# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DeveloperConnect
      module V1
        module DeveloperConnect
          # Path helper methods for the DeveloperConnect API.
          module Paths
            ##
            # Create a fully-qualified AccountConnector resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/accountConnectors/{account_connector}`
            #
            # @param project [String]
            # @param location [String]
            # @param account_connector [String]
            #
            # @return [::String]
            def account_connector_path project:, location:, account_connector:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/accountConnectors/#{account_connector}"
            end

            ##
            # Create a fully-qualified Connection resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/connections/{connection}`
            #
            # @param project [String]
            # @param location [String]
            # @param connection [String]
            #
            # @return [::String]
            def connection_path project:, location:, connection:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/connections/#{connection}"
            end

            ##
            # Create a fully-qualified CryptoKey resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypto_key}`
            #
            # @param project [String]
            # @param location [String]
            # @param key_ring [String]
            # @param crypto_key [String]
            #
            # @return [::String]
            def crypto_key_path project:, location:, key_ring:, crypto_key:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "key_ring cannot contain /" if key_ring.to_s.include? "/"

              "projects/#{project}/locations/#{location}/keyRings/#{key_ring}/cryptoKeys/#{crypto_key}"
            end

            ##
            # Create a fully-qualified GitRepositoryLink resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/connections/{connection}/gitRepositoryLinks/{git_repository_link}`
            #
            # @param project [String]
            # @param location [String]
            # @param connection [String]
            # @param git_repository_link [String]
            #
            # @return [::String]
            def git_repository_link_path project:, location:, connection:, git_repository_link:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "connection cannot contain /" if connection.to_s.include? "/"

              "projects/#{project}/locations/#{location}/connections/#{connection}/gitRepositoryLinks/#{git_repository_link}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified SecretVersion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/secrets/{secret}/versions/{secret_version}`
            #
            # @param project [String]
            # @param secret [String]
            # @param secret_version [String]
            #
            # @return [::String]
            def secret_version_path project:, secret:, secret_version:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "secret cannot contain /" if secret.to_s.include? "/"

              "projects/#{project}/secrets/#{secret}/versions/#{secret_version}"
            end

            ##
            # Create a fully-qualified Service resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/namespaces/{namespace}/services/{service}`
            #
            # @param project [String]
            # @param location [String]
            # @param namespace [String]
            # @param service [String]
            #
            # @return [::String]
            def service_path project:, location:, namespace:, service:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "namespace cannot contain /" if namespace.to_s.include? "/"

              "projects/#{project}/locations/#{location}/namespaces/#{namespace}/services/#{service}"
            end

            ##
            # Create a fully-qualified User resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/accountConnectors/{account_connector}/users/{user}`
            #
            # @param project [String]
            # @param location [String]
            # @param account_connector [String]
            # @param user [String]
            #
            # @return [::String]
            def user_path project:, location:, account_connector:, user:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "account_connector cannot contain /" if account_connector.to_s.include? "/"

              "projects/#{project}/locations/#{location}/accountConnectors/#{account_connector}/users/#{user}"
            end

            extend self
          end
        end
      end
    end
  end
end
