# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/developerconnect/v1/developer_connect_pb"
require "google/cloud/location"

module Google
  module Cloud
    module DeveloperConnect
      module V1
        module DeveloperConnect
          ##
          # Client for the DeveloperConnect service.
          #
          # Service describing handlers for resources
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "developerconnect.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :developer_connect_stub

            ##
            # Configure the DeveloperConnect Client class.
            #
            # See {::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all DeveloperConnect clients
            #   ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "DeveloperConnect", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.list_connections.timeout = 60.0
                default_config.rpcs.list_connections.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_connection.timeout = 60.0
                default_config.rpcs.get_connection.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_connection.timeout = 60.0
                default_config.rpcs.create_connection.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.update_connection.timeout = 60.0
                default_config.rpcs.update_connection.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_connection.timeout = 60.0
                default_config.rpcs.delete_connection.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_git_repository_link.timeout = 60.0
                default_config.rpcs.create_git_repository_link.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.delete_git_repository_link.timeout = 60.0
                default_config.rpcs.delete_git_repository_link.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.get_git_repository_link.timeout = 60.0
                default_config.rpcs.get_git_repository_link.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.fetch_read_write_token.timeout = 60.0
                default_config.rpcs.fetch_read_write_token.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.fetch_read_token.timeout = 60.0
                default_config.rpcs.fetch_read_token.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.fetch_linkable_git_repositories.timeout = 60.0
                default_config.rpcs.fetch_linkable_git_repositories.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.fetch_git_hub_installations.timeout = 60.0
                default_config.rpcs.fetch_git_hub_installations.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the DeveloperConnect Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @developer_connect_stub.universe_domain
            end

            ##
            # Create a new DeveloperConnect client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the DeveloperConnect client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/developerconnect/v1/developer_connect_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @operations_client = Operations.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @config.endpoint
                config.universe_domain = @config.universe_domain
              end

              @developer_connect_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @developer_connect_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @developer_connect_stub.endpoint
                config.universe_domain = @developer_connect_stub.universe_domain
                config.logger = @developer_connect_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for long-running operations.
            #
            # @return [::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Operations]
            #
            attr_reader :operations_client

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @developer_connect_stub.logger
            end

            # Service calls

            ##
            # Lists Connections in a given project and location.
            #
            # @overload list_connections(request, options = nil)
            #   Pass arguments to `list_connections` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::ListConnectionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::ListConnectionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_connections(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_connections` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value for ListConnectionsRequest
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DeveloperConnect::V1::Connection>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DeveloperConnect::V1::Connection>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::ListConnectionsRequest.new
            #
            #   # Call the list_connections method.
            #   result = client.list_connections request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DeveloperConnect::V1::Connection.
            #     p item
            #   end
            #
            def list_connections request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::ListConnectionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_connections.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_connections.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_connections.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :list_connections, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @developer_connect_stub, :list_connections, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single Connection.
            #
            # @overload get_connection(request, options = nil)
            #   Pass arguments to `get_connection` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::GetConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::GetConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_connection(name: nil)
            #   Pass arguments to `get_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DeveloperConnect::V1::Connection]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DeveloperConnect::V1::Connection]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::GetConnectionRequest.new
            #
            #   # Call the get_connection method.
            #   result = client.get_connection request
            #
            #   # The returned object is of type Google::Cloud::DeveloperConnect::V1::Connection.
            #   p result
            #
            def get_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::GetConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :get_connection, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new Connection in a given project and location.
            #
            # @overload create_connection(request, options = nil)
            #   Pass arguments to `create_connection` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::CreateConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::CreateConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_connection(parent: nil, connection_id: nil, connection: nil, request_id: nil, validate_only: nil)
            #   Pass arguments to `create_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Value for parent.
            #   @param connection_id [::String]
            #     Required. Id of the requesting object
            #     If auto-generating Id server-side, remove this field and
            #     connection_id from the method_signature of Create RPC
            #   @param connection [::Google::Cloud::DeveloperConnect::V1::Connection, ::Hash]
            #     Required. The resource being created
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request, but do not actually post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::CreateConnectionRequest.new
            #
            #   # Call the create_connection method.
            #   result = client.create_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::CreateConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :create_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single Connection.
            #
            # @overload update_connection(request, options = nil)
            #   Pass arguments to `update_connection` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::UpdateConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::UpdateConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_connection(update_mask: nil, connection: nil, request_id: nil, allow_missing: nil, validate_only: nil)
            #   Pass arguments to `update_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Required. Field mask is used to specify the fields to be overwritten in the
            #     Connection resource by the update.
            #     The fields specified in the update_mask are relative to the resource, not
            #     the full request. A field will be overwritten if it is in the mask. If the
            #     user does not provide a mask then all fields will be overwritten.
            #   @param connection [::Google::Cloud::DeveloperConnect::V1::Connection, ::Hash]
            #     Required. The resource being updated
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param allow_missing [::Boolean]
            #     Optional. If set to true, and the connection is not found a new connection
            #     will be created. In this situation `update_mask` is ignored.
            #     The creation will succeed only if the input connection has all the
            #     necessary information (e.g a github_config with both  user_oauth_token and
            #     installation_id properties).
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request, but do not actually post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::UpdateConnectionRequest.new
            #
            #   # Call the update_connection method.
            #   result = client.update_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::UpdateConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.connection&.name
                header_params["connection.name"] = request.connection.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :update_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single Connection.
            #
            # @overload delete_connection(request, options = nil)
            #   Pass arguments to `delete_connection` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::DeleteConnectionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::DeleteConnectionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_connection(name: nil, request_id: nil, validate_only: nil, etag: nil)
            #   Pass arguments to `delete_connection` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request, but do not actually post it.
            #   @param etag [::String]
            #     Optional. The current etag of the Connection.
            #     If an etag is provided and does not match the current etag of the
            #     Connection, deletion will be blocked and an ABORTED error will be returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::DeleteConnectionRequest.new
            #
            #   # Call the delete_connection method.
            #   result = client.delete_connection request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_connection request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::DeleteConnectionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_connection.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_connection.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_connection.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :delete_connection, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a GitRepositoryLink. Upon linking a Git Repository, Developer
            # Connect will configure the Git Repository to send webhook events to
            # Developer Connect. Connections that use Firebase GitHub Application will
            # have events forwarded to the Firebase service. All other Connections will
            # have events forwarded to Cloud Build.
            #
            # @overload create_git_repository_link(request, options = nil)
            #   Pass arguments to `create_git_repository_link` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::CreateGitRepositoryLinkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::CreateGitRepositoryLinkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_git_repository_link(parent: nil, git_repository_link: nil, git_repository_link_id: nil, request_id: nil, validate_only: nil)
            #   Pass arguments to `create_git_repository_link` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Value for parent.
            #   @param git_repository_link [::Google::Cloud::DeveloperConnect::V1::GitRepositoryLink, ::Hash]
            #     Required. The resource being created
            #   @param git_repository_link_id [::String]
            #     Required. The ID to use for the repository, which will become the final
            #     component of the repository's resource name. This ID should be unique in
            #     the connection. Allows alphanumeric characters and any of
            #     -._~%!$&'()*+,;=@.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request, but do not actually post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::CreateGitRepositoryLinkRequest.new
            #
            #   # Call the create_git_repository_link method.
            #   result = client.create_git_repository_link request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_git_repository_link request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::CreateGitRepositoryLinkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_git_repository_link.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_git_repository_link.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_git_repository_link.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :create_git_repository_link, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single GitRepositoryLink.
            #
            # @overload delete_git_repository_link(request, options = nil)
            #   Pass arguments to `delete_git_repository_link` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::DeleteGitRepositoryLinkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::DeleteGitRepositoryLinkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_git_repository_link(name: nil, request_id: nil, validate_only: nil, etag: nil)
            #   Pass arguments to `delete_git_repository_link` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request, but do not actually post it.
            #   @param etag [::String]
            #     Optional. This checksum is computed by the server based on the value of
            #     other fields, and may be sent on update and delete requests to ensure the
            #     client has an up-to-date value before proceeding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::DeleteGitRepositoryLinkRequest.new
            #
            #   # Call the delete_git_repository_link method.
            #   result = client.delete_git_repository_link request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_git_repository_link request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::DeleteGitRepositoryLinkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_git_repository_link.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_git_repository_link.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_git_repository_link.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :delete_git_repository_link, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists GitRepositoryLinks in a given project, location, and connection.
            #
            # @overload list_git_repository_links(request, options = nil)
            #   Pass arguments to `list_git_repository_links` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::ListGitRepositoryLinksRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::ListGitRepositoryLinksRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_git_repository_links(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_git_repository_links` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value for ListGitRepositoryLinksRequest
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DeveloperConnect::V1::GitRepositoryLink>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DeveloperConnect::V1::GitRepositoryLink>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::ListGitRepositoryLinksRequest.new
            #
            #   # Call the list_git_repository_links method.
            #   result = client.list_git_repository_links request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DeveloperConnect::V1::GitRepositoryLink.
            #     p item
            #   end
            #
            def list_git_repository_links request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::ListGitRepositoryLinksRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_git_repository_links.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_git_repository_links.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_git_repository_links.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :list_git_repository_links, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @developer_connect_stub, :list_git_repository_links, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single GitRepositoryLink.
            #
            # @overload get_git_repository_link(request, options = nil)
            #   Pass arguments to `get_git_repository_link` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::GetGitRepositoryLinkRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::GetGitRepositoryLinkRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_git_repository_link(name: nil)
            #   Pass arguments to `get_git_repository_link` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DeveloperConnect::V1::GitRepositoryLink]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DeveloperConnect::V1::GitRepositoryLink]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::GetGitRepositoryLinkRequest.new
            #
            #   # Call the get_git_repository_link method.
            #   result = client.get_git_repository_link request
            #
            #   # The returned object is of type Google::Cloud::DeveloperConnect::V1::GitRepositoryLink.
            #   p result
            #
            def get_git_repository_link request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::GetGitRepositoryLinkRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_git_repository_link.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_git_repository_link.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_git_repository_link.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :get_git_repository_link, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches read/write token of a given gitRepositoryLink.
            #
            # @overload fetch_read_write_token(request, options = nil)
            #   Pass arguments to `fetch_read_write_token` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::FetchReadWriteTokenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::FetchReadWriteTokenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_read_write_token(git_repository_link: nil)
            #   Pass arguments to `fetch_read_write_token` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param git_repository_link [::String]
            #     Required. The resource name of the gitRepositoryLink in the format
            #     `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DeveloperConnect::V1::FetchReadWriteTokenResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DeveloperConnect::V1::FetchReadWriteTokenResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::FetchReadWriteTokenRequest.new
            #
            #   # Call the fetch_read_write_token method.
            #   result = client.fetch_read_write_token request
            #
            #   # The returned object is of type Google::Cloud::DeveloperConnect::V1::FetchReadWriteTokenResponse.
            #   p result
            #
            def fetch_read_write_token request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::FetchReadWriteTokenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_read_write_token.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.git_repository_link
                header_params["git_repository_link"] = request.git_repository_link
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_read_write_token.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_read_write_token.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :fetch_read_write_token, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches read token of a given gitRepositoryLink.
            #
            # @overload fetch_read_token(request, options = nil)
            #   Pass arguments to `fetch_read_token` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::FetchReadTokenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::FetchReadTokenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_read_token(git_repository_link: nil)
            #   Pass arguments to `fetch_read_token` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param git_repository_link [::String]
            #     Required. The resource name of the gitRepositoryLink in the format
            #     `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DeveloperConnect::V1::FetchReadTokenResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DeveloperConnect::V1::FetchReadTokenResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::FetchReadTokenRequest.new
            #
            #   # Call the fetch_read_token method.
            #   result = client.fetch_read_token request
            #
            #   # The returned object is of type Google::Cloud::DeveloperConnect::V1::FetchReadTokenResponse.
            #   p result
            #
            def fetch_read_token request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::FetchReadTokenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_read_token.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.git_repository_link
                header_params["git_repository_link"] = request.git_repository_link
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_read_token.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_read_token.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :fetch_read_token, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # FetchLinkableGitRepositories returns a list of git repositories from an SCM
            # that are available to be added to a Connection.
            #
            # @overload fetch_linkable_git_repositories(request, options = nil)
            #   Pass arguments to `fetch_linkable_git_repositories` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::FetchLinkableGitRepositoriesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::FetchLinkableGitRepositoriesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_linkable_git_repositories(connection: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `fetch_linkable_git_repositories` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param connection [::String]
            #     Required. The name of the Connection.
            #     Format: `projects/*/locations/*/connections/*`.
            #   @param page_size [::Integer]
            #     Optional. Number of results to return in the list. Defaults to 20.
            #   @param page_token [::String]
            #     Optional. Page start.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DeveloperConnect::V1::LinkableGitRepository>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DeveloperConnect::V1::LinkableGitRepository>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::FetchLinkableGitRepositoriesRequest.new
            #
            #   # Call the fetch_linkable_git_repositories method.
            #   result = client.fetch_linkable_git_repositories request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DeveloperConnect::V1::LinkableGitRepository.
            #     p item
            #   end
            #
            def fetch_linkable_git_repositories request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::FetchLinkableGitRepositoriesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_linkable_git_repositories.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.connection
                header_params["connection"] = request.connection
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_linkable_git_repositories.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_linkable_git_repositories.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :fetch_linkable_git_repositories, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @developer_connect_stub, :fetch_linkable_git_repositories, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # FetchGitHubInstallations returns the list of GitHub Installations that
            # are available to be added to a Connection.
            # For github.com, only installations accessible to the authorizer token
            # are returned. For GitHub Enterprise, all installations are returned.
            #
            # @overload fetch_git_hub_installations(request, options = nil)
            #   Pass arguments to `fetch_git_hub_installations` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_git_hub_installations(connection: nil)
            #   Pass arguments to `fetch_git_hub_installations` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param connection [::String]
            #     Required. The resource name of the connection in the format
            #     `projects/*/locations/*/connections/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsRequest.new
            #
            #   # Call the fetch_git_hub_installations method.
            #   result = client.fetch_git_hub_installations request
            #
            #   # The returned object is of type Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsResponse.
            #   p result
            #
            def fetch_git_hub_installations request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::FetchGitHubInstallationsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_git_hub_installations.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.connection
                header_params["connection"] = request.connection
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_git_hub_installations.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_git_hub_installations.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :fetch_git_hub_installations, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetch the list of branches or tags for a given repository.
            #
            # @overload fetch_git_refs(request, options = nil)
            #   Pass arguments to `fetch_git_refs` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::FetchGitRefsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::FetchGitRefsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_git_refs(git_repository_link: nil, ref_type: nil, page_size: nil, page_token: nil)
            #   Pass arguments to `fetch_git_refs` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param git_repository_link [::String]
            #     Required. The resource name of GitRepositoryLink in the format
            #     `projects/*/locations/*/connections/*/gitRepositoryLinks/*`.
            #   @param ref_type [::Google::Cloud::DeveloperConnect::V1::FetchGitRefsRequest::RefType]
            #     Required. Type of refs to fetch.
            #   @param page_size [::Integer]
            #     Optional. Number of results to return in the list. Default to 20.
            #   @param page_token [::String]
            #     Optional. Page start.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DeveloperConnect::V1::FetchGitRefsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DeveloperConnect::V1::FetchGitRefsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::FetchGitRefsRequest.new
            #
            #   # Call the fetch_git_refs method.
            #   result = client.fetch_git_refs request
            #
            #   # The returned object is of type Google::Cloud::DeveloperConnect::V1::FetchGitRefsResponse.
            #   p result
            #
            def fetch_git_refs request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::FetchGitRefsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_git_refs.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.git_repository_link
                header_params["git_repository_link"] = request.git_repository_link
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_git_refs.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_git_refs.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :fetch_git_refs, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists AccountConnectors in a given project and location.
            #
            # @overload list_account_connectors(request, options = nil)
            #   Pass arguments to `list_account_connectors` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::ListAccountConnectorsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::ListAccountConnectorsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_account_connectors(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_account_connectors` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value for ListAccountConnectorsRequest
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DeveloperConnect::V1::AccountConnector>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DeveloperConnect::V1::AccountConnector>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::ListAccountConnectorsRequest.new
            #
            #   # Call the list_account_connectors method.
            #   result = client.list_account_connectors request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DeveloperConnect::V1::AccountConnector.
            #     p item
            #   end
            #
            def list_account_connectors request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::ListAccountConnectorsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_account_connectors.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_account_connectors.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_account_connectors.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :list_account_connectors, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @developer_connect_stub, :list_account_connectors, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Gets details of a single AccountConnector.
            #
            # @overload get_account_connector(request, options = nil)
            #   Pass arguments to `get_account_connector` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::GetAccountConnectorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::GetAccountConnectorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_account_connector(name: nil)
            #   Pass arguments to `get_account_connector` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DeveloperConnect::V1::AccountConnector]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DeveloperConnect::V1::AccountConnector]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::GetAccountConnectorRequest.new
            #
            #   # Call the get_account_connector method.
            #   result = client.get_account_connector request
            #
            #   # The returned object is of type Google::Cloud::DeveloperConnect::V1::AccountConnector.
            #   p result
            #
            def get_account_connector request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::GetAccountConnectorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_account_connector.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_account_connector.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_account_connector.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :get_account_connector, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Creates a new AccountConnector in a given project and location.
            #
            # @overload create_account_connector(request, options = nil)
            #   Pass arguments to `create_account_connector` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::CreateAccountConnectorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::CreateAccountConnectorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_account_connector(parent: nil, account_connector_id: nil, account_connector: nil, request_id: nil, validate_only: nil)
            #   Pass arguments to `create_account_connector` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Location resource name as the account_connector’s parent.
            #   @param account_connector_id [::String]
            #     Required. The ID to use for the AccountConnector, which will become the
            #     final component of the AccountConnector's resource name. Its format should
            #     adhere to https://google.aip.dev/122#resource-id-segments Names must be
            #     unique per-project per-location.
            #   @param account_connector [::Google::Cloud::DeveloperConnect::V1::AccountConnector, ::Hash]
            #     Required. The AccountConnector to create.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request, but do not actually post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::CreateAccountConnectorRequest.new
            #
            #   # Call the create_account_connector method.
            #   result = client.create_account_connector request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def create_account_connector request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::CreateAccountConnectorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_account_connector.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_account_connector.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_account_connector.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :create_account_connector, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Updates the parameters of a single AccountConnector.
            #
            # @overload update_account_connector(request, options = nil)
            #   Pass arguments to `update_account_connector` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::UpdateAccountConnectorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::UpdateAccountConnectorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_account_connector(update_mask: nil, account_connector: nil, request_id: nil, allow_missing: nil, validate_only: nil)
            #   Pass arguments to `update_account_connector` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
            #     Optional. The list of fields to be updated.
            #   @param account_connector [::Google::Cloud::DeveloperConnect::V1::AccountConnector, ::Hash]
            #     Required. The AccountConnector to update.
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes since the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param allow_missing [::Boolean]
            #     Optional. If set to true, and the accountConnector is not found a new
            #     accountConnector will be created. In this situation `update_mask` is
            #     ignored. The creation will succeed only if the input accountConnector has
            #     all the necessary
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request, but do not actually post it.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::UpdateAccountConnectorRequest.new
            #
            #   # Call the update_account_connector method.
            #   result = client.update_account_connector request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def update_account_connector request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::UpdateAccountConnectorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_account_connector.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.account_connector&.name
                header_params["account_connector.name"] = request.account_connector.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_account_connector.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_account_connector.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :update_account_connector, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single AccountConnector.
            #
            # @overload delete_account_connector(request, options = nil)
            #   Pass arguments to `delete_account_connector` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::DeleteAccountConnectorRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::DeleteAccountConnectorRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_account_connector(name: nil, request_id: nil, validate_only: nil, etag: nil, force: nil)
            #   Pass arguments to `delete_account_connector` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request, but do not actually post it.
            #   @param etag [::String]
            #     Optional. The current etag of the AccountConnectorn.
            #     If an etag is provided and does not match the current etag of the
            #     AccountConnector, deletion will be blocked and an ABORTED error will be
            #     returned.
            #   @param force [::Boolean]
            #     Optional. If set to true, any Users from this AccountConnector will also
            #     be deleted. (Otherwise, the request will only work if the AccountConnector
            #     has no Users.)
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::DeleteAccountConnectorRequest.new
            #
            #   # Call the delete_account_connector method.
            #   result = client.delete_account_connector request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_account_connector request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::DeleteAccountConnectorRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_account_connector.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_account_connector.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_account_connector.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :delete_account_connector, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetches OAuth access token based on end user credentials.
            #
            # @overload fetch_access_token(request, options = nil)
            #   Pass arguments to `fetch_access_token` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::FetchAccessTokenRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::FetchAccessTokenRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_access_token(account_connector: nil)
            #   Pass arguments to `fetch_access_token` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param account_connector [::String]
            #     Required. The resource name of the AccountConnector in the format
            #     `projects/*/locations/*/accountConnectors/*`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DeveloperConnect::V1::FetchAccessTokenResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DeveloperConnect::V1::FetchAccessTokenResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::FetchAccessTokenRequest.new
            #
            #   # Call the fetch_access_token method.
            #   result = client.fetch_access_token request
            #
            #   # The returned object is of type Google::Cloud::DeveloperConnect::V1::FetchAccessTokenResponse.
            #   p result
            #
            def fetch_access_token request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::FetchAccessTokenRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_access_token.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.account_connector
                header_params["account_connector"] = request.account_connector
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_access_token.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_access_token.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :fetch_access_token, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Lists Users in a given project, location, and account_connector.
            #
            # @overload list_users(request, options = nil)
            #   Pass arguments to `list_users` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::ListUsersRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::ListUsersRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_users(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
            #   Pass arguments to `list_users` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. Parent value for ListUsersRequest
            #   @param page_size [::Integer]
            #     Optional. Requested page size. Server may return fewer items than
            #     requested. If unspecified, server will pick an appropriate default.
            #   @param page_token [::String]
            #     Optional. A token identifying a page of results the server should return.
            #   @param filter [::String]
            #     Optional. Filtering results
            #   @param order_by [::String]
            #     Optional. Hint for how to order the results
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::DeveloperConnect::V1::User>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::DeveloperConnect::V1::User>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::ListUsersRequest.new
            #
            #   # Call the list_users method.
            #   result = client.list_users request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::DeveloperConnect::V1::User.
            #     p item
            #   end
            #
            def list_users request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::ListUsersRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_users.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_users.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_users.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :list_users, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @developer_connect_stub, :list_users, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Deletes a single User.
            #
            # @overload delete_user(request, options = nil)
            #   Pass arguments to `delete_user` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::DeleteUserRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::DeleteUserRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_user(name: nil, request_id: nil, validate_only: nil, etag: nil)
            #   Pass arguments to `delete_user` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the resource
            #   @param request_id [::String]
            #     Optional. An optional request ID to identify requests. Specify a unique
            #     request ID so that if you must retry your request, the server will know to
            #     ignore the request if it has already been completed. The server will
            #     guarantee that for at least 60 minutes after the first request.
            #
            #     For example, consider a situation where you make an initial request and the
            #     request times out. If you make the request again with the same request
            #     ID, the server can check if original operation with the same request ID
            #     was received, and if so, will ignore the second request. This prevents
            #     clients from accidentally creating duplicate commitments.
            #
            #     The request ID must be a valid UUID with the exception that zero UUID is
            #     not supported (00000000-0000-0000-0000-000000000000).
            #   @param validate_only [::Boolean]
            #     Optional. If set, validate the request, but do not actually post it.
            #   @param etag [::String]
            #     Optional. This checksum is computed by the server based on the value of
            #     other fields, and may be sent on update and delete requests to ensure the
            #     client has an up-to-date value before proceeding.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::DeleteUserRequest.new
            #
            #   # Call the delete_user method.
            #   result = client.delete_user request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_user request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::DeleteUserRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_user.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_user.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_user.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :delete_user, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Fetch the User based on the user credentials.
            #
            # @overload fetch_self(request, options = nil)
            #   Pass arguments to `fetch_self` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::FetchSelfRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::FetchSelfRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload fetch_self(name: nil)
            #   Pass arguments to `fetch_self` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the AccountConnector resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::DeveloperConnect::V1::User]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::DeveloperConnect::V1::User]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::FetchSelfRequest.new
            #
            #   # Call the fetch_self method.
            #   result = client.fetch_self request
            #
            #   # The returned object is of type Google::Cloud::DeveloperConnect::V1::User.
            #   p result
            #
            def fetch_self request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::FetchSelfRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.fetch_self.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.fetch_self.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.fetch_self.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :fetch_self, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete the User based on the user credentials.
            #
            # @overload delete_self(request, options = nil)
            #   Pass arguments to `delete_self` via a request object, either of type
            #   {::Google::Cloud::DeveloperConnect::V1::DeleteSelfRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::DeveloperConnect::V1::DeleteSelfRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_self(name: nil)
            #   Pass arguments to `delete_self` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. Name of the AccountConnector resource
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::Operation]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::Operation]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/developer_connect/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::DeveloperConnect::V1::DeleteSelfRequest.new
            #
            #   # Call the delete_self method.
            #   result = client.delete_self request
            #
            #   # The returned object is of type Gapic::Operation. You can use it to
            #   # check the status of an operation, cancel it, or wait for results.
            #   # Here is how to wait for a response.
            #   result.wait_until_done! timeout: 60
            #   if result.response?
            #     p result.response
            #   else
            #     puts "No response received."
            #   end
            #
            def delete_self request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::DeveloperConnect::V1::DeleteSelfRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_self.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::DeveloperConnect::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_self.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_self.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @developer_connect_stub.call_rpc :delete_self, request, options: options do |response, operation|
                response = ::Gapic::Operation.new response, @operations_client, options: options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the DeveloperConnect API.
            #
            # This class represents the configuration for DeveloperConnect,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # list_connections to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_connections.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.list_connections.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::DeveloperConnect::V1::DeveloperConnect::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "developerconnect.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the DeveloperConnect API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `list_connections`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_connections
                ##
                # RPC-specific configuration for `get_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_connection
                ##
                # RPC-specific configuration for `create_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_connection
                ##
                # RPC-specific configuration for `update_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_connection
                ##
                # RPC-specific configuration for `delete_connection`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_connection
                ##
                # RPC-specific configuration for `create_git_repository_link`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_git_repository_link
                ##
                # RPC-specific configuration for `delete_git_repository_link`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_git_repository_link
                ##
                # RPC-specific configuration for `list_git_repository_links`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_git_repository_links
                ##
                # RPC-specific configuration for `get_git_repository_link`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_git_repository_link
                ##
                # RPC-specific configuration for `fetch_read_write_token`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_read_write_token
                ##
                # RPC-specific configuration for `fetch_read_token`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_read_token
                ##
                # RPC-specific configuration for `fetch_linkable_git_repositories`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_linkable_git_repositories
                ##
                # RPC-specific configuration for `fetch_git_hub_installations`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_git_hub_installations
                ##
                # RPC-specific configuration for `fetch_git_refs`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_git_refs
                ##
                # RPC-specific configuration for `list_account_connectors`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_account_connectors
                ##
                # RPC-specific configuration for `get_account_connector`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_account_connector
                ##
                # RPC-specific configuration for `create_account_connector`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_account_connector
                ##
                # RPC-specific configuration for `update_account_connector`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_account_connector
                ##
                # RPC-specific configuration for `delete_account_connector`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_account_connector
                ##
                # RPC-specific configuration for `fetch_access_token`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_access_token
                ##
                # RPC-specific configuration for `list_users`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_users
                ##
                # RPC-specific configuration for `delete_user`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_user
                ##
                # RPC-specific configuration for `fetch_self`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :fetch_self
                ##
                # RPC-specific configuration for `delete_self`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_self

                # @private
                def initialize parent_rpcs = nil
                  list_connections_config = parent_rpcs.list_connections if parent_rpcs.respond_to? :list_connections
                  @list_connections = ::Gapic::Config::Method.new list_connections_config
                  get_connection_config = parent_rpcs.get_connection if parent_rpcs.respond_to? :get_connection
                  @get_connection = ::Gapic::Config::Method.new get_connection_config
                  create_connection_config = parent_rpcs.create_connection if parent_rpcs.respond_to? :create_connection
                  @create_connection = ::Gapic::Config::Method.new create_connection_config
                  update_connection_config = parent_rpcs.update_connection if parent_rpcs.respond_to? :update_connection
                  @update_connection = ::Gapic::Config::Method.new update_connection_config
                  delete_connection_config = parent_rpcs.delete_connection if parent_rpcs.respond_to? :delete_connection
                  @delete_connection = ::Gapic::Config::Method.new delete_connection_config
                  create_git_repository_link_config = parent_rpcs.create_git_repository_link if parent_rpcs.respond_to? :create_git_repository_link
                  @create_git_repository_link = ::Gapic::Config::Method.new create_git_repository_link_config
                  delete_git_repository_link_config = parent_rpcs.delete_git_repository_link if parent_rpcs.respond_to? :delete_git_repository_link
                  @delete_git_repository_link = ::Gapic::Config::Method.new delete_git_repository_link_config
                  list_git_repository_links_config = parent_rpcs.list_git_repository_links if parent_rpcs.respond_to? :list_git_repository_links
                  @list_git_repository_links = ::Gapic::Config::Method.new list_git_repository_links_config
                  get_git_repository_link_config = parent_rpcs.get_git_repository_link if parent_rpcs.respond_to? :get_git_repository_link
                  @get_git_repository_link = ::Gapic::Config::Method.new get_git_repository_link_config
                  fetch_read_write_token_config = parent_rpcs.fetch_read_write_token if parent_rpcs.respond_to? :fetch_read_write_token
                  @fetch_read_write_token = ::Gapic::Config::Method.new fetch_read_write_token_config
                  fetch_read_token_config = parent_rpcs.fetch_read_token if parent_rpcs.respond_to? :fetch_read_token
                  @fetch_read_token = ::Gapic::Config::Method.new fetch_read_token_config
                  fetch_linkable_git_repositories_config = parent_rpcs.fetch_linkable_git_repositories if parent_rpcs.respond_to? :fetch_linkable_git_repositories
                  @fetch_linkable_git_repositories = ::Gapic::Config::Method.new fetch_linkable_git_repositories_config
                  fetch_git_hub_installations_config = parent_rpcs.fetch_git_hub_installations if parent_rpcs.respond_to? :fetch_git_hub_installations
                  @fetch_git_hub_installations = ::Gapic::Config::Method.new fetch_git_hub_installations_config
                  fetch_git_refs_config = parent_rpcs.fetch_git_refs if parent_rpcs.respond_to? :fetch_git_refs
                  @fetch_git_refs = ::Gapic::Config::Method.new fetch_git_refs_config
                  list_account_connectors_config = parent_rpcs.list_account_connectors if parent_rpcs.respond_to? :list_account_connectors
                  @list_account_connectors = ::Gapic::Config::Method.new list_account_connectors_config
                  get_account_connector_config = parent_rpcs.get_account_connector if parent_rpcs.respond_to? :get_account_connector
                  @get_account_connector = ::Gapic::Config::Method.new get_account_connector_config
                  create_account_connector_config = parent_rpcs.create_account_connector if parent_rpcs.respond_to? :create_account_connector
                  @create_account_connector = ::Gapic::Config::Method.new create_account_connector_config
                  update_account_connector_config = parent_rpcs.update_account_connector if parent_rpcs.respond_to? :update_account_connector
                  @update_account_connector = ::Gapic::Config::Method.new update_account_connector_config
                  delete_account_connector_config = parent_rpcs.delete_account_connector if parent_rpcs.respond_to? :delete_account_connector
                  @delete_account_connector = ::Gapic::Config::Method.new delete_account_connector_config
                  fetch_access_token_config = parent_rpcs.fetch_access_token if parent_rpcs.respond_to? :fetch_access_token
                  @fetch_access_token = ::Gapic::Config::Method.new fetch_access_token_config
                  list_users_config = parent_rpcs.list_users if parent_rpcs.respond_to? :list_users
                  @list_users = ::Gapic::Config::Method.new list_users_config
                  delete_user_config = parent_rpcs.delete_user if parent_rpcs.respond_to? :delete_user
                  @delete_user = ::Gapic::Config::Method.new delete_user_config
                  fetch_self_config = parent_rpcs.fetch_self if parent_rpcs.respond_to? :fetch_self
                  @fetch_self = ::Gapic::Config::Method.new fetch_self_config
                  delete_self_config = parent_rpcs.delete_self if parent_rpcs.respond_to? :delete_self
                  @delete_self = ::Gapic::Config::Method.new delete_self_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
