# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/deploy/v1/cloud_deploy_pb"
require "google/cloud/deploy/v1/cloud_deploy"

class ::Google::Cloud::Deploy::V1::CloudDeploy::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_delivery_pipelines
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::ListDeliveryPipelinesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_delivery_pipelines_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_delivery_pipelines, name
      assert_kind_of ::Google::Cloud::Deploy::V1::ListDeliveryPipelinesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_delivery_pipelines_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_delivery_pipelines({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_delivery_pipelines parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_delivery_pipelines ::Google::Cloud::Deploy::V1::ListDeliveryPipelinesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_delivery_pipelines({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_delivery_pipelines(::Google::Cloud::Deploy::V1::ListDeliveryPipelinesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_delivery_pipelines_client_stub.call_rpc_count
    end
  end

  def test_get_delivery_pipeline
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::DeliveryPipeline.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_delivery_pipeline_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_delivery_pipeline, name
      assert_kind_of ::Google::Cloud::Deploy::V1::GetDeliveryPipelineRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_delivery_pipeline_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_delivery_pipeline({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_delivery_pipeline name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_delivery_pipeline ::Google::Cloud::Deploy::V1::GetDeliveryPipelineRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_delivery_pipeline({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_delivery_pipeline(::Google::Cloud::Deploy::V1::GetDeliveryPipelineRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_delivery_pipeline_client_stub.call_rpc_count
    end
  end

  def test_create_delivery_pipeline
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    delivery_pipeline_id = "hello world"
    delivery_pipeline = {}
    request_id = "hello world"
    validate_only = true

    create_delivery_pipeline_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_delivery_pipeline, name
      assert_kind_of ::Google::Cloud::Deploy::V1::CreateDeliveryPipelineRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["delivery_pipeline_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Deploy::V1::DeliveryPipeline), request["delivery_pipeline"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_delivery_pipeline_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_delivery_pipeline({ parent: parent, delivery_pipeline_id: delivery_pipeline_id, delivery_pipeline: delivery_pipeline, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_delivery_pipeline parent: parent, delivery_pipeline_id: delivery_pipeline_id, delivery_pipeline: delivery_pipeline, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_delivery_pipeline ::Google::Cloud::Deploy::V1::CreateDeliveryPipelineRequest.new(parent: parent, delivery_pipeline_id: delivery_pipeline_id, delivery_pipeline: delivery_pipeline, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_delivery_pipeline({ parent: parent, delivery_pipeline_id: delivery_pipeline_id, delivery_pipeline: delivery_pipeline, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_delivery_pipeline(::Google::Cloud::Deploy::V1::CreateDeliveryPipelineRequest.new(parent: parent, delivery_pipeline_id: delivery_pipeline_id, delivery_pipeline: delivery_pipeline, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_delivery_pipeline_client_stub.call_rpc_count
    end
  end

  def test_update_delivery_pipeline
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    delivery_pipeline = {}
    request_id = "hello world"
    allow_missing = true
    validate_only = true

    update_delivery_pipeline_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_delivery_pipeline, name
      assert_kind_of ::Google::Cloud::Deploy::V1::UpdateDeliveryPipelineRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Deploy::V1::DeliveryPipeline), request["delivery_pipeline"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_delivery_pipeline_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_delivery_pipeline({ update_mask: update_mask, delivery_pipeline: delivery_pipeline, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_delivery_pipeline update_mask: update_mask, delivery_pipeline: delivery_pipeline, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_delivery_pipeline ::Google::Cloud::Deploy::V1::UpdateDeliveryPipelineRequest.new(update_mask: update_mask, delivery_pipeline: delivery_pipeline, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_delivery_pipeline({ update_mask: update_mask, delivery_pipeline: delivery_pipeline, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_delivery_pipeline(::Google::Cloud::Deploy::V1::UpdateDeliveryPipelineRequest.new(update_mask: update_mask, delivery_pipeline: delivery_pipeline, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_delivery_pipeline_client_stub.call_rpc_count
    end
  end

  def test_delete_delivery_pipeline
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    allow_missing = true
    validate_only = true
    force = true
    etag = "hello world"

    delete_delivery_pipeline_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_delivery_pipeline, name
      assert_kind_of ::Google::Cloud::Deploy::V1::DeleteDeliveryPipelineRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["force"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_delivery_pipeline_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_delivery_pipeline({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, force: force, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_delivery_pipeline name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, force: force, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_delivery_pipeline ::Google::Cloud::Deploy::V1::DeleteDeliveryPipelineRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, force: force, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_delivery_pipeline({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, force: force, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_delivery_pipeline(::Google::Cloud::Deploy::V1::DeleteDeliveryPipelineRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, force: force, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_delivery_pipeline_client_stub.call_rpc_count
    end
  end

  def test_list_targets
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::ListTargetsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_targets_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_targets, name
      assert_kind_of ::Google::Cloud::Deploy::V1::ListTargetsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_targets_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_targets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_targets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_targets ::Google::Cloud::Deploy::V1::ListTargetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_targets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_targets(::Google::Cloud::Deploy::V1::ListTargetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_targets_client_stub.call_rpc_count
    end
  end

  def test_rollback_target
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::RollbackTargetResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    target_id = "hello world"
    rollout_id = "hello world"
    release_id = "hello world"
    rollout_to_roll_back = "hello world"
    rollback_config = {}
    validate_only = true
    override_deploy_policy = ["hello world"]

    rollback_target_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :rollback_target, name
      assert_kind_of ::Google::Cloud::Deploy::V1::RollbackTargetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["target_id"]
      assert_equal "hello world", request["rollout_id"]
      assert_equal "hello world", request["release_id"]
      assert_equal "hello world", request["rollout_to_roll_back"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Deploy::V1::RollbackTargetConfig), request["rollback_config"]
      assert_equal true, request["validate_only"]
      assert_equal ["hello world"], request["override_deploy_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, rollback_target_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.rollback_target({ name: name, target_id: target_id, rollout_id: rollout_id, release_id: release_id, rollout_to_roll_back: rollout_to_roll_back, rollback_config: rollback_config, validate_only: validate_only, override_deploy_policy: override_deploy_policy }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.rollback_target name: name, target_id: target_id, rollout_id: rollout_id, release_id: release_id, rollout_to_roll_back: rollout_to_roll_back, rollback_config: rollback_config, validate_only: validate_only, override_deploy_policy: override_deploy_policy do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.rollback_target ::Google::Cloud::Deploy::V1::RollbackTargetRequest.new(name: name, target_id: target_id, rollout_id: rollout_id, release_id: release_id, rollout_to_roll_back: rollout_to_roll_back, rollback_config: rollback_config, validate_only: validate_only, override_deploy_policy: override_deploy_policy) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.rollback_target({ name: name, target_id: target_id, rollout_id: rollout_id, release_id: release_id, rollout_to_roll_back: rollout_to_roll_back, rollback_config: rollback_config, validate_only: validate_only, override_deploy_policy: override_deploy_policy }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.rollback_target(::Google::Cloud::Deploy::V1::RollbackTargetRequest.new(name: name, target_id: target_id, rollout_id: rollout_id, release_id: release_id, rollout_to_roll_back: rollout_to_roll_back, rollback_config: rollback_config, validate_only: validate_only, override_deploy_policy: override_deploy_policy), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, rollback_target_client_stub.call_rpc_count
    end
  end

  def test_get_target
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::Target.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_target_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_target, name
      assert_kind_of ::Google::Cloud::Deploy::V1::GetTargetRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_target_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_target({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_target name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_target ::Google::Cloud::Deploy::V1::GetTargetRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_target({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_target(::Google::Cloud::Deploy::V1::GetTargetRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_target_client_stub.call_rpc_count
    end
  end

  def test_create_target
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    target_id = "hello world"
    target = {}
    request_id = "hello world"
    validate_only = true

    create_target_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_target, name
      assert_kind_of ::Google::Cloud::Deploy::V1::CreateTargetRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["target_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Deploy::V1::Target), request["target"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_target_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_target({ parent: parent, target_id: target_id, target: target, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_target parent: parent, target_id: target_id, target: target, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_target ::Google::Cloud::Deploy::V1::CreateTargetRequest.new(parent: parent, target_id: target_id, target: target, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_target({ parent: parent, target_id: target_id, target: target, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_target(::Google::Cloud::Deploy::V1::CreateTargetRequest.new(parent: parent, target_id: target_id, target: target, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_target_client_stub.call_rpc_count
    end
  end

  def test_update_target
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    target = {}
    request_id = "hello world"
    allow_missing = true
    validate_only = true

    update_target_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_target, name
      assert_kind_of ::Google::Cloud::Deploy::V1::UpdateTargetRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Deploy::V1::Target), request["target"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_target_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_target({ update_mask: update_mask, target: target, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_target update_mask: update_mask, target: target, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_target ::Google::Cloud::Deploy::V1::UpdateTargetRequest.new(update_mask: update_mask, target: target, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_target({ update_mask: update_mask, target: target, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_target(::Google::Cloud::Deploy::V1::UpdateTargetRequest.new(update_mask: update_mask, target: target, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_target_client_stub.call_rpc_count
    end
  end

  def test_delete_target
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    allow_missing = true
    validate_only = true
    etag = "hello world"

    delete_target_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_target, name
      assert_kind_of ::Google::Cloud::Deploy::V1::DeleteTargetRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_target_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_target({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_target name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_target ::Google::Cloud::Deploy::V1::DeleteTargetRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_target({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_target(::Google::Cloud::Deploy::V1::DeleteTargetRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_target_client_stub.call_rpc_count
    end
  end

  def test_list_custom_target_types
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::ListCustomTargetTypesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_custom_target_types_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_custom_target_types, name
      assert_kind_of ::Google::Cloud::Deploy::V1::ListCustomTargetTypesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_custom_target_types_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_custom_target_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_custom_target_types parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_custom_target_types ::Google::Cloud::Deploy::V1::ListCustomTargetTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_custom_target_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_custom_target_types(::Google::Cloud::Deploy::V1::ListCustomTargetTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_custom_target_types_client_stub.call_rpc_count
    end
  end

  def test_get_custom_target_type
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::CustomTargetType.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_custom_target_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_custom_target_type, name
      assert_kind_of ::Google::Cloud::Deploy::V1::GetCustomTargetTypeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_custom_target_type_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_custom_target_type({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_custom_target_type name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_custom_target_type ::Google::Cloud::Deploy::V1::GetCustomTargetTypeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_custom_target_type({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_custom_target_type(::Google::Cloud::Deploy::V1::GetCustomTargetTypeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_custom_target_type_client_stub.call_rpc_count
    end
  end

  def test_create_custom_target_type
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    custom_target_type_id = "hello world"
    custom_target_type = {}
    request_id = "hello world"
    validate_only = true

    create_custom_target_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_custom_target_type, name
      assert_kind_of ::Google::Cloud::Deploy::V1::CreateCustomTargetTypeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["custom_target_type_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Deploy::V1::CustomTargetType), request["custom_target_type"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_custom_target_type_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_custom_target_type({ parent: parent, custom_target_type_id: custom_target_type_id, custom_target_type: custom_target_type, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_custom_target_type parent: parent, custom_target_type_id: custom_target_type_id, custom_target_type: custom_target_type, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_custom_target_type ::Google::Cloud::Deploy::V1::CreateCustomTargetTypeRequest.new(parent: parent, custom_target_type_id: custom_target_type_id, custom_target_type: custom_target_type, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_custom_target_type({ parent: parent, custom_target_type_id: custom_target_type_id, custom_target_type: custom_target_type, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_custom_target_type(::Google::Cloud::Deploy::V1::CreateCustomTargetTypeRequest.new(parent: parent, custom_target_type_id: custom_target_type_id, custom_target_type: custom_target_type, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_custom_target_type_client_stub.call_rpc_count
    end
  end

  def test_update_custom_target_type
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    custom_target_type = {}
    request_id = "hello world"
    allow_missing = true
    validate_only = true

    update_custom_target_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_custom_target_type, name
      assert_kind_of ::Google::Cloud::Deploy::V1::UpdateCustomTargetTypeRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Deploy::V1::CustomTargetType), request["custom_target_type"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_custom_target_type_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_custom_target_type({ update_mask: update_mask, custom_target_type: custom_target_type, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_custom_target_type update_mask: update_mask, custom_target_type: custom_target_type, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_custom_target_type ::Google::Cloud::Deploy::V1::UpdateCustomTargetTypeRequest.new(update_mask: update_mask, custom_target_type: custom_target_type, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_custom_target_type({ update_mask: update_mask, custom_target_type: custom_target_type, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_custom_target_type(::Google::Cloud::Deploy::V1::UpdateCustomTargetTypeRequest.new(update_mask: update_mask, custom_target_type: custom_target_type, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_custom_target_type_client_stub.call_rpc_count
    end
  end

  def test_delete_custom_target_type
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    allow_missing = true
    validate_only = true
    etag = "hello world"

    delete_custom_target_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_custom_target_type, name
      assert_kind_of ::Google::Cloud::Deploy::V1::DeleteCustomTargetTypeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_custom_target_type_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_custom_target_type({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_custom_target_type name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_custom_target_type ::Google::Cloud::Deploy::V1::DeleteCustomTargetTypeRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_custom_target_type({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_custom_target_type(::Google::Cloud::Deploy::V1::DeleteCustomTargetTypeRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_custom_target_type_client_stub.call_rpc_count
    end
  end

  def test_list_releases
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::ListReleasesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_releases_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_releases, name
      assert_kind_of ::Google::Cloud::Deploy::V1::ListReleasesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_releases_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_releases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_releases parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_releases ::Google::Cloud::Deploy::V1::ListReleasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_releases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_releases(::Google::Cloud::Deploy::V1::ListReleasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_releases_client_stub.call_rpc_count
    end
  end

  def test_get_release
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::Release.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_release_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_release, name
      assert_kind_of ::Google::Cloud::Deploy::V1::GetReleaseRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_release_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_release({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_release name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_release ::Google::Cloud::Deploy::V1::GetReleaseRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_release({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_release(::Google::Cloud::Deploy::V1::GetReleaseRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_release_client_stub.call_rpc_count
    end
  end

  def test_create_release
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    release_id = "hello world"
    release = {}
    request_id = "hello world"
    validate_only = true
    override_deploy_policy = ["hello world"]

    create_release_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_release, name
      assert_kind_of ::Google::Cloud::Deploy::V1::CreateReleaseRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["release_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Deploy::V1::Release), request["release"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal ["hello world"], request["override_deploy_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_release_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_release({ parent: parent, release_id: release_id, release: release, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_release parent: parent, release_id: release_id, release: release, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_release ::Google::Cloud::Deploy::V1::CreateReleaseRequest.new(parent: parent, release_id: release_id, release: release, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_release({ parent: parent, release_id: release_id, release: release, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_release(::Google::Cloud::Deploy::V1::CreateReleaseRequest.new(parent: parent, release_id: release_id, release: release, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_release_client_stub.call_rpc_count
    end
  end

  def test_abandon_release
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::AbandonReleaseResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    abandon_release_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :abandon_release, name
      assert_kind_of ::Google::Cloud::Deploy::V1::AbandonReleaseRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, abandon_release_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.abandon_release({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.abandon_release name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.abandon_release ::Google::Cloud::Deploy::V1::AbandonReleaseRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.abandon_release({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.abandon_release(::Google::Cloud::Deploy::V1::AbandonReleaseRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, abandon_release_client_stub.call_rpc_count
    end
  end

  def test_create_deploy_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    deploy_policy_id = "hello world"
    deploy_policy = {}
    request_id = "hello world"
    validate_only = true

    create_deploy_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_deploy_policy, name
      assert_kind_of ::Google::Cloud::Deploy::V1::CreateDeployPolicyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["deploy_policy_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Deploy::V1::DeployPolicy), request["deploy_policy"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_deploy_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_deploy_policy({ parent: parent, deploy_policy_id: deploy_policy_id, deploy_policy: deploy_policy, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_deploy_policy parent: parent, deploy_policy_id: deploy_policy_id, deploy_policy: deploy_policy, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_deploy_policy ::Google::Cloud::Deploy::V1::CreateDeployPolicyRequest.new(parent: parent, deploy_policy_id: deploy_policy_id, deploy_policy: deploy_policy, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_deploy_policy({ parent: parent, deploy_policy_id: deploy_policy_id, deploy_policy: deploy_policy, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_deploy_policy(::Google::Cloud::Deploy::V1::CreateDeployPolicyRequest.new(parent: parent, deploy_policy_id: deploy_policy_id, deploy_policy: deploy_policy, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_deploy_policy_client_stub.call_rpc_count
    end
  end

  def test_update_deploy_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    deploy_policy = {}
    request_id = "hello world"
    allow_missing = true
    validate_only = true

    update_deploy_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_deploy_policy, name
      assert_kind_of ::Google::Cloud::Deploy::V1::UpdateDeployPolicyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Deploy::V1::DeployPolicy), request["deploy_policy"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_deploy_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_deploy_policy({ update_mask: update_mask, deploy_policy: deploy_policy, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_deploy_policy update_mask: update_mask, deploy_policy: deploy_policy, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_deploy_policy ::Google::Cloud::Deploy::V1::UpdateDeployPolicyRequest.new(update_mask: update_mask, deploy_policy: deploy_policy, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_deploy_policy({ update_mask: update_mask, deploy_policy: deploy_policy, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_deploy_policy(::Google::Cloud::Deploy::V1::UpdateDeployPolicyRequest.new(update_mask: update_mask, deploy_policy: deploy_policy, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_deploy_policy_client_stub.call_rpc_count
    end
  end

  def test_delete_deploy_policy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    allow_missing = true
    validate_only = true
    etag = "hello world"

    delete_deploy_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_deploy_policy, name
      assert_kind_of ::Google::Cloud::Deploy::V1::DeleteDeployPolicyRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_deploy_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_deploy_policy({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_deploy_policy name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_deploy_policy ::Google::Cloud::Deploy::V1::DeleteDeployPolicyRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_deploy_policy({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_deploy_policy(::Google::Cloud::Deploy::V1::DeleteDeployPolicyRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_deploy_policy_client_stub.call_rpc_count
    end
  end

  def test_list_deploy_policies
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::ListDeployPoliciesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_deploy_policies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_deploy_policies, name
      assert_kind_of ::Google::Cloud::Deploy::V1::ListDeployPoliciesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_deploy_policies_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_deploy_policies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_deploy_policies parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_deploy_policies ::Google::Cloud::Deploy::V1::ListDeployPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_deploy_policies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_deploy_policies(::Google::Cloud::Deploy::V1::ListDeployPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_deploy_policies_client_stub.call_rpc_count
    end
  end

  def test_get_deploy_policy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::DeployPolicy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_deploy_policy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_deploy_policy, name
      assert_kind_of ::Google::Cloud::Deploy::V1::GetDeployPolicyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_deploy_policy_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_deploy_policy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_deploy_policy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_deploy_policy ::Google::Cloud::Deploy::V1::GetDeployPolicyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_deploy_policy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_deploy_policy(::Google::Cloud::Deploy::V1::GetDeployPolicyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_deploy_policy_client_stub.call_rpc_count
    end
  end

  def test_approve_rollout
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::ApproveRolloutResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    approved = true
    override_deploy_policy = ["hello world"]

    approve_rollout_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :approve_rollout, name
      assert_kind_of ::Google::Cloud::Deploy::V1::ApproveRolloutRequest, request
      assert_equal "hello world", request["name"]
      assert_equal true, request["approved"]
      assert_equal ["hello world"], request["override_deploy_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, approve_rollout_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.approve_rollout({ name: name, approved: approved, override_deploy_policy: override_deploy_policy }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.approve_rollout name: name, approved: approved, override_deploy_policy: override_deploy_policy do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.approve_rollout ::Google::Cloud::Deploy::V1::ApproveRolloutRequest.new(name: name, approved: approved, override_deploy_policy: override_deploy_policy) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.approve_rollout({ name: name, approved: approved, override_deploy_policy: override_deploy_policy }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.approve_rollout(::Google::Cloud::Deploy::V1::ApproveRolloutRequest.new(name: name, approved: approved, override_deploy_policy: override_deploy_policy), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, approve_rollout_client_stub.call_rpc_count
    end
  end

  def test_advance_rollout
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::AdvanceRolloutResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    phase_id = "hello world"
    override_deploy_policy = ["hello world"]

    advance_rollout_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :advance_rollout, name
      assert_kind_of ::Google::Cloud::Deploy::V1::AdvanceRolloutRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["phase_id"]
      assert_equal ["hello world"], request["override_deploy_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, advance_rollout_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.advance_rollout({ name: name, phase_id: phase_id, override_deploy_policy: override_deploy_policy }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.advance_rollout name: name, phase_id: phase_id, override_deploy_policy: override_deploy_policy do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.advance_rollout ::Google::Cloud::Deploy::V1::AdvanceRolloutRequest.new(name: name, phase_id: phase_id, override_deploy_policy: override_deploy_policy) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.advance_rollout({ name: name, phase_id: phase_id, override_deploy_policy: override_deploy_policy }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.advance_rollout(::Google::Cloud::Deploy::V1::AdvanceRolloutRequest.new(name: name, phase_id: phase_id, override_deploy_policy: override_deploy_policy), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, advance_rollout_client_stub.call_rpc_count
    end
  end

  def test_cancel_rollout
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::CancelRolloutResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    override_deploy_policy = ["hello world"]

    cancel_rollout_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_rollout, name
      assert_kind_of ::Google::Cloud::Deploy::V1::CancelRolloutRequest, request
      assert_equal "hello world", request["name"]
      assert_equal ["hello world"], request["override_deploy_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_rollout_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_rollout({ name: name, override_deploy_policy: override_deploy_policy }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_rollout name: name, override_deploy_policy: override_deploy_policy do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_rollout ::Google::Cloud::Deploy::V1::CancelRolloutRequest.new(name: name, override_deploy_policy: override_deploy_policy) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_rollout({ name: name, override_deploy_policy: override_deploy_policy }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_rollout(::Google::Cloud::Deploy::V1::CancelRolloutRequest.new(name: name, override_deploy_policy: override_deploy_policy), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_rollout_client_stub.call_rpc_count
    end
  end

  def test_list_rollouts
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::ListRolloutsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_rollouts_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_rollouts, name
      assert_kind_of ::Google::Cloud::Deploy::V1::ListRolloutsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_rollouts_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_rollouts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_rollouts parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_rollouts ::Google::Cloud::Deploy::V1::ListRolloutsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_rollouts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_rollouts(::Google::Cloud::Deploy::V1::ListRolloutsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_rollouts_client_stub.call_rpc_count
    end
  end

  def test_get_rollout
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::Rollout.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rollout_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_rollout, name
      assert_kind_of ::Google::Cloud::Deploy::V1::GetRolloutRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_rollout_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_rollout({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_rollout name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_rollout ::Google::Cloud::Deploy::V1::GetRolloutRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_rollout({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_rollout(::Google::Cloud::Deploy::V1::GetRolloutRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_rollout_client_stub.call_rpc_count
    end
  end

  def test_create_rollout
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rollout_id = "hello world"
    rollout = {}
    request_id = "hello world"
    validate_only = true
    override_deploy_policy = ["hello world"]
    starting_phase_id = "hello world"

    create_rollout_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_rollout, name
      assert_kind_of ::Google::Cloud::Deploy::V1::CreateRolloutRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["rollout_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Deploy::V1::Rollout), request["rollout"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal ["hello world"], request["override_deploy_policy"]
      assert_equal "hello world", request["starting_phase_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_rollout_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_rollout({ parent: parent, rollout_id: rollout_id, rollout: rollout, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy, starting_phase_id: starting_phase_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_rollout parent: parent, rollout_id: rollout_id, rollout: rollout, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy, starting_phase_id: starting_phase_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_rollout ::Google::Cloud::Deploy::V1::CreateRolloutRequest.new(parent: parent, rollout_id: rollout_id, rollout: rollout, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy, starting_phase_id: starting_phase_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_rollout({ parent: parent, rollout_id: rollout_id, rollout: rollout, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy, starting_phase_id: starting_phase_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_rollout(::Google::Cloud::Deploy::V1::CreateRolloutRequest.new(parent: parent, rollout_id: rollout_id, rollout: rollout, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy, starting_phase_id: starting_phase_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_rollout_client_stub.call_rpc_count
    end
  end

  def test_ignore_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::IgnoreJobResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    rollout = "hello world"
    phase_id = "hello world"
    job_id = "hello world"
    override_deploy_policy = ["hello world"]

    ignore_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :ignore_job, name
      assert_kind_of ::Google::Cloud::Deploy::V1::IgnoreJobRequest, request
      assert_equal "hello world", request["rollout"]
      assert_equal "hello world", request["phase_id"]
      assert_equal "hello world", request["job_id"]
      assert_equal ["hello world"], request["override_deploy_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, ignore_job_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.ignore_job({ rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.ignore_job rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.ignore_job ::Google::Cloud::Deploy::V1::IgnoreJobRequest.new(rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.ignore_job({ rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.ignore_job(::Google::Cloud::Deploy::V1::IgnoreJobRequest.new(rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, ignore_job_client_stub.call_rpc_count
    end
  end

  def test_retry_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::RetryJobResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    rollout = "hello world"
    phase_id = "hello world"
    job_id = "hello world"
    override_deploy_policy = ["hello world"]

    retry_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :retry_job, name
      assert_kind_of ::Google::Cloud::Deploy::V1::RetryJobRequest, request
      assert_equal "hello world", request["rollout"]
      assert_equal "hello world", request["phase_id"]
      assert_equal "hello world", request["job_id"]
      assert_equal ["hello world"], request["override_deploy_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, retry_job_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.retry_job({ rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.retry_job rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.retry_job ::Google::Cloud::Deploy::V1::RetryJobRequest.new(rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.retry_job({ rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.retry_job(::Google::Cloud::Deploy::V1::RetryJobRequest.new(rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, retry_job_client_stub.call_rpc_count
    end
  end

  def test_list_job_runs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::ListJobRunsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_job_runs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_job_runs, name
      assert_kind_of ::Google::Cloud::Deploy::V1::ListJobRunsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_job_runs_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_job_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_job_runs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_job_runs ::Google::Cloud::Deploy::V1::ListJobRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_job_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_job_runs(::Google::Cloud::Deploy::V1::ListJobRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_job_runs_client_stub.call_rpc_count
    end
  end

  def test_get_job_run
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::JobRun.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_job_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_job_run, name
      assert_kind_of ::Google::Cloud::Deploy::V1::GetJobRunRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_job_run_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_job_run({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_job_run name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_job_run ::Google::Cloud::Deploy::V1::GetJobRunRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_job_run({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_job_run(::Google::Cloud::Deploy::V1::GetJobRunRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_job_run_client_stub.call_rpc_count
    end
  end

  def test_terminate_job_run
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::TerminateJobRunResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    override_deploy_policy = ["hello world"]

    terminate_job_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :terminate_job_run, name
      assert_kind_of ::Google::Cloud::Deploy::V1::TerminateJobRunRequest, request
      assert_equal "hello world", request["name"]
      assert_equal ["hello world"], request["override_deploy_policy"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, terminate_job_run_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.terminate_job_run({ name: name, override_deploy_policy: override_deploy_policy }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.terminate_job_run name: name, override_deploy_policy: override_deploy_policy do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.terminate_job_run ::Google::Cloud::Deploy::V1::TerminateJobRunRequest.new(name: name, override_deploy_policy: override_deploy_policy) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.terminate_job_run({ name: name, override_deploy_policy: override_deploy_policy }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.terminate_job_run(::Google::Cloud::Deploy::V1::TerminateJobRunRequest.new(name: name, override_deploy_policy: override_deploy_policy), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, terminate_job_run_client_stub.call_rpc_count
    end
  end

  def test_get_config
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::Config.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_config_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_config, name
      assert_kind_of ::Google::Cloud::Deploy::V1::GetConfigRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_config_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_config({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_config name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_config ::Google::Cloud::Deploy::V1::GetConfigRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_config({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_config(::Google::Cloud::Deploy::V1::GetConfigRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_config_client_stub.call_rpc_count
    end
  end

  def test_create_automation
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    automation_id = "hello world"
    automation = {}
    request_id = "hello world"
    validate_only = true

    create_automation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_automation, name
      assert_kind_of ::Google::Cloud::Deploy::V1::CreateAutomationRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["automation_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Deploy::V1::Automation), request["automation"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_automation_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_automation({ parent: parent, automation_id: automation_id, automation: automation, request_id: request_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_automation parent: parent, automation_id: automation_id, automation: automation, request_id: request_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_automation ::Google::Cloud::Deploy::V1::CreateAutomationRequest.new(parent: parent, automation_id: automation_id, automation: automation, request_id: request_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_automation({ parent: parent, automation_id: automation_id, automation: automation, request_id: request_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_automation(::Google::Cloud::Deploy::V1::CreateAutomationRequest.new(parent: parent, automation_id: automation_id, automation: automation, request_id: request_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_automation_client_stub.call_rpc_count
    end
  end

  def test_update_automation
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    automation = {}
    request_id = "hello world"
    allow_missing = true
    validate_only = true

    update_automation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_automation, name
      assert_kind_of ::Google::Cloud::Deploy::V1::UpdateAutomationRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Deploy::V1::Automation), request["automation"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_automation_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_automation({ update_mask: update_mask, automation: automation, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_automation update_mask: update_mask, automation: automation, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_automation ::Google::Cloud::Deploy::V1::UpdateAutomationRequest.new(update_mask: update_mask, automation: automation, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_automation({ update_mask: update_mask, automation: automation, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_automation(::Google::Cloud::Deploy::V1::UpdateAutomationRequest.new(update_mask: update_mask, automation: automation, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_automation_client_stub.call_rpc_count
    end
  end

  def test_delete_automation
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    allow_missing = true
    validate_only = true
    etag = "hello world"

    delete_automation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_automation, name
      assert_kind_of ::Google::Cloud::Deploy::V1::DeleteAutomationRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["validate_only"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_automation_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_automation({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_automation name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_automation ::Google::Cloud::Deploy::V1::DeleteAutomationRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_automation({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_automation(::Google::Cloud::Deploy::V1::DeleteAutomationRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_automation_client_stub.call_rpc_count
    end
  end

  def test_get_automation
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::Automation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_automation_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_automation, name
      assert_kind_of ::Google::Cloud::Deploy::V1::GetAutomationRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_automation_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_automation({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_automation name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_automation ::Google::Cloud::Deploy::V1::GetAutomationRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_automation({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_automation(::Google::Cloud::Deploy::V1::GetAutomationRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_automation_client_stub.call_rpc_count
    end
  end

  def test_list_automations
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::ListAutomationsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_automations_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_automations, name
      assert_kind_of ::Google::Cloud::Deploy::V1::ListAutomationsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_automations_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_automations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_automations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_automations ::Google::Cloud::Deploy::V1::ListAutomationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_automations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_automations(::Google::Cloud::Deploy::V1::ListAutomationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_automations_client_stub.call_rpc_count
    end
  end

  def test_get_automation_run
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::AutomationRun.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_automation_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_automation_run, name
      assert_kind_of ::Google::Cloud::Deploy::V1::GetAutomationRunRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_automation_run_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_automation_run({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_automation_run name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_automation_run ::Google::Cloud::Deploy::V1::GetAutomationRunRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_automation_run({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_automation_run(::Google::Cloud::Deploy::V1::GetAutomationRunRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_automation_run_client_stub.call_rpc_count
    end
  end

  def test_list_automation_runs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::ListAutomationRunsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_automation_runs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_automation_runs, name
      assert_kind_of ::Google::Cloud::Deploy::V1::ListAutomationRunsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_automation_runs_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_automation_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_automation_runs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_automation_runs ::Google::Cloud::Deploy::V1::ListAutomationRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_automation_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_automation_runs(::Google::Cloud::Deploy::V1::ListAutomationRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_automation_runs_client_stub.call_rpc_count
    end
  end

  def test_cancel_automation_run
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Deploy::V1::CancelAutomationRunResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_automation_run_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_automation_run, name
      assert_kind_of ::Google::Cloud::Deploy::V1::CancelAutomationRunRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_automation_run_client_stub do
      # Create client
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_automation_run({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_automation_run name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_automation_run ::Google::Cloud::Deploy::V1::CancelAutomationRunRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_automation_run({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_automation_run(::Google::Cloud::Deploy::V1::CancelAutomationRunRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_automation_run_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Deploy::V1::CloudDeploy::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Deploy::V1::CloudDeploy::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Deploy::V1::CloudDeploy::Operations, client.operations_client
  end
end
