# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/deploy/v1/cloud_deploy_pb"
require "google/cloud/deploy/v1/cloud_deploy/rest"


class ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_delivery_pipelines
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::ListDeliveryPipelinesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_delivery_pipelines_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_list_delivery_pipelines_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_delivery_pipelines_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_delivery_pipelines({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_delivery_pipelines parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_delivery_pipelines ::Google::Cloud::Deploy::V1::ListDeliveryPipelinesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_delivery_pipelines({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_delivery_pipelines(::Google::Cloud::Deploy::V1::ListDeliveryPipelinesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_delivery_pipelines_client_stub.call_count
      end
    end
  end

  def test_get_delivery_pipeline
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::DeliveryPipeline.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_delivery_pipeline_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_get_delivery_pipeline_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_delivery_pipeline_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_delivery_pipeline({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_delivery_pipeline name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_delivery_pipeline ::Google::Cloud::Deploy::V1::GetDeliveryPipelineRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_delivery_pipeline({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_delivery_pipeline(::Google::Cloud::Deploy::V1::GetDeliveryPipelineRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_delivery_pipeline_client_stub.call_count
      end
    end
  end

  def test_create_delivery_pipeline
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    delivery_pipeline_id = "hello world"
    delivery_pipeline = {}
    request_id = "hello world"
    validate_only = true

    create_delivery_pipeline_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_create_delivery_pipeline_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_delivery_pipeline_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_delivery_pipeline({ parent: parent, delivery_pipeline_id: delivery_pipeline_id, delivery_pipeline: delivery_pipeline, request_id: request_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_delivery_pipeline parent: parent, delivery_pipeline_id: delivery_pipeline_id, delivery_pipeline: delivery_pipeline, request_id: request_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_delivery_pipeline ::Google::Cloud::Deploy::V1::CreateDeliveryPipelineRequest.new(parent: parent, delivery_pipeline_id: delivery_pipeline_id, delivery_pipeline: delivery_pipeline, request_id: request_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_delivery_pipeline({ parent: parent, delivery_pipeline_id: delivery_pipeline_id, delivery_pipeline: delivery_pipeline, request_id: request_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_delivery_pipeline(::Google::Cloud::Deploy::V1::CreateDeliveryPipelineRequest.new(parent: parent, delivery_pipeline_id: delivery_pipeline_id, delivery_pipeline: delivery_pipeline, request_id: request_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_delivery_pipeline_client_stub.call_count
      end
    end
  end

  def test_update_delivery_pipeline
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    delivery_pipeline = {}
    request_id = "hello world"
    allow_missing = true
    validate_only = true

    update_delivery_pipeline_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_update_delivery_pipeline_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_delivery_pipeline_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_delivery_pipeline({ update_mask: update_mask, delivery_pipeline: delivery_pipeline, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_delivery_pipeline update_mask: update_mask, delivery_pipeline: delivery_pipeline, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_delivery_pipeline ::Google::Cloud::Deploy::V1::UpdateDeliveryPipelineRequest.new(update_mask: update_mask, delivery_pipeline: delivery_pipeline, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_delivery_pipeline({ update_mask: update_mask, delivery_pipeline: delivery_pipeline, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_delivery_pipeline(::Google::Cloud::Deploy::V1::UpdateDeliveryPipelineRequest.new(update_mask: update_mask, delivery_pipeline: delivery_pipeline, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_delivery_pipeline_client_stub.call_count
      end
    end
  end

  def test_delete_delivery_pipeline
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    allow_missing = true
    validate_only = true
    force = true
    etag = "hello world"

    delete_delivery_pipeline_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_delete_delivery_pipeline_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_delivery_pipeline_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_delivery_pipeline({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, force: force, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_delivery_pipeline name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, force: force, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_delivery_pipeline ::Google::Cloud::Deploy::V1::DeleteDeliveryPipelineRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, force: force, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_delivery_pipeline({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, force: force, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_delivery_pipeline(::Google::Cloud::Deploy::V1::DeleteDeliveryPipelineRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, force: force, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_delivery_pipeline_client_stub.call_count
      end
    end
  end

  def test_list_targets
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::ListTargetsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_targets_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_list_targets_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_targets_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_targets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_targets parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_targets ::Google::Cloud::Deploy::V1::ListTargetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_targets({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_targets(::Google::Cloud::Deploy::V1::ListTargetsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_targets_client_stub.call_count
      end
    end
  end

  def test_rollback_target
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::RollbackTargetResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    target_id = "hello world"
    rollout_id = "hello world"
    release_id = "hello world"
    rollout_to_roll_back = "hello world"
    rollback_config = {}
    validate_only = true
    override_deploy_policy = ["hello world"]

    rollback_target_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_rollback_target_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, rollback_target_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.rollback_target({ name: name, target_id: target_id, rollout_id: rollout_id, release_id: release_id, rollout_to_roll_back: rollout_to_roll_back, rollback_config: rollback_config, validate_only: validate_only, override_deploy_policy: override_deploy_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.rollback_target name: name, target_id: target_id, rollout_id: rollout_id, release_id: release_id, rollout_to_roll_back: rollout_to_roll_back, rollback_config: rollback_config, validate_only: validate_only, override_deploy_policy: override_deploy_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.rollback_target ::Google::Cloud::Deploy::V1::RollbackTargetRequest.new(name: name, target_id: target_id, rollout_id: rollout_id, release_id: release_id, rollout_to_roll_back: rollout_to_roll_back, rollback_config: rollback_config, validate_only: validate_only, override_deploy_policy: override_deploy_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.rollback_target({ name: name, target_id: target_id, rollout_id: rollout_id, release_id: release_id, rollout_to_roll_back: rollout_to_roll_back, rollback_config: rollback_config, validate_only: validate_only, override_deploy_policy: override_deploy_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.rollback_target(::Google::Cloud::Deploy::V1::RollbackTargetRequest.new(name: name, target_id: target_id, rollout_id: rollout_id, release_id: release_id, rollout_to_roll_back: rollout_to_roll_back, rollback_config: rollback_config, validate_only: validate_only, override_deploy_policy: override_deploy_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, rollback_target_client_stub.call_count
      end
    end
  end

  def test_get_target
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::Target.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_target_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_get_target_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_target_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_target({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_target name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_target ::Google::Cloud::Deploy::V1::GetTargetRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_target({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_target(::Google::Cloud::Deploy::V1::GetTargetRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_target_client_stub.call_count
      end
    end
  end

  def test_create_target
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    target_id = "hello world"
    target = {}
    request_id = "hello world"
    validate_only = true

    create_target_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_create_target_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_target_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_target({ parent: parent, target_id: target_id, target: target, request_id: request_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_target parent: parent, target_id: target_id, target: target, request_id: request_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_target ::Google::Cloud::Deploy::V1::CreateTargetRequest.new(parent: parent, target_id: target_id, target: target, request_id: request_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_target({ parent: parent, target_id: target_id, target: target, request_id: request_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_target(::Google::Cloud::Deploy::V1::CreateTargetRequest.new(parent: parent, target_id: target_id, target: target, request_id: request_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_target_client_stub.call_count
      end
    end
  end

  def test_update_target
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    target = {}
    request_id = "hello world"
    allow_missing = true
    validate_only = true

    update_target_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_update_target_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_target_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_target({ update_mask: update_mask, target: target, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_target update_mask: update_mask, target: target, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_target ::Google::Cloud::Deploy::V1::UpdateTargetRequest.new(update_mask: update_mask, target: target, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_target({ update_mask: update_mask, target: target, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_target(::Google::Cloud::Deploy::V1::UpdateTargetRequest.new(update_mask: update_mask, target: target, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_target_client_stub.call_count
      end
    end
  end

  def test_delete_target
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    allow_missing = true
    validate_only = true
    etag = "hello world"

    delete_target_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_delete_target_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_target_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_target({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_target name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_target ::Google::Cloud::Deploy::V1::DeleteTargetRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_target({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_target(::Google::Cloud::Deploy::V1::DeleteTargetRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_target_client_stub.call_count
      end
    end
  end

  def test_list_custom_target_types
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::ListCustomTargetTypesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_custom_target_types_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_list_custom_target_types_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_custom_target_types_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_custom_target_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_custom_target_types parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_custom_target_types ::Google::Cloud::Deploy::V1::ListCustomTargetTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_custom_target_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_custom_target_types(::Google::Cloud::Deploy::V1::ListCustomTargetTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_custom_target_types_client_stub.call_count
      end
    end
  end

  def test_get_custom_target_type
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::CustomTargetType.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_custom_target_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_get_custom_target_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_custom_target_type_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_custom_target_type({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_custom_target_type name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_custom_target_type ::Google::Cloud::Deploy::V1::GetCustomTargetTypeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_custom_target_type({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_custom_target_type(::Google::Cloud::Deploy::V1::GetCustomTargetTypeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_custom_target_type_client_stub.call_count
      end
    end
  end

  def test_create_custom_target_type
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    custom_target_type_id = "hello world"
    custom_target_type = {}
    request_id = "hello world"
    validate_only = true

    create_custom_target_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_create_custom_target_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_custom_target_type_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_custom_target_type({ parent: parent, custom_target_type_id: custom_target_type_id, custom_target_type: custom_target_type, request_id: request_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_custom_target_type parent: parent, custom_target_type_id: custom_target_type_id, custom_target_type: custom_target_type, request_id: request_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_custom_target_type ::Google::Cloud::Deploy::V1::CreateCustomTargetTypeRequest.new(parent: parent, custom_target_type_id: custom_target_type_id, custom_target_type: custom_target_type, request_id: request_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_custom_target_type({ parent: parent, custom_target_type_id: custom_target_type_id, custom_target_type: custom_target_type, request_id: request_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_custom_target_type(::Google::Cloud::Deploy::V1::CreateCustomTargetTypeRequest.new(parent: parent, custom_target_type_id: custom_target_type_id, custom_target_type: custom_target_type, request_id: request_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_custom_target_type_client_stub.call_count
      end
    end
  end

  def test_update_custom_target_type
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    custom_target_type = {}
    request_id = "hello world"
    allow_missing = true
    validate_only = true

    update_custom_target_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_update_custom_target_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_custom_target_type_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_custom_target_type({ update_mask: update_mask, custom_target_type: custom_target_type, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_custom_target_type update_mask: update_mask, custom_target_type: custom_target_type, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_custom_target_type ::Google::Cloud::Deploy::V1::UpdateCustomTargetTypeRequest.new(update_mask: update_mask, custom_target_type: custom_target_type, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_custom_target_type({ update_mask: update_mask, custom_target_type: custom_target_type, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_custom_target_type(::Google::Cloud::Deploy::V1::UpdateCustomTargetTypeRequest.new(update_mask: update_mask, custom_target_type: custom_target_type, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_custom_target_type_client_stub.call_count
      end
    end
  end

  def test_delete_custom_target_type
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    allow_missing = true
    validate_only = true
    etag = "hello world"

    delete_custom_target_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_delete_custom_target_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_custom_target_type_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_custom_target_type({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_custom_target_type name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_custom_target_type ::Google::Cloud::Deploy::V1::DeleteCustomTargetTypeRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_custom_target_type({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_custom_target_type(::Google::Cloud::Deploy::V1::DeleteCustomTargetTypeRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_custom_target_type_client_stub.call_count
      end
    end
  end

  def test_list_releases
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::ListReleasesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_releases_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_list_releases_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_releases_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_releases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_releases parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_releases ::Google::Cloud::Deploy::V1::ListReleasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_releases({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_releases(::Google::Cloud::Deploy::V1::ListReleasesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_releases_client_stub.call_count
      end
    end
  end

  def test_get_release
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::Release.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_release_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_get_release_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_release_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_release({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_release name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_release ::Google::Cloud::Deploy::V1::GetReleaseRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_release({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_release(::Google::Cloud::Deploy::V1::GetReleaseRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_release_client_stub.call_count
      end
    end
  end

  def test_create_release
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    release_id = "hello world"
    release = {}
    request_id = "hello world"
    validate_only = true
    override_deploy_policy = ["hello world"]

    create_release_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_create_release_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_release_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_release({ parent: parent, release_id: release_id, release: release, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_release parent: parent, release_id: release_id, release: release, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_release ::Google::Cloud::Deploy::V1::CreateReleaseRequest.new(parent: parent, release_id: release_id, release: release, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_release({ parent: parent, release_id: release_id, release: release, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_release(::Google::Cloud::Deploy::V1::CreateReleaseRequest.new(parent: parent, release_id: release_id, release: release, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_release_client_stub.call_count
      end
    end
  end

  def test_abandon_release
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::AbandonReleaseResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    abandon_release_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_abandon_release_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, abandon_release_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.abandon_release({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.abandon_release name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.abandon_release ::Google::Cloud::Deploy::V1::AbandonReleaseRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.abandon_release({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.abandon_release(::Google::Cloud::Deploy::V1::AbandonReleaseRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, abandon_release_client_stub.call_count
      end
    end
  end

  def test_create_deploy_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    deploy_policy_id = "hello world"
    deploy_policy = {}
    request_id = "hello world"
    validate_only = true

    create_deploy_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_create_deploy_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_deploy_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_deploy_policy({ parent: parent, deploy_policy_id: deploy_policy_id, deploy_policy: deploy_policy, request_id: request_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_deploy_policy parent: parent, deploy_policy_id: deploy_policy_id, deploy_policy: deploy_policy, request_id: request_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_deploy_policy ::Google::Cloud::Deploy::V1::CreateDeployPolicyRequest.new(parent: parent, deploy_policy_id: deploy_policy_id, deploy_policy: deploy_policy, request_id: request_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_deploy_policy({ parent: parent, deploy_policy_id: deploy_policy_id, deploy_policy: deploy_policy, request_id: request_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_deploy_policy(::Google::Cloud::Deploy::V1::CreateDeployPolicyRequest.new(parent: parent, deploy_policy_id: deploy_policy_id, deploy_policy: deploy_policy, request_id: request_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_deploy_policy_client_stub.call_count
      end
    end
  end

  def test_update_deploy_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    deploy_policy = {}
    request_id = "hello world"
    allow_missing = true
    validate_only = true

    update_deploy_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_update_deploy_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_deploy_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_deploy_policy({ update_mask: update_mask, deploy_policy: deploy_policy, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_deploy_policy update_mask: update_mask, deploy_policy: deploy_policy, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_deploy_policy ::Google::Cloud::Deploy::V1::UpdateDeployPolicyRequest.new(update_mask: update_mask, deploy_policy: deploy_policy, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_deploy_policy({ update_mask: update_mask, deploy_policy: deploy_policy, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_deploy_policy(::Google::Cloud::Deploy::V1::UpdateDeployPolicyRequest.new(update_mask: update_mask, deploy_policy: deploy_policy, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_deploy_policy_client_stub.call_count
      end
    end
  end

  def test_delete_deploy_policy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    allow_missing = true
    validate_only = true
    etag = "hello world"

    delete_deploy_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_delete_deploy_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_deploy_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_deploy_policy({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_deploy_policy name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_deploy_policy ::Google::Cloud::Deploy::V1::DeleteDeployPolicyRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_deploy_policy({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_deploy_policy(::Google::Cloud::Deploy::V1::DeleteDeployPolicyRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_deploy_policy_client_stub.call_count
      end
    end
  end

  def test_list_deploy_policies
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::ListDeployPoliciesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_deploy_policies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_list_deploy_policies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_deploy_policies_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_deploy_policies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_deploy_policies parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_deploy_policies ::Google::Cloud::Deploy::V1::ListDeployPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_deploy_policies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_deploy_policies(::Google::Cloud::Deploy::V1::ListDeployPoliciesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_deploy_policies_client_stub.call_count
      end
    end
  end

  def test_get_deploy_policy
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::DeployPolicy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_deploy_policy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_get_deploy_policy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_deploy_policy_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_deploy_policy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_deploy_policy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_deploy_policy ::Google::Cloud::Deploy::V1::GetDeployPolicyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_deploy_policy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_deploy_policy(::Google::Cloud::Deploy::V1::GetDeployPolicyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_deploy_policy_client_stub.call_count
      end
    end
  end

  def test_approve_rollout
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::ApproveRolloutResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    approved = true
    override_deploy_policy = ["hello world"]

    approve_rollout_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_approve_rollout_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, approve_rollout_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.approve_rollout({ name: name, approved: approved, override_deploy_policy: override_deploy_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.approve_rollout name: name, approved: approved, override_deploy_policy: override_deploy_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.approve_rollout ::Google::Cloud::Deploy::V1::ApproveRolloutRequest.new(name: name, approved: approved, override_deploy_policy: override_deploy_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.approve_rollout({ name: name, approved: approved, override_deploy_policy: override_deploy_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.approve_rollout(::Google::Cloud::Deploy::V1::ApproveRolloutRequest.new(name: name, approved: approved, override_deploy_policy: override_deploy_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, approve_rollout_client_stub.call_count
      end
    end
  end

  def test_advance_rollout
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::AdvanceRolloutResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    phase_id = "hello world"
    override_deploy_policy = ["hello world"]

    advance_rollout_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_advance_rollout_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, advance_rollout_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.advance_rollout({ name: name, phase_id: phase_id, override_deploy_policy: override_deploy_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.advance_rollout name: name, phase_id: phase_id, override_deploy_policy: override_deploy_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.advance_rollout ::Google::Cloud::Deploy::V1::AdvanceRolloutRequest.new(name: name, phase_id: phase_id, override_deploy_policy: override_deploy_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.advance_rollout({ name: name, phase_id: phase_id, override_deploy_policy: override_deploy_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.advance_rollout(::Google::Cloud::Deploy::V1::AdvanceRolloutRequest.new(name: name, phase_id: phase_id, override_deploy_policy: override_deploy_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, advance_rollout_client_stub.call_count
      end
    end
  end

  def test_cancel_rollout
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::CancelRolloutResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    override_deploy_policy = ["hello world"]

    cancel_rollout_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_cancel_rollout_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_rollout_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_rollout({ name: name, override_deploy_policy: override_deploy_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_rollout name: name, override_deploy_policy: override_deploy_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_rollout ::Google::Cloud::Deploy::V1::CancelRolloutRequest.new(name: name, override_deploy_policy: override_deploy_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_rollout({ name: name, override_deploy_policy: override_deploy_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_rollout(::Google::Cloud::Deploy::V1::CancelRolloutRequest.new(name: name, override_deploy_policy: override_deploy_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_rollout_client_stub.call_count
      end
    end
  end

  def test_list_rollouts
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::ListRolloutsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_rollouts_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_list_rollouts_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_rollouts_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_rollouts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_rollouts parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_rollouts ::Google::Cloud::Deploy::V1::ListRolloutsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_rollouts({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_rollouts(::Google::Cloud::Deploy::V1::ListRolloutsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_rollouts_client_stub.call_count
      end
    end
  end

  def test_get_rollout
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::Rollout.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_rollout_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_get_rollout_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_rollout_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_rollout({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_rollout name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_rollout ::Google::Cloud::Deploy::V1::GetRolloutRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_rollout({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_rollout(::Google::Cloud::Deploy::V1::GetRolloutRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_rollout_client_stub.call_count
      end
    end
  end

  def test_create_rollout
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    rollout_id = "hello world"
    rollout = {}
    request_id = "hello world"
    validate_only = true
    override_deploy_policy = ["hello world"]
    starting_phase_id = "hello world"

    create_rollout_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_create_rollout_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_rollout_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_rollout({ parent: parent, rollout_id: rollout_id, rollout: rollout, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy, starting_phase_id: starting_phase_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_rollout parent: parent, rollout_id: rollout_id, rollout: rollout, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy, starting_phase_id: starting_phase_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_rollout ::Google::Cloud::Deploy::V1::CreateRolloutRequest.new(parent: parent, rollout_id: rollout_id, rollout: rollout, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy, starting_phase_id: starting_phase_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_rollout({ parent: parent, rollout_id: rollout_id, rollout: rollout, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy, starting_phase_id: starting_phase_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_rollout(::Google::Cloud::Deploy::V1::CreateRolloutRequest.new(parent: parent, rollout_id: rollout_id, rollout: rollout, request_id: request_id, validate_only: validate_only, override_deploy_policy: override_deploy_policy, starting_phase_id: starting_phase_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_rollout_client_stub.call_count
      end
    end
  end

  def test_ignore_job
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::IgnoreJobResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    rollout = "hello world"
    phase_id = "hello world"
    job_id = "hello world"
    override_deploy_policy = ["hello world"]

    ignore_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_ignore_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, ignore_job_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.ignore_job({ rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.ignore_job rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.ignore_job ::Google::Cloud::Deploy::V1::IgnoreJobRequest.new(rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.ignore_job({ rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.ignore_job(::Google::Cloud::Deploy::V1::IgnoreJobRequest.new(rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, ignore_job_client_stub.call_count
      end
    end
  end

  def test_retry_job
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::RetryJobResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    rollout = "hello world"
    phase_id = "hello world"
    job_id = "hello world"
    override_deploy_policy = ["hello world"]

    retry_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_retry_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, retry_job_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.retry_job({ rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.retry_job rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.retry_job ::Google::Cloud::Deploy::V1::RetryJobRequest.new(rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.retry_job({ rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.retry_job(::Google::Cloud::Deploy::V1::RetryJobRequest.new(rollout: rollout, phase_id: phase_id, job_id: job_id, override_deploy_policy: override_deploy_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, retry_job_client_stub.call_count
      end
    end
  end

  def test_list_job_runs
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::ListJobRunsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_job_runs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_list_job_runs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_job_runs_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_job_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_job_runs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_job_runs ::Google::Cloud::Deploy::V1::ListJobRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_job_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_job_runs(::Google::Cloud::Deploy::V1::ListJobRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_job_runs_client_stub.call_count
      end
    end
  end

  def test_get_job_run
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::JobRun.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_job_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_get_job_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_job_run_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_job_run({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_job_run name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_job_run ::Google::Cloud::Deploy::V1::GetJobRunRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_job_run({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_job_run(::Google::Cloud::Deploy::V1::GetJobRunRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_job_run_client_stub.call_count
      end
    end
  end

  def test_terminate_job_run
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::TerminateJobRunResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    override_deploy_policy = ["hello world"]

    terminate_job_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_terminate_job_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, terminate_job_run_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.terminate_job_run({ name: name, override_deploy_policy: override_deploy_policy }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.terminate_job_run name: name, override_deploy_policy: override_deploy_policy do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.terminate_job_run ::Google::Cloud::Deploy::V1::TerminateJobRunRequest.new(name: name, override_deploy_policy: override_deploy_policy) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.terminate_job_run({ name: name, override_deploy_policy: override_deploy_policy }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.terminate_job_run(::Google::Cloud::Deploy::V1::TerminateJobRunRequest.new(name: name, override_deploy_policy: override_deploy_policy), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, terminate_job_run_client_stub.call_count
      end
    end
  end

  def test_get_config
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::Config.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_config_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_get_config_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_config_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_config({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_config name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_config ::Google::Cloud::Deploy::V1::GetConfigRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_config({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_config(::Google::Cloud::Deploy::V1::GetConfigRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_config_client_stub.call_count
      end
    end
  end

  def test_create_automation
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    automation_id = "hello world"
    automation = {}
    request_id = "hello world"
    validate_only = true

    create_automation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_create_automation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_automation_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_automation({ parent: parent, automation_id: automation_id, automation: automation, request_id: request_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_automation parent: parent, automation_id: automation_id, automation: automation, request_id: request_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_automation ::Google::Cloud::Deploy::V1::CreateAutomationRequest.new(parent: parent, automation_id: automation_id, automation: automation, request_id: request_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_automation({ parent: parent, automation_id: automation_id, automation: automation, request_id: request_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_automation(::Google::Cloud::Deploy::V1::CreateAutomationRequest.new(parent: parent, automation_id: automation_id, automation: automation, request_id: request_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_automation_client_stub.call_count
      end
    end
  end

  def test_update_automation
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    automation = {}
    request_id = "hello world"
    allow_missing = true
    validate_only = true

    update_automation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_update_automation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_automation_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_automation({ update_mask: update_mask, automation: automation, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_automation update_mask: update_mask, automation: automation, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_automation ::Google::Cloud::Deploy::V1::UpdateAutomationRequest.new(update_mask: update_mask, automation: automation, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_automation({ update_mask: update_mask, automation: automation, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_automation(::Google::Cloud::Deploy::V1::UpdateAutomationRequest.new(update_mask: update_mask, automation: automation, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_automation_client_stub.call_count
      end
    end
  end

  def test_delete_automation
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    allow_missing = true
    validate_only = true
    etag = "hello world"

    delete_automation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_delete_automation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_automation_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_automation({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_automation name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_automation ::Google::Cloud::Deploy::V1::DeleteAutomationRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_automation({ name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_automation(::Google::Cloud::Deploy::V1::DeleteAutomationRequest.new(name: name, request_id: request_id, allow_missing: allow_missing, validate_only: validate_only, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_automation_client_stub.call_count
      end
    end
  end

  def test_get_automation
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::Automation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_automation_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_get_automation_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_automation_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_automation({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_automation name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_automation ::Google::Cloud::Deploy::V1::GetAutomationRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_automation({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_automation(::Google::Cloud::Deploy::V1::GetAutomationRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_automation_client_stub.call_count
      end
    end
  end

  def test_list_automations
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::ListAutomationsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_automations_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_list_automations_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_automations_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_automations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_automations parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_automations ::Google::Cloud::Deploy::V1::ListAutomationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_automations({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_automations(::Google::Cloud::Deploy::V1::ListAutomationsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_automations_client_stub.call_count
      end
    end
  end

  def test_get_automation_run
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::AutomationRun.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_automation_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_get_automation_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_automation_run_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_automation_run({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_automation_run name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_automation_run ::Google::Cloud::Deploy::V1::GetAutomationRunRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_automation_run({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_automation_run(::Google::Cloud::Deploy::V1::GetAutomationRunRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_automation_run_client_stub.call_count
      end
    end
  end

  def test_list_automation_runs
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::ListAutomationRunsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_automation_runs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_list_automation_runs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_automation_runs_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_automation_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_automation_runs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_automation_runs ::Google::Cloud::Deploy::V1::ListAutomationRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_automation_runs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_automation_runs(::Google::Cloud::Deploy::V1::ListAutomationRunsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_automation_runs_client_stub.call_count
      end
    end
  end

  def test_cancel_automation_run
    # Create test objects.
    client_result = ::Google::Cloud::Deploy::V1::CancelAutomationRunResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_automation_run_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.stub :transcode_cancel_automation_run_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_automation_run_client_stub do
        # Create client
        client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_automation_run({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_automation_run name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_automation_run ::Google::Cloud::Deploy::V1::CancelAutomationRunRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_automation_run({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_automation_run(::Google::Cloud::Deploy::V1::CancelAutomationRunRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_automation_run_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client::Configuration, config
  end
end
