# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/deploy/v1/cloud_deploy"

class ::Google::Cloud::Deploy::V1::CloudDeploy::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_automation_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.automation_path project: "value0", location: "value1", delivery_pipeline: "value2", automation: "value3"
      assert_equal "projects/value0/locations/value1/deliveryPipelines/value2/automations/value3", path
    end
  end

  def test_automation_run_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.automation_run_path project: "value0", location: "value1", delivery_pipeline: "value2", automation_run: "value3"
      assert_equal "projects/value0/locations/value1/deliveryPipelines/value2/automationRuns/value3", path
    end
  end

  def test_build_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.build_path project: "value0", location: "value1", build: "value2"
      assert_equal "projects/value0/locations/value1/builds/value2", path
    end
  end

  def test_cluster_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.cluster_path project: "value0", location: "value1", cluster: "value2"
      assert_equal "projects/value0/locations/value1/clusters/value2", path
    end
  end

  def test_config_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.config_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1/config", path
    end
  end

  def test_custom_target_type_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.custom_target_type_path project: "value0", location: "value1", custom_target_type: "value2"
      assert_equal "projects/value0/locations/value1/customTargetTypes/value2", path
    end
  end

  def test_delivery_pipeline_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.delivery_pipeline_path project: "value0", location: "value1", delivery_pipeline: "value2"
      assert_equal "projects/value0/locations/value1/deliveryPipelines/value2", path
    end
  end

  def test_deploy_policy_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.deploy_policy_path project: "value0", location: "value1", deploy_policy: "value2"
      assert_equal "projects/value0/locations/value1/deployPolicies/value2", path
    end
  end

  def test_job_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.job_path project: "value0", location: "value1", job: "value2"
      assert_equal "projects/value0/locations/value1/jobs/value2", path
    end
  end

  def test_job_run_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.job_run_path project: "value0", location: "value1", delivery_pipeline: "value2", release: "value3", rollout: "value4", job_run: "value5"
      assert_equal "projects/value0/locations/value1/deliveryPipelines/value2/releases/value3/rollouts/value4/jobRuns/value5", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_membership_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.membership_path project: "value0", location: "value1", membership: "value2"
      assert_equal "projects/value0/locations/value1/memberships/value2", path
    end
  end

  def test_release_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.release_path project: "value0", location: "value1", delivery_pipeline: "value2", release: "value3"
      assert_equal "projects/value0/locations/value1/deliveryPipelines/value2/releases/value3", path
    end
  end

  def test_repository_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.repository_path project: "value0", location: "value1", connection: "value2", repository: "value3"
      assert_equal "projects/value0/locations/value1/connections/value2/repositories/value3", path
    end
  end

  def test_rollout_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.rollout_path project: "value0", location: "value1", delivery_pipeline: "value2", release: "value3", rollout: "value4"
      assert_equal "projects/value0/locations/value1/deliveryPipelines/value2/releases/value3/rollouts/value4", path
    end
  end

  def test_service_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.service_path project: "value0", location: "value1", service: "value2"
      assert_equal "projects/value0/locations/value1/services/value2", path
    end
  end

  def test_target_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.target_path project: "value0", location: "value1", target: "value2"
      assert_equal "projects/value0/locations/value1/targets/value2", path
    end
  end

  def test_worker_pool_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Deploy::V1::CloudDeploy::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.worker_pool_path project: "value0", location: "value1", worker_pool: "value2"
      assert_equal "projects/value0/locations/value1/workerPools/value2", path
    end
  end
end
