# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Deploy
      module V1
        # Payload proto for "clouddeploy.googleapis.com/deploypolicy_evaluation"
        # Platform Log event that describes the deploy policy evaluation event.
        # @!attribute [rw] message
        #   @return [::String]
        #     Debug message for when a deploy policy event occurs.
        # @!attribute [rw] rule_type
        #   @return [::String]
        #     Rule type (e.g. Restrict Rollouts).
        # @!attribute [rw] rule
        #   @return [::String]
        #     Rule id.
        # @!attribute [rw] pipeline_uid
        #   @return [::String]
        #     Unique identifier of the `Delivery Pipeline`.
        # @!attribute [rw] delivery_pipeline
        #   @return [::String]
        #     The name of the `Delivery Pipeline`.
        # @!attribute [rw] target_uid
        #   @return [::String]
        #     Unique identifier of the `Target`. This is an optional field, as a `Target`
        #     may not always be applicable to a policy.
        # @!attribute [rw] target
        #   @return [::String]
        #     The name of the `Target`. This is an optional field, as a `Target` may not
        #     always be applicable to a policy.
        # @!attribute [rw] invoker
        #   @return [::Google::Cloud::Deploy::V1::DeployPolicy::Invoker]
        #     What invoked the action (e.g. a user or automation).
        # @!attribute [rw] deploy_policy
        #   @return [::String]
        #     The name of the `DeployPolicy`.
        # @!attribute [rw] deploy_policy_uid
        #   @return [::String]
        #     Unique identifier of the `DeployPolicy`.
        # @!attribute [rw] allowed
        #   @return [::Boolean]
        #     Whether the request is allowed. Allowed is set as true if:
        #     (1) the request complies with the policy; or
        #     (2) the request doesn't comply with the policy but the policy was
        #     overridden; or
        #     (3) the request doesn't comply with the policy but the policy was suspended
        # @!attribute [rw] verdict
        #   @return [::Google::Cloud::Deploy::V1::DeployPolicyEvaluationEvent::PolicyVerdict]
        #     The policy verdict of the request.
        # @!attribute [rw] overrides
        #   @return [::Array<::Google::Cloud::Deploy::V1::DeployPolicyEvaluationEvent::PolicyVerdictOverride>]
        #     Things that could have overridden the policy verdict. Overrides together
        #     with verdict decide whether the request is allowed.
        class DeployPolicyEvaluationEvent
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The policy verdict of the request.
          module PolicyVerdict
            # This should never happen.
            POLICY_VERDICT_UNSPECIFIED = 0

            # Allowed by policy. This enum value is not currently used but may be used
            # in the future. Currently logs are only generated when a request is denied
            # by policy.
            ALLOWED_BY_POLICY = 1

            # Denied by policy.
            DENIED_BY_POLICY = 2
          end

          # Things that could have overridden the policy verdict. When overrides are
          # used, the request will be allowed even if it is DENIED_BY_POLICY.
          module PolicyVerdictOverride
            # This should never happen.
            POLICY_VERDICT_OVERRIDE_UNSPECIFIED = 0

            # The policy was overridden.
            POLICY_OVERRIDDEN = 1

            # The policy was suspended.
            POLICY_SUSPENDED = 2
          end
        end
      end
    end
  end
end
