# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Deploy
      module V1
        # A `DeliveryPipeline` resource in the Cloud Deploy API.
        #
        # A `DeliveryPipeline` defines a pipeline through which a Skaffold
        # configuration can progress.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the `DeliveryPipeline`. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}`.
        #     The `deliveryPipeline` component must match
        #     `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Unique identifier of the `DeliveryPipeline`.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the `DeliveryPipeline`. Max length is 255
        #     characters.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User annotations. These attributes can only be set and used by
        #     the user, and not by Cloud Deploy.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels are attributes that can be set and used by both the
        #     user and by Cloud Deploy. Labels must meet the following constraints:
        #
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #     underscores, and dashes.
        #     * All characters must use UTF-8 encoding, and international characters are
        #     allowed.
        #     * Keys must start with a lowercase letter or international character.
        #     * Each resource is limited to a maximum of 64 labels.
        #
        #     Both keys and values are additionally constrained to be <= 128 bytes.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the pipeline was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Most recent time at which the pipeline was updated.
        # @!attribute [rw] serial_pipeline
        #   @return [::Google::Cloud::Deploy::V1::SerialPipeline]
        #     Optional. SerialPipeline defines a sequential set of stages for a
        #     `DeliveryPipeline`.
        # @!attribute [r] condition
        #   @return [::Google::Cloud::Deploy::V1::PipelineCondition]
        #     Output only. Information around the state of the Delivery Pipeline.
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of other
        #     fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [rw] suspended
        #   @return [::Boolean]
        #     Optional. When suspended, no new releases or rollouts can be created,
        #     but in-progress ones will complete.
        class DeliveryPipeline
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # SerialPipeline defines a sequential set of stages for a `DeliveryPipeline`.
        # @!attribute [rw] stages
        #   @return [::Array<::Google::Cloud::Deploy::V1::Stage>]
        #     Optional. Each stage specifies configuration for a `Target`. The ordering
        #     of this list defines the promotion flow.
        class SerialPipeline
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Stage specifies a location to which to deploy.
        # @!attribute [rw] target_id
        #   @return [::String]
        #     Optional. The target_id to which this stage points. This field refers
        #     exclusively to the last segment of a target name. For example, this field
        #     would just be `my-target` (rather than
        #     `projects/project/locations/location/targets/my-target`). The location of
        #     the `Target` is inferred to be the same as the location of the
        #     `DeliveryPipeline` that contains this `Stage`.
        # @!attribute [rw] profiles
        #   @return [::Array<::String>]
        #     Optional. Skaffold profiles to use when rendering the manifest for this
        #     stage's `Target`.
        # @!attribute [rw] strategy
        #   @return [::Google::Cloud::Deploy::V1::Strategy]
        #     Optional. The strategy to use for a `Rollout` to this stage.
        # @!attribute [rw] deploy_parameters
        #   @return [::Array<::Google::Cloud::Deploy::V1::DeployParameters>]
        #     Optional. The deploy parameters to use for the target in this stage.
        class Stage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeployParameters contains deploy parameters information.
        # @!attribute [rw] values
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Required. Values are deploy parameters in key-value pairs.
        # @!attribute [rw] match_target_labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Deploy parameters are applied to targets with match labels.
        #     If unspecified, deploy parameters are applied to all targets (including
        #     child targets of a multi-target).
        class DeployParameters
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ValuesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MatchTargetLabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Strategy contains deployment strategy information.
        # @!attribute [rw] standard
        #   @return [::Google::Cloud::Deploy::V1::Standard]
        #     Optional. Standard deployment strategy executes a single deploy and
        #     allows verifying the deployment.
        #
        #     Note: The following fields are mutually exclusive: `standard`, `canary`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] canary
        #   @return [::Google::Cloud::Deploy::V1::Canary]
        #     Optional. Canary deployment strategy provides progressive percentage
        #     based deployments to a Target.
        #
        #     Note: The following fields are mutually exclusive: `canary`, `standard`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Strategy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Predeploy contains the predeploy job configuration information.
        # @!attribute [rw] actions
        #   @return [::Array<::String>]
        #     Optional. A sequence of Skaffold custom actions to invoke during execution
        #     of the predeploy job.
        class Predeploy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Postdeploy contains the postdeploy job configuration information.
        # @!attribute [rw] actions
        #   @return [::Array<::String>]
        #     Optional. A sequence of Skaffold custom actions to invoke during execution
        #     of the postdeploy job.
        class Postdeploy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Standard represents the standard deployment strategy.
        # @!attribute [rw] verify
        #   @return [::Boolean]
        #     Optional. Whether to verify a deployment via `skaffold verify`.
        # @!attribute [rw] predeploy
        #   @return [::Google::Cloud::Deploy::V1::Predeploy]
        #     Optional. Configuration for the predeploy job. If this is not configured,
        #     the predeploy job will not be present.
        # @!attribute [rw] postdeploy
        #   @return [::Google::Cloud::Deploy::V1::Postdeploy]
        #     Optional. Configuration for the postdeploy job. If this is not configured,
        #     the postdeploy job will not be present.
        class Standard
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Canary represents the canary deployment strategy.
        # @!attribute [rw] runtime_config
        #   @return [::Google::Cloud::Deploy::V1::RuntimeConfig]
        #     Optional. Runtime specific configurations for the deployment strategy. The
        #     runtime configuration is used to determine how Cloud Deploy will split
        #     traffic to enable a progressive deployment.
        # @!attribute [rw] canary_deployment
        #   @return [::Google::Cloud::Deploy::V1::CanaryDeployment]
        #     Optional. Configures the progressive based deployment for a Target.
        #
        #     Note: The following fields are mutually exclusive: `canary_deployment`, `custom_canary_deployment`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] custom_canary_deployment
        #   @return [::Google::Cloud::Deploy::V1::CustomCanaryDeployment]
        #     Optional. Configures the progressive based deployment for a Target, but
        #     allows customizing at the phase level where a phase represents each of
        #     the percentage deployments.
        #
        #     Note: The following fields are mutually exclusive: `custom_canary_deployment`, `canary_deployment`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Canary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CanaryDeployment represents the canary deployment configuration
        # @!attribute [rw] percentages
        #   @return [::Array<::Integer>]
        #     Required. The percentage based deployments that will occur as a part of a
        #     `Rollout`. List is expected in ascending order and each integer n is
        #     0 <= n < 100.
        #     If the GatewayServiceMesh is configured for Kubernetes, then the range for
        #     n is 0 <= n <= 100.
        # @!attribute [rw] verify
        #   @return [::Boolean]
        #     Optional. Whether to run verify tests after each percentage deployment via
        #     `skaffold verify`.
        # @!attribute [rw] predeploy
        #   @return [::Google::Cloud::Deploy::V1::Predeploy]
        #     Optional. Configuration for the predeploy job of the first phase. If this
        #     is not configured, there will be no predeploy job for this phase.
        # @!attribute [rw] postdeploy
        #   @return [::Google::Cloud::Deploy::V1::Postdeploy]
        #     Optional. Configuration for the postdeploy job of the last phase. If this
        #     is not configured, there will be no postdeploy job for this phase.
        class CanaryDeployment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CustomCanaryDeployment represents the custom canary deployment
        # configuration.
        # @!attribute [rw] phase_configs
        #   @return [::Array<::Google::Cloud::Deploy::V1::CustomCanaryDeployment::PhaseConfig>]
        #     Required. Configuration for each phase in the canary deployment in the
        #     order executed.
        class CustomCanaryDeployment
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # PhaseConfig represents the configuration for a phase in the custom
          # canary deployment.
          # @!attribute [rw] phase_id
          #   @return [::String]
          #     Required. The ID to assign to the `Rollout` phase.
          #     This value must consist of lower-case letters, numbers, and hyphens,
          #     start with a letter and end with a letter or a number, and have a max
          #     length of 63 characters. In other words, it must match the following
          #     regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
          # @!attribute [rw] percentage
          #   @return [::Integer]
          #     Required. Percentage deployment for the phase.
          # @!attribute [rw] profiles
          #   @return [::Array<::String>]
          #     Optional. Skaffold profiles to use when rendering the manifest for this
          #     phase. These are in addition to the profiles list specified in the
          #     `DeliveryPipeline` stage.
          # @!attribute [rw] verify
          #   @return [::Boolean]
          #     Optional. Whether to run verify tests after the deployment via `skaffold
          #     verify`.
          # @!attribute [rw] predeploy
          #   @return [::Google::Cloud::Deploy::V1::Predeploy]
          #     Optional. Configuration for the predeploy job of this phase. If this is
          #     not configured, there will be no predeploy job for this phase.
          # @!attribute [rw] postdeploy
          #   @return [::Google::Cloud::Deploy::V1::Postdeploy]
          #     Optional. Configuration for the postdeploy job of this phase. If this is
          #     not configured, there will be no postdeploy job for this phase.
          class PhaseConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # KubernetesConfig contains the Kubernetes runtime configuration.
        # @!attribute [rw] gateway_service_mesh
        #   @return [::Google::Cloud::Deploy::V1::KubernetesConfig::GatewayServiceMesh]
        #     Optional. Kubernetes Gateway API service mesh configuration.
        #
        #     Note: The following fields are mutually exclusive: `gateway_service_mesh`, `service_networking`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] service_networking
        #   @return [::Google::Cloud::Deploy::V1::KubernetesConfig::ServiceNetworking]
        #     Optional. Kubernetes Service networking configuration.
        #
        #     Note: The following fields are mutually exclusive: `service_networking`, `gateway_service_mesh`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class KubernetesConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Information about the Kubernetes Gateway API service mesh configuration.
          # @!attribute [rw] http_route
          #   @return [::String]
          #     Required. Name of the Gateway API HTTPRoute.
          # @!attribute [rw] service
          #   @return [::String]
          #     Required. Name of the Kubernetes Service.
          # @!attribute [rw] deployment
          #   @return [::String]
          #     Required. Name of the Kubernetes Deployment whose traffic is managed by
          #     the specified HTTPRoute and Service.
          # @!attribute [rw] route_update_wait_time
          #   @return [::Google::Protobuf::Duration]
          #     Optional. The time to wait for route updates to propagate. The maximum
          #     configurable time is 3 hours, in seconds format. If unspecified, there is
          #     no wait time.
          # @!attribute [rw] stable_cutback_duration
          #   @return [::Google::Protobuf::Duration]
          #     Optional. The amount of time to migrate traffic back from the canary
          #     Service to the original Service during the stable phase deployment. If
          #     specified, must be between 15s and 3600s. If unspecified, there is no
          #     cutback time.
          # @!attribute [rw] pod_selector_label
          #   @return [::String]
          #     Optional. The label to use when selecting Pods for the Deployment and
          #     Service resources. This label must already be present in both resources.
          # @!attribute [rw] route_destinations
          #   @return [::Google::Cloud::Deploy::V1::KubernetesConfig::GatewayServiceMesh::RouteDestinations]
          #     Optional. Route destinations allow configuring the Gateway API HTTPRoute
          #     to be deployed to additional clusters. This option is available for
          #     multi-cluster service mesh set ups that require the route to exist in the
          #     clusters that call the service. If unspecified, the HTTPRoute will only
          #     be deployed to the Target cluster.
          class GatewayServiceMesh
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Information about route destinations for the Gateway API service mesh.
            # @!attribute [rw] destination_ids
            #   @return [::Array<::String>]
            #     Required. The clusters where the Gateway API HTTPRoute resource will be
            #     deployed to. Valid entries include the associated entities IDs
            #     configured in the Target resource and "@self" to include the Target
            #     cluster.
            # @!attribute [rw] propagate_service
            #   @return [::Boolean]
            #     Optional. Whether to propagate the Kubernetes Service to the route
            #     destination clusters. The Service will always be deployed to the Target
            #     cluster even if the HTTPRoute is not. This option may be used to
            #     facilitate successful DNS lookup in the route destination clusters. Can
            #     only be set to true if destinations are specified.
            class RouteDestinations
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Information about the Kubernetes Service networking configuration.
          # @!attribute [rw] service
          #   @return [::String]
          #     Required. Name of the Kubernetes Service.
          # @!attribute [rw] deployment
          #   @return [::String]
          #     Required. Name of the Kubernetes Deployment whose traffic is managed by
          #     the specified Service.
          # @!attribute [rw] disable_pod_overprovisioning
          #   @return [::Boolean]
          #     Optional. Whether to disable Pod overprovisioning. If Pod
          #     overprovisioning is disabled then Cloud Deploy will limit the number of
          #     total Pods used for the deployment strategy to the number of Pods the
          #     Deployment has on the cluster.
          # @!attribute [rw] pod_selector_label
          #   @return [::String]
          #     Optional. The label to use when selecting Pods for the Deployment
          #     resource. This label must already be present in the Deployment.
          class ServiceNetworking
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # CloudRunConfig contains the Cloud Run runtime configuration.
        # @!attribute [rw] automatic_traffic_control
        #   @return [::Boolean]
        #     Optional. Whether Cloud Deploy should update the traffic stanza in a Cloud
        #     Run Service on the user's behalf to facilitate traffic splitting. This is
        #     required to be true for CanaryDeployments, but optional for
        #     CustomCanaryDeployments.
        # @!attribute [rw] canary_revision_tags
        #   @return [::Array<::String>]
        #     Optional. A list of tags that are added to the canary revision while the
        #     canary phase is in progress.
        # @!attribute [rw] prior_revision_tags
        #   @return [::Array<::String>]
        #     Optional. A list of tags that are added to the prior revision while the
        #     canary phase is in progress.
        # @!attribute [rw] stable_revision_tags
        #   @return [::Array<::String>]
        #     Optional. A list of tags that are added to the final stable revision when
        #     the stable phase is applied.
        class CloudRunConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RuntimeConfig contains the runtime specific configurations for a deployment
        # strategy.
        # @!attribute [rw] kubernetes
        #   @return [::Google::Cloud::Deploy::V1::KubernetesConfig]
        #     Optional. Kubernetes runtime configuration.
        #
        #     Note: The following fields are mutually exclusive: `kubernetes`, `cloud_run`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] cloud_run
        #   @return [::Google::Cloud::Deploy::V1::CloudRunConfig]
        #     Optional. Cloud Run runtime configuration.
        #
        #     Note: The following fields are mutually exclusive: `cloud_run`, `kubernetes`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class RuntimeConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PipelineReadyCondition contains information around the status of the
        # Pipeline.
        # @!attribute [rw] status
        #   @return [::Boolean]
        #     True if the Pipeline is in a valid state. Otherwise at least one condition
        #     in `PipelineCondition` is in an invalid state. Iterate over those
        #     conditions and see which condition(s) has status = false to find out what
        #     is wrong with the Pipeline.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Last time the condition was updated.
        class PipelineReadyCondition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `TargetsPresentCondition` contains information on any Targets referenced in
        # the Delivery Pipeline that do not actually exist.
        # @!attribute [rw] status
        #   @return [::Boolean]
        #     True if there aren't any missing Targets.
        # @!attribute [rw] missing_targets
        #   @return [::Array<::String>]
        #     The list of Target names that do not exist. For example,
        #     `projects/{project_id}/locations/{location_name}/targets/{target_name}`.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Last time the condition was updated.
        class TargetsPresentCondition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # TargetsTypeCondition contains information on whether the Targets defined in
        # the Delivery Pipeline are of the same type.
        # @!attribute [rw] status
        #   @return [::Boolean]
        #     True if the targets are all a comparable type. For example this is true if
        #     all targets are GKE clusters. This is false if some targets are Cloud Run
        #     targets and others are GKE clusters.
        # @!attribute [rw] error_details
        #   @return [::String]
        #     Human readable error message.
        class TargetsTypeCondition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PipelineCondition contains all conditions relevant to a Delivery Pipeline.
        # @!attribute [rw] pipeline_ready_condition
        #   @return [::Google::Cloud::Deploy::V1::PipelineReadyCondition]
        #     Details around the Pipeline's overall status.
        # @!attribute [rw] targets_present_condition
        #   @return [::Google::Cloud::Deploy::V1::TargetsPresentCondition]
        #     Details around targets enumerated in the pipeline.
        # @!attribute [rw] targets_type_condition
        #   @return [::Google::Cloud::Deploy::V1::TargetsTypeCondition]
        #     Details on the whether the targets enumerated in the pipeline are of the
        #     same type.
        class PipelineCondition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `ListDeliveryPipelines`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of pipelines. Format must
        #     be `projects/{project_id}/locations/{location_name}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of pipelines to return. The service may return
        #     fewer than this value. If unspecified, at most 50 pipelines will
        #     be returned. The maximum value is 1000; values above 1000 will be set
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListDeliveryPipelines` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other provided parameters match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter pipelines to be returned. See https://google.aip.dev/160 for more
        #     details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
        class ListDeliveryPipelinesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from `ListDeliveryPipelines`.
        # @!attribute [rw] delivery_pipelines
        #   @return [::Array<::Google::Cloud::Deploy::V1::DeliveryPipeline>]
        #     The `DeliveryPipeline` objects.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDeliveryPipelinesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `GetDeliveryPipeline`
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the `DeliveryPipeline`. Format must be
        #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
        class GetDeliveryPipelineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `CreateDeliveryPipeline`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent collection in which the `DeliveryPipeline` must be
        #     created. The format is `projects/{project_id}/locations/{location_name}`.
        # @!attribute [rw] delivery_pipeline_id
        #   @return [::String]
        #     Required. ID of the `DeliveryPipeline`.
        # @!attribute [rw] delivery_pipeline
        #   @return [::Google::Cloud::Deploy::V1::DeliveryPipeline]
        #     Required. The `DeliveryPipeline` to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, the request is validated and the user is provided
        #     with an expected result, but no actual change is made.
        class CreateDeliveryPipelineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `UpdateDeliveryPipeline`.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten by the
        #     update in the `DeliveryPipeline` resource. The fields specified in the
        #     update_mask are relative to the resource, not the full request. A field
        #     will be overwritten if it's in the mask. If the user doesn't provide a mask
        #     then all fields are overwritten.
        # @!attribute [rw] delivery_pipeline
        #   @return [::Google::Cloud::Deploy::V1::DeliveryPipeline]
        #     Required. The `DeliveryPipeline` to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, updating a `DeliveryPipeline` that does not exist
        #     will result in the creation of a new `DeliveryPipeline`.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, the request is validated and the user is provided
        #     with an expected result, but no actual change is made.
        class UpdateDeliveryPipelineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `DeleteDeliveryPipeline`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the `DeliveryPipeline` to delete. The format is
        #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, then deleting an already deleted or non-existing
        #     `DeliveryPipeline` will succeed.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     actually post it.
        # @!attribute [rw] force
        #   @return [::Boolean]
        #     Optional. If set to true, all child resources under this pipeline will also
        #     be deleted. Otherwise, the request will only work if the pipeline has no
        #     child resources.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        class DeleteDeliveryPipelineRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configs for the Rollback rollout.
        # @!attribute [rw] rollout
        #   @return [::Google::Cloud::Deploy::V1::Rollout]
        #     Optional. The rollback `Rollout` to create.
        # @!attribute [rw] starting_phase_id
        #   @return [::String]
        #     Optional. The starting phase ID for the `Rollout`. If unspecified, the
        #     `Rollout` will start in the stable phase.
        class RollbackTargetConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `RollbackTarget`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The `DeliveryPipeline` for which the rollback `Rollout` must be
        #     created. The format is
        #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
        # @!attribute [rw] target_id
        #   @return [::String]
        #     Required. ID of the `Target` that is being rolled back.
        # @!attribute [rw] rollout_id
        #   @return [::String]
        #     Required. ID of the rollback `Rollout` to create.
        # @!attribute [rw] release_id
        #   @return [::String]
        #     Optional. ID of the `Release` to roll back to. If this isn't specified, the
        #     previous successful `Rollout` to the specified target will be used to
        #     determine the `Release`.
        # @!attribute [rw] rollout_to_roll_back
        #   @return [::String]
        #     Optional. If provided, this must be the latest `Rollout` that is on the
        #     `Target`.
        # @!attribute [rw] rollback_config
        #   @return [::Google::Cloud::Deploy::V1::RollbackTargetConfig]
        #     Optional. Configs for the rollback `Rollout`.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, the request is validated and the user is provided
        #     with a `RollbackTargetResponse`.
        # @!attribute [rw] override_deploy_policy
        #   @return [::Array<::String>]
        #     Optional. Deploy policies to override. Format is
        #     `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
        class RollbackTargetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from `RollbackTarget`.
        # @!attribute [rw] rollback_config
        #   @return [::Google::Cloud::Deploy::V1::RollbackTargetConfig]
        #     The config of the rollback `Rollout` created or will be created.
        class RollbackTargetResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A `Target` resource in the Cloud Deploy API.
        #
        # A `Target` defines a location to which a Skaffold configuration
        # can be deployed.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the `Target`. Format is
        #     `projects/{project}/locations/{location}/targets/{target}`.
        #     The `target` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
        # @!attribute [r] target_id
        #   @return [::String]
        #     Output only. Resource id of the `Target`.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Unique identifier of the `Target`.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the `Target`. Max length is 255 characters.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User annotations. These attributes can only be set and used by
        #     the user, and not by Cloud Deploy. See
        #     https://google.aip.dev/128#annotations for more details such as format and
        #     size limitations.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels are attributes that can be set and used by both the
        #     user and by Cloud Deploy. Labels must meet the following constraints:
        #
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #     underscores, and dashes.
        #     * All characters must use UTF-8 encoding, and international characters are
        #     allowed.
        #     * Keys must start with a lowercase letter or international character.
        #     * Each resource is limited to a maximum of 64 labels.
        #
        #     Both keys and values are additionally constrained to be <= 128 bytes.
        # @!attribute [rw] require_approval
        #   @return [::Boolean]
        #     Optional. Whether or not the `Target` requires approval.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the `Target` was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Most recent time at which the `Target` was updated.
        # @!attribute [rw] gke
        #   @return [::Google::Cloud::Deploy::V1::GkeCluster]
        #     Optional. Information specifying a GKE Cluster.
        #
        #     Note: The following fields are mutually exclusive: `gke`, `anthos_cluster`, `run`, `multi_target`, `custom_target`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] anthos_cluster
        #   @return [::Google::Cloud::Deploy::V1::AnthosCluster]
        #     Optional. Information specifying an Anthos Cluster.
        #
        #     Note: The following fields are mutually exclusive: `anthos_cluster`, `gke`, `run`, `multi_target`, `custom_target`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] run
        #   @return [::Google::Cloud::Deploy::V1::CloudRunLocation]
        #     Optional. Information specifying a Cloud Run deployment target.
        #
        #     Note: The following fields are mutually exclusive: `run`, `gke`, `anthos_cluster`, `multi_target`, `custom_target`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] multi_target
        #   @return [::Google::Cloud::Deploy::V1::MultiTarget]
        #     Optional. Information specifying a multiTarget.
        #
        #     Note: The following fields are mutually exclusive: `multi_target`, `gke`, `anthos_cluster`, `run`, `custom_target`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] custom_target
        #   @return [::Google::Cloud::Deploy::V1::CustomTarget]
        #     Optional. Information specifying a Custom Target.
        #
        #     Note: The following fields are mutually exclusive: `custom_target`, `gke`, `anthos_cluster`, `run`, `multi_target`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] associated_entities
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Deploy::V1::AssociatedEntities}]
        #     Optional. Map of entity IDs to their associated entities. Associated
        #     entities allows specifying places other than the deployment target for
        #     specific features. For example, the Gateway API canary can be configured to
        #     deploy the HTTPRoute to a different cluster(s) than the deployment cluster
        #     using associated entities. An entity ID must consist of lower-case letters,
        #     numbers, and hyphens, start with a letter and end with a letter or a
        #     number, and have a max length of 63 characters. In other words, it must
        #     match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [rw] execution_configs
        #   @return [::Array<::Google::Cloud::Deploy::V1::ExecutionConfig>]
        #     Optional. Configurations for all execution that relates to this `Target`.
        #     Each `ExecutionEnvironmentUsage` value may only be used in a single
        #     configuration; using the same value multiple times is an error.
        #     When one or more configurations are specified, they must include the
        #     `RENDER` and `DEPLOY` `ExecutionEnvironmentUsage` values.
        #     When no configurations are specified, execution will use the default
        #     specified in `DefaultPool`.
        # @!attribute [rw] deploy_parameters
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The deploy parameters to use for this target.
        class Target
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Deploy::V1::AssociatedEntities]
          class AssociatedEntitiesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class DeployParametersEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Configuration of the environment to use when calling Skaffold.
        # @!attribute [rw] usages
        #   @return [::Array<::Google::Cloud::Deploy::V1::ExecutionConfig::ExecutionEnvironmentUsage>]
        #     Required. Usages when this configuration should be applied.
        # @!attribute [rw] default_pool
        #   @return [::Google::Cloud::Deploy::V1::DefaultPool]
        #     Optional. Use default Cloud Build pool.
        #
        #     Note: The following fields are mutually exclusive: `default_pool`, `private_pool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] private_pool
        #   @return [::Google::Cloud::Deploy::V1::PrivatePool]
        #     Optional. Use private Cloud Build pool.
        #
        #     Note: The following fields are mutually exclusive: `private_pool`, `default_pool`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] worker_pool
        #   @return [::String]
        #     Optional. The resource name of the `WorkerPool`, with the format
        #     `projects/{project}/locations/{location}/workerPools/{worker_pool}`.
        #     If this optional field is unspecified, the default Cloud Build pool will be
        #     used.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. Google service account to use for execution. If unspecified,
        #     the project execution service account
        #     (<PROJECT_NUMBER>-compute@developer.gserviceaccount.com) is used.
        # @!attribute [rw] artifact_storage
        #   @return [::String]
        #     Optional. Cloud Storage location in which to store execution outputs. This
        #     can either be a bucket ("gs://my-bucket") or a path within a bucket
        #     ("gs://my-bucket/my-dir").
        #     If unspecified, a default bucket located in the same region will be used.
        # @!attribute [rw] execution_timeout
        #   @return [::Google::Protobuf::Duration]
        #     Optional. Execution timeout for a Cloud Build Execution. This must be
        #     between 10m and 24h in seconds format. If unspecified, a default timeout of
        #     1h is used.
        # @!attribute [rw] verbose
        #   @return [::Boolean]
        #     Optional. If true, additional logging will be enabled when running builds
        #     in this execution environment.
        class ExecutionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Possible usages of this configuration.
          module ExecutionEnvironmentUsage
            # Default value. This value is unused.
            EXECUTION_ENVIRONMENT_USAGE_UNSPECIFIED = 0

            # Use for rendering.
            RENDER = 1

            # Use for deploying and deployment hooks.
            DEPLOY = 2

            # Use for deployment verification.
            VERIFY = 3

            # Use for predeploy job execution.
            PREDEPLOY = 4

            # Use for postdeploy job execution.
            POSTDEPLOY = 5
          end
        end

        # Execution using the default Cloud Build pool.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. Google service account to use for execution. If unspecified,
        #     the project execution service account
        #     (<PROJECT_NUMBER>-compute@developer.gserviceaccount.com) will be used.
        # @!attribute [rw] artifact_storage
        #   @return [::String]
        #     Optional. Cloud Storage location where execution outputs should be stored.
        #     This can either be a bucket ("gs://my-bucket") or a path within a bucket
        #     ("gs://my-bucket/my-dir").
        #     If unspecified, a default bucket located in the same region will be used.
        class DefaultPool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Execution using a private Cloud Build pool.
        # @!attribute [rw] worker_pool
        #   @return [::String]
        #     Required. Resource name of the Cloud Build worker pool to use. The format
        #     is `projects/{project}/locations/{location}/workerPools/{pool}`.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Optional. Google service account to use for execution. If unspecified,
        #     the project execution service account
        #     (<PROJECT_NUMBER>-compute@developer.gserviceaccount.com) will be used.
        # @!attribute [rw] artifact_storage
        #   @return [::String]
        #     Optional. Cloud Storage location where execution outputs should be stored.
        #     This can either be a bucket ("gs://my-bucket") or a path within a bucket
        #     ("gs://my-bucket/my-dir").
        #     If unspecified, a default bucket located in the same region will be used.
        class PrivatePool
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information specifying a GKE Cluster.
        # @!attribute [rw] cluster
        #   @return [::String]
        #     Optional. Information specifying a GKE Cluster. Format is
        #     `projects/{project_id}/locations/{location_id}/clusters/{cluster_id}`.
        # @!attribute [rw] internal_ip
        #   @return [::Boolean]
        #     Optional. If true, `cluster` is accessed using the private IP address of
        #     the control plane endpoint. Otherwise, the default IP address of the
        #     control plane endpoint is used. The default IP address is the private IP
        #     address for clusters with private control-plane endpoints and the public IP
        #     address otherwise.
        #
        #     Only specify this option when `cluster` is a [private GKE
        #     cluster](https://cloud.google.com/kubernetes-engine/docs/concepts/private-cluster-concept).
        #     Note that `internal_ip` and `dns_endpoint` cannot both be set to true.
        # @!attribute [rw] proxy_url
        #   @return [::String]
        #     Optional. If set, used to configure a
        #     [proxy](https://kubernetes.io/docs/concepts/configuration/organize-cluster-access-kubeconfig/#proxy)
        #     to the Kubernetes server.
        # @!attribute [rw] dns_endpoint
        #   @return [::Boolean]
        #     Optional. If set, the cluster will be accessed using the DNS endpoint. Note
        #     that both `dns_endpoint` and `internal_ip` cannot be set to true.
        class GkeCluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information specifying an Anthos Cluster.
        # @!attribute [rw] membership
        #   @return [::String]
        #     Optional. Membership of the GKE Hub-registered cluster to which to apply
        #     the Skaffold configuration. Format is
        #     `projects/{project}/locations/{location}/memberships/{membership_name}`.
        class AnthosCluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information specifying where to deploy a Cloud Run Service.
        # @!attribute [rw] location
        #   @return [::String]
        #     Required. The location for the Cloud Run Service. Format must be
        #     `projects/{project}/locations/{location}`.
        class CloudRunLocation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information specifying a multiTarget.
        # @!attribute [rw] target_ids
        #   @return [::Array<::String>]
        #     Required. The target_ids of this multiTarget.
        class MultiTarget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information specifying a Custom Target.
        # @!attribute [rw] custom_target_type
        #   @return [::String]
        #     Required. The name of the CustomTargetType. Format must be
        #     `projects/{project}/locations/{location}/customTargetTypes/{custom_target_type}`.
        class CustomTarget
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about entities associated with a `Target`.
        # @!attribute [rw] gke_clusters
        #   @return [::Array<::Google::Cloud::Deploy::V1::GkeCluster>]
        #     Optional. Information specifying GKE clusters as associated entities.
        # @!attribute [rw] anthos_clusters
        #   @return [::Array<::Google::Cloud::Deploy::V1::AnthosCluster>]
        #     Optional. Information specifying Anthos clusters as associated entities.
        class AssociatedEntities
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `ListTargets`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of targets. Format must be
        #     `projects/{project_id}/locations/{location_name}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of `Target` objects to return. The service may
        #     return fewer than this value. If unspecified, at most 50 `Target` objects
        #     will be returned. The maximum value is 1000; values above 1000 will be set
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListTargets` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other provided parameters match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter targets to be returned. See https://google.aip.dev/160 for
        #     more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. See https://google.aip.dev/132#ordering for
        #     more details.
        class ListTargetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from `ListTargets`.
        # @!attribute [rw] targets
        #   @return [::Array<::Google::Cloud::Deploy::V1::Target>]
        #     The `Target` objects.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListTargetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `GetTarget`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the `Target`. Format must be
        #     `projects/{project_id}/locations/{location_name}/targets/{target_name}`.
        class GetTargetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `CreateTarget`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent collection in which the `Target` must be created.
        #     The format is
        #     `projects/{project_id}/locations/{location_name}`.
        # @!attribute [rw] target_id
        #   @return [::String]
        #     Required. ID of the `Target`.
        # @!attribute [rw] target
        #   @return [::Google::Cloud::Deploy::V1::Target]
        #     Required. The `Target` to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, the request is validated and the user is provided
        #     with an expected result, but no actual change is made.
        class CreateTargetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `UpdateTarget`.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten by the
        #     update in the `Target` resource. The fields specified in the update_mask
        #     are relative to the resource, not the full request. A field will be
        #     overwritten if it's in the mask. If the user doesn't provide a mask then
        #     all fields are overwritten.
        # @!attribute [rw] target
        #   @return [::Google::Cloud::Deploy::V1::Target]
        #     Required. The `Target` to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, updating a `Target` that does not exist will
        #     result in the creation of a new `Target`.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, the request is validated and the user is provided
        #     with an expected result, but no actual change is made.
        class UpdateTargetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `DeleteTarget`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the `Target` to delete. The format is
        #     `projects/{project_id}/locations/{location_name}/targets/{target_name}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, then deleting an already deleted or non-existing
        #     `Target` will succeed.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     actually post it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        class DeleteTargetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A `CustomTargetType` resource in the Cloud Deploy API.
        #
        # A `CustomTargetType` defines a type of custom target that can be referenced
        # in a `Target` in order to facilitate deploying to other systems besides the
        # supported runtimes.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the `CustomTargetType`. Format is
        #     `projects/{project}/locations/{location}/customTargetTypes/{customTargetType}`.
        #     The `customTargetType` component must match
        #     `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
        # @!attribute [r] custom_target_type_id
        #   @return [::String]
        #     Output only. Resource id of the `CustomTargetType`.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Unique identifier of the `CustomTargetType`.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the `CustomTargetType`. Max length is 255
        #     characters.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User annotations. These attributes can only be set and used by
        #     the user, and not by Cloud Deploy. See
        #     https://google.aip.dev/128#annotations for more details such as format and
        #     size limitations.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels are attributes that can be set and used by both the
        #     user and by Cloud Deploy. Labels must meet the following constraints:
        #
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #     underscores, and dashes.
        #     * All characters must use UTF-8 encoding, and international characters are
        #     allowed.
        #     * Keys must start with a lowercase letter or international character.
        #     * Each resource is limited to a maximum of 64 labels.
        #
        #     Both keys and values are additionally constrained to be <= 128 bytes.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the `CustomTargetType` was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Most recent time at which the `CustomTargetType` was updated.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [rw] custom_actions
        #   @return [::Google::Cloud::Deploy::V1::CustomTargetSkaffoldActions]
        #     Optional. Configures render and deploy for the `CustomTargetType` using
        #     Skaffold custom actions.
        class CustomTargetType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # CustomTargetSkaffoldActions represents the `CustomTargetType` configuration
        # using Skaffold custom actions.
        # @!attribute [rw] render_action
        #   @return [::String]
        #     Optional. The Skaffold custom action responsible for render operations. If
        #     not provided then Cloud Deploy will perform the render operations via
        #     `skaffold render`.
        # @!attribute [rw] deploy_action
        #   @return [::String]
        #     Required. The Skaffold custom action responsible for deploy operations.
        # @!attribute [rw] include_skaffold_modules
        #   @return [::Array<::Google::Cloud::Deploy::V1::SkaffoldModules>]
        #     Optional. List of Skaffold modules Cloud Deploy will include in the
        #     Skaffold Config as required before performing diagnose.
        class CustomTargetSkaffoldActions
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Skaffold Config modules and their remote source.
        # @!attribute [rw] configs
        #   @return [::Array<::String>]
        #     Optional. The Skaffold Config modules to use from the specified source.
        # @!attribute [rw] git
        #   @return [::Google::Cloud::Deploy::V1::SkaffoldModules::SkaffoldGitSource]
        #     Optional. Remote git repository containing the Skaffold Config modules.
        #
        #     Note: The following fields are mutually exclusive: `git`, `google_cloud_storage`, `google_cloud_build_repo`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] google_cloud_storage
        #   @return [::Google::Cloud::Deploy::V1::SkaffoldModules::SkaffoldGCSSource]
        #     Optional. Cloud Storage bucket containing the Skaffold Config modules.
        #
        #     Note: The following fields are mutually exclusive: `google_cloud_storage`, `git`, `google_cloud_build_repo`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] google_cloud_build_repo
        #   @return [::Google::Cloud::Deploy::V1::SkaffoldModules::SkaffoldGCBRepoSource]
        #     Optional. Cloud Build V2 repository containing the Skaffold Config
        #     modules.
        #
        #     Note: The following fields are mutually exclusive: `google_cloud_build_repo`, `git`, `google_cloud_storage`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class SkaffoldModules
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Git repository containing Skaffold Config modules.
          # @!attribute [rw] repo
          #   @return [::String]
          #     Required. Git repository the package should be cloned from.
          # @!attribute [rw] path
          #   @return [::String]
          #     Optional. Relative path from the repository root to the Skaffold file.
          # @!attribute [rw] ref
          #   @return [::String]
          #     Optional. Git branch or tag to use when cloning the repository.
          class SkaffoldGitSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Cloud Storage bucket containing Skaffold Config modules.
          # @!attribute [rw] source
          #   @return [::String]
          #     Required. Cloud Storage source paths to copy recursively. For example,
          #     providing "gs://my-bucket/dir/configs/*" will result in Skaffold copying
          #     all files within the "dir/configs" directory in the bucket "my-bucket".
          # @!attribute [rw] path
          #   @return [::String]
          #     Optional. Relative path from the source to the Skaffold file.
          class SkaffoldGCSSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Cloud Build V2 Repository containing Skaffold Configs.
          # @!attribute [rw] repository
          #   @return [::String]
          #     Required. Name of the Cloud Build V2 Repository.
          #     Format is
          #     projects/\\{project}/locations/\\{location}/connections/\\{connection}/repositories/\\{repository}.
          # @!attribute [rw] path
          #   @return [::String]
          #     Optional. Relative path from the repository root to the Skaffold Config
          #     file.
          # @!attribute [rw] ref
          #   @return [::String]
          #     Optional. Branch or tag to use when cloning the repository.
          class SkaffoldGCBRepoSource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The request object for `ListCustomTargetTypes`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent that owns this collection of custom target types.
        #     Format must be `projects/{project_id}/locations/{location_name}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of `CustomTargetType` objects to return. The
        #     service may return fewer than this value. If unspecified, at most 50
        #     `CustomTargetType` objects will be returned. The maximum value is 1000;
        #     values above 1000 will be set to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListCustomTargetTypes`
        #     call. Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other provided parameters match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter custom target types to be returned. See
        #     https://google.aip.dev/160 for more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. See https://google.aip.dev/132#ordering for
        #     more details.
        class ListCustomTargetTypesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from `ListCustomTargetTypes.`
        # @!attribute [rw] custom_target_types
        #   @return [::Array<::Google::Cloud::Deploy::V1::CustomTargetType>]
        #     The `CustomTargetType` objects.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListCustomTargetTypesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `GetCustomTargetType`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the `CustomTargetType`. Format must be
        #     `projects/{project_id}/locations/{location_name}/customTargetTypes/{custom_target_type}`.
        class GetCustomTargetTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `CreateCustomTargetType`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent collection in which the `CustomTargetType` must be
        #     created. The format is `projects/{project_id}/locations/{location_name}`.
        # @!attribute [rw] custom_target_type_id
        #   @return [::String]
        #     Required. ID of the `CustomTargetType`.
        # @!attribute [rw] custom_target_type
        #   @return [::Google::Cloud::Deploy::V1::CustomTargetType]
        #     Required. The `CustomTargetType` to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, the request is validated and the user is provided
        #     with an expected result, but no actual change is made.
        class CreateCustomTargetTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `UpdateCustomTargetType`.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten by the
        #     update in the `CustomTargetType` resource. The fields specified in the
        #     update_mask are relative to the resource, not the full request. A field
        #     will be overwritten if it's in the mask. If the user doesn't provide a mask
        #     then all fields are overwritten.
        # @!attribute [rw] custom_target_type
        #   @return [::Google::Cloud::Deploy::V1::CustomTargetType]
        #     Required. The `CustomTargetType` to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, updating a `CustomTargetType` that does not exist
        #     will result in the creation of a new `CustomTargetType`.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, the request is validated and the user is provided
        #     with an expected result, but no actual change is made.
        class UpdateCustomTargetTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `DeleteCustomTargetType`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the `CustomTargetType` to delete. Format must be
        #     `projects/{project_id}/locations/{location_name}/customTargetTypes/{custom_target_type}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, then deleting an already deleted or non-existing
        #     `CustomTargetType` will succeed.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, the request is validated but no actual change is
        #     made.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        class DeleteCustomTargetTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A `DeployPolicy` resource in the Cloud Deploy API.
        #
        # A `DeployPolicy` inhibits manual or automation-driven actions within a
        # Delivery Pipeline or Target.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the `DeployPolicy`. Format is
        #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
        #     The `deployPolicy` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Unique identifier of the `DeployPolicy`.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the `DeployPolicy`. Max length is 255 characters.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User annotations. These attributes can only be set and used by
        #     the user, and not by Cloud Deploy. Annotations must meet the following
        #     constraints:
        #
        #     * Annotations are key/value pairs.
        #     * Valid annotation keys have two segments: an optional prefix and name,
        #     separated by a slash (`/`).
        #     * The name segment is required and must be 63 characters or less,
        #     beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
        #     dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
        #     * The prefix is optional. If specified, the prefix must be a DNS subdomain:
        #     a series of DNS labels separated by dots(`.`), not longer than 253
        #     characters in total, followed by a slash (`/`).
        #
        #     See
        #     https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
        #     for more details.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels are attributes that can be set and used by both the
        #     user and by Cloud Deploy. Labels must meet the following constraints:
        #
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #     underscores, and dashes.
        #     * All characters must use UTF-8 encoding, and international characters are
        #     allowed.
        #     * Keys must start with a lowercase letter or international character.
        #     * Each resource is limited to a maximum of 64 labels.
        #
        #     Both keys and values are additionally constrained to be <= 128 bytes.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the deploy policy was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Most recent time at which the deploy policy was updated.
        # @!attribute [rw] suspended
        #   @return [::Boolean]
        #     Optional. When suspended, the policy will not prevent actions from
        #     occurring, even if the action violates the policy.
        # @!attribute [rw] selectors
        #   @return [::Array<::Google::Cloud::Deploy::V1::DeployPolicyResourceSelector>]
        #     Required. Selected resources to which the policy will be applied. At least
        #     one selector is required. If one selector matches the resource the policy
        #     applies. For example, if there are two selectors and the action being
        #     attempted matches one of them, the policy will apply to that action.
        # @!attribute [rw] rules
        #   @return [::Array<::Google::Cloud::Deploy::V1::PolicyRule>]
        #     Required. Rules to apply. At least one rule must be present.
        # @!attribute [rw] etag
        #   @return [::String]
        #     The weak etag of the `DeployPolicy` resource.
        #     This checksum is computed by the server based on the value of other
        #     fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        class DeployPolicy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # What invoked the action. Filters enforcing the policy depending on what
          # invoked the action.
          module Invoker
            # Unspecified.
            INVOKER_UNSPECIFIED = 0

            # The action is user-driven. For example, creating a rollout manually via a
            # gcloud create command.
            USER = 1

            # Automated action by Cloud Deploy.
            DEPLOY_AUTOMATION = 2
          end
        end

        # Contains information on the resources to select for a deploy policy.
        # Attributes provided must all match the resource in order for policy
        # restrictions to apply. For example, if delivery pipelines attributes given
        # are an id "prod" and labels "foo: bar", a delivery pipeline resource must
        # match both that id and have that label in order to be subject to the policy.
        # @!attribute [rw] delivery_pipeline
        #   @return [::Google::Cloud::Deploy::V1::DeliveryPipelineAttribute]
        #     Optional. Contains attributes about a delivery pipeline.
        # @!attribute [rw] target
        #   @return [::Google::Cloud::Deploy::V1::TargetAttribute]
        #     Optional. Contains attributes about a target.
        class DeployPolicyResourceSelector
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains criteria for selecting DeliveryPipelines.
        # @!attribute [rw] id
        #   @return [::String]
        #     Optional. ID of the `DeliveryPipeline`. The value of this field could be
        #     one of the following:
        #
        #     * The last segment of a pipeline name
        #     * "*", all delivery pipelines in a location
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     DeliveryPipeline labels.
        class DeliveryPipelineAttribute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Contains criteria for selecting Targets. This could be used to select targets
        # for a Deploy Policy or for an Automation.
        # @!attribute [rw] id
        #   @return [::String]
        #     Optional. ID of the `Target`. The value of this field could be one of the
        #     following:
        #
        #     * The last segment of a target name
        #     * "*", all targets in a location
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Target labels.
        class TargetAttribute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Deploy Policy rule.
        # @!attribute [rw] rollout_restriction
        #   @return [::Google::Cloud::Deploy::V1::RolloutRestriction]
        #     Optional. Rollout restrictions.
        class PolicyRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Rollout restrictions.
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. Restriction rule ID. Required and must be unique within a
        #     DeployPolicy. The format is `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
        # @!attribute [rw] invokers
        #   @return [::Array<::Google::Cloud::Deploy::V1::DeployPolicy::Invoker>]
        #     Optional. What invoked the action. If left empty, all invoker types will be
        #     restricted.
        # @!attribute [rw] actions
        #   @return [::Array<::Google::Cloud::Deploy::V1::RolloutRestriction::RolloutActions>]
        #     Optional. Rollout actions to be restricted as part of the policy. If left
        #     empty, all actions will be restricted.
        # @!attribute [rw] time_windows
        #   @return [::Google::Cloud::Deploy::V1::TimeWindows]
        #     Required. Time window within which actions are restricted.
        class RolloutRestriction
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Rollout actions to be restricted as part of the policy.
          module RolloutActions
            # Unspecified.
            ROLLOUT_ACTIONS_UNSPECIFIED = 0

            # Advance the rollout to the next phase.
            ADVANCE = 1

            # Approve the rollout.
            APPROVE = 2

            # Cancel the rollout.
            CANCEL = 3

            # Create a rollout.
            CREATE = 4

            # Ignore a job result on the rollout.
            IGNORE_JOB = 5

            # Retry a job for a rollout.
            RETRY_JOB = 6

            # Rollback a rollout.
            ROLLBACK = 7

            # Terminate a jobrun.
            TERMINATE_JOBRUN = 8
          end
        end

        # Time windows within which actions are restricted. See the
        # [documentation](https://cloud.google.com/deploy/docs/deploy-policy#dates_times)
        # for more information on how to configure dates/times.
        # @!attribute [rw] time_zone
        #   @return [::String]
        #     Required. The time zone in IANA format [IANA Time Zone
        #     Database](https://www.iana.org/time-zones) (e.g. America/New_York).
        # @!attribute [rw] one_time_windows
        #   @return [::Array<::Google::Cloud::Deploy::V1::OneTimeWindow>]
        #     Optional. One-time windows within which actions are restricted.
        # @!attribute [rw] weekly_windows
        #   @return [::Array<::Google::Cloud::Deploy::V1::WeeklyWindow>]
        #     Optional. Recurring weekly windows within which actions are restricted.
        class TimeWindows
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # One-time window within which actions are restricted. For example, blocking
        # actions over New Year's Eve from December 31st at 5pm to January 1st at 9am.
        # @!attribute [rw] start_date
        #   @return [::Google::Type::Date]
        #     Required. Start date.
        # @!attribute [rw] start_time
        #   @return [::Google::Type::TimeOfDay]
        #     Required. Start time (inclusive). Use 00:00 for the beginning of the day.
        # @!attribute [rw] end_date
        #   @return [::Google::Type::Date]
        #     Required. End date.
        # @!attribute [rw] end_time
        #   @return [::Google::Type::TimeOfDay]
        #     Required. End time (exclusive). You may use 24:00 for the end of the day.
        class OneTimeWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Weekly windows. For example, blocking actions every Saturday and Sunday.
        # Another example would be blocking actions every weekday from 5pm to midnight.
        # @!attribute [rw] days_of_week
        #   @return [::Array<::Google::Type::DayOfWeek>]
        #     Optional. Days of week. If left empty, all days of the week will be
        #     included.
        # @!attribute [rw] start_time
        #   @return [::Google::Type::TimeOfDay]
        #     Optional. Start time (inclusive). Use 00:00 for the beginning of the day.
        #     If you specify start_time you must also specify end_time. If left empty,
        #     this will block for the entire day for the days specified in days_of_week.
        # @!attribute [rw] end_time
        #   @return [::Google::Type::TimeOfDay]
        #     Optional. End time (exclusive). Use 24:00 to indicate midnight. If you
        #     specify end_time you must also specify start_time. If left empty, this will
        #     block for the entire day for the days specified in days_of_week.
        class WeeklyWindow
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Returned from an action if one or more policies were
        # violated, and therefore the action was prevented. Contains information about
        # what policies were violated and why.
        # @!attribute [rw] policy_violation_details
        #   @return [::Array<::Google::Cloud::Deploy::V1::PolicyViolationDetails>]
        #     Policy violation details.
        class PolicyViolation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Policy violation details.
        # @!attribute [rw] policy
        #   @return [::String]
        #     Name of the policy that was violated.
        #     Policy resource will be in the format of
        #     `projects/{project}/locations/{location}/policies/{policy}`.
        # @!attribute [rw] rule_id
        #   @return [::String]
        #     Id of the rule that triggered the policy violation.
        # @!attribute [rw] failure_message
        #   @return [::String]
        #     User readable message about why the request violated a policy. This is not
        #     intended for machine parsing.
        class PolicyViolationDetails
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A `Release` resource in the Cloud Deploy API.
        #
        # A `Release` defines a specific Skaffold configuration instance
        # that can be deployed.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the `Release`. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}`.
        #     The `release` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Unique identifier of the `Release`.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the `Release`. Max length is 255 characters.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User annotations. These attributes can only be set and used by
        #     the user, and not by Cloud Deploy. See
        #     https://google.aip.dev/128#annotations for more details such as format and
        #     size limitations.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels are attributes that can be set and used by both the
        #     user and by Cloud Deploy. Labels must meet the following constraints:
        #
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #     underscores, and dashes.
        #     * All characters must use UTF-8 encoding, and international characters are
        #     allowed.
        #     * Keys must start with a lowercase letter or international character.
        #     * Each resource is limited to a maximum of 64 labels.
        #
        #     Both keys and values are additionally constrained to be <= 128 bytes.
        # @!attribute [r] abandoned
        #   @return [::Boolean]
        #     Output only. Indicates whether this is an abandoned release.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the `Release` was created.
        # @!attribute [r] render_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the render began.
        # @!attribute [r] render_end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the render completed.
        # @!attribute [rw] skaffold_config_uri
        #   @return [::String]
        #     Optional. Cloud Storage URI of tar.gz archive containing Skaffold
        #     configuration.
        # @!attribute [rw] skaffold_config_path
        #   @return [::String]
        #     Optional. Filepath of the Skaffold config inside of the config URI.
        # @!attribute [rw] build_artifacts
        #   @return [::Array<::Google::Cloud::Deploy::V1::BuildArtifact>]
        #     Optional. List of artifacts to pass through to Skaffold command.
        # @!attribute [r] delivery_pipeline_snapshot
        #   @return [::Google::Cloud::Deploy::V1::DeliveryPipeline]
        #     Output only. Snapshot of the parent pipeline taken at release creation
        #     time.
        # @!attribute [r] target_snapshots
        #   @return [::Array<::Google::Cloud::Deploy::V1::Target>]
        #     Output only. Snapshot of the targets taken at release creation time.
        # @!attribute [r] custom_target_type_snapshots
        #   @return [::Array<::Google::Cloud::Deploy::V1::CustomTargetType>]
        #     Output only. Snapshot of the custom target types referenced by the targets
        #     taken at release creation time.
        # @!attribute [r] render_state
        #   @return [::Google::Cloud::Deploy::V1::Release::RenderState]
        #     Output only. Current state of the render operation.
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of other
        #     fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [rw] skaffold_version
        #   @return [::String]
        #     Optional. The Skaffold version to use when operating on this release, such
        #     as "1.20.0". Not all versions are valid; Cloud Deploy supports a specific
        #     set of versions.
        #
        #     If unset, the most recent supported Skaffold version will be used.
        # @!attribute [r] target_artifacts
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Deploy::V1::TargetArtifact}]
        #     Output only. Map from target ID to the target artifacts created
        #     during the render operation.
        # @!attribute [r] target_renders
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Deploy::V1::Release::TargetRender}]
        #     Output only. Map from target ID to details of the render operation for that
        #     target.
        # @!attribute [r] condition
        #   @return [::Google::Cloud::Deploy::V1::Release::ReleaseCondition]
        #     Output only. Information around the state of the Release.
        # @!attribute [rw] deploy_parameters
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The deploy parameters to use for all targets in this release.
        class Release
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Details of rendering for a single target.
          # @!attribute [r] rendering_build
          #   @return [::String]
          #     Output only. The resource name of the Cloud Build `Build` object that is
          #     used to render the manifest for this target. Format is
          #     `projects/{project}/locations/{location}/builds/{build}`.
          # @!attribute [r] rendering_state
          #   @return [::Google::Cloud::Deploy::V1::Release::TargetRender::TargetRenderState]
          #     Output only. Current state of the render operation for this Target.
          # @!attribute [r] metadata
          #   @return [::Google::Cloud::Deploy::V1::RenderMetadata]
          #     Output only. Metadata related to the `Release` render for this Target.
          # @!attribute [r] failure_cause
          #   @return [::Google::Cloud::Deploy::V1::Release::TargetRender::FailureCause]
          #     Output only. Reason this render failed. This will always be unspecified
          #     while the render in progress.
          # @!attribute [r] failure_message
          #   @return [::String]
          #     Output only. Additional information about the render failure, if
          #     available.
          class TargetRender
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Valid states of the render operation.
            module TargetRenderState
              # The render operation state is unspecified.
              TARGET_RENDER_STATE_UNSPECIFIED = 0

              # The render operation has completed successfully.
              SUCCEEDED = 1

              # The render operation has failed.
              FAILED = 2

              # The render operation is in progress.
              IN_PROGRESS = 3
            end

            # Well-known rendering failures.
            module FailureCause
              # No reason for failure is specified.
              FAILURE_CAUSE_UNSPECIFIED = 0

              # Cloud Build is not available, either because it is not enabled or
              # because Cloud Deploy has insufficient permissions. See [required
              # permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
              CLOUD_BUILD_UNAVAILABLE = 1

              # The render operation did not complete successfully; check Cloud Build
              # logs.
              EXECUTION_FAILED = 2

              # Cloud Build failed to fulfill Cloud Deploy's request. See
              # failure_message for additional details.
              CLOUD_BUILD_REQUEST_FAILED = 3

              # The render operation did not complete successfully because the
              # verification stanza required for verify was not found on the Skaffold
              # configuration.
              VERIFICATION_CONFIG_NOT_FOUND = 4

              # The render operation did not complete successfully because the custom
              # action(s) required for Rollout jobs were not found in the Skaffold
              # configuration. See failure_message for additional details.
              CUSTOM_ACTION_NOT_FOUND = 5

              # Release failed during rendering because the release configuration is
              # not supported with the specified deployment strategy.
              DEPLOYMENT_STRATEGY_NOT_SUPPORTED = 6

              # The render operation had a feature configured that is not supported.
              RENDER_FEATURE_NOT_SUPPORTED = 7
            end
          end

          # ReleaseReadyCondition contains information around the status of the
          # Release. If a release is not ready, you cannot create a rollout with the
          # release.
          # @!attribute [rw] status
          #   @return [::Boolean]
          #     True if the Release is in a valid state. Otherwise at least one condition
          #     in `ReleaseCondition` is in an invalid state. Iterate over those
          #     conditions and see which condition(s) has status = false to find out what
          #     is wrong with the Release.
          class ReleaseReadyCondition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # SkaffoldSupportedCondition contains information about when support for the
          # release's version of Skaffold ends.
          # @!attribute [rw] status
          #   @return [::Boolean]
          #     True if the version of Skaffold used by this release is supported.
          # @!attribute [rw] skaffold_support_state
          #   @return [::Google::Cloud::Deploy::V1::SkaffoldSupportState]
          #     The Skaffold support state for this release's version of Skaffold.
          # @!attribute [rw] maintenance_mode_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which this release's version of Skaffold will enter
          #     maintenance mode.
          # @!attribute [rw] support_expiration_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The time at which this release's version of Skaffold will no longer be
          #     supported.
          class SkaffoldSupportedCondition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # ReleaseCondition contains all conditions relevant to a Release.
          # @!attribute [rw] release_ready_condition
          #   @return [::Google::Cloud::Deploy::V1::Release::ReleaseReadyCondition]
          #     Details around the Releases's overall status.
          # @!attribute [rw] skaffold_supported_condition
          #   @return [::Google::Cloud::Deploy::V1::Release::SkaffoldSupportedCondition]
          #     Details around the support state of the release's Skaffold
          #     version.
          class ReleaseCondition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Deploy::V1::TargetArtifact]
          class TargetArtifactsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Deploy::V1::Release::TargetRender]
          class TargetRendersEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class DeployParametersEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Valid states of the render operation.
          module RenderState
            # The render state is unspecified.
            RENDER_STATE_UNSPECIFIED = 0

            # All rendering operations have completed successfully.
            SUCCEEDED = 1

            # All rendering operations have completed, and one or more have failed.
            FAILED = 2

            # Rendering has started and is not complete.
            IN_PROGRESS = 3
          end
        end

        # The request object for `CreateDeployPolicy`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent collection in which the `DeployPolicy` must be
        #     created. The format is `projects/{project_id}/locations/{location_name}`.
        # @!attribute [rw] deploy_policy_id
        #   @return [::String]
        #     Required. ID of the `DeployPolicy`.
        # @!attribute [rw] deploy_policy
        #   @return [::Google::Cloud::Deploy::V1::DeployPolicy]
        #     Required. The `DeployPolicy` to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, the request is validated and the user is provided
        #     with an expected result, but no actual change is made.
        class CreateDeployPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `UpdateDeployPolicy`.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten by the
        #     update in the `DeployPolicy` resource. The fields specified in the
        #     update_mask are relative to the resource, not the full request. A field
        #     will be overwritten if it's in the mask. If the user doesn't provide a mask
        #     then all fields are overwritten.
        # @!attribute [rw] deploy_policy
        #   @return [::Google::Cloud::Deploy::V1::DeployPolicy]
        #     Required. The `DeployPolicy` to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, updating a `DeployPolicy` that does not exist
        #     will result in the creation of a new `DeployPolicy`.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, the request is validated and the user is provided
        #     with an expected result, but no actual change is made.
        class UpdateDeployPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `DeleteDeployPolicy`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the `DeployPolicy` to delete. The format is
        #     `projects/{project_id}/locations/{location_name}/deployPolicies/{deploy_policy_name}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, then deleting an already deleted or non-existing
        #     `DeployPolicy` will succeed.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and preview the review, but do not
        #     actually post it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        class DeleteDeployPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `ListDeployPolicies`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of deploy policies. Format
        #     must be `projects/{project_id}/locations/{location_name}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of deploy policies to return. The service may return
        #     fewer than this value. If unspecified, at most 50 deploy policies will
        #     be returned. The maximum value is 1000; values above 1000 will be set
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListDeployPolicies` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other provided parameters match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter deploy policies to be returned. See https://google.aip.dev/160 for
        #     more details. All fields can be used in the filter.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
        class ListDeployPoliciesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from `ListDeployPolicies`.
        # @!attribute [rw] deploy_policies
        #   @return [::Array<::Google::Cloud::Deploy::V1::DeployPolicy>]
        #     The `DeployPolicy` objects.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDeployPoliciesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `GetDeployPolicy`
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the `DeployPolicy`. Format must be
        #     `projects/{project_id}/locations/{location_name}/deployPolicies/{deploy_policy_name}`.
        class GetDeployPolicyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Description of an a image to use during Skaffold rendering.
        # @!attribute [rw] image
        #   @return [::String]
        #     Optional. Image name in Skaffold configuration.
        # @!attribute [rw] tag
        #   @return [::String]
        #     Optional. Image tag to use. This will generally be the full path to an
        #     image, such as "gcr.io/my-project/busybox:1.2.3" or
        #     "gcr.io/my-project/busybox@sha256:abc123".
        class BuildArtifact
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The artifacts produced by a target render operation.
        # @!attribute [r] artifact_uri
        #   @return [::String]
        #     Output only. URI of a directory containing the artifacts. This contains
        #     deployment configuration used by Skaffold during a rollout, and all
        #     paths are relative to this location.
        # @!attribute [r] skaffold_config_path
        #   @return [::String]
        #     Output only. File path of the resolved Skaffold configuration for the
        #     stable phase, relative to the URI.
        # @!attribute [r] manifest_path
        #   @return [::String]
        #     Output only. File path of the rendered manifest relative to the URI for the
        #     stable phase.
        # @!attribute [r] phase_artifacts
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Deploy::V1::TargetArtifact::PhaseArtifact}]
        #     Output only. Map from the phase ID to the phase artifacts for the `Target`.
        class TargetArtifact
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Contains the paths to the artifacts, relative to the URI, for a phase.
          # @!attribute [r] skaffold_config_path
          #   @return [::String]
          #     Output only. File path of the resolved Skaffold configuration relative to
          #     the URI.
          # @!attribute [r] manifest_path
          #   @return [::String]
          #     Output only. File path of the rendered manifest relative to the URI.
          # @!attribute [r] job_manifests_path
          #   @return [::String]
          #     Output only. File path of the directory of rendered job manifests
          #     relative to the URI. This is only set if it is applicable.
          class PhaseArtifact
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Deploy::V1::TargetArtifact::PhaseArtifact]
          class PhaseArtifactsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The artifacts produced by a deploy operation.
        # @!attribute [r] artifact_uri
        #   @return [::String]
        #     Output only. URI of a directory containing the artifacts. All paths are
        #     relative to this location.
        # @!attribute [r] manifest_paths
        #   @return [::Array<::String>]
        #     Output only. File paths of the manifests applied during the deploy
        #     operation relative to the URI.
        class DeployArtifact
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CloudRunRenderMetadata contains Cloud Run information associated with a
        # `Release` render.
        # @!attribute [r] service
        #   @return [::String]
        #     Output only. The name of the Cloud Run Service in the rendered manifest.
        #     Format is `projects/{project}/locations/{location}/services/{service}`.
        class CloudRunRenderMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RenderMetadata includes information associated with a `Release` render.
        # @!attribute [r] cloud_run
        #   @return [::Google::Cloud::Deploy::V1::CloudRunRenderMetadata]
        #     Output only. Metadata associated with rendering for Cloud Run.
        # @!attribute [r] custom
        #   @return [::Google::Cloud::Deploy::V1::CustomMetadata]
        #     Output only. Custom metadata provided by user-defined render operation.
        class RenderMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `ListReleases`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The `DeliveryPipeline` which owns this collection of `Release`
        #     objects.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of `Release` objects to return. The service
        #     may return fewer than this value. If unspecified, at most 50 `Release`
        #     objects will be returned. The maximum value is 1000; values above 1000 will
        #     be set to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListReleases` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other provided parameters match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter releases to be returned. See https://google.aip.dev/160
        #     for more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. See https://google.aip.dev/132#ordering for
        #     more details.
        class ListReleasesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from `ListReleases`.
        # @!attribute [rw] releases
        #   @return [::Array<::Google::Cloud::Deploy::V1::Release>]
        #     The `Release` objects.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListReleasesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `GetRelease`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the `Release`. Format must be
        #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}`.
        class GetReleaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `CreateRelease`,
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent collection in which the `Release` is created.
        #     The format is
        #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
        # @!attribute [rw] release_id
        #   @return [::String]
        #     Required. ID of the `Release`.
        # @!attribute [rw] release
        #   @return [::Google::Cloud::Deploy::V1::Release]
        #     Required. The `Release` to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, the request is validated and the user is provided
        #     with an expected result, but no actual change is made.
        # @!attribute [rw] override_deploy_policy
        #   @return [::Array<::String>]
        #     Optional. Deploy policies to override. Format is
        #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
        class CreateReleaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A `Rollout` resource in the Cloud Deploy API.
        #
        # A `Rollout` contains information around a specific deployment to a `Target`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. Name of the `Rollout`. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
        #     The `rollout` component must match `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Unique identifier of the `Rollout`.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the `Rollout` for user purposes. Max length is 255
        #     characters.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User annotations. These attributes can only be set and used by
        #     the user, and not by Cloud Deploy. See
        #     https://google.aip.dev/128#annotations for more details such as format and
        #     size limitations.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels are attributes that can be set and used by both the
        #     user and by Cloud Deploy. Labels must meet the following constraints:
        #
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #     underscores, and dashes.
        #     * All characters must use UTF-8 encoding, and international characters are
        #     allowed.
        #     * Keys must start with a lowercase letter or international character.
        #     * Each resource is limited to a maximum of 64 labels.
        #
        #     Both keys and values are additionally constrained to be <= 128 bytes.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the `Rollout` was created.
        # @!attribute [r] approve_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the `Rollout` was approved.
        # @!attribute [r] enqueue_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the `Rollout` was enqueued.
        # @!attribute [r] deploy_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the `Rollout` started deploying.
        # @!attribute [r] deploy_end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the `Rollout` finished deploying.
        # @!attribute [rw] target_id
        #   @return [::String]
        #     Required. The ID of Target to which this `Rollout` is deploying.
        # @!attribute [r] approval_state
        #   @return [::Google::Cloud::Deploy::V1::Rollout::ApprovalState]
        #     Output only. Approval state of the `Rollout`.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Deploy::V1::Rollout::State]
        #     Output only. Current state of the `Rollout`.
        # @!attribute [r] failure_reason
        #   @return [::String]
        #     Output only. Additional information about the rollout failure, if
        #     available.
        # @!attribute [r] deploying_build
        #   @return [::String]
        #     Output only. The resource name of the Cloud Build `Build` object that is
        #     used to deploy the Rollout. Format is
        #     `projects/{project}/locations/{location}/builds/{build}`.
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of other
        #     fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [r] deploy_failure_cause
        #   @return [::Google::Cloud::Deploy::V1::Rollout::FailureCause]
        #     Output only. The reason this rollout failed. This will always be
        #     unspecified while the rollout is in progress.
        # @!attribute [r] phases
        #   @return [::Array<::Google::Cloud::Deploy::V1::Phase>]
        #     Output only. The phases that represent the workflows of this `Rollout`.
        # @!attribute [r] metadata
        #   @return [::Google::Cloud::Deploy::V1::Metadata]
        #     Output only. Metadata contains information about the rollout.
        # @!attribute [r] controller_rollout
        #   @return [::String]
        #     Output only. Name of the `ControllerRollout`. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
        # @!attribute [r] rollback_of_rollout
        #   @return [::String]
        #     Output only. Name of the `Rollout` that is rolled back by this `Rollout`.
        #     Empty if this `Rollout` wasn't created as a rollback.
        # @!attribute [r] rolled_back_by_rollouts
        #   @return [::Array<::String>]
        #     Output only. Names of `Rollouts` that rolled back this `Rollout`.
        # @!attribute [r] active_repair_automation_run
        #   @return [::String]
        #     Output only. The AutomationRun actively repairing the rollout.
        class Rollout
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Valid approval states of a `Rollout`.
          module ApprovalState
            # The `Rollout` has an unspecified approval state.
            APPROVAL_STATE_UNSPECIFIED = 0

            # The `Rollout` requires approval.
            NEEDS_APPROVAL = 1

            # The `Rollout` does not require approval.
            DOES_NOT_NEED_APPROVAL = 2

            # The `Rollout` has been approved.
            APPROVED = 3

            # The `Rollout` has been rejected.
            REJECTED = 4
          end

          # Valid states of a `Rollout`.
          module State
            # The `Rollout` has an unspecified state.
            STATE_UNSPECIFIED = 0

            # The `Rollout` has completed successfully.
            SUCCEEDED = 1

            # The `Rollout` has failed.
            FAILED = 2

            # The `Rollout` is being deployed.
            IN_PROGRESS = 3

            # The `Rollout` needs approval.
            PENDING_APPROVAL = 4

            # An approver rejected the `Rollout`.
            APPROVAL_REJECTED = 5

            # The `Rollout` is waiting for an earlier Rollout(s) to complete on this
            # `Target`.
            PENDING = 6

            # The `Rollout` is waiting for the `Release` to be fully rendered.
            PENDING_RELEASE = 7

            # The `Rollout` is in the process of being cancelled.
            CANCELLING = 8

            # The `Rollout` has been cancelled.
            CANCELLED = 9

            # The `Rollout` is halted.
            HALTED = 10
          end

          # Well-known rollout failures.
          module FailureCause
            # No reason for failure is specified.
            FAILURE_CAUSE_UNSPECIFIED = 0

            # Cloud Build is not available, either because it is not enabled or because
            # Cloud Deploy has insufficient permissions. See [required
            # permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
            CLOUD_BUILD_UNAVAILABLE = 1

            # The deploy operation did not complete successfully; check Cloud Build
            # logs.
            EXECUTION_FAILED = 2

            # Deployment did not complete within the allotted time.
            DEADLINE_EXCEEDED = 3

            # Release is in a failed state.
            RELEASE_FAILED = 4

            # Release is abandoned.
            RELEASE_ABANDONED = 5

            # No Skaffold verify configuration was found.
            VERIFICATION_CONFIG_NOT_FOUND = 6

            # Cloud Build failed to fulfill Cloud Deploy's request. See failure_message
            # for additional details.
            CLOUD_BUILD_REQUEST_FAILED = 7

            # A Rollout operation had a feature configured that is not supported.
            OPERATION_FEATURE_NOT_SUPPORTED = 8
          end
        end

        # Metadata includes information associated with a `Rollout`.
        # @!attribute [r] cloud_run
        #   @return [::Google::Cloud::Deploy::V1::CloudRunMetadata]
        #     Output only. The name of the Cloud Run Service that is associated with a
        #     `Rollout`.
        # @!attribute [r] automation
        #   @return [::Google::Cloud::Deploy::V1::AutomationRolloutMetadata]
        #     Output only. AutomationRolloutMetadata contains the information about the
        #     interactions between Automation service and this rollout.
        # @!attribute [r] custom
        #   @return [::Google::Cloud::Deploy::V1::CustomMetadata]
        #     Output only. Custom metadata provided by user-defined `Rollout` operations.
        class Metadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DeployJobRunMetadata surfaces information associated with a `DeployJobRun` to
        # the user.
        # @!attribute [r] cloud_run
        #   @return [::Google::Cloud::Deploy::V1::CloudRunMetadata]
        #     Output only. The name of the Cloud Run Service that is associated with a
        #     `DeployJobRun`.
        # @!attribute [r] custom_target
        #   @return [::Google::Cloud::Deploy::V1::CustomTargetDeployMetadata]
        #     Output only. Custom Target metadata associated with a `DeployJobRun`.
        # @!attribute [r] custom
        #   @return [::Google::Cloud::Deploy::V1::CustomMetadata]
        #     Output only. Custom metadata provided by user-defined deploy operation.
        class DeployJobRunMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CloudRunMetadata contains information from a Cloud Run deployment.
        # @!attribute [r] service
        #   @return [::String]
        #     Output only. The name of the Cloud Run Service that is associated with a
        #     `Rollout`. Format is
        #     `projects/{project}/locations/{location}/services/{service}`.
        # @!attribute [r] service_urls
        #   @return [::Array<::String>]
        #     Output only. The Cloud Run Service urls that are associated with a
        #     `Rollout`.
        # @!attribute [r] revision
        #   @return [::String]
        #     Output only. The Cloud Run Revision id associated with a `Rollout`.
        # @!attribute [r] job
        #   @return [::String]
        #     Output only. The name of the Cloud Run job that is associated with a
        #     `Rollout`. Format is
        #     `projects/{project}/locations/{location}/jobs/{job_name}`.
        class CloudRunMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CustomTargetDeployMetadata contains information from a Custom Target
        # deploy operation.
        # @!attribute [r] skip_message
        #   @return [::String]
        #     Output only. Skip message provided in the results of a custom deploy
        #     operation.
        class CustomTargetDeployMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AutomationRolloutMetadata contains Automation-related actions that
        # were performed on a rollout.
        # @!attribute [r] promote_automation_run
        #   @return [::String]
        #     Output only. The name of the AutomationRun initiated by a promote release
        #     rule.
        # @!attribute [r] advance_automation_runs
        #   @return [::Array<::String>]
        #     Output only. The names of the AutomationRuns initiated by an advance
        #     rollout rule.
        # @!attribute [r] repair_automation_runs
        #   @return [::Array<::String>]
        #     Output only. The names of the AutomationRuns initiated by a repair rollout
        #     rule.
        class AutomationRolloutMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CustomMetadata contains information from a user-defined operation.
        # @!attribute [r] values
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Output only. Key-value pairs provided by the user-defined operation.
        class CustomMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ValuesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Phase represents a collection of jobs that are logically grouped together
        # for a `Rollout`.
        # @!attribute [r] id
        #   @return [::String]
        #     Output only. The ID of the Phase.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Deploy::V1::Phase::State]
        #     Output only. Current state of the Phase.
        # @!attribute [r] skip_message
        #   @return [::String]
        #     Output only. Additional information on why the Phase was skipped, if
        #     available.
        # @!attribute [r] deployment_jobs
        #   @return [::Google::Cloud::Deploy::V1::DeploymentJobs]
        #     Output only. Deployment job composition.
        #
        #     Note: The following fields are mutually exclusive: `deployment_jobs`, `child_rollout_jobs`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] child_rollout_jobs
        #   @return [::Google::Cloud::Deploy::V1::ChildRolloutJobs]
        #     Output only. ChildRollout job composition.
        #
        #     Note: The following fields are mutually exclusive: `child_rollout_jobs`, `deployment_jobs`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Phase
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Valid states of a Phase.
          module State
            # The Phase has an unspecified state.
            STATE_UNSPECIFIED = 0

            # The Phase is waiting for an earlier Phase(s) to complete.
            PENDING = 1

            # The Phase is in progress.
            IN_PROGRESS = 2

            # The Phase has succeeded.
            SUCCEEDED = 3

            # The Phase has failed.
            FAILED = 4

            # The Phase was aborted.
            ABORTED = 5

            # The Phase was skipped.
            SKIPPED = 6
          end
        end

        # Deployment job composition.
        # @!attribute [r] predeploy_job
        #   @return [::Google::Cloud::Deploy::V1::Job]
        #     Output only. The predeploy Job, which is the first job on the phase.
        # @!attribute [r] deploy_job
        #   @return [::Google::Cloud::Deploy::V1::Job]
        #     Output only. The deploy Job. This is the deploy job in the phase.
        # @!attribute [r] verify_job
        #   @return [::Google::Cloud::Deploy::V1::Job]
        #     Output only. The verify Job. Runs after a deploy if the deploy succeeds.
        # @!attribute [r] postdeploy_job
        #   @return [::Google::Cloud::Deploy::V1::Job]
        #     Output only. The postdeploy Job, which is the last job on the phase.
        class DeploymentJobs
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ChildRollouts job composition
        # @!attribute [r] create_rollout_jobs
        #   @return [::Array<::Google::Cloud::Deploy::V1::Job>]
        #     Output only. List of CreateChildRolloutJobs
        # @!attribute [r] advance_rollout_jobs
        #   @return [::Array<::Google::Cloud::Deploy::V1::Job>]
        #     Output only. List of AdvanceChildRolloutJobs
        class ChildRolloutJobs
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Job represents an operation for a `Rollout`.
        # @!attribute [r] id
        #   @return [::String]
        #     Output only. The ID of the Job.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Deploy::V1::Job::State]
        #     Output only. The current state of the Job.
        # @!attribute [r] skip_message
        #   @return [::String]
        #     Output only. Additional information on why the Job was skipped, if
        #     available.
        # @!attribute [r] job_run
        #   @return [::String]
        #     Output only. The name of the `JobRun` responsible for the most recent
        #     invocation of this Job.
        # @!attribute [r] deploy_job
        #   @return [::Google::Cloud::Deploy::V1::DeployJob]
        #     Output only. A deploy Job.
        #
        #     Note: The following fields are mutually exclusive: `deploy_job`, `verify_job`, `predeploy_job`, `postdeploy_job`, `create_child_rollout_job`, `advance_child_rollout_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] verify_job
        #   @return [::Google::Cloud::Deploy::V1::VerifyJob]
        #     Output only. A verify Job.
        #
        #     Note: The following fields are mutually exclusive: `verify_job`, `deploy_job`, `predeploy_job`, `postdeploy_job`, `create_child_rollout_job`, `advance_child_rollout_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] predeploy_job
        #   @return [::Google::Cloud::Deploy::V1::PredeployJob]
        #     Output only. A predeploy Job.
        #
        #     Note: The following fields are mutually exclusive: `predeploy_job`, `deploy_job`, `verify_job`, `postdeploy_job`, `create_child_rollout_job`, `advance_child_rollout_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] postdeploy_job
        #   @return [::Google::Cloud::Deploy::V1::PostdeployJob]
        #     Output only. A postdeploy Job.
        #
        #     Note: The following fields are mutually exclusive: `postdeploy_job`, `deploy_job`, `verify_job`, `predeploy_job`, `create_child_rollout_job`, `advance_child_rollout_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] create_child_rollout_job
        #   @return [::Google::Cloud::Deploy::V1::CreateChildRolloutJob]
        #     Output only. A createChildRollout Job.
        #
        #     Note: The following fields are mutually exclusive: `create_child_rollout_job`, `deploy_job`, `verify_job`, `predeploy_job`, `postdeploy_job`, `advance_child_rollout_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] advance_child_rollout_job
        #   @return [::Google::Cloud::Deploy::V1::AdvanceChildRolloutJob]
        #     Output only. An advanceChildRollout Job.
        #
        #     Note: The following fields are mutually exclusive: `advance_child_rollout_job`, `deploy_job`, `verify_job`, `predeploy_job`, `postdeploy_job`, `create_child_rollout_job`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Job
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Valid states of a Job.
          module State
            # The Job has an unspecified state.
            STATE_UNSPECIFIED = 0

            # The Job is waiting for an earlier Phase(s) or Job(s) to complete.
            PENDING = 1

            # The Job is disabled.
            DISABLED = 2

            # The Job is in progress.
            IN_PROGRESS = 3

            # The Job succeeded.
            SUCCEEDED = 4

            # The Job failed.
            FAILED = 5

            # The Job was aborted.
            ABORTED = 6

            # The Job was skipped.
            SKIPPED = 7

            # The Job was ignored.
            IGNORED = 8
          end
        end

        # A deploy Job.
        class DeployJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A verify Job.
        class VerifyJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A predeploy Job.
        # @!attribute [r] actions
        #   @return [::Array<::String>]
        #     Output only. The custom actions that the predeploy Job executes.
        class PredeployJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A postdeploy Job.
        # @!attribute [r] actions
        #   @return [::Array<::String>]
        #     Output only. The custom actions that the postdeploy Job executes.
        class PostdeployJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A createChildRollout Job.
        class CreateChildRolloutJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An advanceChildRollout Job.
        class AdvanceChildRolloutJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListRolloutsRequest is the request object used by `ListRollouts`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The `Release` which owns this collection of `Rollout` objects.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of `Rollout` objects to return. The service
        #     may return fewer than this value. If unspecified, at most 50 `Rollout`
        #     objects will be returned. The maximum value is 1000; values above 1000 will
        #     be set to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListRollouts` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other provided parameters match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter rollouts to be returned. See https://google.aip.dev/160
        #     for more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. See https://google.aip.dev/132#ordering for
        #     more details.
        class ListRolloutsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListRolloutsResponse is the response object returned by `ListRollouts`.
        # @!attribute [rw] rollouts
        #   @return [::Array<::Google::Cloud::Deploy::V1::Rollout>]
        #     The `Rollout` objects.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListRolloutsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetRolloutRequest is the request object used by `GetRollout`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the `Rollout`. Format must be
        #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}/rollouts/{rollout_name}`.
        class GetRolloutRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # CreateRolloutRequest is the request object used by `CreateRollout`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent collection in which the `Rollout` must be created.
        #     The format is
        #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}`.
        # @!attribute [rw] rollout_id
        #   @return [::String]
        #     Required. ID of the `Rollout`.
        # @!attribute [rw] rollout
        #   @return [::Google::Cloud::Deploy::V1::Rollout]
        #     Required. The `Rollout` to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, the request is validated and the user is provided
        #     with an expected result, but no actual change is made.
        # @!attribute [rw] override_deploy_policy
        #   @return [::Array<::String>]
        #     Optional. Deploy policies to override. Format is
        #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
        # @!attribute [rw] starting_phase_id
        #   @return [::String]
        #     Optional. The starting phase ID for the `Rollout`. If empty the `Rollout`
        #     will start at the first phase.
        class CreateRolloutRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of the long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have
        #     {::Google::Longrunning::Operation#error google.longrunning.Operation.error}
        #     value with a {::Google::Rpc::Status#code google.rpc.Status.code} of 1,
        #     corresponding to `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object used by `ApproveRollout`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the Rollout. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
        # @!attribute [rw] approved
        #   @return [::Boolean]
        #     Required. True = approve; false = reject
        # @!attribute [rw] override_deploy_policy
        #   @return [::Array<::String>]
        #     Optional. Deploy policies to override. Format is
        #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
        class ApproveRolloutRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from `ApproveRollout`.
        class ApproveRolloutResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object used by `AdvanceRollout`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the Rollout. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
        # @!attribute [rw] phase_id
        #   @return [::String]
        #     Required. The phase ID to advance the `Rollout` to.
        # @!attribute [rw] override_deploy_policy
        #   @return [::Array<::String>]
        #     Optional. Deploy policies to override. Format is
        #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
        class AdvanceRolloutRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from `AdvanceRollout`.
        class AdvanceRolloutResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object used by `CancelRollout`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the Rollout. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
        # @!attribute [rw] override_deploy_policy
        #   @return [::Array<::String>]
        #     Optional. Deploy policies to override. Format is
        #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
        class CancelRolloutRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from `CancelRollout`.
        class CancelRolloutResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object used by `IgnoreJob`.
        # @!attribute [rw] rollout
        #   @return [::String]
        #     Required. Name of the Rollout. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
        # @!attribute [rw] phase_id
        #   @return [::String]
        #     Required. The phase ID the Job to ignore belongs to.
        # @!attribute [rw] job_id
        #   @return [::String]
        #     Required. The job ID for the Job to ignore.
        # @!attribute [rw] override_deploy_policy
        #   @return [::Array<::String>]
        #     Optional. Deploy policies to override. Format is
        #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
        class IgnoreJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from `IgnoreJob`.
        class IgnoreJobResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RetryJobRequest is the request object used by `RetryJob`.
        # @!attribute [rw] rollout
        #   @return [::String]
        #     Required. Name of the Rollout. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
        # @!attribute [rw] phase_id
        #   @return [::String]
        #     Required. The phase ID the Job to retry belongs to.
        # @!attribute [rw] job_id
        #   @return [::String]
        #     Required. The job ID for the Job to retry.
        # @!attribute [rw] override_deploy_policy
        #   @return [::Array<::String>]
        #     Optional. Deploy policies to override. Format is
        #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
        class RetryJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from 'RetryJob'.
        class RetryJobResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object used by `AbandonRelease`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the Release. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}`.
        class AbandonReleaseRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object for `AbandonRelease`.
        class AbandonReleaseResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A `JobRun` resource in the Cloud Deploy API.
        #
        # A `JobRun` contains information of a single `Rollout` job evaluation.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the `JobRun`. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{releases}/rollouts/{rollouts}/jobRuns/{uuid}`.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Unique identifier of the `JobRun`.
        # @!attribute [r] phase_id
        #   @return [::String]
        #     Output only. ID of the `Rollout` phase this `JobRun` belongs in.
        # @!attribute [r] job_id
        #   @return [::String]
        #     Output only. ID of the `Rollout` job this `JobRun` corresponds to.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the `JobRun` was created.
        # @!attribute [r] start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the `JobRun` was started.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the `JobRun` ended.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Deploy::V1::JobRun::State]
        #     Output only. The current state of the `JobRun`.
        # @!attribute [r] deploy_job_run
        #   @return [::Google::Cloud::Deploy::V1::DeployJobRun]
        #     Output only. Information specific to a deploy `JobRun`.
        #
        #     Note: The following fields are mutually exclusive: `deploy_job_run`, `verify_job_run`, `predeploy_job_run`, `postdeploy_job_run`, `create_child_rollout_job_run`, `advance_child_rollout_job_run`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] verify_job_run
        #   @return [::Google::Cloud::Deploy::V1::VerifyJobRun]
        #     Output only. Information specific to a verify `JobRun`.
        #
        #     Note: The following fields are mutually exclusive: `verify_job_run`, `deploy_job_run`, `predeploy_job_run`, `postdeploy_job_run`, `create_child_rollout_job_run`, `advance_child_rollout_job_run`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] predeploy_job_run
        #   @return [::Google::Cloud::Deploy::V1::PredeployJobRun]
        #     Output only. Information specific to a predeploy `JobRun`.
        #
        #     Note: The following fields are mutually exclusive: `predeploy_job_run`, `deploy_job_run`, `verify_job_run`, `postdeploy_job_run`, `create_child_rollout_job_run`, `advance_child_rollout_job_run`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] postdeploy_job_run
        #   @return [::Google::Cloud::Deploy::V1::PostdeployJobRun]
        #     Output only. Information specific to a postdeploy `JobRun`.
        #
        #     Note: The following fields are mutually exclusive: `postdeploy_job_run`, `deploy_job_run`, `verify_job_run`, `predeploy_job_run`, `create_child_rollout_job_run`, `advance_child_rollout_job_run`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] create_child_rollout_job_run
        #   @return [::Google::Cloud::Deploy::V1::CreateChildRolloutJobRun]
        #     Output only. Information specific to a createChildRollout `JobRun`.
        #
        #     Note: The following fields are mutually exclusive: `create_child_rollout_job_run`, `deploy_job_run`, `verify_job_run`, `predeploy_job_run`, `postdeploy_job_run`, `advance_child_rollout_job_run`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] advance_child_rollout_job_run
        #   @return [::Google::Cloud::Deploy::V1::AdvanceChildRolloutJobRun]
        #     Output only. Information specific to an advanceChildRollout `JobRun`
        #
        #     Note: The following fields are mutually exclusive: `advance_child_rollout_job_run`, `deploy_job_run`, `verify_job_run`, `predeploy_job_run`, `postdeploy_job_run`, `create_child_rollout_job_run`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. This checksum is computed by the server based on the value of
        #     other fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        class JobRun
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Valid states of a `JobRun`.
          module State
            # The `JobRun` has an unspecified state.
            STATE_UNSPECIFIED = 0

            # The `JobRun` is in progress.
            IN_PROGRESS = 1

            # The `JobRun` has succeeded.
            SUCCEEDED = 2

            # The `JobRun` has failed.
            FAILED = 3

            # The `JobRun` is terminating.
            TERMINATING = 4

            # The `JobRun` was terminated.
            TERMINATED = 5
          end
        end

        # DeployJobRun contains information specific to a deploy `JobRun`.
        # @!attribute [r] build
        #   @return [::String]
        #     Output only. The resource name of the Cloud Build `Build` object that is
        #     used to deploy. Format is
        #     `projects/{project}/locations/{location}/builds/{build}`.
        # @!attribute [r] failure_cause
        #   @return [::Google::Cloud::Deploy::V1::DeployJobRun::FailureCause]
        #     Output only. The reason the deploy failed. This will always be unspecified
        #     while the deploy is in progress or if it succeeded.
        # @!attribute [r] failure_message
        #   @return [::String]
        #     Output only. Additional information about the deploy failure, if available.
        # @!attribute [r] metadata
        #   @return [::Google::Cloud::Deploy::V1::DeployJobRunMetadata]
        #     Output only. Metadata containing information about the deploy job run.
        # @!attribute [r] artifact
        #   @return [::Google::Cloud::Deploy::V1::DeployArtifact]
        #     Output only. The artifact of a deploy job run, if available.
        class DeployJobRun
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Well-known deploy failures.
          module FailureCause
            # No reason for failure is specified.
            FAILURE_CAUSE_UNSPECIFIED = 0

            # Cloud Build is not available, either because it is not enabled or because
            # Cloud Deploy has insufficient permissions. See [Required
            # permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
            CLOUD_BUILD_UNAVAILABLE = 1

            # The deploy operation did not complete successfully; check Cloud Build
            # logs.
            EXECUTION_FAILED = 2

            # The deploy job run did not complete within the allotted time.
            DEADLINE_EXCEEDED = 3

            # There were missing resources in the runtime environment required for a
            # canary deployment. Check the Cloud Build logs for more information.
            MISSING_RESOURCES_FOR_CANARY = 4

            # Cloud Build failed to fulfill Cloud Deploy's request. See failure_message
            # for additional details.
            CLOUD_BUILD_REQUEST_FAILED = 5

            # The deploy operation had a feature configured that is not supported.
            DEPLOY_FEATURE_NOT_SUPPORTED = 6
          end
        end

        # VerifyJobRun contains information specific to a verify `JobRun`.
        # @!attribute [r] build
        #   @return [::String]
        #     Output only. The resource name of the Cloud Build `Build` object that is
        #     used to verify. Format is
        #     `projects/{project}/locations/{location}/builds/{build}`.
        # @!attribute [r] artifact_uri
        #   @return [::String]
        #     Output only. URI of a directory containing the verify artifacts. This
        #     contains the Skaffold event log.
        # @!attribute [r] event_log_path
        #   @return [::String]
        #     Output only. File path of the Skaffold event log relative to the artifact
        #     URI.
        # @!attribute [r] failure_cause
        #   @return [::Google::Cloud::Deploy::V1::VerifyJobRun::FailureCause]
        #     Output only. The reason the verify failed. This will always be unspecified
        #     while the verify is in progress or if it succeeded.
        # @!attribute [r] failure_message
        #   @return [::String]
        #     Output only. Additional information about the verify failure, if available.
        class VerifyJobRun
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Well-known verify failures.
          module FailureCause
            # No reason for failure is specified.
            FAILURE_CAUSE_UNSPECIFIED = 0

            # Cloud Build is not available, either because it is not enabled or because
            # Cloud Deploy has insufficient permissions. See [required
            # permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
            CLOUD_BUILD_UNAVAILABLE = 1

            # The verify operation did not complete successfully; check Cloud Build
            # logs.
            EXECUTION_FAILED = 2

            # The verify job run did not complete within the allotted time.
            DEADLINE_EXCEEDED = 3

            # No Skaffold verify configuration was found.
            VERIFICATION_CONFIG_NOT_FOUND = 4

            # Cloud Build failed to fulfill Cloud Deploy's request. See failure_message
            # for additional details.
            CLOUD_BUILD_REQUEST_FAILED = 5
          end
        end

        # PredeployJobRun contains information specific to a predeploy `JobRun`.
        # @!attribute [r] build
        #   @return [::String]
        #     Output only. The resource name of the Cloud Build `Build` object that is
        #     used to execute the custom actions associated with the predeploy Job.
        #     Format is `projects/{project}/locations/{location}/builds/{build}`.
        # @!attribute [r] failure_cause
        #   @return [::Google::Cloud::Deploy::V1::PredeployJobRun::FailureCause]
        #     Output only. The reason the predeploy failed. This will always be
        #     unspecified while the predeploy is in progress or if it succeeded.
        # @!attribute [r] failure_message
        #   @return [::String]
        #     Output only. Additional information about the predeploy failure, if
        #     available.
        class PredeployJobRun
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Well-known predeploy failures.
          module FailureCause
            # No reason for failure is specified.
            FAILURE_CAUSE_UNSPECIFIED = 0

            # Cloud Build is not available, either because it is not enabled or because
            # Cloud Deploy has insufficient permissions. See [required
            # permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
            CLOUD_BUILD_UNAVAILABLE = 1

            # The predeploy operation did not complete successfully; check Cloud Build
            # logs.
            EXECUTION_FAILED = 2

            # The predeploy job run did not complete within the allotted time.
            DEADLINE_EXCEEDED = 3

            # Cloud Build failed to fulfill Cloud Deploy's request. See failure_message
            # for additional details.
            CLOUD_BUILD_REQUEST_FAILED = 4
          end
        end

        # PostdeployJobRun contains information specific to a postdeploy `JobRun`.
        # @!attribute [r] build
        #   @return [::String]
        #     Output only. The resource name of the Cloud Build `Build` object that is
        #     used to execute the custom actions associated with the postdeploy Job.
        #     Format is `projects/{project}/locations/{location}/builds/{build}`.
        # @!attribute [r] failure_cause
        #   @return [::Google::Cloud::Deploy::V1::PostdeployJobRun::FailureCause]
        #     Output only. The reason the postdeploy failed. This will always be
        #     unspecified while the postdeploy is in progress or if it succeeded.
        # @!attribute [r] failure_message
        #   @return [::String]
        #     Output only. Additional information about the postdeploy failure, if
        #     available.
        class PostdeployJobRun
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Well-known postdeploy failures.
          module FailureCause
            # No reason for failure is specified.
            FAILURE_CAUSE_UNSPECIFIED = 0

            # Cloud Build is not available, either because it is not enabled or because
            # Cloud Deploy has insufficient permissions. See [required
            # permission](https://cloud.google.com/deploy/docs/cloud-deploy-service-account#required_permissions).
            CLOUD_BUILD_UNAVAILABLE = 1

            # The postdeploy operation did not complete successfully; check Cloud Build
            # logs.
            EXECUTION_FAILED = 2

            # The postdeploy job run did not complete within the allotted time.
            DEADLINE_EXCEEDED = 3

            # Cloud Build failed to fulfill Cloud Deploy's request. See failure_message
            # for additional details.
            CLOUD_BUILD_REQUEST_FAILED = 4
          end
        end

        # CreateChildRolloutJobRun contains information specific to a
        # createChildRollout `JobRun`.
        # @!attribute [r] rollout
        #   @return [::String]
        #     Output only. Name of the `ChildRollout`. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
        # @!attribute [r] rollout_phase_id
        #   @return [::String]
        #     Output only. The ID of the childRollout Phase initiated by this JobRun.
        class CreateChildRolloutJobRun
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AdvanceChildRolloutJobRun contains information specific to a
        # advanceChildRollout `JobRun`.
        # @!attribute [r] rollout
        #   @return [::String]
        #     Output only. Name of the `ChildRollout`. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
        # @!attribute [r] rollout_phase_id
        #   @return [::String]
        #     Output only. the ID of the ChildRollout's Phase.
        class AdvanceChildRolloutJobRun
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListJobRunsRequest is the request object used by `ListJobRuns`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The `Rollout` which owns this collection of `JobRun` objects.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of `JobRun` objects to return. The service may
        #     return fewer than this value. If unspecified, at most 50 `JobRun` objects
        #     will be returned. The maximum value is 1000; values above 1000 will be set
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListJobRuns` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other provided parameters match the call that provided
        #     the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter results to be returned. See https://google.aip.dev/160 for
        #     more details.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Field to sort by. See https://google.aip.dev/132#ordering for
        #     more details.
        class ListJobRunsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # ListJobRunsResponse is the response object returned by `ListJobRuns`.
        # @!attribute [rw] job_runs
        #   @return [::Array<::Google::Cloud::Deploy::V1::JobRun>]
        #     The `JobRun` objects.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page. If
        #     this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached
        class ListJobRunsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # GetJobRunRequest is the request object used by `GetJobRun`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the `JobRun`. Format must be
        #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}/rollouts/{rollout_name}/jobRuns/{job_run_name}`.
        class GetJobRunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object used by `TerminateJobRun`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the `JobRun`. Format must be
        #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}/jobRuns/{jobRun}`.
        # @!attribute [rw] override_deploy_policy
        #   @return [::Array<::String>]
        #     Optional. Deploy policies to override. Format is
        #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
        class TerminateJobRunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from `TerminateJobRun`.
        class TerminateJobRunResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Service-wide configuration.
        # @!attribute [rw] name
        #   @return [::String]
        #     Name of the configuration.
        # @!attribute [rw] supported_versions
        #   @return [::Array<::Google::Cloud::Deploy::V1::SkaffoldVersion>]
        #     All supported versions of Skaffold.
        # @!attribute [rw] default_skaffold_version
        #   @return [::String]
        #     Default Skaffold version that is assigned when a Release is created without
        #     specifying a Skaffold version.
        class Config
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details of a supported Skaffold version.
        # @!attribute [rw] version
        #   @return [::String]
        #     Release version number. For example, "1.20.3".
        # @!attribute [rw] maintenance_mode_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which this version of Skaffold will enter maintenance mode.
        # @!attribute [rw] support_expiration_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time at which this version of Skaffold will no longer be supported.
        # @!attribute [rw] support_end_date
        #   @return [::Google::Type::Date]
        #     Date when this version is expected to no longer be supported.
        class SkaffoldVersion
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request to get a configuration.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of requested configuration.
        class GetConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An `Automation` resource in the Cloud Deploy API.
        #
        # An `Automation` enables the automation of manually driven actions for
        # a Delivery Pipeline, which includes Release promotion among Targets,
        # Rollout repair and Rollout deployment strategy advancement. The intention
        # of Automation is to reduce manual intervention in the continuous delivery
        # process.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the `Automation`. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automations/{automation}`.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. Unique identifier of the `Automation`.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the `Automation`. Max length is 255 characters.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the automation was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the automation was updated.
        # @!attribute [rw] annotations
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User annotations. These attributes can only be set and used by
        #     the user, and not by Cloud Deploy. Annotations must meet the following
        #     constraints:
        #
        #     * Annotations are key/value pairs.
        #     * Valid annotation keys have two segments: an optional prefix and name,
        #     separated by a slash (`/`).
        #     * The name segment is required and must be 63 characters or less,
        #     beginning and ending with an alphanumeric character (`[a-z0-9A-Z]`) with
        #     dashes (`-`), underscores (`_`), dots (`.`), and alphanumerics between.
        #     * The prefix is optional. If specified, the prefix must be a DNS subdomain:
        #     a series of DNS labels separated by dots(`.`), not longer than 253
        #     characters in total, followed by a slash (`/`).
        #
        #     See
        #     https://kubernetes.io/docs/concepts/overview/working-with-objects/annotations/#syntax-and-character-set
        #     for more details.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Labels are attributes that can be set and used by both the
        #     user and by Cloud Deploy. Labels must meet the following constraints:
        #
        #     * Keys and values can contain only lowercase letters, numeric characters,
        #     underscores, and dashes.
        #     * All characters must use UTF-8 encoding, and international characters are
        #     allowed.
        #     * Keys must start with a lowercase letter or international character.
        #     * Each resource is limited to a maximum of 64 labels.
        #
        #     Both keys and values are additionally constrained to be <= 63 characters.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The weak etag of the `Automation` resource.
        #     This checksum is computed by the server based on the value of other
        #     fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [rw] suspended
        #   @return [::Boolean]
        #     Optional. When Suspended, automation is deactivated from execution.
        # @!attribute [rw] service_account
        #   @return [::String]
        #     Required. Email address of the user-managed IAM service account that
        #     creates Cloud Deploy release and rollout resources.
        # @!attribute [rw] selector
        #   @return [::Google::Cloud::Deploy::V1::AutomationResourceSelector]
        #     Required. Selected resources to which the automation will be applied.
        # @!attribute [rw] rules
        #   @return [::Array<::Google::Cloud::Deploy::V1::AutomationRule>]
        #     Required. List of Automation rules associated with the Automation resource.
        #     Must have at least one rule and limited to 250 rules per Delivery Pipeline.
        #     Note: the order of the rules here is not the same as the order of
        #     execution.
        class Automation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class AnnotationsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # AutomationResourceSelector contains the information to select the resources
        # to which an Automation is going to be applied.
        # @!attribute [rw] targets
        #   @return [::Array<::Google::Cloud::Deploy::V1::TargetAttribute>]
        #     Optional. Contains attributes about a target.
        class AutomationResourceSelector
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `AutomationRule` defines the automation activities.
        # @!attribute [rw] promote_release_rule
        #   @return [::Google::Cloud::Deploy::V1::PromoteReleaseRule]
        #     Optional. `PromoteReleaseRule` will automatically promote a release from
        #     the current target to a specified target.
        #
        #     Note: The following fields are mutually exclusive: `promote_release_rule`, `advance_rollout_rule`, `repair_rollout_rule`, `timed_promote_release_rule`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] advance_rollout_rule
        #   @return [::Google::Cloud::Deploy::V1::AdvanceRolloutRule]
        #     Optional. The `AdvanceRolloutRule` will automatically advance a
        #     successful Rollout.
        #
        #     Note: The following fields are mutually exclusive: `advance_rollout_rule`, `promote_release_rule`, `repair_rollout_rule`, `timed_promote_release_rule`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] repair_rollout_rule
        #   @return [::Google::Cloud::Deploy::V1::RepairRolloutRule]
        #     Optional. The `RepairRolloutRule` will automatically repair a failed
        #     rollout.
        #
        #     Note: The following fields are mutually exclusive: `repair_rollout_rule`, `promote_release_rule`, `advance_rollout_rule`, `timed_promote_release_rule`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] timed_promote_release_rule
        #   @return [::Google::Cloud::Deploy::V1::TimedPromoteReleaseRule]
        #     Optional. The `TimedPromoteReleaseRule` will automatically promote a
        #     release from the current target(s) to the specified target(s) on a
        #     configured schedule.
        #
        #     Note: The following fields are mutually exclusive: `timed_promote_release_rule`, `promote_release_rule`, `advance_rollout_rule`, `repair_rollout_rule`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class AutomationRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `TimedPromoteReleaseRule` will automatically promote a release from the
        # current target(s) to the specified target(s) on a configured schedule.
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. ID of the rule. This ID must be unique in the `Automation`
        #     resource to which this rule belongs. The format is
        #     `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
        # @!attribute [rw] destination_target_id
        #   @return [::String]
        #     Optional. The ID of the stage in the pipeline to which this `Release` is
        #     deploying. If unspecified, default it to the next stage in the promotion
        #     flow. The value of this field could be one of the following:
        #
        #     * The last segment of a target name
        #     * "@next", the next target in the promotion sequence
        # @!attribute [rw] schedule
        #   @return [::String]
        #     Required. Schedule in crontab format. e.g. "0 9 * * 1" for every Monday at
        #     9am.
        # @!attribute [rw] time_zone
        #   @return [::String]
        #     Required. The time zone in IANA format [IANA Time Zone
        #     Database](https://www.iana.org/time-zones) (e.g. America/New_York).
        # @!attribute [r] condition
        #   @return [::Google::Cloud::Deploy::V1::AutomationRuleCondition]
        #     Output only. Information around the state of the Automation rule.
        # @!attribute [rw] destination_phase
        #   @return [::String]
        #     Optional. The starting phase of the rollout created by this rule. Default
        #     to the first phase.
        class TimedPromoteReleaseRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `PromoteRelease` rule will automatically promote a release from the
        # current target to a specified target.
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. ID of the rule. This id must be unique in the `Automation`
        #     resource to which this rule belongs. The format is
        #     `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
        # @!attribute [rw] wait
        #   @return [::Google::Protobuf::Duration]
        #     Optional. How long the release need to be paused until being promoted to
        #     the next target.
        # @!attribute [rw] destination_target_id
        #   @return [::String]
        #     Optional. The ID of the stage in the pipeline to which this `Release` is
        #     deploying. If unspecified, default it to the next stage in the promotion
        #     flow. The value of this field could be one of the following:
        #
        #     * The last segment of a target name
        #     * "@next", the next target in the promotion sequence
        # @!attribute [r] condition
        #   @return [::Google::Cloud::Deploy::V1::AutomationRuleCondition]
        #     Output only. Information around the state of the Automation rule.
        # @!attribute [rw] destination_phase
        #   @return [::String]
        #     Optional. The starting phase of the rollout created by this operation.
        #     Default to the first phase.
        class PromoteReleaseRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `AdvanceRollout` automation rule will automatically advance a successful
        # Rollout to the next phase.
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. ID of the rule. This id must be unique in the `Automation`
        #     resource to which this rule belongs. The format is
        #     `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
        # @!attribute [rw] source_phases
        #   @return [::Array<::String>]
        #     Optional. Proceeds only after phase name matched any one in the list.
        #     This value must consist of lower-case letters, numbers, and hyphens,
        #     start with a letter and end with a letter or a number, and have a max
        #     length of 63 characters. In other words, it must match the following
        #     regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
        # @!attribute [rw] wait
        #   @return [::Google::Protobuf::Duration]
        #     Optional. How long to wait after a rollout is finished.
        # @!attribute [r] condition
        #   @return [::Google::Cloud::Deploy::V1::AutomationRuleCondition]
        #     Output only. Information around the state of the Automation rule.
        class AdvanceRolloutRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The `RepairRolloutRule` automation rule will automatically repair a failed
        # `Rollout`.
        # @!attribute [rw] id
        #   @return [::String]
        #     Required. ID of the rule. This id must be unique in the `Automation`
        #     resource to which this rule belongs. The format is
        #     `[a-z]([a-z0-9-]{0,61}[a-z0-9])?`.
        # @!attribute [rw] phases
        #   @return [::Array<::String>]
        #     Optional. Phases within which jobs are subject to automatic repair actions
        #     on failure. Proceeds only after phase name matched any one in the list, or
        #     for all phases if unspecified. This value must consist of lower-case
        #     letters, numbers, and hyphens, start with a letter and end with a letter or
        #     a number, and have a max length of 63 characters. In other words, it must
        #     match the following regex: `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
        # @!attribute [rw] jobs
        #   @return [::Array<::String>]
        #     Optional. Jobs to repair. Proceeds only after job name matched any one in
        #     the list, or for all jobs if unspecified or empty. The phase that includes
        #     the job must match the phase ID specified in `source_phase`. This value
        #     must consist of lower-case letters, numbers, and hyphens, start with a
        #     letter and end with a letter or a number, and have a max length of 63
        #     characters. In other words, it must match the following regex:
        #     `^[a-z]([a-z0-9-]{0,61}[a-z0-9])?$`.
        # @!attribute [r] condition
        #   @return [::Google::Cloud::Deploy::V1::AutomationRuleCondition]
        #     Output only. Information around the state of the 'Automation' rule.
        # @!attribute [rw] repair_phases
        #   @return [::Array<::Google::Cloud::Deploy::V1::RepairPhaseConfig>]
        #     Required. Defines the types of automatic repair phases for failed jobs.
        class RepairRolloutRule
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration of the repair phase.
        # @!attribute [rw] retry
        #   @return [::Google::Cloud::Deploy::V1::Retry]
        #     Optional. Retries a failed job.
        #
        #     Note: The following fields are mutually exclusive: `retry`, `rollback`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] rollback
        #   @return [::Google::Cloud::Deploy::V1::Rollback]
        #     Optional. Rolls back a `Rollout`.
        #
        #     Note: The following fields are mutually exclusive: `rollback`, `retry`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class RepairPhaseConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Retries the failed job.
        # @!attribute [rw] attempts
        #   @return [::Integer]
        #     Required. Total number of retries. Retry is skipped if set to 0; The
        #     minimum value is 1, and the maximum value is 10.
        # @!attribute [rw] wait
        #   @return [::Google::Protobuf::Duration]
        #     Optional. How long to wait for the first retry. Default is 0, and the
        #     maximum value is 14d.
        # @!attribute [rw] backoff_mode
        #   @return [::Google::Cloud::Deploy::V1::BackoffMode]
        #     Optional. The pattern of how wait time will be increased. Default is
        #     linear. Backoff mode will be ignored if `wait` is 0.
        class Retry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Rolls back a `Rollout`.
        # @!attribute [rw] destination_phase
        #   @return [::String]
        #     Optional. The starting phase ID for the `Rollout`. If unspecified, the
        #     `Rollout` will start in the stable phase.
        # @!attribute [rw] disable_rollback_if_rollout_pending
        #   @return [::Boolean]
        #     Optional. If pending rollout exists on the target, the rollback operation
        #     will be aborted.
        class Rollback
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `AutomationRuleCondition` contains conditions relevant to an
        # `Automation` rule.
        # @!attribute [rw] targets_present_condition
        #   @return [::Google::Cloud::Deploy::V1::TargetsPresentCondition]
        #     Optional. Details around targets enumerated in the rule.
        # @!attribute [rw] timed_promote_release_condition
        #   @return [::Google::Cloud::Deploy::V1::TimedPromoteReleaseCondition]
        #     Optional. TimedPromoteReleaseCondition contains rule conditions specific
        #     to a an Automation with a timed promote release rule defined.
        class AutomationRuleCondition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # `TimedPromoteReleaseCondition` contains conditions specific to an Automation
        # with a Timed Promote Release rule defined.
        # @!attribute [r] next_promotion_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. When the next scheduled promotion(s) will occur.
        # @!attribute [r] targets_list
        #   @return [::Array<::Google::Cloud::Deploy::V1::TimedPromoteReleaseCondition::Targets>]
        #     Output only. A list of targets involved in the upcoming timed promotion(s).
        class TimedPromoteReleaseCondition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The targets involved in a single timed promotion.
          # @!attribute [rw] source_target_id
          #   @return [::String]
          #     Optional. The source target ID.
          # @!attribute [rw] destination_target_id
          #   @return [::String]
          #     Optional. The destination target ID.
          class Targets
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The request object for `CreateAutomation`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent collection in which the `Automation` must be created.
        #     The format is
        #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
        # @!attribute [rw] automation_id
        #   @return [::String]
        #     Required. ID of the `Automation`.
        # @!attribute [rw] automation
        #   @return [::Google::Cloud::Deploy::V1::Automation]
        #     Required. The `Automation` to create.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, the request is validated and the user is provided
        #     with an expected result, but no actual change is made.
        class CreateAutomationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `UpdateAutomation`.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Field mask is used to specify the fields to be overwritten by the
        #     update in the `Automation` resource. The fields specified in the
        #     update_mask are relative to the resource, not the full request. A field
        #     will be overwritten if it's in the mask. If the user doesn't provide a mask
        #     then all fields are overwritten.
        # @!attribute [rw] automation
        #   @return [::Google::Cloud::Deploy::V1::Automation]
        #     Required. The `Automation` to update.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, updating a `Automation` that does not exist will
        #     result in the creation of a new `Automation`.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set to true, the request is validated and the user is provided
        #     with an expected result, but no actual change is made.
        class UpdateAutomationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `DeleteAutomation`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the `Automation` to delete. The format is
        #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/automations/{automation_name}`.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A request ID to identify requests. Specify a unique request ID
        #     so that if you must retry your request, the server knows to ignore the
        #     request if it has already been completed. The server guarantees that for
        #     at least 60 minutes after the first request.
        #
        #     For example, consider a situation where you make an initial request and the
        #     request times out. If you make the request again with the same request ID,
        #     the server can check if original operation with the same request ID was
        #     received, and if so, will ignore the second request. This prevents clients
        #     from accidentally creating duplicate commitments.
        #
        #     The request ID must be a valid UUID with the exception that zero UUID is
        #     not supported (00000000-0000-0000-0000-000000000000).
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true, then deleting an already deleted or non-existing
        #     `Automation` will succeed.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. If set, validate the request and verify whether the resource
        #     exists, but do not actually post it.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The weak etag of the request.
        #     This checksum is computed by the server based on the value of other
        #     fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        class DeleteAutomationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `ListAutomations`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent `Delivery Pipeline`, which owns this collection of
        #     automations. Format must be
        #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of automations to return. The service may return
        #     fewer than this value. If unspecified, at most 50 automations will
        #     be returned. The maximum value is 1000; values above 1000 will be set
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListAutomations` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other provided parameters match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter automations to be returned. All fields can be used in the
        #     filter.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to sort by.
        class ListAutomationsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from `ListAutomations`.
        # @!attribute [rw] automations
        #   @return [::Array<::Google::Cloud::Deploy::V1::Automation>]
        #     The `Automation` objects.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListAutomationsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `GetAutomation`
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the `Automation`. Format must be
        #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/automations/{automation_name}`.
        class GetAutomationRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An `AutomationRun` resource in the Cloud Deploy API.
        #
        # An `AutomationRun` represents an execution instance of an
        # automation rule.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Name of the `AutomationRun`. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the `AutomationRun` was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time at which the automationRun was updated.
        # @!attribute [r] etag
        #   @return [::String]
        #     Output only. The weak etag of the `AutomationRun` resource.
        #     This checksum is computed by the server based on the value of other
        #     fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [r] service_account
        #   @return [::String]
        #     Output only. Email address of the user-managed IAM service account that
        #     performs the operations against Cloud Deploy resources.
        # @!attribute [r] automation_snapshot
        #   @return [::Google::Cloud::Deploy::V1::Automation]
        #     Output only. Snapshot of the Automation taken at AutomationRun creation
        #     time.
        # @!attribute [r] target_id
        #   @return [::String]
        #     Output only. The ID of the source target that initiates the
        #     `AutomationRun`. The value of this field is the last segment of a target
        #     name.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Deploy::V1::AutomationRun::State]
        #     Output only. Current state of the `AutomationRun`.
        # @!attribute [r] state_description
        #   @return [::String]
        #     Output only. Explains the current state of the `AutomationRun`. Present
        #     only when an explanation is needed.
        # @!attribute [r] policy_violation
        #   @return [::Google::Cloud::Deploy::V1::PolicyViolation]
        #     Output only. Contains information about what policies prevented the
        #     `AutomationRun` from proceeding.
        # @!attribute [r] expire_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Time the `AutomationRun` expires. An `AutomationRun` expires
        #     after 14 days from its creation date.
        # @!attribute [r] rule_id
        #   @return [::String]
        #     Output only. The ID of the automation rule that initiated the operation.
        # @!attribute [r] automation_id
        #   @return [::String]
        #     Output only. The ID of the automation that initiated the operation.
        # @!attribute [r] promote_release_operation
        #   @return [::Google::Cloud::Deploy::V1::PromoteReleaseOperation]
        #     Output only. Promotes a release to a specified 'Target'.
        #
        #     Note: The following fields are mutually exclusive: `promote_release_operation`, `advance_rollout_operation`, `repair_rollout_operation`, `timed_promote_release_operation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] advance_rollout_operation
        #   @return [::Google::Cloud::Deploy::V1::AdvanceRolloutOperation]
        #     Output only. Advances a rollout to the next phase.
        #
        #     Note: The following fields are mutually exclusive: `advance_rollout_operation`, `promote_release_operation`, `repair_rollout_operation`, `timed_promote_release_operation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] repair_rollout_operation
        #   @return [::Google::Cloud::Deploy::V1::RepairRolloutOperation]
        #     Output only. Repairs a failed 'Rollout'.
        #
        #     Note: The following fields are mutually exclusive: `repair_rollout_operation`, `promote_release_operation`, `advance_rollout_operation`, `timed_promote_release_operation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] timed_promote_release_operation
        #   @return [::Google::Cloud::Deploy::V1::TimedPromoteReleaseOperation]
        #     Output only. Promotes a release to a specified 'Target' as defined in a
        #     Timed Promote Release rule.
        #
        #     Note: The following fields are mutually exclusive: `timed_promote_release_operation`, `promote_release_operation`, `advance_rollout_operation`, `repair_rollout_operation`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] wait_until_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Earliest time the `AutomationRun` will attempt to resume.
        #     Wait-time is configured by `wait` in automation rule.
        class AutomationRun
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Valid state of an `AutomationRun`.
          module State
            # The `AutomationRun` has an unspecified state.
            STATE_UNSPECIFIED = 0

            # The `AutomationRun` has succeeded.
            SUCCEEDED = 1

            # The `AutomationRun` was cancelled.
            CANCELLED = 2

            # The `AutomationRun` has failed.
            FAILED = 3

            # The `AutomationRun` is in progress.
            IN_PROGRESS = 4

            # The `AutomationRun` is pending.
            PENDING = 5

            # The `AutomationRun` was aborted.
            ABORTED = 6
          end
        end

        # Contains the information of an automated promote-release operation.
        # @!attribute [r] target_id
        #   @return [::String]
        #     Output only. The ID of the target that represents the promotion stage to
        #     which the release will be promoted. The value of this field is the last
        #     segment of a target name.
        # @!attribute [r] wait
        #   @return [::Google::Protobuf::Duration]
        #     Output only. How long the operation will be paused.
        # @!attribute [r] rollout
        #   @return [::String]
        #     Output only. The name of the rollout that initiates the `AutomationRun`.
        # @!attribute [r] phase
        #   @return [::String]
        #     Output only. The starting phase of the rollout created by this operation.
        class PromoteReleaseOperation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains the information of an automated advance-rollout operation.
        # @!attribute [r] source_phase
        #   @return [::String]
        #     Output only. The phase of a deployment that initiated the operation.
        # @!attribute [r] wait
        #   @return [::Google::Protobuf::Duration]
        #     Output only. How long the operation will be paused.
        # @!attribute [r] rollout
        #   @return [::String]
        #     Output only. The name of the rollout that initiates the `AutomationRun`.
        # @!attribute [r] destination_phase
        #   @return [::String]
        #     Output only. The phase the rollout will be advanced to.
        class AdvanceRolloutOperation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains the information for an automated `repair rollout` operation.
        # @!attribute [r] rollout
        #   @return [::String]
        #     Output only. The name of the rollout that initiates the `AutomationRun`.
        # @!attribute [r] current_repair_phase_index
        #   @return [::Integer]
        #     Output only. The index of the current repair action in the repair sequence.
        # @!attribute [r] repair_phases
        #   @return [::Array<::Google::Cloud::Deploy::V1::RepairPhase>]
        #     Output only. Records of the repair attempts. Each repair phase may have
        #     multiple retry attempts or single rollback attempt.
        # @!attribute [r] phase_id
        #   @return [::String]
        #     Output only. The phase ID of the phase that includes the job being
        #     repaired.
        # @!attribute [r] job_id
        #   @return [::String]
        #     Output only. The job ID for the Job to repair.
        class RepairRolloutOperation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Contains the information of an automated timed promote-release operation.
        # @!attribute [r] target_id
        #   @return [::String]
        #     Output only. The ID of the target that represents the promotion stage to
        #     which the release will be promoted. The value of this field is the last
        #     segment of a target name.
        # @!attribute [r] release
        #   @return [::String]
        #     Output only. The name of the release to be promoted.
        # @!attribute [r] phase
        #   @return [::String]
        #     Output only. The starting phase of the rollout created by this operation.
        class TimedPromoteReleaseOperation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RepairPhase tracks the repair attempts that have been made for
        # each `RepairPhaseConfig` specified in the `Automation` resource.
        # @!attribute [r] retry
        #   @return [::Google::Cloud::Deploy::V1::RetryPhase]
        #     Output only. Records of the retry attempts for retry repair mode.
        #
        #     Note: The following fields are mutually exclusive: `retry`, `rollback`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] rollback
        #   @return [::Google::Cloud::Deploy::V1::RollbackAttempt]
        #     Output only. Rollback attempt for rollback repair mode .
        #
        #     Note: The following fields are mutually exclusive: `rollback`, `retry`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class RepairPhase
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RetryPhase contains the retry attempts and the metadata for initiating a
        # new attempt.
        # @!attribute [r] total_attempts
        #   @return [::Integer]
        #     Output only. The number of attempts that have been made.
        # @!attribute [r] backoff_mode
        #   @return [::Google::Cloud::Deploy::V1::BackoffMode]
        #     Output only. The pattern of how the wait time of the retry attempt is
        #     calculated.
        # @!attribute [r] attempts
        #   @return [::Array<::Google::Cloud::Deploy::V1::RetryAttempt>]
        #     Output only. Detail of a retry action.
        class RetryPhase
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RetryAttempt represents an action of retrying the failed Cloud Deploy job.
        # @!attribute [r] attempt
        #   @return [::Integer]
        #     Output only. The index of this retry attempt.
        # @!attribute [r] wait
        #   @return [::Google::Protobuf::Duration]
        #     Output only. How long the operation will be paused.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Deploy::V1::RepairState]
        #     Output only. Valid state of this retry action.
        # @!attribute [r] state_desc
        #   @return [::String]
        #     Output only. Description of the state of the Retry.
        class RetryAttempt
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # RollbackAttempt represents an action of rolling back a Cloud Deploy 'Target'.
        # @!attribute [r] destination_phase
        #   @return [::String]
        #     Output only. The phase to which the rollout will be rolled back to.
        # @!attribute [r] rollout_id
        #   @return [::String]
        #     Output only. ID of the rollback `Rollout` to create.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Deploy::V1::RepairState]
        #     Output only. Valid state of this rollback action.
        # @!attribute [r] state_desc
        #   @return [::String]
        #     Output only. Description of the state of the Rollback.
        # @!attribute [r] disable_rollback_if_rollout_pending
        #   @return [::Boolean]
        #     Output only. If active rollout exists on the target, abort this rollback.
        class RollbackAttempt
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `ListAutomationRuns`.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent `Delivery Pipeline`, which owns this collection of
        #     automationRuns. Format must be
        #     `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     The maximum number of automationRuns to return. The service may return
        #     fewer than this value. If unspecified, at most 50 automationRuns will
        #     be returned. The maximum value is 1000; values above 1000 will be set
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     A page token, received from a previous `ListAutomationRuns` call.
        #     Provide this to retrieve the subsequent page.
        #
        #     When paginating, all other provided parameters match
        #     the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Filter automationRuns to be returned. All fields can be used in the
        #     filter.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Field to sort by.
        class ListAutomationRunsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from `ListAutomationRuns`.
        # @!attribute [rw] automation_runs
        #   @return [::Array<::Google::Cloud::Deploy::V1::AutomationRun>]
        #     The `AutomationRuns` objects.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListAutomationRunsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object for `GetAutomationRun`
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the `AutomationRun`. Format must be
        #     `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
        class GetAutomationRunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The request object used by `CancelAutomationRun`.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. Name of the `AutomationRun`. Format is
        #     `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
        class CancelAutomationRunRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The response object from `CancelAutomationRun`.
        class CancelAutomationRunResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The support state of a specific Skaffold version.
        module SkaffoldSupportState
          # Default value. This value is unused.
          SKAFFOLD_SUPPORT_STATE_UNSPECIFIED = 0

          # This Skaffold version is currently supported.
          SKAFFOLD_SUPPORT_STATE_SUPPORTED = 1

          # This Skaffold version is in maintenance mode.
          SKAFFOLD_SUPPORT_STATE_MAINTENANCE_MODE = 2

          # This Skaffold version is no longer supported.
          SKAFFOLD_SUPPORT_STATE_UNSUPPORTED = 3
        end

        # The pattern of how wait time is increased.
        module BackoffMode
          # No WaitMode is specified.
          BACKOFF_MODE_UNSPECIFIED = 0

          # Increases the wait time linearly.
          BACKOFF_MODE_LINEAR = 1

          # Increases the wait time exponentially.
          BACKOFF_MODE_EXPONENTIAL = 2
        end

        # Valid state of a repair attempt.
        module RepairState
          # The `repair` has an unspecified state.
          REPAIR_STATE_UNSPECIFIED = 0

          # The `repair` action has succeeded.
          REPAIR_STATE_SUCCEEDED = 1

          # The `repair` action was cancelled.
          REPAIR_STATE_CANCELLED = 2

          # The `repair` action has failed.
          REPAIR_STATE_FAILED = 3

          # The `repair` action is in progress.
          REPAIR_STATE_IN_PROGRESS = 4

          # The `repair` action is pending.
          REPAIR_STATE_PENDING = 5

          # The `repair` action was aborted.
          REPAIR_STATE_ABORTED = 7
        end
      end
    end
  end
end
