# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/deploy/v1/cloud_deploy_pb"
require "google/cloud/deploy/v1/cloud_deploy/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module Deploy
      module V1
        module CloudDeploy
          module Rest
            ##
            # REST client for the CloudDeploy service.
            #
            # CloudDeploy service creates and manages Continuous Delivery operations
            # on Google Cloud Platform via Skaffold (https://skaffold.dev).
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "clouddeploy.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :cloud_deploy_stub

              ##
              # Configure the CloudDeploy Client class.
              #
              # See {::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all CloudDeploy clients
              #   ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Deploy", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.list_delivery_pipelines.timeout = 60.0
                  default_config.rpcs.list_delivery_pipelines.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_delivery_pipeline.timeout = 60.0
                  default_config.rpcs.get_delivery_pipeline.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_delivery_pipeline.timeout = 60.0

                  default_config.rpcs.update_delivery_pipeline.timeout = 60.0

                  default_config.rpcs.delete_delivery_pipeline.timeout = 60.0

                  default_config.rpcs.list_targets.timeout = 60.0
                  default_config.rpcs.list_targets.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_target.timeout = 60.0
                  default_config.rpcs.get_target.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_target.timeout = 60.0

                  default_config.rpcs.update_target.timeout = 60.0

                  default_config.rpcs.delete_target.timeout = 60.0

                  default_config.rpcs.list_custom_target_types.timeout = 60.0
                  default_config.rpcs.list_custom_target_types.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_custom_target_type.timeout = 60.0
                  default_config.rpcs.get_custom_target_type.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_custom_target_type.timeout = 60.0

                  default_config.rpcs.update_custom_target_type.timeout = 60.0

                  default_config.rpcs.delete_custom_target_type.timeout = 60.0

                  default_config.rpcs.list_releases.timeout = 60.0
                  default_config.rpcs.list_releases.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_release.timeout = 60.0
                  default_config.rpcs.get_release.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_release.timeout = 60.0

                  default_config.rpcs.abandon_release.timeout = 60.0

                  default_config.rpcs.create_deploy_policy.timeout = 60.0

                  default_config.rpcs.update_deploy_policy.timeout = 60.0

                  default_config.rpcs.delete_deploy_policy.timeout = 60.0

                  default_config.rpcs.list_deploy_policies.timeout = 60.0
                  default_config.rpcs.list_deploy_policies.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_deploy_policy.timeout = 60.0
                  default_config.rpcs.get_deploy_policy.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.approve_rollout.timeout = 60.0

                  default_config.rpcs.advance_rollout.timeout = 60.0

                  default_config.rpcs.cancel_rollout.timeout = 60.0

                  default_config.rpcs.list_rollouts.timeout = 60.0
                  default_config.rpcs.list_rollouts.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_rollout.timeout = 60.0
                  default_config.rpcs.get_rollout.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_rollout.timeout = 60.0

                  default_config.rpcs.ignore_job.timeout = 60.0

                  default_config.rpcs.retry_job.timeout = 60.0

                  default_config.rpcs.list_job_runs.timeout = 60.0
                  default_config.rpcs.list_job_runs.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_job_run.timeout = 60.0
                  default_config.rpcs.get_job_run.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.terminate_job_run.timeout = 60.0

                  default_config.rpcs.get_config.timeout = 60.0
                  default_config.rpcs.get_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_automation.timeout = 60.0

                  default_config.rpcs.update_automation.timeout = 60.0

                  default_config.rpcs.delete_automation.timeout = 60.0

                  default_config.rpcs.get_automation.timeout = 60.0
                  default_config.rpcs.get_automation.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_automations.timeout = 60.0
                  default_config.rpcs.list_automations.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_automation_run.timeout = 60.0
                  default_config.rpcs.get_automation_run.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_automation_runs.timeout = 60.0
                  default_config.rpcs.list_automation_runs.retry_policy = {
                    initial_delay: 1.0, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.cancel_automation_run.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the CloudDeploy Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @cloud_deploy_stub.universe_domain
              end

              ##
              # Create a new CloudDeploy REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the CloudDeploy client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @cloud_deploy_stub = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @cloud_deploy_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @cloud_deploy_stub.endpoint
                  config.universe_domain = @cloud_deploy_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @cloud_deploy_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @cloud_deploy_stub.endpoint
                  config.universe_domain = @cloud_deploy_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @cloud_deploy_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @cloud_deploy_stub.logger
              end

              # Service calls

              ##
              # Lists DeliveryPipelines in a given project and location.
              #
              # @overload list_delivery_pipelines(request, options = nil)
              #   Pass arguments to `list_delivery_pipelines` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::ListDeliveryPipelinesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::ListDeliveryPipelinesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_delivery_pipelines(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_delivery_pipelines` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of pipelines. Format must
              #     be `projects/{project_id}/locations/{location_name}`.
              #   @param page_size [::Integer]
              #     The maximum number of pipelines to return. The service may return
              #     fewer than this value. If unspecified, at most 50 pipelines will
              #     be returned. The maximum value is 1000; values above 1000 will be set
              #     to 1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListDeliveryPipelines` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other provided parameters match
              #     the call that provided the page token.
              #   @param filter [::String]
              #     Filter pipelines to be returned. See https://google.aip.dev/160 for more
              #     details.
              #   @param order_by [::String]
              #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::DeliveryPipeline>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::DeliveryPipeline>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::ListDeliveryPipelinesRequest.new
              #
              #   # Call the list_delivery_pipelines method.
              #   result = client.list_delivery_pipelines request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Deploy::V1::DeliveryPipeline.
              #     p item
              #   end
              #
              def list_delivery_pipelines request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::ListDeliveryPipelinesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_delivery_pipelines.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_delivery_pipelines.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_delivery_pipelines.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.list_delivery_pipelines request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_deploy_stub, :list_delivery_pipelines, "delivery_pipelines", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single DeliveryPipeline.
              #
              # @overload get_delivery_pipeline(request, options = nil)
              #   Pass arguments to `get_delivery_pipeline` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::GetDeliveryPipelineRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::GetDeliveryPipelineRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_delivery_pipeline(name: nil)
              #   Pass arguments to `get_delivery_pipeline` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the `DeliveryPipeline`. Format must be
              #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::DeliveryPipeline]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::DeliveryPipeline]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::GetDeliveryPipelineRequest.new
              #
              #   # Call the get_delivery_pipeline method.
              #   result = client.get_delivery_pipeline request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::DeliveryPipeline.
              #   p result
              #
              def get_delivery_pipeline request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::GetDeliveryPipelineRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_delivery_pipeline.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_delivery_pipeline.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_delivery_pipeline.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.get_delivery_pipeline request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new DeliveryPipeline in a given project and location.
              #
              # @overload create_delivery_pipeline(request, options = nil)
              #   Pass arguments to `create_delivery_pipeline` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::CreateDeliveryPipelineRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::CreateDeliveryPipelineRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_delivery_pipeline(parent: nil, delivery_pipeline_id: nil, delivery_pipeline: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `create_delivery_pipeline` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent collection in which the `DeliveryPipeline` must be
              #     created. The format is `projects/{project_id}/locations/{location_name}`.
              #   @param delivery_pipeline_id [::String]
              #     Required. ID of the `DeliveryPipeline`.
              #   @param delivery_pipeline [::Google::Cloud::Deploy::V1::DeliveryPipeline, ::Hash]
              #     Required. The `DeliveryPipeline` to create.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set to true, the request is validated and the user is provided
              #     with an expected result, but no actual change is made.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::CreateDeliveryPipelineRequest.new
              #
              #   # Call the create_delivery_pipeline method.
              #   result = client.create_delivery_pipeline request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_delivery_pipeline request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::CreateDeliveryPipelineRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_delivery_pipeline.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_delivery_pipeline.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_delivery_pipeline.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.create_delivery_pipeline request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single DeliveryPipeline.
              #
              # @overload update_delivery_pipeline(request, options = nil)
              #   Pass arguments to `update_delivery_pipeline` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::UpdateDeliveryPipelineRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::UpdateDeliveryPipelineRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_delivery_pipeline(update_mask: nil, delivery_pipeline: nil, request_id: nil, allow_missing: nil, validate_only: nil)
              #   Pass arguments to `update_delivery_pipeline` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten by the
              #     update in the `DeliveryPipeline` resource. The fields specified in the
              #     update_mask are relative to the resource, not the full request. A field
              #     will be overwritten if it's in the mask. If the user doesn't provide a mask
              #     then all fields are overwritten.
              #   @param delivery_pipeline [::Google::Cloud::Deploy::V1::DeliveryPipeline, ::Hash]
              #     Required. The `DeliveryPipeline` to update.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, updating a `DeliveryPipeline` that does not exist
              #     will result in the creation of a new `DeliveryPipeline`.
              #   @param validate_only [::Boolean]
              #     Optional. If set to true, the request is validated and the user is provided
              #     with an expected result, but no actual change is made.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::UpdateDeliveryPipelineRequest.new
              #
              #   # Call the update_delivery_pipeline method.
              #   result = client.update_delivery_pipeline request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_delivery_pipeline request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::UpdateDeliveryPipelineRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_delivery_pipeline.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_delivery_pipeline.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_delivery_pipeline.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.update_delivery_pipeline request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single DeliveryPipeline.
              #
              # @overload delete_delivery_pipeline(request, options = nil)
              #   Pass arguments to `delete_delivery_pipeline` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::DeleteDeliveryPipelineRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::DeleteDeliveryPipelineRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_delivery_pipeline(name: nil, request_id: nil, allow_missing: nil, validate_only: nil, force: nil, etag: nil)
              #   Pass arguments to `delete_delivery_pipeline` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `DeliveryPipeline` to delete. The format is
              #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, then deleting an already deleted or non-existing
              #     `DeliveryPipeline` will succeed.
              #   @param validate_only [::Boolean]
              #     Optional. If set, validate the request and preview the review, but do not
              #     actually post it.
              #   @param force [::Boolean]
              #     Optional. If set to true, all child resources under this pipeline will also
              #     be deleted. Otherwise, the request will only work if the pipeline has no
              #     child resources.
              #   @param etag [::String]
              #     Optional. This checksum is computed by the server based on the value of
              #     other fields, and may be sent on update and delete requests to ensure the
              #     client has an up-to-date value before proceeding.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::DeleteDeliveryPipelineRequest.new
              #
              #   # Call the delete_delivery_pipeline method.
              #   result = client.delete_delivery_pipeline request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_delivery_pipeline request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::DeleteDeliveryPipelineRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_delivery_pipeline.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_delivery_pipeline.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_delivery_pipeline.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.delete_delivery_pipeline request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Targets in a given project and location.
              #
              # @overload list_targets(request, options = nil)
              #   Pass arguments to `list_targets` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::ListTargetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::ListTargetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_targets(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_targets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of targets. Format must be
              #     `projects/{project_id}/locations/{location_name}`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of `Target` objects to return. The service may
              #     return fewer than this value. If unspecified, at most 50 `Target` objects
              #     will be returned. The maximum value is 1000; values above 1000 will be set
              #     to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListTargets` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other provided parameters match
              #     the call that provided the page token.
              #   @param filter [::String]
              #     Optional. Filter targets to be returned. See https://google.aip.dev/160 for
              #     more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. See https://google.aip.dev/132#ordering for
              #     more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::Target>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::Target>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::ListTargetsRequest.new
              #
              #   # Call the list_targets method.
              #   result = client.list_targets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Deploy::V1::Target.
              #     p item
              #   end
              #
              def list_targets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::ListTargetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_targets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_targets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_targets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.list_targets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_deploy_stub, :list_targets, "targets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a `Rollout` to roll back the specified target.
              #
              # @overload rollback_target(request, options = nil)
              #   Pass arguments to `rollback_target` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::RollbackTargetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::RollbackTargetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload rollback_target(name: nil, target_id: nil, rollout_id: nil, release_id: nil, rollout_to_roll_back: nil, rollback_config: nil, validate_only: nil, override_deploy_policy: nil)
              #   Pass arguments to `rollback_target` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The `DeliveryPipeline` for which the rollback `Rollout` must be
              #     created. The format is
              #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
              #   @param target_id [::String]
              #     Required. ID of the `Target` that is being rolled back.
              #   @param rollout_id [::String]
              #     Required. ID of the rollback `Rollout` to create.
              #   @param release_id [::String]
              #     Optional. ID of the `Release` to roll back to. If this isn't specified, the
              #     previous successful `Rollout` to the specified target will be used to
              #     determine the `Release`.
              #   @param rollout_to_roll_back [::String]
              #     Optional. If provided, this must be the latest `Rollout` that is on the
              #     `Target`.
              #   @param rollback_config [::Google::Cloud::Deploy::V1::RollbackTargetConfig, ::Hash]
              #     Optional. Configs for the rollback `Rollout`.
              #   @param validate_only [::Boolean]
              #     Optional. If set to true, the request is validated and the user is provided
              #     with a `RollbackTargetResponse`.
              #   @param override_deploy_policy [::Array<::String>]
              #     Optional. Deploy policies to override. Format is
              #     `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::RollbackTargetResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::RollbackTargetResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::RollbackTargetRequest.new
              #
              #   # Call the rollback_target method.
              #   result = client.rollback_target request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::RollbackTargetResponse.
              #   p result
              #
              def rollback_target request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::RollbackTargetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.rollback_target.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.rollback_target.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.rollback_target.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.rollback_target request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Target.
              #
              # @overload get_target(request, options = nil)
              #   Pass arguments to `get_target` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::GetTargetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::GetTargetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_target(name: nil)
              #   Pass arguments to `get_target` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the `Target`. Format must be
              #     `projects/{project_id}/locations/{location_name}/targets/{target_name}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::Target]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::Target]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::GetTargetRequest.new
              #
              #   # Call the get_target method.
              #   result = client.get_target request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::Target.
              #   p result
              #
              def get_target request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::GetTargetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_target.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_target.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_target.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.get_target request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Target in a given project and location.
              #
              # @overload create_target(request, options = nil)
              #   Pass arguments to `create_target` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::CreateTargetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::CreateTargetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_target(parent: nil, target_id: nil, target: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `create_target` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent collection in which the `Target` must be created.
              #     The format is
              #     `projects/{project_id}/locations/{location_name}`.
              #   @param target_id [::String]
              #     Required. ID of the `Target`.
              #   @param target [::Google::Cloud::Deploy::V1::Target, ::Hash]
              #     Required. The `Target` to create.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set to true, the request is validated and the user is provided
              #     with an expected result, but no actual change is made.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::CreateTargetRequest.new
              #
              #   # Call the create_target method.
              #   result = client.create_target request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_target request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::CreateTargetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_target.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_target.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_target.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.create_target request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Target.
              #
              # @overload update_target(request, options = nil)
              #   Pass arguments to `update_target` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::UpdateTargetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::UpdateTargetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_target(update_mask: nil, target: nil, request_id: nil, allow_missing: nil, validate_only: nil)
              #   Pass arguments to `update_target` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten by the
              #     update in the `Target` resource. The fields specified in the update_mask
              #     are relative to the resource, not the full request. A field will be
              #     overwritten if it's in the mask. If the user doesn't provide a mask then
              #     all fields are overwritten.
              #   @param target [::Google::Cloud::Deploy::V1::Target, ::Hash]
              #     Required. The `Target` to update.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, updating a `Target` that does not exist will
              #     result in the creation of a new `Target`.
              #   @param validate_only [::Boolean]
              #     Optional. If set to true, the request is validated and the user is provided
              #     with an expected result, but no actual change is made.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::UpdateTargetRequest.new
              #
              #   # Call the update_target method.
              #   result = client.update_target request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_target request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::UpdateTargetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_target.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_target.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_target.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.update_target request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Target.
              #
              # @overload delete_target(request, options = nil)
              #   Pass arguments to `delete_target` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::DeleteTargetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::DeleteTargetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_target(name: nil, request_id: nil, allow_missing: nil, validate_only: nil, etag: nil)
              #   Pass arguments to `delete_target` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `Target` to delete. The format is
              #     `projects/{project_id}/locations/{location_name}/targets/{target_name}`.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, then deleting an already deleted or non-existing
              #     `Target` will succeed.
              #   @param validate_only [::Boolean]
              #     Optional. If set, validate the request and preview the review, but do not
              #     actually post it.
              #   @param etag [::String]
              #     Optional. This checksum is computed by the server based on the value of
              #     other fields, and may be sent on update and delete requests to ensure the
              #     client has an up-to-date value before proceeding.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::DeleteTargetRequest.new
              #
              #   # Call the delete_target method.
              #   result = client.delete_target request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_target request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::DeleteTargetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_target.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_target.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_target.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.delete_target request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists CustomTargetTypes in a given project and location.
              #
              # @overload list_custom_target_types(request, options = nil)
              #   Pass arguments to `list_custom_target_types` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::ListCustomTargetTypesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::ListCustomTargetTypesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_custom_target_types(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_custom_target_types` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent that owns this collection of custom target types.
              #     Format must be `projects/{project_id}/locations/{location_name}`.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of `CustomTargetType` objects to return. The
              #     service may return fewer than this value. If unspecified, at most 50
              #     `CustomTargetType` objects will be returned. The maximum value is 1000;
              #     values above 1000 will be set to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListCustomTargetTypes`
              #     call. Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other provided parameters match
              #     the call that provided the page token.
              #   @param filter [::String]
              #     Optional. Filter custom target types to be returned. See
              #     https://google.aip.dev/160 for more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. See https://google.aip.dev/132#ordering for
              #     more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::CustomTargetType>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::CustomTargetType>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::ListCustomTargetTypesRequest.new
              #
              #   # Call the list_custom_target_types method.
              #   result = client.list_custom_target_types request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Deploy::V1::CustomTargetType.
              #     p item
              #   end
              #
              def list_custom_target_types request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::ListCustomTargetTypesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_custom_target_types.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_custom_target_types.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_custom_target_types.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.list_custom_target_types request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_deploy_stub, :list_custom_target_types, "custom_target_types", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single CustomTargetType.
              #
              # @overload get_custom_target_type(request, options = nil)
              #   Pass arguments to `get_custom_target_type` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::GetCustomTargetTypeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::GetCustomTargetTypeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_custom_target_type(name: nil)
              #   Pass arguments to `get_custom_target_type` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the `CustomTargetType`. Format must be
              #     `projects/{project_id}/locations/{location_name}/customTargetTypes/{custom_target_type}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::CustomTargetType]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::CustomTargetType]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::GetCustomTargetTypeRequest.new
              #
              #   # Call the get_custom_target_type method.
              #   result = client.get_custom_target_type request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::CustomTargetType.
              #   p result
              #
              def get_custom_target_type request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::GetCustomTargetTypeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_custom_target_type.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_custom_target_type.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_custom_target_type.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.get_custom_target_type request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new CustomTargetType in a given project and location.
              #
              # @overload create_custom_target_type(request, options = nil)
              #   Pass arguments to `create_custom_target_type` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::CreateCustomTargetTypeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::CreateCustomTargetTypeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_custom_target_type(parent: nil, custom_target_type_id: nil, custom_target_type: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `create_custom_target_type` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent collection in which the `CustomTargetType` must be
              #     created. The format is `projects/{project_id}/locations/{location_name}`.
              #   @param custom_target_type_id [::String]
              #     Required. ID of the `CustomTargetType`.
              #   @param custom_target_type [::Google::Cloud::Deploy::V1::CustomTargetType, ::Hash]
              #     Required. The `CustomTargetType` to create.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set to true, the request is validated and the user is provided
              #     with an expected result, but no actual change is made.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::CreateCustomTargetTypeRequest.new
              #
              #   # Call the create_custom_target_type method.
              #   result = client.create_custom_target_type request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_custom_target_type request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::CreateCustomTargetTypeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_custom_target_type.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_custom_target_type.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_custom_target_type.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.create_custom_target_type request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a single CustomTargetType.
              #
              # @overload update_custom_target_type(request, options = nil)
              #   Pass arguments to `update_custom_target_type` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::UpdateCustomTargetTypeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::UpdateCustomTargetTypeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_custom_target_type(update_mask: nil, custom_target_type: nil, request_id: nil, allow_missing: nil, validate_only: nil)
              #   Pass arguments to `update_custom_target_type` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten by the
              #     update in the `CustomTargetType` resource. The fields specified in the
              #     update_mask are relative to the resource, not the full request. A field
              #     will be overwritten if it's in the mask. If the user doesn't provide a mask
              #     then all fields are overwritten.
              #   @param custom_target_type [::Google::Cloud::Deploy::V1::CustomTargetType, ::Hash]
              #     Required. The `CustomTargetType` to update.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, updating a `CustomTargetType` that does not exist
              #     will result in the creation of a new `CustomTargetType`.
              #   @param validate_only [::Boolean]
              #     Optional. If set to true, the request is validated and the user is provided
              #     with an expected result, but no actual change is made.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::UpdateCustomTargetTypeRequest.new
              #
              #   # Call the update_custom_target_type method.
              #   result = client.update_custom_target_type request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_custom_target_type request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::UpdateCustomTargetTypeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_custom_target_type.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_custom_target_type.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_custom_target_type.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.update_custom_target_type request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single CustomTargetType.
              #
              # @overload delete_custom_target_type(request, options = nil)
              #   Pass arguments to `delete_custom_target_type` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::DeleteCustomTargetTypeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::DeleteCustomTargetTypeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_custom_target_type(name: nil, request_id: nil, allow_missing: nil, validate_only: nil, etag: nil)
              #   Pass arguments to `delete_custom_target_type` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `CustomTargetType` to delete. Format must be
              #     `projects/{project_id}/locations/{location_name}/customTargetTypes/{custom_target_type}`.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, then deleting an already deleted or non-existing
              #     `CustomTargetType` will succeed.
              #   @param validate_only [::Boolean]
              #     Optional. If set to true, the request is validated but no actual change is
              #     made.
              #   @param etag [::String]
              #     Optional. This checksum is computed by the server based on the value of
              #     other fields, and may be sent on update and delete requests to ensure the
              #     client has an up-to-date value before proceeding.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::DeleteCustomTargetTypeRequest.new
              #
              #   # Call the delete_custom_target_type method.
              #   result = client.delete_custom_target_type request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_custom_target_type request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::DeleteCustomTargetTypeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_custom_target_type.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_custom_target_type.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_custom_target_type.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.delete_custom_target_type request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Releases in a given project and location.
              #
              # @overload list_releases(request, options = nil)
              #   Pass arguments to `list_releases` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::ListReleasesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::ListReleasesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_releases(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_releases` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The `DeliveryPipeline` which owns this collection of `Release`
              #     objects.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of `Release` objects to return. The service
              #     may return fewer than this value. If unspecified, at most 50 `Release`
              #     objects will be returned. The maximum value is 1000; values above 1000 will
              #     be set to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListReleases` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other provided parameters match
              #     the call that provided the page token.
              #   @param filter [::String]
              #     Optional. Filter releases to be returned. See https://google.aip.dev/160
              #     for more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. See https://google.aip.dev/132#ordering for
              #     more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::Release>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::Release>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::ListReleasesRequest.new
              #
              #   # Call the list_releases method.
              #   result = client.list_releases request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Deploy::V1::Release.
              #     p item
              #   end
              #
              def list_releases request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::ListReleasesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_releases.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_releases.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_releases.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.list_releases request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_deploy_stub, :list_releases, "releases", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Release.
              #
              # @overload get_release(request, options = nil)
              #   Pass arguments to `get_release` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::GetReleaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::GetReleaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_release(name: nil)
              #   Pass arguments to `get_release` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the `Release`. Format must be
              #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::Release]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::Release]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::GetReleaseRequest.new
              #
              #   # Call the get_release method.
              #   result = client.get_release request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::Release.
              #   p result
              #
              def get_release request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::GetReleaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_release.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_release.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_release.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.get_release request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Release in a given project and location.
              #
              # @overload create_release(request, options = nil)
              #   Pass arguments to `create_release` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::CreateReleaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::CreateReleaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_release(parent: nil, release_id: nil, release: nil, request_id: nil, validate_only: nil, override_deploy_policy: nil)
              #   Pass arguments to `create_release` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent collection in which the `Release` is created.
              #     The format is
              #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
              #   @param release_id [::String]
              #     Required. ID of the `Release`.
              #   @param release [::Google::Cloud::Deploy::V1::Release, ::Hash]
              #     Required. The `Release` to create.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set to true, the request is validated and the user is provided
              #     with an expected result, but no actual change is made.
              #   @param override_deploy_policy [::Array<::String>]
              #     Optional. Deploy policies to override. Format is
              #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::CreateReleaseRequest.new
              #
              #   # Call the create_release method.
              #   result = client.create_release request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_release request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::CreateReleaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_release.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_release.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_release.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.create_release request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Abandons a Release in the Delivery Pipeline.
              #
              # @overload abandon_release(request, options = nil)
              #   Pass arguments to `abandon_release` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::AbandonReleaseRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::AbandonReleaseRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload abandon_release(name: nil)
              #   Pass arguments to `abandon_release` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the Release. Format is
              #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::AbandonReleaseResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::AbandonReleaseResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::AbandonReleaseRequest.new
              #
              #   # Call the abandon_release method.
              #   result = client.abandon_release request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::AbandonReleaseResponse.
              #   p result
              #
              def abandon_release request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::AbandonReleaseRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.abandon_release.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.abandon_release.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.abandon_release.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.abandon_release request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new DeployPolicy in a given project and location.
              #
              # @overload create_deploy_policy(request, options = nil)
              #   Pass arguments to `create_deploy_policy` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::CreateDeployPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::CreateDeployPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_deploy_policy(parent: nil, deploy_policy_id: nil, deploy_policy: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `create_deploy_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent collection in which the `DeployPolicy` must be
              #     created. The format is `projects/{project_id}/locations/{location_name}`.
              #   @param deploy_policy_id [::String]
              #     Required. ID of the `DeployPolicy`.
              #   @param deploy_policy [::Google::Cloud::Deploy::V1::DeployPolicy, ::Hash]
              #     Required. The `DeployPolicy` to create.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set to true, the request is validated and the user is provided
              #     with an expected result, but no actual change is made.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::CreateDeployPolicyRequest.new
              #
              #   # Call the create_deploy_policy method.
              #   result = client.create_deploy_policy request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_deploy_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::CreateDeployPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_deploy_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_deploy_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_deploy_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.create_deploy_policy request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single DeployPolicy.
              #
              # @overload update_deploy_policy(request, options = nil)
              #   Pass arguments to `update_deploy_policy` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::UpdateDeployPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::UpdateDeployPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_deploy_policy(update_mask: nil, deploy_policy: nil, request_id: nil, allow_missing: nil, validate_only: nil)
              #   Pass arguments to `update_deploy_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten by the
              #     update in the `DeployPolicy` resource. The fields specified in the
              #     update_mask are relative to the resource, not the full request. A field
              #     will be overwritten if it's in the mask. If the user doesn't provide a mask
              #     then all fields are overwritten.
              #   @param deploy_policy [::Google::Cloud::Deploy::V1::DeployPolicy, ::Hash]
              #     Required. The `DeployPolicy` to update.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, updating a `DeployPolicy` that does not exist
              #     will result in the creation of a new `DeployPolicy`.
              #   @param validate_only [::Boolean]
              #     Optional. If set to true, the request is validated and the user is provided
              #     with an expected result, but no actual change is made.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::UpdateDeployPolicyRequest.new
              #
              #   # Call the update_deploy_policy method.
              #   result = client.update_deploy_policy request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_deploy_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::UpdateDeployPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_deploy_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_deploy_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_deploy_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.update_deploy_policy request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single DeployPolicy.
              #
              # @overload delete_deploy_policy(request, options = nil)
              #   Pass arguments to `delete_deploy_policy` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::DeleteDeployPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::DeleteDeployPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_deploy_policy(name: nil, request_id: nil, allow_missing: nil, validate_only: nil, etag: nil)
              #   Pass arguments to `delete_deploy_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `DeployPolicy` to delete. The format is
              #     `projects/{project_id}/locations/{location_name}/deployPolicies/{deploy_policy_name}`.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, then deleting an already deleted or non-existing
              #     `DeployPolicy` will succeed.
              #   @param validate_only [::Boolean]
              #     Optional. If set, validate the request and preview the review, but do not
              #     actually post it.
              #   @param etag [::String]
              #     Optional. This checksum is computed by the server based on the value of
              #     other fields, and may be sent on update and delete requests to ensure the
              #     client has an up-to-date value before proceeding.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::DeleteDeployPolicyRequest.new
              #
              #   # Call the delete_deploy_policy method.
              #   result = client.delete_deploy_policy request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_deploy_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::DeleteDeployPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_deploy_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_deploy_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_deploy_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.delete_deploy_policy request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists DeployPolicies in a given project and location.
              #
              # @overload list_deploy_policies(request, options = nil)
              #   Pass arguments to `list_deploy_policies` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::ListDeployPoliciesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::ListDeployPoliciesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_deploy_policies(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_deploy_policies` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent, which owns this collection of deploy policies. Format
              #     must be `projects/{project_id}/locations/{location_name}`.
              #   @param page_size [::Integer]
              #     The maximum number of deploy policies to return. The service may return
              #     fewer than this value. If unspecified, at most 50 deploy policies will
              #     be returned. The maximum value is 1000; values above 1000 will be set
              #     to 1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListDeployPolicies` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other provided parameters match
              #     the call that provided the page token.
              #   @param filter [::String]
              #     Filter deploy policies to be returned. See https://google.aip.dev/160 for
              #     more details. All fields can be used in the filter.
              #   @param order_by [::String]
              #     Field to sort by. See https://google.aip.dev/132#ordering for more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::DeployPolicy>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::DeployPolicy>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::ListDeployPoliciesRequest.new
              #
              #   # Call the list_deploy_policies method.
              #   result = client.list_deploy_policies request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Deploy::V1::DeployPolicy.
              #     p item
              #   end
              #
              def list_deploy_policies request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::ListDeployPoliciesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_deploy_policies.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_deploy_policies.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_deploy_policies.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.list_deploy_policies request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_deploy_stub, :list_deploy_policies, "deploy_policies", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single DeployPolicy.
              #
              # @overload get_deploy_policy(request, options = nil)
              #   Pass arguments to `get_deploy_policy` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::GetDeployPolicyRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::GetDeployPolicyRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_deploy_policy(name: nil)
              #   Pass arguments to `get_deploy_policy` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the `DeployPolicy`. Format must be
              #     `projects/{project_id}/locations/{location_name}/deployPolicies/{deploy_policy_name}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::DeployPolicy]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::DeployPolicy]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::GetDeployPolicyRequest.new
              #
              #   # Call the get_deploy_policy method.
              #   result = client.get_deploy_policy request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::DeployPolicy.
              #   p result
              #
              def get_deploy_policy request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::GetDeployPolicyRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_deploy_policy.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_deploy_policy.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_deploy_policy.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.get_deploy_policy request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Approves a Rollout.
              #
              # @overload approve_rollout(request, options = nil)
              #   Pass arguments to `approve_rollout` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::ApproveRolloutRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::ApproveRolloutRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload approve_rollout(name: nil, approved: nil, override_deploy_policy: nil)
              #   Pass arguments to `approve_rollout` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the Rollout. Format is
              #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
              #   @param approved [::Boolean]
              #     Required. True = approve; false = reject
              #   @param override_deploy_policy [::Array<::String>]
              #     Optional. Deploy policies to override. Format is
              #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::ApproveRolloutResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::ApproveRolloutResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::ApproveRolloutRequest.new
              #
              #   # Call the approve_rollout method.
              #   result = client.approve_rollout request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::ApproveRolloutResponse.
              #   p result
              #
              def approve_rollout request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::ApproveRolloutRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.approve_rollout.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.approve_rollout.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.approve_rollout.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.approve_rollout request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Advances a Rollout in a given project and location.
              #
              # @overload advance_rollout(request, options = nil)
              #   Pass arguments to `advance_rollout` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::AdvanceRolloutRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::AdvanceRolloutRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload advance_rollout(name: nil, phase_id: nil, override_deploy_policy: nil)
              #   Pass arguments to `advance_rollout` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the Rollout. Format is
              #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
              #   @param phase_id [::String]
              #     Required. The phase ID to advance the `Rollout` to.
              #   @param override_deploy_policy [::Array<::String>]
              #     Optional. Deploy policies to override. Format is
              #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::AdvanceRolloutResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::AdvanceRolloutResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::AdvanceRolloutRequest.new
              #
              #   # Call the advance_rollout method.
              #   result = client.advance_rollout request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::AdvanceRolloutResponse.
              #   p result
              #
              def advance_rollout request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::AdvanceRolloutRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.advance_rollout.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.advance_rollout.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.advance_rollout.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.advance_rollout request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Cancels a Rollout in a given project and location.
              #
              # @overload cancel_rollout(request, options = nil)
              #   Pass arguments to `cancel_rollout` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::CancelRolloutRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::CancelRolloutRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload cancel_rollout(name: nil, override_deploy_policy: nil)
              #   Pass arguments to `cancel_rollout` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the Rollout. Format is
              #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
              #   @param override_deploy_policy [::Array<::String>]
              #     Optional. Deploy policies to override. Format is
              #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::CancelRolloutResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::CancelRolloutResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::CancelRolloutRequest.new
              #
              #   # Call the cancel_rollout method.
              #   result = client.cancel_rollout request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::CancelRolloutResponse.
              #   p result
              #
              def cancel_rollout request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::CancelRolloutRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.cancel_rollout.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.cancel_rollout.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.cancel_rollout.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.cancel_rollout request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Rollouts in a given project and location.
              #
              # @overload list_rollouts(request, options = nil)
              #   Pass arguments to `list_rollouts` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::ListRolloutsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::ListRolloutsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_rollouts(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_rollouts` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The `Release` which owns this collection of `Rollout` objects.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of `Rollout` objects to return. The service
              #     may return fewer than this value. If unspecified, at most 50 `Rollout`
              #     objects will be returned. The maximum value is 1000; values above 1000 will
              #     be set to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListRollouts` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other provided parameters match
              #     the call that provided the page token.
              #   @param filter [::String]
              #     Optional. Filter rollouts to be returned. See https://google.aip.dev/160
              #     for more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. See https://google.aip.dev/132#ordering for
              #     more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::Rollout>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::Rollout>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::ListRolloutsRequest.new
              #
              #   # Call the list_rollouts method.
              #   result = client.list_rollouts request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Deploy::V1::Rollout.
              #     p item
              #   end
              #
              def list_rollouts request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::ListRolloutsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_rollouts.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_rollouts.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_rollouts.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.list_rollouts request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_deploy_stub, :list_rollouts, "rollouts", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Rollout.
              #
              # @overload get_rollout(request, options = nil)
              #   Pass arguments to `get_rollout` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::GetRolloutRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::GetRolloutRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_rollout(name: nil)
              #   Pass arguments to `get_rollout` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the `Rollout`. Format must be
              #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}/rollouts/{rollout_name}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::Rollout]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::Rollout]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::GetRolloutRequest.new
              #
              #   # Call the get_rollout method.
              #   result = client.get_rollout request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::Rollout.
              #   p result
              #
              def get_rollout request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::GetRolloutRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_rollout.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_rollout.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_rollout.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.get_rollout request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Rollout in a given project and location.
              #
              # @overload create_rollout(request, options = nil)
              #   Pass arguments to `create_rollout` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::CreateRolloutRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::CreateRolloutRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_rollout(parent: nil, rollout_id: nil, rollout: nil, request_id: nil, validate_only: nil, override_deploy_policy: nil, starting_phase_id: nil)
              #   Pass arguments to `create_rollout` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent collection in which the `Rollout` must be created.
              #     The format is
              #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}`.
              #   @param rollout_id [::String]
              #     Required. ID of the `Rollout`.
              #   @param rollout [::Google::Cloud::Deploy::V1::Rollout, ::Hash]
              #     Required. The `Rollout` to create.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set to true, the request is validated and the user is provided
              #     with an expected result, but no actual change is made.
              #   @param override_deploy_policy [::Array<::String>]
              #     Optional. Deploy policies to override. Format is
              #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
              #   @param starting_phase_id [::String]
              #     Optional. The starting phase ID for the `Rollout`. If empty the `Rollout`
              #     will start at the first phase.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::CreateRolloutRequest.new
              #
              #   # Call the create_rollout method.
              #   result = client.create_rollout request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_rollout request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::CreateRolloutRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_rollout.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_rollout.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_rollout.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.create_rollout request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Ignores the specified Job in a Rollout.
              #
              # @overload ignore_job(request, options = nil)
              #   Pass arguments to `ignore_job` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::IgnoreJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::IgnoreJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload ignore_job(rollout: nil, phase_id: nil, job_id: nil, override_deploy_policy: nil)
              #   Pass arguments to `ignore_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param rollout [::String]
              #     Required. Name of the Rollout. Format is
              #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
              #   @param phase_id [::String]
              #     Required. The phase ID the Job to ignore belongs to.
              #   @param job_id [::String]
              #     Required. The job ID for the Job to ignore.
              #   @param override_deploy_policy [::Array<::String>]
              #     Optional. Deploy policies to override. Format is
              #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::IgnoreJobResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::IgnoreJobResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::IgnoreJobRequest.new
              #
              #   # Call the ignore_job method.
              #   result = client.ignore_job request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::IgnoreJobResponse.
              #   p result
              #
              def ignore_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::IgnoreJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.ignore_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.ignore_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.ignore_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.ignore_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retries the specified Job in a Rollout.
              #
              # @overload retry_job(request, options = nil)
              #   Pass arguments to `retry_job` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::RetryJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::RetryJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload retry_job(rollout: nil, phase_id: nil, job_id: nil, override_deploy_policy: nil)
              #   Pass arguments to `retry_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param rollout [::String]
              #     Required. Name of the Rollout. Format is
              #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}`.
              #   @param phase_id [::String]
              #     Required. The phase ID the Job to retry belongs to.
              #   @param job_id [::String]
              #     Required. The job ID for the Job to retry.
              #   @param override_deploy_policy [::Array<::String>]
              #     Optional. Deploy policies to override. Format is
              #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::RetryJobResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::RetryJobResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::RetryJobRequest.new
              #
              #   # Call the retry_job method.
              #   result = client.retry_job request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::RetryJobResponse.
              #   p result
              #
              def retry_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::RetryJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.retry_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.retry_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.retry_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.retry_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists JobRuns in a given project and location.
              #
              # @overload list_job_runs(request, options = nil)
              #   Pass arguments to `list_job_runs` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::ListJobRunsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::ListJobRunsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_job_runs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_job_runs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The `Rollout` which owns this collection of `JobRun` objects.
              #   @param page_size [::Integer]
              #     Optional. The maximum number of `JobRun` objects to return. The service may
              #     return fewer than this value. If unspecified, at most 50 `JobRun` objects
              #     will be returned. The maximum value is 1000; values above 1000 will be set
              #     to 1000.
              #   @param page_token [::String]
              #     Optional. A page token, received from a previous `ListJobRuns` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other provided parameters match the call that provided
              #     the page token.
              #   @param filter [::String]
              #     Optional. Filter results to be returned. See https://google.aip.dev/160 for
              #     more details.
              #   @param order_by [::String]
              #     Optional. Field to sort by. See https://google.aip.dev/132#ordering for
              #     more details.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::JobRun>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::JobRun>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::ListJobRunsRequest.new
              #
              #   # Call the list_job_runs method.
              #   result = client.list_job_runs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Deploy::V1::JobRun.
              #     p item
              #   end
              #
              def list_job_runs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::ListJobRunsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_job_runs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_job_runs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_job_runs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.list_job_runs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_deploy_stub, :list_job_runs, "job_runs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single JobRun.
              #
              # @overload get_job_run(request, options = nil)
              #   Pass arguments to `get_job_run` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::GetJobRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::GetJobRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_job_run(name: nil)
              #   Pass arguments to `get_job_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the `JobRun`. Format must be
              #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/releases/{release_name}/rollouts/{rollout_name}/jobRuns/{job_run_name}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::JobRun]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::JobRun]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::GetJobRunRequest.new
              #
              #   # Call the get_job_run method.
              #   result = client.get_job_run request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::JobRun.
              #   p result
              #
              def get_job_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::GetJobRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_job_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_job_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_job_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.get_job_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Terminates a Job Run in a given project and location.
              #
              # @overload terminate_job_run(request, options = nil)
              #   Pass arguments to `terminate_job_run` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::TerminateJobRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::TerminateJobRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload terminate_job_run(name: nil, override_deploy_policy: nil)
              #   Pass arguments to `terminate_job_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the `JobRun`. Format must be
              #     `projects/{project}/locations/{location}/deliveryPipelines/{deliveryPipeline}/releases/{release}/rollouts/{rollout}/jobRuns/{jobRun}`.
              #   @param override_deploy_policy [::Array<::String>]
              #     Optional. Deploy policies to override. Format is
              #     `projects/{project}/locations/{location}/deployPolicies/{deployPolicy}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::TerminateJobRunResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::TerminateJobRunResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::TerminateJobRunRequest.new
              #
              #   # Call the terminate_job_run method.
              #   result = client.terminate_job_run request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::TerminateJobRunResponse.
              #   p result
              #
              def terminate_job_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::TerminateJobRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.terminate_job_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.terminate_job_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.terminate_job_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.terminate_job_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the configuration for a location.
              #
              # @overload get_config(request, options = nil)
              #   Pass arguments to `get_config` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::GetConfigRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::GetConfigRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_config(name: nil)
              #   Pass arguments to `get_config` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of requested configuration.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::Config]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::Config]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::GetConfigRequest.new
              #
              #   # Call the get_config method.
              #   result = client.get_config request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::Config.
              #   p result
              #
              def get_config request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::GetConfigRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_config.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_config.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_config.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.get_config request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a new Automation in a given project and location.
              #
              # @overload create_automation(request, options = nil)
              #   Pass arguments to `create_automation` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::CreateAutomationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::CreateAutomationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_automation(parent: nil, automation_id: nil, automation: nil, request_id: nil, validate_only: nil)
              #   Pass arguments to `create_automation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent collection in which the `Automation` must be created.
              #     The format is
              #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
              #   @param automation_id [::String]
              #     Required. ID of the `Automation`.
              #   @param automation [::Google::Cloud::Deploy::V1::Automation, ::Hash]
              #     Required. The `Automation` to create.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. If set to true, the request is validated and the user is provided
              #     with an expected result, but no actual change is made.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::CreateAutomationRequest.new
              #
              #   # Call the create_automation method.
              #   result = client.create_automation request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_automation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::CreateAutomationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_automation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_automation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_automation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.create_automation request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates the parameters of a single Automation resource.
              #
              # @overload update_automation(request, options = nil)
              #   Pass arguments to `update_automation` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::UpdateAutomationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::UpdateAutomationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_automation(update_mask: nil, automation: nil, request_id: nil, allow_missing: nil, validate_only: nil)
              #   Pass arguments to `update_automation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Field mask is used to specify the fields to be overwritten by the
              #     update in the `Automation` resource. The fields specified in the
              #     update_mask are relative to the resource, not the full request. A field
              #     will be overwritten if it's in the mask. If the user doesn't provide a mask
              #     then all fields are overwritten.
              #   @param automation [::Google::Cloud::Deploy::V1::Automation, ::Hash]
              #     Required. The `Automation` to update.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, updating a `Automation` that does not exist will
              #     result in the creation of a new `Automation`.
              #   @param validate_only [::Boolean]
              #     Optional. If set to true, the request is validated and the user is provided
              #     with an expected result, but no actual change is made.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::UpdateAutomationRequest.new
              #
              #   # Call the update_automation method.
              #   result = client.update_automation request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_automation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::UpdateAutomationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_automation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_automation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_automation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.update_automation request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a single Automation resource.
              #
              # @overload delete_automation(request, options = nil)
              #   Pass arguments to `delete_automation` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::DeleteAutomationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::DeleteAutomationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_automation(name: nil, request_id: nil, allow_missing: nil, validate_only: nil, etag: nil)
              #   Pass arguments to `delete_automation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the `Automation` to delete. The format is
              #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/automations/{automation_name}`.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server knows to ignore the
              #     request if it has already been completed. The server guarantees that for
              #     at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param allow_missing [::Boolean]
              #     Optional. If set to true, then deleting an already deleted or non-existing
              #     `Automation` will succeed.
              #   @param validate_only [::Boolean]
              #     Optional. If set, validate the request and verify whether the resource
              #     exists, but do not actually post it.
              #   @param etag [::String]
              #     Optional. The weak etag of the request.
              #     This checksum is computed by the server based on the value of other
              #     fields, and may be sent on update and delete requests to ensure the
              #     client has an up-to-date value before proceeding.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::DeleteAutomationRequest.new
              #
              #   # Call the delete_automation method.
              #   result = client.delete_automation request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_automation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::DeleteAutomationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_automation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_automation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_automation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.delete_automation request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single Automation.
              #
              # @overload get_automation(request, options = nil)
              #   Pass arguments to `get_automation` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::GetAutomationRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::GetAutomationRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_automation(name: nil)
              #   Pass arguments to `get_automation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the `Automation`. Format must be
              #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}/automations/{automation_name}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::Automation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::Automation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::GetAutomationRequest.new
              #
              #   # Call the get_automation method.
              #   result = client.get_automation request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::Automation.
              #   p result
              #
              def get_automation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::GetAutomationRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_automation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_automation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_automation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.get_automation request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Automations in a given project and location.
              #
              # @overload list_automations(request, options = nil)
              #   Pass arguments to `list_automations` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::ListAutomationsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::ListAutomationsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_automations(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_automations` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent `Delivery Pipeline`, which owns this collection of
              #     automations. Format must be
              #     `projects/{project_id}/locations/{location_name}/deliveryPipelines/{pipeline_name}`.
              #   @param page_size [::Integer]
              #     The maximum number of automations to return. The service may return
              #     fewer than this value. If unspecified, at most 50 automations will
              #     be returned. The maximum value is 1000; values above 1000 will be set
              #     to 1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListAutomations` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other provided parameters match
              #     the call that provided the page token.
              #   @param filter [::String]
              #     Filter automations to be returned. All fields can be used in the
              #     filter.
              #   @param order_by [::String]
              #     Field to sort by.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::Automation>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::Automation>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::ListAutomationsRequest.new
              #
              #   # Call the list_automations method.
              #   result = client.list_automations request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Deploy::V1::Automation.
              #     p item
              #   end
              #
              def list_automations request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::ListAutomationsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_automations.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_automations.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_automations.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.list_automations request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_deploy_stub, :list_automations, "automations", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets details of a single AutomationRun.
              #
              # @overload get_automation_run(request, options = nil)
              #   Pass arguments to `get_automation_run` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::GetAutomationRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::GetAutomationRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_automation_run(name: nil)
              #   Pass arguments to `get_automation_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the `AutomationRun`. Format must be
              #     `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::AutomationRun]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::AutomationRun]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::GetAutomationRunRequest.new
              #
              #   # Call the get_automation_run method.
              #   result = client.get_automation_run request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::AutomationRun.
              #   p result
              #
              def get_automation_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::GetAutomationRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_automation_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_automation_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_automation_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.get_automation_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists AutomationRuns in a given project and location.
              #
              # @overload list_automation_runs(request, options = nil)
              #   Pass arguments to `list_automation_runs` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::ListAutomationRunsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::ListAutomationRunsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_automation_runs(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_automation_runs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent `Delivery Pipeline`, which owns this collection of
              #     automationRuns. Format must be
              #     `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}`.
              #   @param page_size [::Integer]
              #     The maximum number of automationRuns to return. The service may return
              #     fewer than this value. If unspecified, at most 50 automationRuns will
              #     be returned. The maximum value is 1000; values above 1000 will be set
              #     to 1000.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListAutomationRuns` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other provided parameters match
              #     the call that provided the page token.
              #   @param filter [::String]
              #     Filter automationRuns to be returned. All fields can be used in the
              #     filter.
              #   @param order_by [::String]
              #     Field to sort by.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::AutomationRun>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Deploy::V1::AutomationRun>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::ListAutomationRunsRequest.new
              #
              #   # Call the list_automation_runs method.
              #   result = client.list_automation_runs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Deploy::V1::AutomationRun.
              #     p item
              #   end
              #
              def list_automation_runs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::ListAutomationRunsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_automation_runs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_automation_runs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_automation_runs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.list_automation_runs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cloud_deploy_stub, :list_automation_runs, "automation_runs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Cancels an AutomationRun. The `state` of the `AutomationRun` after
              # cancelling is `CANCELLED`. `CancelAutomationRun` can be called on
              # AutomationRun in the state `IN_PROGRESS` and `PENDING`; AutomationRun
              # in a different state returns an `FAILED_PRECONDITION` error.
              #
              # @overload cancel_automation_run(request, options = nil)
              #   Pass arguments to `cancel_automation_run` via a request object, either of type
              #   {::Google::Cloud::Deploy::V1::CancelAutomationRunRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Deploy::V1::CancelAutomationRunRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload cancel_automation_run(name: nil)
              #   Pass arguments to `cancel_automation_run` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. Name of the `AutomationRun`. Format is
              #     `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Deploy::V1::CancelAutomationRunResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Deploy::V1::CancelAutomationRunResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/deploy/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Deploy::V1::CancelAutomationRunRequest.new
              #
              #   # Call the cancel_automation_run method.
              #   result = client.cancel_automation_run request
              #
              #   # The returned object is of type Google::Cloud::Deploy::V1::CancelAutomationRunResponse.
              #   p result
              #
              def cancel_automation_run request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Deploy::V1::CancelAutomationRunRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.cancel_automation_run.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Deploy::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.cancel_automation_run.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.cancel_automation_run.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cloud_deploy_stub.cancel_automation_run request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the CloudDeploy REST API.
              #
              # This class represents the configuration for CloudDeploy REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_delivery_pipelines to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_delivery_pipelines.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Deploy::V1::CloudDeploy::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_delivery_pipelines.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "clouddeploy.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the CloudDeploy API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_delivery_pipelines`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_delivery_pipelines
                  ##
                  # RPC-specific configuration for `get_delivery_pipeline`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_delivery_pipeline
                  ##
                  # RPC-specific configuration for `create_delivery_pipeline`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_delivery_pipeline
                  ##
                  # RPC-specific configuration for `update_delivery_pipeline`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_delivery_pipeline
                  ##
                  # RPC-specific configuration for `delete_delivery_pipeline`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_delivery_pipeline
                  ##
                  # RPC-specific configuration for `list_targets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_targets
                  ##
                  # RPC-specific configuration for `rollback_target`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :rollback_target
                  ##
                  # RPC-specific configuration for `get_target`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_target
                  ##
                  # RPC-specific configuration for `create_target`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_target
                  ##
                  # RPC-specific configuration for `update_target`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_target
                  ##
                  # RPC-specific configuration for `delete_target`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_target
                  ##
                  # RPC-specific configuration for `list_custom_target_types`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_custom_target_types
                  ##
                  # RPC-specific configuration for `get_custom_target_type`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_custom_target_type
                  ##
                  # RPC-specific configuration for `create_custom_target_type`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_custom_target_type
                  ##
                  # RPC-specific configuration for `update_custom_target_type`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_custom_target_type
                  ##
                  # RPC-specific configuration for `delete_custom_target_type`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_custom_target_type
                  ##
                  # RPC-specific configuration for `list_releases`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_releases
                  ##
                  # RPC-specific configuration for `get_release`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_release
                  ##
                  # RPC-specific configuration for `create_release`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_release
                  ##
                  # RPC-specific configuration for `abandon_release`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :abandon_release
                  ##
                  # RPC-specific configuration for `create_deploy_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_deploy_policy
                  ##
                  # RPC-specific configuration for `update_deploy_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_deploy_policy
                  ##
                  # RPC-specific configuration for `delete_deploy_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_deploy_policy
                  ##
                  # RPC-specific configuration for `list_deploy_policies`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_deploy_policies
                  ##
                  # RPC-specific configuration for `get_deploy_policy`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_deploy_policy
                  ##
                  # RPC-specific configuration for `approve_rollout`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :approve_rollout
                  ##
                  # RPC-specific configuration for `advance_rollout`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :advance_rollout
                  ##
                  # RPC-specific configuration for `cancel_rollout`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :cancel_rollout
                  ##
                  # RPC-specific configuration for `list_rollouts`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_rollouts
                  ##
                  # RPC-specific configuration for `get_rollout`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_rollout
                  ##
                  # RPC-specific configuration for `create_rollout`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_rollout
                  ##
                  # RPC-specific configuration for `ignore_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :ignore_job
                  ##
                  # RPC-specific configuration for `retry_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :retry_job
                  ##
                  # RPC-specific configuration for `list_job_runs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_job_runs
                  ##
                  # RPC-specific configuration for `get_job_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_job_run
                  ##
                  # RPC-specific configuration for `terminate_job_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :terminate_job_run
                  ##
                  # RPC-specific configuration for `get_config`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_config
                  ##
                  # RPC-specific configuration for `create_automation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_automation
                  ##
                  # RPC-specific configuration for `update_automation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_automation
                  ##
                  # RPC-specific configuration for `delete_automation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_automation
                  ##
                  # RPC-specific configuration for `get_automation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_automation
                  ##
                  # RPC-specific configuration for `list_automations`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_automations
                  ##
                  # RPC-specific configuration for `get_automation_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_automation_run
                  ##
                  # RPC-specific configuration for `list_automation_runs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_automation_runs
                  ##
                  # RPC-specific configuration for `cancel_automation_run`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :cancel_automation_run

                  # @private
                  def initialize parent_rpcs = nil
                    list_delivery_pipelines_config = parent_rpcs.list_delivery_pipelines if parent_rpcs.respond_to? :list_delivery_pipelines
                    @list_delivery_pipelines = ::Gapic::Config::Method.new list_delivery_pipelines_config
                    get_delivery_pipeline_config = parent_rpcs.get_delivery_pipeline if parent_rpcs.respond_to? :get_delivery_pipeline
                    @get_delivery_pipeline = ::Gapic::Config::Method.new get_delivery_pipeline_config
                    create_delivery_pipeline_config = parent_rpcs.create_delivery_pipeline if parent_rpcs.respond_to? :create_delivery_pipeline
                    @create_delivery_pipeline = ::Gapic::Config::Method.new create_delivery_pipeline_config
                    update_delivery_pipeline_config = parent_rpcs.update_delivery_pipeline if parent_rpcs.respond_to? :update_delivery_pipeline
                    @update_delivery_pipeline = ::Gapic::Config::Method.new update_delivery_pipeline_config
                    delete_delivery_pipeline_config = parent_rpcs.delete_delivery_pipeline if parent_rpcs.respond_to? :delete_delivery_pipeline
                    @delete_delivery_pipeline = ::Gapic::Config::Method.new delete_delivery_pipeline_config
                    list_targets_config = parent_rpcs.list_targets if parent_rpcs.respond_to? :list_targets
                    @list_targets = ::Gapic::Config::Method.new list_targets_config
                    rollback_target_config = parent_rpcs.rollback_target if parent_rpcs.respond_to? :rollback_target
                    @rollback_target = ::Gapic::Config::Method.new rollback_target_config
                    get_target_config = parent_rpcs.get_target if parent_rpcs.respond_to? :get_target
                    @get_target = ::Gapic::Config::Method.new get_target_config
                    create_target_config = parent_rpcs.create_target if parent_rpcs.respond_to? :create_target
                    @create_target = ::Gapic::Config::Method.new create_target_config
                    update_target_config = parent_rpcs.update_target if parent_rpcs.respond_to? :update_target
                    @update_target = ::Gapic::Config::Method.new update_target_config
                    delete_target_config = parent_rpcs.delete_target if parent_rpcs.respond_to? :delete_target
                    @delete_target = ::Gapic::Config::Method.new delete_target_config
                    list_custom_target_types_config = parent_rpcs.list_custom_target_types if parent_rpcs.respond_to? :list_custom_target_types
                    @list_custom_target_types = ::Gapic::Config::Method.new list_custom_target_types_config
                    get_custom_target_type_config = parent_rpcs.get_custom_target_type if parent_rpcs.respond_to? :get_custom_target_type
                    @get_custom_target_type = ::Gapic::Config::Method.new get_custom_target_type_config
                    create_custom_target_type_config = parent_rpcs.create_custom_target_type if parent_rpcs.respond_to? :create_custom_target_type
                    @create_custom_target_type = ::Gapic::Config::Method.new create_custom_target_type_config
                    update_custom_target_type_config = parent_rpcs.update_custom_target_type if parent_rpcs.respond_to? :update_custom_target_type
                    @update_custom_target_type = ::Gapic::Config::Method.new update_custom_target_type_config
                    delete_custom_target_type_config = parent_rpcs.delete_custom_target_type if parent_rpcs.respond_to? :delete_custom_target_type
                    @delete_custom_target_type = ::Gapic::Config::Method.new delete_custom_target_type_config
                    list_releases_config = parent_rpcs.list_releases if parent_rpcs.respond_to? :list_releases
                    @list_releases = ::Gapic::Config::Method.new list_releases_config
                    get_release_config = parent_rpcs.get_release if parent_rpcs.respond_to? :get_release
                    @get_release = ::Gapic::Config::Method.new get_release_config
                    create_release_config = parent_rpcs.create_release if parent_rpcs.respond_to? :create_release
                    @create_release = ::Gapic::Config::Method.new create_release_config
                    abandon_release_config = parent_rpcs.abandon_release if parent_rpcs.respond_to? :abandon_release
                    @abandon_release = ::Gapic::Config::Method.new abandon_release_config
                    create_deploy_policy_config = parent_rpcs.create_deploy_policy if parent_rpcs.respond_to? :create_deploy_policy
                    @create_deploy_policy = ::Gapic::Config::Method.new create_deploy_policy_config
                    update_deploy_policy_config = parent_rpcs.update_deploy_policy if parent_rpcs.respond_to? :update_deploy_policy
                    @update_deploy_policy = ::Gapic::Config::Method.new update_deploy_policy_config
                    delete_deploy_policy_config = parent_rpcs.delete_deploy_policy if parent_rpcs.respond_to? :delete_deploy_policy
                    @delete_deploy_policy = ::Gapic::Config::Method.new delete_deploy_policy_config
                    list_deploy_policies_config = parent_rpcs.list_deploy_policies if parent_rpcs.respond_to? :list_deploy_policies
                    @list_deploy_policies = ::Gapic::Config::Method.new list_deploy_policies_config
                    get_deploy_policy_config = parent_rpcs.get_deploy_policy if parent_rpcs.respond_to? :get_deploy_policy
                    @get_deploy_policy = ::Gapic::Config::Method.new get_deploy_policy_config
                    approve_rollout_config = parent_rpcs.approve_rollout if parent_rpcs.respond_to? :approve_rollout
                    @approve_rollout = ::Gapic::Config::Method.new approve_rollout_config
                    advance_rollout_config = parent_rpcs.advance_rollout if parent_rpcs.respond_to? :advance_rollout
                    @advance_rollout = ::Gapic::Config::Method.new advance_rollout_config
                    cancel_rollout_config = parent_rpcs.cancel_rollout if parent_rpcs.respond_to? :cancel_rollout
                    @cancel_rollout = ::Gapic::Config::Method.new cancel_rollout_config
                    list_rollouts_config = parent_rpcs.list_rollouts if parent_rpcs.respond_to? :list_rollouts
                    @list_rollouts = ::Gapic::Config::Method.new list_rollouts_config
                    get_rollout_config = parent_rpcs.get_rollout if parent_rpcs.respond_to? :get_rollout
                    @get_rollout = ::Gapic::Config::Method.new get_rollout_config
                    create_rollout_config = parent_rpcs.create_rollout if parent_rpcs.respond_to? :create_rollout
                    @create_rollout = ::Gapic::Config::Method.new create_rollout_config
                    ignore_job_config = parent_rpcs.ignore_job if parent_rpcs.respond_to? :ignore_job
                    @ignore_job = ::Gapic::Config::Method.new ignore_job_config
                    retry_job_config = parent_rpcs.retry_job if parent_rpcs.respond_to? :retry_job
                    @retry_job = ::Gapic::Config::Method.new retry_job_config
                    list_job_runs_config = parent_rpcs.list_job_runs if parent_rpcs.respond_to? :list_job_runs
                    @list_job_runs = ::Gapic::Config::Method.new list_job_runs_config
                    get_job_run_config = parent_rpcs.get_job_run if parent_rpcs.respond_to? :get_job_run
                    @get_job_run = ::Gapic::Config::Method.new get_job_run_config
                    terminate_job_run_config = parent_rpcs.terminate_job_run if parent_rpcs.respond_to? :terminate_job_run
                    @terminate_job_run = ::Gapic::Config::Method.new terminate_job_run_config
                    get_config_config = parent_rpcs.get_config if parent_rpcs.respond_to? :get_config
                    @get_config = ::Gapic::Config::Method.new get_config_config
                    create_automation_config = parent_rpcs.create_automation if parent_rpcs.respond_to? :create_automation
                    @create_automation = ::Gapic::Config::Method.new create_automation_config
                    update_automation_config = parent_rpcs.update_automation if parent_rpcs.respond_to? :update_automation
                    @update_automation = ::Gapic::Config::Method.new update_automation_config
                    delete_automation_config = parent_rpcs.delete_automation if parent_rpcs.respond_to? :delete_automation
                    @delete_automation = ::Gapic::Config::Method.new delete_automation_config
                    get_automation_config = parent_rpcs.get_automation if parent_rpcs.respond_to? :get_automation
                    @get_automation = ::Gapic::Config::Method.new get_automation_config
                    list_automations_config = parent_rpcs.list_automations if parent_rpcs.respond_to? :list_automations
                    @list_automations = ::Gapic::Config::Method.new list_automations_config
                    get_automation_run_config = parent_rpcs.get_automation_run if parent_rpcs.respond_to? :get_automation_run
                    @get_automation_run = ::Gapic::Config::Method.new get_automation_run_config
                    list_automation_runs_config = parent_rpcs.list_automation_runs if parent_rpcs.respond_to? :list_automation_runs
                    @list_automation_runs = ::Gapic::Config::Method.new list_automation_runs_config
                    cancel_automation_run_config = parent_rpcs.cancel_automation_run if parent_rpcs.respond_to? :cancel_automation_run
                    @cancel_automation_run = ::Gapic::Config::Method.new cancel_automation_run_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
