# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Deploy
      module V1
        module CloudDeploy
          # Path helper methods for the CloudDeploy API.
          module Paths
            ##
            # Create a fully-qualified Automation resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automations/{automation}`
            #
            # @param project [String]
            # @param location [String]
            # @param delivery_pipeline [String]
            # @param automation [String]
            #
            # @return [::String]
            def automation_path project:, location:, delivery_pipeline:, automation:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "delivery_pipeline cannot contain /" if delivery_pipeline.to_s.include? "/"

              "projects/#{project}/locations/#{location}/deliveryPipelines/#{delivery_pipeline}/automations/#{automation}"
            end

            ##
            # Create a fully-qualified AutomationRun resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/automationRuns/{automation_run}`
            #
            # @param project [String]
            # @param location [String]
            # @param delivery_pipeline [String]
            # @param automation_run [String]
            #
            # @return [::String]
            def automation_run_path project:, location:, delivery_pipeline:, automation_run:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "delivery_pipeline cannot contain /" if delivery_pipeline.to_s.include? "/"

              "projects/#{project}/locations/#{location}/deliveryPipelines/#{delivery_pipeline}/automationRuns/#{automation_run}"
            end

            ##
            # Create a fully-qualified Build resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/builds/{build}`
            #
            # @param project [String]
            # @param location [String]
            # @param build [String]
            #
            # @return [::String]
            def build_path project:, location:, build:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/builds/#{build}"
            end

            ##
            # Create a fully-qualified Cluster resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/clusters/{cluster}`
            #
            # @param project [String]
            # @param location [String]
            # @param cluster [String]
            #
            # @return [::String]
            def cluster_path project:, location:, cluster:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/clusters/#{cluster}"
            end

            ##
            # Create a fully-qualified Config resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/config`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def config_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}/config"
            end

            ##
            # Create a fully-qualified CustomTargetType resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/customTargetTypes/{custom_target_type}`
            #
            # @param project [String]
            # @param location [String]
            # @param custom_target_type [String]
            #
            # @return [::String]
            def custom_target_type_path project:, location:, custom_target_type:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/customTargetTypes/#{custom_target_type}"
            end

            ##
            # Create a fully-qualified DeliveryPipeline resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}`
            #
            # @param project [String]
            # @param location [String]
            # @param delivery_pipeline [String]
            #
            # @return [::String]
            def delivery_pipeline_path project:, location:, delivery_pipeline:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/deliveryPipelines/#{delivery_pipeline}"
            end

            ##
            # Create a fully-qualified DeployPolicy resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/deployPolicies/{deploy_policy}`
            #
            # @param project [String]
            # @param location [String]
            # @param deploy_policy [String]
            #
            # @return [::String]
            def deploy_policy_path project:, location:, deploy_policy:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/deployPolicies/#{deploy_policy}"
            end

            ##
            # Create a fully-qualified Job resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/jobs/{job}`
            #
            # @param project [String]
            # @param location [String]
            # @param job [String]
            #
            # @return [::String]
            def job_path project:, location:, job:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/jobs/#{job}"
            end

            ##
            # Create a fully-qualified JobRun resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}/rollouts/{rollout}/jobRuns/{job_run}`
            #
            # @param project [String]
            # @param location [String]
            # @param delivery_pipeline [String]
            # @param release [String]
            # @param rollout [String]
            # @param job_run [String]
            #
            # @return [::String]
            def job_run_path project:, location:, delivery_pipeline:, release:, rollout:, job_run:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "delivery_pipeline cannot contain /" if delivery_pipeline.to_s.include? "/"
              raise ::ArgumentError, "release cannot contain /" if release.to_s.include? "/"
              raise ::ArgumentError, "rollout cannot contain /" if rollout.to_s.include? "/"

              "projects/#{project}/locations/#{location}/deliveryPipelines/#{delivery_pipeline}/releases/#{release}/rollouts/#{rollout}/jobRuns/#{job_run}"
            end

            ##
            # Create a fully-qualified Location resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}`
            #
            # @param project [String]
            # @param location [String]
            #
            # @return [::String]
            def location_path project:, location:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"

              "projects/#{project}/locations/#{location}"
            end

            ##
            # Create a fully-qualified Membership resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/memberships/{membership}`
            #
            # @param project [String]
            # @param location [String]
            # @param membership [String]
            #
            # @return [::String]
            def membership_path project:, location:, membership:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/memberships/#{membership}"
            end

            ##
            # Create a fully-qualified Release resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}`
            #
            # @param project [String]
            # @param location [String]
            # @param delivery_pipeline [String]
            # @param release [String]
            #
            # @return [::String]
            def release_path project:, location:, delivery_pipeline:, release:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "delivery_pipeline cannot contain /" if delivery_pipeline.to_s.include? "/"

              "projects/#{project}/locations/#{location}/deliveryPipelines/#{delivery_pipeline}/releases/#{release}"
            end

            ##
            # Create a fully-qualified Repository resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/connections/{connection}/repositories/{repository}`
            #
            # @param project [String]
            # @param location [String]
            # @param connection [String]
            # @param repository [String]
            #
            # @return [::String]
            def repository_path project:, location:, connection:, repository:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "connection cannot contain /" if connection.to_s.include? "/"

              "projects/#{project}/locations/#{location}/connections/#{connection}/repositories/#{repository}"
            end

            ##
            # Create a fully-qualified Rollout resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/deliveryPipelines/{delivery_pipeline}/releases/{release}/rollouts/{rollout}`
            #
            # @param project [String]
            # @param location [String]
            # @param delivery_pipeline [String]
            # @param release [String]
            # @param rollout [String]
            #
            # @return [::String]
            def rollout_path project:, location:, delivery_pipeline:, release:, rollout:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "delivery_pipeline cannot contain /" if delivery_pipeline.to_s.include? "/"
              raise ::ArgumentError, "release cannot contain /" if release.to_s.include? "/"

              "projects/#{project}/locations/#{location}/deliveryPipelines/#{delivery_pipeline}/releases/#{release}/rollouts/#{rollout}"
            end

            ##
            # Create a fully-qualified Service resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/services/{service}`
            #
            # @param project [String]
            # @param location [String]
            # @param service [String]
            #
            # @return [::String]
            def service_path project:, location:, service:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/services/#{service}"
            end

            ##
            # Create a fully-qualified Target resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/targets/{target}`
            #
            # @param project [String]
            # @param location [String]
            # @param target [String]
            #
            # @return [::String]
            def target_path project:, location:, target:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/targets/#{target}"
            end

            ##
            # Create a fully-qualified WorkerPool resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/workerPools/{worker_pool}`
            #
            # @param project [String]
            # @param location [String]
            # @param worker_pool [String]
            #
            # @return [::String]
            def worker_pool_path project:, location:, worker_pool:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"

              "projects/#{project}/locations/#{location}/workerPools/#{worker_pool}"
            end

            extend self
          end
        end
      end
    end
  end
end
