# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/datastream/v1alpha1/datastream_pb"
require "google/cloud/datastream/v1alpha1/datastream"

class ::Google::Cloud::Datastream::V1alpha1::Datastream::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_connection_profiles
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Datastream::V1alpha1::ListConnectionProfilesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_connection_profiles_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_connection_profiles, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::ListConnectionProfilesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_connection_profiles_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_connection_profiles({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_connection_profiles parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_connection_profiles ::Google::Cloud::Datastream::V1alpha1::ListConnectionProfilesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_connection_profiles({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_connection_profiles(::Google::Cloud::Datastream::V1alpha1::ListConnectionProfilesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_connection_profiles_client_stub.call_rpc_count
    end
  end

  def test_get_connection_profile
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Datastream::V1alpha1::ConnectionProfile.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_connection_profile_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_connection_profile, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::GetConnectionProfileRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_connection_profile_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_connection_profile({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_connection_profile name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_connection_profile ::Google::Cloud::Datastream::V1alpha1::GetConnectionProfileRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_connection_profile({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_connection_profile(::Google::Cloud::Datastream::V1alpha1::GetConnectionProfileRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_connection_profile_client_stub.call_rpc_count
    end
  end

  def test_create_connection_profile
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    connection_profile_id = "hello world"
    connection_profile = {}
    request_id = "hello world"

    create_connection_profile_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_connection_profile, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::CreateConnectionProfileRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["connection_profile_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Datastream::V1alpha1::ConnectionProfile), request["connection_profile"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_connection_profile_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_connection_profile({ parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_connection_profile parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_connection_profile ::Google::Cloud::Datastream::V1alpha1::CreateConnectionProfileRequest.new(parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_connection_profile({ parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_connection_profile(::Google::Cloud::Datastream::V1alpha1::CreateConnectionProfileRequest.new(parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_connection_profile_client_stub.call_rpc_count
    end
  end

  def test_update_connection_profile
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    connection_profile = {}
    request_id = "hello world"

    update_connection_profile_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_connection_profile, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::UpdateConnectionProfileRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Datastream::V1alpha1::ConnectionProfile), request["connection_profile"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_connection_profile_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_connection_profile({ update_mask: update_mask, connection_profile: connection_profile, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_connection_profile update_mask: update_mask, connection_profile: connection_profile, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_connection_profile ::Google::Cloud::Datastream::V1alpha1::UpdateConnectionProfileRequest.new(update_mask: update_mask, connection_profile: connection_profile, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_connection_profile({ update_mask: update_mask, connection_profile: connection_profile, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_connection_profile(::Google::Cloud::Datastream::V1alpha1::UpdateConnectionProfileRequest.new(update_mask: update_mask, connection_profile: connection_profile, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_connection_profile_client_stub.call_rpc_count
    end
  end

  def test_delete_connection_profile
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_connection_profile_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_connection_profile, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::DeleteConnectionProfileRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_connection_profile_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_connection_profile({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_connection_profile name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_connection_profile ::Google::Cloud::Datastream::V1alpha1::DeleteConnectionProfileRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_connection_profile({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_connection_profile(::Google::Cloud::Datastream::V1alpha1::DeleteConnectionProfileRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_connection_profile_client_stub.call_rpc_count
    end
  end

  def test_discover_connection_profile
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Datastream::V1alpha1::DiscoverConnectionProfileResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    connection_profile = {}
    recursive = true
    oracle_rdbms = {}

    discover_connection_profile_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :discover_connection_profile, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::DiscoverConnectionProfileRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Datastream::V1alpha1::ConnectionProfile), request["connection_profile"]
      assert_equal :connection_profile, request.target
      assert_equal true, request["recursive"]
      assert_equal :recursive, request.depth
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Datastream::V1alpha1::OracleRdbms), request["oracle_rdbms"]
      assert_equal :oracle_rdbms, request.data_object
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, discover_connection_profile_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.discover_connection_profile({ parent: parent, connection_profile: connection_profile, recursive: recursive, oracle_rdbms: oracle_rdbms }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.discover_connection_profile parent: parent, connection_profile: connection_profile, recursive: recursive, oracle_rdbms: oracle_rdbms do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.discover_connection_profile ::Google::Cloud::Datastream::V1alpha1::DiscoverConnectionProfileRequest.new(parent: parent, connection_profile: connection_profile, recursive: recursive, oracle_rdbms: oracle_rdbms) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.discover_connection_profile({ parent: parent, connection_profile: connection_profile, recursive: recursive, oracle_rdbms: oracle_rdbms }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.discover_connection_profile(::Google::Cloud::Datastream::V1alpha1::DiscoverConnectionProfileRequest.new(parent: parent, connection_profile: connection_profile, recursive: recursive, oracle_rdbms: oracle_rdbms), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, discover_connection_profile_client_stub.call_rpc_count
    end
  end

  def test_list_streams
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Datastream::V1alpha1::ListStreamsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_streams_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_streams, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::ListStreamsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_streams_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_streams({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_streams parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_streams ::Google::Cloud::Datastream::V1alpha1::ListStreamsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_streams({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_streams(::Google::Cloud::Datastream::V1alpha1::ListStreamsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_streams_client_stub.call_rpc_count
    end
  end

  def test_get_stream
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Datastream::V1alpha1::Stream.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_stream_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_stream, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::GetStreamRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_stream_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_stream({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_stream name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_stream ::Google::Cloud::Datastream::V1alpha1::GetStreamRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_stream({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_stream(::Google::Cloud::Datastream::V1alpha1::GetStreamRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_stream_client_stub.call_rpc_count
    end
  end

  def test_create_stream
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    stream_id = "hello world"
    stream = {}
    request_id = "hello world"
    validate_only = true
    force = true

    create_stream_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_stream, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::CreateStreamRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["stream_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Datastream::V1alpha1::Stream), request["stream"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_stream_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_stream({ parent: parent, stream_id: stream_id, stream: stream, request_id: request_id, validate_only: validate_only, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_stream parent: parent, stream_id: stream_id, stream: stream, request_id: request_id, validate_only: validate_only, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_stream ::Google::Cloud::Datastream::V1alpha1::CreateStreamRequest.new(parent: parent, stream_id: stream_id, stream: stream, request_id: request_id, validate_only: validate_only, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_stream({ parent: parent, stream_id: stream_id, stream: stream, request_id: request_id, validate_only: validate_only, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_stream(::Google::Cloud::Datastream::V1alpha1::CreateStreamRequest.new(parent: parent, stream_id: stream_id, stream: stream, request_id: request_id, validate_only: validate_only, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_stream_client_stub.call_rpc_count
    end
  end

  def test_update_stream
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    stream = {}
    request_id = "hello world"
    validate_only = true
    force = true

    update_stream_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_stream, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::UpdateStreamRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Datastream::V1alpha1::Stream), request["stream"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["validate_only"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_stream_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_stream({ update_mask: update_mask, stream: stream, request_id: request_id, validate_only: validate_only, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_stream update_mask: update_mask, stream: stream, request_id: request_id, validate_only: validate_only, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_stream ::Google::Cloud::Datastream::V1alpha1::UpdateStreamRequest.new(update_mask: update_mask, stream: stream, request_id: request_id, validate_only: validate_only, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_stream({ update_mask: update_mask, stream: stream, request_id: request_id, validate_only: validate_only, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_stream(::Google::Cloud::Datastream::V1alpha1::UpdateStreamRequest.new(update_mask: update_mask, stream: stream, request_id: request_id, validate_only: validate_only, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_stream_client_stub.call_rpc_count
    end
  end

  def test_delete_stream
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_stream_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_stream, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::DeleteStreamRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_stream_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_stream({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_stream name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_stream ::Google::Cloud::Datastream::V1alpha1::DeleteStreamRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_stream({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_stream(::Google::Cloud::Datastream::V1alpha1::DeleteStreamRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_stream_client_stub.call_rpc_count
    end
  end

  def test_fetch_errors
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    stream = "hello world"

    fetch_errors_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_errors, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::FetchErrorsRequest, request
      assert_equal "hello world", request["stream"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_errors_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_errors({ stream: stream }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_errors stream: stream do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_errors ::Google::Cloud::Datastream::V1alpha1::FetchErrorsRequest.new(stream: stream) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_errors({ stream: stream }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_errors(::Google::Cloud::Datastream::V1alpha1::FetchErrorsRequest.new(stream: stream), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_errors_client_stub.call_rpc_count
    end
  end

  def test_fetch_static_ips
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Datastream::V1alpha1::FetchStaticIpsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    fetch_static_ips_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :fetch_static_ips, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::FetchStaticIpsRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, fetch_static_ips_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.fetch_static_ips({ name: name, page_size: page_size, page_token: page_token }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.fetch_static_ips name: name, page_size: page_size, page_token: page_token do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.fetch_static_ips ::Google::Cloud::Datastream::V1alpha1::FetchStaticIpsRequest.new(name: name, page_size: page_size, page_token: page_token) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.fetch_static_ips({ name: name, page_size: page_size, page_token: page_token }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.fetch_static_ips(::Google::Cloud::Datastream::V1alpha1::FetchStaticIpsRequest.new(name: name, page_size: page_size, page_token: page_token), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, fetch_static_ips_client_stub.call_rpc_count
    end
  end

  def test_create_private_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    private_connection_id = "hello world"
    private_connection = {}
    request_id = "hello world"

    create_private_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_private_connection, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::CreatePrivateConnectionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["private_connection_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Datastream::V1alpha1::PrivateConnection), request["private_connection"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_private_connection_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_private_connection({ parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_private_connection parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_private_connection ::Google::Cloud::Datastream::V1alpha1::CreatePrivateConnectionRequest.new(parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_private_connection({ parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_private_connection(::Google::Cloud::Datastream::V1alpha1::CreatePrivateConnectionRequest.new(parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_private_connection_client_stub.call_rpc_count
    end
  end

  def test_get_private_connection
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Datastream::V1alpha1::PrivateConnection.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_private_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_private_connection, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::GetPrivateConnectionRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_private_connection_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_private_connection({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_private_connection name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_private_connection ::Google::Cloud::Datastream::V1alpha1::GetPrivateConnectionRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_private_connection({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_private_connection(::Google::Cloud::Datastream::V1alpha1::GetPrivateConnectionRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_private_connection_client_stub.call_rpc_count
    end
  end

  def test_list_private_connections
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Datastream::V1alpha1::ListPrivateConnectionsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_private_connections_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_private_connections, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::ListPrivateConnectionsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_private_connections_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_private_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_private_connections parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_private_connections ::Google::Cloud::Datastream::V1alpha1::ListPrivateConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_private_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_private_connections(::Google::Cloud::Datastream::V1alpha1::ListPrivateConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_private_connections_client_stub.call_rpc_count
    end
  end

  def test_delete_private_connection
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_private_connection_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_private_connection, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::DeletePrivateConnectionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      assert_equal true, request["force"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_private_connection_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_private_connection({ name: name, request_id: request_id, force: force }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_private_connection name: name, request_id: request_id, force: force do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_private_connection ::Google::Cloud::Datastream::V1alpha1::DeletePrivateConnectionRequest.new(name: name, request_id: request_id, force: force) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_private_connection({ name: name, request_id: request_id, force: force }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_private_connection(::Google::Cloud::Datastream::V1alpha1::DeletePrivateConnectionRequest.new(name: name, request_id: request_id, force: force), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_private_connection_client_stub.call_rpc_count
    end
  end

  def test_create_route
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    route_id = "hello world"
    route = {}
    request_id = "hello world"

    create_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_route, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::CreateRouteRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["route_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Datastream::V1alpha1::Route), request["route"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_route_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_route({ parent: parent, route_id: route_id, route: route, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_route parent: parent, route_id: route_id, route: route, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_route ::Google::Cloud::Datastream::V1alpha1::CreateRouteRequest.new(parent: parent, route_id: route_id, route: route, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_route({ parent: parent, route_id: route_id, route: route, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_route(::Google::Cloud::Datastream::V1alpha1::CreateRouteRequest.new(parent: parent, route_id: route_id, route: route, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_route_client_stub.call_rpc_count
    end
  end

  def test_get_route
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Datastream::V1alpha1::Route.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_route, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::GetRouteRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_route_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_route({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_route name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_route ::Google::Cloud::Datastream::V1alpha1::GetRouteRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_route({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_route(::Google::Cloud::Datastream::V1alpha1::GetRouteRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_route_client_stub.call_rpc_count
    end
  end

  def test_list_routes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Datastream::V1alpha1::ListRoutesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_routes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_routes, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::ListRoutesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_routes_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_routes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_routes parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_routes ::Google::Cloud::Datastream::V1alpha1::ListRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_routes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_routes(::Google::Cloud::Datastream::V1alpha1::ListRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_routes_client_stub.call_rpc_count
    end
  end

  def test_delete_route
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_route_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_route, name
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::DeleteRouteRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_route_client_stub do
      # Create client
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_route({ name: name, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_route name: name, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_route ::Google::Cloud::Datastream::V1alpha1::DeleteRouteRequest.new(name: name, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_route({ name: name, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_route(::Google::Cloud::Datastream::V1alpha1::DeleteRouteRequest.new(name: name, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_route_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Datastream::V1alpha1::Datastream::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Datastream::V1alpha1::Datastream::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Datastream::V1alpha1::Datastream::Operations, client.operations_client
  end
end
