# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/datastream/v1alpha1/datastream_pb"
require "google/cloud/datastream/v1alpha1/datastream/rest/service_stub"

module Google
  module Cloud
    module Datastream
      module V1alpha1
        module Datastream
          module Rest
            ##
            # REST client for the Datastream service.
            #
            # Datastream service
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "datastream.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :datastream_stub

              ##
              # Configure the Datastream Client class.
              #
              # See {::Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all Datastream clients
              #   ::Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Datastream", "V1alpha1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.timeout = 60.0
                  default_config.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_connection_profile.timeout = 60.0

                  default_config.rpcs.update_connection_profile.timeout = 60.0

                  default_config.rpcs.delete_connection_profile.timeout = 60.0

                  default_config.rpcs.create_stream.timeout = 60.0

                  default_config.rpcs.update_stream.timeout = 60.0

                  default_config.rpcs.delete_stream.timeout = 60.0

                  default_config.rpcs.create_private_connection.timeout = 60.0

                  default_config.rpcs.delete_private_connection.timeout = 60.0

                  default_config.rpcs.create_route.timeout = 60.0

                  default_config.rpcs.delete_route.timeout = 60.0

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the Datastream Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @datastream_stub.universe_domain
              end

              ##
              # Create a new Datastream REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Datastream client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @datastream_stub = ::Google::Cloud::Datastream::V1alpha1::Datastream::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @datastream_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @datastream_stub.logger
              end

              # Service calls

              ##
              # Use this method to list connection profiles created in a project and
              # location.
              #
              # @overload list_connection_profiles(request, options = nil)
              #   Pass arguments to `list_connection_profiles` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::ListConnectionProfilesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::ListConnectionProfilesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_connection_profiles(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_connection_profiles` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent that owns the collection of connection profiles.
              #   @param page_size [::Integer]
              #     Maximum number of connection profiles to return.
              #     If unspecified, at most 50 connection profiles will be returned.
              #     The maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Page token received from a previous `ListConnectionProfiles` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListConnectionProfiles`
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Filter request.
              #   @param order_by [::String]
              #     Order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Datastream::V1alpha1::ConnectionProfile>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Datastream::V1alpha1::ConnectionProfile>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::ListConnectionProfilesRequest.new
              #
              #   # Call the list_connection_profiles method.
              #   result = client.list_connection_profiles request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Datastream::V1alpha1::ConnectionProfile.
              #     p item
              #   end
              #
              def list_connection_profiles request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::ListConnectionProfilesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_connection_profiles.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_connection_profiles.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_connection_profiles.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.list_connection_profiles request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @datastream_stub, :list_connection_profiles, "connection_profiles", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to get details about a connection profile.
              #
              # @overload get_connection_profile(request, options = nil)
              #   Pass arguments to `get_connection_profile` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::GetConnectionProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::GetConnectionProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_connection_profile(name: nil)
              #   Pass arguments to `get_connection_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the connection profile resource to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Datastream::V1alpha1::ConnectionProfile]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Datastream::V1alpha1::ConnectionProfile]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::GetConnectionProfileRequest.new
              #
              #   # Call the get_connection_profile method.
              #   result = client.get_connection_profile request
              #
              #   # The returned object is of type Google::Cloud::Datastream::V1alpha1::ConnectionProfile.
              #   p result
              #
              def get_connection_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::GetConnectionProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_connection_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_connection_profile.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_connection_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.get_connection_profile request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to create a connection profile in a project and location.
              #
              # @overload create_connection_profile(request, options = nil)
              #   Pass arguments to `create_connection_profile` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::CreateConnectionProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::CreateConnectionProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_connection_profile(parent: nil, connection_profile_id: nil, connection_profile: nil, request_id: nil)
              #   Pass arguments to `create_connection_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent that owns the collection of ConnectionProfiles.
              #   @param connection_profile_id [::String]
              #     Required. The connection profile identifier.
              #   @param connection_profile [::Google::Cloud::Datastream::V1alpha1::ConnectionProfile, ::Hash]
              #     Required. The connection profile resource to create.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::CreateConnectionProfileRequest.new
              #
              #   # Call the create_connection_profile method.
              #   result = client.create_connection_profile request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_connection_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::CreateConnectionProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_connection_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_connection_profile.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_connection_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.create_connection_profile request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to update the parameters of a connection profile.
              #
              # @overload update_connection_profile(request, options = nil)
              #   Pass arguments to `update_connection_profile` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::UpdateConnectionProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::UpdateConnectionProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_connection_profile(update_mask: nil, connection_profile: nil, request_id: nil)
              #   Pass arguments to `update_connection_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     ConnectionProfile resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param connection_profile [::Google::Cloud::Datastream::V1alpha1::ConnectionProfile, ::Hash]
              #     Required. The ConnectionProfile to update.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::UpdateConnectionProfileRequest.new
              #
              #   # Call the update_connection_profile method.
              #   result = client.update_connection_profile request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_connection_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::UpdateConnectionProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_connection_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_connection_profile.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_connection_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.update_connection_profile request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to delete a connection profile..
              #
              # @overload delete_connection_profile(request, options = nil)
              #   Pass arguments to `delete_connection_profile` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::DeleteConnectionProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::DeleteConnectionProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_connection_profile(name: nil, request_id: nil)
              #   Pass arguments to `delete_connection_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the connection profile resource to delete.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::DeleteConnectionProfileRequest.new
              #
              #   # Call the delete_connection_profile method.
              #   result = client.delete_connection_profile request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_connection_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::DeleteConnectionProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_connection_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_connection_profile.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_connection_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.delete_connection_profile request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to discover a connection profile.
              # The discover API call exposes the data objects and metadata belonging to
              # the profile. Typically, a request returns children data objects under a
              # parent data object that's optionally supplied in the request.
              #
              # @overload discover_connection_profile(request, options = nil)
              #   Pass arguments to `discover_connection_profile` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::DiscoverConnectionProfileRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::DiscoverConnectionProfileRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload discover_connection_profile(parent: nil, connection_profile: nil, connection_profile_name: nil, recursive: nil, recursion_depth: nil, oracle_rdbms: nil, mysql_rdbms: nil)
              #   Pass arguments to `discover_connection_profile` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent resource of the ConnectionProfile type. Must be in the
              #     format `projects/*/locations/*`.
              #   @param connection_profile [::Google::Cloud::Datastream::V1alpha1::ConnectionProfile, ::Hash]
              #     An ad-hoc ConnectionProfile configuration.
              #
              #     Note: The following parameters are mutually exclusive: `connection_profile`, `connection_profile_name`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param connection_profile_name [::String]
              #     A reference to an existing ConnectionProfile.
              #
              #     Note: The following parameters are mutually exclusive: `connection_profile_name`, `connection_profile`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param recursive [::Boolean]
              #     Whether to retrieve the full hierarchy of data objects (TRUE) or only the
              #     current level (FALSE).
              #
              #     Note: The following parameters are mutually exclusive: `recursive`, `recursion_depth`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param recursion_depth [::Integer]
              #     The number of hierarchy levels below the current level to be retrieved.
              #
              #     Note: The following parameters are mutually exclusive: `recursion_depth`, `recursive`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param oracle_rdbms [::Google::Cloud::Datastream::V1alpha1::OracleRdbms, ::Hash]
              #     Oracle RDBMS to enrich with child data objects and metadata.
              #
              #     Note: The following parameters are mutually exclusive: `oracle_rdbms`, `mysql_rdbms`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              #   @param mysql_rdbms [::Google::Cloud::Datastream::V1alpha1::MysqlRdbms, ::Hash]
              #     MySQL RDBMS to enrich with child data objects and metadata.
              #
              #     Note: The following parameters are mutually exclusive: `mysql_rdbms`, `oracle_rdbms`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Datastream::V1alpha1::DiscoverConnectionProfileResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Datastream::V1alpha1::DiscoverConnectionProfileResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::DiscoverConnectionProfileRequest.new
              #
              #   # Call the discover_connection_profile method.
              #   result = client.discover_connection_profile request
              #
              #   # The returned object is of type Google::Cloud::Datastream::V1alpha1::DiscoverConnectionProfileResponse.
              #   p result
              #
              def discover_connection_profile request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::DiscoverConnectionProfileRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.discover_connection_profile.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.discover_connection_profile.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.discover_connection_profile.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.discover_connection_profile request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to list streams in a project and location.
              #
              # @overload list_streams(request, options = nil)
              #   Pass arguments to `list_streams` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::ListStreamsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::ListStreamsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_streams(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_streams` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent that owns the collection of streams.
              #   @param page_size [::Integer]
              #     Maximum number of streams to return.
              #     If unspecified, at most 50 streams will  be returned. The maximum
              #     value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Page token received from a previous `ListStreams` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to `ListStreams`
              #     must match the call that provided the page token.
              #   @param filter [::String]
              #     Filter request.
              #   @param order_by [::String]
              #     Order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Datastream::V1alpha1::Stream>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Datastream::V1alpha1::Stream>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::ListStreamsRequest.new
              #
              #   # Call the list_streams method.
              #   result = client.list_streams request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Datastream::V1alpha1::Stream.
              #     p item
              #   end
              #
              def list_streams request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::ListStreamsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_streams.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_streams.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_streams.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.list_streams request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @datastream_stub, :list_streams, "streams", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to get details about a stream.
              #
              # @overload get_stream(request, options = nil)
              #   Pass arguments to `get_stream` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::GetStreamRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::GetStreamRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_stream(name: nil)
              #   Pass arguments to `get_stream` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the stream resource to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Datastream::V1alpha1::Stream]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Datastream::V1alpha1::Stream]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::GetStreamRequest.new
              #
              #   # Call the get_stream method.
              #   result = client.get_stream request
              #
              #   # The returned object is of type Google::Cloud::Datastream::V1alpha1::Stream.
              #   p result
              #
              def get_stream request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::GetStreamRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_stream.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_stream.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_stream.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.get_stream request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to create a stream.
              #
              # @overload create_stream(request, options = nil)
              #   Pass arguments to `create_stream` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::CreateStreamRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::CreateStreamRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_stream(parent: nil, stream_id: nil, stream: nil, request_id: nil, validate_only: nil, force: nil)
              #   Pass arguments to `create_stream` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent that owns the collection of streams.
              #   @param stream_id [::String]
              #     Required. The stream identifier.
              #   @param stream [::Google::Cloud::Datastream::V1alpha1::Stream, ::Hash]
              #     Required. The stream resource to create.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the stream, but do not create any resources.
              #     The default is false.
              #   @param force [::Boolean]
              #     Optional. Create the stream without validating it.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::CreateStreamRequest.new
              #
              #   # Call the create_stream method.
              #   result = client.create_stream request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_stream request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::CreateStreamRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_stream.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_stream.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_stream.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.create_stream request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to update the configuration of a stream.
              #
              # @overload update_stream(request, options = nil)
              #   Pass arguments to `update_stream` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::UpdateStreamRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::UpdateStreamRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_stream(update_mask: nil, stream: nil, request_id: nil, validate_only: nil, force: nil)
              #   Pass arguments to `update_stream` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Optional. Field mask is used to specify the fields to be overwritten in the
              #     stream resource by the update.
              #     The fields specified in the update_mask are relative to the resource, not
              #     the full request. A field will be overwritten if it is in the mask. If the
              #     user does not provide a mask then all fields will be overwritten.
              #   @param stream [::Google::Cloud::Datastream::V1alpha1::Stream, ::Hash]
              #     Required. The stream resource to update.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the stream with the changes, without actually updating it.
              #     The default is false.
              #   @param force [::Boolean]
              #     Optional. Execute the update without validating it.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::UpdateStreamRequest.new
              #
              #   # Call the update_stream method.
              #   result = client.update_stream request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_stream request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::UpdateStreamRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_stream.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_stream.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_stream.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.update_stream request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to delete a stream.
              #
              # @overload delete_stream(request, options = nil)
              #   Pass arguments to `delete_stream` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::DeleteStreamRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::DeleteStreamRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_stream(name: nil, request_id: nil)
              #   Pass arguments to `delete_stream` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the stream resource to delete.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::DeleteStreamRequest.new
              #
              #   # Call the delete_stream method.
              #   result = client.delete_stream request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_stream request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::DeleteStreamRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_stream.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_stream.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_stream.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.delete_stream request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to fetch any errors associated with a stream.
              #
              # @overload fetch_errors(request, options = nil)
              #   Pass arguments to `fetch_errors` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::FetchErrorsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::FetchErrorsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload fetch_errors(stream: nil)
              #   Pass arguments to `fetch_errors` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param stream [::String]
              #     Name of the Stream resource for which to fetch any errors.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::FetchErrorsRequest.new
              #
              #   # Call the fetch_errors method.
              #   result = client.fetch_errors request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def fetch_errors request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::FetchErrorsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.fetch_errors.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.fetch_errors.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.fetch_errors.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.fetch_errors request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # The FetchStaticIps API call exposes the static ips used by Datastream.
              # Typically, a request returns children data objects under
              # a parent data object that's optionally supplied in the request.
              #
              # @overload fetch_static_ips(request, options = nil)
              #   Pass arguments to `fetch_static_ips` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::FetchStaticIpsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::FetchStaticIpsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload fetch_static_ips(name: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `fetch_static_ips` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name resource of the Response type. Must be in the
              #     format `projects/*/locations/*`.
              #   @param page_size [::Integer]
              #     Maximum number of Ips to return, will likely not be specified.
              #   @param page_token [::String]
              #     A page token, received from a previous `ListStaticIps` call.
              #     will likely not be specified.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Datastream::V1alpha1::FetchStaticIpsResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Datastream::V1alpha1::FetchStaticIpsResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::FetchStaticIpsRequest.new
              #
              #   # Call the fetch_static_ips method.
              #   result = client.fetch_static_ips request
              #
              #   # The returned object is of type Google::Cloud::Datastream::V1alpha1::FetchStaticIpsResponse.
              #   p result
              #
              def fetch_static_ips request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::FetchStaticIpsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.fetch_static_ips.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.fetch_static_ips.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.fetch_static_ips.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.fetch_static_ips request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to create a private connectivity configuration.
              #
              # @overload create_private_connection(request, options = nil)
              #   Pass arguments to `create_private_connection` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::CreatePrivateConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::CreatePrivateConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_private_connection(parent: nil, private_connection_id: nil, private_connection: nil, request_id: nil)
              #   Pass arguments to `create_private_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent that owns the collection of PrivateConnections.
              #   @param private_connection_id [::String]
              #     Required. The private connectivity identifier.
              #   @param private_connection [::Google::Cloud::Datastream::V1alpha1::PrivateConnection, ::Hash]
              #     Required. The Private Connectivity resource to create.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::CreatePrivateConnectionRequest.new
              #
              #   # Call the create_private_connection method.
              #   result = client.create_private_connection request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_private_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::CreatePrivateConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_private_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_private_connection.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_private_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.create_private_connection request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to get details about a private connectivity configuration.
              #
              # @overload get_private_connection(request, options = nil)
              #   Pass arguments to `get_private_connection` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::GetPrivateConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::GetPrivateConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_private_connection(name: nil)
              #   Pass arguments to `get_private_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the  private connectivity configuration to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Datastream::V1alpha1::PrivateConnection]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Datastream::V1alpha1::PrivateConnection]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::GetPrivateConnectionRequest.new
              #
              #   # Call the get_private_connection method.
              #   result = client.get_private_connection request
              #
              #   # The returned object is of type Google::Cloud::Datastream::V1alpha1::PrivateConnection.
              #   p result
              #
              def get_private_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::GetPrivateConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_private_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_private_connection.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_private_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.get_private_connection request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to list private connectivity configurations in a project
              # and location.
              #
              # @overload list_private_connections(request, options = nil)
              #   Pass arguments to `list_private_connections` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::ListPrivateConnectionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::ListPrivateConnectionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_private_connections(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_private_connections` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent that owns the collection of private connectivity configurations.
              #   @param page_size [::Integer]
              #     Maximum number of private connectivity configurations to return.
              #     If unspecified, at most 50 private connectivity configurations that will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Page token received from a previous `ListPrivateConnections` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     `ListPrivateConnections` must match the call that provided the page
              #     token.
              #   @param filter [::String]
              #     Filter request.
              #   @param order_by [::String]
              #     Order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Datastream::V1alpha1::PrivateConnection>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Datastream::V1alpha1::PrivateConnection>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::ListPrivateConnectionsRequest.new
              #
              #   # Call the list_private_connections method.
              #   result = client.list_private_connections request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Datastream::V1alpha1::PrivateConnection.
              #     p item
              #   end
              #
              def list_private_connections request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::ListPrivateConnectionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_private_connections.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_private_connections.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_private_connections.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.list_private_connections request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @datastream_stub, :list_private_connections, "private_connections", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to delete a private connectivity configuration.
              #
              # @overload delete_private_connection(request, options = nil)
              #   Pass arguments to `delete_private_connection` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::DeletePrivateConnectionRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::DeletePrivateConnectionRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_private_connection(name: nil, request_id: nil, force: nil)
              #   Pass arguments to `delete_private_connection` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the private connectivity configuration to delete.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              #   @param force [::Boolean]
              #     Optional. If set to true, any child routes that belong to this PrivateConnection will
              #     also be deleted.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::DeletePrivateConnectionRequest.new
              #
              #   # Call the delete_private_connection method.
              #   result = client.delete_private_connection request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_private_connection request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::DeletePrivateConnectionRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_private_connection.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_private_connection.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_private_connection.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.delete_private_connection request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to create a route for a private connectivity in a project
              # and location.
              #
              # @overload create_route(request, options = nil)
              #   Pass arguments to `create_route` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::CreateRouteRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::CreateRouteRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_route(parent: nil, route_id: nil, route: nil, request_id: nil)
              #   Pass arguments to `create_route` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent that owns the collection of Routes.
              #   @param route_id [::String]
              #     Required. The Route identifier.
              #   @param route [::Google::Cloud::Datastream::V1alpha1::Route, ::Hash]
              #     Required. The Route resource to create.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes since the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::CreateRouteRequest.new
              #
              #   # Call the create_route method.
              #   result = client.create_route request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_route request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::CreateRouteRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_route.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_route.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_route.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.create_route request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to get details about a route.
              #
              # @overload get_route(request, options = nil)
              #   Pass arguments to `get_route` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::GetRouteRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::GetRouteRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_route(name: nil)
              #   Pass arguments to `get_route` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Route resource to get.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Datastream::V1alpha1::Route]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Datastream::V1alpha1::Route]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::GetRouteRequest.new
              #
              #   # Call the get_route method.
              #   result = client.get_route request
              #
              #   # The returned object is of type Google::Cloud::Datastream::V1alpha1::Route.
              #   p result
              #
              def get_route request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::GetRouteRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_route.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_route.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_route.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.get_route request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to list routes created for a private connectivity in a
              # project and location.
              #
              # @overload list_routes(request, options = nil)
              #   Pass arguments to `list_routes` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::ListRoutesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::ListRoutesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_routes(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_routes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The parent that owns the collection of Routess.
              #   @param page_size [::Integer]
              #     Maximum number of Routes to return. The service may return
              #     fewer than this value. If unspecified, at most 50 Routes
              #     will be returned. The maximum value is 1000; values above 1000 will be
              #     coerced to 1000.
              #   @param page_token [::String]
              #     Page token received from a previous `ListRoutes` call.
              #     Provide this to retrieve the subsequent page.
              #
              #     When paginating, all other parameters provided to
              #     `ListRoutes` must match the call that provided the page
              #     token.
              #   @param filter [::String]
              #     Filter request.
              #   @param order_by [::String]
              #     Order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Datastream::V1alpha1::Route>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Datastream::V1alpha1::Route>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::ListRoutesRequest.new
              #
              #   # Call the list_routes method.
              #   result = client.list_routes request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Datastream::V1alpha1::Route.
              #     p item
              #   end
              #
              def list_routes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::ListRoutesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_routes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_routes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_routes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.list_routes request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @datastream_stub, :list_routes, "routes", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Use this method to delete a route.
              #
              # @overload delete_route(request, options = nil)
              #   Pass arguments to `delete_route` via a request object, either of type
              #   {::Google::Cloud::Datastream::V1alpha1::DeleteRouteRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Datastream::V1alpha1::DeleteRouteRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_route(name: nil, request_id: nil)
              #   Pass arguments to `delete_route` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The name of the Route resource to delete.
              #   @param request_id [::String]
              #     Optional. A request ID to identify requests. Specify a unique request ID
              #     so that if you must retry your request, the server will know to ignore
              #     the request if it has already been completed. The server will guarantee
              #     that for at least 60 minutes after the first request.
              #
              #     For example, consider a situation where you make an initial request and the
              #     request times out. If you make the request again with the same request ID,
              #     the server can check if original operation with the same request ID was
              #     received, and if so, will ignore the second request. This prevents clients
              #     from accidentally creating duplicate commitments.
              #
              #     The request ID must be a valid UUID with the exception that zero UUID is
              #     not supported (00000000-0000-0000-0000-000000000000).
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/datastream/v1alpha1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Datastream::V1alpha1::DeleteRouteRequest.new
              #
              #   # Call the delete_route method.
              #   result = client.delete_route request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_route request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastream::V1alpha1::DeleteRouteRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_route.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Datastream::V1alpha1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_route.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_route.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @datastream_stub.delete_route request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the Datastream REST API.
              #
              # This class represents the configuration for Datastream REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # list_connection_profiles to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_connection_profiles.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Datastream::V1alpha1::Datastream::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.list_connection_profiles.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "datastream.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the Datastream API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `list_connection_profiles`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_connection_profiles
                  ##
                  # RPC-specific configuration for `get_connection_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_connection_profile
                  ##
                  # RPC-specific configuration for `create_connection_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_connection_profile
                  ##
                  # RPC-specific configuration for `update_connection_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_connection_profile
                  ##
                  # RPC-specific configuration for `delete_connection_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_connection_profile
                  ##
                  # RPC-specific configuration for `discover_connection_profile`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :discover_connection_profile
                  ##
                  # RPC-specific configuration for `list_streams`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_streams
                  ##
                  # RPC-specific configuration for `get_stream`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_stream
                  ##
                  # RPC-specific configuration for `create_stream`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_stream
                  ##
                  # RPC-specific configuration for `update_stream`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_stream
                  ##
                  # RPC-specific configuration for `delete_stream`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_stream
                  ##
                  # RPC-specific configuration for `fetch_errors`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :fetch_errors
                  ##
                  # RPC-specific configuration for `fetch_static_ips`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :fetch_static_ips
                  ##
                  # RPC-specific configuration for `create_private_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_private_connection
                  ##
                  # RPC-specific configuration for `get_private_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_private_connection
                  ##
                  # RPC-specific configuration for `list_private_connections`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_private_connections
                  ##
                  # RPC-specific configuration for `delete_private_connection`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_private_connection
                  ##
                  # RPC-specific configuration for `create_route`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_route
                  ##
                  # RPC-specific configuration for `get_route`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_route
                  ##
                  # RPC-specific configuration for `list_routes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_routes
                  ##
                  # RPC-specific configuration for `delete_route`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_route

                  # @private
                  def initialize parent_rpcs = nil
                    list_connection_profiles_config = parent_rpcs.list_connection_profiles if parent_rpcs.respond_to? :list_connection_profiles
                    @list_connection_profiles = ::Gapic::Config::Method.new list_connection_profiles_config
                    get_connection_profile_config = parent_rpcs.get_connection_profile if parent_rpcs.respond_to? :get_connection_profile
                    @get_connection_profile = ::Gapic::Config::Method.new get_connection_profile_config
                    create_connection_profile_config = parent_rpcs.create_connection_profile if parent_rpcs.respond_to? :create_connection_profile
                    @create_connection_profile = ::Gapic::Config::Method.new create_connection_profile_config
                    update_connection_profile_config = parent_rpcs.update_connection_profile if parent_rpcs.respond_to? :update_connection_profile
                    @update_connection_profile = ::Gapic::Config::Method.new update_connection_profile_config
                    delete_connection_profile_config = parent_rpcs.delete_connection_profile if parent_rpcs.respond_to? :delete_connection_profile
                    @delete_connection_profile = ::Gapic::Config::Method.new delete_connection_profile_config
                    discover_connection_profile_config = parent_rpcs.discover_connection_profile if parent_rpcs.respond_to? :discover_connection_profile
                    @discover_connection_profile = ::Gapic::Config::Method.new discover_connection_profile_config
                    list_streams_config = parent_rpcs.list_streams if parent_rpcs.respond_to? :list_streams
                    @list_streams = ::Gapic::Config::Method.new list_streams_config
                    get_stream_config = parent_rpcs.get_stream if parent_rpcs.respond_to? :get_stream
                    @get_stream = ::Gapic::Config::Method.new get_stream_config
                    create_stream_config = parent_rpcs.create_stream if parent_rpcs.respond_to? :create_stream
                    @create_stream = ::Gapic::Config::Method.new create_stream_config
                    update_stream_config = parent_rpcs.update_stream if parent_rpcs.respond_to? :update_stream
                    @update_stream = ::Gapic::Config::Method.new update_stream_config
                    delete_stream_config = parent_rpcs.delete_stream if parent_rpcs.respond_to? :delete_stream
                    @delete_stream = ::Gapic::Config::Method.new delete_stream_config
                    fetch_errors_config = parent_rpcs.fetch_errors if parent_rpcs.respond_to? :fetch_errors
                    @fetch_errors = ::Gapic::Config::Method.new fetch_errors_config
                    fetch_static_ips_config = parent_rpcs.fetch_static_ips if parent_rpcs.respond_to? :fetch_static_ips
                    @fetch_static_ips = ::Gapic::Config::Method.new fetch_static_ips_config
                    create_private_connection_config = parent_rpcs.create_private_connection if parent_rpcs.respond_to? :create_private_connection
                    @create_private_connection = ::Gapic::Config::Method.new create_private_connection_config
                    get_private_connection_config = parent_rpcs.get_private_connection if parent_rpcs.respond_to? :get_private_connection
                    @get_private_connection = ::Gapic::Config::Method.new get_private_connection_config
                    list_private_connections_config = parent_rpcs.list_private_connections if parent_rpcs.respond_to? :list_private_connections
                    @list_private_connections = ::Gapic::Config::Method.new list_private_connections_config
                    delete_private_connection_config = parent_rpcs.delete_private_connection if parent_rpcs.respond_to? :delete_private_connection
                    @delete_private_connection = ::Gapic::Config::Method.new delete_private_connection_config
                    create_route_config = parent_rpcs.create_route if parent_rpcs.respond_to? :create_route
                    @create_route = ::Gapic::Config::Method.new create_route_config
                    get_route_config = parent_rpcs.get_route if parent_rpcs.respond_to? :get_route
                    @get_route = ::Gapic::Config::Method.new get_route_config
                    list_routes_config = parent_rpcs.list_routes if parent_rpcs.respond_to? :list_routes
                    @list_routes = ::Gapic::Config::Method.new list_routes_config
                    delete_route_config = parent_rpcs.delete_route if parent_rpcs.respond_to? :delete_route
                    @delete_route = ::Gapic::Config::Method.new delete_route_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
