# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/datastream/v1/datastream_pb"
require "google/cloud/datastream/v1/datastream/rest"


class ::Google::Cloud::Datastream::V1::Datastream::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_list_connection_profiles
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::ListConnectionProfilesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_connection_profiles_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_list_connection_profiles_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_connection_profiles_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_connection_profiles({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_connection_profiles parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_connection_profiles ::Google::Cloud::Datastream::V1::ListConnectionProfilesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_connection_profiles({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_connection_profiles(::Google::Cloud::Datastream::V1::ListConnectionProfilesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_connection_profiles_client_stub.call_count
      end
    end
  end

  def test_get_connection_profile
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::ConnectionProfile.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_connection_profile_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_get_connection_profile_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_connection_profile_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_connection_profile({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_connection_profile name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_connection_profile ::Google::Cloud::Datastream::V1::GetConnectionProfileRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_connection_profile({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_connection_profile(::Google::Cloud::Datastream::V1::GetConnectionProfileRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_connection_profile_client_stub.call_count
      end
    end
  end

  def test_create_connection_profile
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    connection_profile_id = "hello world"
    connection_profile = {}
    request_id = "hello world"
    validate_only = true
    force = true

    create_connection_profile_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_create_connection_profile_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_connection_profile_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_connection_profile({ parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_connection_profile parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_connection_profile ::Google::Cloud::Datastream::V1::CreateConnectionProfileRequest.new(parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_connection_profile({ parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_connection_profile(::Google::Cloud::Datastream::V1::CreateConnectionProfileRequest.new(parent: parent, connection_profile_id: connection_profile_id, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_connection_profile_client_stub.call_count
      end
    end
  end

  def test_update_connection_profile
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    connection_profile = {}
    request_id = "hello world"
    validate_only = true
    force = true

    update_connection_profile_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_update_connection_profile_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_connection_profile_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_connection_profile({ update_mask: update_mask, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_connection_profile update_mask: update_mask, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_connection_profile ::Google::Cloud::Datastream::V1::UpdateConnectionProfileRequest.new(update_mask: update_mask, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_connection_profile({ update_mask: update_mask, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_connection_profile(::Google::Cloud::Datastream::V1::UpdateConnectionProfileRequest.new(update_mask: update_mask, connection_profile: connection_profile, request_id: request_id, validate_only: validate_only, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_connection_profile_client_stub.call_count
      end
    end
  end

  def test_delete_connection_profile
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_connection_profile_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_delete_connection_profile_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_connection_profile_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_connection_profile({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_connection_profile name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_connection_profile ::Google::Cloud::Datastream::V1::DeleteConnectionProfileRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_connection_profile({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_connection_profile(::Google::Cloud::Datastream::V1::DeleteConnectionProfileRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_connection_profile_client_stub.call_count
      end
    end
  end

  def test_discover_connection_profile
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::DiscoverConnectionProfileResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    connection_profile = {}
    full_hierarchy = true
    oracle_rdbms = {}

    discover_connection_profile_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_discover_connection_profile_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, discover_connection_profile_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.discover_connection_profile({ parent: parent, connection_profile: connection_profile, full_hierarchy: full_hierarchy, oracle_rdbms: oracle_rdbms }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.discover_connection_profile parent: parent, connection_profile: connection_profile, full_hierarchy: full_hierarchy, oracle_rdbms: oracle_rdbms do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.discover_connection_profile ::Google::Cloud::Datastream::V1::DiscoverConnectionProfileRequest.new(parent: parent, connection_profile: connection_profile, full_hierarchy: full_hierarchy, oracle_rdbms: oracle_rdbms) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.discover_connection_profile({ parent: parent, connection_profile: connection_profile, full_hierarchy: full_hierarchy, oracle_rdbms: oracle_rdbms }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.discover_connection_profile(::Google::Cloud::Datastream::V1::DiscoverConnectionProfileRequest.new(parent: parent, connection_profile: connection_profile, full_hierarchy: full_hierarchy, oracle_rdbms: oracle_rdbms), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, discover_connection_profile_client_stub.call_count
      end
    end
  end

  def test_list_streams
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::ListStreamsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_streams_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_list_streams_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_streams_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_streams({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_streams parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_streams ::Google::Cloud::Datastream::V1::ListStreamsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_streams({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_streams(::Google::Cloud::Datastream::V1::ListStreamsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_streams_client_stub.call_count
      end
    end
  end

  def test_get_stream
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::Stream.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_stream_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_get_stream_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_stream_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_stream({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_stream name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_stream ::Google::Cloud::Datastream::V1::GetStreamRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_stream({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_stream(::Google::Cloud::Datastream::V1::GetStreamRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_stream_client_stub.call_count
      end
    end
  end

  def test_create_stream
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    stream_id = "hello world"
    stream = {}
    request_id = "hello world"
    validate_only = true
    force = true

    create_stream_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_create_stream_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_stream_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_stream({ parent: parent, stream_id: stream_id, stream: stream, request_id: request_id, validate_only: validate_only, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_stream parent: parent, stream_id: stream_id, stream: stream, request_id: request_id, validate_only: validate_only, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_stream ::Google::Cloud::Datastream::V1::CreateStreamRequest.new(parent: parent, stream_id: stream_id, stream: stream, request_id: request_id, validate_only: validate_only, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_stream({ parent: parent, stream_id: stream_id, stream: stream, request_id: request_id, validate_only: validate_only, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_stream(::Google::Cloud::Datastream::V1::CreateStreamRequest.new(parent: parent, stream_id: stream_id, stream: stream, request_id: request_id, validate_only: validate_only, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_stream_client_stub.call_count
      end
    end
  end

  def test_update_stream
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    stream = {}
    request_id = "hello world"
    validate_only = true
    force = true

    update_stream_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_update_stream_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_stream_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_stream({ update_mask: update_mask, stream: stream, request_id: request_id, validate_only: validate_only, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_stream update_mask: update_mask, stream: stream, request_id: request_id, validate_only: validate_only, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_stream ::Google::Cloud::Datastream::V1::UpdateStreamRequest.new(update_mask: update_mask, stream: stream, request_id: request_id, validate_only: validate_only, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_stream({ update_mask: update_mask, stream: stream, request_id: request_id, validate_only: validate_only, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_stream(::Google::Cloud::Datastream::V1::UpdateStreamRequest.new(update_mask: update_mask, stream: stream, request_id: request_id, validate_only: validate_only, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_stream_client_stub.call_count
      end
    end
  end

  def test_delete_stream
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_stream_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_delete_stream_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_stream_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_stream({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_stream name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_stream ::Google::Cloud::Datastream::V1::DeleteStreamRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_stream({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_stream(::Google::Cloud::Datastream::V1::DeleteStreamRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_stream_client_stub.call_count
      end
    end
  end

  def test_run_stream
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    cdc_strategy = {}
    force = true

    run_stream_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_run_stream_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, run_stream_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.run_stream({ name: name, cdc_strategy: cdc_strategy, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.run_stream name: name, cdc_strategy: cdc_strategy, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.run_stream ::Google::Cloud::Datastream::V1::RunStreamRequest.new(name: name, cdc_strategy: cdc_strategy, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.run_stream({ name: name, cdc_strategy: cdc_strategy, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.run_stream(::Google::Cloud::Datastream::V1::RunStreamRequest.new(name: name, cdc_strategy: cdc_strategy, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, run_stream_client_stub.call_count
      end
    end
  end

  def test_get_stream_object
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::StreamObject.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_stream_object_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_get_stream_object_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_stream_object_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_stream_object({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_stream_object name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_stream_object ::Google::Cloud::Datastream::V1::GetStreamObjectRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_stream_object({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_stream_object(::Google::Cloud::Datastream::V1::GetStreamObjectRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_stream_object_client_stub.call_count
      end
    end
  end

  def test_lookup_stream_object
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::StreamObject.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    source_object_identifier = {}

    lookup_stream_object_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_lookup_stream_object_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, lookup_stream_object_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.lookup_stream_object({ parent: parent, source_object_identifier: source_object_identifier }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.lookup_stream_object parent: parent, source_object_identifier: source_object_identifier do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.lookup_stream_object ::Google::Cloud::Datastream::V1::LookupStreamObjectRequest.new(parent: parent, source_object_identifier: source_object_identifier) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.lookup_stream_object({ parent: parent, source_object_identifier: source_object_identifier }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.lookup_stream_object(::Google::Cloud::Datastream::V1::LookupStreamObjectRequest.new(parent: parent, source_object_identifier: source_object_identifier), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, lookup_stream_object_client_stub.call_count
      end
    end
  end

  def test_list_stream_objects
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::ListStreamObjectsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"

    list_stream_objects_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_list_stream_objects_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_stream_objects_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_stream_objects({ parent: parent, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_stream_objects parent: parent, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_stream_objects ::Google::Cloud::Datastream::V1::ListStreamObjectsRequest.new(parent: parent, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_stream_objects({ parent: parent, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_stream_objects(::Google::Cloud::Datastream::V1::ListStreamObjectsRequest.new(parent: parent, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_stream_objects_client_stub.call_count
      end
    end
  end

  def test_start_backfill_job
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::StartBackfillJobResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    object = "hello world"

    start_backfill_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_start_backfill_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, start_backfill_job_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.start_backfill_job({ object: object }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.start_backfill_job object: object do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.start_backfill_job ::Google::Cloud::Datastream::V1::StartBackfillJobRequest.new(object: object) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.start_backfill_job({ object: object }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.start_backfill_job(::Google::Cloud::Datastream::V1::StartBackfillJobRequest.new(object: object), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, start_backfill_job_client_stub.call_count
      end
    end
  end

  def test_stop_backfill_job
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::StopBackfillJobResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    object = "hello world"

    stop_backfill_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_stop_backfill_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, stop_backfill_job_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.stop_backfill_job({ object: object }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.stop_backfill_job object: object do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.stop_backfill_job ::Google::Cloud::Datastream::V1::StopBackfillJobRequest.new(object: object) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.stop_backfill_job({ object: object }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.stop_backfill_job(::Google::Cloud::Datastream::V1::StopBackfillJobRequest.new(object: object), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, stop_backfill_job_client_stub.call_count
      end
    end
  end

  def test_fetch_static_ips
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::FetchStaticIpsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    page_size = 42
    page_token = "hello world"

    fetch_static_ips_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_fetch_static_ips_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, fetch_static_ips_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.fetch_static_ips({ name: name, page_size: page_size, page_token: page_token }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.fetch_static_ips name: name, page_size: page_size, page_token: page_token do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.fetch_static_ips ::Google::Cloud::Datastream::V1::FetchStaticIpsRequest.new(name: name, page_size: page_size, page_token: page_token) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.fetch_static_ips({ name: name, page_size: page_size, page_token: page_token }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.fetch_static_ips(::Google::Cloud::Datastream::V1::FetchStaticIpsRequest.new(name: name, page_size: page_size, page_token: page_token), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, fetch_static_ips_client_stub.call_count
      end
    end
  end

  def test_create_private_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    private_connection_id = "hello world"
    private_connection = {}
    request_id = "hello world"
    force = true
    validate_only = true

    create_private_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_create_private_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_private_connection_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_private_connection({ parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id, force: force, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_private_connection parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id, force: force, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_private_connection ::Google::Cloud::Datastream::V1::CreatePrivateConnectionRequest.new(parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id, force: force, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_private_connection({ parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id, force: force, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_private_connection(::Google::Cloud::Datastream::V1::CreatePrivateConnectionRequest.new(parent: parent, private_connection_id: private_connection_id, private_connection: private_connection, request_id: request_id, force: force, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_private_connection_client_stub.call_count
      end
    end
  end

  def test_get_private_connection
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::PrivateConnection.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_private_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_get_private_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_private_connection_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_private_connection({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_private_connection name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_private_connection ::Google::Cloud::Datastream::V1::GetPrivateConnectionRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_private_connection({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_private_connection(::Google::Cloud::Datastream::V1::GetPrivateConnectionRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_private_connection_client_stub.call_count
      end
    end
  end

  def test_list_private_connections
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::ListPrivateConnectionsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_private_connections_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_list_private_connections_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_private_connections_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_private_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_private_connections parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_private_connections ::Google::Cloud::Datastream::V1::ListPrivateConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_private_connections({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_private_connections(::Google::Cloud::Datastream::V1::ListPrivateConnectionsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_private_connections_client_stub.call_count
      end
    end
  end

  def test_delete_private_connection
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"
    force = true

    delete_private_connection_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_delete_private_connection_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_private_connection_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_private_connection({ name: name, request_id: request_id, force: force }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_private_connection name: name, request_id: request_id, force: force do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_private_connection ::Google::Cloud::Datastream::V1::DeletePrivateConnectionRequest.new(name: name, request_id: request_id, force: force) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_private_connection({ name: name, request_id: request_id, force: force }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_private_connection(::Google::Cloud::Datastream::V1::DeletePrivateConnectionRequest.new(name: name, request_id: request_id, force: force), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_private_connection_client_stub.call_count
      end
    end
  end

  def test_create_route
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    route_id = "hello world"
    route = {}
    request_id = "hello world"

    create_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_create_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_route_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_route({ parent: parent, route_id: route_id, route: route, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_route parent: parent, route_id: route_id, route: route, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_route ::Google::Cloud::Datastream::V1::CreateRouteRequest.new(parent: parent, route_id: route_id, route: route, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_route({ parent: parent, route_id: route_id, route: route, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_route(::Google::Cloud::Datastream::V1::CreateRouteRequest.new(parent: parent, route_id: route_id, route: route, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_route_client_stub.call_count
      end
    end
  end

  def test_get_route
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::Route.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_get_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_route_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_route({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_route name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_route ::Google::Cloud::Datastream::V1::GetRouteRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_route({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_route(::Google::Cloud::Datastream::V1::GetRouteRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_route_client_stub.call_count
      end
    end
  end

  def test_list_routes
    # Create test objects.
    client_result = ::Google::Cloud::Datastream::V1::ListRoutesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_routes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_list_routes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_routes_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_routes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_routes parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_routes ::Google::Cloud::Datastream::V1::ListRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_routes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_routes(::Google::Cloud::Datastream::V1::ListRoutesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_routes_client_stub.call_count
      end
    end
  end

  def test_delete_route
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    request_id = "hello world"

    delete_route_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastream::V1::Datastream::Rest::ServiceStub.stub :transcode_delete_route_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_route_client_stub do
        # Create client
        client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_route({ name: name, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_route name: name, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_route ::Google::Cloud::Datastream::V1::DeleteRouteRequest.new(name: name, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_route({ name: name, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_route(::Google::Cloud::Datastream::V1::DeleteRouteRequest.new(name: name, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_route_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Datastream::V1::Datastream::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Datastream::V1::Datastream::Rest::Client::Configuration, config
  end
end
