# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Datastream
      module V1
        # Oracle database profile.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Required. Hostname for the Oracle connection.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Port for the Oracle connection, default value is 1521.
        # @!attribute [rw] username
        #   @return [::String]
        #     Required. Username for the Oracle connection.
        # @!attribute [rw] password
        #   @return [::String]
        #     Optional. Password for the Oracle connection. Mutually exclusive with the
        #     `secret_manager_stored_password` field.
        # @!attribute [rw] database_service
        #   @return [::String]
        #     Required. Database for the Oracle connection.
        # @!attribute [rw] connection_attributes
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Connection string attributes
        # @!attribute [rw] oracle_ssl_config
        #   @return [::Google::Cloud::Datastream::V1::OracleSslConfig]
        #     Optional. SSL configuration for the Oracle connection.
        # @!attribute [rw] oracle_asm_config
        #   @return [::Google::Cloud::Datastream::V1::OracleAsmConfig]
        #     Optional. Configuration for Oracle ASM connection.
        # @!attribute [rw] secret_manager_stored_password
        #   @return [::String]
        #     Optional. A reference to a Secret Manager resource name storing the Oracle
        #     connection password. Mutually exclusive with the `password` field.
        class OracleProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ConnectionAttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Configuration for Oracle Automatic Storage Management (ASM) connection.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Required. Hostname for the Oracle ASM connection.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Required. Port for the Oracle ASM connection.
        # @!attribute [rw] username
        #   @return [::String]
        #     Required. Username for the Oracle ASM connection.
        # @!attribute [rw] password
        #   @return [::String]
        #     Optional. Password for the Oracle ASM connection. Mutually exclusive with
        #     the `secret_manager_stored_password` field.
        # @!attribute [rw] asm_service
        #   @return [::String]
        #     Required. ASM service name for the Oracle ASM connection.
        # @!attribute [rw] connection_attributes
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Connection string attributes
        # @!attribute [rw] oracle_ssl_config
        #   @return [::Google::Cloud::Datastream::V1::OracleSslConfig]
        #     Optional. SSL configuration for the Oracle connection.
        # @!attribute [rw] secret_manager_stored_password
        #   @return [::String]
        #     Optional. A reference to a Secret Manager resource name storing the Oracle
        #     ASM connection password. Mutually exclusive with the `password` field.
        class OracleAsmConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ConnectionAttributesEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # MySQL database profile.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Required. Hostname for the MySQL connection.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Port for the MySQL connection, default value is 3306.
        # @!attribute [rw] username
        #   @return [::String]
        #     Required. Username for the MySQL connection.
        # @!attribute [rw] password
        #   @return [::String]
        #     Optional. Input only. Password for the MySQL connection. Mutually exclusive
        #     with the `secret_manager_stored_password` field.
        # @!attribute [rw] ssl_config
        #   @return [::Google::Cloud::Datastream::V1::MysqlSslConfig]
        #     SSL configuration for the MySQL connection.
        # @!attribute [rw] secret_manager_stored_password
        #   @return [::String]
        #     Optional. A reference to a Secret Manager resource name storing the MySQL
        #     connection password. Mutually exclusive with the `password` field.
        class MysqlProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PostgreSQL database profile.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Required. Hostname for the PostgreSQL connection.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Port for the PostgreSQL connection, default value is 5432.
        # @!attribute [rw] username
        #   @return [::String]
        #     Required. Username for the PostgreSQL connection.
        # @!attribute [rw] password
        #   @return [::String]
        #     Optional. Password for the PostgreSQL connection. Mutually exclusive with
        #     the `secret_manager_stored_password` field.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. Database for the PostgreSQL connection.
        # @!attribute [rw] secret_manager_stored_password
        #   @return [::String]
        #     Optional. A reference to a Secret Manager resource name storing the
        #     PostgreSQL connection password. Mutually exclusive with the `password`
        #     field.
        # @!attribute [rw] ssl_config
        #   @return [::Google::Cloud::Datastream::V1::PostgresqlSslConfig]
        #     Optional. SSL configuration for the PostgreSQL connection.
        #     In case PostgresqlSslConfig is not set, the connection will use the default
        #     SSL mode, which is `prefer` (i.e. this mode will only use encryption if
        #     enabled from database side, otherwise will use unencrypted communication)
        class PostgresqlProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SQLServer database profile.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Required. Hostname for the SQLServer connection.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Port for the SQLServer connection, default value is 1433.
        # @!attribute [rw] username
        #   @return [::String]
        #     Required. Username for the SQLServer connection.
        # @!attribute [rw] password
        #   @return [::String]
        #     Optional. Password for the SQLServer connection. Mutually exclusive with
        #     the `secret_manager_stored_password` field.
        # @!attribute [rw] database
        #   @return [::String]
        #     Required. Database for the SQLServer connection.
        # @!attribute [rw] secret_manager_stored_password
        #   @return [::String]
        #     Optional. A reference to a Secret Manager resource name storing the
        #     SQLServer connection password. Mutually exclusive with the `password`
        #     field.
        class SqlServerProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Salesforce profile
        # @!attribute [rw] domain
        #   @return [::String]
        #     Required. Domain endpoint for the Salesforce connection.
        # @!attribute [rw] user_credentials
        #   @return [::Google::Cloud::Datastream::V1::SalesforceProfile::UserCredentials]
        #     User-password authentication.
        #
        #     Note: The following fields are mutually exclusive: `user_credentials`, `oauth2_client_credentials`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] oauth2_client_credentials
        #   @return [::Google::Cloud::Datastream::V1::SalesforceProfile::Oauth2ClientCredentials]
        #     Connected app authentication.
        #
        #     Note: The following fields are mutually exclusive: `oauth2_client_credentials`, `user_credentials`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class SalesforceProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Username-password credentials.
          # @!attribute [rw] username
          #   @return [::String]
          #     Required. Username for the Salesforce connection.
          # @!attribute [rw] password
          #   @return [::String]
          #     Optional. Password for the Salesforce connection.
          #     Mutually exclusive with the `secret_manager_stored_password` field.
          # @!attribute [rw] security_token
          #   @return [::String]
          #     Optional. Security token for the Salesforce connection.
          #     Mutually exclusive with the `secret_manager_stored_security_token` field.
          # @!attribute [rw] secret_manager_stored_password
          #   @return [::String]
          #     Optional. A reference to a Secret Manager resource name storing the
          #     Salesforce connection's password. Mutually exclusive with the `password`
          #     field.
          # @!attribute [rw] secret_manager_stored_security_token
          #   @return [::String]
          #     Optional. A reference to a Secret Manager resource name storing the
          #     Salesforce connection's security token. Mutually exclusive with the
          #     `security_token` field.
          class UserCredentials
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # OAuth2 Client Credentials.
          # @!attribute [rw] client_id
          #   @return [::String]
          #     Required. Client ID for Salesforce OAuth2 Client Credentials.
          # @!attribute [rw] client_secret
          #   @return [::String]
          #     Optional. Client secret for Salesforce OAuth2 Client Credentials.
          #     Mutually exclusive with the `secret_manager_stored_client_secret` field.
          # @!attribute [rw] secret_manager_stored_client_secret
          #   @return [::String]
          #     Optional. A reference to a Secret Manager resource name storing the
          #     Salesforce OAuth2 client_secret. Mutually exclusive with the
          #     `client_secret` field.
          class Oauth2ClientCredentials
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # MongoDB profile.
        # @!attribute [rw] host_addresses
        #   @return [::Array<::Google::Cloud::Datastream::V1::HostAddress>]
        #     Required. List of host addresses for a MongoDB cluster.
        #     For SRV connection format, this list must contain exactly one DNS host
        #     without a port. For Standard connection format, this list must contain all
        #     the required hosts in the cluster with their respective ports.
        # @!attribute [rw] replica_set
        #   @return [::String]
        #     Optional. Name of the replica set. Only needed for self hosted replica set
        #     type MongoDB cluster. For SRV connection format, this field must be empty.
        #     For Standard connection format, this field must be specified.
        # @!attribute [rw] username
        #   @return [::String]
        #     Required. Username for the MongoDB connection.
        # @!attribute [rw] password
        #   @return [::String]
        #     Optional. Password for the MongoDB connection. Mutually exclusive with the
        #     `secret_manager_stored_password` field.
        # @!attribute [rw] secret_manager_stored_password
        #   @return [::String]
        #     Optional. A reference to a Secret Manager resource name storing the
        #     SQLServer connection password. Mutually exclusive with the `password`
        #     field.
        # @!attribute [rw] ssl_config
        #   @return [::Google::Cloud::Datastream::V1::MongodbSslConfig]
        #     Optional. SSL configuration for the MongoDB connection.
        # @!attribute [rw] srv_connection_format
        #   @return [::Google::Cloud::Datastream::V1::SrvConnectionFormat]
        #     Srv connection format.
        #
        #     Note: The following fields are mutually exclusive: `srv_connection_format`, `standard_connection_format`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] standard_connection_format
        #   @return [::Google::Cloud::Datastream::V1::StandardConnectionFormat]
        #     Standard connection format.
        #
        #     Note: The following fields are mutually exclusive: `standard_connection_format`, `srv_connection_format`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class MongodbProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A HostAddress represents a transport end point, which is the combination
        # of an IP address or hostname and a port number.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Required. Hostname for the connection.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Optional. Port for the connection.
        class HostAddress
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Srv connection format.
        class SrvConnectionFormat
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Standard connection format.
        # @!attribute [rw] direct_connection
        #   @return [::Boolean]
        #     Optional. Specifies whether the client connects directly to the host[:port]
        #     in the connection URI.
        class StandardConnectionFormat
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Cloud Storage bucket profile.
        # @!attribute [rw] bucket
        #   @return [::String]
        #     Required. The Cloud Storage bucket name.
        # @!attribute [rw] root_path
        #   @return [::String]
        #     The root path inside the Cloud Storage bucket.
        class GcsProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # BigQuery warehouse profile.
        class BigQueryProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Static IP address connectivity. Used when the source database is configured
        # to allow incoming connections from the Datastream public IP addresses
        # for the region specified in the connection profile.
        class StaticServiceIpConnectivity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Forward SSH Tunnel connectivity.
        # @!attribute [rw] hostname
        #   @return [::String]
        #     Required. Hostname for the SSH tunnel.
        # @!attribute [rw] username
        #   @return [::String]
        #     Required. Username for the SSH tunnel.
        # @!attribute [rw] port
        #   @return [::Integer]
        #     Port for the SSH tunnel, default value is 22.
        # @!attribute [rw] password
        #   @return [::String]
        #     Input only. SSH password.
        #
        #     Note: The following fields are mutually exclusive: `password`, `private_key`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] private_key
        #   @return [::String]
        #     Input only. SSH private key.
        #
        #     Note: The following fields are mutually exclusive: `private_key`, `password`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ForwardSshTunnelConnectivity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The VPC Peering configuration is used to create VPC peering between
        # Datastream and the consumer's VPC.
        # @!attribute [rw] vpc
        #   @return [::String]
        #     Required. Fully qualified name of the VPC that Datastream will peer to.
        #     Format: `projects/{project}/global/{networks}/{name}`
        # @!attribute [rw] subnet
        #   @return [::String]
        #     Required. A free subnet for peering. (CIDR of /29)
        class VpcPeeringConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The PSC Interface configuration is used to create PSC Interface between
        # Datastream and the consumer's PSC.
        # @!attribute [rw] network_attachment
        #   @return [::String]
        #     Required. Fully qualified name of the Network Attachment that Datastream
        #     will connect to. Format:
        #     `projects/{project}/regions/{region}/networkAttachments/{name}`
        class PscInterfaceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The PrivateConnection resource is used to establish private connectivity
        # between Datastream and a customer's network.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource's name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create time of the resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update time of the resource.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Datastream::V1::PrivateConnection::State]
        #     Output only. The state of the Private Connection.
        # @!attribute [r] error
        #   @return [::Google::Cloud::Datastream::V1::Error]
        #     Output only. In case of error, the details of the error in a user-friendly
        #     format.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [rw] vpc_peering_config
        #   @return [::Google::Cloud::Datastream::V1::VpcPeeringConfig]
        #     VPC Peering Config.
        # @!attribute [rw] psc_interface_config
        #   @return [::Google::Cloud::Datastream::V1::PscInterfaceConfig]
        #     PSC Interface Config.
        class PrivateConnection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Private Connection state.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # The private connection is in creation state - creating resources.
            CREATING = 1

            # The private connection has been created with all of its resources.
            CREATED = 2

            # The private connection creation has failed.
            FAILED = 3

            # The private connection is being deleted.
            DELETING = 4

            # Delete request has failed, resource is in invalid state.
            FAILED_TO_DELETE = 5
          end
        end

        # Private Connectivity
        # @!attribute [rw] private_connection
        #   @return [::String]
        #     Required. A reference to a private connection resource.
        #     Format: `projects/{project}/locations/{location}/privateConnections/{name}`
        class PrivateConnectivity
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The route resource is the child of the private connection resource,
        # used for defining a route for a private connection.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource's name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create time of the resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update time of the resource.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name.
        # @!attribute [rw] destination_address
        #   @return [::String]
        #     Required. Destination address for connection
        # @!attribute [rw] destination_port
        #   @return [::Integer]
        #     Destination port for connection
        class Route
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # MongoDB SSL configuration information.
        # @!attribute [rw] client_key
        #   @return [::String]
        #     Optional. Input only. PEM-encoded private key associated with the Client
        #     Certificate. If this field is used then the 'client_certificate' and the
        #     'ca_certificate' fields are mandatory.
        # @!attribute [r] client_key_set
        #   @return [::Boolean]
        #     Output only. Indicates whether the client_key field is set.
        # @!attribute [rw] client_certificate
        #   @return [::String]
        #     Optional. Input only. PEM-encoded certificate that will be used by the
        #     replica to authenticate against the source database server. If this field
        #     is used then the 'client_key' and the 'ca_certificate' fields are
        #     mandatory.
        # @!attribute [r] client_certificate_set
        #   @return [::Boolean]
        #     Output only. Indicates whether the client_certificate field is set.
        # @!attribute [rw] ca_certificate
        #   @return [::String]
        #     Optional. Input only. PEM-encoded certificate of the CA that signed the
        #     source database server's certificate.
        # @!attribute [r] ca_certificate_set
        #   @return [::Boolean]
        #     Output only. Indicates whether the ca_certificate field is set.
        # @!attribute [rw] secret_manager_stored_client_key
        #   @return [::String]
        #     Optional. Input only. A reference to a Secret Manager resource name storing
        #     the PEM-encoded private key associated with the Client Certificate. If this
        #     field is used then the 'client_certificate' and the 'ca_certificate' fields
        #     are mandatory. Mutually exclusive with the `client_key` field.
        class MongodbSslConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MySQL SSL configuration information.
        # @!attribute [rw] client_key
        #   @return [::String]
        #     Optional. Input only. PEM-encoded private key associated with the Client
        #     Certificate. If this field is used then the 'client_certificate' and the
        #     'ca_certificate' fields are mandatory.
        # @!attribute [r] client_key_set
        #   @return [::Boolean]
        #     Output only. Indicates whether the client_key field is set.
        # @!attribute [rw] client_certificate
        #   @return [::String]
        #     Optional. Input only. PEM-encoded certificate that will be used by the
        #     replica to authenticate against the source database server. If this field
        #     is used then the 'client_key' and the 'ca_certificate' fields are
        #     mandatory.
        # @!attribute [r] client_certificate_set
        #   @return [::Boolean]
        #     Output only. Indicates whether the client_certificate field is set.
        # @!attribute [rw] ca_certificate
        #   @return [::String]
        #     Input only. PEM-encoded certificate of the CA that signed the source
        #     database server's certificate.
        # @!attribute [r] ca_certificate_set
        #   @return [::Boolean]
        #     Output only. Indicates whether the ca_certificate field is set.
        class MysqlSslConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Oracle SSL configuration information.
        # @!attribute [rw] ca_certificate
        #   @return [::String]
        #     Input only. PEM-encoded certificate of the CA that signed the source
        #     database server's certificate.
        # @!attribute [r] ca_certificate_set
        #   @return [::Boolean]
        #     Output only. Indicates whether the ca_certificate field has been set for
        #     this Connection-Profile.
        # @!attribute [rw] server_certificate_distinguished_name
        #   @return [::String]
        #     Optional. The distinguished name (DN) mentioned in the server
        #     certificate. This corresponds to SSL_SERVER_CERT_DN sqlnet parameter.
        #     Refer
        #     https://docs.oracle.com/en/database/oracle/oracle-database/19/netrf/local-naming-parameters-in-tns-ora-file.html#GUID-70AB0695-A9AA-4A94-B141-4C605236EEB7
        #     If this field is not provided, the DN matching is not enforced.
        class OracleSslConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PostgreSQL SSL configuration information.
        # @!attribute [rw] server_verification
        #   @return [::Google::Cloud::Datastream::V1::PostgresqlSslConfig::ServerVerification]
        #      If this field is set, the communication will be encrypted with TLS
        #      encryption and the server identity will be authenticated.
        #
        #     Note: The following fields are mutually exclusive: `server_verification`, `server_and_client_verification`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] server_and_client_verification
        #   @return [::Google::Cloud::Datastream::V1::PostgresqlSslConfig::ServerAndClientVerification]
        #     If this field is set, the communication will be encrypted with TLS
        #     encryption and both the server identity and the client identity will be
        #     authenticated.
        #
        #     Note: The following fields are mutually exclusive: `server_and_client_verification`, `server_verification`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class PostgresqlSslConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Message represents the option where Datastream will enforce the encryption
          # and authenticate the server identity. ca_certificate must be set if user
          # selects this option.
          # @!attribute [rw] ca_certificate
          #   @return [::String]
          #     Required. Input only. PEM-encoded server root CA certificate.
          # @!attribute [rw] server_certificate_hostname
          #   @return [::String]
          #     Optional. The hostname mentioned in the Subject or SAN extension of the
          #     server certificate. If this field is not provided, the hostname in the
          #     server certificate is not validated.
          class ServerVerification
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Message represents the option where Datastream will enforce the encryption
          # and authenticate the server identity as well as the client identity.
          # ca_certificate, client_certificate and client_key must be set if user
          # selects this option.
          # @!attribute [rw] client_certificate
          #   @return [::String]
          #     Required. Input only. PEM-encoded certificate used by the source database
          #     to authenticate the client identity (i.e., the Datastream's identity).
          #     This certificate is signed by either a root certificate trusted by the
          #     server or one or more intermediate certificates (which is stored with the
          #     leaf certificate) to link the this certificate to the trusted root
          #     certificate.
          # @!attribute [rw] client_key
          #   @return [::String]
          #     Optional. Input only. PEM-encoded private key associated with the client
          #     certificate. This value will be used during the SSL/TLS handshake,
          #     allowing the PostgreSQL server to authenticate the client's identity,
          #     i.e. identity of the Datastream.
          # @!attribute [rw] ca_certificate
          #   @return [::String]
          #     Required. Input only. PEM-encoded server root CA certificate.
          # @!attribute [rw] server_certificate_hostname
          #   @return [::String]
          #     Optional. The hostname mentioned in the Subject or SAN extension of the
          #     server certificate. If this field is not provided, the hostname in the
          #     server certificate is not validated.
          class ServerAndClientVerification
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A set of reusable connection configurations to be used as a source or
        # destination for a stream.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource's name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The create time of the resource.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The update time of the resource.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [rw] oracle_profile
        #   @return [::Google::Cloud::Datastream::V1::OracleProfile]
        #     Oracle ConnectionProfile configuration.
        #
        #     Note: The following fields are mutually exclusive: `oracle_profile`, `gcs_profile`, `mysql_profile`, `bigquery_profile`, `postgresql_profile`, `sql_server_profile`, `salesforce_profile`, `mongodb_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gcs_profile
        #   @return [::Google::Cloud::Datastream::V1::GcsProfile]
        #     Cloud Storage ConnectionProfile configuration.
        #
        #     Note: The following fields are mutually exclusive: `gcs_profile`, `oracle_profile`, `mysql_profile`, `bigquery_profile`, `postgresql_profile`, `sql_server_profile`, `salesforce_profile`, `mongodb_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] mysql_profile
        #   @return [::Google::Cloud::Datastream::V1::MysqlProfile]
        #     MySQL ConnectionProfile configuration.
        #
        #     Note: The following fields are mutually exclusive: `mysql_profile`, `oracle_profile`, `gcs_profile`, `bigquery_profile`, `postgresql_profile`, `sql_server_profile`, `salesforce_profile`, `mongodb_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bigquery_profile
        #   @return [::Google::Cloud::Datastream::V1::BigQueryProfile]
        #     BigQuery Connection Profile configuration.
        #
        #     Note: The following fields are mutually exclusive: `bigquery_profile`, `oracle_profile`, `gcs_profile`, `mysql_profile`, `postgresql_profile`, `sql_server_profile`, `salesforce_profile`, `mongodb_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] postgresql_profile
        #   @return [::Google::Cloud::Datastream::V1::PostgresqlProfile]
        #     PostgreSQL Connection Profile configuration.
        #
        #     Note: The following fields are mutually exclusive: `postgresql_profile`, `oracle_profile`, `gcs_profile`, `mysql_profile`, `bigquery_profile`, `sql_server_profile`, `salesforce_profile`, `mongodb_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sql_server_profile
        #   @return [::Google::Cloud::Datastream::V1::SqlServerProfile]
        #     SQLServer Connection Profile configuration.
        #
        #     Note: The following fields are mutually exclusive: `sql_server_profile`, `oracle_profile`, `gcs_profile`, `mysql_profile`, `bigquery_profile`, `postgresql_profile`, `salesforce_profile`, `mongodb_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] salesforce_profile
        #   @return [::Google::Cloud::Datastream::V1::SalesforceProfile]
        #     Salesforce Connection Profile configuration.
        #
        #     Note: The following fields are mutually exclusive: `salesforce_profile`, `oracle_profile`, `gcs_profile`, `mysql_profile`, `bigquery_profile`, `postgresql_profile`, `sql_server_profile`, `mongodb_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] mongodb_profile
        #   @return [::Google::Cloud::Datastream::V1::MongodbProfile]
        #     MongoDB Connection Profile configuration.
        #
        #     Note: The following fields are mutually exclusive: `mongodb_profile`, `oracle_profile`, `gcs_profile`, `mysql_profile`, `bigquery_profile`, `postgresql_profile`, `sql_server_profile`, `salesforce_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] static_service_ip_connectivity
        #   @return [::Google::Cloud::Datastream::V1::StaticServiceIpConnectivity]
        #     Static Service IP connectivity.
        #
        #     Note: The following fields are mutually exclusive: `static_service_ip_connectivity`, `forward_ssh_connectivity`, `private_connectivity`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] forward_ssh_connectivity
        #   @return [::Google::Cloud::Datastream::V1::ForwardSshTunnelConnectivity]
        #     Forward SSH tunnel connectivity.
        #
        #     Note: The following fields are mutually exclusive: `forward_ssh_connectivity`, `static_service_ip_connectivity`, `private_connectivity`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] private_connectivity
        #   @return [::Google::Cloud::Datastream::V1::PrivateConnectivity]
        #     Private connectivity.
        #
        #     Note: The following fields are mutually exclusive: `private_connectivity`, `static_service_ip_connectivity`, `forward_ssh_connectivity`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class ConnectionProfile
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Oracle Column.
        # @!attribute [rw] column
        #   @return [::String]
        #     Column name.
        # @!attribute [rw] data_type
        #   @return [::String]
        #     The Oracle data type.
        # @!attribute [rw] length
        #   @return [::Integer]
        #     Column length.
        # @!attribute [rw] precision
        #   @return [::Integer]
        #     Column precision.
        # @!attribute [rw] scale
        #   @return [::Integer]
        #     Column scale.
        # @!attribute [rw] encoding
        #   @return [::String]
        #     Column encoding.
        # @!attribute [rw] primary_key
        #   @return [::Boolean]
        #     Whether or not the column represents a primary key.
        # @!attribute [rw] nullable
        #   @return [::Boolean]
        #     Whether or not the column can accept a null value.
        # @!attribute [rw] ordinal_position
        #   @return [::Integer]
        #     The ordinal position of the column in the table.
        class OracleColumn
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Oracle table.
        # @!attribute [rw] table
        #   @return [::String]
        #     Table name.
        # @!attribute [rw] oracle_columns
        #   @return [::Array<::Google::Cloud::Datastream::V1::OracleColumn>]
        #     Oracle columns in the schema.
        #     When unspecified as part of include/exclude objects, includes/excludes
        #     everything.
        class OracleTable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Oracle schema.
        # @!attribute [rw] schema
        #   @return [::String]
        #     Schema name.
        # @!attribute [rw] oracle_tables
        #   @return [::Array<::Google::Cloud::Datastream::V1::OracleTable>]
        #     Tables in the schema.
        class OracleSchema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Oracle database structure.
        # @!attribute [rw] oracle_schemas
        #   @return [::Array<::Google::Cloud::Datastream::V1::OracleSchema>]
        #     Oracle schemas/databases in the database server.
        class OracleRdbms
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Oracle data source configuration
        # @!attribute [rw] include_objects
        #   @return [::Google::Cloud::Datastream::V1::OracleRdbms]
        #     Oracle objects to include in the stream.
        # @!attribute [rw] exclude_objects
        #   @return [::Google::Cloud::Datastream::V1::OracleRdbms]
        #     Oracle objects to exclude from the stream.
        # @!attribute [rw] max_concurrent_cdc_tasks
        #   @return [::Integer]
        #     Maximum number of concurrent CDC tasks. The number should be non-negative.
        #     If not set (or set to 0), the system's default value is used.
        # @!attribute [rw] max_concurrent_backfill_tasks
        #   @return [::Integer]
        #     Maximum number of concurrent backfill tasks. The number should be
        #     non-negative. If not set (or set to 0), the system's default value is used.
        # @!attribute [rw] drop_large_objects
        #   @return [::Google::Cloud::Datastream::V1::OracleSourceConfig::DropLargeObjects]
        #     Drop large object values.
        #
        #     Note: The following fields are mutually exclusive: `drop_large_objects`, `stream_large_objects`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] stream_large_objects
        #   @return [::Google::Cloud::Datastream::V1::OracleSourceConfig::StreamLargeObjects]
        #     Stream large object values.
        #
        #     Note: The following fields are mutually exclusive: `stream_large_objects`, `drop_large_objects`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] log_miner
        #   @return [::Google::Cloud::Datastream::V1::OracleSourceConfig::LogMiner]
        #     Use LogMiner.
        #
        #     Note: The following fields are mutually exclusive: `log_miner`, `binary_log_parser`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] binary_log_parser
        #   @return [::Google::Cloud::Datastream::V1::OracleSourceConfig::BinaryLogParser]
        #     Use Binary Log Parser.
        #
        #     Note: The following fields are mutually exclusive: `binary_log_parser`, `log_miner`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class OracleSourceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Configuration to drop large object values.
          class DropLargeObjects
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration to stream large object values.
          class StreamLargeObjects
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration to use LogMiner CDC method.
          class LogMiner
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Configuration to use Binary Log Parser CDC technique.
          # @!attribute [rw] oracle_asm_log_file_access
          #   @return [::Google::Cloud::Datastream::V1::OracleSourceConfig::BinaryLogParser::OracleAsmLogFileAccess]
          #     Use Oracle ASM.
          #
          #     Note: The following fields are mutually exclusive: `oracle_asm_log_file_access`, `log_file_directories`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] log_file_directories
          #   @return [::Google::Cloud::Datastream::V1::OracleSourceConfig::BinaryLogParser::LogFileDirectories]
          #     Use Oracle directories.
          #
          #     Note: The following fields are mutually exclusive: `log_file_directories`, `oracle_asm_log_file_access`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class BinaryLogParser
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Configuration to use Oracle ASM to access the log files.
            class OracleAsmLogFileAccess
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Configuration to specify the Oracle directories to access the log files.
            # @!attribute [rw] online_log_directory
            #   @return [::String]
            #     Required. Oracle directory for online logs.
            # @!attribute [rw] archived_log_directory
            #   @return [::String]
            #     Required. Oracle directory for archived logs.
            class LogFileDirectories
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end
        end

        # PostgreSQL Column.
        # @!attribute [rw] column
        #   @return [::String]
        #     Column name.
        # @!attribute [rw] data_type
        #   @return [::String]
        #     The PostgreSQL data type.
        # @!attribute [rw] length
        #   @return [::Integer]
        #     Column length.
        # @!attribute [rw] precision
        #   @return [::Integer]
        #     Column precision.
        # @!attribute [rw] scale
        #   @return [::Integer]
        #     Column scale.
        # @!attribute [rw] primary_key
        #   @return [::Boolean]
        #     Whether or not the column represents a primary key.
        # @!attribute [rw] nullable
        #   @return [::Boolean]
        #     Whether or not the column can accept a null value.
        # @!attribute [rw] ordinal_position
        #   @return [::Integer]
        #     The ordinal position of the column in the table.
        class PostgresqlColumn
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PostgreSQL table.
        # @!attribute [rw] table
        #   @return [::String]
        #     Table name.
        # @!attribute [rw] postgresql_columns
        #   @return [::Array<::Google::Cloud::Datastream::V1::PostgresqlColumn>]
        #     PostgreSQL columns in the schema.
        #     When unspecified as part of include/exclude objects,
        #     includes/excludes everything.
        class PostgresqlTable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PostgreSQL schema.
        # @!attribute [rw] schema
        #   @return [::String]
        #     Schema name.
        # @!attribute [rw] postgresql_tables
        #   @return [::Array<::Google::Cloud::Datastream::V1::PostgresqlTable>]
        #     Tables in the schema.
        class PostgresqlSchema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PostgreSQL database structure.
        # @!attribute [rw] postgresql_schemas
        #   @return [::Array<::Google::Cloud::Datastream::V1::PostgresqlSchema>]
        #     PostgreSQL schemas in the database server.
        class PostgresqlRdbms
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # PostgreSQL data source configuration
        # @!attribute [rw] include_objects
        #   @return [::Google::Cloud::Datastream::V1::PostgresqlRdbms]
        #     PostgreSQL objects to include in the stream.
        # @!attribute [rw] exclude_objects
        #   @return [::Google::Cloud::Datastream::V1::PostgresqlRdbms]
        #     PostgreSQL objects to exclude from the stream.
        # @!attribute [rw] replication_slot
        #   @return [::String]
        #     Required. Immutable. The name of the logical replication slot that's
        #     configured with the pgoutput plugin.
        # @!attribute [rw] publication
        #   @return [::String]
        #     Required. The name of the publication that includes the set of all tables
        #     that are defined in the stream's include_objects.
        # @!attribute [rw] max_concurrent_backfill_tasks
        #   @return [::Integer]
        #     Maximum number of concurrent backfill tasks. The number should be non
        #     negative. If not set (or set to 0), the system's default value will be
        #     used.
        class PostgresqlSourceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SQLServer Column.
        # @!attribute [rw] column
        #   @return [::String]
        #     Column name.
        # @!attribute [rw] data_type
        #   @return [::String]
        #     The SQLServer data type.
        # @!attribute [rw] length
        #   @return [::Integer]
        #     Column length.
        # @!attribute [rw] precision
        #   @return [::Integer]
        #     Column precision.
        # @!attribute [rw] scale
        #   @return [::Integer]
        #     Column scale.
        # @!attribute [rw] primary_key
        #   @return [::Boolean]
        #     Whether or not the column represents a primary key.
        # @!attribute [rw] nullable
        #   @return [::Boolean]
        #     Whether or not the column can accept a null value.
        # @!attribute [rw] ordinal_position
        #   @return [::Integer]
        #     The ordinal position of the column in the table.
        class SqlServerColumn
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SQLServer table.
        # @!attribute [rw] table
        #   @return [::String]
        #     Table name.
        # @!attribute [rw] columns
        #   @return [::Array<::Google::Cloud::Datastream::V1::SqlServerColumn>]
        #     SQLServer columns in the schema.
        #     When unspecified as part of include/exclude objects,
        #     includes/excludes everything.
        class SqlServerTable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SQLServer schema.
        # @!attribute [rw] schema
        #   @return [::String]
        #     Schema name.
        # @!attribute [rw] tables
        #   @return [::Array<::Google::Cloud::Datastream::V1::SqlServerTable>]
        #     Tables in the schema.
        class SqlServerSchema
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SQLServer database structure.
        # @!attribute [rw] schemas
        #   @return [::Array<::Google::Cloud::Datastream::V1::SqlServerSchema>]
        #     SQLServer schemas in the database server.
        class SqlServerRdbms
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # SQLServer data source configuration
        # @!attribute [rw] include_objects
        #   @return [::Google::Cloud::Datastream::V1::SqlServerRdbms]
        #     SQLServer objects to include in the stream.
        # @!attribute [rw] exclude_objects
        #   @return [::Google::Cloud::Datastream::V1::SqlServerRdbms]
        #     SQLServer objects to exclude from the stream.
        # @!attribute [rw] max_concurrent_cdc_tasks
        #   @return [::Integer]
        #     Max concurrent CDC tasks.
        # @!attribute [rw] max_concurrent_backfill_tasks
        #   @return [::Integer]
        #     Max concurrent backfill tasks.
        # @!attribute [rw] transaction_logs
        #   @return [::Google::Cloud::Datastream::V1::SqlServerTransactionLogs]
        #     CDC reader reads from transaction logs.
        #
        #     Note: The following fields are mutually exclusive: `transaction_logs`, `change_tables`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] change_tables
        #   @return [::Google::Cloud::Datastream::V1::SqlServerChangeTables]
        #     CDC reader reads from change tables.
        #
        #     Note: The following fields are mutually exclusive: `change_tables`, `transaction_logs`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class SqlServerSourceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration to use Transaction Logs CDC read method.
        class SqlServerTransactionLogs
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Configuration to use Change Tables CDC read method.
        class SqlServerChangeTables
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MySQL Column.
        # @!attribute [rw] column
        #   @return [::String]
        #     Column name.
        # @!attribute [rw] data_type
        #   @return [::String]
        #     The MySQL data type. Full data types list can be found here:
        #     https://dev.mysql.com/doc/refman/8.0/en/data-types.html
        # @!attribute [rw] length
        #   @return [::Integer]
        #     Column length.
        # @!attribute [rw] collation
        #   @return [::String]
        #     Column collation.
        # @!attribute [rw] primary_key
        #   @return [::Boolean]
        #     Whether or not the column represents a primary key.
        # @!attribute [rw] nullable
        #   @return [::Boolean]
        #     Whether or not the column can accept a null value.
        # @!attribute [rw] ordinal_position
        #   @return [::Integer]
        #     The ordinal position of the column in the table.
        # @!attribute [rw] precision
        #   @return [::Integer]
        #     Column precision.
        # @!attribute [rw] scale
        #   @return [::Integer]
        #     Column scale.
        class MysqlColumn
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MySQL table.
        # @!attribute [rw] table
        #   @return [::String]
        #     Table name.
        # @!attribute [rw] mysql_columns
        #   @return [::Array<::Google::Cloud::Datastream::V1::MysqlColumn>]
        #     MySQL columns in the database.
        #     When unspecified as part of include/exclude objects, includes/excludes
        #     everything.
        class MysqlTable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MySQL database.
        # @!attribute [rw] database
        #   @return [::String]
        #     Database name.
        # @!attribute [rw] mysql_tables
        #   @return [::Array<::Google::Cloud::Datastream::V1::MysqlTable>]
        #     Tables in the database.
        class MysqlDatabase
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MySQL database structure
        # @!attribute [rw] mysql_databases
        #   @return [::Array<::Google::Cloud::Datastream::V1::MysqlDatabase>]
        #     Mysql databases on the server
        class MysqlRdbms
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MySQL source configuration
        # @!attribute [rw] include_objects
        #   @return [::Google::Cloud::Datastream::V1::MysqlRdbms]
        #     MySQL objects to retrieve from the source.
        # @!attribute [rw] exclude_objects
        #   @return [::Google::Cloud::Datastream::V1::MysqlRdbms]
        #     MySQL objects to exclude from the stream.
        # @!attribute [rw] max_concurrent_cdc_tasks
        #   @return [::Integer]
        #     Maximum number of concurrent CDC tasks. The number should be non negative.
        #     If not set (or set to 0), the system's default value will be used.
        # @!attribute [rw] max_concurrent_backfill_tasks
        #   @return [::Integer]
        #     Maximum number of concurrent backfill tasks. The number should be non
        #     negative. If not set (or set to 0), the system's default value will be
        #     used.
        # @!attribute [rw] binary_log_position
        #   @return [::Google::Cloud::Datastream::V1::MysqlSourceConfig::BinaryLogPosition]
        #     Use Binary log position based replication.
        #
        #     Note: The following fields are mutually exclusive: `binary_log_position`, `gtid`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] gtid
        #   @return [::Google::Cloud::Datastream::V1::MysqlSourceConfig::Gtid]
        #     Use GTID based replication.
        #
        #     Note: The following fields are mutually exclusive: `gtid`, `binary_log_position`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class MysqlSourceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Use Binary log position based replication.
          class BinaryLogPosition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Use GTID based replication.
          class Gtid
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Salesforce source configuration
        # @!attribute [rw] include_objects
        #   @return [::Google::Cloud::Datastream::V1::SalesforceOrg]
        #     Salesforce objects to retrieve from the source.
        # @!attribute [rw] exclude_objects
        #   @return [::Google::Cloud::Datastream::V1::SalesforceOrg]
        #     Salesforce objects to exclude from the stream.
        # @!attribute [rw] polling_interval
        #   @return [::Google::Protobuf::Duration]
        #     Required. Salesforce objects polling interval. The interval at which new
        #     changes will be polled for each object. The duration must be between 5
        #     minutes and 24 hours.
        class SalesforceSourceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Salesforce organization structure.
        # @!attribute [rw] objects
        #   @return [::Array<::Google::Cloud::Datastream::V1::SalesforceObject>]
        #     Salesforce objects in the database server.
        class SalesforceOrg
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Salesforce object.
        # @!attribute [rw] object_name
        #   @return [::String]
        #     Object name.
        # @!attribute [rw] fields
        #   @return [::Array<::Google::Cloud::Datastream::V1::SalesforceField>]
        #     Salesforce fields.
        #     When unspecified as part of include objects,
        #     includes everything, when unspecified as part of exclude objects,
        #     excludes nothing.
        class SalesforceObject
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Salesforce field.
        # @!attribute [rw] name
        #   @return [::String]
        #     Field name.
        # @!attribute [rw] data_type
        #   @return [::String]
        #     The data type.
        # @!attribute [rw] nillable
        #   @return [::Boolean]
        #     Indicates whether the field can accept nil values.
        class SalesforceField
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MongoDB source configuration.
        # @!attribute [rw] include_objects
        #   @return [::Google::Cloud::Datastream::V1::MongodbCluster]
        #     MongoDB collections to include in the stream.
        # @!attribute [rw] exclude_objects
        #   @return [::Google::Cloud::Datastream::V1::MongodbCluster]
        #     MongoDB collections to exclude from the stream.
        # @!attribute [rw] max_concurrent_backfill_tasks
        #   @return [::Integer]
        #     Optional. Maximum number of concurrent backfill tasks. The number should be
        #     non-negative and less than or equal to 50. If not set (or set to 0), the
        #     system's default value is used
        class MongodbSourceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MongoDB Cluster structure.
        # @!attribute [rw] databases
        #   @return [::Array<::Google::Cloud::Datastream::V1::MongodbDatabase>]
        #     MongoDB databases in the cluster.
        class MongodbCluster
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MongoDB Database.
        # @!attribute [rw] database
        #   @return [::String]
        #     Database name.
        # @!attribute [rw] collections
        #   @return [::Array<::Google::Cloud::Datastream::V1::MongodbCollection>]
        #     Collections in the database.
        class MongodbDatabase
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MongoDB Collection.
        # @!attribute [rw] collection
        #   @return [::String]
        #     Collection name.
        # @!attribute [rw] fields
        #   @return [::Array<::Google::Cloud::Datastream::V1::MongodbField>]
        #     Fields in the collection.
        class MongodbCollection
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MongoDB Field.
        # @!attribute [rw] field
        #   @return [::String]
        #     Field name.
        class MongodbField
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The configuration of the stream source.
        # @!attribute [rw] source_connection_profile
        #   @return [::String]
        #     Required. Source connection profile resource.
        #     Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
        # @!attribute [rw] oracle_source_config
        #   @return [::Google::Cloud::Datastream::V1::OracleSourceConfig]
        #     Oracle data source configuration.
        #
        #     Note: The following fields are mutually exclusive: `oracle_source_config`, `mysql_source_config`, `postgresql_source_config`, `sql_server_source_config`, `salesforce_source_config`, `mongodb_source_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] mysql_source_config
        #   @return [::Google::Cloud::Datastream::V1::MysqlSourceConfig]
        #     MySQL data source configuration.
        #
        #     Note: The following fields are mutually exclusive: `mysql_source_config`, `oracle_source_config`, `postgresql_source_config`, `sql_server_source_config`, `salesforce_source_config`, `mongodb_source_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] postgresql_source_config
        #   @return [::Google::Cloud::Datastream::V1::PostgresqlSourceConfig]
        #     PostgreSQL data source configuration.
        #
        #     Note: The following fields are mutually exclusive: `postgresql_source_config`, `oracle_source_config`, `mysql_source_config`, `sql_server_source_config`, `salesforce_source_config`, `mongodb_source_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sql_server_source_config
        #   @return [::Google::Cloud::Datastream::V1::SqlServerSourceConfig]
        #     SQLServer data source configuration.
        #
        #     Note: The following fields are mutually exclusive: `sql_server_source_config`, `oracle_source_config`, `mysql_source_config`, `postgresql_source_config`, `salesforce_source_config`, `mongodb_source_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] salesforce_source_config
        #   @return [::Google::Cloud::Datastream::V1::SalesforceSourceConfig]
        #     Salesforce data source configuration.
        #
        #     Note: The following fields are mutually exclusive: `salesforce_source_config`, `oracle_source_config`, `mysql_source_config`, `postgresql_source_config`, `sql_server_source_config`, `mongodb_source_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] mongodb_source_config
        #   @return [::Google::Cloud::Datastream::V1::MongodbSourceConfig]
        #     MongoDB data source configuration.
        #
        #     Note: The following fields are mutually exclusive: `mongodb_source_config`, `oracle_source_config`, `mysql_source_config`, `postgresql_source_config`, `sql_server_source_config`, `salesforce_source_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class SourceConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # AVRO file format configuration.
        class AvroFileFormat
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # JSON file format configuration.
        # @!attribute [rw] schema_file_format
        #   @return [::Google::Cloud::Datastream::V1::JsonFileFormat::SchemaFileFormat]
        #     The schema file format along JSON data files.
        # @!attribute [rw] compression
        #   @return [::Google::Cloud::Datastream::V1::JsonFileFormat::JsonCompression]
        #     Compression of the loaded JSON file.
        class JsonFileFormat
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Schema file format.
          module SchemaFileFormat
            # Unspecified schema file format.
            SCHEMA_FILE_FORMAT_UNSPECIFIED = 0

            # Do not attach schema file.
            NO_SCHEMA_FILE = 1

            # Avro schema format.
            AVRO_SCHEMA_FILE = 2
          end

          # Json file compression.
          module JsonCompression
            # Unspecified json file compression.
            JSON_COMPRESSION_UNSPECIFIED = 0

            # Do not compress JSON file.
            NO_COMPRESSION = 1

            # Gzip compression.
            GZIP = 2
          end
        end

        # Google Cloud Storage destination configuration
        # @!attribute [rw] path
        #   @return [::String]
        #     Path inside the Cloud Storage bucket to write data to.
        # @!attribute [rw] file_rotation_mb
        #   @return [::Integer]
        #     The maximum file size to be saved in the bucket.
        # @!attribute [rw] file_rotation_interval
        #   @return [::Google::Protobuf::Duration]
        #     The maximum duration for which new events are added before a file is
        #     closed and a new file is created. Values within the range of 15-60 seconds
        #     are allowed.
        # @!attribute [rw] avro_file_format
        #   @return [::Google::Cloud::Datastream::V1::AvroFileFormat]
        #     AVRO file format configuration.
        #
        #     Note: The following fields are mutually exclusive: `avro_file_format`, `json_file_format`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] json_file_format
        #   @return [::Google::Cloud::Datastream::V1::JsonFileFormat]
        #     JSON file format configuration.
        #
        #     Note: The following fields are mutually exclusive: `json_file_format`, `avro_file_format`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class GcsDestinationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # BigQuery destination configuration
        # @!attribute [rw] single_target_dataset
        #   @return [::Google::Cloud::Datastream::V1::BigQueryDestinationConfig::SingleTargetDataset]
        #     Single destination dataset.
        #
        #     Note: The following fields are mutually exclusive: `single_target_dataset`, `source_hierarchy_datasets`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] source_hierarchy_datasets
        #   @return [::Google::Cloud::Datastream::V1::BigQueryDestinationConfig::SourceHierarchyDatasets]
        #     Source hierarchy datasets.
        #
        #     Note: The following fields are mutually exclusive: `source_hierarchy_datasets`, `single_target_dataset`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] data_freshness
        #   @return [::Google::Protobuf::Duration]
        #     The guaranteed data freshness (in seconds) when querying tables created by
        #     the stream. Editing this field will only affect new tables created in the
        #     future, but existing tables will not be impacted. Lower values mean that
        #     queries will return fresher data, but may result in higher cost.
        # @!attribute [rw] blmt_config
        #   @return [::Google::Cloud::Datastream::V1::BigQueryDestinationConfig::BlmtConfig]
        #     Optional. Big Lake Managed Tables (BLMT) configuration.
        # @!attribute [rw] merge
        #   @return [::Google::Cloud::Datastream::V1::BigQueryDestinationConfig::Merge]
        #     The standard mode
        #
        #     Note: The following fields are mutually exclusive: `merge`, `append_only`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] append_only
        #   @return [::Google::Cloud::Datastream::V1::BigQueryDestinationConfig::AppendOnly]
        #     Append only mode
        #
        #     Note: The following fields are mutually exclusive: `append_only`, `merge`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class BigQueryDestinationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A single target dataset to which all data will be streamed.
          # @!attribute [rw] dataset_id
          #   @return [::String]
          #     The dataset ID of the target dataset.
          #     DatasetIds allowed characters:
          #     https://cloud.google.com/bigquery/docs/reference/rest/v2/datasets#datasetreference.
          class SingleTargetDataset
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Destination datasets are created so that hierarchy of the destination data
          # objects matches the source hierarchy.
          # @!attribute [rw] dataset_template
          #   @return [::Google::Cloud::Datastream::V1::BigQueryDestinationConfig::SourceHierarchyDatasets::DatasetTemplate]
          #     The dataset template to use for dynamic dataset creation.
          # @!attribute [rw] project_id
          #   @return [::String]
          #     Optional. The project id of the BigQuery dataset. If not specified, the
          #     project will be inferred from the stream resource.
          class SourceHierarchyDatasets
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Dataset template used for dynamic dataset creation.
            # @!attribute [rw] location
            #   @return [::String]
            #     Required. The geographic location where the dataset should reside. See
            #     https://cloud.google.com/bigquery/docs/locations for supported
            #     locations.
            # @!attribute [rw] dataset_id_prefix
            #   @return [::String]
            #     If supplied, every created dataset will have its name prefixed by the
            #     provided value. The prefix and name will be separated by an underscore.
            #     i.e. <prefix>_<dataset_name>.
            # @!attribute [rw] kms_key_name
            #   @return [::String]
            #     Describes the Cloud KMS encryption key that will be used to
            #     protect destination BigQuery table. The BigQuery Service Account
            #     associated with your project requires access to this encryption key.
            #     i.e.
            #     projects/\\{project}/locations/\\{location}/keyRings/\\{key_ring}/cryptoKeys/\\{cryptoKey}.
            #     See https://cloud.google.com/bigquery/docs/customer-managed-encryption
            #     for more information.
            class DatasetTemplate
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The configuration for BLMT.
          # @!attribute [rw] bucket
          #   @return [::String]
          #     Required. The Cloud Storage bucket name.
          # @!attribute [rw] root_path
          #   @return [::String]
          #     The root path inside the Cloud Storage bucket.
          # @!attribute [rw] connection_name
          #   @return [::String]
          #     Required. The bigquery connection.
          #     Format: `{project}.{location}.{name}`
          # @!attribute [rw] file_format
          #   @return [::Google::Cloud::Datastream::V1::BigQueryDestinationConfig::BlmtConfig::FileFormat]
          #     Required. The file format.
          # @!attribute [rw] table_format
          #   @return [::Google::Cloud::Datastream::V1::BigQueryDestinationConfig::BlmtConfig::TableFormat]
          #     Required. The table format.
          class BlmtConfig
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Supported file formats for BigLake managed tables.
            module FileFormat
              # Default value.
              FILE_FORMAT_UNSPECIFIED = 0

              # Parquet file format.
              PARQUET = 1
            end

            # Supported table formats for BigLake managed tables.
            module TableFormat
              # Default value.
              TABLE_FORMAT_UNSPECIFIED = 0

              # Iceberg table format.
              ICEBERG = 1
            end
          end

          # AppendOnly mode defines that all changes to a table will be written to the
          # destination table.
          class AppendOnly
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Merge mode defines that all changes to a table will be merged at the
          # destination table.
          class Merge
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The configuration of the stream destination.
        # @!attribute [rw] destination_connection_profile
        #   @return [::String]
        #     Required. Destination connection profile resource.
        #     Format: `projects/{project}/locations/{location}/connectionProfiles/{name}`
        # @!attribute [rw] gcs_destination_config
        #   @return [::Google::Cloud::Datastream::V1::GcsDestinationConfig]
        #     A configuration for how data should be loaded to Cloud Storage.
        #
        #     Note: The following fields are mutually exclusive: `gcs_destination_config`, `bigquery_destination_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] bigquery_destination_config
        #   @return [::Google::Cloud::Datastream::V1::BigQueryDestinationConfig]
        #     BigQuery destination configuration.
        #
        #     Note: The following fields are mutually exclusive: `bigquery_destination_config`, `gcs_destination_config`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DestinationConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A resource representing streaming data from a source to a destination.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The stream's name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation time of the stream.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last update time of the stream.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Labels.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name.
        # @!attribute [rw] source_config
        #   @return [::Google::Cloud::Datastream::V1::SourceConfig]
        #     Required. Source connection profile configuration.
        # @!attribute [rw] destination_config
        #   @return [::Google::Cloud::Datastream::V1::DestinationConfig]
        #     Required. Destination connection profile configuration.
        # @!attribute [rw] state
        #   @return [::Google::Cloud::Datastream::V1::Stream::State]
        #     The state of the stream.
        # @!attribute [rw] backfill_all
        #   @return [::Google::Cloud::Datastream::V1::Stream::BackfillAllStrategy]
        #     Automatically backfill objects included in the stream source
        #     configuration. Specific objects can be excluded.
        #
        #     Note: The following fields are mutually exclusive: `backfill_all`, `backfill_none`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] backfill_none
        #   @return [::Google::Cloud::Datastream::V1::Stream::BackfillNoneStrategy]
        #     Do not automatically backfill any objects.
        #
        #     Note: The following fields are mutually exclusive: `backfill_none`, `backfill_all`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] errors
        #   @return [::Array<::Google::Cloud::Datastream::V1::Error>]
        #     Output only. Errors on the Stream.
        # @!attribute [rw] customer_managed_encryption_key
        #   @return [::String]
        #     Immutable. A reference to a KMS encryption key.
        #     If provided, it will be used to encrypt the data.
        #     If left blank, data will be encrypted using an internal Stream-specific
        #     encryption key provisioned through KMS.
        # @!attribute [r] last_recovery_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. If the stream was recovered, the time of the last recovery.
        #     Note: This field is currently experimental.
        # @!attribute [r] satisfies_pzs
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        # @!attribute [r] satisfies_pzi
        #   @return [::Boolean]
        #     Output only. Reserved for future use.
        class Stream
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Backfill strategy to automatically backfill the Stream's objects.
          # Specific objects can be excluded.
          # @!attribute [rw] oracle_excluded_objects
          #   @return [::Google::Cloud::Datastream::V1::OracleRdbms]
          #     Oracle data source objects to avoid backfilling.
          #
          #     Note: The following fields are mutually exclusive: `oracle_excluded_objects`, `mysql_excluded_objects`, `postgresql_excluded_objects`, `sql_server_excluded_objects`, `salesforce_excluded_objects`, `mongodb_excluded_objects`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] mysql_excluded_objects
          #   @return [::Google::Cloud::Datastream::V1::MysqlRdbms]
          #     MySQL data source objects to avoid backfilling.
          #
          #     Note: The following fields are mutually exclusive: `mysql_excluded_objects`, `oracle_excluded_objects`, `postgresql_excluded_objects`, `sql_server_excluded_objects`, `salesforce_excluded_objects`, `mongodb_excluded_objects`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] postgresql_excluded_objects
          #   @return [::Google::Cloud::Datastream::V1::PostgresqlRdbms]
          #     PostgreSQL data source objects to avoid backfilling.
          #
          #     Note: The following fields are mutually exclusive: `postgresql_excluded_objects`, `oracle_excluded_objects`, `mysql_excluded_objects`, `sql_server_excluded_objects`, `salesforce_excluded_objects`, `mongodb_excluded_objects`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] sql_server_excluded_objects
          #   @return [::Google::Cloud::Datastream::V1::SqlServerRdbms]
          #     SQLServer data source objects to avoid backfilling
          #
          #     Note: The following fields are mutually exclusive: `sql_server_excluded_objects`, `oracle_excluded_objects`, `mysql_excluded_objects`, `postgresql_excluded_objects`, `salesforce_excluded_objects`, `mongodb_excluded_objects`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] salesforce_excluded_objects
          #   @return [::Google::Cloud::Datastream::V1::SalesforceOrg]
          #     Salesforce data source objects to avoid backfilling
          #
          #     Note: The following fields are mutually exclusive: `salesforce_excluded_objects`, `oracle_excluded_objects`, `mysql_excluded_objects`, `postgresql_excluded_objects`, `sql_server_excluded_objects`, `mongodb_excluded_objects`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] mongodb_excluded_objects
          #   @return [::Google::Cloud::Datastream::V1::MongodbCluster]
          #     MongoDB data source objects to avoid backfilling
          #
          #     Note: The following fields are mutually exclusive: `mongodb_excluded_objects`, `oracle_excluded_objects`, `mysql_excluded_objects`, `postgresql_excluded_objects`, `sql_server_excluded_objects`, `salesforce_excluded_objects`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class BackfillAllStrategy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Backfill strategy to disable automatic backfill for the Stream's objects.
          class BackfillNoneStrategy
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Stream state.
          module State
            # Unspecified stream state.
            STATE_UNSPECIFIED = 0

            # The stream has been created but has not yet started streaming data.
            NOT_STARTED = 1

            # The stream is running.
            RUNNING = 2

            # The stream is paused.
            PAUSED = 3

            # The stream is in maintenance mode.
            #
            # Updates are rejected on the resource in this state.
            MAINTENANCE = 4

            # The stream is experiencing an error that is preventing data from being
            # streamed.
            FAILED = 5

            # The stream has experienced a terminal failure.
            FAILED_PERMANENTLY = 6

            # The stream is starting, but not yet running.
            STARTING = 7

            # The Stream is no longer reading new events, but still writing events in
            # the buffer.
            DRAINING = 8
          end
        end

        # A specific stream object (e.g a specific DB table).
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The object resource's name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The creation time of the object.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The last update time of the object.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Required. Display name.
        # @!attribute [r] errors
        #   @return [::Array<::Google::Cloud::Datastream::V1::Error>]
        #     Output only. Active errors on the object.
        # @!attribute [rw] backfill_job
        #   @return [::Google::Cloud::Datastream::V1::BackfillJob]
        #     The latest backfill job that was initiated for the stream object.
        # @!attribute [rw] source_object
        #   @return [::Google::Cloud::Datastream::V1::SourceObjectIdentifier]
        #     The object identifier in the data source.
        class StreamObject
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents an identifier of an object in the data source.
        # @!attribute [rw] oracle_identifier
        #   @return [::Google::Cloud::Datastream::V1::SourceObjectIdentifier::OracleObjectIdentifier]
        #     Oracle data source object identifier.
        #
        #     Note: The following fields are mutually exclusive: `oracle_identifier`, `mysql_identifier`, `postgresql_identifier`, `sql_server_identifier`, `salesforce_identifier`, `mongodb_identifier`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] mysql_identifier
        #   @return [::Google::Cloud::Datastream::V1::SourceObjectIdentifier::MysqlObjectIdentifier]
        #     Mysql data source object identifier.
        #
        #     Note: The following fields are mutually exclusive: `mysql_identifier`, `oracle_identifier`, `postgresql_identifier`, `sql_server_identifier`, `salesforce_identifier`, `mongodb_identifier`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] postgresql_identifier
        #   @return [::Google::Cloud::Datastream::V1::SourceObjectIdentifier::PostgresqlObjectIdentifier]
        #     PostgreSQL data source object identifier.
        #
        #     Note: The following fields are mutually exclusive: `postgresql_identifier`, `oracle_identifier`, `mysql_identifier`, `sql_server_identifier`, `salesforce_identifier`, `mongodb_identifier`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] sql_server_identifier
        #   @return [::Google::Cloud::Datastream::V1::SourceObjectIdentifier::SqlServerObjectIdentifier]
        #     SQLServer data source object identifier.
        #
        #     Note: The following fields are mutually exclusive: `sql_server_identifier`, `oracle_identifier`, `mysql_identifier`, `postgresql_identifier`, `salesforce_identifier`, `mongodb_identifier`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] salesforce_identifier
        #   @return [::Google::Cloud::Datastream::V1::SourceObjectIdentifier::SalesforceObjectIdentifier]
        #     Salesforce data source object identifier.
        #
        #     Note: The following fields are mutually exclusive: `salesforce_identifier`, `oracle_identifier`, `mysql_identifier`, `postgresql_identifier`, `sql_server_identifier`, `mongodb_identifier`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] mongodb_identifier
        #   @return [::Google::Cloud::Datastream::V1::SourceObjectIdentifier::MongodbObjectIdentifier]
        #     MongoDB data source object identifier.
        #
        #     Note: The following fields are mutually exclusive: `mongodb_identifier`, `oracle_identifier`, `mysql_identifier`, `postgresql_identifier`, `sql_server_identifier`, `salesforce_identifier`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class SourceObjectIdentifier
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Oracle data source object identifier.
          # @!attribute [rw] schema
          #   @return [::String]
          #     Required. The schema name.
          # @!attribute [rw] table
          #   @return [::String]
          #     Required. The table name.
          class OracleObjectIdentifier
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # PostgreSQL data source object identifier.
          # @!attribute [rw] schema
          #   @return [::String]
          #     Required. The schema name.
          # @!attribute [rw] table
          #   @return [::String]
          #     Required. The table name.
          class PostgresqlObjectIdentifier
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Mysql data source object identifier.
          # @!attribute [rw] database
          #   @return [::String]
          #     Required. The database name.
          # @!attribute [rw] table
          #   @return [::String]
          #     Required. The table name.
          class MysqlObjectIdentifier
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # SQLServer data source object identifier.
          # @!attribute [rw] schema
          #   @return [::String]
          #     Required. The schema name.
          # @!attribute [rw] table
          #   @return [::String]
          #     Required. The table name.
          class SqlServerObjectIdentifier
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Salesforce data source object identifier.
          # @!attribute [rw] object_name
          #   @return [::String]
          #     Required. The object name.
          class SalesforceObjectIdentifier
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # MongoDB data source object identifier.
          # @!attribute [rw] database
          #   @return [::String]
          #     Required. The database name.
          # @!attribute [rw] collection
          #   @return [::String]
          #     Required. The collection name.
          class MongodbObjectIdentifier
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Represents a backfill job on a specific stream object.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Datastream::V1::BackfillJob::State]
        #     Output only. Backfill job state.
        # @!attribute [rw] trigger
        #   @return [::Google::Cloud::Datastream::V1::BackfillJob::Trigger]
        #     Backfill job's triggering reason.
        # @!attribute [r] last_start_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Backfill job's start time.
        # @!attribute [r] last_end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. Backfill job's end time.
        # @!attribute [r] errors
        #   @return [::Array<::Google::Cloud::Datastream::V1::Error>]
        #     Output only. Errors which caused the backfill job to fail.
        class BackfillJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # State of the stream object's backfill job.
          module State
            # Default value.
            STATE_UNSPECIFIED = 0

            # Backfill job was never started for the stream object (stream has backfill
            # strategy defined as manual or object was explicitly excluded from
            # automatic backfill).
            NOT_STARTED = 1

            # Backfill job will start pending available resources.
            PENDING = 2

            # Backfill job is running.
            ACTIVE = 3

            # Backfill job stopped (next job run will start from beginning).
            STOPPED = 4

            # Backfill job failed (due to an error).
            FAILED = 5

            # Backfill completed successfully.
            COMPLETED = 6

            # Backfill job failed since the table structure is currently unsupported
            # for backfill.
            UNSUPPORTED = 7
          end

          # Triggering reason for a backfill job.
          module Trigger
            # Default value.
            TRIGGER_UNSPECIFIED = 0

            # Object backfill job was triggered automatically according to the stream's
            # backfill strategy.
            AUTOMATIC = 1

            # Object backfill job was triggered manually using the dedicated API.
            MANUAL = 2
          end
        end

        # Represent a user-facing Error.
        # @!attribute [rw] reason
        #   @return [::String]
        #     A title that explains the reason for the error.
        # @!attribute [rw] error_uuid
        #   @return [::String]
        #     A unique identifier for this specific error,
        #     allowing it to be traced throughout the system in logs and API responses.
        # @!attribute [rw] message
        #   @return [::String]
        #     A message containing more information about the error that occurred.
        # @!attribute [rw] error_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the error occurred.
        # @!attribute [rw] details
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Additional information about the error.
        class Error
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class DetailsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Contains the current validation results.
        # @!attribute [rw] validations
        #   @return [::Array<::Google::Cloud::Datastream::V1::Validation>]
        #     A list of validations (includes both executed as well as not executed
        #     validations).
        class ValidationResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A validation to perform on a stream.
        # @!attribute [rw] description
        #   @return [::String]
        #     A short description of the validation.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Datastream::V1::Validation::State]
        #     Output only. Validation execution status.
        # @!attribute [rw] message
        #   @return [::Array<::Google::Cloud::Datastream::V1::ValidationMessage>]
        #     Messages reflecting the validation results.
        # @!attribute [rw] code
        #   @return [::String]
        #     A custom code identifying this validation.
        class Validation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Validation execution state.
          module State
            # Unspecified state.
            STATE_UNSPECIFIED = 0

            # Validation did not execute.
            NOT_EXECUTED = 1

            # Validation failed.
            FAILED = 2

            # Validation passed.
            PASSED = 3

            # Validation executed with warnings.
            WARNING = 4
          end
        end

        # Represent user-facing validation result message.
        # @!attribute [rw] message
        #   @return [::String]
        #     The result of the validation.
        # @!attribute [rw] level
        #   @return [::Google::Cloud::Datastream::V1::ValidationMessage::Level]
        #     Message severity level (warning or error).
        # @!attribute [rw] metadata
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Additional metadata related to the result.
        # @!attribute [rw] code
        #   @return [::String]
        #     A custom code identifying this specific message.
        class ValidationMessage
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class MetadataEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Validation message level.
          module Level
            # Unspecified level.
            LEVEL_UNSPECIFIED = 0

            # Potentially cause issues with the Stream.
            WARNING = 1

            # Definitely cause issues with the Stream.
            ERROR = 2
          end
        end

        # The strategy that the stream uses for CDC replication.
        # @!attribute [rw] most_recent_start_position
        #   @return [::Google::Cloud::Datastream::V1::CdcStrategy::MostRecentStartPosition]
        #     Optional. Start replicating from the most recent position in the source.
        #
        #     Note: The following fields are mutually exclusive: `most_recent_start_position`, `next_available_start_position`, `specific_start_position`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] next_available_start_position
        #   @return [::Google::Cloud::Datastream::V1::CdcStrategy::NextAvailableStartPosition]
        #     Optional. Resume replication from the next available position in the
        #     source.
        #
        #     Note: The following fields are mutually exclusive: `next_available_start_position`, `most_recent_start_position`, `specific_start_position`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] specific_start_position
        #   @return [::Google::Cloud::Datastream::V1::CdcStrategy::SpecificStartPosition]
        #     Optional. Start replicating from a specific position in the source.
        #
        #     Note: The following fields are mutually exclusive: `specific_start_position`, `most_recent_start_position`, `next_available_start_position`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class CdcStrategy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # CDC strategy to start replicating from the most recent position in the
          # source.
          class MostRecentStartPosition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # CDC strategy to resume replication from the next available position in the
          # source.
          class NextAvailableStartPosition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # CDC strategy to start replicating from a specific position in the source.
          # @!attribute [rw] mysql_log_position
          #   @return [::Google::Cloud::Datastream::V1::MysqlLogPosition]
          #     MySQL specific log position to start replicating from.
          #
          #     Note: The following fields are mutually exclusive: `mysql_log_position`, `oracle_scn_position`, `sql_server_lsn_position`, `mysql_gtid_position`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] oracle_scn_position
          #   @return [::Google::Cloud::Datastream::V1::OracleScnPosition]
          #     Oracle SCN to start replicating from.
          #
          #     Note: The following fields are mutually exclusive: `oracle_scn_position`, `mysql_log_position`, `sql_server_lsn_position`, `mysql_gtid_position`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] sql_server_lsn_position
          #   @return [::Google::Cloud::Datastream::V1::SqlServerLsnPosition]
          #     SqlServer LSN to start replicating from.
          #
          #     Note: The following fields are mutually exclusive: `sql_server_lsn_position`, `mysql_log_position`, `oracle_scn_position`, `mysql_gtid_position`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          # @!attribute [rw] mysql_gtid_position
          #   @return [::Google::Cloud::Datastream::V1::MysqlGtidPosition]
          #     MySQL GTID set to start replicating from.
          #
          #     Note: The following fields are mutually exclusive: `mysql_gtid_position`, `mysql_log_position`, `oracle_scn_position`, `sql_server_lsn_position`. If a field in that set is populated, all other fields in the set will automatically be cleared.
          class SpecificStartPosition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # SQL Server LSN position
        # @!attribute [rw] lsn
        #   @return [::String]
        #     Required. Log sequence number (LSN) from where Logs will be read
        class SqlServerLsnPosition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Oracle SCN position
        # @!attribute [rw] scn
        #   @return [::Integer]
        #     Required. SCN number from where Logs will be read
        class OracleScnPosition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MySQL log position
        # @!attribute [rw] log_file
        #   @return [::String]
        #     Required. The binary log file name.
        # @!attribute [rw] log_position
        #   @return [::Integer]
        #     Optional. The position within the binary log file. Default is head of file.
        class MysqlLogPosition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # MySQL GTID position
        # @!attribute [rw] gtid_set
        #   @return [::String]
        #     Required. The gtid set to start replication from.
        class MysqlGtidPosition
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
