# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/datastore/v1/datastore_pb"
require "google/cloud/datastore/v1/datastore/rest"


class ::Google::Cloud::Datastore::V1::Datastore::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_lookup
    # Create test objects.
    client_result = ::Google::Cloud::Datastore::V1::LookupResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    database_id = "hello world"
    read_options = {}
    keys = [{}]
    property_mask = {}

    lookup_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastore::V1::Datastore::Rest::ServiceStub.stub :transcode_lookup_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, lookup_client_stub do
        # Create client
        client = ::Google::Cloud::Datastore::V1::Datastore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.lookup({ project_id: project_id, database_id: database_id, read_options: read_options, keys: keys, property_mask: property_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.lookup project_id: project_id, database_id: database_id, read_options: read_options, keys: keys, property_mask: property_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.lookup ::Google::Cloud::Datastore::V1::LookupRequest.new(project_id: project_id, database_id: database_id, read_options: read_options, keys: keys, property_mask: property_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.lookup({ project_id: project_id, database_id: database_id, read_options: read_options, keys: keys, property_mask: property_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.lookup(::Google::Cloud::Datastore::V1::LookupRequest.new(project_id: project_id, database_id: database_id, read_options: read_options, keys: keys, property_mask: property_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, lookup_client_stub.call_count
      end
    end
  end

  def test_run_query
    # Create test objects.
    client_result = ::Google::Cloud::Datastore::V1::RunQueryResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    database_id = "hello world"
    partition_id = {}
    read_options = {}
    query = {}
    property_mask = {}
    explain_options = {}

    run_query_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastore::V1::Datastore::Rest::ServiceStub.stub :transcode_run_query_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, run_query_client_stub do
        # Create client
        client = ::Google::Cloud::Datastore::V1::Datastore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.run_query({ project_id: project_id, database_id: database_id, partition_id: partition_id, read_options: read_options, query: query, property_mask: property_mask, explain_options: explain_options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.run_query project_id: project_id, database_id: database_id, partition_id: partition_id, read_options: read_options, query: query, property_mask: property_mask, explain_options: explain_options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.run_query ::Google::Cloud::Datastore::V1::RunQueryRequest.new(project_id: project_id, database_id: database_id, partition_id: partition_id, read_options: read_options, query: query, property_mask: property_mask, explain_options: explain_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.run_query({ project_id: project_id, database_id: database_id, partition_id: partition_id, read_options: read_options, query: query, property_mask: property_mask, explain_options: explain_options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.run_query(::Google::Cloud::Datastore::V1::RunQueryRequest.new(project_id: project_id, database_id: database_id, partition_id: partition_id, read_options: read_options, query: query, property_mask: property_mask, explain_options: explain_options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, run_query_client_stub.call_count
      end
    end
  end

  def test_run_aggregation_query
    # Create test objects.
    client_result = ::Google::Cloud::Datastore::V1::RunAggregationQueryResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    database_id = "hello world"
    partition_id = {}
    read_options = {}
    aggregation_query = {}
    explain_options = {}

    run_aggregation_query_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastore::V1::Datastore::Rest::ServiceStub.stub :transcode_run_aggregation_query_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, run_aggregation_query_client_stub do
        # Create client
        client = ::Google::Cloud::Datastore::V1::Datastore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.run_aggregation_query({ project_id: project_id, database_id: database_id, partition_id: partition_id, read_options: read_options, aggregation_query: aggregation_query, explain_options: explain_options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.run_aggregation_query project_id: project_id, database_id: database_id, partition_id: partition_id, read_options: read_options, aggregation_query: aggregation_query, explain_options: explain_options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.run_aggregation_query ::Google::Cloud::Datastore::V1::RunAggregationQueryRequest.new(project_id: project_id, database_id: database_id, partition_id: partition_id, read_options: read_options, aggregation_query: aggregation_query, explain_options: explain_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.run_aggregation_query({ project_id: project_id, database_id: database_id, partition_id: partition_id, read_options: read_options, aggregation_query: aggregation_query, explain_options: explain_options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.run_aggregation_query(::Google::Cloud::Datastore::V1::RunAggregationQueryRequest.new(project_id: project_id, database_id: database_id, partition_id: partition_id, read_options: read_options, aggregation_query: aggregation_query, explain_options: explain_options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, run_aggregation_query_client_stub.call_count
      end
    end
  end

  def test_begin_transaction
    # Create test objects.
    client_result = ::Google::Cloud::Datastore::V1::BeginTransactionResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    database_id = "hello world"
    transaction_options = {}

    begin_transaction_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastore::V1::Datastore::Rest::ServiceStub.stub :transcode_begin_transaction_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, begin_transaction_client_stub do
        # Create client
        client = ::Google::Cloud::Datastore::V1::Datastore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.begin_transaction({ project_id: project_id, database_id: database_id, transaction_options: transaction_options }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.begin_transaction project_id: project_id, database_id: database_id, transaction_options: transaction_options do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.begin_transaction ::Google::Cloud::Datastore::V1::BeginTransactionRequest.new(project_id: project_id, database_id: database_id, transaction_options: transaction_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.begin_transaction({ project_id: project_id, database_id: database_id, transaction_options: transaction_options }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.begin_transaction(::Google::Cloud::Datastore::V1::BeginTransactionRequest.new(project_id: project_id, database_id: database_id, transaction_options: transaction_options), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, begin_transaction_client_stub.call_count
      end
    end
  end

  def test_commit
    # Create test objects.
    client_result = ::Google::Cloud::Datastore::V1::CommitResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    database_id = "hello world"
    mode = :MODE_UNSPECIFIED
    transaction = "hello world"
    mutations = [{}]

    commit_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastore::V1::Datastore::Rest::ServiceStub.stub :transcode_commit_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, commit_client_stub do
        # Create client
        client = ::Google::Cloud::Datastore::V1::Datastore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.commit({ project_id: project_id, database_id: database_id, mode: mode, transaction: transaction, mutations: mutations }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.commit project_id: project_id, database_id: database_id, mode: mode, transaction: transaction, mutations: mutations do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.commit ::Google::Cloud::Datastore::V1::CommitRequest.new(project_id: project_id, database_id: database_id, mode: mode, transaction: transaction, mutations: mutations) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.commit({ project_id: project_id, database_id: database_id, mode: mode, transaction: transaction, mutations: mutations }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.commit(::Google::Cloud::Datastore::V1::CommitRequest.new(project_id: project_id, database_id: database_id, mode: mode, transaction: transaction, mutations: mutations), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, commit_client_stub.call_count
      end
    end
  end

  def test_rollback
    # Create test objects.
    client_result = ::Google::Cloud::Datastore::V1::RollbackResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    database_id = "hello world"
    transaction = "hello world"

    rollback_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastore::V1::Datastore::Rest::ServiceStub.stub :transcode_rollback_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, rollback_client_stub do
        # Create client
        client = ::Google::Cloud::Datastore::V1::Datastore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.rollback({ project_id: project_id, database_id: database_id, transaction: transaction }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.rollback project_id: project_id, database_id: database_id, transaction: transaction do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.rollback ::Google::Cloud::Datastore::V1::RollbackRequest.new(project_id: project_id, database_id: database_id, transaction: transaction) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.rollback({ project_id: project_id, database_id: database_id, transaction: transaction }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.rollback(::Google::Cloud::Datastore::V1::RollbackRequest.new(project_id: project_id, database_id: database_id, transaction: transaction), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, rollback_client_stub.call_count
      end
    end
  end

  def test_allocate_ids
    # Create test objects.
    client_result = ::Google::Cloud::Datastore::V1::AllocateIdsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    database_id = "hello world"
    keys = [{}]

    allocate_ids_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastore::V1::Datastore::Rest::ServiceStub.stub :transcode_allocate_ids_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, allocate_ids_client_stub do
        # Create client
        client = ::Google::Cloud::Datastore::V1::Datastore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.allocate_ids({ project_id: project_id, database_id: database_id, keys: keys }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.allocate_ids project_id: project_id, database_id: database_id, keys: keys do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.allocate_ids ::Google::Cloud::Datastore::V1::AllocateIdsRequest.new(project_id: project_id, database_id: database_id, keys: keys) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.allocate_ids({ project_id: project_id, database_id: database_id, keys: keys }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.allocate_ids(::Google::Cloud::Datastore::V1::AllocateIdsRequest.new(project_id: project_id, database_id: database_id, keys: keys), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, allocate_ids_client_stub.call_count
      end
    end
  end

  def test_reserve_ids
    # Create test objects.
    client_result = ::Google::Cloud::Datastore::V1::ReserveIdsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    project_id = "hello world"
    database_id = "hello world"
    keys = [{}]

    reserve_ids_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Datastore::V1::Datastore::Rest::ServiceStub.stub :transcode_reserve_ids_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, reserve_ids_client_stub do
        # Create client
        client = ::Google::Cloud::Datastore::V1::Datastore::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.reserve_ids({ project_id: project_id, database_id: database_id, keys: keys }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.reserve_ids project_id: project_id, database_id: database_id, keys: keys do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.reserve_ids ::Google::Cloud::Datastore::V1::ReserveIdsRequest.new(project_id: project_id, database_id: database_id, keys: keys) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.reserve_ids({ project_id: project_id, database_id: database_id, keys: keys }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.reserve_ids(::Google::Cloud::Datastore::V1::ReserveIdsRequest.new(project_id: project_id, database_id: database_id, keys: keys), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, reserve_ids_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Datastore::V1::Datastore::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Datastore::V1::Datastore::Rest::Client::Configuration, config
  end
end
