# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/datastore/v1/datastore_pb"

module Google
  module Cloud
    module Datastore
      module V1
        module Datastore
          ##
          # Client for the Datastore service.
          #
          # Each RPC normalizes the partition IDs of the keys in its input entities,
          # and always returns entities with keys with normalized partition IDs.
          # This applies to all keys and entities, including those in values, except keys
          # with both an empty path and an empty or unset partition ID. Normalization of
          # input keys sets the project ID (if not already set) to the project ID from
          # the request.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "datastore.$UNIVERSE_DOMAIN$"

            # @private
            attr_reader :datastore_stub

            ##
            # Configure the Datastore Client class.
            #
            # See {::Google::Cloud::Datastore::V1::Datastore::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all Datastore clients
            #   ::Google::Cloud::Datastore::V1::Datastore::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Datastore", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.lookup.timeout = 60.0
                default_config.rpcs.lookup.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.run_query.timeout = 60.0
                default_config.rpcs.run_query.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.run_aggregation_query.timeout = 60.0
                default_config.rpcs.run_aggregation_query.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config.rpcs.begin_transaction.timeout = 60.0

                default_config.rpcs.commit.timeout = 60.0

                default_config.rpcs.rollback.timeout = 60.0

                default_config.rpcs.allocate_ids.timeout = 60.0

                default_config.rpcs.reserve_ids.timeout = 60.0
                default_config.rpcs.reserve_ids.retry_policy = {
                  initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the Datastore Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Datastore::V1::Datastore::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @datastore_stub.universe_domain
            end

            ##
            # Create a new Datastore client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Datastore::V1::Datastore::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Datastore::V1::Datastore::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Datastore client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/datastore/v1/datastore_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @datastore_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Datastore::V1::Datastore::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @datastore_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end
            end

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @datastore_stub.logger
            end

            # Service calls

            ##
            # Looks up entities by key.
            #
            # @overload lookup(request, options = nil)
            #   Pass arguments to `lookup` via a request object, either of type
            #   {::Google::Cloud::Datastore::V1::LookupRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Datastore::V1::LookupRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload lookup(project_id: nil, database_id: nil, read_options: nil, keys: nil, property_mask: nil)
            #   Pass arguments to `lookup` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Required. The ID of the project against which to make the request.
            #   @param database_id [::String]
            #     The ID of the database against which to make the request.
            #
            #     '(default)' is not allowed; please use empty string '' to refer the default
            #     database.
            #   @param read_options [::Google::Cloud::Datastore::V1::ReadOptions, ::Hash]
            #     The options for this lookup request.
            #   @param keys [::Array<::Google::Cloud::Datastore::V1::Key, ::Hash>]
            #     Required. Keys of entities to look up.
            #   @param property_mask [::Google::Cloud::Datastore::V1::PropertyMask, ::Hash]
            #     The properties to return. Defaults to returning all properties.
            #
            #     If this field is set and an entity has a property not referenced in the
            #     mask, it will be absent from [LookupResponse.found.entity.properties][].
            #
            #     The entity's key is always returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Datastore::V1::LookupResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Datastore::V1::LookupResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/datastore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Datastore::V1::Datastore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Datastore::V1::LookupRequest.new
            #
            #   # Call the lookup method.
            #   result = client.lookup request
            #
            #   # The returned object is of type Google::Cloud::Datastore::V1::LookupResponse.
            #   p result
            #
            def lookup request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastore::V1::LookupRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.lookup.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Datastore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.project_id && !request.project_id.empty?
                header_params["project_id"] = request.project_id
              end
              if request.database_id && !request.database_id.empty?
                header_params["database_id"] = request.database_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.lookup.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.lookup.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @datastore_stub.call_rpc :lookup, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Queries for entities.
            #
            # @overload run_query(request, options = nil)
            #   Pass arguments to `run_query` via a request object, either of type
            #   {::Google::Cloud::Datastore::V1::RunQueryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Datastore::V1::RunQueryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload run_query(project_id: nil, database_id: nil, partition_id: nil, read_options: nil, query: nil, gql_query: nil, property_mask: nil, explain_options: nil)
            #   Pass arguments to `run_query` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Required. The ID of the project against which to make the request.
            #   @param database_id [::String]
            #     The ID of the database against which to make the request.
            #
            #     '(default)' is not allowed; please use empty string '' to refer the default
            #     database.
            #   @param partition_id [::Google::Cloud::Datastore::V1::PartitionId, ::Hash]
            #     Entities are partitioned into subsets, identified by a partition ID.
            #     Queries are scoped to a single partition.
            #     This partition ID is normalized with the standard default context
            #     partition ID.
            #   @param read_options [::Google::Cloud::Datastore::V1::ReadOptions, ::Hash]
            #     The options for this query.
            #   @param query [::Google::Cloud::Datastore::V1::Query, ::Hash]
            #     The query to run.
            #
            #     Note: The following parameters are mutually exclusive: `query`, `gql_query`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param gql_query [::Google::Cloud::Datastore::V1::GqlQuery, ::Hash]
            #     The GQL query to run. This query must be a non-aggregation query.
            #
            #     Note: The following parameters are mutually exclusive: `gql_query`, `query`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param property_mask [::Google::Cloud::Datastore::V1::PropertyMask, ::Hash]
            #     The properties to return.
            #     This field must not be set for a projection query.
            #
            #     See
            #     {::Google::Cloud::Datastore::V1::LookupRequest#property_mask LookupRequest.property_mask}.
            #   @param explain_options [::Google::Cloud::Datastore::V1::ExplainOptions, ::Hash]
            #     Optional. Explain options for the query. If set, additional query
            #     statistics will be returned. If not, only query results will be returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Datastore::V1::RunQueryResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Datastore::V1::RunQueryResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/datastore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Datastore::V1::Datastore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Datastore::V1::RunQueryRequest.new
            #
            #   # Call the run_query method.
            #   result = client.run_query request
            #
            #   # The returned object is of type Google::Cloud::Datastore::V1::RunQueryResponse.
            #   p result
            #
            def run_query request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastore::V1::RunQueryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.run_query.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Datastore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.project_id && !request.project_id.empty?
                header_params["project_id"] = request.project_id
              end
              if request.database_id && !request.database_id.empty?
                header_params["database_id"] = request.database_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.run_query.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.run_query.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @datastore_stub.call_rpc :run_query, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Runs an aggregation query.
            #
            # @overload run_aggregation_query(request, options = nil)
            #   Pass arguments to `run_aggregation_query` via a request object, either of type
            #   {::Google::Cloud::Datastore::V1::RunAggregationQueryRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Datastore::V1::RunAggregationQueryRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload run_aggregation_query(project_id: nil, database_id: nil, partition_id: nil, read_options: nil, aggregation_query: nil, gql_query: nil, explain_options: nil)
            #   Pass arguments to `run_aggregation_query` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Required. The ID of the project against which to make the request.
            #   @param database_id [::String]
            #     The ID of the database against which to make the request.
            #
            #     '(default)' is not allowed; please use empty string '' to refer the default
            #     database.
            #   @param partition_id [::Google::Cloud::Datastore::V1::PartitionId, ::Hash]
            #     Entities are partitioned into subsets, identified by a partition ID.
            #     Queries are scoped to a single partition.
            #     This partition ID is normalized with the standard default context
            #     partition ID.
            #   @param read_options [::Google::Cloud::Datastore::V1::ReadOptions, ::Hash]
            #     The options for this query.
            #   @param aggregation_query [::Google::Cloud::Datastore::V1::AggregationQuery, ::Hash]
            #     The query to run.
            #
            #     Note: The following parameters are mutually exclusive: `aggregation_query`, `gql_query`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param gql_query [::Google::Cloud::Datastore::V1::GqlQuery, ::Hash]
            #     The GQL query to run. This query must be an aggregation query.
            #
            #     Note: The following parameters are mutually exclusive: `gql_query`, `aggregation_query`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param explain_options [::Google::Cloud::Datastore::V1::ExplainOptions, ::Hash]
            #     Optional. Explain options for the query. If set, additional query
            #     statistics will be returned. If not, only query results will be returned.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Datastore::V1::RunAggregationQueryResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Datastore::V1::RunAggregationQueryResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/datastore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Datastore::V1::Datastore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Datastore::V1::RunAggregationQueryRequest.new
            #
            #   # Call the run_aggregation_query method.
            #   result = client.run_aggregation_query request
            #
            #   # The returned object is of type Google::Cloud::Datastore::V1::RunAggregationQueryResponse.
            #   p result
            #
            def run_aggregation_query request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastore::V1::RunAggregationQueryRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.run_aggregation_query.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Datastore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.project_id && !request.project_id.empty?
                header_params["project_id"] = request.project_id
              end
              if request.database_id && !request.database_id.empty?
                header_params["database_id"] = request.database_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.run_aggregation_query.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.run_aggregation_query.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @datastore_stub.call_rpc :run_aggregation_query, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Begins a new transaction.
            #
            # @overload begin_transaction(request, options = nil)
            #   Pass arguments to `begin_transaction` via a request object, either of type
            #   {::Google::Cloud::Datastore::V1::BeginTransactionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Datastore::V1::BeginTransactionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload begin_transaction(project_id: nil, database_id: nil, transaction_options: nil)
            #   Pass arguments to `begin_transaction` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Required. The ID of the project against which to make the request.
            #   @param database_id [::String]
            #     The ID of the database against which to make the request.
            #
            #     '(default)' is not allowed; please use empty string '' to refer the default
            #     database.
            #   @param transaction_options [::Google::Cloud::Datastore::V1::TransactionOptions, ::Hash]
            #     Options for a new transaction.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Datastore::V1::BeginTransactionResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Datastore::V1::BeginTransactionResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/datastore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Datastore::V1::Datastore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Datastore::V1::BeginTransactionRequest.new
            #
            #   # Call the begin_transaction method.
            #   result = client.begin_transaction request
            #
            #   # The returned object is of type Google::Cloud::Datastore::V1::BeginTransactionResponse.
            #   p result
            #
            def begin_transaction request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastore::V1::BeginTransactionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.begin_transaction.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Datastore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.project_id && !request.project_id.empty?
                header_params["project_id"] = request.project_id
              end
              if request.database_id && !request.database_id.empty?
                header_params["database_id"] = request.database_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.begin_transaction.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.begin_transaction.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @datastore_stub.call_rpc :begin_transaction, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Commits a transaction, optionally creating, deleting or modifying some
            # entities.
            #
            # @overload commit(request, options = nil)
            #   Pass arguments to `commit` via a request object, either of type
            #   {::Google::Cloud::Datastore::V1::CommitRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Datastore::V1::CommitRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload commit(project_id: nil, database_id: nil, mode: nil, transaction: nil, single_use_transaction: nil, mutations: nil)
            #   Pass arguments to `commit` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Required. The ID of the project against which to make the request.
            #   @param database_id [::String]
            #     The ID of the database against which to make the request.
            #
            #     '(default)' is not allowed; please use empty string '' to refer the default
            #     database.
            #   @param mode [::Google::Cloud::Datastore::V1::CommitRequest::Mode]
            #     The type of commit to perform. Defaults to `TRANSACTIONAL`.
            #   @param transaction [::String]
            #     The identifier of the transaction associated with the commit. A
            #     transaction identifier is returned by a call to
            #     {::Google::Cloud::Datastore::V1::Datastore::Client#begin_transaction Datastore.BeginTransaction}.
            #
            #     Note: The following parameters are mutually exclusive: `transaction`, `single_use_transaction`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param single_use_transaction [::Google::Cloud::Datastore::V1::TransactionOptions, ::Hash]
            #     Options for beginning a new transaction for this request.
            #     The transaction is committed when the request completes. If specified,
            #     {::Google::Cloud::Datastore::V1::TransactionOptions TransactionOptions.mode} must be
            #     {::Google::Cloud::Datastore::V1::TransactionOptions::ReadWrite TransactionOptions.ReadWrite}.
            #
            #     Note: The following parameters are mutually exclusive: `single_use_transaction`, `transaction`. At most one of these parameters can be set. If more than one is set, only one will be used, and it is not defined which one.
            #   @param mutations [::Array<::Google::Cloud::Datastore::V1::Mutation, ::Hash>]
            #     The mutations to perform.
            #
            #     When mode is `TRANSACTIONAL`, mutations affecting a single entity are
            #     applied in order. The following sequences of mutations affecting a single
            #     entity are not permitted in a single `Commit` request:
            #
            #     - `insert` followed by `insert`
            #     - `update` followed by `insert`
            #     - `upsert` followed by `insert`
            #     - `delete` followed by `update`
            #
            #     When mode is `NON_TRANSACTIONAL`, no two mutations may affect a single
            #     entity.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Datastore::V1::CommitResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Datastore::V1::CommitResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/datastore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Datastore::V1::Datastore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Datastore::V1::CommitRequest.new
            #
            #   # Call the commit method.
            #   result = client.commit request
            #
            #   # The returned object is of type Google::Cloud::Datastore::V1::CommitResponse.
            #   p result
            #
            def commit request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastore::V1::CommitRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.commit.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Datastore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.project_id && !request.project_id.empty?
                header_params["project_id"] = request.project_id
              end
              if request.database_id && !request.database_id.empty?
                header_params["database_id"] = request.database_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.commit.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.commit.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @datastore_stub.call_rpc :commit, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Rolls back a transaction.
            #
            # @overload rollback(request, options = nil)
            #   Pass arguments to `rollback` via a request object, either of type
            #   {::Google::Cloud::Datastore::V1::RollbackRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Datastore::V1::RollbackRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload rollback(project_id: nil, database_id: nil, transaction: nil)
            #   Pass arguments to `rollback` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Required. The ID of the project against which to make the request.
            #   @param database_id [::String]
            #     The ID of the database against which to make the request.
            #
            #     '(default)' is not allowed; please use empty string '' to refer the default
            #     database.
            #   @param transaction [::String]
            #     Required. The transaction identifier, returned by a call to
            #     {::Google::Cloud::Datastore::V1::Datastore::Client#begin_transaction Datastore.BeginTransaction}.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Datastore::V1::RollbackResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Datastore::V1::RollbackResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/datastore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Datastore::V1::Datastore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Datastore::V1::RollbackRequest.new
            #
            #   # Call the rollback method.
            #   result = client.rollback request
            #
            #   # The returned object is of type Google::Cloud::Datastore::V1::RollbackResponse.
            #   p result
            #
            def rollback request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastore::V1::RollbackRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.rollback.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Datastore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.project_id && !request.project_id.empty?
                header_params["project_id"] = request.project_id
              end
              if request.database_id && !request.database_id.empty?
                header_params["database_id"] = request.database_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.rollback.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.rollback.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @datastore_stub.call_rpc :rollback, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Allocates IDs for the given keys, which is useful for referencing an entity
            # before it is inserted.
            #
            # @overload allocate_ids(request, options = nil)
            #   Pass arguments to `allocate_ids` via a request object, either of type
            #   {::Google::Cloud::Datastore::V1::AllocateIdsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Datastore::V1::AllocateIdsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload allocate_ids(project_id: nil, database_id: nil, keys: nil)
            #   Pass arguments to `allocate_ids` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Required. The ID of the project against which to make the request.
            #   @param database_id [::String]
            #     The ID of the database against which to make the request.
            #
            #     '(default)' is not allowed; please use empty string '' to refer the default
            #     database.
            #   @param keys [::Array<::Google::Cloud::Datastore::V1::Key, ::Hash>]
            #     Required. A list of keys with incomplete key paths for which to allocate
            #     IDs. No key may be reserved/read-only.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Datastore::V1::AllocateIdsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Datastore::V1::AllocateIdsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/datastore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Datastore::V1::Datastore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Datastore::V1::AllocateIdsRequest.new
            #
            #   # Call the allocate_ids method.
            #   result = client.allocate_ids request
            #
            #   # The returned object is of type Google::Cloud::Datastore::V1::AllocateIdsResponse.
            #   p result
            #
            def allocate_ids request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastore::V1::AllocateIdsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.allocate_ids.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Datastore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.project_id && !request.project_id.empty?
                header_params["project_id"] = request.project_id
              end
              if request.database_id && !request.database_id.empty?
                header_params["database_id"] = request.database_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.allocate_ids.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.allocate_ids.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @datastore_stub.call_rpc :allocate_ids, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Prevents the supplied keys' IDs from being auto-allocated by Cloud
            # Datastore.
            #
            # @overload reserve_ids(request, options = nil)
            #   Pass arguments to `reserve_ids` via a request object, either of type
            #   {::Google::Cloud::Datastore::V1::ReserveIdsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Datastore::V1::ReserveIdsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload reserve_ids(project_id: nil, database_id: nil, keys: nil)
            #   Pass arguments to `reserve_ids` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param project_id [::String]
            #     Required. The ID of the project against which to make the request.
            #   @param database_id [::String]
            #     The ID of the database against which to make the request.
            #
            #     '(default)' is not allowed; please use empty string '' to refer the default
            #     database.
            #   @param keys [::Array<::Google::Cloud::Datastore::V1::Key, ::Hash>]
            #     Required. A list of keys with complete key paths whose numeric IDs should
            #     not be auto-allocated.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Datastore::V1::ReserveIdsResponse]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Datastore::V1::ReserveIdsResponse]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/datastore/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Datastore::V1::Datastore::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Datastore::V1::ReserveIdsRequest.new
            #
            #   # Call the reserve_ids method.
            #   result = client.reserve_ids request
            #
            #   # The returned object is of type Google::Cloud::Datastore::V1::ReserveIdsResponse.
            #   p result
            #
            def reserve_ids request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastore::V1::ReserveIdsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.reserve_ids.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Datastore::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.project_id && !request.project_id.empty?
                header_params["project_id"] = request.project_id
              end
              if request.database_id && !request.database_id.empty?
                header_params["database_id"] = request.database_id
              end

              request_params_header = URI.encode_www_form header_params
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.reserve_ids.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.reserve_ids.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @datastore_stub.call_rpc :reserve_ids, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the Datastore API.
            #
            # This class represents the configuration for Datastore,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Datastore::V1::Datastore::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # lookup to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Datastore::V1::Datastore::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.lookup.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Datastore::V1::Datastore::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.lookup.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Datastore::V1::Datastore::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "datastore.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the Datastore API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `lookup`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :lookup
                ##
                # RPC-specific configuration for `run_query`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :run_query
                ##
                # RPC-specific configuration for `run_aggregation_query`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :run_aggregation_query
                ##
                # RPC-specific configuration for `begin_transaction`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :begin_transaction
                ##
                # RPC-specific configuration for `commit`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :commit
                ##
                # RPC-specific configuration for `rollback`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :rollback
                ##
                # RPC-specific configuration for `allocate_ids`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :allocate_ids
                ##
                # RPC-specific configuration for `reserve_ids`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :reserve_ids

                # @private
                def initialize parent_rpcs = nil
                  lookup_config = parent_rpcs.lookup if parent_rpcs.respond_to? :lookup
                  @lookup = ::Gapic::Config::Method.new lookup_config
                  run_query_config = parent_rpcs.run_query if parent_rpcs.respond_to? :run_query
                  @run_query = ::Gapic::Config::Method.new run_query_config
                  run_aggregation_query_config = parent_rpcs.run_aggregation_query if parent_rpcs.respond_to? :run_aggregation_query
                  @run_aggregation_query = ::Gapic::Config::Method.new run_aggregation_query_config
                  begin_transaction_config = parent_rpcs.begin_transaction if parent_rpcs.respond_to? :begin_transaction
                  @begin_transaction = ::Gapic::Config::Method.new begin_transaction_config
                  commit_config = parent_rpcs.commit if parent_rpcs.respond_to? :commit
                  @commit = ::Gapic::Config::Method.new commit_config
                  rollback_config = parent_rpcs.rollback if parent_rpcs.respond_to? :rollback
                  @rollback = ::Gapic::Config::Method.new rollback_config
                  allocate_ids_config = parent_rpcs.allocate_ids if parent_rpcs.respond_to? :allocate_ids
                  @allocate_ids = ::Gapic::Config::Method.new allocate_ids_config
                  reserve_ids_config = parent_rpcs.reserve_ids if parent_rpcs.respond_to? :reserve_ids
                  @reserve_ids = ::Gapic::Config::Method.new reserve_ids_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
