# frozen_string_literal: true

# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/datastore/v1/version"

require "google/cloud/datastore/v1/datastore/credentials"
require "google/cloud/datastore/v1/datastore/client"
require "google/cloud/datastore/v1/datastore/rest"

module Google
  module Cloud
    module Datastore
      module V1
        ##
        # Each RPC normalizes the partition IDs of the keys in its input entities,
        # and always returns entities with keys with normalized partition IDs.
        # This applies to all keys and entities, including those in values, except keys
        # with both an empty path and an empty or unset partition ID. Normalization of
        # input keys sets the project ID (if not already set) to the project ID from
        # the request.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/datastore/v1/datastore"
        #     client = ::Google::Cloud::Datastore::V1::Datastore::Client.new
        #
        # @example Load this service and instantiate a REST client
        #
        #     require "google/cloud/datastore/v1/datastore/rest"
        #     client = ::Google::Cloud::Datastore::V1::Datastore::Rest::Client.new
        #
        module Datastore
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "datastore", "helpers.rb"
require "google/cloud/datastore/v1/datastore/helpers" if ::File.file? helper_path
