# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/datastore/admin/v1/datastore_admin_pb"
require "google/cloud/datastore/admin/v1/datastore_admin/rest/service_stub"

module Google
  module Cloud
    module Datastore
      module Admin
        module V1
          module DatastoreAdmin
            module Rest
              ##
              # REST client for the DatastoreAdmin service.
              #
              # Google Cloud Datastore Admin API
              #
              # The Datastore Admin API provides several admin services for Cloud Datastore.
              #
              # Concepts: Project, namespace, kind, and entity as defined in the Google Cloud
              # Datastore API.
              #
              # Operation: An Operation represents work being performed in the background.
              #
              # EntityFilter: Allows specifying a subset of entities in a project. This is
              # specified as a combination of kinds and namespaces (either or both of which
              # may be all).
              #
              # Export/Import Service:
              #
              # - The Export/Import service provides the ability to copy all or a subset of
              # entities to/from Google Cloud Storage.
              # - Exported data may be imported into Cloud Datastore for any Google Cloud
              # Platform project. It is not restricted to the export source project. It is
              # possible to export from one project and then import into another.
              # - Exported data can also be loaded into Google BigQuery for analysis.
              # - Exports and imports are performed asynchronously. An Operation resource is
              # created for each export/import. The state (including any errors encountered)
              # of the export/import may be queried via the Operation resource.
              #
              # Index Service:
              #
              # - The index service manages Cloud Datastore composite indexes.
              # - Index creation and deletion are performed asynchronously.
              # An Operation resource is created for each such asynchronous operation.
              # The state of the operation (including any errors encountered)
              # may be queried via the Operation resource.
              #
              # Operation Service:
              #
              # - The Operations collection provides a record of actions performed for the
              # specified project (including any operations in progress). Operations are not
              # created directly but through calls on other collections or resources.
              # - An operation that is not yet done may be cancelled. The request to cancel
              # is asynchronous and the operation may continue to run for some time after the
              # request to cancel is made.
              # - An operation that is done may be deleted so that it is no longer listed as
              # part of the Operation collection.
              # - ListOperations returns all pending operations, but not completed
              # operations.
              # - Operations are created by service DatastoreAdmin, but are accessed via
              # service google.longrunning.Operations.
              #
              class Client
                # @private
                API_VERSION = ""

                # @private
                DEFAULT_ENDPOINT_TEMPLATE = "datastore.$UNIVERSE_DOMAIN$"

                # @private
                attr_reader :datastore_admin_stub

                ##
                # Configure the DatastoreAdmin Client class.
                #
                # See {::Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @example
                #
                #   # Modify the configuration for all DatastoreAdmin clients
                #   ::Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def self.configure
                  @configure ||= begin
                    namespace = ["Google", "Cloud", "Datastore", "Admin", "V1"]
                    parent_config = while namespace.any?
                                      parent_name = namespace.join "::"
                                      parent_const = const_get parent_name
                                      break parent_const.configure if parent_const.respond_to? :configure
                                      namespace.pop
                                    end
                    default_config = Client::Configuration.new parent_config

                    default_config.rpcs.export_entities.timeout = 60.0

                    default_config.rpcs.import_entities.timeout = 60.0

                    default_config.rpcs.create_index.timeout = 60.0

                    default_config.rpcs.delete_index.timeout = 60.0

                    default_config.rpcs.get_index.timeout = 60.0
                    default_config.rpcs.get_index.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                    }

                    default_config.rpcs.list_indexes.timeout = 60.0
                    default_config.rpcs.list_indexes.retry_policy = {
                      initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14, 4]
                    }

                    default_config
                  end
                  yield @configure if block_given?
                  @configure
                end

                ##
                # Configure the DatastoreAdmin Client instance.
                #
                # The configuration is set to the derived mode, meaning that values can be changed,
                # but structural changes (adding new fields, etc.) are not allowed. Structural changes
                # should be made on {Client.configure}.
                #
                # See {::Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client::Configuration}
                # for a description of the configuration fields.
                #
                # @yield [config] Configure the Client client.
                # @yieldparam config [Client::Configuration]
                #
                # @return [Client::Configuration]
                #
                def configure
                  yield @config if block_given?
                  @config
                end

                ##
                # The effective universe domain
                #
                # @return [String]
                #
                def universe_domain
                  @datastore_admin_stub.universe_domain
                end

                ##
                # Create a new DatastoreAdmin REST client object.
                #
                # @example
                #
                #   # Create a client using the default configuration
                #   client = ::Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client.new
                #
                #   # Create a client using a custom configuration
                #   client = ::Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #   end
                #
                # @yield [config] Configure the DatastoreAdmin client.
                # @yieldparam config [Client::Configuration]
                #
                def initialize
                  # Create the configuration object
                  @config = Configuration.new Client.configure

                  # Yield the configuration if needed
                  yield @config if block_given?

                  # Create credentials
                  credentials = @config.credentials
                  # Use self-signed JWT if the endpoint is unchanged from default,
                  # but only if the default endpoint does not have a region prefix.
                  enable_self_signed_jwt = @config.endpoint.nil? ||
                                           (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                           !@config.endpoint.split(".").first.include?("-"))
                  credentials ||= Credentials.default scope: @config.scope,
                                                      enable_self_signed_jwt: enable_self_signed_jwt
                  if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                    credentials = Credentials.new credentials, scope: @config.scope
                  end

                  @quota_project_id = @config.quota_project
                  @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                  @operations_client = ::Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Operations.new do |config|
                    config.credentials = credentials
                    config.quota_project = @quota_project_id
                    config.endpoint = @config.endpoint
                    config.universe_domain = @config.universe_domain
                  end

                  @datastore_admin_stub = ::Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::ServiceStub.new(
                    endpoint: @config.endpoint,
                    endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                    universe_domain: @config.universe_domain,
                    credentials: credentials,
                    logger: @config.logger
                  )

                  @datastore_admin_stub.logger(stub: true)&.info do |entry|
                    entry.set_system_name
                    entry.set_service
                    entry.message = "Created client for #{entry.service}"
                    entry.set_credentials_fields credentials
                    entry.set "customEndpoint", @config.endpoint if @config.endpoint
                    entry.set "defaultTimeout", @config.timeout if @config.timeout
                    entry.set "quotaProject", @quota_project_id if @quota_project_id
                  end
                end

                ##
                # Get the associated client for long-running operations.
                #
                # @return [::Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Operations]
                #
                attr_reader :operations_client

                ##
                # The logger used for request/response debug logging.
                #
                # @return [Logger]
                #
                def logger
                  @datastore_admin_stub.logger
                end

                # Service calls

                ##
                # Exports a copy of all or a subset of entities from Google Cloud Datastore
                # to another storage system, such as Google Cloud Storage. Recent updates to
                # entities may not be reflected in the export. The export occurs in the
                # background and its progress can be monitored and managed via the
                # Operation resource that is created. The output of an export may only be
                # used once the associated operation is done. If an export operation is
                # cancelled before completion it may leave partial data behind in Google
                # Cloud Storage.
                #
                # @overload export_entities(request, options = nil)
                #   Pass arguments to `export_entities` via a request object, either of type
                #   {::Google::Cloud::Datastore::Admin::V1::ExportEntitiesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Datastore::Admin::V1::ExportEntitiesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload export_entities(project_id: nil, labels: nil, entity_filter: nil, output_url_prefix: nil)
                #   Pass arguments to `export_entities` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param project_id [::String]
                #     Required. Project ID against which to make the request.
                #   @param labels [::Hash{::String => ::String}]
                #     Client-assigned labels.
                #   @param entity_filter [::Google::Cloud::Datastore::Admin::V1::EntityFilter, ::Hash]
                #     Description of what data from the project is included in the export.
                #   @param output_url_prefix [::String]
                #     Required. Location for the export metadata and data files.
                #
                #     The full resource URL of the external storage location. Currently, only
                #     Google Cloud Storage is supported. So output_url_prefix should be of the
                #     form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the
                #     name of the Cloud Storage bucket and `NAMESPACE_PATH` is an optional Cloud
                #     Storage namespace path (this is not a Cloud Datastore namespace). For more
                #     information about Cloud Storage namespace paths, see
                #     [Object name
                #     considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
                #
                #     The resulting files will be nested deeper than the specified URL prefix.
                #     The final output URL will be provided in the
                #     {::Google::Cloud::Datastore::Admin::V1::ExportEntitiesResponse#output_url google.datastore.admin.v1.ExportEntitiesResponse.output_url}
                #     field. That value should be used for subsequent ImportEntities operations.
                #
                #     By nesting the data files deeper, the same Cloud Storage bucket can be used
                #     in multiple ExportEntities operations without conflict.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/datastore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Datastore::Admin::V1::ExportEntitiesRequest.new
                #
                #   # Call the export_entities method.
                #   result = client.export_entities request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def export_entities request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastore::Admin::V1::ExportEntitiesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.export_entities.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Datastore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.export_entities.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.export_entities.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @datastore_admin_stub.export_entities request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Imports entities into Google Cloud Datastore. Existing entities with the
                # same key are overwritten. The import occurs in the background and its
                # progress can be monitored and managed via the Operation resource that is
                # created. If an ImportEntities operation is cancelled, it is possible
                # that a subset of the data has already been imported to Cloud Datastore.
                #
                # @overload import_entities(request, options = nil)
                #   Pass arguments to `import_entities` via a request object, either of type
                #   {::Google::Cloud::Datastore::Admin::V1::ImportEntitiesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Datastore::Admin::V1::ImportEntitiesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload import_entities(project_id: nil, labels: nil, input_url: nil, entity_filter: nil)
                #   Pass arguments to `import_entities` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param project_id [::String]
                #     Required. Project ID against which to make the request.
                #   @param labels [::Hash{::String => ::String}]
                #     Client-assigned labels.
                #   @param input_url [::String]
                #     Required. The full resource URL of the external storage location.
                #     Currently, only Google Cloud Storage is supported. So input_url should be
                #     of the form:
                #     `gs://BUCKET_NAME[/NAMESPACE_PATH]/OVERALL_EXPORT_METADATA_FILE`, where
                #     `BUCKET_NAME` is the name of the Cloud Storage bucket, `NAMESPACE_PATH` is
                #     an optional Cloud Storage namespace path (this is not a Cloud Datastore
                #     namespace), and `OVERALL_EXPORT_METADATA_FILE` is the metadata file written
                #     by the ExportEntities operation. For more information about Cloud Storage
                #     namespace paths, see
                #     [Object name
                #     considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
                #
                #     For more information, see
                #     {::Google::Cloud::Datastore::Admin::V1::ExportEntitiesResponse#output_url google.datastore.admin.v1.ExportEntitiesResponse.output_url}.
                #   @param entity_filter [::Google::Cloud::Datastore::Admin::V1::EntityFilter, ::Hash]
                #     Optionally specify which kinds/namespaces are to be imported. If provided,
                #     the list must be a subset of the EntityFilter used in creating the export,
                #     otherwise a FAILED_PRECONDITION error will be returned. If no filter is
                #     specified then all entities from the export are imported.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/datastore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Datastore::Admin::V1::ImportEntitiesRequest.new
                #
                #   # Call the import_entities method.
                #   result = client.import_entities request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def import_entities request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastore::Admin::V1::ImportEntitiesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.import_entities.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Datastore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.import_entities.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.import_entities.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @datastore_admin_stub.import_entities request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Creates the specified index.
                # A newly created index's initial state is `CREATING`. On completion of the
                # returned {::Google::Longrunning::Operation google.longrunning.Operation}, the
                # state will be `READY`. If the index already exists, the call will return an
                # `ALREADY_EXISTS` status.
                #
                # During index creation, the process could result in an error, in which
                # case the index will move to the `ERROR` state. The process can be recovered
                # by fixing the data that caused the error, removing the index with
                # {::Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client#delete_index delete}, then
                # re-creating the index with [create]
                # [google.datastore.admin.v1.DatastoreAdmin.CreateIndex].
                #
                # Indexes with a single property cannot be created.
                #
                # @overload create_index(request, options = nil)
                #   Pass arguments to `create_index` via a request object, either of type
                #   {::Google::Cloud::Datastore::Admin::V1::CreateIndexRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Datastore::Admin::V1::CreateIndexRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload create_index(project_id: nil, index: nil)
                #   Pass arguments to `create_index` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param project_id [::String]
                #     Project ID against which to make the request.
                #   @param index [::Google::Cloud::Datastore::Admin::V1::Index, ::Hash]
                #     The index to create. The name and state fields are output only and will be
                #     ignored. Single property indexes cannot be created or deleted.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/datastore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Datastore::Admin::V1::CreateIndexRequest.new
                #
                #   # Call the create_index method.
                #   result = client.create_index request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def create_index request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastore::Admin::V1::CreateIndexRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.create_index.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Datastore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.create_index.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.create_index.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @datastore_admin_stub.create_index request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Deletes an existing index.
                # An index can only be deleted if it is in a `READY` or `ERROR` state. On
                # successful execution of the request, the index will be in a `DELETING`
                # {::Google::Cloud::Datastore::Admin::V1::Index::State state}. And on completion of the
                # returned {::Google::Longrunning::Operation google.longrunning.Operation}, the
                # index will be removed.
                #
                # During index deletion, the process could result in an error, in which
                # case the index will move to the `ERROR` state. The process can be recovered
                # by fixing the data that caused the error, followed by calling
                # {::Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client#delete_index delete} again.
                #
                # @overload delete_index(request, options = nil)
                #   Pass arguments to `delete_index` via a request object, either of type
                #   {::Google::Cloud::Datastore::Admin::V1::DeleteIndexRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Datastore::Admin::V1::DeleteIndexRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload delete_index(project_id: nil, index_id: nil)
                #   Pass arguments to `delete_index` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param project_id [::String]
                #     Project ID against which to make the request.
                #   @param index_id [::String]
                #     The resource ID of the index to delete.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Operation]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Operation]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/datastore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Datastore::Admin::V1::DeleteIndexRequest.new
                #
                #   # Call the delete_index method.
                #   result = client.delete_index request
                #
                #   # The returned object is of type Gapic::Operation. You can use it to
                #   # check the status of an operation, cancel it, or wait for results.
                #   # Here is how to wait for a response.
                #   result.wait_until_done! timeout: 60
                #   if result.response?
                #     p result.response
                #   else
                #     puts "No response received."
                #   end
                #
                def delete_index request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastore::Admin::V1::DeleteIndexRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.delete_index.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Datastore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.delete_index.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.delete_index.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @datastore_admin_stub.delete_index request, options do |result, operation|
                    result = ::Gapic::Operation.new result, @operations_client, options: options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Gets an index.
                #
                # @overload get_index(request, options = nil)
                #   Pass arguments to `get_index` via a request object, either of type
                #   {::Google::Cloud::Datastore::Admin::V1::GetIndexRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Datastore::Admin::V1::GetIndexRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload get_index(project_id: nil, index_id: nil)
                #   Pass arguments to `get_index` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param project_id [::String]
                #     Project ID against which to make the request.
                #   @param index_id [::String]
                #     The resource ID of the index to get.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Google::Cloud::Datastore::Admin::V1::Index]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Google::Cloud::Datastore::Admin::V1::Index]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/datastore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Datastore::Admin::V1::GetIndexRequest.new
                #
                #   # Call the get_index method.
                #   result = client.get_index request
                #
                #   # The returned object is of type Google::Cloud::Datastore::Admin::V1::Index.
                #   p result
                #
                def get_index request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastore::Admin::V1::GetIndexRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.get_index.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Datastore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.get_index.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.get_index.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @datastore_admin_stub.get_index request, options do |result, operation|
                    yield result, operation if block_given?
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Lists the indexes that match the specified filters.  Datastore uses an
                # eventually consistent query to fetch the list of indexes and may
                # occasionally return stale results.
                #
                # @overload list_indexes(request, options = nil)
                #   Pass arguments to `list_indexes` via a request object, either of type
                #   {::Google::Cloud::Datastore::Admin::V1::ListIndexesRequest} or an equivalent Hash.
                #
                #   @param request [::Google::Cloud::Datastore::Admin::V1::ListIndexesRequest, ::Hash]
                #     A request object representing the call parameters. Required. To specify no
                #     parameters, or to keep all the default parameter values, pass an empty Hash.
                #   @param options [::Gapic::CallOptions, ::Hash]
                #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
                #
                # @overload list_indexes(project_id: nil, filter: nil, page_size: nil, page_token: nil)
                #   Pass arguments to `list_indexes` via keyword arguments. Note that at
                #   least one keyword argument is required. To specify no parameters, or to keep all
                #   the default parameter values, pass an empty Hash as a request object (see above).
                #
                #   @param project_id [::String]
                #     Project ID against which to make the request.
                #   @param filter [::String]
                #   @param page_size [::Integer]
                #     The maximum number of items to return.  If zero, then all results will be
                #     returned.
                #   @param page_token [::String]
                #     The next_page_token value returned from a previous List request, if any.
                # @yield [result, operation] Access the result along with the TransportOperation object
                # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Datastore::Admin::V1::Index>]
                # @yieldparam operation [::Gapic::Rest::TransportOperation]
                #
                # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Datastore::Admin::V1::Index>]
                #
                # @raise [::Google::Cloud::Error] if the REST call is aborted.
                #
                # @example Basic example
                #   require "google/cloud/datastore/admin/v1"
                #
                #   # Create a client object. The client can be reused for multiple calls.
                #   client = Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client.new
                #
                #   # Create a request. To set request fields, pass in keyword arguments.
                #   request = Google::Cloud::Datastore::Admin::V1::ListIndexesRequest.new
                #
                #   # Call the list_indexes method.
                #   result = client.list_indexes request
                #
                #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
                #   # over elements, and API calls will be issued to fetch pages as needed.
                #   result.each do |item|
                #     # Each element is of type ::Google::Cloud::Datastore::Admin::V1::Index.
                #     p item
                #   end
                #
                def list_indexes request, options = nil
                  raise ::ArgumentError, "request must be provided" if request.nil?

                  request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Datastore::Admin::V1::ListIndexesRequest

                  # Converts hash and nil to an options object
                  options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                  # Customize the options with defaults
                  call_metadata = @config.rpcs.list_indexes.metadata.to_h

                  # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                  call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                    lib_name: @config.lib_name, lib_version: @config.lib_version,
                    gapic_version: ::Google::Cloud::Datastore::Admin::V1::VERSION,
                    transports_version_send: [:rest]

                  call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                  call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                  options.apply_defaults timeout:      @config.rpcs.list_indexes.timeout,
                                         metadata:     call_metadata,
                                         retry_policy: @config.rpcs.list_indexes.retry_policy

                  options.apply_defaults timeout:      @config.timeout,
                                         metadata:     @config.metadata,
                                         retry_policy: @config.retry_policy

                  @datastore_admin_stub.list_indexes request, options do |result, operation|
                    result = ::Gapic::Rest::PagedEnumerable.new @datastore_admin_stub, :list_indexes, "indexes", request, result, options
                    yield result, operation if block_given?
                    throw :response, result
                  end
                rescue ::Gapic::Rest::Error => e
                  raise ::Google::Cloud::Error.from_error(e)
                end

                ##
                # Configuration class for the DatastoreAdmin REST API.
                #
                # This class represents the configuration for DatastoreAdmin REST,
                # providing control over timeouts, retry behavior, logging, transport
                # parameters, and other low-level controls. Certain parameters can also be
                # applied individually to specific RPCs. See
                # {::Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client::Configuration::Rpcs}
                # for a list of RPCs that can be configured independently.
                #
                # Configuration can be applied globally to all clients, or to a single client
                # on construction.
                #
                # @example
                #
                #   # Modify the global config, setting the timeout for
                #   # export_entities to 20 seconds,
                #   # and all remaining timeouts to 10 seconds.
                #   ::Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client.configure do |config|
                #     config.timeout = 10.0
                #     config.rpcs.export_entities.timeout = 20.0
                #   end
                #
                #   # Apply the above configuration only to a new client.
                #   client = ::Google::Cloud::Datastore::Admin::V1::DatastoreAdmin::Rest::Client.new do |config|
                #     config.timeout = 10.0
                #     config.rpcs.export_entities.timeout = 20.0
                #   end
                #
                # @!attribute [rw] endpoint
                #   A custom service endpoint, as a hostname or hostname:port. The default is
                #   nil, indicating to use the default endpoint in the current universe domain.
                #   @return [::String,nil]
                # @!attribute [rw] credentials
                #   Credentials to send with calls. You may provide any of the following types:
                #    *  (`String`) The path to a service account key file in JSON format
                #    *  (`Hash`) A service account key as a Hash
                #    *  (`Google::Auth::Credentials`) A googleauth credentials object
                #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
                #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
                #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
                #    *  (`nil`) indicating no credentials
                #
                #   Warning: If you accept a credential configuration (JSON file or Hash) from an
                #   external source for authentication to Google Cloud, you must validate it before
                #   providing it to a Google API client library. Providing an unvalidated credential
                #   configuration to Google APIs can compromise the security of your systems and data.
                #   For more information, refer to [Validate credential configurations from external
                #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
                #   @return [::Object]
                # @!attribute [rw] scope
                #   The OAuth scopes
                #   @return [::Array<::String>]
                # @!attribute [rw] lib_name
                #   The library name as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] lib_version
                #   The library version as recorded in instrumentation and logging
                #   @return [::String]
                # @!attribute [rw] timeout
                #   The call timeout in seconds.
                #   @return [::Numeric]
                # @!attribute [rw] metadata
                #   Additional headers to be sent with the call.
                #   @return [::Hash{::Symbol=>::String}]
                # @!attribute [rw] retry_policy
                #   The retry policy. The value is a hash with the following keys:
                #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #       trigger a retry.
                #   @return [::Hash]
                # @!attribute [rw] quota_project
                #   A separate project against which to charge quota.
                #   @return [::String]
                # @!attribute [rw] universe_domain
                #   The universe domain within which to make requests. This determines the
                #   default endpoint URL. The default value of nil uses the environment
                #   universe (usually the default "googleapis.com" universe).
                #   @return [::String,nil]
                # @!attribute [rw] logger
                #   A custom logger to use for request/response debug logging, or the value
                #   `:default` (the default) to construct a default logger, or `nil` to
                #   explicitly disable logging.
                #   @return [::Logger,:default,nil]
                #
                class Configuration
                  extend ::Gapic::Config

                  # @private
                  # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                  DEFAULT_ENDPOINT = "datastore.googleapis.com"

                  config_attr :endpoint,      nil, ::String, nil
                  config_attr :credentials,   nil do |value|
                    allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                    allowed.any? { |klass| klass === value }
                  end
                  config_attr :scope,         nil, ::String, ::Array, nil
                  config_attr :lib_name,      nil, ::String, nil
                  config_attr :lib_version,   nil, ::String, nil
                  config_attr :timeout,       nil, ::Numeric, nil
                  config_attr :metadata,      nil, ::Hash, nil
                  config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                  config_attr :quota_project, nil, ::String, nil
                  config_attr :universe_domain, nil, ::String, nil
                  config_attr :logger, :default, ::Logger, nil, :default

                  # @private
                  def initialize parent_config = nil
                    @parent_config = parent_config unless parent_config.nil?

                    yield self if block_given?
                  end

                  ##
                  # Configurations for individual RPCs
                  # @return [Rpcs]
                  #
                  def rpcs
                    @rpcs ||= begin
                      parent_rpcs = nil
                      parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                      Rpcs.new parent_rpcs
                    end
                  end

                  ##
                  # Configuration RPC class for the DatastoreAdmin API.
                  #
                  # Includes fields providing the configuration for each RPC in this service.
                  # Each configuration object is of type `Gapic::Config::Method` and includes
                  # the following configuration fields:
                  #
                  #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                  #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                  #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                  #     include the following keys:
                  #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                  #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                  #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                  #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                  #         trigger a retry.
                  #
                  class Rpcs
                    ##
                    # RPC-specific configuration for `export_entities`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :export_entities
                    ##
                    # RPC-specific configuration for `import_entities`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :import_entities
                    ##
                    # RPC-specific configuration for `create_index`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :create_index
                    ##
                    # RPC-specific configuration for `delete_index`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :delete_index
                    ##
                    # RPC-specific configuration for `get_index`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :get_index
                    ##
                    # RPC-specific configuration for `list_indexes`
                    # @return [::Gapic::Config::Method]
                    #
                    attr_reader :list_indexes

                    # @private
                    def initialize parent_rpcs = nil
                      export_entities_config = parent_rpcs.export_entities if parent_rpcs.respond_to? :export_entities
                      @export_entities = ::Gapic::Config::Method.new export_entities_config
                      import_entities_config = parent_rpcs.import_entities if parent_rpcs.respond_to? :import_entities
                      @import_entities = ::Gapic::Config::Method.new import_entities_config
                      create_index_config = parent_rpcs.create_index if parent_rpcs.respond_to? :create_index
                      @create_index = ::Gapic::Config::Method.new create_index_config
                      delete_index_config = parent_rpcs.delete_index if parent_rpcs.respond_to? :delete_index
                      @delete_index = ::Gapic::Config::Method.new delete_index_config
                      get_index_config = parent_rpcs.get_index if parent_rpcs.respond_to? :get_index
                      @get_index = ::Gapic::Config::Method.new get_index_config
                      list_indexes_config = parent_rpcs.list_indexes if parent_rpcs.respond_to? :list_indexes
                      @list_indexes = ::Gapic::Config::Method.new list_indexes_config

                      yield self if block_given?
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
