# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/dataqna/v1alpha/question_service_pb"
require "google/cloud/dataqna/v1alpha/question_service"

class ::Google::Cloud::DataQnA::V1alpha::QuestionService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_get_question
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataQnA::V1alpha::Question.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    read_mask = {}

    get_question_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_question, name
      assert_kind_of ::Google::Cloud::DataQnA::V1alpha::GetQuestionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["read_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_question_client_stub do
      # Create client
      client = ::Google::Cloud::DataQnA::V1alpha::QuestionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_question({ name: name, read_mask: read_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_question name: name, read_mask: read_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_question ::Google::Cloud::DataQnA::V1alpha::GetQuestionRequest.new(name: name, read_mask: read_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_question({ name: name, read_mask: read_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_question(::Google::Cloud::DataQnA::V1alpha::GetQuestionRequest.new(name: name, read_mask: read_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_question_client_stub.call_rpc_count
    end
  end

  def test_create_question
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataQnA::V1alpha::Question.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    question = {}

    create_question_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_question, name
      assert_kind_of ::Google::Cloud::DataQnA::V1alpha::CreateQuestionRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataQnA::V1alpha::Question), request["question"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_question_client_stub do
      # Create client
      client = ::Google::Cloud::DataQnA::V1alpha::QuestionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_question({ parent: parent, question: question }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_question parent: parent, question: question do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_question ::Google::Cloud::DataQnA::V1alpha::CreateQuestionRequest.new(parent: parent, question: question) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_question({ parent: parent, question: question }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_question(::Google::Cloud::DataQnA::V1alpha::CreateQuestionRequest.new(parent: parent, question: question), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_question_client_stub.call_rpc_count
    end
  end

  def test_execute_question
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataQnA::V1alpha::Question.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    interpretation_index = 42

    execute_question_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :execute_question, name
      assert_kind_of ::Google::Cloud::DataQnA::V1alpha::ExecuteQuestionRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["interpretation_index"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, execute_question_client_stub do
      # Create client
      client = ::Google::Cloud::DataQnA::V1alpha::QuestionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.execute_question({ name: name, interpretation_index: interpretation_index }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.execute_question name: name, interpretation_index: interpretation_index do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.execute_question ::Google::Cloud::DataQnA::V1alpha::ExecuteQuestionRequest.new(name: name, interpretation_index: interpretation_index) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.execute_question({ name: name, interpretation_index: interpretation_index }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.execute_question(::Google::Cloud::DataQnA::V1alpha::ExecuteQuestionRequest.new(name: name, interpretation_index: interpretation_index), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, execute_question_client_stub.call_rpc_count
    end
  end

  def test_get_user_feedback
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataQnA::V1alpha::UserFeedback.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_user_feedback_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_user_feedback, name
      assert_kind_of ::Google::Cloud::DataQnA::V1alpha::GetUserFeedbackRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_user_feedback_client_stub do
      # Create client
      client = ::Google::Cloud::DataQnA::V1alpha::QuestionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_user_feedback({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_user_feedback name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_user_feedback ::Google::Cloud::DataQnA::V1alpha::GetUserFeedbackRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_user_feedback({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_user_feedback(::Google::Cloud::DataQnA::V1alpha::GetUserFeedbackRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_user_feedback_client_stub.call_rpc_count
    end
  end

  def test_update_user_feedback
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::DataQnA::V1alpha::UserFeedback.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    user_feedback = {}
    update_mask = {}

    update_user_feedback_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_user_feedback, name
      assert_kind_of ::Google::Cloud::DataQnA::V1alpha::UpdateUserFeedbackRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::DataQnA::V1alpha::UserFeedback), request["user_feedback"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_user_feedback_client_stub do
      # Create client
      client = ::Google::Cloud::DataQnA::V1alpha::QuestionService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_user_feedback({ user_feedback: user_feedback, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_user_feedback user_feedback: user_feedback, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_user_feedback ::Google::Cloud::DataQnA::V1alpha::UpdateUserFeedbackRequest.new(user_feedback: user_feedback, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_user_feedback({ user_feedback: user_feedback, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_user_feedback(::Google::Cloud::DataQnA::V1alpha::UpdateUserFeedbackRequest.new(user_feedback: user_feedback, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_user_feedback_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DataQnA::V1alpha::QuestionService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::DataQnA::V1alpha::QuestionService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::DataQnA::V1alpha::QuestionService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::DataQnA::V1alpha::QuestionService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end
end
