# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module DataQnA
      module V1alpha
        # The question resource represents a natural language query, its settings,
        # understanding generated by the system, and answer retrieval status.
        # A question cannot be modified.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Immutable. The unique identifier for the Question. The ID is server-generated.
        #     Example: `projects/foo/locations/bar/questions/123`
        # @!attribute [rw] scopes
        #   @return [::Array<::String>]
        #     Required. Immutable. Scopes to be used for the question. A scope defines the relevant data set
        #     scope. It can be a reference to a specific data source or a collection of
        #     data sources. Currently, support is limited to a single BigQuery table.
        #     There must be exactly one `scopes` element.
        #
        #     Example:
        #     `//bigquery.googleapis.com/projects/test-project/datasets/foo/tables/bar`
        # @!attribute [rw] query
        #   @return [::String]
        #     Required. Immutable. The query in natural language.
        # @!attribute [rw] data_source_annotations
        #   @return [::Array<::String>]
        #     A list of annotations to use instead of the default annotation of a data
        #     source (set in the data source reference resource). There must not be
        #     more than one annotation with the same data source reference.
        # @!attribute [rw] interpret_error
        #   @return [::Google::Cloud::DataQnA::V1alpha::InterpretError]
        #     An error field explaining why interpretation failed. This is only populated
        #     if the interpretation failed.
        #
        #     Note: This is different from getting a status error on the request itself.
        #     This is not a client or server error and the Question resource is still
        #     persisted, but the service could not interpret the question. Clients should
        #     present the error to the user so the user can rephrase the question.
        # @!attribute [rw] interpretations
        #   @return [::Array<::Google::Cloud::DataQnA::V1alpha::Interpretation>]
        #     A list of interpretations for this question.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the question was created.
        # @!attribute [r] user_email
        #   @return [::String]
        #     Output only. The e-mail address of the user that created this question.
        # @!attribute [rw] debug_flags
        #   @return [::Google::Cloud::DataQnA::V1alpha::DebugFlags]
        #     Input only. Immutable. Flags to request additional information for debugging purposes.
        # @!attribute [rw] debug_info
        #   @return [::Google::Protobuf::Any]
        #     Top level debug information.
        #     This will be stored as the type DebugInformation.
        #     Using Any so clients don't need to pull in anything
        #     inside the debug message.
        class Question
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Details on the failure to interpret the question.
        # @!attribute [rw] message
        #   @return [::String]
        #     Error message explaining why this question could not be interpreted.
        # @!attribute [rw] code
        #   @return [::Google::Cloud::DataQnA::V1alpha::InterpretError::InterpretErrorCode]
        #     The code for the error category why the interpretation failed.
        # @!attribute [rw] details
        #   @return [::Google::Cloud::DataQnA::V1alpha::InterpretError::InterpretErrorDetails]
        #     Details on interpretation failure.
        class InterpretError
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Details on interpretation failure.
          # @!attribute [rw] unsupported_details
          #   @return [::Google::Cloud::DataQnA::V1alpha::InterpretError::InterpretUnsupportedDetails]
          #     Populated if parts of the query are unsupported.
          # @!attribute [rw] incomplete_query_details
          #   @return [::Google::Cloud::DataQnA::V1alpha::InterpretError::InterpretIncompleteQueryDetails]
          #     Populated if the query is incomplete.
          # @!attribute [rw] ambiguity_details
          #   @return [::Google::Cloud::DataQnA::V1alpha::InterpretError::InterpretAmbiguityDetails]
          #     Populated if the query was too ambiguous.
          class InterpretErrorDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details about unsupported parts in a query.
          # @!attribute [rw] operators
          #   @return [::Array<::String>]
          #     Unsupported operators. For example: median.
          # @!attribute [rw] intent
          #   @return [::Array<::String>]
          #     Unsupported intents.
          class InterpretUnsupportedDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details about an incomplete query.
          # @!attribute [rw] entities
          #   @return [::Array<::Google::Cloud::DataQnA::V1alpha::InterpretEntity>]
          #     List of missing interpret entities.
          class InterpretIncompleteQueryDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Details about a query that was too ambiguous. Currently, the message
          # has no fields and its presence signals that there was ambiguity.
          class InterpretAmbiguityDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The interpret error code provides an error category why the interpretation
          # failed.
          module InterpretErrorCode
            # No interpret error code was specified.
            INTERPRET_ERROR_CODE_UNSPECIFIED = 0

            # The query is not valid.
            INVALID_QUERY = 1

            # The interpreter failed to understand the question. For example, because
            # it was too ambiguous.
            FAILED_TO_UNDERSTAND = 2

            # The interpreter could understand the question, but was not able to arrive
            # at an answer. For example, because a requested operation is not
            # supported.
            FAILED_TO_ANSWER = 3
          end
        end

        # Information about the backend status (such as BigQuery) of the execution.
        # @!attribute [rw] job_creation_status
        #   @return [::Google::Rpc::Status]
        #     Status returned by the backend when the job was created.
        # @!attribute [rw] job_execution_state
        #   @return [::Google::Cloud::DataQnA::V1alpha::ExecutionInfo::JobExecutionState]
        #     Status of the job execution.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Time when the execution was triggered.
        # @!attribute [rw] bigquery_job
        #   @return [::Google::Cloud::DataQnA::V1alpha::BigQueryJob]
        #     BigQuery job information.
        #     Future versions will have different backends. Hence, clients must make sure
        #     they can handle it when this field is not populated.
        class ExecutionInfo
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Enum of possible job execution statuses.
          module JobExecutionState
            # No job execution was specified.
            JOB_EXECUTION_STATE_UNSPECIFIED = 0

            # No job execution was requested, yet.
            NOT_EXECUTED = 1

            # The job is running.
            RUNNING = 2

            # The job completed successfully.
            SUCCEEDED = 3

            # The job completed unsuccessfully.
            FAILED = 4
          end
        end

        # BigQuery job information. This can be used to query the BigQuery API and
        # retrieve the current job's status (using
        # [jobs.get](https://cloud.google.com/bigquery/docs/reference/rest/v2/jobs/get)).
        # @!attribute [rw] job_id
        #   @return [::String]
        #     The job ID.
        # @!attribute [rw] project_id
        #   @return [::String]
        #     The project ID of the job.
        # @!attribute [rw] location
        #   @return [::String]
        #     The location where the job is running.
        class BigQueryJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An interpretation of a natural language query.
        # @!attribute [rw] data_sources
        #   @return [::Array<::String>]
        #     List of data sources used in the current understanding.
        # @!attribute [rw] confidence
        #   @return [::Float]
        #     The level of confidence that one of the interpretations is correct. This is
        #     a value in the range [0, 1] where a value of 0.5 or below is to be
        #     considered a low confidence.
        # @!attribute [rw] unused_phrases
        #   @return [::Array<::String>]
        #     A list of unused phrases. Clients should display a Did You Mean (DYM)
        #      dialog if this is non-empty, even if this is the only interpretation.
        # @!attribute [rw] human_readable
        #   @return [::Google::Cloud::DataQnA::V1alpha::HumanReadable]
        #     Human readable representation of the query.
        # @!attribute [rw] interpretation_structure
        #   @return [::Google::Cloud::DataQnA::V1alpha::InterpretationStructure]
        #     Information about the interpretation structure that helps to understand and
        #     visualize the response.
        # @!attribute [rw] data_query
        #   @return [::Google::Cloud::DataQnA::V1alpha::DataQuery]
        #     Representation of the data query to be sent to the backend.
        # @!attribute [rw] execution_info
        #   @return [::Google::Cloud::DataQnA::V1alpha::ExecutionInfo]
        #     Information about the backend response. This is populated only if execution
        #     of an interpretation was requested.
        class Interpretation
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Representation of the data query for the backend.
        # This is provided for informational purposes only. Clients should not use
        # it to send it to the backend directly, but rather use the `execute` RPC
        # to trigger the execution. Using the `execute` RPC is needed in order to
        # track the state of a question and report on it correctly to the data
        # administrators.
        # @!attribute [rw] sql
        #   @return [::String]
        #     The generated SQL query to be sent to the backend.
        class DataQuery
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Human readable interpretation.
        # @!attribute [rw] generated_interpretation
        #   @return [::Google::Cloud::DataQnA::V1alpha::AnnotatedString]
        #     Generated query explaining the interpretation.
        # @!attribute [rw] original_question
        #   @return [::Google::Cloud::DataQnA::V1alpha::AnnotatedString]
        #     Annotations on the original query.
        class HumanReadable
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information about the interpretation structure that helps to understand and
        # visualize the response.
        # @!attribute [rw] visualization_types
        #   @return [::Array<::Google::Cloud::DataQnA::V1alpha::InterpretationStructure::VisualizationType>]
        #     List of possible visualization types to apply for this interpretation. The
        #     order has no relevance.
        # @!attribute [rw] column_info
        #   @return [::Array<::Google::Cloud::DataQnA::V1alpha::InterpretationStructure::ColumnInfo>]
        #     Information about the output columns, that is, the columns that will be
        #     returned by the backend.
        class InterpretationStructure
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Information about a column.
          # @!attribute [rw] output_alias
          #   @return [::String]
          #     The alias of the output column as used by the backend. For example, the
          #     field name in the schema provided in the query response in BigQuery.
          # @!attribute [rw] display_name
          #   @return [::String]
          #     Human readable name of the output column.
          class ColumnInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Enumeration of visualzation types to use for query response data.
          module VisualizationType
            # No visualization type was specified.
            VISUALIZATION_TYPE_UNSPECIFIED = 0

            # Show a table.
            TABLE = 1

            # Show a [bar
            # chart](https://developers.google.com/chart/interactive/docs/gallery/barchart).
            BAR_CHART = 2

            # Show a [column
            # chart](https://developers.google.com/chart/interactive/docs/gallery/columnchart).
            COLUMN_CHART = 3

            # Show a
            # [timeline](https://developers.google.com/chart/interactive/docs/gallery/timeline).
            TIMELINE = 4

            # Show a [scatter
            # plot](https://developers.google.com/chart/interactive/docs/gallery/scatterchart).
            SCATTER_PLOT = 5

            # Show a [pie
            # chart](https://developers.google.com/chart/interactive/docs/gallery/piechart).
            PIE_CHART = 6

            # Show a [line
            # chart](https://developers.google.com/chart/interactive/docs/gallery/linechart).
            LINE_CHART = 7

            # Show an [area
            # chart](https://developers.google.com/chart/interactive/docs/gallery/areachart).
            AREA_CHART = 8

            # Show a [combo
            # chart](https://developers.google.com/chart/interactive/docs/gallery/combochart).
            COMBO_CHART = 9

            # Show a
            # [histogram](https://developers.google.com/chart/interactive/docs/gallery/histogram).
            HISTOGRAM = 10

            # This denotes queries when the user has not specified the particular type
            # of chart and has mentioned only a generic chart name such as "Chart",
            # "Plot", "Graph", etc. This will differentiate it from specific charting
            # terms such as "Bar chart", "Pie chart", etc.
            GENERIC_CHART = 11

            # The user tried to specify a chart type, but the interpreter could not
            # understand the type. The client should display a generic chart and may
            # give a hint to the user that the requested type was not understood.
            CHART_NOT_UNDERSTOOD = 12
          end
        end

        # Configuriation of debug flags.
        # @!attribute [rw] include_va_query
        #   @return [::Boolean]
        #     Whether to include the original VAQuery.
        # @!attribute [rw] include_nested_va_query
        #   @return [::Boolean]
        #     Whether to include the original nested VAQuery.
        # @!attribute [rw] include_human_interpretation
        #   @return [::Boolean]
        #     Whether to include the original human interpretation strings generated
        #     by Analyza.
        # @!attribute [rw] include_aqua_debug_response
        #   @return [::Boolean]
        #     Whether to include the Aqua debug response.
        # @!attribute [rw] time_override
        #   @return [::Integer]
        #     The time in milliseconds from Unix epoch to be used
        #     to process the query. This is useful for testing
        #     the queries at different time period.
        #     If not set or time_override <= 0, then the current
        #     time is used.
        # @!attribute [rw] is_internal_google_user
        #   @return [::Boolean]
        #     Set to true if request is initiated by an internal Google user.
        # @!attribute [rw] ignore_cache
        #   @return [::Boolean]
        #     Determines whether cache needs to be ignored. If set to
        #     true, cache won't be queried and updated.
        # @!attribute [rw] include_search_entities_rpc
        #   @return [::Boolean]
        #     Whether to include the request/response pair from the call to the
        #     EntityIndex for SearchEntities.
        # @!attribute [rw] include_list_column_annotations_rpc
        #   @return [::Boolean]
        #     Whether to include the request/response pair from the call to the
        #     Annotations service for ListColumnAnnotations.
        # @!attribute [rw] include_virtual_analyst_entities
        #   @return [::Boolean]
        #     Whether to include the entity list passed to Analyza.
        # @!attribute [rw] include_table_list
        #   @return [::Boolean]
        #     Whether to include the table list.
        # @!attribute [rw] include_domain_list
        #   @return [::Boolean]
        #     Whether to include the domain list.
        class DebugFlags
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Query entities of an interpretation.
        module InterpretEntity
          # No interpret entity was specified.
          INTERPRET_ENTITY_UNSPECIFIED = 0

          # A dimenstion entity.
          DIMENSION = 1

          # A metric entity.
          METRIC = 2
        end
      end
    end
  end
end
