# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/dataqna/v1alpha/version"

require "google/cloud/dataqna/v1alpha/question_service/credentials"
require "google/cloud/dataqna/v1alpha/question_service/paths"
require "google/cloud/dataqna/v1alpha/question_service/client"

module Google
  module Cloud
    module DataQnA
      module V1alpha
        ##
        # Service to interpret natural language queries.
        # The service allows to create `Question` resources that are interpreted and
        # are filled with one or more interpretations if the question could be
        # interpreted. Once a `Question` resource is created and has at least one
        # interpretation, an interpretation can be chosen for execution, which
        # triggers a query to the backend (for BigQuery, it will create a job).
        # Upon successful execution of that interpretation, backend specific
        # information will be returned so that the client can retrieve the results
        # from the backend.
        #
        # The `Question` resources are named `projects/*/locations/*/questions/*`.
        #
        # The `Question` resource has a singletion sub-resource `UserFeedback` named
        # `projects/*/locations/*/questions/*/userFeedback`, which allows access to
        # user feedback.
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/dataqna/v1alpha/question_service"
        #     client = ::Google::Cloud::DataQnA::V1alpha::QuestionService::Client.new
        #
        module QuestionService
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "question_service", "helpers.rb"
require "google/cloud/dataqna/v1alpha/question_service/helpers" if ::File.file? helper_path
