# frozen_string_literal: true

# Copyright 2021 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "gapic/common"
require "gapic/config"
require "gapic/config/method"

require "google/cloud/dataqna/v1alpha/version"

require "google/cloud/dataqna/v1alpha/auto_suggestion_service/credentials"
require "google/cloud/dataqna/v1alpha/auto_suggestion_service/paths"
require "google/cloud/dataqna/v1alpha/auto_suggestion_service/client"

module Google
  module Cloud
    module DataQnA
      module V1alpha
        ##
        # This stateless API provides automatic suggestions for natural language
        # queries for the data sources in the provided project and location.
        #
        # The service provides a resourceless operation `suggestQueries` that can be
        # called to get a list of suggestions for a given incomplete query and scope
        # (or list of scopes) under which the query is to be interpreted.
        #
        # There are two types of suggestions, ENTITY for single entity suggestions
        # and TEMPLATE for full sentences. By default, both types are returned.
        #
        # Example Request:
        # ```
        # GetSuggestions({
        #   parent: "locations/us/projects/my-project"
        #   scopes:
        #   "//bigquery.googleapis.com/projects/my-project/datasets/my-dataset/tables/my-table"
        #   query: "top it"
        # })
        # ```
        #
        # The service will retrieve information based on the given scope(s) and give
        # suggestions based on that (e.g. "top item" for "top it" if "item" is a known
        # dimension for the provided scope).
        # ```
        # suggestions {
        #   suggestion_info {
        #     annotated_suggestion {
        #       text_formatted: "top item by sum of usd_revenue_net"
        #       markups {
        #         type: DIMENSION
        #         start_char_index: 4
        #         length: 4
        #       }
        #       markups {
        #         type: METRIC
        #         start_char_index: 19
        #         length: 15
        #       }
        #     }
        #     query_matches {
        #       start_char_index: 0
        #       length: 6
        #     }
        #   }
        #   suggestion_type: TEMPLATE
        #   ranking_score: 0.9
        # }
        # suggestions {
        #   suggestion_info {
        #     annotated_suggestion {
        #       text_formatted: "item"
        #       markups {
        #         type: DIMENSION
        #         start_char_index: 4
        #         length: 2
        #       }
        #     }
        #     query_matches {
        #       start_char_index: 0
        #       length: 6
        #     }
        #   }
        #   suggestion_type: ENTITY
        #   ranking_score: 0.8
        # }
        # ```
        #
        # @example Load this service and instantiate a gRPC client
        #
        #     require "google/cloud/dataqna/v1alpha/auto_suggestion_service"
        #     client = ::Google::Cloud::DataQnA::V1alpha::AutoSuggestionService::Client.new
        #
        module AutoSuggestionService
        end
      end
    end
  end
end

helper_path = ::File.join __dir__, "auto_suggestion_service", "helpers.rb"
require "google/cloud/dataqna/v1alpha/auto_suggestion_service/helpers" if ::File.file? helper_path
