# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/dataproc/v1/node_groups_pb"
require "google/cloud/dataproc/v1/node_group_controller"

class ::Google::Cloud::Dataproc::V1::NodeGroupController::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_node_group
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    node_group = {}
    node_group_id = "hello world"
    request_id = "hello world"

    create_node_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_node_group, name
      assert_kind_of ::Google::Cloud::Dataproc::V1::CreateNodeGroupRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataproc::V1::NodeGroup), request["node_group"]
      assert_equal "hello world", request["node_group_id"]
      assert_equal "hello world", request["request_id"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_node_group_client_stub do
      # Create client
      client = ::Google::Cloud::Dataproc::V1::NodeGroupController::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_node_group({ parent: parent, node_group: node_group, node_group_id: node_group_id, request_id: request_id }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_node_group parent: parent, node_group: node_group, node_group_id: node_group_id, request_id: request_id do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_node_group ::Google::Cloud::Dataproc::V1::CreateNodeGroupRequest.new(parent: parent, node_group: node_group, node_group_id: node_group_id, request_id: request_id) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_node_group({ parent: parent, node_group: node_group, node_group_id: node_group_id, request_id: request_id }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_node_group(::Google::Cloud::Dataproc::V1::CreateNodeGroupRequest.new(parent: parent, node_group: node_group, node_group_id: node_group_id, request_id: request_id), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_node_group_client_stub.call_rpc_count
    end
  end

  def test_resize_node_group
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    size = 42
    request_id = "hello world"
    graceful_decommission_timeout = {}

    resize_node_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :resize_node_group, name
      assert_kind_of ::Google::Cloud::Dataproc::V1::ResizeNodeGroupRequest, request
      assert_equal "hello world", request["name"]
      assert_equal 42, request["size"]
      assert_equal "hello world", request["request_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::Duration), request["graceful_decommission_timeout"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, resize_node_group_client_stub do
      # Create client
      client = ::Google::Cloud::Dataproc::V1::NodeGroupController::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.resize_node_group({ name: name, size: size, request_id: request_id, graceful_decommission_timeout: graceful_decommission_timeout }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.resize_node_group name: name, size: size, request_id: request_id, graceful_decommission_timeout: graceful_decommission_timeout do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.resize_node_group ::Google::Cloud::Dataproc::V1::ResizeNodeGroupRequest.new(name: name, size: size, request_id: request_id, graceful_decommission_timeout: graceful_decommission_timeout) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.resize_node_group({ name: name, size: size, request_id: request_id, graceful_decommission_timeout: graceful_decommission_timeout }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.resize_node_group(::Google::Cloud::Dataproc::V1::ResizeNodeGroupRequest.new(name: name, size: size, request_id: request_id, graceful_decommission_timeout: graceful_decommission_timeout), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, resize_node_group_client_stub.call_rpc_count
    end
  end

  def test_get_node_group
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataproc::V1::NodeGroup.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_node_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_node_group, name
      assert_kind_of ::Google::Cloud::Dataproc::V1::GetNodeGroupRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_node_group_client_stub do
      # Create client
      client = ::Google::Cloud::Dataproc::V1::NodeGroupController::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_node_group({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_node_group name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_node_group ::Google::Cloud::Dataproc::V1::GetNodeGroupRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_node_group({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_node_group(::Google::Cloud::Dataproc::V1::GetNodeGroupRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_node_group_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataproc::V1::NodeGroupController::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dataproc::V1::NodeGroupController::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataproc::V1::NodeGroupController::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Dataproc::V1::NodeGroupController::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataproc::V1::NodeGroupController::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Dataproc::V1::NodeGroupController::Operations, client.operations_client
  end
end
