# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/dataproc/v1/node_groups_pb"
require "google/cloud/dataproc/v1/node_group_controller/rest"


class ::Google::Cloud::Dataproc::V1::NodeGroupController::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_node_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    node_group = {}
    node_group_id = "hello world"
    request_id = "hello world"

    create_node_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataproc::V1::NodeGroupController::Rest::ServiceStub.stub :transcode_create_node_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_node_group_client_stub do
        # Create client
        client = ::Google::Cloud::Dataproc::V1::NodeGroupController::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_node_group({ parent: parent, node_group: node_group, node_group_id: node_group_id, request_id: request_id }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_node_group parent: parent, node_group: node_group, node_group_id: node_group_id, request_id: request_id do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_node_group ::Google::Cloud::Dataproc::V1::CreateNodeGroupRequest.new(parent: parent, node_group: node_group, node_group_id: node_group_id, request_id: request_id) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_node_group({ parent: parent, node_group: node_group, node_group_id: node_group_id, request_id: request_id }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_node_group(::Google::Cloud::Dataproc::V1::CreateNodeGroupRequest.new(parent: parent, node_group: node_group, node_group_id: node_group_id, request_id: request_id), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_node_group_client_stub.call_count
      end
    end
  end

  def test_resize_node_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    size = 42
    request_id = "hello world"
    graceful_decommission_timeout = {}

    resize_node_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataproc::V1::NodeGroupController::Rest::ServiceStub.stub :transcode_resize_node_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, resize_node_group_client_stub do
        # Create client
        client = ::Google::Cloud::Dataproc::V1::NodeGroupController::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.resize_node_group({ name: name, size: size, request_id: request_id, graceful_decommission_timeout: graceful_decommission_timeout }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.resize_node_group name: name, size: size, request_id: request_id, graceful_decommission_timeout: graceful_decommission_timeout do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.resize_node_group ::Google::Cloud::Dataproc::V1::ResizeNodeGroupRequest.new(name: name, size: size, request_id: request_id, graceful_decommission_timeout: graceful_decommission_timeout) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.resize_node_group({ name: name, size: size, request_id: request_id, graceful_decommission_timeout: graceful_decommission_timeout }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.resize_node_group(::Google::Cloud::Dataproc::V1::ResizeNodeGroupRequest.new(name: name, size: size, request_id: request_id, graceful_decommission_timeout: graceful_decommission_timeout), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, resize_node_group_client_stub.call_count
      end
    end
  end

  def test_get_node_group
    # Create test objects.
    client_result = ::Google::Cloud::Dataproc::V1::NodeGroup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_node_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataproc::V1::NodeGroupController::Rest::ServiceStub.stub :transcode_get_node_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_node_group_client_stub do
        # Create client
        client = ::Google::Cloud::Dataproc::V1::NodeGroupController::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_node_group({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_node_group name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_node_group ::Google::Cloud::Dataproc::V1::GetNodeGroupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_node_group({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_node_group(::Google::Cloud::Dataproc::V1::GetNodeGroupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_node_group_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataproc::V1::NodeGroupController::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dataproc::V1::NodeGroupController::Rest::Client::Configuration, config
  end
end
