# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataproc
      module V1
        # A request to create a session.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this session will be created.
        # @!attribute [rw] session
        #   @return [::Google::Cloud::Dataproc::V1::Session]
        #     Required. The interactive session to create.
        # @!attribute [rw] session_id
        #   @return [::String]
        #     Required. The ID to use for the session, which becomes the final component
        #     of the session's resource name.
        #
        #     This value must be 4-63 characters. Valid characters
        #     are /[a-z][0-9]-/.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique ID used to identify the request. If the service
        #     receives two
        #     [CreateSessionRequests](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateSessionRequest)s
        #     with the same ID, the second request is ignored, and the
        #     first {::Google::Cloud::Dataproc::V1::Session Session} is created and stored in
        #     the backend.
        #
        #     Recommendation: Set this value to a
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
        #
        #     The value must contain only letters (a-z, A-Z), numbers (0-9),
        #     underscores (_), and hyphens (-). The maximum length is 40 characters.
        class CreateSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get the resource representation for a session.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the session to retrieve.
        class GetSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to list sessions in a project.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which owns this collection of sessions.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of sessions to return in each response.
        #     The service may return fewer than this value.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token received from a previous `ListSessions` call.
        #     Provide this token to retrieve the subsequent page.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter for the sessions to return in the response.
        #
        #     A filter is a logical expression constraining the values of various fields
        #     in each session resource. Filters are case sensitive, and may contain
        #     multiple clauses combined with logical operators (AND, OR).
        #     Supported fields are `session_id`, `session_uuid`, `state`, `create_time`,
        #     and `labels`.
        #
        #     Example: `state = ACTIVE and create_time < "2023-01-01T00:00:00Z"`
        #     is a filter for sessions in an ACTIVE state that were created before
        #     2023-01-01. `state = ACTIVE and labels.environment=production` is a filter
        #     for sessions in an ACTIVE state that have a production environment label.
        #
        #     See https://google.aip.dev/assets/misc/ebnf-filtering.txt for a detailed
        #     description of the filter syntax and a list of supported comparators.
        class ListSessionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A list of interactive sessions.
        # @!attribute [r] sessions
        #   @return [::Array<::Google::Cloud::Dataproc::V1::Session>]
        #     Output only. The sessions from the specified collection.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token`, to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        class ListSessionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to terminate an interactive session.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the session resource to terminate.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique ID used to identify the request. If the service
        #     receives two
        #     [TerminateSessionRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.TerminateSessionRequest)s
        #     with the same ID, the second request is ignored.
        #
        #     Recommendation: Set this value to a
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
        #
        #     The value must contain only letters (a-z, A-Z), numbers (0-9),
        #     underscores (_), and hyphens (-). The maximum length is 40 characters.
        class TerminateSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to delete a session.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the session resource to delete.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique ID used to identify the request. If the service
        #     receives two
        #     [DeleteSessionRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.DeleteSessionRequest)s
        #     with the same ID, the second request is ignored.
        #
        #     Recommendation: Set this value to a
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
        #
        #     The value must contain only letters (a-z, A-Z), numbers (0-9),
        #     underscores (_), and hyphens (-). The maximum length is 40 characters.
        class DeleteSessionRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A representation of a session.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the session.
        # @!attribute [r] uuid
        #   @return [::String]
        #     Output only. A session UUID (Unique Universal Identifier). The service
        #     generates this value when it creates the session.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the session was created.
        # @!attribute [rw] jupyter_session
        #   @return [::Google::Cloud::Dataproc::V1::JupyterConfig]
        #     Optional. Jupyter session config.
        #
        #     Note: The following fields are mutually exclusive: `jupyter_session`, `spark_connect_session`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] spark_connect_session
        #   @return [::Google::Cloud::Dataproc::V1::SparkConnectConfig]
        #     Optional. Spark Connect session config.
        #
        #     Note: The following fields are mutually exclusive: `spark_connect_session`, `jupyter_session`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] runtime_info
        #   @return [::Google::Cloud::Dataproc::V1::RuntimeInfo]
        #     Output only. Runtime information about session execution.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Dataproc::V1::Session::State]
        #     Output only. A state of the session.
        # @!attribute [r] state_message
        #   @return [::String]
        #     Output only. Session state details, such as the failure
        #     description if the state is `FAILED`.
        # @!attribute [r] state_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the session entered the current state.
        # @!attribute [r] creator
        #   @return [::String]
        #     Output only. The email address of the user who created the session.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. The labels to associate with the session.
        #     Label **keys** must contain 1 to 63 characters, and must conform to
        #     [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
        #     Label **values** may be empty, but, if present, must contain 1 to 63
        #     characters, and must conform to [RFC
        #     1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
        #     associated with a session.
        # @!attribute [rw] runtime_config
        #   @return [::Google::Cloud::Dataproc::V1::RuntimeConfig]
        #     Optional. Runtime configuration for the session execution.
        # @!attribute [rw] environment_config
        #   @return [::Google::Cloud::Dataproc::V1::EnvironmentConfig]
        #     Optional. Environment configuration for the session execution.
        # @!attribute [rw] user
        #   @return [::String]
        #     Optional. The email address of the user who owns the session.
        # @!attribute [r] state_history
        #   @return [::Array<::Google::Cloud::Dataproc::V1::Session::SessionStateHistory>]
        #     Output only. Historical state information for the session.
        # @!attribute [rw] session_template
        #   @return [::String]
        #     Optional. The session template used by the session.
        #
        #     Only resource names, including project ID and location, are valid.
        #
        #     Example:
        #     * `https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
        #     * `projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]`
        #
        #     The template must be in the same project and Dataproc region as the
        #     session.
        class Session
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Historical state information.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Dataproc::V1::Session::State]
          #     Output only. The state of the session at this point in the session
          #     history.
          # @!attribute [r] state_message
          #   @return [::String]
          #     Output only. Details about the state at this point in the session
          #     history.
          # @!attribute [r] state_start_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the session entered the historical state.
          class SessionStateHistory
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The session state.
          module State
            # The session state is unknown.
            STATE_UNSPECIFIED = 0

            # The session is created prior to running.
            CREATING = 1

            # The session is running.
            ACTIVE = 2

            # The session is terminating.
            TERMINATING = 3

            # The session is terminated successfully.
            TERMINATED = 4

            # The session is no longer running due to an error.
            FAILED = 5
          end
        end

        # Jupyter configuration for an interactive session.
        # @!attribute [rw] kernel
        #   @return [::Google::Cloud::Dataproc::V1::JupyterConfig::Kernel]
        #     Optional. Kernel
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. Display name, shown in the Jupyter kernelspec card.
        class JupyterConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Jupyter kernel types.
          module Kernel
            # The kernel is unknown.
            KERNEL_UNSPECIFIED = 0

            # Python kernel.
            PYTHON = 1

            # Scala kernel.
            SCALA = 2
          end
        end

        # Spark Connect configuration for an interactive session.
        class SparkConnectConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
