# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataproc
      module V1
        # A request to create a node group.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this node group will be created.
        #     Format: `projects/{project}/regions/{region}/clusters/{cluster}`
        # @!attribute [rw] node_group
        #   @return [::Google::Cloud::Dataproc::V1::NodeGroup]
        #     Required. The node group to create.
        # @!attribute [rw] node_group_id
        #   @return [::String]
        #     Optional. An optional node group ID. Generated if not specified.
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9),
        #     underscores (_), and hyphens (-). Cannot begin or end with underscore
        #     or hyphen. Must consist of from 3 to 33 characters.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique ID used to identify the request. If the server receives
        #     two
        #     [CreateNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateNodeGroupRequests)
        #     with the same ID, the second request is ignored and the
        #     first {::Google::Longrunning::Operation google.longrunning.Operation} created
        #     and stored in the backend is returned.
        #
        #     Recommendation: Set this value to a
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9),
        #     underscores (_), and hyphens (-). The maximum length is 40 characters.
        class CreateNodeGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to resize a node group.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the node group to resize.
        #     Format:
        #     `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
        # @!attribute [rw] size
        #   @return [::Integer]
        #     Required. The number of running instances for the node group to maintain.
        #     The group adds or removes instances to maintain the number of instances
        #     specified by this parameter.
        # @!attribute [rw] request_id
        #   @return [::String]
        #     Optional. A unique ID used to identify the request. If the server receives
        #     two
        #     [ResizeNodeGroupRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
        #     with the same ID, the second request is ignored and the
        #     first {::Google::Longrunning::Operation google.longrunning.Operation} created
        #     and stored in the backend is returned.
        #
        #     Recommendation: Set this value to a
        #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
        #
        #     The ID must contain only letters (a-z, A-Z), numbers (0-9),
        #     underscores (_), and hyphens (-). The maximum length is 40 characters.
        # @!attribute [rw] graceful_decommission_timeout
        #   @return [::Google::Protobuf::Duration]
        #     Optional. Timeout for graceful YARN decommissioning. [Graceful
        #     decommissioning]
        #     (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
        #     allows the removal of nodes from the Compute Engine node group
        #     without interrupting jobs in progress. This timeout specifies how long to
        #     wait for jobs in progress to finish before forcefully removing nodes (and
        #     potentially interrupting jobs). Default timeout is 0 (for forceful
        #     decommission), and the maximum allowed timeout is 1 day. (see JSON
        #     representation of
        #     [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
        #
        #     Only supported on Dataproc image versions 1.2 and higher.
        class ResizeNodeGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A request to get a node group .
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the node group to retrieve.
        #     Format:
        #     `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{nodeGroup}`
        class GetNodeGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
