# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataproc
      module V1
        module NodeGroupController
          # Path helper methods for the NodeGroupController API.
          module Paths
            ##
            # Create a fully-qualified ClusterRegion resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/regions/{region}/clusters/{cluster}`
            #
            # @param project [String]
            # @param region [String]
            # @param cluster [String]
            #
            # @return [::String]
            def cluster_region_path project:, region:, cluster:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "region cannot contain /" if region.to_s.include? "/"

              "projects/#{project}/regions/#{region}/clusters/#{cluster}"
            end

            ##
            # Create a fully-qualified NodeGroup resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/regions/{region}/clusters/{cluster}/nodeGroups/{node_group}`
            #
            # @param project [String]
            # @param region [String]
            # @param cluster [String]
            # @param node_group [String]
            #
            # @return [::String]
            def node_group_path project:, region:, cluster:, node_group:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "region cannot contain /" if region.to_s.include? "/"
              raise ::ArgumentError, "cluster cannot contain /" if cluster.to_s.include? "/"

              "projects/#{project}/regions/#{region}/clusters/#{cluster}/nodeGroups/#{node_group}"
            end

            extend self
          end
        end
      end
    end
  end
end
