# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dataproc/v1/jobs_pb"
require "google/cloud/dataproc/v1/job_controller/rest/service_stub"
require "google/iam/v1/rest"

module Google
  module Cloud
    module Dataproc
      module V1
        module JobController
          module Rest
            ##
            # REST client for the JobController service.
            #
            # The JobController provides methods to manage jobs.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "dataproc.$UNIVERSE_DOMAIN$"

              # @private
              attr_reader :job_controller_stub

              ##
              # Configure the JobController Client class.
              #
              # See {::Google::Cloud::Dataproc::V1::JobController::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all JobController clients
              #   ::Google::Cloud::Dataproc::V1::JobController::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Dataproc", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.submit_job.timeout = 900.0
                  default_config.rpcs.submit_job.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.submit_job_as_operation.timeout = 900.0
                  default_config.rpcs.submit_job_as_operation.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_job.timeout = 900.0
                  default_config.rpcs.get_job.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                  }

                  default_config.rpcs.list_jobs.timeout = 900.0
                  default_config.rpcs.list_jobs.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                  }

                  default_config.rpcs.update_job.timeout = 900.0
                  default_config.rpcs.update_job.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.cancel_job.timeout = 900.0
                  default_config.rpcs.cancel_job.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [4, 13, 14]
                  }

                  default_config.rpcs.delete_job.timeout = 900.0
                  default_config.rpcs.delete_job.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the JobController Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Dataproc::V1::JobController::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @job_controller_stub.universe_domain
              end

              ##
              # Create a new JobController REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Dataproc::V1::JobController::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Dataproc::V1::JobController::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the JobController client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Dataproc::V1::JobController::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @job_controller_stub = ::Google::Cloud::Dataproc::V1::JobController::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @job_controller_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @job_controller_stub.endpoint
                  config.universe_domain = @job_controller_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @job_controller_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Dataproc::V1::JobController::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @job_controller_stub.logger
              end

              # Service calls

              ##
              # Submits a job to a cluster.
              #
              # @overload submit_job(request, options = nil)
              #   Pass arguments to `submit_job` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::SubmitJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::SubmitJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload submit_job(project_id: nil, region: nil, job: nil, request_id: nil)
              #   Pass arguments to `submit_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project that the job
              #     belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param job [::Google::Cloud::Dataproc::V1::Job, ::Hash]
              #     Required. The job resource.
              #   @param request_id [::String]
              #     Optional. A unique id used to identify the request. If the server
              #     receives two
              #     [SubmitJobRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.SubmitJobRequest)s
              #     with the same id, then the second request will be ignored and the
              #     first {::Google::Cloud::Dataproc::V1::Job Job} created and stored in the backend
              #     is returned.
              #
              #     It is recommended to always set this value to a
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
              #
              #     The id must contain only letters (a-z, A-Z), numbers (0-9),
              #     underscores (_), and hyphens (-). The maximum length is 40 characters.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataproc::V1::Job]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataproc::V1::Job]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::JobController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::SubmitJobRequest.new
              #
              #   # Call the submit_job method.
              #   result = client.submit_job request
              #
              #   # The returned object is of type Google::Cloud::Dataproc::V1::Job.
              #   p result
              #
              def submit_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::SubmitJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.submit_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.submit_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.submit_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @job_controller_stub.submit_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Submits job to a cluster.
              #
              # @overload submit_job_as_operation(request, options = nil)
              #   Pass arguments to `submit_job_as_operation` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::SubmitJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::SubmitJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload submit_job_as_operation(project_id: nil, region: nil, job: nil, request_id: nil)
              #   Pass arguments to `submit_job_as_operation` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project that the job
              #     belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param job [::Google::Cloud::Dataproc::V1::Job, ::Hash]
              #     Required. The job resource.
              #   @param request_id [::String]
              #     Optional. A unique id used to identify the request. If the server
              #     receives two
              #     [SubmitJobRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.SubmitJobRequest)s
              #     with the same id, then the second request will be ignored and the
              #     first {::Google::Cloud::Dataproc::V1::Job Job} created and stored in the backend
              #     is returned.
              #
              #     It is recommended to always set this value to a
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
              #
              #     The id must contain only letters (a-z, A-Z), numbers (0-9),
              #     underscores (_), and hyphens (-). The maximum length is 40 characters.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::JobController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::SubmitJobRequest.new
              #
              #   # Call the submit_job_as_operation method.
              #   result = client.submit_job_as_operation request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def submit_job_as_operation request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::SubmitJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.submit_job_as_operation.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.submit_job_as_operation.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.submit_job_as_operation.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @job_controller_stub.submit_job_as_operation request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the resource representation for a job in a project.
              #
              # @overload get_job(request, options = nil)
              #   Pass arguments to `get_job` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::GetJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::GetJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_job(project_id: nil, region: nil, job_id: nil)
              #   Pass arguments to `get_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project that the job
              #     belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param job_id [::String]
              #     Required. The job ID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataproc::V1::Job]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataproc::V1::Job]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::JobController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::GetJobRequest.new
              #
              #   # Call the get_job method.
              #   result = client.get_job request
              #
              #   # The returned object is of type Google::Cloud::Dataproc::V1::Job.
              #   p result
              #
              def get_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::GetJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @job_controller_stub.get_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists regions/\\{region}/jobs in a project.
              #
              # @overload list_jobs(request, options = nil)
              #   Pass arguments to `list_jobs` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::ListJobsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::ListJobsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_jobs(project_id: nil, region: nil, page_size: nil, page_token: nil, cluster_name: nil, job_state_matcher: nil, filter: nil)
              #   Pass arguments to `list_jobs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project that the job
              #     belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param page_size [::Integer]
              #     Optional. The number of results to return in each response.
              #   @param page_token [::String]
              #     Optional. The page token, returned by a previous call, to request the
              #     next page of results.
              #   @param cluster_name [::String]
              #     Optional. If set, the returned jobs list includes only jobs that were
              #     submitted to the named cluster.
              #   @param job_state_matcher [::Google::Cloud::Dataproc::V1::ListJobsRequest::JobStateMatcher]
              #     Optional. Specifies enumerated categories of jobs to list.
              #     (default = match ALL jobs).
              #
              #     If `filter` is provided, `jobStateMatcher` will be ignored.
              #   @param filter [::String]
              #     Optional. A filter constraining the jobs to list. Filters are
              #     case-sensitive and have the following syntax:
              #
              #     [field = value] AND [field [= value]] ...
              #
              #     where **field** is `status.state` or `labels.[KEY]`, and `[KEY]` is a label
              #     key. **value** can be `*` to match all values.
              #     `status.state` can be either `ACTIVE` or `NON_ACTIVE`.
              #     Only the logical `AND` operator is supported; space-separated items are
              #     treated as having an implicit `AND` operator.
              #
              #     Example filter:
              #
              #     status.state = ACTIVE AND labels.env = staging AND labels.starred = *
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataproc::V1::Job>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataproc::V1::Job>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::JobController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::ListJobsRequest.new
              #
              #   # Call the list_jobs method.
              #   result = client.list_jobs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataproc::V1::Job.
              #     p item
              #   end
              #
              def list_jobs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::ListJobsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_jobs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_jobs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_jobs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @job_controller_stub.list_jobs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @job_controller_stub, :list_jobs, "jobs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a job in a project.
              #
              # @overload update_job(request, options = nil)
              #   Pass arguments to `update_job` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::UpdateJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::UpdateJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_job(project_id: nil, region: nil, job_id: nil, job: nil, update_mask: nil)
              #   Pass arguments to `update_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project that the job
              #     belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param job_id [::String]
              #     Required. The job ID.
              #   @param job [::Google::Cloud::Dataproc::V1::Job, ::Hash]
              #     Required. The changes to the job.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Specifies the path, relative to <code>Job</code>, of
              #     the field to update. For example, to update the labels of a Job the
              #     <code>update_mask</code> parameter would be specified as
              #     <code>labels</code>, and the `PATCH` request body would specify the new
              #     value. <strong>Note:</strong> Currently, <code>labels</code> is the only
              #     field that can be updated.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataproc::V1::Job]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataproc::V1::Job]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::JobController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::UpdateJobRequest.new
              #
              #   # Call the update_job method.
              #   result = client.update_job request
              #
              #   # The returned object is of type Google::Cloud::Dataproc::V1::Job.
              #   p result
              #
              def update_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::UpdateJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @job_controller_stub.update_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts a job cancellation request. To access the job resource
              # after cancellation, call
              # [regions/\\{region}/jobs.list](https://cloud.google.com/dataproc/docs/reference/rest/v1/projects.regions.jobs/list)
              # or
              # [regions/\\{region}/jobs.get](https://cloud.google.com/dataproc/docs/reference/rest/v1/projects.regions.jobs/get).
              #
              # @overload cancel_job(request, options = nil)
              #   Pass arguments to `cancel_job` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::CancelJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::CancelJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload cancel_job(project_id: nil, region: nil, job_id: nil)
              #   Pass arguments to `cancel_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project that the job
              #     belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param job_id [::String]
              #     Required. The job ID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataproc::V1::Job]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataproc::V1::Job]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::JobController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::CancelJobRequest.new
              #
              #   # Call the cancel_job method.
              #   result = client.cancel_job request
              #
              #   # The returned object is of type Google::Cloud::Dataproc::V1::Job.
              #   p result
              #
              def cancel_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::CancelJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.cancel_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.cancel_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.cancel_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @job_controller_stub.cancel_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes the job from the project. If the job is active, the delete fails,
              # and the response returns `FAILED_PRECONDITION`.
              #
              # @overload delete_job(request, options = nil)
              #   Pass arguments to `delete_job` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::DeleteJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::DeleteJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_job(project_id: nil, region: nil, job_id: nil)
              #   Pass arguments to `delete_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project that the job
              #     belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param job_id [::String]
              #     Required. The job ID.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::JobController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::DeleteJobRequest.new
              #
              #   # Call the delete_job method.
              #   result = client.delete_job request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def delete_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::DeleteJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @job_controller_stub.delete_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the JobController REST API.
              #
              # This class represents the configuration for JobController REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Dataproc::V1::JobController::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # submit_job to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Dataproc::V1::JobController::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.submit_job.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Dataproc::V1::JobController::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.submit_job.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "dataproc.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the JobController API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `submit_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :submit_job
                  ##
                  # RPC-specific configuration for `submit_job_as_operation`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :submit_job_as_operation
                  ##
                  # RPC-specific configuration for `get_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_job
                  ##
                  # RPC-specific configuration for `list_jobs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_jobs
                  ##
                  # RPC-specific configuration for `update_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_job
                  ##
                  # RPC-specific configuration for `cancel_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :cancel_job
                  ##
                  # RPC-specific configuration for `delete_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_job

                  # @private
                  def initialize parent_rpcs = nil
                    submit_job_config = parent_rpcs.submit_job if parent_rpcs.respond_to? :submit_job
                    @submit_job = ::Gapic::Config::Method.new submit_job_config
                    submit_job_as_operation_config = parent_rpcs.submit_job_as_operation if parent_rpcs.respond_to? :submit_job_as_operation
                    @submit_job_as_operation = ::Gapic::Config::Method.new submit_job_as_operation_config
                    get_job_config = parent_rpcs.get_job if parent_rpcs.respond_to? :get_job
                    @get_job = ::Gapic::Config::Method.new get_job_config
                    list_jobs_config = parent_rpcs.list_jobs if parent_rpcs.respond_to? :list_jobs
                    @list_jobs = ::Gapic::Config::Method.new list_jobs_config
                    update_job_config = parent_rpcs.update_job if parent_rpcs.respond_to? :update_job
                    @update_job = ::Gapic::Config::Method.new update_job_config
                    cancel_job_config = parent_rpcs.cancel_job if parent_rpcs.respond_to? :cancel_job
                    @cancel_job = ::Gapic::Config::Method.new cancel_job_config
                    delete_job_config = parent_rpcs.delete_job if parent_rpcs.respond_to? :delete_job
                    @delete_job = ::Gapic::Config::Method.new delete_job_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
