# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dataproc/v1/clusters_pb"
require "google/cloud/dataproc/v1/cluster_controller/rest/service_stub"
require "google/iam/v1/rest"

module Google
  module Cloud
    module Dataproc
      module V1
        module ClusterController
          module Rest
            ##
            # REST client for the ClusterController service.
            #
            # The ClusterControllerService provides methods to manage clusters
            # of Compute Engine instances.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "dataproc.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :cluster_controller_stub

              ##
              # Configure the ClusterController Client class.
              #
              # See {::Google::Cloud::Dataproc::V1::ClusterController::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all ClusterController clients
              #   ::Google::Cloud::Dataproc::V1::ClusterController::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Dataproc", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_cluster.timeout = 300.0
                  default_config.rpcs.create_cluster.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.update_cluster.timeout = 300.0
                  default_config.rpcs.update_cluster.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.delete_cluster.timeout = 300.0
                  default_config.rpcs.delete_cluster.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_cluster.timeout = 300.0
                  default_config.rpcs.get_cluster.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [13, 4, 14]
                  }

                  default_config.rpcs.list_clusters.timeout = 300.0
                  default_config.rpcs.list_clusters.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [13, 4, 14]
                  }

                  default_config.rpcs.diagnose_cluster.timeout = 300.0
                  default_config.rpcs.diagnose_cluster.retry_policy = {
                    initial_delay: 0.1, max_delay: 60.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the ClusterController Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Dataproc::V1::ClusterController::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @cluster_controller_stub.universe_domain
              end

              ##
              # Create a new ClusterController REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Dataproc::V1::ClusterController::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Dataproc::V1::ClusterController::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the ClusterController client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Dataproc::V1::ClusterController::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @cluster_controller_stub = ::Google::Cloud::Dataproc::V1::ClusterController::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @cluster_controller_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @cluster_controller_stub.endpoint
                  config.universe_domain = @cluster_controller_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @cluster_controller_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Dataproc::V1::ClusterController::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @cluster_controller_stub.logger
              end

              # Service calls

              ##
              # Creates a cluster in a project. The returned
              # {::Google::Longrunning::Operation#metadata Operation.metadata} will be
              # [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
              #
              # @overload create_cluster(request, options = nil)
              #   Pass arguments to `create_cluster` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::CreateClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::CreateClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_cluster(project_id: nil, region: nil, cluster: nil, request_id: nil, action_on_failed_primary_workers: nil)
              #   Pass arguments to `create_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project that the cluster
              #     belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param cluster [::Google::Cloud::Dataproc::V1::Cluster, ::Hash]
              #     Required. The cluster to create.
              #   @param request_id [::String]
              #     Optional. A unique ID used to identify the request. If the server receives
              #     two
              #     [CreateClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateClusterRequest)s
              #     with the same id, then the second request will be ignored and the
              #     first {::Google::Longrunning::Operation google.longrunning.Operation} created
              #     and stored in the backend is returned.
              #
              #     It is recommended to always set this value to a
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
              #
              #     The ID must contain only letters (a-z, A-Z), numbers (0-9),
              #     underscores (_), and hyphens (-). The maximum length is 40 characters.
              #   @param action_on_failed_primary_workers [::Google::Cloud::Dataproc::V1::FailureAction]
              #     Optional. Failure action when primary worker creation fails.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::ClusterController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::CreateClusterRequest.new
              #
              #   # Call the create_cluster method.
              #   result = client.create_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::CreateClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cluster_controller_stub.create_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a cluster in a project. The returned
              # {::Google::Longrunning::Operation#metadata Operation.metadata} will be
              # [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
              # The cluster must be in a
              # {::Google::Cloud::Dataproc::V1::ClusterStatus::State `RUNNING`} state or an error
              # is returned.
              #
              # @overload update_cluster(request, options = nil)
              #   Pass arguments to `update_cluster` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::UpdateClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::UpdateClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_cluster(project_id: nil, region: nil, cluster_name: nil, cluster: nil, graceful_decommission_timeout: nil, update_mask: nil, request_id: nil)
              #   Pass arguments to `update_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project the
              #     cluster belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param cluster_name [::String]
              #     Required. The cluster name.
              #   @param cluster [::Google::Cloud::Dataproc::V1::Cluster, ::Hash]
              #     Required. The changes to the cluster.
              #   @param graceful_decommission_timeout [::Google::Protobuf::Duration, ::Hash]
              #     Optional. Timeout for graceful YARN decommissioning. Graceful
              #     decommissioning allows removing nodes from the cluster without
              #     interrupting jobs in progress. Timeout specifies how long to wait for jobs
              #     in progress to finish before forcefully removing nodes (and potentially
              #     interrupting jobs). Default timeout is 0 (for forceful decommission), and
              #     the maximum allowed timeout is 1 day. (see JSON representation of
              #     [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json)).
              #
              #     Only supported on Dataproc image versions 1.2 and higher.
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Specifies the path, relative to `Cluster`, of
              #     the field to update. For example, to change the number of workers
              #     in a cluster to 5, the `update_mask` parameter would be
              #     specified as `config.worker_config.num_instances`,
              #     and the `PATCH` request body would specify the new value, as follows:
              #
              #         {
              #           "config":{
              #             "workerConfig":{
              #               "numInstances":"5"
              #             }
              #           }
              #         }
              #     Similarly, to change the number of preemptible workers in a cluster to 5,
              #     the `update_mask` parameter would be
              #     `config.secondary_worker_config.num_instances`, and the `PATCH` request
              #     body would be set as follows:
              #
              #         {
              #           "config":{
              #             "secondaryWorkerConfig":{
              #               "numInstances":"5"
              #             }
              #           }
              #         }
              #     <strong>Note:</strong> Currently, only the following fields can be updated:
              #
              #      <table>
              #      <tbody>
              #      <tr>
              #      <td><strong>Mask</strong></td>
              #      <td><strong>Purpose</strong></td>
              #      </tr>
              #      <tr>
              #      <td><strong><em>labels</em></strong></td>
              #      <td>Update labels</td>
              #      </tr>
              #      <tr>
              #      <td><strong><em>config.worker_config.num_instances</em></strong></td>
              #      <td>Resize primary worker group</td>
              #      </tr>
              #      <tr>
              #      <td><strong><em>config.secondary_worker_config.num_instances</em></strong></td>
              #      <td>Resize secondary worker group</td>
              #      </tr>
              #      <tr>
              #      <td>config.autoscaling_config.policy_uri</td><td>Use, stop using, or
              #      change autoscaling policies</td>
              #      </tr>
              #      </tbody>
              #      </table>
              #   @param request_id [::String]
              #     Optional. A unique ID used to identify the request. If the server
              #     receives two
              #     [UpdateClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.UpdateClusterRequest)s
              #     with the same id, then the second request will be ignored and the
              #     first {::Google::Longrunning::Operation google.longrunning.Operation} created
              #     and stored in the backend is returned.
              #
              #     It is recommended to always set this value to a
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
              #
              #     The ID must contain only letters (a-z, A-Z), numbers (0-9),
              #     underscores (_), and hyphens (-). The maximum length is 40 characters.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::ClusterController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::UpdateClusterRequest.new
              #
              #   # Call the update_cluster method.
              #   result = client.update_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::UpdateClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cluster_controller_stub.update_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Stops a cluster in a project.
              #
              # @overload stop_cluster(request, options = nil)
              #   Pass arguments to `stop_cluster` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::StopClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::StopClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload stop_cluster(project_id: nil, region: nil, cluster_name: nil, cluster_uuid: nil, request_id: nil)
              #   Pass arguments to `stop_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project the
              #     cluster belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param cluster_name [::String]
              #     Required. The cluster name.
              #   @param cluster_uuid [::String]
              #     Optional. Specifying the `cluster_uuid` means the RPC will fail
              #     (with error NOT_FOUND) if a cluster with the specified UUID does not exist.
              #   @param request_id [::String]
              #     Optional. A unique ID used to identify the request. If the server
              #     receives two
              #     [StopClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.StopClusterRequest)s
              #     with the same id, then the second request will be ignored and the
              #     first {::Google::Longrunning::Operation google.longrunning.Operation} created
              #     and stored in the backend is returned.
              #
              #     Recommendation: Set this value to a
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
              #
              #     The ID must contain only letters (a-z, A-Z), numbers (0-9),
              #     underscores (_), and hyphens (-). The maximum length is 40 characters.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::ClusterController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::StopClusterRequest.new
              #
              #   # Call the stop_cluster method.
              #   result = client.stop_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def stop_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::StopClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.stop_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.stop_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.stop_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cluster_controller_stub.stop_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Starts a cluster in a project.
              #
              # @overload start_cluster(request, options = nil)
              #   Pass arguments to `start_cluster` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::StartClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::StartClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload start_cluster(project_id: nil, region: nil, cluster_name: nil, cluster_uuid: nil, request_id: nil)
              #   Pass arguments to `start_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project the
              #     cluster belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param cluster_name [::String]
              #     Required. The cluster name.
              #   @param cluster_uuid [::String]
              #     Optional. Specifying the `cluster_uuid` means the RPC will fail
              #     (with error NOT_FOUND) if a cluster with the specified UUID does not exist.
              #   @param request_id [::String]
              #     Optional. A unique ID used to identify the request. If the server
              #     receives two
              #     [StartClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.StartClusterRequest)s
              #     with the same id, then the second request will be ignored and the
              #     first {::Google::Longrunning::Operation google.longrunning.Operation} created
              #     and stored in the backend is returned.
              #
              #     Recommendation: Set this value to a
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
              #
              #     The ID must contain only letters (a-z, A-Z), numbers (0-9),
              #     underscores (_), and hyphens (-). The maximum length is 40 characters.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::ClusterController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::StartClusterRequest.new
              #
              #   # Call the start_cluster method.
              #   result = client.start_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def start_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::StartClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.start_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.start_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.start_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cluster_controller_stub.start_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a cluster in a project. The returned
              # {::Google::Longrunning::Operation#metadata Operation.metadata} will be
              # [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
              #
              # @overload delete_cluster(request, options = nil)
              #   Pass arguments to `delete_cluster` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::DeleteClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::DeleteClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_cluster(project_id: nil, region: nil, cluster_name: nil, cluster_uuid: nil, request_id: nil)
              #   Pass arguments to `delete_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project that the cluster
              #     belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param cluster_name [::String]
              #     Required. The cluster name.
              #   @param cluster_uuid [::String]
              #     Optional. Specifying the `cluster_uuid` means the RPC should fail
              #     (with error NOT_FOUND) if cluster with specified UUID does not exist.
              #   @param request_id [::String]
              #     Optional. A unique ID used to identify the request. If the server
              #     receives two
              #     [DeleteClusterRequest](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.DeleteClusterRequest)s
              #     with the same id, then the second request will be ignored and the
              #     first {::Google::Longrunning::Operation google.longrunning.Operation} created
              #     and stored in the backend is returned.
              #
              #     It is recommended to always set this value to a
              #     [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
              #
              #     The ID must contain only letters (a-z, A-Z), numbers (0-9),
              #     underscores (_), and hyphens (-). The maximum length is 40 characters.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::ClusterController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::DeleteClusterRequest.new
              #
              #   # Call the delete_cluster method.
              #   result = client.delete_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::DeleteClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cluster_controller_stub.delete_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets the resource representation for a cluster in a project.
              #
              # @overload get_cluster(request, options = nil)
              #   Pass arguments to `get_cluster` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::GetClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::GetClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_cluster(project_id: nil, region: nil, cluster_name: nil)
              #   Pass arguments to `get_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project that the cluster
              #     belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param cluster_name [::String]
              #     Required. The cluster name.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataproc::V1::Cluster]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataproc::V1::Cluster]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::ClusterController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::GetClusterRequest.new
              #
              #   # Call the get_cluster method.
              #   result = client.get_cluster request
              #
              #   # The returned object is of type Google::Cloud::Dataproc::V1::Cluster.
              #   p result
              #
              def get_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::GetClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cluster_controller_stub.get_cluster request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists all regions/\\{region}/clusters in a project alphabetically.
              #
              # @overload list_clusters(request, options = nil)
              #   Pass arguments to `list_clusters` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::ListClustersRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::ListClustersRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_clusters(project_id: nil, region: nil, filter: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_clusters` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project that the cluster
              #     belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param filter [::String]
              #     Optional. A filter constraining the clusters to list. Filters are
              #     case-sensitive and have the following syntax:
              #
              #     field = value [AND [field = value]] ...
              #
              #     where **field** is one of `status.state`, `clusterName`, or `labels.[KEY]`,
              #     and `[KEY]` is a label key. **value** can be `*` to match all values.
              #     `status.state` can be one of the following: `ACTIVE`, `INACTIVE`,
              #     `CREATING`, `RUNNING`, `ERROR`, `DELETING`, `UPDATING`, `STOPPING`, or
              #     `STOPPED`. `ACTIVE` contains the `CREATING`, `UPDATING`, and `RUNNING`
              #     states. `INACTIVE` contains the `DELETING`, `ERROR`, `STOPPING`, and
              #     `STOPPED` states. `clusterName` is the name of the cluster provided at
              #     creation time. Only the logical `AND` operator is supported;
              #     space-separated items are treated as having an implicit `AND` operator.
              #
              #     Example filter:
              #
              #     status.state = ACTIVE AND clusterName = mycluster
              #     AND labels.env = staging AND labels.starred = *
              #   @param page_size [::Integer]
              #     Optional. The standard List page size.
              #   @param page_token [::String]
              #     Optional. The standard List page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataproc::V1::Cluster>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataproc::V1::Cluster>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::ClusterController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::ListClustersRequest.new
              #
              #   # Call the list_clusters method.
              #   result = client.list_clusters request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataproc::V1::Cluster.
              #     p item
              #   end
              #
              def list_clusters request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::ListClustersRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_clusters.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_clusters.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_clusters.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cluster_controller_stub.list_clusters request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @cluster_controller_stub, :list_clusters, "clusters", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Gets cluster diagnostic information. The returned
              # {::Google::Longrunning::Operation#metadata Operation.metadata} will be
              # [ClusterOperationMetadata](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
              # After the operation completes,
              # {::Google::Longrunning::Operation#response Operation.response}
              # contains
              # [DiagnoseClusterResults](https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#diagnoseclusterresults).
              #
              # @overload diagnose_cluster(request, options = nil)
              #   Pass arguments to `diagnose_cluster` via a request object, either of type
              #   {::Google::Cloud::Dataproc::V1::DiagnoseClusterRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataproc::V1::DiagnoseClusterRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload diagnose_cluster(project_id: nil, region: nil, cluster_name: nil, tarball_gcs_dir: nil, tarball_access: nil, diagnosis_interval: nil, jobs: nil, yarn_application_ids: nil)
              #   Pass arguments to `diagnose_cluster` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param project_id [::String]
              #     Required. The ID of the Google Cloud Platform project that the cluster
              #     belongs to.
              #   @param region [::String]
              #     Required. The Dataproc region in which to handle the request.
              #   @param cluster_name [::String]
              #     Required. The cluster name.
              #   @param tarball_gcs_dir [::String]
              #     Optional. (Optional) The output Cloud Storage directory for the diagnostic
              #     tarball. If not specified, a task-specific directory in the cluster's
              #     staging bucket will be used.
              #   @param tarball_access [::Google::Cloud::Dataproc::V1::DiagnoseClusterRequest::TarballAccess]
              #     Optional. (Optional) The access type to the diagnostic tarball. If not
              #     specified, falls back to default access of the bucket
              #   @param diagnosis_interval [::Google::Type::Interval, ::Hash]
              #     Optional. Time interval in which diagnosis should be carried out on the
              #     cluster.
              #   @param jobs [::Array<::String>]
              #     Optional. Specifies a list of jobs on which diagnosis is to be performed.
              #     Format: projects/\\{project}/regions/\\{region}/jobs/\\{job}
              #   @param yarn_application_ids [::Array<::String>]
              #     Optional. Specifies a list of yarn applications on which diagnosis is to be
              #     performed.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataproc/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataproc::V1::ClusterController::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataproc::V1::DiagnoseClusterRequest.new
              #
              #   # Call the diagnose_cluster method.
              #   result = client.diagnose_cluster request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def diagnose_cluster request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataproc::V1::DiagnoseClusterRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.diagnose_cluster.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataproc::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.diagnose_cluster.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.diagnose_cluster.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @cluster_controller_stub.diagnose_cluster request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the ClusterController REST API.
              #
              # This class represents the configuration for ClusterController REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Dataproc::V1::ClusterController::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_cluster to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Dataproc::V1::ClusterController::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_cluster.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Dataproc::V1::ClusterController::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_cluster.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "dataproc.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the ClusterController API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_cluster
                  ##
                  # RPC-specific configuration for `update_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_cluster
                  ##
                  # RPC-specific configuration for `stop_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :stop_cluster
                  ##
                  # RPC-specific configuration for `start_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :start_cluster
                  ##
                  # RPC-specific configuration for `delete_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_cluster
                  ##
                  # RPC-specific configuration for `get_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_cluster
                  ##
                  # RPC-specific configuration for `list_clusters`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_clusters
                  ##
                  # RPC-specific configuration for `diagnose_cluster`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :diagnose_cluster

                  # @private
                  def initialize parent_rpcs = nil
                    create_cluster_config = parent_rpcs.create_cluster if parent_rpcs.respond_to? :create_cluster
                    @create_cluster = ::Gapic::Config::Method.new create_cluster_config
                    update_cluster_config = parent_rpcs.update_cluster if parent_rpcs.respond_to? :update_cluster
                    @update_cluster = ::Gapic::Config::Method.new update_cluster_config
                    stop_cluster_config = parent_rpcs.stop_cluster if parent_rpcs.respond_to? :stop_cluster
                    @stop_cluster = ::Gapic::Config::Method.new stop_cluster_config
                    start_cluster_config = parent_rpcs.start_cluster if parent_rpcs.respond_to? :start_cluster
                    @start_cluster = ::Gapic::Config::Method.new start_cluster_config
                    delete_cluster_config = parent_rpcs.delete_cluster if parent_rpcs.respond_to? :delete_cluster
                    @delete_cluster = ::Gapic::Config::Method.new delete_cluster_config
                    get_cluster_config = parent_rpcs.get_cluster if parent_rpcs.respond_to? :get_cluster
                    @get_cluster = ::Gapic::Config::Method.new get_cluster_config
                    list_clusters_config = parent_rpcs.list_clusters if parent_rpcs.respond_to? :list_clusters
                    @list_clusters = ::Gapic::Config::Method.new list_clusters_config
                    diagnose_cluster_config = parent_rpcs.diagnose_cluster if parent_rpcs.respond_to? :diagnose_cluster
                    @diagnose_cluster = ::Gapic::Config::Method.new diagnose_cluster_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
