# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

# Require this file early so that the version constant gets defined before
# requiring "google/cloud". This is because google-cloud-core will load the
# entrypoint (gem name) file, which in turn re-requires this file (hence
# causing a require cycle) unless the version constant is already defined.
require "google/cloud/dataplex/version"

require "googleauth"
gem "google-cloud-core"
require "google/cloud" unless defined? ::Google::Cloud.new
require "google/cloud/config"

# Set the default configuration
::Google::Cloud.configure.add_config! :dataplex do |config|
  config.add_field! :endpoint,      nil, match: ::String
  config.add_field! :credentials,   nil, match: [::String, ::Hash, ::Google::Auth::Credentials]
  config.add_field! :scope,         nil, match: [::Array, ::String]
  config.add_field! :lib_name,      nil, match: ::String
  config.add_field! :lib_version,   nil, match: ::String
  config.add_field! :interceptors,  nil, match: ::Array
  config.add_field! :timeout,       nil, match: ::Numeric
  config.add_field! :metadata,      nil, match: ::Hash
  config.add_field! :retry_policy,  nil, match: [::Hash, ::Proc]
  config.add_field! :quota_project, nil, match: ::String
  config.add_field! :universe_domain, nil, match: ::String
end

module Google
  module Cloud
    module Dataplex
      ##
      # Create a new client object for DataplexService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Dataplex::V1::DataplexService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dataplex-v1/latest/Google-Cloud-Dataplex-V1-DataplexService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the DataplexService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the DataplexService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Dataplex.dataplex_service_available?}.
      #
      # ## About DataplexService
      #
      # Dataplex service provides data lakes as a service. The primary resources
      # offered by this service are Lakes, Zones and Assets which collectively allow
      # a data administrator to organize, manage, secure and catalog data across
      # their organization located across cloud projects in a variety of storage
      # systems including Cloud Storage and BigQuery.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.dataplex_service version: :v1, transport: :grpc, &block
        require "google/cloud/dataplex/#{version.to_s.downcase}"

        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Dataplex.const_get(package_name).const_get(:DataplexService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the DataplexService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Dataplex.dataplex_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the DataplexService service,
      # or if the versioned client gem needs an update to support the DataplexService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.dataplex_service_available? version: :v1, transport: :grpc
        require "google/cloud/dataplex/#{version.to_s.downcase}"
        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Dataplex.const_get package_name
        return false unless service_module.const_defined? :DataplexService
        service_module = service_module.const_get :DataplexService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for BusinessGlossaryService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dataplex-v1/latest/Google-Cloud-Dataplex-V1-BusinessGlossaryService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the BusinessGlossaryService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the BusinessGlossaryService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Dataplex.business_glossary_service_available?}.
      #
      # ## About BusinessGlossaryService
      #
      # BusinessGlossaryService provides APIs for managing business glossary
      # resources for enterprise customers.
      # The resources currently supported in Business Glossary are:
      # 1. Glossary
      # 2. GlossaryCategory
      # 3. GlossaryTerm
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.business_glossary_service version: :v1, transport: :grpc, &block
        require "google/cloud/dataplex/#{version.to_s.downcase}"

        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Dataplex.const_get(package_name).const_get(:BusinessGlossaryService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the BusinessGlossaryService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Dataplex.business_glossary_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the BusinessGlossaryService service,
      # or if the versioned client gem needs an update to support the BusinessGlossaryService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.business_glossary_service_available? version: :v1, transport: :grpc
        require "google/cloud/dataplex/#{version.to_s.downcase}"
        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Dataplex.const_get package_name
        return false unless service_module.const_defined? :BusinessGlossaryService
        service_module = service_module.const_get :BusinessGlossaryService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for CatalogService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Dataplex::V1::CatalogService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dataplex-v1/latest/Google-Cloud-Dataplex-V1-CatalogService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the CatalogService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the CatalogService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Dataplex.catalog_service_available?}.
      #
      # ## About CatalogService
      #
      # The primary resources offered by this service are EntryGroups, EntryTypes,
      # AspectTypes, Entries and EntryLinks. They collectively let data
      # administrators organize, manage, secure, and catalog data located across
      # cloud projects in their organization in a variety of storage systems,
      # including Cloud Storage and BigQuery.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.catalog_service version: :v1, transport: :grpc, &block
        require "google/cloud/dataplex/#{version.to_s.downcase}"

        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Dataplex.const_get(package_name).const_get(:CatalogService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the CatalogService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Dataplex.catalog_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the CatalogService service,
      # or if the versioned client gem needs an update to support the CatalogService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.catalog_service_available? version: :v1, transport: :grpc
        require "google/cloud/dataplex/#{version.to_s.downcase}"
        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Dataplex.const_get package_name
        return false unless service_module.const_defined? :CatalogService
        service_module = service_module.const_get :CatalogService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for CmekService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Dataplex::V1::CmekService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dataplex-v1/latest/Google-Cloud-Dataplex-V1-CmekService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the CmekService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the CmekService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Dataplex.cmek_service_available?}.
      #
      # ## About CmekService
      #
      # Dataplex Universal Catalog Customer Managed Encryption Keys (CMEK) Service
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.cmek_service version: :v1, transport: :grpc, &block
        require "google/cloud/dataplex/#{version.to_s.downcase}"

        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Dataplex.const_get(package_name).const_get(:CmekService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the CmekService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Dataplex.cmek_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the CmekService service,
      # or if the versioned client gem needs an update to support the CmekService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.cmek_service_available? version: :v1, transport: :grpc
        require "google/cloud/dataplex/#{version.to_s.downcase}"
        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Dataplex.const_get package_name
        return false unless service_module.const_defined? :CmekService
        service_module = service_module.const_get :CmekService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for ContentService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Dataplex::V1::ContentService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dataplex-v1/latest/Google-Cloud-Dataplex-V1-ContentService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the ContentService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the ContentService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Dataplex.content_service_available?}.
      #
      # ## About ContentService
      #
      # ContentService manages Notebook and SQL Scripts for Dataplex Universal
      # Catalog.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.content_service version: :v1, transport: :grpc, &block
        require "google/cloud/dataplex/#{version.to_s.downcase}"

        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Dataplex.const_get(package_name).const_get(:ContentService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the ContentService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Dataplex.content_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the ContentService service,
      # or if the versioned client gem needs an update to support the ContentService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.content_service_available? version: :v1, transport: :grpc
        require "google/cloud/dataplex/#{version.to_s.downcase}"
        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Dataplex.const_get package_name
        return false unless service_module.const_defined? :ContentService
        service_module = service_module.const_get :ContentService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for DataTaxonomyService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Dataplex::V1::DataTaxonomyService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dataplex-v1/latest/Google-Cloud-Dataplex-V1-DataTaxonomyService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the DataTaxonomyService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the DataTaxonomyService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Dataplex.data_taxonomy_service_available?}.
      #
      # ## About DataTaxonomyService
      #
      # DataTaxonomyService enables attribute-based governance. The resources
      # currently offered include DataTaxonomy and DataAttribute.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.data_taxonomy_service version: :v1, transport: :grpc, &block
        require "google/cloud/dataplex/#{version.to_s.downcase}"

        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Dataplex.const_get(package_name).const_get(:DataTaxonomyService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the DataTaxonomyService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Dataplex.data_taxonomy_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the DataTaxonomyService service,
      # or if the versioned client gem needs an update to support the DataTaxonomyService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.data_taxonomy_service_available? version: :v1, transport: :grpc
        require "google/cloud/dataplex/#{version.to_s.downcase}"
        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Dataplex.const_get package_name
        return false unless service_module.const_defined? :DataTaxonomyService
        service_module = service_module.const_get :DataTaxonomyService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for DataScanService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Dataplex::V1::DataScanService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dataplex-v1/latest/Google-Cloud-Dataplex-V1-DataScanService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the DataScanService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the DataScanService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Dataplex.data_scan_service_available?}.
      #
      # ## About DataScanService
      #
      # DataScanService manages DataScan resources which can be configured to run
      # various types of data scanning workload and generate enriched metadata (e.g.
      # Data Profile, Data Quality) for the data source.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.data_scan_service version: :v1, transport: :grpc, &block
        require "google/cloud/dataplex/#{version.to_s.downcase}"

        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Dataplex.const_get(package_name).const_get(:DataScanService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the DataScanService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Dataplex.data_scan_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the DataScanService service,
      # or if the versioned client gem needs an update to support the DataScanService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.data_scan_service_available? version: :v1, transport: :grpc
        require "google/cloud/dataplex/#{version.to_s.downcase}"
        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Dataplex.const_get package_name
        return false unless service_module.const_defined? :DataScanService
        service_module = service_module.const_get :DataScanService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Create a new client object for MetadataService.
      #
      # By default, this returns an instance of
      # [Google::Cloud::Dataplex::V1::MetadataService::Client](https://cloud.google.com/ruby/docs/reference/google-cloud-dataplex-v1/latest/Google-Cloud-Dataplex-V1-MetadataService-Client)
      # for a gRPC client for version V1 of the API.
      # However, you can specify a different API version by passing it in the
      # `version` parameter. If the MetadataService service is
      # supported by that API version, and the corresponding gem is available, the
      # appropriate versioned client will be returned.
      # You can also specify a different transport by passing `:rest` or `:grpc` in
      # the `transport` parameter.
      #
      # Raises an exception if the currently installed versioned client gem for the
      # given API version does not support the given transport of the MetadataService service.
      # You can determine whether the method will succeed by calling
      # {Google::Cloud::Dataplex.metadata_service_available?}.
      #
      # ## About MetadataService
      #
      # Metadata service manages metadata resources such as tables, filesets and
      # partitions.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [::Object] A client object for the specified version.
      #
      def self.metadata_service version: :v1, transport: :grpc, &block
        require "google/cloud/dataplex/#{version.to_s.downcase}"

        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        service_module = Google::Cloud::Dataplex.const_get(package_name).const_get(:MetadataService)
        service_module = service_module.const_get(:Rest) if transport == :rest
        service_module.const_get(:Client).new(&block)
      end

      ##
      # Determines whether the MetadataService service is supported by the current client.
      # If true, you can retrieve a client object by calling {Google::Cloud::Dataplex.metadata_service}.
      # If false, that method will raise an exception. This could happen if the given
      # API version does not exist or does not support the MetadataService service,
      # or if the versioned client gem needs an update to support the MetadataService service.
      #
      # @param version [::String, ::Symbol] The API version to connect to. Optional.
      #   Defaults to `:v1`.
      # @param transport [:grpc, :rest] The transport to use. Defaults to `:grpc`.
      # @return [boolean] Whether the service is available.
      #
      def self.metadata_service_available? version: :v1, transport: :grpc
        require "google/cloud/dataplex/#{version.to_s.downcase}"
        package_name = Google::Cloud::Dataplex
                       .constants
                       .select { |sym| sym.to_s.downcase == version.to_s.downcase.tr("_", "") }
                       .first
        return false unless package_name
        service_module = Google::Cloud::Dataplex.const_get package_name
        return false unless service_module.const_defined? :MetadataService
        service_module = service_module.const_get :MetadataService
        if transport == :rest
          return false unless service_module.const_defined? :Rest
          service_module = service_module.const_get :Rest
        end
        service_module.const_defined? :Client
      rescue ::LoadError
        false
      end

      ##
      # Configure the google-cloud-dataplex library.
      #
      # The following configuration parameters are supported:
      #
      # * `credentials` (*type:* `String, Hash, Google::Auth::Credentials`) -
      #   The path to the keyfile as a String, the contents of the keyfile as a
      #   Hash, or a Google::Auth::Credentials object.
      # * `lib_name` (*type:* `String`) -
      #   The library name as recorded in instrumentation and logging.
      # * `lib_version` (*type:* `String`) -
      #   The library version as recorded in instrumentation and logging.
      # * `interceptors` (*type:* `Array<GRPC::ClientInterceptor>`) -
      #   An array of interceptors that are run before calls are executed.
      # * `timeout` (*type:* `Numeric`) -
      #   Default timeout in seconds.
      # * `metadata` (*type:* `Hash{Symbol=>String}`) -
      #   Additional headers to be sent with the call.
      # * `retry_policy` (*type:* `Hash`) -
      #   The retry policy. The value is a hash with the following keys:
      #     * `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
      #     * `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
      #     * `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
      #     * `:retry_codes` (*type:* `Array<String>`) -
      #       The error codes that should trigger a retry.
      #
      # @return [::Google::Cloud::Config] The default configuration used by this library
      #
      def self.configure
        yield ::Google::Cloud.configure.dataplex if block_given?

        ::Google::Cloud.configure.dataplex
      end
    end
  end
end

helper_path = ::File.join __dir__, "dataplex", "helpers.rb"
require "google/cloud/dataplex/helpers" if ::File.file? helper_path
