# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/dataplex/v1/data_taxonomy_pb"
require "google/cloud/dataplex/v1/data_taxonomy_service"

class ::Google::Cloud::Dataplex::V1::DataTaxonomyService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_data_taxonomy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_taxonomy_id = "hello world"
    data_taxonomy = {}
    validate_only = true

    create_data_taxonomy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_data_taxonomy, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::CreateDataTaxonomyRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["data_taxonomy_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::DataTaxonomy), request["data_taxonomy"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_data_taxonomy_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_data_taxonomy({ parent: parent, data_taxonomy_id: data_taxonomy_id, data_taxonomy: data_taxonomy, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_data_taxonomy parent: parent, data_taxonomy_id: data_taxonomy_id, data_taxonomy: data_taxonomy, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_data_taxonomy ::Google::Cloud::Dataplex::V1::CreateDataTaxonomyRequest.new(parent: parent, data_taxonomy_id: data_taxonomy_id, data_taxonomy: data_taxonomy, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_data_taxonomy({ parent: parent, data_taxonomy_id: data_taxonomy_id, data_taxonomy: data_taxonomy, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_data_taxonomy(::Google::Cloud::Dataplex::V1::CreateDataTaxonomyRequest.new(parent: parent, data_taxonomy_id: data_taxonomy_id, data_taxonomy: data_taxonomy, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_data_taxonomy_client_stub.call_rpc_count
    end
  end

  def test_update_data_taxonomy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    data_taxonomy = {}
    validate_only = true

    update_data_taxonomy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_data_taxonomy, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::UpdateDataTaxonomyRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::DataTaxonomy), request["data_taxonomy"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_data_taxonomy_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_data_taxonomy({ update_mask: update_mask, data_taxonomy: data_taxonomy, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_data_taxonomy update_mask: update_mask, data_taxonomy: data_taxonomy, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_data_taxonomy ::Google::Cloud::Dataplex::V1::UpdateDataTaxonomyRequest.new(update_mask: update_mask, data_taxonomy: data_taxonomy, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_data_taxonomy({ update_mask: update_mask, data_taxonomy: data_taxonomy, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_data_taxonomy(::Google::Cloud::Dataplex::V1::UpdateDataTaxonomyRequest.new(update_mask: update_mask, data_taxonomy: data_taxonomy, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_data_taxonomy_client_stub.call_rpc_count
    end
  end

  def test_delete_data_taxonomy
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_data_taxonomy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_data_taxonomy, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::DeleteDataTaxonomyRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_data_taxonomy_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_data_taxonomy({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_data_taxonomy name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_data_taxonomy ::Google::Cloud::Dataplex::V1::DeleteDataTaxonomyRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_data_taxonomy({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_data_taxonomy(::Google::Cloud::Dataplex::V1::DeleteDataTaxonomyRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_data_taxonomy_client_stub.call_rpc_count
    end
  end

  def test_list_data_taxonomies
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::ListDataTaxonomiesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_data_taxonomies_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_data_taxonomies, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::ListDataTaxonomiesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_data_taxonomies_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_data_taxonomies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_data_taxonomies parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_data_taxonomies ::Google::Cloud::Dataplex::V1::ListDataTaxonomiesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_data_taxonomies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_data_taxonomies(::Google::Cloud::Dataplex::V1::ListDataTaxonomiesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_data_taxonomies_client_stub.call_rpc_count
    end
  end

  def test_get_data_taxonomy
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::DataTaxonomy.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_taxonomy_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_taxonomy, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::GetDataTaxonomyRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_taxonomy_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_taxonomy({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_taxonomy name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_taxonomy ::Google::Cloud::Dataplex::V1::GetDataTaxonomyRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_taxonomy({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_taxonomy(::Google::Cloud::Dataplex::V1::GetDataTaxonomyRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_taxonomy_client_stub.call_rpc_count
    end
  end

  def test_create_data_attribute_binding
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_attribute_binding_id = "hello world"
    data_attribute_binding = {}
    validate_only = true

    create_data_attribute_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_data_attribute_binding, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::CreateDataAttributeBindingRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["data_attribute_binding_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::DataAttributeBinding), request["data_attribute_binding"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_data_attribute_binding_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_data_attribute_binding({ parent: parent, data_attribute_binding_id: data_attribute_binding_id, data_attribute_binding: data_attribute_binding, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_data_attribute_binding parent: parent, data_attribute_binding_id: data_attribute_binding_id, data_attribute_binding: data_attribute_binding, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_data_attribute_binding ::Google::Cloud::Dataplex::V1::CreateDataAttributeBindingRequest.new(parent: parent, data_attribute_binding_id: data_attribute_binding_id, data_attribute_binding: data_attribute_binding, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_data_attribute_binding({ parent: parent, data_attribute_binding_id: data_attribute_binding_id, data_attribute_binding: data_attribute_binding, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_data_attribute_binding(::Google::Cloud::Dataplex::V1::CreateDataAttributeBindingRequest.new(parent: parent, data_attribute_binding_id: data_attribute_binding_id, data_attribute_binding: data_attribute_binding, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_data_attribute_binding_client_stub.call_rpc_count
    end
  end

  def test_update_data_attribute_binding
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    data_attribute_binding = {}
    validate_only = true

    update_data_attribute_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_data_attribute_binding, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::UpdateDataAttributeBindingRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::DataAttributeBinding), request["data_attribute_binding"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_data_attribute_binding_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_data_attribute_binding({ update_mask: update_mask, data_attribute_binding: data_attribute_binding, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_data_attribute_binding update_mask: update_mask, data_attribute_binding: data_attribute_binding, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_data_attribute_binding ::Google::Cloud::Dataplex::V1::UpdateDataAttributeBindingRequest.new(update_mask: update_mask, data_attribute_binding: data_attribute_binding, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_data_attribute_binding({ update_mask: update_mask, data_attribute_binding: data_attribute_binding, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_data_attribute_binding(::Google::Cloud::Dataplex::V1::UpdateDataAttributeBindingRequest.new(update_mask: update_mask, data_attribute_binding: data_attribute_binding, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_data_attribute_binding_client_stub.call_rpc_count
    end
  end

  def test_delete_data_attribute_binding
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_data_attribute_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_data_attribute_binding, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::DeleteDataAttributeBindingRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_data_attribute_binding_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_data_attribute_binding({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_data_attribute_binding name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_data_attribute_binding ::Google::Cloud::Dataplex::V1::DeleteDataAttributeBindingRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_data_attribute_binding({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_data_attribute_binding(::Google::Cloud::Dataplex::V1::DeleteDataAttributeBindingRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_data_attribute_binding_client_stub.call_rpc_count
    end
  end

  def test_list_data_attribute_bindings
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::ListDataAttributeBindingsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_data_attribute_bindings_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_data_attribute_bindings, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::ListDataAttributeBindingsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_data_attribute_bindings_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_data_attribute_bindings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_data_attribute_bindings parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_data_attribute_bindings ::Google::Cloud::Dataplex::V1::ListDataAttributeBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_data_attribute_bindings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_data_attribute_bindings(::Google::Cloud::Dataplex::V1::ListDataAttributeBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_data_attribute_bindings_client_stub.call_rpc_count
    end
  end

  def test_get_data_attribute_binding
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::DataAttributeBinding.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_attribute_binding_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_attribute_binding, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::GetDataAttributeBindingRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_attribute_binding_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_attribute_binding({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_attribute_binding name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_attribute_binding ::Google::Cloud::Dataplex::V1::GetDataAttributeBindingRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_attribute_binding({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_attribute_binding(::Google::Cloud::Dataplex::V1::GetDataAttributeBindingRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_attribute_binding_client_stub.call_rpc_count
    end
  end

  def test_create_data_attribute
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_attribute_id = "hello world"
    data_attribute = {}
    validate_only = true

    create_data_attribute_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_data_attribute, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::CreateDataAttributeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["data_attribute_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::DataAttribute), request["data_attribute"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_data_attribute_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_data_attribute({ parent: parent, data_attribute_id: data_attribute_id, data_attribute: data_attribute, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_data_attribute parent: parent, data_attribute_id: data_attribute_id, data_attribute: data_attribute, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_data_attribute ::Google::Cloud::Dataplex::V1::CreateDataAttributeRequest.new(parent: parent, data_attribute_id: data_attribute_id, data_attribute: data_attribute, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_data_attribute({ parent: parent, data_attribute_id: data_attribute_id, data_attribute: data_attribute, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_data_attribute(::Google::Cloud::Dataplex::V1::CreateDataAttributeRequest.new(parent: parent, data_attribute_id: data_attribute_id, data_attribute: data_attribute, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_data_attribute_client_stub.call_rpc_count
    end
  end

  def test_update_data_attribute
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    data_attribute = {}
    validate_only = true

    update_data_attribute_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_data_attribute, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::UpdateDataAttributeRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::DataAttribute), request["data_attribute"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_data_attribute_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_data_attribute({ update_mask: update_mask, data_attribute: data_attribute, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_data_attribute update_mask: update_mask, data_attribute: data_attribute, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_data_attribute ::Google::Cloud::Dataplex::V1::UpdateDataAttributeRequest.new(update_mask: update_mask, data_attribute: data_attribute, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_data_attribute({ update_mask: update_mask, data_attribute: data_attribute, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_data_attribute(::Google::Cloud::Dataplex::V1::UpdateDataAttributeRequest.new(update_mask: update_mask, data_attribute: data_attribute, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_data_attribute_client_stub.call_rpc_count
    end
  end

  def test_delete_data_attribute
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_data_attribute_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_data_attribute, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::DeleteDataAttributeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_data_attribute_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_data_attribute({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_data_attribute name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_data_attribute ::Google::Cloud::Dataplex::V1::DeleteDataAttributeRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_data_attribute({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_data_attribute(::Google::Cloud::Dataplex::V1::DeleteDataAttributeRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_data_attribute_client_stub.call_rpc_count
    end
  end

  def test_list_data_attributes
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::ListDataAttributesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_data_attributes_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_data_attributes, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::ListDataAttributesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_data_attributes_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_data_attributes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_data_attributes parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_data_attributes ::Google::Cloud::Dataplex::V1::ListDataAttributesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_data_attributes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_data_attributes(::Google::Cloud::Dataplex::V1::ListDataAttributesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_data_attributes_client_stub.call_rpc_count
    end
  end

  def test_get_data_attribute
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::DataAttribute.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_attribute_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_data_attribute, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::GetDataAttributeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_data_attribute_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_data_attribute({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_data_attribute name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_data_attribute ::Google::Cloud::Dataplex::V1::GetDataAttributeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_data_attribute({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_data_attribute(::Google::Cloud::Dataplex::V1::GetDataAttributeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_data_attribute_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Operations, client.operations_client
  end
end
