# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/dataplex/v1/data_taxonomy_pb"
require "google/cloud/dataplex/v1/data_taxonomy_service/rest"


class ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_data_taxonomy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_taxonomy_id = "hello world"
    data_taxonomy = {}
    validate_only = true

    create_data_taxonomy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_create_data_taxonomy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_data_taxonomy_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_data_taxonomy({ parent: parent, data_taxonomy_id: data_taxonomy_id, data_taxonomy: data_taxonomy, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_data_taxonomy parent: parent, data_taxonomy_id: data_taxonomy_id, data_taxonomy: data_taxonomy, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_data_taxonomy ::Google::Cloud::Dataplex::V1::CreateDataTaxonomyRequest.new(parent: parent, data_taxonomy_id: data_taxonomy_id, data_taxonomy: data_taxonomy, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_data_taxonomy({ parent: parent, data_taxonomy_id: data_taxonomy_id, data_taxonomy: data_taxonomy, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_data_taxonomy(::Google::Cloud::Dataplex::V1::CreateDataTaxonomyRequest.new(parent: parent, data_taxonomy_id: data_taxonomy_id, data_taxonomy: data_taxonomy, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_data_taxonomy_client_stub.call_count
      end
    end
  end

  def test_update_data_taxonomy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    data_taxonomy = {}
    validate_only = true

    update_data_taxonomy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_update_data_taxonomy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_data_taxonomy_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_data_taxonomy({ update_mask: update_mask, data_taxonomy: data_taxonomy, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_data_taxonomy update_mask: update_mask, data_taxonomy: data_taxonomy, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_data_taxonomy ::Google::Cloud::Dataplex::V1::UpdateDataTaxonomyRequest.new(update_mask: update_mask, data_taxonomy: data_taxonomy, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_data_taxonomy({ update_mask: update_mask, data_taxonomy: data_taxonomy, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_data_taxonomy(::Google::Cloud::Dataplex::V1::UpdateDataTaxonomyRequest.new(update_mask: update_mask, data_taxonomy: data_taxonomy, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_data_taxonomy_client_stub.call_count
      end
    end
  end

  def test_delete_data_taxonomy
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_data_taxonomy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_delete_data_taxonomy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_data_taxonomy_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_data_taxonomy({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_data_taxonomy name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_data_taxonomy ::Google::Cloud::Dataplex::V1::DeleteDataTaxonomyRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_data_taxonomy({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_data_taxonomy(::Google::Cloud::Dataplex::V1::DeleteDataTaxonomyRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_data_taxonomy_client_stub.call_count
      end
    end
  end

  def test_list_data_taxonomies
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::ListDataTaxonomiesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_data_taxonomies_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_list_data_taxonomies_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_data_taxonomies_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_data_taxonomies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_data_taxonomies parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_data_taxonomies ::Google::Cloud::Dataplex::V1::ListDataTaxonomiesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_data_taxonomies({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_data_taxonomies(::Google::Cloud::Dataplex::V1::ListDataTaxonomiesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_data_taxonomies_client_stub.call_count
      end
    end
  end

  def test_get_data_taxonomy
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::DataTaxonomy.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_taxonomy_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_get_data_taxonomy_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_data_taxonomy_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_data_taxonomy({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_data_taxonomy name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_data_taxonomy ::Google::Cloud::Dataplex::V1::GetDataTaxonomyRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_data_taxonomy({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_data_taxonomy(::Google::Cloud::Dataplex::V1::GetDataTaxonomyRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_data_taxonomy_client_stub.call_count
      end
    end
  end

  def test_create_data_attribute_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_attribute_binding_id = "hello world"
    data_attribute_binding = {}
    validate_only = true

    create_data_attribute_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_create_data_attribute_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_data_attribute_binding_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_data_attribute_binding({ parent: parent, data_attribute_binding_id: data_attribute_binding_id, data_attribute_binding: data_attribute_binding, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_data_attribute_binding parent: parent, data_attribute_binding_id: data_attribute_binding_id, data_attribute_binding: data_attribute_binding, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_data_attribute_binding ::Google::Cloud::Dataplex::V1::CreateDataAttributeBindingRequest.new(parent: parent, data_attribute_binding_id: data_attribute_binding_id, data_attribute_binding: data_attribute_binding, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_data_attribute_binding({ parent: parent, data_attribute_binding_id: data_attribute_binding_id, data_attribute_binding: data_attribute_binding, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_data_attribute_binding(::Google::Cloud::Dataplex::V1::CreateDataAttributeBindingRequest.new(parent: parent, data_attribute_binding_id: data_attribute_binding_id, data_attribute_binding: data_attribute_binding, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_data_attribute_binding_client_stub.call_count
      end
    end
  end

  def test_update_data_attribute_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    data_attribute_binding = {}
    validate_only = true

    update_data_attribute_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_update_data_attribute_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_data_attribute_binding_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_data_attribute_binding({ update_mask: update_mask, data_attribute_binding: data_attribute_binding, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_data_attribute_binding update_mask: update_mask, data_attribute_binding: data_attribute_binding, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_data_attribute_binding ::Google::Cloud::Dataplex::V1::UpdateDataAttributeBindingRequest.new(update_mask: update_mask, data_attribute_binding: data_attribute_binding, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_data_attribute_binding({ update_mask: update_mask, data_attribute_binding: data_attribute_binding, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_data_attribute_binding(::Google::Cloud::Dataplex::V1::UpdateDataAttributeBindingRequest.new(update_mask: update_mask, data_attribute_binding: data_attribute_binding, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_data_attribute_binding_client_stub.call_count
      end
    end
  end

  def test_delete_data_attribute_binding
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_data_attribute_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_delete_data_attribute_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_data_attribute_binding_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_data_attribute_binding({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_data_attribute_binding name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_data_attribute_binding ::Google::Cloud::Dataplex::V1::DeleteDataAttributeBindingRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_data_attribute_binding({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_data_attribute_binding(::Google::Cloud::Dataplex::V1::DeleteDataAttributeBindingRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_data_attribute_binding_client_stub.call_count
      end
    end
  end

  def test_list_data_attribute_bindings
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::ListDataAttributeBindingsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_data_attribute_bindings_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_list_data_attribute_bindings_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_data_attribute_bindings_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_data_attribute_bindings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_data_attribute_bindings parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_data_attribute_bindings ::Google::Cloud::Dataplex::V1::ListDataAttributeBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_data_attribute_bindings({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_data_attribute_bindings(::Google::Cloud::Dataplex::V1::ListDataAttributeBindingsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_data_attribute_bindings_client_stub.call_count
      end
    end
  end

  def test_get_data_attribute_binding
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::DataAttributeBinding.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_attribute_binding_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_get_data_attribute_binding_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_data_attribute_binding_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_data_attribute_binding({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_data_attribute_binding name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_data_attribute_binding ::Google::Cloud::Dataplex::V1::GetDataAttributeBindingRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_data_attribute_binding({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_data_attribute_binding(::Google::Cloud::Dataplex::V1::GetDataAttributeBindingRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_data_attribute_binding_client_stub.call_count
      end
    end
  end

  def test_create_data_attribute
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    data_attribute_id = "hello world"
    data_attribute = {}
    validate_only = true

    create_data_attribute_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_create_data_attribute_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_data_attribute_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_data_attribute({ parent: parent, data_attribute_id: data_attribute_id, data_attribute: data_attribute, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_data_attribute parent: parent, data_attribute_id: data_attribute_id, data_attribute: data_attribute, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_data_attribute ::Google::Cloud::Dataplex::V1::CreateDataAttributeRequest.new(parent: parent, data_attribute_id: data_attribute_id, data_attribute: data_attribute, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_data_attribute({ parent: parent, data_attribute_id: data_attribute_id, data_attribute: data_attribute, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_data_attribute(::Google::Cloud::Dataplex::V1::CreateDataAttributeRequest.new(parent: parent, data_attribute_id: data_attribute_id, data_attribute: data_attribute, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_data_attribute_client_stub.call_count
      end
    end
  end

  def test_update_data_attribute
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    update_mask = {}
    data_attribute = {}
    validate_only = true

    update_data_attribute_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_update_data_attribute_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_data_attribute_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_data_attribute({ update_mask: update_mask, data_attribute: data_attribute, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_data_attribute update_mask: update_mask, data_attribute: data_attribute, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_data_attribute ::Google::Cloud::Dataplex::V1::UpdateDataAttributeRequest.new(update_mask: update_mask, data_attribute: data_attribute, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_data_attribute({ update_mask: update_mask, data_attribute: data_attribute, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_data_attribute(::Google::Cloud::Dataplex::V1::UpdateDataAttributeRequest.new(update_mask: update_mask, data_attribute: data_attribute, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_data_attribute_client_stub.call_count
      end
    end
  end

  def test_delete_data_attribute
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_data_attribute_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_delete_data_attribute_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_data_attribute_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_data_attribute({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_data_attribute name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_data_attribute ::Google::Cloud::Dataplex::V1::DeleteDataAttributeRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_data_attribute({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_data_attribute(::Google::Cloud::Dataplex::V1::DeleteDataAttributeRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_data_attribute_client_stub.call_count
      end
    end
  end

  def test_list_data_attributes
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::ListDataAttributesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_data_attributes_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_list_data_attributes_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_data_attributes_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_data_attributes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_data_attributes parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_data_attributes ::Google::Cloud::Dataplex::V1::ListDataAttributesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_data_attributes({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_data_attributes(::Google::Cloud::Dataplex::V1::ListDataAttributesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_data_attributes_client_stub.call_count
      end
    end
  end

  def test_get_data_attribute
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::DataAttribute.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_data_attribute_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::ServiceStub.stub :transcode_get_data_attribute_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_data_attribute_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_data_attribute({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_data_attribute name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_data_attribute ::Google::Cloud::Dataplex::V1::GetDataAttributeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_data_attribute({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_data_attribute(::Google::Cloud::Dataplex::V1::GetDataAttributeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_data_attribute_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dataplex::V1::DataTaxonomyService::Rest::Client::Configuration, config
  end
end
