# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/dataplex/v1/catalog_pb"
require "google/cloud/dataplex/v1/catalog_service"

class ::Google::Cloud::Dataplex::V1::CatalogService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_entry_type
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entry_type_id = "hello world"
    entry_type = {}
    validate_only = true

    create_entry_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_entry_type, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::CreateEntryTypeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["entry_type_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::EntryType), request["entry_type"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_entry_type_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_entry_type({ parent: parent, entry_type_id: entry_type_id, entry_type: entry_type, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_entry_type parent: parent, entry_type_id: entry_type_id, entry_type: entry_type, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_entry_type ::Google::Cloud::Dataplex::V1::CreateEntryTypeRequest.new(parent: parent, entry_type_id: entry_type_id, entry_type: entry_type, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_entry_type({ parent: parent, entry_type_id: entry_type_id, entry_type: entry_type, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_entry_type(::Google::Cloud::Dataplex::V1::CreateEntryTypeRequest.new(parent: parent, entry_type_id: entry_type_id, entry_type: entry_type, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_entry_type_client_stub.call_rpc_count
    end
  end

  def test_update_entry_type
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    entry_type = {}
    update_mask = {}
    validate_only = true

    update_entry_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_entry_type, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::UpdateEntryTypeRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::EntryType), request["entry_type"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_entry_type_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_entry_type({ entry_type: entry_type, update_mask: update_mask, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_entry_type entry_type: entry_type, update_mask: update_mask, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_entry_type ::Google::Cloud::Dataplex::V1::UpdateEntryTypeRequest.new(entry_type: entry_type, update_mask: update_mask, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_entry_type({ entry_type: entry_type, update_mask: update_mask, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_entry_type(::Google::Cloud::Dataplex::V1::UpdateEntryTypeRequest.new(entry_type: entry_type, update_mask: update_mask, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_entry_type_client_stub.call_rpc_count
    end
  end

  def test_delete_entry_type
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_entry_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_entry_type, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::DeleteEntryTypeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_entry_type_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_entry_type({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_entry_type name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_entry_type ::Google::Cloud::Dataplex::V1::DeleteEntryTypeRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_entry_type({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_entry_type(::Google::Cloud::Dataplex::V1::DeleteEntryTypeRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_entry_type_client_stub.call_rpc_count
    end
  end

  def test_list_entry_types
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::ListEntryTypesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_entry_types_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_entry_types, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::ListEntryTypesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_entry_types_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_entry_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_entry_types parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_entry_types ::Google::Cloud::Dataplex::V1::ListEntryTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_entry_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_entry_types(::Google::Cloud::Dataplex::V1::ListEntryTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_entry_types_client_stub.call_rpc_count
    end
  end

  def test_get_entry_type
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::EntryType.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_entry_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_entry_type, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::GetEntryTypeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_entry_type_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_entry_type({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_entry_type name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_entry_type ::Google::Cloud::Dataplex::V1::GetEntryTypeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_entry_type({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_entry_type(::Google::Cloud::Dataplex::V1::GetEntryTypeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_entry_type_client_stub.call_rpc_count
    end
  end

  def test_create_aspect_type
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    aspect_type_id = "hello world"
    aspect_type = {}
    validate_only = true

    create_aspect_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_aspect_type, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::CreateAspectTypeRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["aspect_type_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::AspectType), request["aspect_type"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_aspect_type_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_aspect_type({ parent: parent, aspect_type_id: aspect_type_id, aspect_type: aspect_type, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_aspect_type parent: parent, aspect_type_id: aspect_type_id, aspect_type: aspect_type, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_aspect_type ::Google::Cloud::Dataplex::V1::CreateAspectTypeRequest.new(parent: parent, aspect_type_id: aspect_type_id, aspect_type: aspect_type, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_aspect_type({ parent: parent, aspect_type_id: aspect_type_id, aspect_type: aspect_type, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_aspect_type(::Google::Cloud::Dataplex::V1::CreateAspectTypeRequest.new(parent: parent, aspect_type_id: aspect_type_id, aspect_type: aspect_type, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_aspect_type_client_stub.call_rpc_count
    end
  end

  def test_update_aspect_type
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    aspect_type = {}
    update_mask = {}
    validate_only = true

    update_aspect_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_aspect_type, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::UpdateAspectTypeRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::AspectType), request["aspect_type"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_aspect_type_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_aspect_type({ aspect_type: aspect_type, update_mask: update_mask, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_aspect_type aspect_type: aspect_type, update_mask: update_mask, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_aspect_type ::Google::Cloud::Dataplex::V1::UpdateAspectTypeRequest.new(aspect_type: aspect_type, update_mask: update_mask, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_aspect_type({ aspect_type: aspect_type, update_mask: update_mask, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_aspect_type(::Google::Cloud::Dataplex::V1::UpdateAspectTypeRequest.new(aspect_type: aspect_type, update_mask: update_mask, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_aspect_type_client_stub.call_rpc_count
    end
  end

  def test_delete_aspect_type
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_aspect_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_aspect_type, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::DeleteAspectTypeRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_aspect_type_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_aspect_type({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_aspect_type name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_aspect_type ::Google::Cloud::Dataplex::V1::DeleteAspectTypeRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_aspect_type({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_aspect_type(::Google::Cloud::Dataplex::V1::DeleteAspectTypeRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_aspect_type_client_stub.call_rpc_count
    end
  end

  def test_list_aspect_types
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::ListAspectTypesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_aspect_types_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_aspect_types, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::ListAspectTypesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_aspect_types_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_aspect_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_aspect_types parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_aspect_types ::Google::Cloud::Dataplex::V1::ListAspectTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_aspect_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_aspect_types(::Google::Cloud::Dataplex::V1::ListAspectTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_aspect_types_client_stub.call_rpc_count
    end
  end

  def test_get_aspect_type
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::AspectType.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_aspect_type_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_aspect_type, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::GetAspectTypeRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_aspect_type_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_aspect_type({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_aspect_type name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_aspect_type ::Google::Cloud::Dataplex::V1::GetAspectTypeRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_aspect_type({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_aspect_type(::Google::Cloud::Dataplex::V1::GetAspectTypeRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_aspect_type_client_stub.call_rpc_count
    end
  end

  def test_create_entry_group
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entry_group_id = "hello world"
    entry_group = {}
    validate_only = true

    create_entry_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_entry_group, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::CreateEntryGroupRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["entry_group_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::EntryGroup), request["entry_group"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_entry_group_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_entry_group({ parent: parent, entry_group_id: entry_group_id, entry_group: entry_group, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_entry_group parent: parent, entry_group_id: entry_group_id, entry_group: entry_group, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_entry_group ::Google::Cloud::Dataplex::V1::CreateEntryGroupRequest.new(parent: parent, entry_group_id: entry_group_id, entry_group: entry_group, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_entry_group({ parent: parent, entry_group_id: entry_group_id, entry_group: entry_group, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_entry_group(::Google::Cloud::Dataplex::V1::CreateEntryGroupRequest.new(parent: parent, entry_group_id: entry_group_id, entry_group: entry_group, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_entry_group_client_stub.call_rpc_count
    end
  end

  def test_update_entry_group
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    entry_group = {}
    update_mask = {}
    validate_only = true

    update_entry_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_entry_group, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::UpdateEntryGroupRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::EntryGroup), request["entry_group"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_entry_group_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_entry_group({ entry_group: entry_group, update_mask: update_mask, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_entry_group entry_group: entry_group, update_mask: update_mask, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_entry_group ::Google::Cloud::Dataplex::V1::UpdateEntryGroupRequest.new(entry_group: entry_group, update_mask: update_mask, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_entry_group({ entry_group: entry_group, update_mask: update_mask, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_entry_group(::Google::Cloud::Dataplex::V1::UpdateEntryGroupRequest.new(entry_group: entry_group, update_mask: update_mask, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_entry_group_client_stub.call_rpc_count
    end
  end

  def test_delete_entry_group
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_entry_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_entry_group, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::DeleteEntryGroupRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_entry_group_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_entry_group({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_entry_group name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_entry_group ::Google::Cloud::Dataplex::V1::DeleteEntryGroupRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_entry_group({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_entry_group(::Google::Cloud::Dataplex::V1::DeleteEntryGroupRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_entry_group_client_stub.call_rpc_count
    end
  end

  def test_list_entry_groups
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::ListEntryGroupsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_entry_groups_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_entry_groups, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::ListEntryGroupsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_entry_groups_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_entry_groups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_entry_groups parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_entry_groups ::Google::Cloud::Dataplex::V1::ListEntryGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_entry_groups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_entry_groups(::Google::Cloud::Dataplex::V1::ListEntryGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_entry_groups_client_stub.call_rpc_count
    end
  end

  def test_get_entry_group
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::EntryGroup.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_entry_group_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_entry_group, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::GetEntryGroupRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_entry_group_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_entry_group({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_entry_group name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_entry_group ::Google::Cloud::Dataplex::V1::GetEntryGroupRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_entry_group({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_entry_group(::Google::Cloud::Dataplex::V1::GetEntryGroupRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_entry_group_client_stub.call_rpc_count
    end
  end

  def test_create_entry
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::Entry.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entry_id = "hello world"
    entry = {}

    create_entry_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_entry, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::CreateEntryRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["entry_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::Entry), request["entry"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_entry_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_entry({ parent: parent, entry_id: entry_id, entry: entry }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_entry parent: parent, entry_id: entry_id, entry: entry do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_entry ::Google::Cloud::Dataplex::V1::CreateEntryRequest.new(parent: parent, entry_id: entry_id, entry: entry) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_entry({ parent: parent, entry_id: entry_id, entry: entry }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_entry(::Google::Cloud::Dataplex::V1::CreateEntryRequest.new(parent: parent, entry_id: entry_id, entry: entry), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_entry_client_stub.call_rpc_count
    end
  end

  def test_update_entry
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::Entry.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    entry = {}
    update_mask = {}
    allow_missing = true
    delete_missing_aspects = true
    aspect_keys = ["hello world"]

    update_entry_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_entry, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::UpdateEntryRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::Entry), request["entry"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["allow_missing"]
      assert_equal true, request["delete_missing_aspects"]
      assert_equal ["hello world"], request["aspect_keys"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_entry_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_entry({ entry: entry, update_mask: update_mask, allow_missing: allow_missing, delete_missing_aspects: delete_missing_aspects, aspect_keys: aspect_keys }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_entry entry: entry, update_mask: update_mask, allow_missing: allow_missing, delete_missing_aspects: delete_missing_aspects, aspect_keys: aspect_keys do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_entry ::Google::Cloud::Dataplex::V1::UpdateEntryRequest.new(entry: entry, update_mask: update_mask, allow_missing: allow_missing, delete_missing_aspects: delete_missing_aspects, aspect_keys: aspect_keys) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_entry({ entry: entry, update_mask: update_mask, allow_missing: allow_missing, delete_missing_aspects: delete_missing_aspects, aspect_keys: aspect_keys }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_entry(::Google::Cloud::Dataplex::V1::UpdateEntryRequest.new(entry: entry, update_mask: update_mask, allow_missing: allow_missing, delete_missing_aspects: delete_missing_aspects, aspect_keys: aspect_keys), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_entry_client_stub.call_rpc_count
    end
  end

  def test_delete_entry
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::Entry.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_entry_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_entry, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::DeleteEntryRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_entry_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_entry({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_entry name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_entry ::Google::Cloud::Dataplex::V1::DeleteEntryRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_entry({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_entry(::Google::Cloud::Dataplex::V1::DeleteEntryRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_entry_client_stub.call_rpc_count
    end
  end

  def test_list_entries
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::ListEntriesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_entries_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_entries, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::ListEntriesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_entries_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_entries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_entries parent: parent, page_size: page_size, page_token: page_token, filter: filter do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_entries ::Google::Cloud::Dataplex::V1::ListEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_entries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_entries(::Google::Cloud::Dataplex::V1::ListEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_entries_client_stub.call_rpc_count
    end
  end

  def test_get_entry
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::Entry.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :ENTRY_VIEW_UNSPECIFIED
    aspect_types = ["hello world"]
    paths = ["hello world"]

    get_entry_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_entry, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::GetEntryRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :ENTRY_VIEW_UNSPECIFIED, request["view"]
      assert_equal ["hello world"], request["aspect_types"]
      assert_equal ["hello world"], request["paths"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_entry_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_entry({ name: name, view: view, aspect_types: aspect_types, paths: paths }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_entry name: name, view: view, aspect_types: aspect_types, paths: paths do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_entry ::Google::Cloud::Dataplex::V1::GetEntryRequest.new(name: name, view: view, aspect_types: aspect_types, paths: paths) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_entry({ name: name, view: view, aspect_types: aspect_types, paths: paths }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_entry(::Google::Cloud::Dataplex::V1::GetEntryRequest.new(name: name, view: view, aspect_types: aspect_types, paths: paths), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_entry_client_stub.call_rpc_count
    end
  end

  def test_lookup_entry
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::Entry.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :ENTRY_VIEW_UNSPECIFIED
    aspect_types = ["hello world"]
    paths = ["hello world"]
    entry = "hello world"

    lookup_entry_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :lookup_entry, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::LookupEntryRequest, request
      assert_equal "hello world", request["name"]
      assert_equal :ENTRY_VIEW_UNSPECIFIED, request["view"]
      assert_equal ["hello world"], request["aspect_types"]
      assert_equal ["hello world"], request["paths"]
      assert_equal "hello world", request["entry"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, lookup_entry_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.lookup_entry({ name: name, view: view, aspect_types: aspect_types, paths: paths, entry: entry }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.lookup_entry name: name, view: view, aspect_types: aspect_types, paths: paths, entry: entry do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.lookup_entry ::Google::Cloud::Dataplex::V1::LookupEntryRequest.new(name: name, view: view, aspect_types: aspect_types, paths: paths, entry: entry) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.lookup_entry({ name: name, view: view, aspect_types: aspect_types, paths: paths, entry: entry }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.lookup_entry(::Google::Cloud::Dataplex::V1::LookupEntryRequest.new(name: name, view: view, aspect_types: aspect_types, paths: paths, entry: entry), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, lookup_entry_client_stub.call_rpc_count
    end
  end

  def test_search_entries
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::SearchEntriesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    scope = "hello world"
    semantic_search = true

    search_entries_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :search_entries, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::SearchEntriesRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["query"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["order_by"]
      assert_equal "hello world", request["scope"]
      assert_equal true, request["semantic_search"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, search_entries_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.search_entries({ name: name, query: query, page_size: page_size, page_token: page_token, order_by: order_by, scope: scope, semantic_search: semantic_search }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.search_entries name: name, query: query, page_size: page_size, page_token: page_token, order_by: order_by, scope: scope, semantic_search: semantic_search do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.search_entries ::Google::Cloud::Dataplex::V1::SearchEntriesRequest.new(name: name, query: query, page_size: page_size, page_token: page_token, order_by: order_by, scope: scope, semantic_search: semantic_search) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.search_entries({ name: name, query: query, page_size: page_size, page_token: page_token, order_by: order_by, scope: scope, semantic_search: semantic_search }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.search_entries(::Google::Cloud::Dataplex::V1::SearchEntriesRequest.new(name: name, query: query, page_size: page_size, page_token: page_token, order_by: order_by, scope: scope, semantic_search: semantic_search), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, search_entries_client_stub.call_rpc_count
    end
  end

  def test_create_metadata_job
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    metadata_job = {}
    metadata_job_id = "hello world"
    validate_only = true

    create_metadata_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_metadata_job, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::CreateMetadataJobRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::MetadataJob), request["metadata_job"]
      assert_equal "hello world", request["metadata_job_id"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_metadata_job_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_metadata_job({ parent: parent, metadata_job: metadata_job, metadata_job_id: metadata_job_id, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_metadata_job parent: parent, metadata_job: metadata_job, metadata_job_id: metadata_job_id, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_metadata_job ::Google::Cloud::Dataplex::V1::CreateMetadataJobRequest.new(parent: parent, metadata_job: metadata_job, metadata_job_id: metadata_job_id, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_metadata_job({ parent: parent, metadata_job: metadata_job, metadata_job_id: metadata_job_id, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_metadata_job(::Google::Cloud::Dataplex::V1::CreateMetadataJobRequest.new(parent: parent, metadata_job: metadata_job, metadata_job_id: metadata_job_id, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_metadata_job_client_stub.call_rpc_count
    end
  end

  def test_get_metadata_job
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::MetadataJob.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_metadata_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_metadata_job, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::GetMetadataJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_metadata_job_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_metadata_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_metadata_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_metadata_job ::Google::Cloud::Dataplex::V1::GetMetadataJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_metadata_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_metadata_job(::Google::Cloud::Dataplex::V1::GetMetadataJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_metadata_job_client_stub.call_rpc_count
    end
  end

  def test_list_metadata_jobs
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::ListMetadataJobsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_metadata_jobs_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_metadata_jobs, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::ListMetadataJobsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_metadata_jobs_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_metadata_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_metadata_jobs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_metadata_jobs ::Google::Cloud::Dataplex::V1::ListMetadataJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_metadata_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_metadata_jobs(::Google::Cloud::Dataplex::V1::ListMetadataJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_metadata_jobs_client_stub.call_rpc_count
    end
  end

  def test_cancel_metadata_job
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_metadata_job_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :cancel_metadata_job, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::CancelMetadataJobRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, cancel_metadata_job_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.cancel_metadata_job({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.cancel_metadata_job name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.cancel_metadata_job ::Google::Cloud::Dataplex::V1::CancelMetadataJobRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.cancel_metadata_job({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.cancel_metadata_job(::Google::Cloud::Dataplex::V1::CancelMetadataJobRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, cancel_metadata_job_client_stub.call_rpc_count
    end
  end

  def test_create_entry_link
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::EntryLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entry_link_id = "hello world"
    entry_link = {}

    create_entry_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_entry_link, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::CreateEntryLinkRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["entry_link_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::EntryLink), request["entry_link"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_entry_link_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_entry_link({ parent: parent, entry_link_id: entry_link_id, entry_link: entry_link }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_entry_link parent: parent, entry_link_id: entry_link_id, entry_link: entry_link do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_entry_link ::Google::Cloud::Dataplex::V1::CreateEntryLinkRequest.new(parent: parent, entry_link_id: entry_link_id, entry_link: entry_link) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_entry_link({ parent: parent, entry_link_id: entry_link_id, entry_link: entry_link }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_entry_link(::Google::Cloud::Dataplex::V1::CreateEntryLinkRequest.new(parent: parent, entry_link_id: entry_link_id, entry_link: entry_link), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_entry_link_client_stub.call_rpc_count
    end
  end

  def test_delete_entry_link
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::EntryLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_entry_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_entry_link, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::DeleteEntryLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_entry_link_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_entry_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_entry_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_entry_link ::Google::Cloud::Dataplex::V1::DeleteEntryLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_entry_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_entry_link(::Google::Cloud::Dataplex::V1::DeleteEntryLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_entry_link_client_stub.call_rpc_count
    end
  end

  def test_get_entry_link
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::EntryLink.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_entry_link_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_entry_link, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::GetEntryLinkRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_entry_link_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_entry_link({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_entry_link name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_entry_link ::Google::Cloud::Dataplex::V1::GetEntryLinkRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_entry_link({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_entry_link(::Google::Cloud::Dataplex::V1::GetEntryLinkRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_entry_link_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dataplex::V1::CatalogService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Dataplex::V1::CatalogService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Dataplex::V1::CatalogService::Operations, client.operations_client
  end
end
