# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/dataplex/v1/catalog_pb"
require "google/cloud/dataplex/v1/catalog_service/rest"


class ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_entry_type
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entry_type_id = "hello world"
    entry_type = {}
    validate_only = true

    create_entry_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_create_entry_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_entry_type_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_entry_type({ parent: parent, entry_type_id: entry_type_id, entry_type: entry_type, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_entry_type parent: parent, entry_type_id: entry_type_id, entry_type: entry_type, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_entry_type ::Google::Cloud::Dataplex::V1::CreateEntryTypeRequest.new(parent: parent, entry_type_id: entry_type_id, entry_type: entry_type, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_entry_type({ parent: parent, entry_type_id: entry_type_id, entry_type: entry_type, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_entry_type(::Google::Cloud::Dataplex::V1::CreateEntryTypeRequest.new(parent: parent, entry_type_id: entry_type_id, entry_type: entry_type, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_entry_type_client_stub.call_count
      end
    end
  end

  def test_update_entry_type
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    entry_type = {}
    update_mask = {}
    validate_only = true

    update_entry_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_update_entry_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_entry_type_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_entry_type({ entry_type: entry_type, update_mask: update_mask, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_entry_type entry_type: entry_type, update_mask: update_mask, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_entry_type ::Google::Cloud::Dataplex::V1::UpdateEntryTypeRequest.new(entry_type: entry_type, update_mask: update_mask, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_entry_type({ entry_type: entry_type, update_mask: update_mask, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_entry_type(::Google::Cloud::Dataplex::V1::UpdateEntryTypeRequest.new(entry_type: entry_type, update_mask: update_mask, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_entry_type_client_stub.call_count
      end
    end
  end

  def test_delete_entry_type
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_entry_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_delete_entry_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_entry_type_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_entry_type({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_entry_type name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_entry_type ::Google::Cloud::Dataplex::V1::DeleteEntryTypeRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_entry_type({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_entry_type(::Google::Cloud::Dataplex::V1::DeleteEntryTypeRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_entry_type_client_stub.call_count
      end
    end
  end

  def test_list_entry_types
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::ListEntryTypesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_entry_types_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_list_entry_types_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_entry_types_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_entry_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_entry_types parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_entry_types ::Google::Cloud::Dataplex::V1::ListEntryTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_entry_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_entry_types(::Google::Cloud::Dataplex::V1::ListEntryTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_entry_types_client_stub.call_count
      end
    end
  end

  def test_get_entry_type
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::EntryType.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_entry_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_get_entry_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_entry_type_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_entry_type({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_entry_type name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_entry_type ::Google::Cloud::Dataplex::V1::GetEntryTypeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_entry_type({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_entry_type(::Google::Cloud::Dataplex::V1::GetEntryTypeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_entry_type_client_stub.call_count
      end
    end
  end

  def test_create_aspect_type
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    aspect_type_id = "hello world"
    aspect_type = {}
    validate_only = true

    create_aspect_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_create_aspect_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_aspect_type_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_aspect_type({ parent: parent, aspect_type_id: aspect_type_id, aspect_type: aspect_type, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_aspect_type parent: parent, aspect_type_id: aspect_type_id, aspect_type: aspect_type, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_aspect_type ::Google::Cloud::Dataplex::V1::CreateAspectTypeRequest.new(parent: parent, aspect_type_id: aspect_type_id, aspect_type: aspect_type, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_aspect_type({ parent: parent, aspect_type_id: aspect_type_id, aspect_type: aspect_type, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_aspect_type(::Google::Cloud::Dataplex::V1::CreateAspectTypeRequest.new(parent: parent, aspect_type_id: aspect_type_id, aspect_type: aspect_type, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_aspect_type_client_stub.call_count
      end
    end
  end

  def test_update_aspect_type
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    aspect_type = {}
    update_mask = {}
    validate_only = true

    update_aspect_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_update_aspect_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_aspect_type_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_aspect_type({ aspect_type: aspect_type, update_mask: update_mask, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_aspect_type aspect_type: aspect_type, update_mask: update_mask, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_aspect_type ::Google::Cloud::Dataplex::V1::UpdateAspectTypeRequest.new(aspect_type: aspect_type, update_mask: update_mask, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_aspect_type({ aspect_type: aspect_type, update_mask: update_mask, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_aspect_type(::Google::Cloud::Dataplex::V1::UpdateAspectTypeRequest.new(aspect_type: aspect_type, update_mask: update_mask, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_aspect_type_client_stub.call_count
      end
    end
  end

  def test_delete_aspect_type
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_aspect_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_delete_aspect_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_aspect_type_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_aspect_type({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_aspect_type name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_aspect_type ::Google::Cloud::Dataplex::V1::DeleteAspectTypeRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_aspect_type({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_aspect_type(::Google::Cloud::Dataplex::V1::DeleteAspectTypeRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_aspect_type_client_stub.call_count
      end
    end
  end

  def test_list_aspect_types
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::ListAspectTypesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_aspect_types_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_list_aspect_types_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_aspect_types_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_aspect_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_aspect_types parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_aspect_types ::Google::Cloud::Dataplex::V1::ListAspectTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_aspect_types({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_aspect_types(::Google::Cloud::Dataplex::V1::ListAspectTypesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_aspect_types_client_stub.call_count
      end
    end
  end

  def test_get_aspect_type
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::AspectType.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_aspect_type_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_get_aspect_type_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_aspect_type_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_aspect_type({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_aspect_type name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_aspect_type ::Google::Cloud::Dataplex::V1::GetAspectTypeRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_aspect_type({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_aspect_type(::Google::Cloud::Dataplex::V1::GetAspectTypeRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_aspect_type_client_stub.call_count
      end
    end
  end

  def test_create_entry_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entry_group_id = "hello world"
    entry_group = {}
    validate_only = true

    create_entry_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_create_entry_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_entry_group_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_entry_group({ parent: parent, entry_group_id: entry_group_id, entry_group: entry_group, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_entry_group parent: parent, entry_group_id: entry_group_id, entry_group: entry_group, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_entry_group ::Google::Cloud::Dataplex::V1::CreateEntryGroupRequest.new(parent: parent, entry_group_id: entry_group_id, entry_group: entry_group, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_entry_group({ parent: parent, entry_group_id: entry_group_id, entry_group: entry_group, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_entry_group(::Google::Cloud::Dataplex::V1::CreateEntryGroupRequest.new(parent: parent, entry_group_id: entry_group_id, entry_group: entry_group, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_entry_group_client_stub.call_count
      end
    end
  end

  def test_update_entry_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    entry_group = {}
    update_mask = {}
    validate_only = true

    update_entry_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_update_entry_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_entry_group_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_entry_group({ entry_group: entry_group, update_mask: update_mask, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_entry_group entry_group: entry_group, update_mask: update_mask, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_entry_group ::Google::Cloud::Dataplex::V1::UpdateEntryGroupRequest.new(entry_group: entry_group, update_mask: update_mask, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_entry_group({ entry_group: entry_group, update_mask: update_mask, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_entry_group(::Google::Cloud::Dataplex::V1::UpdateEntryGroupRequest.new(entry_group: entry_group, update_mask: update_mask, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_entry_group_client_stub.call_count
      end
    end
  end

  def test_delete_entry_group
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_entry_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_delete_entry_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_entry_group_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_entry_group({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_entry_group name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_entry_group ::Google::Cloud::Dataplex::V1::DeleteEntryGroupRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_entry_group({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_entry_group(::Google::Cloud::Dataplex::V1::DeleteEntryGroupRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_entry_group_client_stub.call_count
      end
    end
  end

  def test_list_entry_groups
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::ListEntryGroupsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_entry_groups_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_list_entry_groups_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_entry_groups_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_entry_groups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_entry_groups parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_entry_groups ::Google::Cloud::Dataplex::V1::ListEntryGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_entry_groups({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_entry_groups(::Google::Cloud::Dataplex::V1::ListEntryGroupsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_entry_groups_client_stub.call_count
      end
    end
  end

  def test_get_entry_group
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::EntryGroup.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_entry_group_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_get_entry_group_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_entry_group_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_entry_group({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_entry_group name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_entry_group ::Google::Cloud::Dataplex::V1::GetEntryGroupRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_entry_group({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_entry_group(::Google::Cloud::Dataplex::V1::GetEntryGroupRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_entry_group_client_stub.call_count
      end
    end
  end

  def test_create_entry
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::Entry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entry_id = "hello world"
    entry = {}

    create_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_create_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_entry_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_entry({ parent: parent, entry_id: entry_id, entry: entry }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_entry parent: parent, entry_id: entry_id, entry: entry do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_entry ::Google::Cloud::Dataplex::V1::CreateEntryRequest.new(parent: parent, entry_id: entry_id, entry: entry) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_entry({ parent: parent, entry_id: entry_id, entry: entry }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_entry(::Google::Cloud::Dataplex::V1::CreateEntryRequest.new(parent: parent, entry_id: entry_id, entry: entry), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_entry_client_stub.call_count
      end
    end
  end

  def test_update_entry
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::Entry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    entry = {}
    update_mask = {}
    allow_missing = true
    delete_missing_aspects = true
    aspect_keys = ["hello world"]

    update_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_update_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_entry_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_entry({ entry: entry, update_mask: update_mask, allow_missing: allow_missing, delete_missing_aspects: delete_missing_aspects, aspect_keys: aspect_keys }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_entry entry: entry, update_mask: update_mask, allow_missing: allow_missing, delete_missing_aspects: delete_missing_aspects, aspect_keys: aspect_keys do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_entry ::Google::Cloud::Dataplex::V1::UpdateEntryRequest.new(entry: entry, update_mask: update_mask, allow_missing: allow_missing, delete_missing_aspects: delete_missing_aspects, aspect_keys: aspect_keys) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_entry({ entry: entry, update_mask: update_mask, allow_missing: allow_missing, delete_missing_aspects: delete_missing_aspects, aspect_keys: aspect_keys }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_entry(::Google::Cloud::Dataplex::V1::UpdateEntryRequest.new(entry: entry, update_mask: update_mask, allow_missing: allow_missing, delete_missing_aspects: delete_missing_aspects, aspect_keys: aspect_keys), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_entry_client_stub.call_count
      end
    end
  end

  def test_delete_entry
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::Entry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_delete_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_entry_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_entry({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_entry name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_entry ::Google::Cloud::Dataplex::V1::DeleteEntryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_entry({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_entry(::Google::Cloud::Dataplex::V1::DeleteEntryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_entry_client_stub.call_count
      end
    end
  end

  def test_list_entries
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::ListEntriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"

    list_entries_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_list_entries_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_entries_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_entries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_entries parent: parent, page_size: page_size, page_token: page_token, filter: filter do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_entries ::Google::Cloud::Dataplex::V1::ListEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_entries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_entries(::Google::Cloud::Dataplex::V1::ListEntriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_entries_client_stub.call_count
      end
    end
  end

  def test_get_entry
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::Entry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :ENTRY_VIEW_UNSPECIFIED
    aspect_types = ["hello world"]
    paths = ["hello world"]

    get_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_get_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_entry_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_entry({ name: name, view: view, aspect_types: aspect_types, paths: paths }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_entry name: name, view: view, aspect_types: aspect_types, paths: paths do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_entry ::Google::Cloud::Dataplex::V1::GetEntryRequest.new(name: name, view: view, aspect_types: aspect_types, paths: paths) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_entry({ name: name, view: view, aspect_types: aspect_types, paths: paths }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_entry(::Google::Cloud::Dataplex::V1::GetEntryRequest.new(name: name, view: view, aspect_types: aspect_types, paths: paths), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_entry_client_stub.call_count
      end
    end
  end

  def test_lookup_entry
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::Entry.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    view = :ENTRY_VIEW_UNSPECIFIED
    aspect_types = ["hello world"]
    paths = ["hello world"]
    entry = "hello world"

    lookup_entry_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_lookup_entry_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, lookup_entry_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.lookup_entry({ name: name, view: view, aspect_types: aspect_types, paths: paths, entry: entry }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.lookup_entry name: name, view: view, aspect_types: aspect_types, paths: paths, entry: entry do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.lookup_entry ::Google::Cloud::Dataplex::V1::LookupEntryRequest.new(name: name, view: view, aspect_types: aspect_types, paths: paths, entry: entry) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.lookup_entry({ name: name, view: view, aspect_types: aspect_types, paths: paths, entry: entry }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.lookup_entry(::Google::Cloud::Dataplex::V1::LookupEntryRequest.new(name: name, view: view, aspect_types: aspect_types, paths: paths, entry: entry), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, lookup_entry_client_stub.call_count
      end
    end
  end

  def test_search_entries
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::SearchEntriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    query = "hello world"
    page_size = 42
    page_token = "hello world"
    order_by = "hello world"
    scope = "hello world"
    semantic_search = true

    search_entries_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_search_entries_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, search_entries_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.search_entries({ name: name, query: query, page_size: page_size, page_token: page_token, order_by: order_by, scope: scope, semantic_search: semantic_search }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.search_entries name: name, query: query, page_size: page_size, page_token: page_token, order_by: order_by, scope: scope, semantic_search: semantic_search do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.search_entries ::Google::Cloud::Dataplex::V1::SearchEntriesRequest.new(name: name, query: query, page_size: page_size, page_token: page_token, order_by: order_by, scope: scope, semantic_search: semantic_search) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.search_entries({ name: name, query: query, page_size: page_size, page_token: page_token, order_by: order_by, scope: scope, semantic_search: semantic_search }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.search_entries(::Google::Cloud::Dataplex::V1::SearchEntriesRequest.new(name: name, query: query, page_size: page_size, page_token: page_token, order_by: order_by, scope: scope, semantic_search: semantic_search), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, search_entries_client_stub.call_count
      end
    end
  end

  def test_create_metadata_job
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    metadata_job = {}
    metadata_job_id = "hello world"
    validate_only = true

    create_metadata_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_create_metadata_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_metadata_job_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_metadata_job({ parent: parent, metadata_job: metadata_job, metadata_job_id: metadata_job_id, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_metadata_job parent: parent, metadata_job: metadata_job, metadata_job_id: metadata_job_id, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_metadata_job ::Google::Cloud::Dataplex::V1::CreateMetadataJobRequest.new(parent: parent, metadata_job: metadata_job, metadata_job_id: metadata_job_id, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_metadata_job({ parent: parent, metadata_job: metadata_job, metadata_job_id: metadata_job_id, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_metadata_job(::Google::Cloud::Dataplex::V1::CreateMetadataJobRequest.new(parent: parent, metadata_job: metadata_job, metadata_job_id: metadata_job_id, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_metadata_job_client_stub.call_count
      end
    end
  end

  def test_get_metadata_job
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::MetadataJob.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_metadata_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_get_metadata_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_metadata_job_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_metadata_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_metadata_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_metadata_job ::Google::Cloud::Dataplex::V1::GetMetadataJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_metadata_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_metadata_job(::Google::Cloud::Dataplex::V1::GetMetadataJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_metadata_job_client_stub.call_count
      end
    end
  end

  def test_list_metadata_jobs
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::ListMetadataJobsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_metadata_jobs_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_list_metadata_jobs_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_metadata_jobs_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_metadata_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_metadata_jobs parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_metadata_jobs ::Google::Cloud::Dataplex::V1::ListMetadataJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_metadata_jobs({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_metadata_jobs(::Google::Cloud::Dataplex::V1::ListMetadataJobsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_metadata_jobs_client_stub.call_count
      end
    end
  end

  def test_cancel_metadata_job
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    cancel_metadata_job_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_cancel_metadata_job_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, cancel_metadata_job_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.cancel_metadata_job({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.cancel_metadata_job name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.cancel_metadata_job ::Google::Cloud::Dataplex::V1::CancelMetadataJobRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.cancel_metadata_job({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.cancel_metadata_job(::Google::Cloud::Dataplex::V1::CancelMetadataJobRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, cancel_metadata_job_client_stub.call_count
      end
    end
  end

  def test_create_entry_link
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::EntryLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    entry_link_id = "hello world"
    entry_link = {}

    create_entry_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_create_entry_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_entry_link_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_entry_link({ parent: parent, entry_link_id: entry_link_id, entry_link: entry_link }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_entry_link parent: parent, entry_link_id: entry_link_id, entry_link: entry_link do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_entry_link ::Google::Cloud::Dataplex::V1::CreateEntryLinkRequest.new(parent: parent, entry_link_id: entry_link_id, entry_link: entry_link) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_entry_link({ parent: parent, entry_link_id: entry_link_id, entry_link: entry_link }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_entry_link(::Google::Cloud::Dataplex::V1::CreateEntryLinkRequest.new(parent: parent, entry_link_id: entry_link_id, entry_link: entry_link), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_entry_link_client_stub.call_count
      end
    end
  end

  def test_delete_entry_link
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::EntryLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_entry_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_delete_entry_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_entry_link_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_entry_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_entry_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_entry_link ::Google::Cloud::Dataplex::V1::DeleteEntryLinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_entry_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_entry_link(::Google::Cloud::Dataplex::V1::DeleteEntryLinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_entry_link_client_stub.call_count
      end
    end
  end

  def test_get_entry_link
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::EntryLink.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_entry_link_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::CatalogService::Rest::ServiceStub.stub :transcode_get_entry_link_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_entry_link_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_entry_link({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_entry_link name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_entry_link ::Google::Cloud::Dataplex::V1::GetEntryLinkRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_entry_link({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_entry_link(::Google::Cloud::Dataplex::V1::GetEntryLinkRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_entry_link_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dataplex::V1::CatalogService::Rest::Client::Configuration, config
  end
end
