# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/dataplex/v1/catalog_service"

class ::Google::Cloud::Dataplex::V1::CatalogService::ClientPathsTest < Minitest::Test
  class DummyStub
    def endpoint
      "endpoint.example.com"
    end
  
    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_aspect_type_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.aspect_type_path project: "value0", location: "value1", aspect_type: "value2"
      assert_equal "projects/value0/locations/value1/aspectTypes/value2", path
    end
  end

  def test_entry_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.entry_path project: "value0", location: "value1", entry_group: "value2", entry: "value3"
      assert_equal "projects/value0/locations/value1/entryGroups/value2/entries/value3", path
    end
  end

  def test_entry_group_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.entry_group_path project: "value0", location: "value1", entry_group: "value2"
      assert_equal "projects/value0/locations/value1/entryGroups/value2", path
    end
  end

  def test_entry_link_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.entry_link_path project: "value0", location: "value1", entry_group: "value2", entry_link: "value3"
      assert_equal "projects/value0/locations/value1/entryGroups/value2/entryLinks/value3", path
    end
  end

  def test_entry_type_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.entry_type_path project: "value0", location: "value1", entry_type: "value2"
      assert_equal "projects/value0/locations/value1/entryTypes/value2", path
    end
  end

  def test_glossary_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.glossary_path project: "value0", location: "value1", glossary: "value2"
      assert_equal "projects/value0/locations/value1/glossaries/value2", path
    end
  end

  def test_location_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.location_path project: "value0", location: "value1"
      assert_equal "projects/value0/locations/value1", path
    end
  end

  def test_metadata_job_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.metadata_job_path project: "value0", location: "value1", metadata_job: "value2"
      assert_equal "projects/value0/locations/value1/metadataJobs/value2", path
    end
  end

  def test_project_path
    grpc_channel = ::GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    ::Gapic::ServiceStub.stub :new, DummyStub.new do
      client = ::Google::Cloud::Dataplex::V1::CatalogService::Client.new do |config|
        config.credentials = grpc_channel
      end

      path = client.project_path project: "value0"
      assert_equal "projects/value0", path
    end
  end
end
