# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"

require "gapic/grpc/service_stub"

require "google/cloud/dataplex/v1/business_glossary_pb"
require "google/cloud/dataplex/v1/business_glossary_service"

class ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_rpc_count, :requests

    def initialize response, operation, &block
      @response = response
      @operation = operation
      @block = block
      @call_rpc_count = 0
      @requests = []
    end

    def call_rpc *args, **kwargs
      @call_rpc_count += 1

      @requests << @block&.call(*args, **kwargs)

      catch :response do
        yield @response, @operation if block_given?
        @response
      end
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_glossary
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    glossary_id = "hello world"
    glossary = {}
    validate_only = true

    create_glossary_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_glossary, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::CreateGlossaryRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["glossary_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::Glossary), request["glossary"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_glossary_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_glossary({ parent: parent, glossary_id: glossary_id, glossary: glossary, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_glossary parent: parent, glossary_id: glossary_id, glossary: glossary, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_glossary ::Google::Cloud::Dataplex::V1::CreateGlossaryRequest.new(parent: parent, glossary_id: glossary_id, glossary: glossary, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_glossary({ parent: parent, glossary_id: glossary_id, glossary: glossary, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_glossary(::Google::Cloud::Dataplex::V1::CreateGlossaryRequest.new(parent: parent, glossary_id: glossary_id, glossary: glossary, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_glossary_client_stub.call_rpc_count
    end
  end

  def test_update_glossary
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    glossary = {}
    update_mask = {}
    validate_only = true

    update_glossary_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_glossary, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::UpdateGlossaryRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::Glossary), request["glossary"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      assert_equal true, request["validate_only"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_glossary_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_glossary({ glossary: glossary, update_mask: update_mask, validate_only: validate_only }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_glossary glossary: glossary, update_mask: update_mask, validate_only: validate_only do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_glossary ::Google::Cloud::Dataplex::V1::UpdateGlossaryRequest.new(glossary: glossary, update_mask: update_mask, validate_only: validate_only) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_glossary({ glossary: glossary, update_mask: update_mask, validate_only: validate_only }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_glossary(::Google::Cloud::Dataplex::V1::UpdateGlossaryRequest.new(glossary: glossary, update_mask: update_mask, validate_only: validate_only), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_glossary_client_stub.call_rpc_count
    end
  end

  def test_delete_glossary
    # Create GRPC objects.
    grpc_response = ::Google::Longrunning::Operation.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_glossary_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_glossary, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::DeleteGlossaryRequest, request
      assert_equal "hello world", request["name"]
      assert_equal "hello world", request["etag"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_glossary_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_glossary({ name: name, etag: etag }) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_glossary name: name, etag: etag do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_glossary ::Google::Cloud::Dataplex::V1::DeleteGlossaryRequest.new(name: name, etag: etag) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_glossary({ name: name, etag: etag }, grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_glossary(::Google::Cloud::Dataplex::V1::DeleteGlossaryRequest.new(name: name, etag: etag), grpc_options) do |response, operation|
        assert_kind_of Gapic::Operation, response
        assert_equal grpc_response, response.grpc_op
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_glossary_client_stub.call_rpc_count
    end
  end

  def test_get_glossary
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::Glossary.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_glossary_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_glossary, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::GetGlossaryRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_glossary_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_glossary({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_glossary name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_glossary ::Google::Cloud::Dataplex::V1::GetGlossaryRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_glossary({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_glossary(::Google::Cloud::Dataplex::V1::GetGlossaryRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_glossary_client_stub.call_rpc_count
    end
  end

  def test_list_glossaries
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::ListGlossariesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_glossaries_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_glossaries, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::ListGlossariesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_glossaries_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_glossaries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_glossaries parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_glossaries ::Google::Cloud::Dataplex::V1::ListGlossariesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_glossaries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_glossaries(::Google::Cloud::Dataplex::V1::ListGlossariesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_glossaries_client_stub.call_rpc_count
    end
  end

  def test_create_glossary_category
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::GlossaryCategory.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    category_id = "hello world"
    category = {}

    create_glossary_category_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_glossary_category, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::CreateGlossaryCategoryRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["category_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::GlossaryCategory), request["category"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_glossary_category_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_glossary_category({ parent: parent, category_id: category_id, category: category }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_glossary_category parent: parent, category_id: category_id, category: category do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_glossary_category ::Google::Cloud::Dataplex::V1::CreateGlossaryCategoryRequest.new(parent: parent, category_id: category_id, category: category) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_glossary_category({ parent: parent, category_id: category_id, category: category }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_glossary_category(::Google::Cloud::Dataplex::V1::CreateGlossaryCategoryRequest.new(parent: parent, category_id: category_id, category: category), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_glossary_category_client_stub.call_rpc_count
    end
  end

  def test_update_glossary_category
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::GlossaryCategory.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    category = {}
    update_mask = {}

    update_glossary_category_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_glossary_category, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::UpdateGlossaryCategoryRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::GlossaryCategory), request["category"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_glossary_category_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_glossary_category({ category: category, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_glossary_category category: category, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_glossary_category ::Google::Cloud::Dataplex::V1::UpdateGlossaryCategoryRequest.new(category: category, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_glossary_category({ category: category, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_glossary_category(::Google::Cloud::Dataplex::V1::UpdateGlossaryCategoryRequest.new(category: category, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_glossary_category_client_stub.call_rpc_count
    end
  end

  def test_delete_glossary_category
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_glossary_category_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_glossary_category, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::DeleteGlossaryCategoryRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_glossary_category_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_glossary_category({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_glossary_category name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_glossary_category ::Google::Cloud::Dataplex::V1::DeleteGlossaryCategoryRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_glossary_category({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_glossary_category(::Google::Cloud::Dataplex::V1::DeleteGlossaryCategoryRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_glossary_category_client_stub.call_rpc_count
    end
  end

  def test_get_glossary_category
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::GlossaryCategory.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_glossary_category_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_glossary_category, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::GetGlossaryCategoryRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_glossary_category_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_glossary_category({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_glossary_category name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_glossary_category ::Google::Cloud::Dataplex::V1::GetGlossaryCategoryRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_glossary_category({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_glossary_category(::Google::Cloud::Dataplex::V1::GetGlossaryCategoryRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_glossary_category_client_stub.call_rpc_count
    end
  end

  def test_list_glossary_categories
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::ListGlossaryCategoriesResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_glossary_categories_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_glossary_categories, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::ListGlossaryCategoriesRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_glossary_categories_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_glossary_categories({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_glossary_categories parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_glossary_categories ::Google::Cloud::Dataplex::V1::ListGlossaryCategoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_glossary_categories({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_glossary_categories(::Google::Cloud::Dataplex::V1::ListGlossaryCategoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_glossary_categories_client_stub.call_rpc_count
    end
  end

  def test_create_glossary_term
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::GlossaryTerm.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    term_id = "hello world"
    term = {}

    create_glossary_term_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :create_glossary_term, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::CreateGlossaryTermRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal "hello world", request["term_id"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::GlossaryTerm), request["term"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, create_glossary_term_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.create_glossary_term({ parent: parent, term_id: term_id, term: term }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.create_glossary_term parent: parent, term_id: term_id, term: term do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.create_glossary_term ::Google::Cloud::Dataplex::V1::CreateGlossaryTermRequest.new(parent: parent, term_id: term_id, term: term) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.create_glossary_term({ parent: parent, term_id: term_id, term: term }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.create_glossary_term(::Google::Cloud::Dataplex::V1::CreateGlossaryTermRequest.new(parent: parent, term_id: term_id, term: term), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, create_glossary_term_client_stub.call_rpc_count
    end
  end

  def test_update_glossary_term
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::GlossaryTerm.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    term = {}
    update_mask = {}

    update_glossary_term_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :update_glossary_term, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::UpdateGlossaryTermRequest, request
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Cloud::Dataplex::V1::GlossaryTerm), request["term"]
      assert_equal Gapic::Protobuf.coerce({}, to: ::Google::Protobuf::FieldMask), request["update_mask"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, update_glossary_term_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.update_glossary_term({ term: term, update_mask: update_mask }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.update_glossary_term term: term, update_mask: update_mask do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.update_glossary_term ::Google::Cloud::Dataplex::V1::UpdateGlossaryTermRequest.new(term: term, update_mask: update_mask) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.update_glossary_term({ term: term, update_mask: update_mask }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.update_glossary_term(::Google::Cloud::Dataplex::V1::UpdateGlossaryTermRequest.new(term: term, update_mask: update_mask), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, update_glossary_term_client_stub.call_rpc_count
    end
  end

  def test_delete_glossary_term
    # Create GRPC objects.
    grpc_response = ::Google::Protobuf::Empty.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_glossary_term_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :delete_glossary_term, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::DeleteGlossaryTermRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, delete_glossary_term_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.delete_glossary_term({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.delete_glossary_term name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.delete_glossary_term ::Google::Cloud::Dataplex::V1::DeleteGlossaryTermRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.delete_glossary_term({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.delete_glossary_term(::Google::Cloud::Dataplex::V1::DeleteGlossaryTermRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, delete_glossary_term_client_stub.call_rpc_count
    end
  end

  def test_get_glossary_term
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::GlossaryTerm.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_glossary_term_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :get_glossary_term, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::GetGlossaryTermRequest, request
      assert_equal "hello world", request["name"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, get_glossary_term_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.get_glossary_term({ name: name }) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.get_glossary_term name: name do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.get_glossary_term ::Google::Cloud::Dataplex::V1::GetGlossaryTermRequest.new(name: name) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.get_glossary_term({ name: name }, grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.get_glossary_term(::Google::Cloud::Dataplex::V1::GetGlossaryTermRequest.new(name: name), grpc_options) do |response, operation|
        assert_equal grpc_response, response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, get_glossary_term_client_stub.call_rpc_count
    end
  end

  def test_list_glossary_terms
    # Create GRPC objects.
    grpc_response = ::Google::Cloud::Dataplex::V1::ListGlossaryTermsResponse.new
    grpc_operation = GRPC::ActiveCall::Operation.new nil
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure
    grpc_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_glossary_terms_client_stub = ClientStub.new grpc_response, grpc_operation do |name, request, options:|
      assert_equal :list_glossary_terms, name
      assert_kind_of ::Google::Cloud::Dataplex::V1::ListGlossaryTermsRequest, request
      assert_equal "hello world", request["parent"]
      assert_equal 42, request["page_size"]
      assert_equal "hello world", request["page_token"]
      assert_equal "hello world", request["filter"]
      assert_equal "hello world", request["order_by"]
      refute_nil options
    end

    Gapic::ServiceStub.stub :new, list_glossary_terms_client_stub do
      # Create client
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end

      # Use hash object
      client.list_glossary_terms({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use named arguments
      client.list_glossary_terms parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object
      client.list_glossary_terms ::Google::Cloud::Dataplex::V1::ListGlossaryTermsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use hash object with options
      client.list_glossary_terms({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Use protobuf object with options
      client.list_glossary_terms(::Google::Cloud::Dataplex::V1::ListGlossaryTermsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), grpc_options) do |response, operation|
        assert_kind_of Gapic::PagedEnumerable, response
        assert_equal grpc_response, response.response
        assert_equal grpc_operation, operation
      end

      # Verify method calls
      assert_equal 5, list_glossary_terms_client_stub.call_rpc_count
    end
  end

  def test_configure
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client::Configuration, config
  end

  def test_credentials
    key = OpenSSL::PKey::RSA.new 2048
    cred_json = {
      "private_key" => key.to_pem,
      "client_email" => "app@developer.gserviceaccount.com",
      "type" => "service_account"
    }
    key_file = StringIO.new cred_json.to_json
    creds = Google::Auth::ServiceAccountCredentials.make_creds({ json_key_io: key_file })

    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = creds
      end
      assert_kind_of ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client, client
      assert_equal creds, client.configure.credentials
    end
  end

  def test_operations_client
    grpc_channel = GRPC::Core::Channel.new "localhost:8888", nil, :this_channel_is_insecure

    client = nil
    dummy_stub = ClientStub.new nil, nil
    Gapic::ServiceStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Client.new do |config|
        config.credentials = grpc_channel
      end
    end

    assert_kind_of ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Operations, client.operations_client
  end
end
