# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "helper"
require "gapic/rest"
require "google/cloud/dataplex/v1/business_glossary_pb"
require "google/cloud/dataplex/v1/business_glossary_service/rest"


class ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ClientTest < Minitest::Test
  class ClientStub
    attr_accessor :call_count, :requests

    def initialize response, &block
      @response = response
      @block = block
      @call_count = 0
      @requests = []
    end

    def make_get_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :get, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_delete_request uri:, params: {}, options: {}, method_name: nil
      make_http_request :delete, uri: uri, body: nil, params: params, options: options, method_name: method_name
    end

    def make_post_request uri:, body: nil, params: {}, options: {}, method_name: nil
      make_http_request :post, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_patch_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :patch, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_put_request uri:, body:, params: {}, options: {}, method_name: nil
      make_http_request :put, uri: uri, body: body, params: params, options: options, method_name: method_name
    end

    def make_http_request *args, **kwargs
      @call_count += 1

      @requests << @block&.call(*args, **kwargs)

      @response
    end

    def endpoint
      "endpoint.example.com"
    end

    def universe_domain
      "example.com"
    end

    def stub_logger
      nil
    end

    def logger
      nil
    end
  end

  def test_create_glossary
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    glossary_id = "hello world"
    glossary = {}
    validate_only = true

    create_glossary_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_create_glossary_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_glossary_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_glossary({ parent: parent, glossary_id: glossary_id, glossary: glossary, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_glossary parent: parent, glossary_id: glossary_id, glossary: glossary, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_glossary ::Google::Cloud::Dataplex::V1::CreateGlossaryRequest.new(parent: parent, glossary_id: glossary_id, glossary: glossary, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_glossary({ parent: parent, glossary_id: glossary_id, glossary: glossary, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_glossary(::Google::Cloud::Dataplex::V1::CreateGlossaryRequest.new(parent: parent, glossary_id: glossary_id, glossary: glossary, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_glossary_client_stub.call_count
      end
    end
  end

  def test_update_glossary
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    glossary = {}
    update_mask = {}
    validate_only = true

    update_glossary_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_update_glossary_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_glossary_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_glossary({ glossary: glossary, update_mask: update_mask, validate_only: validate_only }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_glossary glossary: glossary, update_mask: update_mask, validate_only: validate_only do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_glossary ::Google::Cloud::Dataplex::V1::UpdateGlossaryRequest.new(glossary: glossary, update_mask: update_mask, validate_only: validate_only) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_glossary({ glossary: glossary, update_mask: update_mask, validate_only: validate_only }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_glossary(::Google::Cloud::Dataplex::V1::UpdateGlossaryRequest.new(glossary: glossary, update_mask: update_mask, validate_only: validate_only), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_glossary_client_stub.call_count
      end
    end
  end

  def test_delete_glossary
    # Create test objects.
    client_result = ::Google::Longrunning::Operation.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"
    etag = "hello world"

    delete_glossary_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_delete_glossary_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_glossary_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_glossary({ name: name, etag: etag }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_glossary name: name, etag: etag do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_glossary ::Google::Cloud::Dataplex::V1::DeleteGlossaryRequest.new(name: name, etag: etag) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_glossary({ name: name, etag: etag }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_glossary(::Google::Cloud::Dataplex::V1::DeleteGlossaryRequest.new(name: name, etag: etag), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_glossary_client_stub.call_count
      end
    end
  end

  def test_get_glossary
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::Glossary.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_glossary_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_get_glossary_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_glossary_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_glossary({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_glossary name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_glossary ::Google::Cloud::Dataplex::V1::GetGlossaryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_glossary({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_glossary(::Google::Cloud::Dataplex::V1::GetGlossaryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_glossary_client_stub.call_count
      end
    end
  end

  def test_list_glossaries
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::ListGlossariesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_glossaries_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_list_glossaries_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_glossaries_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_glossaries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_glossaries parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_glossaries ::Google::Cloud::Dataplex::V1::ListGlossariesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_glossaries({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_glossaries(::Google::Cloud::Dataplex::V1::ListGlossariesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_glossaries_client_stub.call_count
      end
    end
  end

  def test_create_glossary_category
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::GlossaryCategory.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    category_id = "hello world"
    category = {}

    create_glossary_category_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_create_glossary_category_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_glossary_category_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_glossary_category({ parent: parent, category_id: category_id, category: category }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_glossary_category parent: parent, category_id: category_id, category: category do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_glossary_category ::Google::Cloud::Dataplex::V1::CreateGlossaryCategoryRequest.new(parent: parent, category_id: category_id, category: category) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_glossary_category({ parent: parent, category_id: category_id, category: category }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_glossary_category(::Google::Cloud::Dataplex::V1::CreateGlossaryCategoryRequest.new(parent: parent, category_id: category_id, category: category), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_glossary_category_client_stub.call_count
      end
    end
  end

  def test_update_glossary_category
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::GlossaryCategory.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    category = {}
    update_mask = {}

    update_glossary_category_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_update_glossary_category_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_glossary_category_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_glossary_category({ category: category, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_glossary_category category: category, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_glossary_category ::Google::Cloud::Dataplex::V1::UpdateGlossaryCategoryRequest.new(category: category, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_glossary_category({ category: category, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_glossary_category(::Google::Cloud::Dataplex::V1::UpdateGlossaryCategoryRequest.new(category: category, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_glossary_category_client_stub.call_count
      end
    end
  end

  def test_delete_glossary_category
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_glossary_category_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_delete_glossary_category_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_glossary_category_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_glossary_category({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_glossary_category name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_glossary_category ::Google::Cloud::Dataplex::V1::DeleteGlossaryCategoryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_glossary_category({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_glossary_category(::Google::Cloud::Dataplex::V1::DeleteGlossaryCategoryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_glossary_category_client_stub.call_count
      end
    end
  end

  def test_get_glossary_category
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::GlossaryCategory.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_glossary_category_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_get_glossary_category_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_glossary_category_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_glossary_category({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_glossary_category name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_glossary_category ::Google::Cloud::Dataplex::V1::GetGlossaryCategoryRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_glossary_category({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_glossary_category(::Google::Cloud::Dataplex::V1::GetGlossaryCategoryRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_glossary_category_client_stub.call_count
      end
    end
  end

  def test_list_glossary_categories
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::ListGlossaryCategoriesResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_glossary_categories_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_list_glossary_categories_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_glossary_categories_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_glossary_categories({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_glossary_categories parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_glossary_categories ::Google::Cloud::Dataplex::V1::ListGlossaryCategoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_glossary_categories({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_glossary_categories(::Google::Cloud::Dataplex::V1::ListGlossaryCategoriesRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_glossary_categories_client_stub.call_count
      end
    end
  end

  def test_create_glossary_term
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::GlossaryTerm.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    term_id = "hello world"
    term = {}

    create_glossary_term_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_create_glossary_term_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, create_glossary_term_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.create_glossary_term({ parent: parent, term_id: term_id, term: term }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.create_glossary_term parent: parent, term_id: term_id, term: term do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.create_glossary_term ::Google::Cloud::Dataplex::V1::CreateGlossaryTermRequest.new(parent: parent, term_id: term_id, term: term) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.create_glossary_term({ parent: parent, term_id: term_id, term: term }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.create_glossary_term(::Google::Cloud::Dataplex::V1::CreateGlossaryTermRequest.new(parent: parent, term_id: term_id, term: term), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, create_glossary_term_client_stub.call_count
      end
    end
  end

  def test_update_glossary_term
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::GlossaryTerm.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    term = {}
    update_mask = {}

    update_glossary_term_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_update_glossary_term_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, update_glossary_term_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.update_glossary_term({ term: term, update_mask: update_mask }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.update_glossary_term term: term, update_mask: update_mask do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.update_glossary_term ::Google::Cloud::Dataplex::V1::UpdateGlossaryTermRequest.new(term: term, update_mask: update_mask) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.update_glossary_term({ term: term, update_mask: update_mask }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.update_glossary_term(::Google::Cloud::Dataplex::V1::UpdateGlossaryTermRequest.new(term: term, update_mask: update_mask), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, update_glossary_term_client_stub.call_count
      end
    end
  end

  def test_delete_glossary_term
    # Create test objects.
    client_result = ::Google::Protobuf::Empty.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    delete_glossary_term_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_delete_glossary_term_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, delete_glossary_term_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.delete_glossary_term({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.delete_glossary_term name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.delete_glossary_term ::Google::Cloud::Dataplex::V1::DeleteGlossaryTermRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.delete_glossary_term({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.delete_glossary_term(::Google::Cloud::Dataplex::V1::DeleteGlossaryTermRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, delete_glossary_term_client_stub.call_count
      end
    end
  end

  def test_get_glossary_term
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::GlossaryTerm.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    name = "hello world"

    get_glossary_term_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_get_glossary_term_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, get_glossary_term_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.get_glossary_term({ name: name }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.get_glossary_term name: name do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.get_glossary_term ::Google::Cloud::Dataplex::V1::GetGlossaryTermRequest.new(name: name) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.get_glossary_term({ name: name }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.get_glossary_term(::Google::Cloud::Dataplex::V1::GetGlossaryTermRequest.new(name: name), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, get_glossary_term_client_stub.call_count
      end
    end
  end

  def test_list_glossary_terms
    # Create test objects.
    client_result = ::Google::Cloud::Dataplex::V1::ListGlossaryTermsResponse.new
    http_response = OpenStruct.new body: client_result.to_json

    call_options = {}

    # Create request parameters for a unary method.
    parent = "hello world"
    page_size = 42
    page_token = "hello world"
    filter = "hello world"
    order_by = "hello world"

    list_glossary_terms_client_stub = ClientStub.new http_response do |_verb, uri:, body:, params:, options:, method_name:|
      assert options.metadata.key? :"x-goog-api-client"
      assert options.metadata[:"x-goog-api-client"].include? "rest"
      refute options.metadata[:"x-goog-api-client"].include? "grpc"
    end

    ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::ServiceStub.stub :transcode_list_glossary_terms_request, ["", "", {}] do
      Gapic::Rest::ClientStub.stub :new, list_glossary_terms_client_stub do
        # Create client
        client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
          config.credentials = :dummy_value
        end

        # Use hash object
        client.list_glossary_terms({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use named arguments
        client.list_glossary_terms parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object
        client.list_glossary_terms ::Google::Cloud::Dataplex::V1::ListGlossaryTermsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use hash object with options
        client.list_glossary_terms({ parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by }, call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Use protobuf object with options
        client.list_glossary_terms(::Google::Cloud::Dataplex::V1::ListGlossaryTermsRequest.new(parent: parent, page_size: page_size, page_token: page_token, filter: filter, order_by: order_by), call_options) do |_result, response|
          assert_equal http_response, response.underlying_op
        end

        # Verify method calls
        assert_equal 5, list_glossary_terms_client_stub.call_count
      end
    end
  end

  def test_configure
    credentials_token = :dummy_value

    client = block_config = config = nil
    dummy_stub = ClientStub.new nil
    Gapic::Rest::ClientStub.stub :new, dummy_stub do
      client = ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client.new do |config|
        config.credentials = credentials_token
      end
    end

    config = client.configure do |c|
      block_config = c
    end

    assert_same block_config, config
    assert_kind_of ::Google::Cloud::Dataplex::V1::BusinessGlossaryService::Rest::Client::Configuration, config
  end
end
