# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        # Create lake request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the lake location, of the form:
        #     projects/\\{project_number}/locations/\\{location_id}
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] lake_id
        #   @return [::String]
        #     Required. Lake identifier.
        #     This ID will be used to generate names such as database and dataset names
        #     when publishing metadata to Hive Metastore and BigQuery.
        #     * Must contain only lowercase letters, numbers and hyphens.
        #     * Must start with a letter.
        #     * Must end with a number or a letter.
        #     * Must be between 1-63 characters.
        #     * Must be unique within the customer project / location.
        # @!attribute [rw] lake
        #   @return [::Google::Cloud::Dataplex::V1::Lake]
        #     Required. Lake resource
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class CreateLakeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update lake request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update.
        # @!attribute [rw] lake
        #   @return [::Google::Cloud::Dataplex::V1::Lake]
        #     Required. Update description.
        #     Only fields specified in `update_mask` are updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class UpdateLakeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete lake request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the lake:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
        class DeleteLakeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List lakes request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the lake location, of the form:
        #     `projects/{project_number}/locations/{location_id}`
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of Lakes to return. The service may return fewer
        #     than this value. If unspecified, at most 10 lakes will be returned. The
        #     maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListLakes` call. Provide
        #     this to retrieve the subsequent page. When paginating, all other parameters
        #     provided to `ListLakes` must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Order by fields for the result.
        class ListLakesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List lakes response.
        # @!attribute [rw] lakes
        #   @return [::Array<::Google::Cloud::Dataplex::V1::Lake>]
        #     Lakes under the given parent location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable_locations
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListLakesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List lake actions request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent lake:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of actions to return. The service may return fewer
        #     than this value. If unspecified, at most 10 actions will be returned. The
        #     maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListLakeActions` call.
        #     Provide this to retrieve the subsequent page. When paginating, all other
        #     parameters provided to `ListLakeActions` must match the call that provided
        #     the page token.
        class ListLakeActionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List actions response.
        # @!attribute [rw] actions
        #   @return [::Array<::Google::Cloud::Dataplex::V1::Action>]
        #     Actions under the given parent lake/zone/asset.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListActionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get lake request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the lake:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
        class GetLakeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Create zone request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent lake:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
        # @!attribute [rw] zone_id
        #   @return [::String]
        #     Required. Zone identifier.
        #     This ID will be used to generate names such as database and dataset names
        #     when publishing metadata to Hive Metastore and BigQuery.
        #     * Must contain only lowercase letters, numbers and hyphens.
        #     * Must start with a letter.
        #     * Must end with a number or a letter.
        #     * Must be between 1-63 characters.
        #     * Must be unique across all lakes from all locations in a project.
        #     * Must not be one of the reserved IDs (i.e. "default", "global-temp")
        # @!attribute [rw] zone
        #   @return [::Google::Cloud::Dataplex::V1::Zone]
        #     Required. Zone resource.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class CreateZoneRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update zone request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update.
        # @!attribute [rw] zone
        #   @return [::Google::Cloud::Dataplex::V1::Zone]
        #     Required. Update description.
        #     Only fields specified in `update_mask` are updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class UpdateZoneRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete zone request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the zone:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
        class DeleteZoneRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List zones request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent lake:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of zones to return. The service may return fewer
        #     than this value. If unspecified, at most 10 zones will be returned. The
        #     maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListZones` call. Provide
        #     this to retrieve the subsequent page. When paginating, all other parameters
        #     provided to `ListZones` must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Order by fields for the result.
        class ListZonesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List zones response.
        # @!attribute [rw] zones
        #   @return [::Array<::Google::Cloud::Dataplex::V1::Zone>]
        #     Zones under the given parent lake.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListZonesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List zone actions request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent zone:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of actions to return. The service may return fewer
        #     than this value. If unspecified, at most 10 actions will be returned. The
        #     maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListZoneActions` call.
        #     Provide this to retrieve the subsequent page. When paginating, all other
        #     parameters provided to `ListZoneActions` must match the call that provided
        #     the page token.
        class ListZoneActionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get zone request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the zone:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
        class GetZoneRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Create asset request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent zone:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
        # @!attribute [rw] asset_id
        #   @return [::String]
        #     Required. Asset identifier.
        #     This ID will be used to generate names such as table names when publishing
        #     metadata to Hive Metastore and BigQuery.
        #     * Must contain only lowercase letters, numbers and hyphens.
        #     * Must start with a letter.
        #     * Must end with a number or a letter.
        #     * Must be between 1-63 characters.
        #     * Must be unique within the zone.
        # @!attribute [rw] asset
        #   @return [::Google::Cloud::Dataplex::V1::Asset]
        #     Required. Asset resource.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class CreateAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update asset request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update.
        # @!attribute [rw] asset
        #   @return [::Google::Cloud::Dataplex::V1::Asset]
        #     Required. Update description.
        #     Only fields specified in `update_mask` are updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class UpdateAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete asset request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the asset:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
        class DeleteAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List assets request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent zone:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of asset to return. The service may return fewer
        #     than this value. If unspecified, at most 10 assets will be returned. The
        #     maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListAssets` call. Provide
        #     this to retrieve the subsequent page. When paginating, all other parameters
        #     provided to `ListAssets` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Order by fields for the result.
        class ListAssetsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List assets response.
        # @!attribute [rw] assets
        #   @return [::Array<::Google::Cloud::Dataplex::V1::Asset>]
        #     Asset under the given parent zone.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListAssetsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List asset actions request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent asset:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of actions to return. The service may return fewer
        #     than this value. If unspecified, at most 10 actions will be returned. The
        #     maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListAssetActions` call.
        #     Provide this to retrieve the subsequent page. When paginating, all other
        #     parameters provided to `ListAssetActions` must match the call that provided
        #     the page token.
        class ListAssetActionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get asset request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the asset:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
        class GetAssetRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Represents the metadata of a long-running operation.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation was created.
        # @!attribute [r] end_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time the operation finished running.
        # @!attribute [r] target
        #   @return [::String]
        #     Output only. Server-defined resource path for the target of the operation.
        # @!attribute [r] verb
        #   @return [::String]
        #     Output only. Name of the verb executed by the operation.
        # @!attribute [r] status_message
        #   @return [::String]
        #     Output only. Human-readable status of the operation, if any.
        # @!attribute [r] requested_cancellation
        #   @return [::Boolean]
        #     Output only. Identifies whether the user has requested cancellation
        #     of the operation. Operations that have successfully been cancelled
        #     have [Operation.error][] value with a
        #     {::Google::Rpc::Status#code google.rpc.Status.code} of 1, corresponding to
        #     `Code.CANCELLED`.
        # @!attribute [r] api_version
        #   @return [::String]
        #     Output only. API version used to start the operation.
        class OperationMetadata
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Create task request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent lake:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
        # @!attribute [rw] task_id
        #   @return [::String]
        #     Required. Task identifier.
        # @!attribute [rw] task
        #   @return [::Google::Cloud::Dataplex::V1::Task]
        #     Required. Task resource.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class CreateTaskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update task request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update.
        # @!attribute [rw] task
        #   @return [::Google::Cloud::Dataplex::V1::Task]
        #     Required. Update description.
        #     Only fields specified in `update_mask` are updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class UpdateTaskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete task request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the task:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/task/{task_id}`.
        class DeleteTaskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List tasks request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent lake:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of tasks to return. The service may return fewer
        #     than this value. If unspecified, at most 10 tasks will be returned. The
        #     maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListZones` call. Provide
        #     this to retrieve the subsequent page. When paginating, all other parameters
        #     provided to `ListZones` must match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Order by fields for the result.
        class ListTasksRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List tasks response.
        # @!attribute [rw] tasks
        #   @return [::Array<::Google::Cloud::Dataplex::V1::Task>]
        #     Tasks under the given parent lake.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable_locations
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListTasksResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get task request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the task:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{tasks_id}`.
        class GetTaskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get job request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the job:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}/jobs/{job_id}`.
        class GetJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the task:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}`.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels for the task. If the map is left empty, the
        #     task will run with existing labels from task definition. If the map
        #     contains an entry with a new key, the same will be added to existing set of
        #     labels. If the map contains an entry with an existing label key in task
        #     definition, the task will run with new label value for that entry. Clearing
        #     an existing label will require label value to be explicitly set to a hyphen
        #     "-". The label value cannot be empty.
        # @!attribute [rw] args
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. Execution spec arguments. If the map is left empty, the task will
        #     run with existing execution spec args from task definition. If the map
        #     contains an entry with a new key, the same will be added to existing set of
        #     args. If the map contains an entry with an existing arg key in task
        #     definition, the task will run with new arg value for that entry. Clearing
        #     an existing arg will require arg value to be explicitly set to a hyphen
        #     "-". The arg value cannot be empty.
        class RunTaskRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class ArgsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] job
        #   @return [::Google::Cloud::Dataplex::V1::Job]
        #     Jobs created by RunTask API.
        class RunTaskResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List jobs request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent environment:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of jobs to return. The service may return fewer
        #     than this value. If unspecified, at most 10 jobs will be returned. The
        #     maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListJobs` call. Provide this
        #     to retrieve the subsequent page. When paginating, all other parameters
        #     provided to `ListJobs` must match the call that provided the page
        #     token.
        class ListJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List jobs response.
        # @!attribute [rw] jobs
        #   @return [::Array<::Google::Cloud::Dataplex::V1::Job>]
        #     Jobs under a given task.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Cancel task jobs.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the job:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/task/{task_id}/job/{job_id}`.
        class CancelJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Create environment request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent lake:
        #     `projects/{project_id}/locations/{location_id}/lakes/{lake_id}`.
        # @!attribute [rw] environment_id
        #   @return [::String]
        #     Required. Environment identifier.
        #     * Must contain only lowercase letters, numbers and hyphens.
        #     * Must start with a letter.
        #     * Must be between 1-63 characters.
        #     * Must end with a number or a letter.
        #     * Must be unique within the lake.
        # @!attribute [rw] environment
        #   @return [::Google::Cloud::Dataplex::V1::Environment]
        #     Required. Environment resource.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class CreateEnvironmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update environment request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update.
        # @!attribute [rw] environment
        #   @return [::Google::Cloud::Dataplex::V1::Environment]
        #     Required. Update description.
        #     Only fields specified in `update_mask` are updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class UpdateEnvironmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete environment request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the environment:
        #     `projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environments/{environment_id}`.
        class DeleteEnvironmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List environments request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent lake:
        #     `projects/{project_id}/locations/{location_id}/lakes/{lake_id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of environments to return. The service may return
        #     fewer than this value. If unspecified, at most 10 environments will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListEnvironments` call.
        #     Provide this to retrieve the subsequent page. When paginating, all other
        #     parameters provided to `ListEnvironments` must match the call that provided
        #     the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Order by fields for the result.
        class ListEnvironmentsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List environments response.
        # @!attribute [rw] environments
        #   @return [::Array<::Google::Cloud::Dataplex::V1::Environment>]
        #     Environments under the given parent lake.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListEnvironmentsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get environment request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the environment:
        #     `projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environments/{environment_id}`.
        class GetEnvironmentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List sessions request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent environment:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/environment/{environment_id}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of sessions to return. The service may return
        #     fewer than this value. If unspecified, at most 10 sessions will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListSessions` call. Provide
        #     this to retrieve the subsequent page. When paginating, all other parameters
        #     provided to `ListSessions` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter request. The following `mode` filter is supported to
        #     return only the sessions belonging to the requester when the mode is USER
        #     and return sessions of all the users when the mode is ADMIN. When no filter
        #     is sent default to USER mode. NOTE: When the mode is ADMIN, the requester
        #     should have `dataplex.environments.listAllSessions` permission to list all
        #     sessions, in absence of the permission, the request fails.
        #
        #     mode = ADMIN | USER
        class ListSessionsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List sessions response.
        # @!attribute [rw] sessions
        #   @return [::Array<::Google::Cloud::Dataplex::V1::Session>]
        #     Sessions under a given environment.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListSessionsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
