# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        # ResourceAccessSpec holds the access control configuration to be enforced
        # on the resources, for example, Cloud Storage bucket, BigQuery dataset,
        # BigQuery table.
        # @!attribute [rw] readers
        #   @return [::Array<::String>]
        #     Optional. The format of strings follows the pattern followed by IAM in the
        #     bindings. user:\\{email}, serviceAccount:\\{email} group:\\{email}.
        #     The set of principals to be granted reader role on the resource.
        # @!attribute [rw] writers
        #   @return [::Array<::String>]
        #     Optional. The set of principals to be granted writer role on the resource.
        # @!attribute [rw] owners
        #   @return [::Array<::String>]
        #     Optional. The set of principals to be granted owner role on the resource.
        class ResourceAccessSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # DataAccessSpec holds the access control configuration to be enforced on data
        # stored within resources (eg: rows, columns in BigQuery Tables). When
        # associated with data, the data is only accessible to
        # principals explicitly granted access through the DataAccessSpec. Principals
        # with access to the containing resource are not implicitly granted access.
        # @!attribute [rw] readers
        #   @return [::Array<::String>]
        #     Optional. The format of strings follows the pattern followed by IAM in the
        #     bindings. user:\\{email}, serviceAccount:\\{email} group:\\{email}.
        #     The set of principals to be granted reader role on data
        #     stored within resources.
        class DataAccessSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
