# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        # A lake is a centralized repository for managing enterprise data across the
        # organization distributed across many cloud projects, and stored in a variety
        # of storage services such as Google Cloud Storage and BigQuery. The resources
        # attached to a lake are referred to as managed resources. Data within these
        # managed resources can be structured or unstructured. A lake provides data
        # admins with tools to organize, secure and manage their data at scale, and
        # provides data scientists and data engineers an integrated experience to
        # easily search, discover, analyze and transform data and associated metadata.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The relative resource name of the lake, of the form:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly display name.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System generated globally unique ID for the lake. This ID will
        #     be different if the lake is deleted and re-created with the same name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the lake was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the lake was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels for the lake.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the lake.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Dataplex::V1::State]
        #     Output only. Current state of the lake.
        # @!attribute [r] service_account
        #   @return [::String]
        #     Output only. Service account associated with this lake. This service
        #     account must be authorized to access or operate on resources managed by the
        #     lake.
        # @!attribute [rw] metastore
        #   @return [::Google::Cloud::Dataplex::V1::Lake::Metastore]
        #     Optional. Settings to manage lake and Dataproc Metastore service instance
        #     association.
        # @!attribute [r] asset_status
        #   @return [::Google::Cloud::Dataplex::V1::AssetStatus]
        #     Output only. Aggregated status of the underlying assets of the lake.
        # @!attribute [r] metastore_status
        #   @return [::Google::Cloud::Dataplex::V1::Lake::MetastoreStatus]
        #     Output only. Metastore status of the lake.
        class Lake
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Settings to manage association of Dataproc Metastore with a lake.
          # @!attribute [rw] service
          #   @return [::String]
          #     Optional. A relative reference to the Dataproc Metastore
          #     (https://cloud.google.com/dataproc-metastore/docs) service associated
          #     with the lake:
          #     `projects/{project_id}/locations/{location_id}/services/{service_id}`
          class Metastore
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Status of Lake and Dataproc Metastore service instance association.
          # @!attribute [rw] state
          #   @return [::Google::Cloud::Dataplex::V1::Lake::MetastoreStatus::State]
          #     Current state of association.
          # @!attribute [rw] message
          #   @return [::String]
          #     Additional information about the current status.
          # @!attribute [rw] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Last update time of the metastore status of the lake.
          # @!attribute [rw] endpoint
          #   @return [::String]
          #     The URI of the endpoint used to access the Metastore service.
          class MetastoreStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Current state of association.
            module State
              # Unspecified.
              STATE_UNSPECIFIED = 0

              # A Metastore service instance is not associated with the lake.
              NONE = 1

              # A Metastore service instance is attached to the lake.
              READY = 2

              # Attach/detach is in progress.
              UPDATING = 3

              # Attach/detach could not be done due to errors.
              ERROR = 4
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Aggregated status of the underlying assets of a lake or zone.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Last update time of the status.
        # @!attribute [rw] active_assets
        #   @return [::Integer]
        #     Number of active assets.
        # @!attribute [rw] security_policy_applying_assets
        #   @return [::Integer]
        #     Number of assets that are in process of updating the security policy on
        #     attached resources.
        class AssetStatus
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A zone represents a logical group of related assets within a lake. A zone can
        # be used to map to organizational structure or represent stages of data
        # readiness from raw to curated. It provides managing behavior that is shared
        # or inherited by all contained assets.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The relative resource name of the zone, of the form:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly display name.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System generated globally unique ID for the zone. This ID will
        #     be different if the zone is deleted and re-created with the same name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the zone was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the zone was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User defined labels for the zone.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the zone.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Dataplex::V1::State]
        #     Output only. Current state of the zone.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Dataplex::V1::Zone::Type]
        #     Required. Immutable. The type of the zone.
        # @!attribute [rw] discovery_spec
        #   @return [::Google::Cloud::Dataplex::V1::Zone::DiscoverySpec]
        #     Optional. Specification of the discovery feature applied to data in this
        #     zone.
        # @!attribute [rw] resource_spec
        #   @return [::Google::Cloud::Dataplex::V1::Zone::ResourceSpec]
        #     Required. Specification of the resources that are referenced by the assets
        #     within this zone.
        # @!attribute [r] asset_status
        #   @return [::Google::Cloud::Dataplex::V1::AssetStatus]
        #     Output only. Aggregated status of the underlying assets of the zone.
        class Zone
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Settings for resources attached as assets within a zone.
          # @!attribute [rw] location_type
          #   @return [::Google::Cloud::Dataplex::V1::Zone::ResourceSpec::LocationType]
          #     Required. Immutable. The location type of the resources that are allowed
          #     to be attached to the assets within this zone.
          class ResourceSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Location type of the resources attached to a zone.
            module LocationType
              # Unspecified location type.
              LOCATION_TYPE_UNSPECIFIED = 0

              # Resources that are associated with a single region.
              SINGLE_REGION = 1

              # Resources that are associated with a multi-region location.
              MULTI_REGION = 2
            end
          end

          # Settings to manage the metadata discovery and publishing in a zone.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Required. Whether discovery is enabled.
          # @!attribute [rw] include_patterns
          #   @return [::Array<::String>]
          #     Optional. The list of patterns to apply for selecting data to include
          #     during discovery if only a subset of the data should considered. For
          #     Cloud Storage bucket assets, these are interpreted as glob patterns used
          #     to match object names. For BigQuery dataset assets, these are interpreted
          #     as patterns to match table names.
          # @!attribute [rw] exclude_patterns
          #   @return [::Array<::String>]
          #     Optional. The list of patterns to apply for selecting data to exclude
          #     during discovery.  For Cloud Storage bucket assets, these are interpreted
          #     as glob patterns used to match object names. For BigQuery dataset assets,
          #     these are interpreted as patterns to match table names.
          # @!attribute [rw] csv_options
          #   @return [::Google::Cloud::Dataplex::V1::Zone::DiscoverySpec::CsvOptions]
          #     Optional. Configuration for CSV data.
          # @!attribute [rw] json_options
          #   @return [::Google::Cloud::Dataplex::V1::Zone::DiscoverySpec::JsonOptions]
          #     Optional. Configuration for Json data.
          # @!attribute [rw] schedule
          #   @return [::String]
          #     Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for
          #     running discovery periodically. Successive discovery runs must be
          #     scheduled at least 60 minutes apart. The default value is to run
          #     discovery every 60 minutes.
          #
          #     To explicitly set a timezone to the cron tab, apply a prefix in the
          #     cron tab: "CRON_TZ=$\\{IANA_TIME_ZONE}" or TZ=$\\{IANA_TIME_ZONE}".
          #     The $\\{IANA_TIME_ZONE} may only be a valid string from IANA time zone
          #     database. For example, `CRON_TZ=America/New_York 1 * * * *`, or
          #     `TZ=America/New_York 1 * * * *`.
          class DiscoverySpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describe CSV and similar semi-structured data formats.
            # @!attribute [rw] header_rows
            #   @return [::Integer]
            #     Optional. The number of rows to interpret as header rows that should be
            #     skipped when reading data rows.
            # @!attribute [rw] delimiter
            #   @return [::String]
            #     Optional. The delimiter being used to separate values. This defaults to
            #     ','.
            # @!attribute [rw] encoding
            #   @return [::String]
            #     Optional. The character encoding of the data. The default is UTF-8.
            # @!attribute [rw] disable_type_inference
            #   @return [::Boolean]
            #     Optional. Whether to disable the inference of data type for CSV data.
            #     If true, all columns will be registered as strings.
            class CsvOptions
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Describe JSON data format.
            # @!attribute [rw] encoding
            #   @return [::String]
            #     Optional. The character encoding of the data. The default is UTF-8.
            # @!attribute [rw] disable_type_inference
            #   @return [::Boolean]
            #     Optional. Whether to disable the inference of data type for Json data.
            #     If true, all columns will be registered as their primitive types
            #     (strings, number or boolean).
            class JsonOptions
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Type of zone.
          module Type
            # Zone type not specified.
            TYPE_UNSPECIFIED = 0

            # A zone that contains data that needs further processing before it is
            # considered generally ready for consumption and analytics workloads.
            RAW = 1

            # A zone that contains data that is considered to be ready for broader
            # consumption and analytics workloads. Curated structured data stored in
            # Cloud Storage must conform to certain file formats (parquet, avro and
            # orc) and organized in a hive-compatible directory layout.
            CURATED = 2
          end
        end

        # Action represents an issue requiring administrator action for resolution.
        # @!attribute [rw] category
        #   @return [::Google::Cloud::Dataplex::V1::Action::Category]
        #     The category of issue associated with the action.
        # @!attribute [rw] issue
        #   @return [::String]
        #     Detailed description of the issue requiring action.
        # @!attribute [rw] detect_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time that the issue was detected.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The relative resource name of the action, of the form:
        #     `projects/{project}/locations/{location}/lakes/{lake}/actions/{action}`
        #     `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/actions/{action}`
        #     `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/assets/{asset}/actions/{action}`.
        # @!attribute [r] lake
        #   @return [::String]
        #     Output only. The relative resource name of the lake, of the form:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
        # @!attribute [r] zone
        #   @return [::String]
        #     Output only. The relative resource name of the zone, of the form:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
        # @!attribute [r] asset
        #   @return [::String]
        #     Output only. The relative resource name of the asset, of the form:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
        # @!attribute [rw] data_locations
        #   @return [::Array<::String>]
        #     The list of data locations associated with this action. Cloud Storage
        #     locations are represented as URI paths(E.g.
        #     `gs://bucket/table1/year=2020/month=Jan/`). BigQuery locations refer to
        #     resource names(E.g.
        #     `bigquery.googleapis.com/projects/project-id/datasets/dataset-id`).
        # @!attribute [rw] invalid_data_format
        #   @return [::Google::Cloud::Dataplex::V1::Action::InvalidDataFormat]
        #     Details for issues related to invalid or unsupported data formats.
        #
        #     Note: The following fields are mutually exclusive: `invalid_data_format`, `incompatible_data_schema`, `invalid_data_partition`, `missing_data`, `missing_resource`, `unauthorized_resource`, `failed_security_policy_apply`, `invalid_data_organization`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] incompatible_data_schema
        #   @return [::Google::Cloud::Dataplex::V1::Action::IncompatibleDataSchema]
        #     Details for issues related to incompatible schemas detected within data.
        #
        #     Note: The following fields are mutually exclusive: `incompatible_data_schema`, `invalid_data_format`, `invalid_data_partition`, `missing_data`, `missing_resource`, `unauthorized_resource`, `failed_security_policy_apply`, `invalid_data_organization`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] invalid_data_partition
        #   @return [::Google::Cloud::Dataplex::V1::Action::InvalidDataPartition]
        #     Details for issues related to invalid or unsupported data partition
        #     structure.
        #
        #     Note: The following fields are mutually exclusive: `invalid_data_partition`, `invalid_data_format`, `incompatible_data_schema`, `missing_data`, `missing_resource`, `unauthorized_resource`, `failed_security_policy_apply`, `invalid_data_organization`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] missing_data
        #   @return [::Google::Cloud::Dataplex::V1::Action::MissingData]
        #     Details for issues related to absence of data within managed resources.
        #
        #     Note: The following fields are mutually exclusive: `missing_data`, `invalid_data_format`, `incompatible_data_schema`, `invalid_data_partition`, `missing_resource`, `unauthorized_resource`, `failed_security_policy_apply`, `invalid_data_organization`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] missing_resource
        #   @return [::Google::Cloud::Dataplex::V1::Action::MissingResource]
        #     Details for issues related to absence of a managed resource.
        #
        #     Note: The following fields are mutually exclusive: `missing_resource`, `invalid_data_format`, `incompatible_data_schema`, `invalid_data_partition`, `missing_data`, `unauthorized_resource`, `failed_security_policy_apply`, `invalid_data_organization`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] unauthorized_resource
        #   @return [::Google::Cloud::Dataplex::V1::Action::UnauthorizedResource]
        #     Details for issues related to lack of permissions to access data
        #     resources.
        #
        #     Note: The following fields are mutually exclusive: `unauthorized_resource`, `invalid_data_format`, `incompatible_data_schema`, `invalid_data_partition`, `missing_data`, `missing_resource`, `failed_security_policy_apply`, `invalid_data_organization`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] failed_security_policy_apply
        #   @return [::Google::Cloud::Dataplex::V1::Action::FailedSecurityPolicyApply]
        #     Details for issues related to applying security policy.
        #
        #     Note: The following fields are mutually exclusive: `failed_security_policy_apply`, `invalid_data_format`, `incompatible_data_schema`, `invalid_data_partition`, `missing_data`, `missing_resource`, `unauthorized_resource`, `invalid_data_organization`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] invalid_data_organization
        #   @return [::Google::Cloud::Dataplex::V1::Action::InvalidDataOrganization]
        #     Details for issues related to invalid data arrangement.
        #
        #     Note: The following fields are mutually exclusive: `invalid_data_organization`, `invalid_data_format`, `incompatible_data_schema`, `invalid_data_partition`, `missing_data`, `missing_resource`, `unauthorized_resource`, `failed_security_policy_apply`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Action
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Action details for resource references in assets that cannot be located.
          class MissingResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Action details for unauthorized resource issues raised to indicate that the
          # service account associated with the lake instance is not authorized to
          # access or manage the resource associated with an asset.
          class UnauthorizedResource
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Failed to apply security policy to the managed resource(s) under a
          # lake, zone or an asset. For a lake or zone resource, one or more underlying
          # assets has a failure applying security policy to the associated managed
          # resource.
          # @!attribute [rw] asset
          #   @return [::String]
          #     Resource name of one of the assets with failing security policy
          #     application. Populated for a lake or zone resource only.
          class FailedSecurityPolicyApply
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Action details for invalid or unsupported data files detected by discovery.
          # @!attribute [rw] sampled_data_locations
          #   @return [::Array<::String>]
          #     The list of data locations sampled and used for format/schema
          #     inference.
          # @!attribute [rw] expected_format
          #   @return [::String]
          #     The expected data format of the entity.
          # @!attribute [rw] new_format
          #   @return [::String]
          #     The new unexpected data format within the entity.
          class InvalidDataFormat
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Action details for incompatible schemas detected by discovery.
          # @!attribute [rw] table
          #   @return [::String]
          #     The name of the table containing invalid data.
          # @!attribute [rw] existing_schema
          #   @return [::String]
          #     The existing and expected schema of the table. The schema is provided as
          #     a JSON formatted structure listing columns and data types.
          # @!attribute [rw] new_schema
          #   @return [::String]
          #     The new and incompatible schema within the table. The schema is provided
          #     as a JSON formatted structured listing columns and data types.
          # @!attribute [rw] sampled_data_locations
          #   @return [::Array<::String>]
          #     The list of data locations sampled and used for format/schema
          #     inference.
          # @!attribute [rw] schema_change
          #   @return [::Google::Cloud::Dataplex::V1::Action::IncompatibleDataSchema::SchemaChange]
          #     Whether the action relates to a schema that is incompatible or modified.
          class IncompatibleDataSchema
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Whether the action relates to a schema that is incompatible or modified.
            module SchemaChange
              # Schema change unspecified.
              SCHEMA_CHANGE_UNSPECIFIED = 0

              # Newly discovered schema is incompatible with existing schema.
              INCOMPATIBLE = 1

              # Newly discovered schema has changed from existing schema for data in a
              # curated zone.
              MODIFIED = 2
            end
          end

          # Action details for invalid or unsupported partitions detected by discovery.
          # @!attribute [rw] expected_structure
          #   @return [::Google::Cloud::Dataplex::V1::Action::InvalidDataPartition::PartitionStructure]
          #     The issue type of InvalidDataPartition.
          class InvalidDataPartition
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The expected partition structure.
            module PartitionStructure
              # PartitionStructure unspecified.
              PARTITION_STRUCTURE_UNSPECIFIED = 0

              # Consistent hive-style partition definition (both raw and curated zone).
              CONSISTENT_KEYS = 1

              # Hive style partition definition (curated zone only).
              HIVE_STYLE_KEYS = 2
            end
          end

          # Action details for absence of data detected by discovery.
          class MissingData
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Action details for invalid data arrangement.
          class InvalidDataOrganization
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The category of issues.
          module Category
            # Unspecified category.
            CATEGORY_UNSPECIFIED = 0

            # Resource management related issues.
            RESOURCE_MANAGEMENT = 1

            # Security policy related issues.
            SECURITY_POLICY = 2

            # Data and discovery related issues.
            DATA_DISCOVERY = 3
          end
        end

        # An asset represents a cloud resource that is being managed within a lake as a
        # member of a zone.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The relative resource name of the asset, of the form:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly display name.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System generated globally unique ID for the asset. This ID
        #     will be different if the asset is deleted and re-created with the same
        #     name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the asset was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the asset was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User defined labels for the asset.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the asset.
        # @!attribute [r] state
        #   @return [::Google::Cloud::Dataplex::V1::State]
        #     Output only. Current state of the asset.
        # @!attribute [rw] resource_spec
        #   @return [::Google::Cloud::Dataplex::V1::Asset::ResourceSpec]
        #     Required. Specification of the resource that is referenced by this asset.
        # @!attribute [r] resource_status
        #   @return [::Google::Cloud::Dataplex::V1::Asset::ResourceStatus]
        #     Output only. Status of the resource referenced by this asset.
        # @!attribute [r] security_status
        #   @return [::Google::Cloud::Dataplex::V1::Asset::SecurityStatus]
        #     Output only. Status of the security policy applied to resource referenced
        #     by this asset.
        # @!attribute [rw] discovery_spec
        #   @return [::Google::Cloud::Dataplex::V1::Asset::DiscoverySpec]
        #     Optional. Specification of the discovery feature applied to data referenced
        #     by this asset. When this spec is left unset, the asset will use the spec
        #     set on the parent zone.
        # @!attribute [r] discovery_status
        #   @return [::Google::Cloud::Dataplex::V1::Asset::DiscoveryStatus]
        #     Output only. Status of the discovery feature applied to data referenced by
        #     this asset.
        class Asset
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Security policy status of the asset. Data security policy, i.e., readers,
          # writers & owners, should be specified in the lake/zone/asset IAM policy.
          # @!attribute [rw] state
          #   @return [::Google::Cloud::Dataplex::V1::Asset::SecurityStatus::State]
          #     The current state of the security policy applied to the attached
          #     resource.
          # @!attribute [rw] message
          #   @return [::String]
          #     Additional information about the current state.
          # @!attribute [rw] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Last update time of the status.
          class SecurityStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The state of the security policy.
            module State
              # State unspecified.
              STATE_UNSPECIFIED = 0

              # Security policy has been successfully applied to the attached resource.
              READY = 1

              # Security policy is in the process of being applied to the attached
              # resource.
              APPLYING = 2

              # Security policy could not be applied to the attached resource due to
              # errors.
              ERROR = 3
            end
          end

          # Settings to manage the metadata discovery and publishing for an asset.
          # @!attribute [rw] enabled
          #   @return [::Boolean]
          #     Optional. Whether discovery is enabled.
          # @!attribute [rw] include_patterns
          #   @return [::Array<::String>]
          #     Optional. The list of patterns to apply for selecting data to include
          #     during discovery if only a subset of the data should considered.  For
          #     Cloud Storage bucket assets, these are interpreted as glob patterns used
          #     to match object names. For BigQuery dataset assets, these are interpreted
          #     as patterns to match table names.
          # @!attribute [rw] exclude_patterns
          #   @return [::Array<::String>]
          #     Optional. The list of patterns to apply for selecting data to exclude
          #     during discovery.  For Cloud Storage bucket assets, these are interpreted
          #     as glob patterns used to match object names. For BigQuery dataset assets,
          #     these are interpreted as patterns to match table names.
          # @!attribute [rw] csv_options
          #   @return [::Google::Cloud::Dataplex::V1::Asset::DiscoverySpec::CsvOptions]
          #     Optional. Configuration for CSV data.
          # @!attribute [rw] json_options
          #   @return [::Google::Cloud::Dataplex::V1::Asset::DiscoverySpec::JsonOptions]
          #     Optional. Configuration for Json data.
          # @!attribute [rw] schedule
          #   @return [::String]
          #     Optional. Cron schedule (https://en.wikipedia.org/wiki/Cron) for
          #     running discovery periodically. Successive discovery runs must be
          #     scheduled at least 60 minutes apart. The default value is to run
          #     discovery every 60 minutes.
          #
          #     To explicitly set a timezone to the cron tab, apply a prefix in the
          #     cron tab: "CRON_TZ=$\\{IANA_TIME_ZONE}" or TZ=$\\{IANA_TIME_ZONE}".
          #     The $\\{IANA_TIME_ZONE} may only be a valid string from IANA time zone
          #     database. For example, `CRON_TZ=America/New_York 1 * * * *`, or
          #     `TZ=America/New_York 1 * * * *`.
          class DiscoverySpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Describe CSV and similar semi-structured data formats.
            # @!attribute [rw] header_rows
            #   @return [::Integer]
            #     Optional. The number of rows to interpret as header rows that should be
            #     skipped when reading data rows.
            # @!attribute [rw] delimiter
            #   @return [::String]
            #     Optional. The delimiter being used to separate values. This defaults to
            #     ','.
            # @!attribute [rw] encoding
            #   @return [::String]
            #     Optional. The character encoding of the data. The default is UTF-8.
            # @!attribute [rw] disable_type_inference
            #   @return [::Boolean]
            #     Optional. Whether to disable the inference of data type for CSV data.
            #     If true, all columns will be registered as strings.
            class CsvOptions
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Describe JSON data format.
            # @!attribute [rw] encoding
            #   @return [::String]
            #     Optional. The character encoding of the data. The default is UTF-8.
            # @!attribute [rw] disable_type_inference
            #   @return [::Boolean]
            #     Optional. Whether to disable the inference of data type for Json data.
            #     If true, all columns will be registered as their primitive types
            #     (strings, number or boolean).
            class JsonOptions
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Identifies the cloud resource that is referenced by this asset.
          # @!attribute [rw] name
          #   @return [::String]
          #     Immutable. Relative name of the cloud resource that contains the data
          #     that is being managed within a lake. For example:
          #       `projects/{project_number}/buckets/{bucket_id}`
          #       `projects/{project_number}/datasets/{dataset_id}`
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Dataplex::V1::Asset::ResourceSpec::Type]
          #     Required. Immutable. Type of resource.
          # @!attribute [rw] read_access_mode
          #   @return [::Google::Cloud::Dataplex::V1::Asset::ResourceSpec::AccessMode]
          #     Optional. Determines how read permissions are handled for each asset and
          #     their associated tables. Only available to storage buckets assets.
          class ResourceSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Type of resource.
            module Type
              # Type not specified.
              TYPE_UNSPECIFIED = 0

              # Cloud Storage bucket.
              STORAGE_BUCKET = 1

              # BigQuery dataset.
              BIGQUERY_DATASET = 2
            end

            # Access Mode determines how data stored within the resource is read. This
            # is only applicable to storage bucket assets.
            module AccessMode
              # Access mode unspecified.
              ACCESS_MODE_UNSPECIFIED = 0

              # Default. Data is accessed directly using storage APIs.
              DIRECT = 1

              # Data is accessed through a managed interface using BigQuery APIs.
              MANAGED = 2
            end
          end

          # Status of the resource referenced by an asset.
          # @!attribute [rw] state
          #   @return [::Google::Cloud::Dataplex::V1::Asset::ResourceStatus::State]
          #     The current state of the managed resource.
          # @!attribute [rw] message
          #   @return [::String]
          #     Additional information about the current state.
          # @!attribute [rw] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Last update time of the status.
          # @!attribute [r] managed_access_identity
          #   @return [::String]
          #     Output only. Service account associated with the BigQuery Connection.
          class ResourceStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The state of a resource.
            module State
              # State unspecified.
              STATE_UNSPECIFIED = 0

              # Resource does not have any errors.
              READY = 1

              # Resource has errors.
              ERROR = 2
            end
          end

          # Status of discovery for an asset.
          # @!attribute [rw] state
          #   @return [::Google::Cloud::Dataplex::V1::Asset::DiscoveryStatus::State]
          #     The current status of the discovery feature.
          # @!attribute [rw] message
          #   @return [::String]
          #     Additional information about the current state.
          # @!attribute [rw] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Last update time of the status.
          # @!attribute [rw] last_run_time
          #   @return [::Google::Protobuf::Timestamp]
          #     The start time of the last discovery run.
          # @!attribute [rw] stats
          #   @return [::Google::Cloud::Dataplex::V1::Asset::DiscoveryStatus::Stats]
          #     Data Stats of the asset reported by discovery.
          # @!attribute [rw] last_run_duration
          #   @return [::Google::Protobuf::Duration]
          #     The duration of the last discovery run.
          class DiscoveryStatus
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The aggregated data statistics for the asset reported by discovery.
            # @!attribute [rw] data_items
            #   @return [::Integer]
            #     The count of data items within the referenced resource.
            # @!attribute [rw] data_size
            #   @return [::Integer]
            #     The number of stored data bytes within the referenced resource.
            # @!attribute [rw] tables
            #   @return [::Integer]
            #     The count of table entities within the referenced resource.
            # @!attribute [rw] filesets
            #   @return [::Integer]
            #     The count of fileset entities within the referenced resource.
            class Stats
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Current state of discovery.
            module State
              # State is unspecified.
              STATE_UNSPECIFIED = 0

              # Discovery for the asset is scheduled.
              SCHEDULED = 1

              # Discovery for the asset is running.
              IN_PROGRESS = 2

              # Discovery for the asset is currently paused (e.g. due to a lack
              # of available resources). It will be automatically resumed.
              PAUSED = 3

              # Discovery for the asset is disabled.
              DISABLED = 5
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # State of a resource.
        module State
          # State is not specified.
          STATE_UNSPECIFIED = 0

          # Resource is active, i.e., ready to use.
          ACTIVE = 1

          # Resource is under creation.
          CREATING = 2

          # Resource is under deletion.
          DELETING = 3

          # Resource is active but has unresolved actions.
          ACTION_REQUIRED = 4
        end
      end
    end
  end
end
