# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        # DataScan scheduling and trigger settings.
        # @!attribute [rw] on_demand
        #   @return [::Google::Cloud::Dataplex::V1::Trigger::OnDemand]
        #     The scan runs once via `RunDataScan` API.
        #
        #     Note: The following fields are mutually exclusive: `on_demand`, `schedule`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] schedule
        #   @return [::Google::Cloud::Dataplex::V1::Trigger::Schedule]
        #     The scan is scheduled to run periodically.
        #
        #     Note: The following fields are mutually exclusive: `schedule`, `on_demand`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class Trigger
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The scan runs once via `RunDataScan` API.
          class OnDemand
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # The scan is scheduled to run periodically.
          # @!attribute [rw] cron
          #   @return [::String]
          #     Required. [Cron](https://en.wikipedia.org/wiki/Cron) schedule for running
          #     scans periodically.
          #
          #     To explicitly set a timezone in the cron tab, apply a prefix in the
          #     cron tab: **"CRON_TZ=$\\{IANA_TIME_ZONE}"** or **"TZ=$\\{IANA_TIME_ZONE}"**.
          #     The **$\\{IANA_TIME_ZONE}** may only be a valid string from IANA time zone
          #     database
          #     ([wikipedia](https://en.wikipedia.org/wiki/List_of_tz_database_time_zones#List)).
          #     For example, `CRON_TZ=America/New_York 1 * * * *`, or
          #     `TZ=America/New_York 1 * * * *`.
          #
          #     This field is required for Schedule scans.
          class Schedule
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # The data source for DataScan.
        # @!attribute [rw] entity
        #   @return [::String]
        #     Immutable. The Dataplex Universal Catalog entity that represents the data
        #     source (e.g. BigQuery table) for DataScan, of the form:
        #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}`.
        #
        #     Note: The following fields are mutually exclusive: `entity`, `resource`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Immutable. The service-qualified full resource name of the cloud resource
        #     for a DataScan job to scan against. The field could either be: Cloud
        #     Storage bucket for DataDiscoveryScan Format:
        #     //storage.googleapis.com/projects/PROJECT_ID/buckets/BUCKET_ID
        #     or
        #     BigQuery table of type "TABLE" for
        #     DataProfileScan/DataQualityScan/DataDocumentationScan Format:
        #     //bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
        #
        #     Note: The following fields are mutually exclusive: `resource`, `entity`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        class DataSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The data scanned during processing (e.g. in incremental DataScan)
        # @!attribute [rw] incremental_field
        #   @return [::Google::Cloud::Dataplex::V1::ScannedData::IncrementalField]
        #     The range denoted by values of an incremental field
        class ScannedData
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # A data range denoted by a pair of start/end values of a field.
          # @!attribute [r] field
          #   @return [::String]
          #     Output only. The field that contains values which monotonically increases
          #     over time (e.g. a timestamp column).
          # @!attribute [r] start
          #   @return [::String]
          #     Output only. Value that marks the start of the range.
          # @!attribute [r] end
          #   @return [::String]
          #     Output only. Value that marks the end of the range.
          class IncrementalField
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
