# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        # DataTaxonomy represents a set of hierarchical DataAttributes resources,
        # grouped with a common theme Eg: 'SensitiveDataTaxonomy' can have attributes
        # to manage PII data. It is defined at project level.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The relative resource name of the DataTaxonomy, of the form:
        #     projects/\\{project_number}/locations/\\{location_id}/dataTaxonomies/\\{data_taxonomy_id}.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System generated globally unique ID for the dataTaxonomy. This
        #     ID will be different if the DataTaxonomy is deleted and re-created with the
        #     same name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the DataTaxonomy was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the DataTaxonomy was last updated.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the DataTaxonomy.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly display name.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels for the DataTaxonomy.
        # @!attribute [r] attribute_count
        #   @return [::Integer]
        #     Output only. The number of attributes in the DataTaxonomy.
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of other
        #     fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [r] class_count
        #   @return [::Integer]
        #     Output only. The number of classes in the DataTaxonomy.
        class DataTaxonomy
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Denotes one dataAttribute in a dataTaxonomy, for example, PII.
        # DataAttribute resources can be defined in a hierarchy.
        # A single dataAttribute resource can contain specs of multiple types
        #
        # ```
        # PII
        #   - ResourceAccessSpec :
        #                 - readers :foo@bar.com
        #   - DataAccessSpec :
        #                 - readers :bar@foo.com
        # ```
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The relative resource name of the dataAttribute, of the form:
        #     projects/\\{project_number}/locations/\\{location_id}/dataTaxonomies/\\{dataTaxonomy}/attributes/\\{data_attribute_id}.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System generated globally unique ID for the DataAttribute.
        #     This ID will be different if the DataAttribute is deleted and re-created
        #     with the same name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the DataAttribute was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the DataAttribute was last updated.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the DataAttribute.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly display name.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels for the DataAttribute.
        # @!attribute [rw] parent_id
        #   @return [::String]
        #     Optional. The ID of the parent DataAttribute resource, should belong to the
        #     same data taxonomy. Circular dependency in parent chain is not valid.
        #     Maximum depth of the hierarchy allowed is 4.
        #     [a -> b -> c -> d -> e, depth = 4]
        # @!attribute [r] attribute_count
        #   @return [::Integer]
        #     Output only. The number of child attributes present for this attribute.
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of other
        #     fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        # @!attribute [rw] resource_access_spec
        #   @return [::Google::Cloud::Dataplex::V1::ResourceAccessSpec]
        #     Optional. Specified when applied to a resource (eg: Cloud Storage bucket,
        #     BigQuery dataset, BigQuery table).
        # @!attribute [rw] data_access_spec
        #   @return [::Google::Cloud::Dataplex::V1::DataAccessSpec]
        #     Optional. Specified when applied to data stored on the resource (eg: rows,
        #     columns in BigQuery Tables).
        class DataAttribute
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # DataAttributeBinding represents binding of attributes to resources. Eg: Bind
        # 'CustomerInfo' entity with 'PII' attribute.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The relative resource name of the Data Attribute Binding, of
        #     the form:
        #     projects/\\{project_number}/locations/\\{location}/dataAttributeBindings/\\{data_attribute_binding_id}
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System generated globally unique ID for the
        #     DataAttributeBinding. This ID will be different if the DataAttributeBinding
        #     is deleted and re-created with the same name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the DataAttributeBinding was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the DataAttributeBinding was last updated.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the DataAttributeBinding.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly display name.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels for the DataAttributeBinding.
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the server based on the value of other
        #     fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        #     Etags must be used when calling the DeleteDataAttributeBinding and the
        #     UpdateDataAttributeBinding method.
        # @!attribute [rw] resource
        #   @return [::String]
        #     Optional. Immutable. The resource name of the resource that is associated
        #     to attributes. Presently, only entity resource is supported in the form:
        #     projects/\\{project}/locations/\\{location}/lakes/\\{lake}/zones/\\{zone}/entities/\\{entity_id}
        #     Must belong in the same project and region as the attribute binding, and
        #     there can only exist one active binding for a resource.
        # @!attribute [rw] attributes
        #   @return [::Array<::String>]
        #     Optional. List of attributes to be associated with the resource, provided
        #     in the form:
        #     projects/\\{project}/locations/\\{location}/dataTaxonomies/\\{dataTaxonomy}/attributes/\\{data_attribute_id}
        # @!attribute [rw] paths
        #   @return [::Array<::Google::Cloud::Dataplex::V1::DataAttributeBinding::Path>]
        #     Optional. The list of paths for items within the associated resource (eg.
        #     columns and partitions within a table) along with attribute bindings.
        class DataAttributeBinding
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Represents a subresource of the given resource, and associated bindings
          # with it. Currently supported subresources are column and partition schema
          # fields within a table.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name identifier of the path.
          #     Nested columns should be of the form: 'address.city'.
          # @!attribute [rw] attributes
          #   @return [::Array<::String>]
          #     Optional. List of attributes to be associated with the path of the
          #     resource, provided in the form:
          #     projects/\\{project}/locations/\\{location}/dataTaxonomies/\\{dataTaxonomy}/attributes/\\{data_attribute_id}
          class Path
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Create DataTaxonomy request.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] parent
        #   @return [::String]
        # @!attribute [rw] data_taxonomy_id
        #   @return [::String]
        #     Required. DataTaxonomy identifier.
        #     * Must contain only lowercase letters, numbers and hyphens.
        #     * Must start with a letter.
        #     * Must be between 1-63 characters.
        #     * Must end with a number or a letter.
        #     * Must be unique within the Project.
        # @!attribute [rw] data_taxonomy
        #   @return [::Google::Cloud::Dataplex::V1::DataTaxonomy]
        #     Required. DataTaxonomy resource.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class CreateDataTaxonomyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update DataTaxonomy request.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update.
        # @!attribute [rw] data_taxonomy
        #   @return [::Google::Cloud::Dataplex::V1::DataTaxonomy]
        #     Required. Only fields specified in `update_mask` are updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class UpdateDataTaxonomyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get DataTaxonomy request.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] name
        #   @return [::String]
        class GetDataTaxonomyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List DataTaxonomies request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the DataTaxonomy location, of the form:
        #     projects/\\{project_number}/locations/\\{location_id}
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of DataTaxonomies to return. The service may
        #     return fewer than this value. If unspecified, at most 10 DataTaxonomies
        #     will be returned. The maximum value is 1000; values above 1000 will be
        #     coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous ` ListDataTaxonomies` call.
        #     Provide this to retrieve the subsequent page. When paginating, all other
        #     parameters provided to ` ListDataTaxonomies` must match the call that
        #     provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Order by fields for the result.
        class ListDataTaxonomiesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List DataTaxonomies response.
        # @!attribute [rw] data_taxonomies
        #   @return [::Array<::Google::Cloud::Dataplex::V1::DataTaxonomy>]
        #     DataTaxonomies under the given parent location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable_locations
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDataTaxonomiesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete DataTaxonomy request.
        # @deprecated This message is deprecated and may be removed in the next major version update.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the DataTaxonomy:
        #     projects/\\{project_number}/locations/\\{location_id}/dataTaxonomies/\\{data_taxonomy_id}
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If the client provided etag value does not match the current etag
        #     value,the DeleteDataTaxonomy method returns an ABORTED error.
        class DeleteDataTaxonomyRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Create DataAttribute request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent data taxonomy
        #     projects/\\{project_number}/locations/\\{location_id}/dataTaxonomies/\\{data_taxonomy_id}
        # @!attribute [rw] data_attribute_id
        #   @return [::String]
        #     Required. DataAttribute identifier.
        #     * Must contain only lowercase letters, numbers and hyphens.
        #     * Must start with a letter.
        #     * Must be between 1-63 characters.
        #     * Must end with a number or a letter.
        #     * Must be unique within the DataTaxonomy.
        # @!attribute [rw] data_attribute
        #   @return [::Google::Cloud::Dataplex::V1::DataAttribute]
        #     Required. DataAttribute resource.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class CreateDataAttributeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update DataAttribute request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update.
        # @!attribute [rw] data_attribute
        #   @return [::Google::Cloud::Dataplex::V1::DataAttribute]
        #     Required. Only fields specified in `update_mask` are updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class UpdateDataAttributeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get DataAttribute request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the dataAttribute:
        #     projects/\\{project_number}/locations/\\{location_id}/dataTaxonomies/\\{dataTaxonomy}/attributes/\\{data_attribute_id}
        class GetDataAttributeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List DataAttributes request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the DataTaxonomy:
        #     projects/\\{project_number}/locations/\\{location_id}/dataTaxonomies/\\{data_taxonomy_id}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of DataAttributes to return. The service may
        #     return fewer than this value. If unspecified, at most 10 dataAttributes
        #     will be returned. The maximum value is 1000; values above 1000 will be
        #     coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListDataAttributes` call.
        #     Provide this to retrieve the subsequent page. When paginating, all other
        #     parameters provided to `ListDataAttributes` must match the call that
        #     provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Order by fields for the result.
        class ListDataAttributesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List DataAttributes response.
        # @!attribute [rw] data_attributes
        #   @return [::Array<::Google::Cloud::Dataplex::V1::DataAttribute>]
        #     DataAttributes under the given parent DataTaxonomy.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable_locations
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDataAttributesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete DataAttribute request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the DataAttribute:
        #     projects/\\{project_number}/locations/\\{location_id}/dataTaxonomies/\\{dataTaxonomy}/attributes/\\{data_attribute_id}
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If the client provided etag value does not match the current etag
        #     value, the DeleteDataAttribute method returns an ABORTED error response.
        class DeleteDataAttributeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Create DataAttributeBinding request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent data taxonomy
        #     projects/\\{project_number}/locations/\\{location_id}
        # @!attribute [rw] data_attribute_binding_id
        #   @return [::String]
        #     Required. DataAttributeBinding identifier.
        #     * Must contain only lowercase letters, numbers and hyphens.
        #     * Must start with a letter.
        #     * Must be between 1-63 characters.
        #     * Must end with a number or a letter.
        #     * Must be unique within the Location.
        # @!attribute [rw] data_attribute_binding
        #   @return [::Google::Cloud::Dataplex::V1::DataAttributeBinding]
        #     Required. DataAttributeBinding resource.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class CreateDataAttributeBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update DataAttributeBinding request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update.
        # @!attribute [rw] data_attribute_binding
        #   @return [::Google::Cloud::Dataplex::V1::DataAttributeBinding]
        #     Required. Only fields specified in `update_mask` are updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class UpdateDataAttributeBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get DataAttributeBinding request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the DataAttributeBinding:
        #     projects/\\{project_number}/locations/\\{location_id}/dataAttributeBindings/\\{data_attribute_binding_id}
        class GetDataAttributeBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List DataAttributeBindings request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the Location:
        #     projects/\\{project_number}/locations/\\{location_id}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of DataAttributeBindings to return. The service
        #     may return fewer than this value. If unspecified, at most 10
        #     DataAttributeBindings will be returned. The maximum value is 1000; values
        #     above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListDataAttributeBindings`
        #     call. Provide this to retrieve the subsequent page. When paginating, all
        #     other parameters provided to `ListDataAttributeBindings` must match the
        #     call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter request.
        #     Filter using resource: filter=resource:"resource-name"
        #     Filter using attribute: filter=attributes:"attribute-name"
        #     Filter using attribute in paths list:
        #     filter=paths.attributes:"attribute-name"
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Order by fields for the result.
        class ListDataAttributeBindingsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List DataAttributeBindings response.
        # @!attribute [rw] data_attribute_bindings
        #   @return [::Array<::Google::Cloud::Dataplex::V1::DataAttributeBinding>]
        #     DataAttributeBindings under the given parent Location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable_locations
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListDataAttributeBindingsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete DataAttributeBinding request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the DataAttributeBinding:
        #     projects/\\{project_number}/locations/\\{location_id}/dataAttributeBindings/\\{data_attribute_binding_id}
        # @!attribute [rw] etag
        #   @return [::String]
        #     Required. If the client provided etag value does not match the current etag
        #     value, the DeleteDataAttributeBindingRequest method returns an ABORTED
        #     error response. Etags must be used when calling the
        #     DeleteDataAttributeBinding.
        class DeleteDataAttributeBindingRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
