# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        # DataProfileScan related setting.
        # @!attribute [rw] sampling_percent
        #   @return [::Float]
        #     Optional. The percentage of the records to be selected from the dataset for
        #     DataScan.
        #
        #     * Value can range between 0.0 and 100.0 with up to 3 significant decimal
        #     digits.
        #     * Sampling is not applied if `sampling_percent` is not specified, 0 or
        #     100.
        # @!attribute [rw] row_filter
        #   @return [::String]
        #     Optional. A filter applied to all rows in a single DataScan job.
        #     The filter needs to be a valid SQL expression for a WHERE clause in
        #     BigQuery standard SQL syntax.
        #     Example: col1 >= 0 AND col2 < 10
        # @!attribute [rw] post_scan_actions
        #   @return [::Google::Cloud::Dataplex::V1::DataProfileSpec::PostScanActions]
        #     Optional. Actions to take upon job completion..
        # @!attribute [rw] include_fields
        #   @return [::Google::Cloud::Dataplex::V1::DataProfileSpec::SelectedFields]
        #     Optional. The fields to include in data profile.
        #
        #     If not specified, all fields at the time of profile scan job execution are
        #     included, except for ones listed in `exclude_fields`.
        # @!attribute [rw] exclude_fields
        #   @return [::Google::Cloud::Dataplex::V1::DataProfileSpec::SelectedFields]
        #     Optional. The fields to exclude from data profile.
        #
        #     If specified, the fields will be excluded from data profile, regardless of
        #     `include_fields` value.
        # @!attribute [rw] catalog_publishing_enabled
        #   @return [::Boolean]
        #     Optional. If set, the latest DataScan job result will be published as
        #     Dataplex Universal Catalog metadata.
        class DataProfileSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # The configuration of post scan actions of DataProfileScan job.
          # @!attribute [rw] bigquery_export
          #   @return [::Google::Cloud::Dataplex::V1::DataProfileSpec::PostScanActions::BigQueryExport]
          #     Optional. If set, results will be exported to the provided BigQuery
          #     table.
          class PostScanActions
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The configuration of BigQuery export post scan action.
            # @!attribute [rw] results_table
            #   @return [::String]
            #     Optional. The BigQuery table to export DataProfileScan results to.
            #     Format:
            #     //bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
            class BigQueryExport
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # The specification for fields to include or exclude in data profile scan.
          # @!attribute [rw] field_names
          #   @return [::Array<::String>]
          #     Optional. Expected input is a list of fully qualified names of fields as
          #     in the schema.
          #
          #     Only top-level field names for nested fields are supported.
          #     For instance, if 'x' is of nested field type, listing 'x' is supported
          #     but 'x.y.z' is not supported. Here 'y' and 'y.z' are nested fields of
          #     'x'.
          class SelectedFields
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # DataProfileResult defines the output of DataProfileScan. Each field of the
        # table will have field type specific profile result.
        # @!attribute [r] row_count
        #   @return [::Integer]
        #     Output only. The count of rows scanned.
        # @!attribute [r] profile
        #   @return [::Google::Cloud::Dataplex::V1::DataProfileResult::Profile]
        #     Output only. The profile information per field.
        # @!attribute [r] scanned_data
        #   @return [::Google::Cloud::Dataplex::V1::ScannedData]
        #     Output only. The data scanned for this result.
        # @!attribute [r] post_scan_actions_result
        #   @return [::Google::Cloud::Dataplex::V1::DataProfileResult::PostScanActionsResult]
        #     Output only. The result of post scan actions.
        # @!attribute [r] catalog_publishing_status
        #   @return [::Google::Cloud::Dataplex::V1::DataScanCatalogPublishingStatus]
        #     Output only. The status of publishing the data scan as Dataplex Universal
        #     Catalog metadata.
        class DataProfileResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Contains name, type, mode and field type specific profile information.
          # @!attribute [r] fields
          #   @return [::Array<::Google::Cloud::Dataplex::V1::DataProfileResult::Profile::Field>]
          #     Output only. List of fields with structural and profile information for
          #     each field.
          class Profile
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A field within a table.
            # @!attribute [r] name
            #   @return [::String]
            #     Output only. The name of the field.
            # @!attribute [r] type
            #   @return [::String]
            #     Output only. The data type retrieved from the schema of the data
            #     source. For instance, for a BigQuery native table, it is the [BigQuery
            #     Table
            #     Schema](https://cloud.google.com/bigquery/docs/reference/rest/v2/tables#tablefieldschema).
            #     For a Dataplex Universal Catalog Entity, it is the [Entity
            #     Schema](https://cloud.google.com/dataplex/docs/reference/rpc/google.cloud.dataplex.v1#type_3).
            # @!attribute [r] mode
            #   @return [::String]
            #     Output only. The mode of the field. Possible values include:
            #
            #     * REQUIRED, if it is a required field.
            #     * NULLABLE, if it is an optional field.
            #     * REPEATED, if it is a repeated field.
            # @!attribute [r] profile
            #   @return [::Google::Cloud::Dataplex::V1::DataProfileResult::Profile::Field::ProfileInfo]
            #     Output only. Profile information for the corresponding field.
            class Field
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # The profile information for each field type.
              # @!attribute [r] null_ratio
              #   @return [::Float]
              #     Output only. Ratio of rows with null value against total scanned
              #     rows.
              # @!attribute [r] distinct_ratio
              #   @return [::Float]
              #     Output only. Ratio of rows with distinct values against total scanned
              #     rows. Not available for complex non-groupable field type, including
              #     RECORD, ARRAY, GEOGRAPHY, and JSON, as well as fields with REPEATABLE
              #     mode.
              # @!attribute [r] top_n_values
              #   @return [::Array<::Google::Cloud::Dataplex::V1::DataProfileResult::Profile::Field::ProfileInfo::TopNValue>]
              #     Output only. The list of top N non-null values, frequency and ratio
              #     with which they occur in the scanned data. N is 10 or equal to the
              #     number of distinct values in the field, whichever is smaller. Not
              #     available for complex non-groupable field type, including RECORD,
              #     ARRAY, GEOGRAPHY, and JSON, as well as fields with REPEATABLE mode.
              # @!attribute [rw] string_profile
              #   @return [::Google::Cloud::Dataplex::V1::DataProfileResult::Profile::Field::ProfileInfo::StringFieldInfo]
              #     String type field information.
              #
              #     Note: The following fields are mutually exclusive: `string_profile`, `integer_profile`, `double_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              # @!attribute [rw] integer_profile
              #   @return [::Google::Cloud::Dataplex::V1::DataProfileResult::Profile::Field::ProfileInfo::IntegerFieldInfo]
              #     Integer type field information.
              #
              #     Note: The following fields are mutually exclusive: `integer_profile`, `string_profile`, `double_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              # @!attribute [rw] double_profile
              #   @return [::Google::Cloud::Dataplex::V1::DataProfileResult::Profile::Field::ProfileInfo::DoubleFieldInfo]
              #     Double type field information.
              #
              #     Note: The following fields are mutually exclusive: `double_profile`, `string_profile`, `integer_profile`. If a field in that set is populated, all other fields in the set will automatically be cleared.
              class ProfileInfo
                include ::Google::Protobuf::MessageExts
                extend ::Google::Protobuf::MessageExts::ClassMethods

                # The profile information for a string type field.
                # @!attribute [r] min_length
                #   @return [::Integer]
                #     Output only. Minimum length of non-null values in the scanned data.
                # @!attribute [r] max_length
                #   @return [::Integer]
                #     Output only. Maximum length of non-null values in the scanned data.
                # @!attribute [r] average_length
                #   @return [::Float]
                #     Output only. Average length of non-null values in the scanned data.
                class StringFieldInfo
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods
                end

                # The profile information for an integer type field.
                # @!attribute [r] average
                #   @return [::Float]
                #     Output only. Average of non-null values in the scanned data. NaN,
                #     if the field has a NaN.
                # @!attribute [r] standard_deviation
                #   @return [::Float]
                #     Output only. Standard deviation of non-null values in the scanned
                #     data. NaN, if the field has a NaN.
                # @!attribute [r] min
                #   @return [::Integer]
                #     Output only. Minimum of non-null values in the scanned data. NaN,
                #     if the field has a NaN.
                # @!attribute [r] quartiles
                #   @return [::Array<::Integer>]
                #     Output only. A quartile divides the number of data points into four
                #     parts, or quarters, of more-or-less equal size. Three main
                #     quartiles used are: The first quartile (Q1) splits off the lowest
                #     25% of data from the highest 75%. It is also known as the lower or
                #     25th empirical quartile, as 25% of the data is below this point.
                #     The second quartile (Q2) is the median of a data set. So, 50% of
                #     the data lies below this point. The third quartile (Q3) splits off
                #     the highest 25% of data from the lowest 75%. It is known as the
                #     upper or 75th empirical quartile, as 75% of the data lies below
                #     this point. Here, the quartiles is provided as an ordered list of
                #     approximate quartile values for the scanned data, occurring in
                #     order Q1, median, Q3.
                # @!attribute [r] max
                #   @return [::Integer]
                #     Output only. Maximum of non-null values in the scanned data. NaN,
                #     if the field has a NaN.
                class IntegerFieldInfo
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods
                end

                # The profile information for a double type field.
                # @!attribute [r] average
                #   @return [::Float]
                #     Output only. Average of non-null values in the scanned data. NaN,
                #     if the field has a NaN.
                # @!attribute [r] standard_deviation
                #   @return [::Float]
                #     Output only. Standard deviation of non-null values in the scanned
                #     data. NaN, if the field has a NaN.
                # @!attribute [r] min
                #   @return [::Float]
                #     Output only. Minimum of non-null values in the scanned data. NaN,
                #     if the field has a NaN.
                # @!attribute [r] quartiles
                #   @return [::Array<::Float>]
                #     Output only. A quartile divides the number of data points into four
                #     parts, or quarters, of more-or-less equal size. Three main
                #     quartiles used are: The first quartile (Q1) splits off the lowest
                #     25% of data from the highest 75%. It is also known as the lower or
                #     25th empirical quartile, as 25% of the data is below this point.
                #     The second quartile (Q2) is the median of a data set. So, 50% of
                #     the data lies below this point. The third quartile (Q3) splits off
                #     the highest 25% of data from the lowest 75%. It is known as the
                #     upper or 75th empirical quartile, as 75% of the data lies below
                #     this point. Here, the quartiles is provided as an ordered list of
                #     quartile values for the scanned data, occurring in order Q1,
                #     median, Q3.
                # @!attribute [r] max
                #   @return [::Float]
                #     Output only. Maximum of non-null values in the scanned data. NaN,
                #     if the field has a NaN.
                class DoubleFieldInfo
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods
                end

                # Top N non-null values in the scanned data.
                # @!attribute [r] value
                #   @return [::String]
                #     Output only. String value of a top N non-null value.
                # @!attribute [r] count
                #   @return [::Integer]
                #     Output only. Count of the corresponding value in the scanned data.
                # @!attribute [r] ratio
                #   @return [::Float]
                #     Output only. Ratio of the corresponding value in the field against
                #     the total number of rows in the scanned data.
                class TopNValue
                  include ::Google::Protobuf::MessageExts
                  extend ::Google::Protobuf::MessageExts::ClassMethods
                end
              end
            end
          end

          # The result of post scan actions of DataProfileScan job.
          # @!attribute [r] bigquery_export_result
          #   @return [::Google::Cloud::Dataplex::V1::DataProfileResult::PostScanActionsResult::BigQueryExportResult]
          #     Output only. The result of BigQuery export post scan action.
          class PostScanActionsResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The result of BigQuery export post scan action.
            # @!attribute [r] state
            #   @return [::Google::Cloud::Dataplex::V1::DataProfileResult::PostScanActionsResult::BigQueryExportResult::State]
            #     Output only. Execution state for the BigQuery exporting.
            # @!attribute [r] message
            #   @return [::String]
            #     Output only. Additional information about the BigQuery exporting.
            class BigQueryExportResult
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods

              # Execution state for the exporting.
              module State
                # The exporting state is unspecified.
                STATE_UNSPECIFIED = 0

                # The exporting completed successfully.
                SUCCEEDED = 1

                # The exporting is no longer running due to an error.
                FAILED = 2

                # The exporting is skipped due to no valid scan result to export
                # (usually caused by scan failed).
                SKIPPED = 3
              end
            end
          end
        end
      end
    end
  end
end
