# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        # DataDocumentation scan related spec.
        class DataDocumentationSpec
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # The output of a DataDocumentation scan.
        # @!attribute [r] table_result
        #   @return [::Google::Cloud::Dataplex::V1::DataDocumentationResult::TableResult]
        #     Output only. Table result for insights.
        class DataDocumentationResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Generated metadata about the table.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The service-qualified full resource name of the cloud
          #     resource. Ex:
          #     //bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tables/TABLE_ID
          # @!attribute [r] overview
          #   @return [::String]
          #     Output only. Generated description of the table.
          # @!attribute [r] schema
          #   @return [::Google::Cloud::Dataplex::V1::DataDocumentationResult::Schema]
          #     Output only. Schema of the table with generated metadata of the columns
          #     in the schema.
          # @!attribute [r] queries
          #   @return [::Array<::Google::Cloud::Dataplex::V1::DataDocumentationResult::Query>]
          #     Output only. Sample SQL queries for the table.
          class TableResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # A sample SQL query in data documentation.
          # @!attribute [r] sql
          #   @return [::String]
          #     Output only. The SQL query string which can be executed.
          # @!attribute [r] description
          #   @return [::String]
          #     Output only. The description for the query.
          class Query
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Schema of the table with generated metadata of columns.
          # @!attribute [r] fields
          #   @return [::Array<::Google::Cloud::Dataplex::V1::DataDocumentationResult::Field>]
          #     Output only. The list of columns.
          class Schema
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Column of a table with generated metadata and nested fields.
          # @!attribute [r] name
          #   @return [::String]
          #     Output only. The name of the column.
          # @!attribute [r] description
          #   @return [::String]
          #     Output only. Generated description for columns and fields.
          # @!attribute [r] fields
          #   @return [::Array<::Google::Cloud::Dataplex::V1::DataDocumentationResult::Field>]
          #     Output only. Nested fields.
          class Field
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end
      end
    end
  end
end
