# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        # Create content request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent lake:
        #     projects/\\{project_id}/locations/\\{location_id}/lakes/\\{lake_id}
        # @!attribute [rw] content
        #   @return [::Google::Cloud::Dataplex::V1::Content]
        #     Required. Content resource.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class CreateContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update content request.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update.
        # @!attribute [rw] content
        #   @return [::Google::Cloud::Dataplex::V1::Content]
        #     Required. Update description.
        #     Only fields specified in `update_mask` are updated.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class UpdateContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete content request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the content:
        #     projects/\\{project_id}/locations/\\{location_id}/lakes/\\{lake_id}/content/\\{content_id}
        class DeleteContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List content request. Returns the BASIC Content view.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent lake:
        #     projects/\\{project_id}/locations/\\{location_id}/lakes/\\{lake_id}
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of content to return. The service may return fewer
        #     than this value. If unspecified, at most 10 content will be returned. The
        #     maximum value is 1000; values above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListContent` call. Provide
        #     this to retrieve the subsequent page. When paginating, all other parameters
        #     provided to `ListContent` must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter request. Filters are case-sensitive.
        #     The following formats are supported:
        #
        #     labels.key1 = "value1"
        #     labels:key1
        #     type = "NOTEBOOK"
        #     type = "SQL_SCRIPT"
        #
        #     These restrictions can be coinjoined with AND, OR and NOT conjunctions.
        class ListContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List content response.
        # @!attribute [rw] content
        #   @return [::Array<::Google::Cloud::Dataplex::V1::Content>]
        #     Content under the given parent lake.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListContentResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get content request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the content:
        #     projects/\\{project_id}/locations/\\{location_id}/lakes/\\{lake_id}/content/\\{content_id}
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Dataplex::V1::GetContentRequest::ContentView]
        #     Optional. Specify content view to make a partial request.
        class GetContentRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Specifies whether the request should return the full or the partial
          # representation.
          module ContentView
            # Content view not specified. Defaults to BASIC.
            # The API will default to the BASIC view.
            CONTENT_VIEW_UNSPECIFIED = 0

            # Will not return the `data_text` field.
            BASIC = 1

            # Returns the complete proto.
            FULL = 2
          end
        end
      end
    end
  end
end
