# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        # A Resource designed to manage encryption configurations for customers to
        # support Customer Managed Encryption Keys (CMEK).
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The resource name of the EncryptionConfig.
        #     Format:
        #     organizations/\\{organization}/locations/\\{location}/encryptionConfigs/\\{encryption_config}
        #     Global location is not supported.
        # @!attribute [rw] key
        #   @return [::String]
        #     Optional. If a key is chosen, it means that the customer is using CMEK.
        #     If a key is not chosen, it means that the customer is using Google managed
        #     encryption.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the Encryption configuration was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the Encryption configuration was last updated.
        # @!attribute [r] encryption_state
        #   @return [::Google::Cloud::Dataplex::V1::EncryptionConfig::EncryptionState]
        #     Output only. The state of encryption of the databases.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Etag of the EncryptionConfig. This is a strong etag.
        # @!attribute [r] failure_details
        #   @return [::Google::Cloud::Dataplex::V1::EncryptionConfig::FailureDetails]
        #     Output only. Details of the failure if anything related to Cmek db fails.
        # @!attribute [rw] enable_metastore_encryption
        #   @return [::Boolean]
        #     Optional. Represent the state of CMEK opt-in for metastore.
        class EncryptionConfig
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Details of the failure if anything related to Cmek db fails.
          # @!attribute [r] error_code
          #   @return [::Google::Cloud::Dataplex::V1::EncryptionConfig::FailureDetails::ErrorCode]
          #     Output only. The error code for the failure.
          # @!attribute [r] error_message
          #   @return [::String]
          #     Output only. The error message will be shown to the user. Set only if the
          #     error code is REQUIRE_USER_ACTION.
          class FailureDetails
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Error code for the failure if anything related to Cmek db fails.
            module ErrorCode
              # The error code is not specified
              UNKNOWN = 0

              # Error because of internal server error, will be retried automatically.
              INTERNAL_ERROR = 1

              # User action is required to resolve the error.
              REQUIRE_USER_ACTION = 2
            end
          end

          # State of encryption of the databases when EncryptionConfig is created or
          # updated.
          module EncryptionState
            # State is not specified.
            ENCRYPTION_STATE_UNSPECIFIED = 0

            # The encryption state of the database when the EncryptionConfig is created
            # or updated. If the encryption fails, it is retried indefinitely and the
            # state is shown as ENCRYPTING.
            ENCRYPTING = 1

            # The encryption of data has completed successfully.
            COMPLETED = 2

            # The encryption of data has failed.
            # The state is set to FAILED when the encryption fails due to reasons like
            # permission issues, invalid key etc.
            FAILED = 3
          end
        end

        # Create EncryptionConfig Request
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location at which the EncryptionConfig is to be created.
        # @!attribute [rw] encryption_config_id
        #   @return [::String]
        #     Required. The ID of the
        #     {::Google::Cloud::Dataplex::V1::EncryptionConfig EncryptionConfig} to create.
        #     Currently, only a value of "default" is supported.
        # @!attribute [rw] encryption_config
        #   @return [::Google::Cloud::Dataplex::V1::EncryptionConfig]
        #     Required. The EncryptionConfig to create.
        class CreateEncryptionConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get EncryptionConfig Request
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the EncryptionConfig to fetch.
        class GetEncryptionConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update EncryptionConfig Request
        # @!attribute [rw] encryption_config
        #   @return [::Google::Cloud::Dataplex::V1::EncryptionConfig]
        #     Required. The EncryptionConfig to update.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Mask of fields to update.
        #     The service treats an omitted field mask as an implied field mask
        #     equivalent to all fields that are populated (have a non-empty value).
        class UpdateEncryptionConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete EncryptionConfig Request
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the EncryptionConfig to delete.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. Etag of the EncryptionConfig. This is a strong etag.
        class DeleteEncryptionConfigRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List EncryptionConfigs Request
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The location for which the EncryptionConfig is to be listed.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of EncryptionConfigs to return. The service may
        #     return fewer than this value. If unspecified, at most 10 EncryptionConfigs
        #     will be returned. The maximum value is 1000; values above 1000 will be
        #     coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListEncryptionConfigs` call.
        #     Provide this to retrieve the subsequent page. When paginating, the
        #     parameters - filter and order_by provided to `ListEncryptionConfigs` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter the EncryptionConfigs to be returned.
        #     Using bare literals: (These values will be matched anywhere it may appear
        #     in the object's field values)
        #     * filter=some_value
        #     Using fields: (These values will be matched only in the specified field)
        #     * filter=some_field=some_value
        #     Supported fields:
        #     * name, key, create_time, update_time, encryption_state
        #     Example:
        #     * filter=name=organizations/123/locations/us-central1/encryptionConfigs/test-config
        #     conjunctions: (AND, OR, NOT)
        #     * filter=name=organizations/123/locations/us-central1/encryptionConfigs/test-config
        #     AND mode=CMEK
        #     logical operators: (>, <, >=, <=, !=, =, :),
        #     * filter=create_time>2024-05-01T00:00:00.000Z
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Order by fields for the result.
        class ListEncryptionConfigsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List EncryptionConfigs Response
        # @!attribute [rw] encryption_configs
        #   @return [::Array<::Google::Cloud::Dataplex::V1::EncryptionConfig>]
        #     The list of EncryptionConfigs under the given parent location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable_locations
        #   @return [::Array<::String>]
        #     Locations that could not be reached.
        class ListEncryptionConfigsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
