# frozen_string_literal: true

# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        # AspectType is a template for creating Aspects, and represents the
        # JSON-schema for a given Entry, for example, BigQuery Table Schema.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The relative resource name of the AspectType, of the form:
        #     projects/\\{project_number}/locations/\\{location_id}/aspectTypes/\\{aspect_type_id}.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System generated globally unique ID for the AspectType.
        #     If you delete and recreate the AspectType with the same name, then this ID
        #     will be different.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the AspectType was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the AspectType was last updated.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the AspectType.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly display name.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels for the AspectType.
        # @!attribute [rw] etag
        #   @return [::String]
        #     The service computes this checksum. The client may send it on update and
        #     delete requests to ensure it has an up-to-date value before proceeding.
        # @!attribute [rw] data_classification
        #   @return [::Google::Cloud::Dataplex::V1::AspectType::DataClassification]
        #     Optional. Immutable. Stores data classification of the aspect.
        # @!attribute [rw] authorization
        #   @return [::Google::Cloud::Dataplex::V1::AspectType::Authorization]
        #     Immutable. Defines the Authorization for this type.
        # @!attribute [rw] metadata_template
        #   @return [::Google::Cloud::Dataplex::V1::AspectType::MetadataTemplate]
        #     Required. MetadataTemplate of the aspect.
        # @!attribute [r] transfer_status
        #   @return [::Google::Cloud::Dataplex::V1::TransferStatus]
        #     Output only. Denotes the transfer status of the Aspect Type. It is
        #     unspecified for Aspect Types created from Dataplex API.
        class AspectType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Authorization for an AspectType.
          # @!attribute [rw] alternate_use_permission
          #   @return [::String]
          #     Immutable. The IAM permission grantable on the EntryGroup to allow access
          #     to instantiate Aspects of Dataplex Universal Catalog owned AspectTypes,
          #     only settable for Dataplex Universal Catalog owned Types.
          class Authorization
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # MetadataTemplate definition for an AspectType.
          # @!attribute [rw] index
          #   @return [::Integer]
          #     Optional. Index is used to encode Template messages. The value of index
          #     can range between 1 and 2,147,483,647. Index must be unique within all
          #     fields in a Template. (Nested Templates can reuse indexes). Once a
          #     Template is defined, the index cannot be changed, because it identifies
          #     the field in the actual storage format. Index is a mandatory field, but
          #     it is optional for top level fields, and map/array "values" definitions.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. The name of the field.
          # @!attribute [rw] type
          #   @return [::String]
          #     Required. The datatype of this field. The following values are supported:
          #
          #     Primitive types:
          #
          #     * string
          #     * int
          #     * bool
          #     * double
          #     * datetime. Must be of the format RFC3339 UTC "Zulu" (Examples:
          #     "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z").
          #
          #     Complex types:
          #
          #     * enum
          #     * array
          #     * map
          #     * record
          # @!attribute [rw] record_fields
          #   @return [::Array<::Google::Cloud::Dataplex::V1::AspectType::MetadataTemplate>]
          #     Optional. Field definition. You must specify it if the type is record. It
          #     defines the nested fields.
          # @!attribute [rw] enum_values
          #   @return [::Array<::Google::Cloud::Dataplex::V1::AspectType::MetadataTemplate::EnumValue>]
          #     Optional. The list of values for an enum type. You must define it if the
          #     type is enum.
          # @!attribute [rw] map_items
          #   @return [::Google::Cloud::Dataplex::V1::AspectType::MetadataTemplate]
          #     Optional. If the type is map, set map_items. map_items can refer to a
          #     primitive field or a complex (record only) field. To specify a primitive
          #     field, you only need to set name and type in the nested
          #     MetadataTemplate. The recommended value for the name field is item, as
          #     this isn't used in the actual payload.
          # @!attribute [rw] array_items
          #   @return [::Google::Cloud::Dataplex::V1::AspectType::MetadataTemplate]
          #     Optional. If the type is array, set array_items. array_items can refer
          #     to a primitive field or a complex (record only) field. To specify a
          #     primitive field, you only need to set name and type in the nested
          #     MetadataTemplate. The recommended value for the name field is item, as
          #     this isn't used in the actual payload.
          # @!attribute [rw] type_id
          #   @return [::String]
          #     Optional. You can use type id if this definition of the field needs to be
          #     reused later. The type id must be unique across the entire template. You
          #     can only specify it if the field type is record.
          # @!attribute [rw] type_ref
          #   @return [::String]
          #     Optional. A reference to another field definition (not an inline
          #     definition). The value must be equal to the value of an id field defined
          #     elsewhere in the MetadataTemplate. Only fields with record type can
          #     refer to other fields.
          # @!attribute [rw] constraints
          #   @return [::Google::Cloud::Dataplex::V1::AspectType::MetadataTemplate::Constraints]
          #     Optional. Specifies the constraints on this field.
          # @!attribute [rw] annotations
          #   @return [::Google::Cloud::Dataplex::V1::AspectType::MetadataTemplate::Annotations]
          #     Optional. Specifies annotations on this field.
          class MetadataTemplate
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Definition of Enumvalue, to be used for enum fields.
            # @!attribute [rw] index
            #   @return [::Integer]
            #     Required. Index for the enum value. It can't be modified.
            # @!attribute [rw] name
            #   @return [::String]
            #     Required. Name of the enumvalue. This is the actual value that the
            #     aspect can contain.
            # @!attribute [rw] deprecated
            #   @return [::String]
            #     Optional. You can set this message if you need to deprecate an enum
            #     value.
            class EnumValue
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Definition of the constraints of a field.
            # @!attribute [rw] required
            #   @return [::Boolean]
            #     Optional. Marks this field as optional or required.
            class Constraints
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Definition of the annotations of a field.
            # @!attribute [rw] deprecated
            #   @return [::String]
            #     Optional. Marks a field as deprecated. You can include a deprecation
            #     message.
            # @!attribute [rw] display_name
            #   @return [::String]
            #     Optional. Display name for a field.
            # @!attribute [rw] description
            #   @return [::String]
            #     Optional. Description for a field.
            # @!attribute [rw] display_order
            #   @return [::Integer]
            #     Optional. Display order for a field. You can use this to reorder where
            #     a field is rendered.
            # @!attribute [rw] string_type
            #   @return [::String]
            #     Optional. You can use String Type annotations to specify special
            #     meaning to string fields. The following values are supported:
            #
            #     * richText: The field must be interpreted as a rich text field.
            #     * url: A fully qualified URL link.
            #     * resource: A service qualified resource reference.
            # @!attribute [rw] string_values
            #   @return [::Array<::String>]
            #     Optional. Suggested hints for string fields. You can use them to
            #     suggest values to users through console.
            class Annotations
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Classifies the data stored by the aspect.
          module DataClassification
            # Denotes that the aspect contains only metadata.
            DATA_CLASSIFICATION_UNSPECIFIED = 0

            # Metadata and data classification.
            METADATA_AND_DATA = 1
          end
        end

        # An Entry Group represents a logical grouping of one or more Entries.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The relative resource name of the EntryGroup, in the format
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/entryGroups/\\{entry_group_id}.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System generated globally unique ID for the EntryGroup. If you
        #     delete and recreate the EntryGroup with the same name, this ID will be
        #     different.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the EntryGroup was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the EntryGroup was last updated.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the EntryGroup.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly display name.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels for the EntryGroup.
        # @!attribute [rw] etag
        #   @return [::String]
        #     This checksum is computed by the service, and might be sent on update and
        #     delete requests to ensure the client has an up-to-date value before
        #     proceeding.
        # @!attribute [r] transfer_status
        #   @return [::Google::Cloud::Dataplex::V1::TransferStatus]
        #     Output only. Denotes the transfer status of the Entry Group. It is
        #     unspecified for Entry Group created from Dataplex API.
        class EntryGroup
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Entry Type is a template for creating Entries.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. The relative resource name of the EntryType, of the form:
        #     projects/\\{project_number}/locations/\\{location_id}/entryTypes/\\{entry_type_id}.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System generated globally unique ID for the EntryType. This ID
        #     will be different if the EntryType is deleted and re-created with the same
        #     name.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the EntryType was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the EntryType was last updated.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. Description of the EntryType.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly display name.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels for the EntryType.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. This checksum is computed by the service, and might be sent on
        #     update and delete requests to ensure the client has an up-to-date value
        #     before proceeding.
        # @!attribute [rw] type_aliases
        #   @return [::Array<::String>]
        #     Optional. Indicates the classes this Entry Type belongs to, for example,
        #     TABLE, DATABASE, MODEL.
        # @!attribute [rw] platform
        #   @return [::String]
        #     Optional. The platform that Entries of this type belongs to.
        # @!attribute [rw] system
        #   @return [::String]
        #     Optional. The system that Entries of this type belongs to. Examples include
        #     CloudSQL, MariaDB etc
        # @!attribute [rw] required_aspects
        #   @return [::Array<::Google::Cloud::Dataplex::V1::EntryType::AspectInfo>]
        #     AspectInfo for the entry type.
        # @!attribute [rw] authorization
        #   @return [::Google::Cloud::Dataplex::V1::EntryType::Authorization]
        #     Immutable. Authorization defined for this type.
        class EntryType
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] type
          #   @return [::String]
          #     Required aspect type for the entry type.
          class AspectInfo
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Authorization for an Entry Type.
          # @!attribute [rw] alternate_use_permission
          #   @return [::String]
          #     Immutable. The IAM permission grantable on the Entry Group to allow
          #     access to instantiate Entries of Dataplex Universal Catalog owned Entry
          #     Types, only settable for Dataplex Universal Catalog owned Types.
          class Authorization
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # An aspect is a single piece of metadata describing an entry.
        # @!attribute [r] aspect_type
        #   @return [::String]
        #     Output only. The resource name of the type used to create this Aspect.
        # @!attribute [r] path
        #   @return [::String]
        #     Output only. The path in the entry under which the aspect is attached.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the Aspect was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the Aspect was last updated.
        # @!attribute [rw] data
        #   @return [::Google::Protobuf::Struct]
        #     Required. The content of the aspect, according to its aspect type schema.
        #     The maximum size of the field is 120KB (encoded as UTF-8).
        # @!attribute [rw] aspect_source
        #   @return [::Google::Cloud::Dataplex::V1::AspectSource]
        #     Optional. Information related to the source system of the aspect.
        class Aspect
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Information related to the source system of the aspect.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the aspect was created in the source system.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time the aspect was last updated in the source system.
        # @!attribute [rw] data_version
        #   @return [::String]
        #     The version of the data format used to produce this data. This field is
        #     used to indicated when the underlying data format changes (e.g., schema
        #     modifications, changes to the source URL format definition, etc).
        class AspectSource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An entry is a representation of a data resource that can be described by
        # various metadata.
        # @!attribute [rw] name
        #   @return [::String]
        #     Identifier. The relative resource name of the entry, in the format
        #     `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}`.
        # @!attribute [rw] entry_type
        #   @return [::String]
        #     Required. Immutable. The relative resource name of the entry type that was
        #     used to create this entry, in the format
        #     `projects/{project_id_or_number}/locations/{location_id}/entryTypes/{entry_type_id}`.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the entry was created in Dataplex Universal
        #     Catalog.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the entry was last updated in Dataplex Universal
        #     Catalog.
        # @!attribute [rw] aspects
        #   @return [::Google::Protobuf::Map{::String => ::Google::Cloud::Dataplex::V1::Aspect}]
        #     Optional. The aspects that are attached to the entry. Depending on how the
        #     aspect is attached to the entry, the format of the aspect key can be one of
        #     the following:
        #
        #     * If the aspect is attached directly to the entry:
        #     `{project_id_or_number}.{location_id}.{aspect_type_id}`
        #     * If the aspect is attached to an entry's path:
        #     `{project_id_or_number}.{location_id}.{aspect_type_id}@{path}`
        # @!attribute [rw] parent_entry
        #   @return [::String]
        #     Optional. Immutable. The resource name of the parent entry, in the format
        #     `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}`.
        # @!attribute [rw] fully_qualified_name
        #   @return [::String]
        #     Optional. A name for the entry that can be referenced by an external
        #     system. For more information, see [Fully qualified
        #     names](https://cloud.google.com/data-catalog/docs/fully-qualified-names).
        #     The maximum size of the field is 4000 characters.
        # @!attribute [rw] entry_source
        #   @return [::Google::Cloud::Dataplex::V1::EntrySource]
        #     Optional. Information related to the source system of the data resource
        #     that is represented by the entry.
        class Entry
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::Google::Cloud::Dataplex::V1::Aspect]
          class AspectsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Information related to the source system of the data resource that is
        # represented by the entry.
        # @!attribute [rw] resource
        #   @return [::String]
        #     The name of the resource in the source system.
        #     Maximum length is 4,000 characters.
        # @!attribute [rw] system
        #   @return [::String]
        #     The name of the source system.
        #     Maximum length is 64 characters.
        # @!attribute [rw] platform
        #   @return [::String]
        #     The platform containing the source system.
        #     Maximum length is 64 characters.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     A user-friendly display name.
        #     Maximum length is 500 characters.
        # @!attribute [rw] description
        #   @return [::String]
        #     A description of the data resource.
        #     Maximum length is 2,000 characters.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     User-defined labels.
        #     The maximum size of keys and values is 128 characters each.
        # @!attribute [rw] ancestors
        #   @return [::Array<::Google::Cloud::Dataplex::V1::EntrySource::Ancestor>]
        #     Immutable. The entries representing the ancestors of the data resource in
        #     the source system.
        # @!attribute [rw] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the resource was created in the source system.
        # @!attribute [rw] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     The time when the resource was last updated in the source system. If the
        #     entry exists in the system and its `EntrySource` has `update_time`
        #     populated, further updates to the `EntrySource` of the entry must provide
        #     incremental updates to its `update_time`.
        # @!attribute [r] location
        #   @return [::String]
        #     Output only. Location of the resource in the source system. You can search
        #     the entry by this location. By default, this should match the location of
        #     the entry group containing this entry. A different value allows capturing
        #     the source location for data external to Google Cloud.
        class EntrySource
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Information about individual items in the hierarchy that is associated with
          # the data resource.
          # @!attribute [rw] name
          #   @return [::String]
          #     Optional. The name of the ancestor resource.
          # @!attribute [rw] type
          #   @return [::String]
          #     Optional. The type of the ancestor resource.
          class Ancestor
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Create EntryGroup Request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the entryGroup, of the form:
        #     projects/\\{project_number}/locations/\\{location_id}
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] entry_group_id
        #   @return [::String]
        #     Required. EntryGroup identifier.
        # @!attribute [rw] entry_group
        #   @return [::Google::Cloud::Dataplex::V1::EntryGroup]
        #     Required. EntryGroup Resource.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. The service validates the request without performing any
        #     mutations. The default is false.
        class CreateEntryGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update EntryGroup Request.
        # @!attribute [rw] entry_group
        #   @return [::Google::Cloud::Dataplex::V1::EntryGroup]
        #     Required. EntryGroup Resource.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. The service validates the request, without performing any
        #     mutations. The default is false.
        class UpdateEntryGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete EntryGroup Request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the EntryGroup:
        #     `projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If the client provided etag value does not match the current etag
        #     value, the DeleteEntryGroupRequest method returns an ABORTED error
        #     response.
        class DeleteEntryGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List entryGroups request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the entryGroup location, of the form:
        #     `projects/{project_number}/locations/{location_id}`
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of EntryGroups to return. The service may return
        #     fewer than this value. If unspecified, the service returns at most 10
        #     EntryGroups. The maximum value is 1000; values above 1000 will be coerced
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListEntryGroups` call.
        #     Provide this to retrieve the subsequent page. When paginating, all other
        #     parameters you provide to `ListEntryGroups` must match the call that
        #     provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter request.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Order by fields for the result.
        class ListEntryGroupsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List entry groups response.
        # @!attribute [rw] entry_groups
        #   @return [::Array<::Google::Cloud::Dataplex::V1::EntryGroup>]
        #     Entry groups under the given parent location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable_locations
        #   @return [::Array<::String>]
        #     Locations that the service couldn't reach.
        class ListEntryGroupsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get EntryGroup request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the EntryGroup:
        #     `projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
        class GetEntryGroupRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Create EntryType Request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the EntryType, of the form:
        #     projects/\\{project_number}/locations/\\{location_id}
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] entry_type_id
        #   @return [::String]
        #     Required. EntryType identifier.
        # @!attribute [rw] entry_type
        #   @return [::Google::Cloud::Dataplex::V1::EntryType]
        #     Required. EntryType Resource.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. The service validates the request without performing any
        #     mutations. The default is false.
        class CreateEntryTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update EntryType Request.
        # @!attribute [rw] entry_type
        #   @return [::Google::Cloud::Dataplex::V1::EntryType]
        #     Required. EntryType Resource.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. The service validates the request without performing any
        #     mutations. The default is false.
        class UpdateEntryTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete EntryType Request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the EntryType:
        #     `projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}`.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If the client provided etag value does not match the current etag
        #     value, the DeleteEntryTypeRequest method returns an ABORTED error response.
        class DeleteEntryTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List EntryTypes request
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the EntryType location, of the form:
        #     `projects/{project_number}/locations/{location_id}`
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of EntryTypes to return. The service may return
        #     fewer than this value. If unspecified, the service returns at most 10
        #     EntryTypes. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListEntryTypes` call.
        #     Provide this to retrieve the subsequent page. When paginating, all other
        #     parameters you provided to `ListEntryTypes` must match the call that
        #     provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter request. Filters are case-sensitive.
        #     The service supports the following formats:
        #
        #     * labels.key1 = "value1"
        #     * labels:key1
        #     * name = "value"
        #
        #     These restrictions can be conjoined with AND, OR, and NOT conjunctions.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Orders the result by `name` or `create_time` fields.
        #     If not specified, the ordering is undefined.
        class ListEntryTypesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List EntryTypes response.
        # @!attribute [rw] entry_types
        #   @return [::Array<::Google::Cloud::Dataplex::V1::EntryType>]
        #     EntryTypes under the given parent location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable_locations
        #   @return [::Array<::String>]
        #     Locations that the service couldn't reach.
        class ListEntryTypesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get EntryType request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the EntryType:
        #     `projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}`.
        class GetEntryTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Create AspectType Request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the AspectType, of the form:
        #     projects/\\{project_number}/locations/\\{location_id}
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] aspect_type_id
        #   @return [::String]
        #     Required. AspectType identifier.
        # @!attribute [rw] aspect_type
        #   @return [::Google::Cloud::Dataplex::V1::AspectType]
        #     Required. AspectType Resource.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. The service validates the request without performing any
        #     mutations. The default is false.
        class CreateAspectTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update AspectType Request
        # @!attribute [rw] aspect_type
        #   @return [::Google::Cloud::Dataplex::V1::AspectType]
        #     Required. AspectType Resource
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. Mask of fields to update.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Only validate the request, but do not perform mutations.
        #     The default is false.
        class UpdateAspectTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete AspectType Request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the AspectType:
        #     `projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}`.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. If the client provided etag value does not match the current etag
        #     value, the DeleteAspectTypeRequest method returns an ABORTED error
        #     response.
        class DeleteAspectTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List AspectTypes request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the AspectType location, of the form:
        #     `projects/{project_number}/locations/{location_id}`
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Maximum number of AspectTypes to return. The service may return
        #     fewer than this value. If unspecified, the service returns at most 10
        #     AspectTypes. The maximum value is 1000; values above 1000 will be coerced
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListAspectTypes` call.
        #     Provide this to retrieve the subsequent page. When paginating, all other
        #     parameters you provide to `ListAspectTypes` must match the call that
        #     provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter request. Filters are case-sensitive.
        #     The service supports the following formats:
        #
        #     * labels.key1 = "value1"
        #     * labels:key1
        #     * name = "value"
        #
        #     These restrictions can be conjoined with AND, OR, and NOT conjunctions.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Orders the result by `name` or `create_time` fields.
        #     If not specified, the ordering is undefined.
        class ListAspectTypesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List AspectTypes response.
        # @!attribute [rw] aspect_types
        #   @return [::Array<::Google::Cloud::Dataplex::V1::AspectType>]
        #     AspectTypes under the given parent location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable_locations
        #   @return [::Array<::String>]
        #     Locations that the service couldn't reach.
        class ListAspectTypesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get AspectType request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the AspectType:
        #     `projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}`.
        class GetAspectTypeRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Create Entry request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent Entry Group:
        #     `projects/{project}/locations/{location}/entryGroups/{entry_group}`.
        # @!attribute [rw] entry_id
        #   @return [::String]
        #     Required. Entry identifier. It has to be unique within an Entry Group.
        #
        #     Entries corresponding to Google Cloud resources use an Entry ID format
        #     based on [full resource
        #     names](https://cloud.google.com/apis/design/resource_names#full_resource_name).
        #     The format is a full resource name of the resource without the
        #     prefix double slashes in the API service name part of the full resource
        #     name. This allows retrieval of entries using their associated resource
        #     name.
        #
        #     For example, if the full resource name of a resource is
        #     `//library.googleapis.com/shelves/shelf1/books/book2`,
        #     then the suggested entry_id is
        #     `library.googleapis.com/shelves/shelf1/books/book2`.
        #
        #     It is also suggested to follow the same convention for entries
        #     corresponding to resources from providers or systems other than Google
        #     Cloud.
        #
        #     The maximum size of the field is 4000 characters.
        # @!attribute [rw] entry
        #   @return [::Google::Cloud::Dataplex::V1::Entry]
        #     Required. Entry resource.
        class CreateEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update Entry request.
        # @!attribute [rw] entry
        #   @return [::Google::Cloud::Dataplex::V1::Entry]
        #     Required. Entry resource.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Optional. Mask of fields to update. To update Aspects, the update_mask must
        #     contain the value "aspects".
        #
        #     If the update_mask is empty, the service will update all modifiable fields
        #     present in the request.
        # @!attribute [rw] allow_missing
        #   @return [::Boolean]
        #     Optional. If set to true and the entry doesn't exist, the service will
        #     create it.
        # @!attribute [rw] delete_missing_aspects
        #   @return [::Boolean]
        #     Optional. If set to true and the aspect_keys specify aspect ranges, the
        #     service deletes any existing aspects from that range that weren't provided
        #     in the request.
        # @!attribute [rw] aspect_keys
        #   @return [::Array<::String>]
        #     Optional. The map keys of the Aspects which the service should modify. It
        #     supports the following syntaxes:
        #
        #     * `<aspect_type_reference>` - matches an aspect of the given type and empty
        #     path.
        #     * `<aspect_type_reference>@path` - matches an aspect of the given type and
        #     specified path. For example, to attach an aspect to a field that is
        #     specified by the `schema` aspect, the path should have the format
        #     `Schema.<field_name>`.
        #     * `<aspect_type_reference>@*` - matches aspects of the given type for all
        #     paths.
        #     * `*@path` - matches aspects of all types on the given path.
        #
        #     The service will not remove existing aspects matching the syntax unless
        #     `delete_missing_aspects` is set to true.
        #
        #     If this field is left empty, the service treats it as specifying
        #     exactly those Aspects present in the request.
        class UpdateEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete Entry request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Entry:
        #     `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
        class DeleteEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List Entries request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent Entry Group:
        #     `projects/{project}/locations/{location}/entryGroups/{entry_group}`.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Number of items to return per page. If there are remaining
        #     results, the service returns a next_page_token. If unspecified, the service
        #     returns at most 10 Entries. The maximum value is 100; values above 100 will
        #     be coerced to 100.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `ListEntries` call. Provide
        #     this to retrieve the subsequent page.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. A filter on the entries to return. Filters are case-sensitive.
        #     You can filter the request by the following fields:
        #
        #     * entry_type
        #     * entry_source.display_name
        #     * parent_entry
        #
        #     The comparison operators are =, !=, <, >, <=, >=. The service compares
        #     strings according to lexical order.
        #
        #     You can use the logical operators AND, OR, NOT in the filter.
        #
        #     You can use Wildcard "*", but for entry_type and parent_entry you need to
        #     provide the full project id or number.
        #
        #     You cannot use parent_entry in conjunction with other fields.
        #
        #     Example filter expressions:
        #
        #     * "entry_source.display_name=AnExampleDisplayName"
        #     * "entry_type=projects/example-project/locations/global/entryTypes/example-entry_type"
        #     * "entry_type=projects/example-project/locations/us/entryTypes/a* OR
        #     entry_type=projects/another-project/locations/*"
        #     * "NOT entry_source.display_name=AnotherExampleDisplayName"
        #     * "parent_entry=projects/example-project/locations/us/entryGroups/example-entry-group/entries/example-entry"
        class ListEntriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List Entries response.
        # @!attribute [rw] entries
        #   @return [::Array<::Google::Cloud::Dataplex::V1::Entry>]
        #     The list of entries under the given parent location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        class ListEntriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get Entry request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Entry:
        #     `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Dataplex::V1::EntryView]
        #     Optional. View to control which parts of an entry the service should
        #     return.
        # @!attribute [rw] aspect_types
        #   @return [::Array<::String>]
        #     Optional. Limits the aspects returned to the provided aspect types.
        #     It only works for CUSTOM view.
        # @!attribute [rw] paths
        #   @return [::Array<::String>]
        #     Optional. Limits the aspects returned to those associated with the provided
        #     paths within the Entry. It only works for CUSTOM view.
        class GetEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Lookup Entry request using permissions in the source system.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The project to which the request should be attributed in the
        #     following form: `projects/{project}/locations/{location}`.
        # @!attribute [rw] view
        #   @return [::Google::Cloud::Dataplex::V1::EntryView]
        #     Optional. View to control which parts of an entry the service should
        #     return.
        # @!attribute [rw] aspect_types
        #   @return [::Array<::String>]
        #     Optional. Limits the aspects returned to the provided aspect types.
        #     It only works for CUSTOM view.
        # @!attribute [rw] paths
        #   @return [::Array<::String>]
        #     Optional. Limits the aspects returned to those associated with the provided
        #     paths within the Entry. It only works for CUSTOM view.
        # @!attribute [rw] entry
        #   @return [::String]
        #     Required. The resource name of the Entry:
        #     `projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}`.
        class LookupEntryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The project to which the request should be attributed in the
        #     following form: `projects/{project}/locations/global`.
        # @!attribute [rw] query
        #   @return [::String]
        #     Required. The query against which entries in scope should be matched.
        #     The query syntax is defined in [Search syntax for Dataplex Universal
        #     Catalog](https://cloud.google.com/dataplex/docs/search-syntax).
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. Number of results in the search page. If <=0, then defaults
        #     to 10. Max limit for page_size is 1000. Throws an invalid argument for
        #     page_size > 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. Page token received from a previous `SearchEntries` call. Provide
        #     this to retrieve the subsequent page.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Specifies the ordering of results.
        #     Supported values are:
        #
        #     * `relevance`
        #     * `last_modified_timestamp`
        #     * `last_modified_timestamp asc`
        # @!attribute [rw] scope
        #   @return [::String]
        #     Optional. The scope under which the search should be operating. It must
        #     either be `organizations/<org_id>` or `projects/<project_ref>`. If it is
        #     unspecified, it defaults to the organization where the project provided in
        #     `name` is located.
        # @!attribute [rw] semantic_search
        #   @return [::Boolean]
        #     Optional. Specifies whether the search should understand the meaning and
        #     intent behind the query, rather than just matching keywords.
        class SearchEntriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A single result of a SearchEntries request.
        # @!attribute [rw] linked_resource
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::String]
        #     Linked resource name.
        # @!attribute [rw] dataplex_entry
        #   @return [::Google::Cloud::Dataplex::V1::Entry]
        # @!attribute [rw] snippets
        #   @deprecated This field is deprecated and may be removed in the next major version update.
        #   @return [::Google::Cloud::Dataplex::V1::SearchEntriesResult::Snippets]
        #     Snippets.
        class SearchEntriesResult
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Snippets for the entry, contains HTML-style highlighting for
          # matched tokens, will be used in UI.
          # @deprecated This message is deprecated and may be removed in the next major version update.
          # @!attribute [rw] dataplex_entry
          #   @deprecated This field is deprecated and may be removed in the next major version update.
          #   @return [::Google::Cloud::Dataplex::V1::Entry]
          #     Entry
          class Snippets
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # @!attribute [rw] results
        #   @return [::Array<::Google::Cloud::Dataplex::V1::SearchEntriesResult>]
        #     The results matching the search query.
        # @!attribute [rw] total_size
        #   @return [::Integer]
        #     The estimated total number of matching entries. This number isn't
        #     guaranteed to be accurate.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     Token to retrieve the next page of results, or empty if there are no more
        #     results in the list.
        # @!attribute [rw] unreachable
        #   @return [::Array<::String>]
        #     Locations that the service couldn't reach. Search results don't include
        #     data from these locations.
        class SearchEntriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # An object that describes the values that you want to set for an entry and its
        # attached aspects when you import metadata. Used when you run a metadata
        # import job. See
        # {::Google::Cloud::Dataplex::V1::CatalogService::Client#create_metadata_job CreateMetadataJob}.
        #
        # You provide a collection of import items in a metadata import file. For more
        # information about how to create a metadata import file, see [Metadata import
        # file](https://cloud.google.com/dataplex/docs/import-metadata#metadata-import-file).
        # @!attribute [rw] entry
        #   @return [::Google::Cloud::Dataplex::V1::Entry]
        #     Information about an entry and its attached aspects.
        # @!attribute [rw] entry_link
        #   @return [::Google::Cloud::Dataplex::V1::EntryLink]
        #     Information about the entry link. User should provide either one of the
        #     entry or entry_link. While providing entry_link, user should not
        #     provide update_mask and aspect_keys.
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     The fields to update, in paths that are relative to the `Entry` resource.
        #     Separate each field with a comma.
        #
        #     In `FULL` entry sync mode, Dataplex Universal Catalog includes the paths of
        #     all of the fields for an entry that can be modified, including aspects.
        #     This means that Dataplex Universal Catalog replaces the existing entry with
        #     the entry in the metadata import file. All modifiable fields are updated,
        #     regardless of the fields that are listed in the update mask, and regardless
        #     of whether a field is present in the `entry` object.
        #
        #     The `update_mask` field is ignored when an entry is created or re-created.
        #
        #     In an aspect-only metadata job (when entry sync mode is `NONE`), set this
        #     value to `aspects`.
        #
        #
        #     Dataplex Universal Catalog also determines which entries and aspects to
        #     modify by comparing the values and timestamps that you provide in the
        #     metadata import file with the values and timestamps that exist in your
        #     project. For more information, see [Comparison
        #     logic](https://cloud.google.com/dataplex/docs/import-metadata#data-modification-logic).
        # @!attribute [rw] aspect_keys
        #   @return [::Array<::String>]
        #     The aspects to modify. Supports the following syntaxes:
        #
        #     * `{aspect_type_reference}`: matches aspects that belong to the specified
        #     aspect type and are attached directly to the entry.
        #     * `{aspect_type_reference}@{path}`: matches aspects that belong to the
        #     specified aspect type and path.
        #     * `{aspect_type_reference}@*` : matches aspects of the given type for all
        #     paths.
        #     * `*@path` : matches aspects of all types on the given path.
        #
        #     Replace `{aspect_type_reference}` with a reference to the aspect type, in
        #     the format
        #     `{project_id_or_number}.{location_id}.{aspect_type_id}`.
        #
        #     In `FULL` entry sync mode, if you leave this field empty, it is treated as
        #     specifying exactly those aspects that are present within the specified
        #     entry. Dataplex Universal Catalog implicitly adds the keys for all of the
        #     required aspects of an entry.
        class ImportItem
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Create metadata job request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent location, in the format
        #     `projects/{project_id_or_number}/locations/{location_id}`
        # @!attribute [rw] metadata_job
        #   @return [::Google::Cloud::Dataplex::V1::MetadataJob]
        #     Required. The metadata job resource.
        # @!attribute [rw] metadata_job_id
        #   @return [::String]
        #     Optional. The metadata job ID. If not provided, a unique ID is generated
        #     with the prefix `metadata-job-`.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. The service validates the request without performing any
        #     mutations. The default is false.
        class CreateMetadataJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get metadata job request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the metadata job, in the format
        #     `projects/{project_id_or_number}/locations/{location_id}/metadataJobs/{metadata_job_id}`.
        class GetMetadataJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List metadata jobs request.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent location, in the format
        #     `projects/{project_id_or_number}/locations/{location_id}`
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of metadata jobs to return. The service might
        #     return fewer jobs than this value. If unspecified, at most 10 jobs are
        #     returned. The maximum value is 1,000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. The page token received from a previous `ListMetadataJobs` call.
        #     Provide this token to retrieve the subsequent page of results. When
        #     paginating, all other parameters that are provided to the
        #     `ListMetadataJobs` request must match the call that provided the page
        #     token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter request. Filters are case-sensitive.
        #     The service supports the following formats:
        #
        #     * `labels.key1 = "value1"`
        #     * `labels:key1`
        #     * `name = "value"`
        #
        #     You can combine filters with `AND`, `OR`, and `NOT` operators.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. The field to sort the results by, either `name` or `create_time`.
        #     If not specified, the ordering is undefined.
        class ListMetadataJobsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List metadata jobs response.
        # @!attribute [rw] metadata_jobs
        #   @return [::Array<::Google::Cloud::Dataplex::V1::MetadataJob>]
        #     Metadata jobs under the specified parent location.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token to retrieve the next page of results. If there are no more results
        #     in the list, the value is empty.
        # @!attribute [rw] unreachable_locations
        #   @return [::Array<::String>]
        #     Locations that the service couldn't reach.
        class ListMetadataJobsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Cancel metadata job request.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the job, in the format
        #     `projects/{project_id_or_number}/locations/{location_id}/metadataJobs/{metadata_job_id}`
        class CancelMetadataJobRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # A metadata job resource.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The name of the resource that the configuration is
        #     applied to, in the format
        #     `projects/{project_number}/locations/{location_id}/metadataJobs/{metadata_job_id}`.
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. A system-generated, globally unique ID for the metadata job.
        #     If the metadata job is deleted and then re-created with the same name, this
        #     ID is different.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the metadata job was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the metadata job was updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels.
        # @!attribute [rw] type
        #   @return [::Google::Cloud::Dataplex::V1::MetadataJob::Type]
        #     Required. Metadata job type.
        # @!attribute [rw] import_spec
        #   @return [::Google::Cloud::Dataplex::V1::MetadataJob::ImportJobSpec]
        #     Import job specification.
        #
        #     Note: The following fields are mutually exclusive: `import_spec`, `export_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [rw] export_spec
        #   @return [::Google::Cloud::Dataplex::V1::MetadataJob::ExportJobSpec]
        #     Export job specification.
        #
        #     Note: The following fields are mutually exclusive: `export_spec`, `import_spec`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] import_result
        #   @return [::Google::Cloud::Dataplex::V1::MetadataJob::ImportJobResult]
        #     Output only. Import job result.
        #
        #     Note: The following fields are mutually exclusive: `import_result`, `export_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] export_result
        #   @return [::Google::Cloud::Dataplex::V1::MetadataJob::ExportJobResult]
        #     Output only. Export job result.
        #
        #     Note: The following fields are mutually exclusive: `export_result`, `import_result`. If a field in that set is populated, all other fields in the set will automatically be cleared.
        # @!attribute [r] status
        #   @return [::Google::Cloud::Dataplex::V1::MetadataJob::Status]
        #     Output only. Metadata job status.
        class MetadataJob
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Results from a metadata import job.
          # @!attribute [r] deleted_entries
          #   @return [::Integer]
          #     Output only. The total number of entries that were deleted.
          # @!attribute [r] updated_entries
          #   @return [::Integer]
          #     Output only. The total number of entries that were updated.
          # @!attribute [r] created_entries
          #   @return [::Integer]
          #     Output only. The total number of entries that were created.
          # @!attribute [r] unchanged_entries
          #   @return [::Integer]
          #     Output only. The total number of entries that were unchanged.
          # @!attribute [r] recreated_entries
          #   @return [::Integer]
          #     Output only. The total number of entries that were recreated.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the status was updated.
          # @!attribute [r] deleted_entry_links
          #   @return [::Integer]
          #     Output only. The total number of entry links that were successfully
          #     deleted.
          # @!attribute [r] created_entry_links
          #   @return [::Integer]
          #     Output only. The total number of entry links that were successfully
          #     created.
          # @!attribute [r] unchanged_entry_links
          #   @return [::Integer]
          #     Output only. The total number of entry links that were left unchanged.
          class ImportJobResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Summary results from a metadata export job. The results are a snapshot of
          # the metadata at the time when the job was created. The exported entries are
          # saved to a Cloud Storage bucket.
          # @!attribute [r] exported_entries
          #   @return [::Integer]
          #     Output only. The number of entries that were exported.
          # @!attribute [r] error_message
          #   @return [::String]
          #     Output only. The error message if the metadata export job failed.
          class ExportJobResult
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Job specification for a metadata import job.
          #
          # You can run the following kinds of metadata import jobs:
          #
          # * Full sync of entries with incremental import of their aspects.
          # Supported for custom entries.
          # * Incremental import of aspects only. Supported for aspects that belong
          # to custom entries and system entries. For custom entries, you can modify
          # both optional aspects and required aspects. For system entries, you can
          # modify optional aspects.
          # @!attribute [rw] source_storage_uri
          #   @return [::String]
          #     Optional. The URI of a Cloud Storage bucket or folder (beginning with
          #     `gs://` and ending with `/`) that contains the metadata import files for
          #     this job.
          #
          #     A metadata import file defines the values to set for each of the entries
          #     and aspects in a metadata import job. For more information about how to
          #     create a metadata import file and the file requirements, see [Metadata
          #     import
          #     file](https://cloud.google.com/dataplex/docs/import-metadata#metadata-import-file).
          #
          #     You can provide multiple metadata import files in the same metadata job.
          #     The bucket or folder must contain at least one metadata import file, in
          #     JSON Lines format (either `.json` or `.jsonl` file extension).
          #
          #     In `FULL` entry sync mode, don't save the metadata import file in a
          #     folder named `SOURCE_STORAGE_URI/deletions/`.
          #
          #     **Caution**: If the metadata import file contains no data, all entries
          #     and aspects that belong to the job's scope are deleted.
          # @!attribute [rw] source_create_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Optional. The time when the process that created the metadata import
          #     files began.
          # @!attribute [rw] scope
          #   @return [::Google::Cloud::Dataplex::V1::MetadataJob::ImportJobSpec::ImportJobScope]
          #     Required. A boundary on the scope of impact that the metadata import job
          #     can have.
          # @!attribute [rw] entry_sync_mode
          #   @return [::Google::Cloud::Dataplex::V1::MetadataJob::ImportJobSpec::SyncMode]
          #     Required. The sync mode for entries.
          # @!attribute [rw] aspect_sync_mode
          #   @return [::Google::Cloud::Dataplex::V1::MetadataJob::ImportJobSpec::SyncMode]
          #     Required. The sync mode for aspects.
          # @!attribute [rw] log_level
          #   @return [::Google::Cloud::Dataplex::V1::MetadataJob::ImportJobSpec::LogLevel]
          #     Optional. The level of logs to write to Cloud Logging for this job.
          #
          #     Debug-level logs provide highly-detailed information for
          #     troubleshooting, but their increased verbosity could incur [additional
          #     costs](https://cloud.google.com/stackdriver/pricing) that might not be
          #     merited for all jobs.
          #
          #     If unspecified, defaults to `INFO`.
          class ImportJobSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # A boundary on the scope of impact that the metadata import job can have.
            # @!attribute [rw] entry_groups
            #   @return [::Array<::String>]
            #     Required. The entry groups that are in scope for the import job,
            #     specified as relative resource names in the format
            #     `projects/{project_number_or_id}/locations/{location_id}/entryGroups/{entry_group_id}`.
            #     Only entries and aspects that belong to the specified entry groups are
            #     affected by the job.
            #
            #     The entry groups and the job must be in the same location.
            # @!attribute [rw] entry_types
            #   @return [::Array<::String>]
            #     Required. The entry types that are in scope for the import job,
            #     specified as relative resource names in the format
            #     `projects/{project_number_or_id}/locations/{location_id}/entryTypes/{entry_type_id}`.
            #     The job modifies only the entries and aspects that belong to these
            #     entry types.
            #
            #     If the metadata import file attempts to modify an entry whose type
            #     isn't included in this list, the import job is halted before modifying
            #     any entries or aspects.
            #
            #     The location of an entry type must either match the location of the
            #     job, or the entry type must be global.
            # @!attribute [rw] aspect_types
            #   @return [::Array<::String>]
            #     Optional. The aspect types that are in scope for the import job,
            #     specified as relative resource names in the format
            #     `projects/{project_number_or_id}/locations/{location_id}/aspectTypes/{aspect_type_id}`.
            #     The job modifies only the aspects that belong to these aspect types.
            #
            #     This field is required when creating an aspect-only import job.
            #
            #     If the metadata import file attempts to modify an aspect whose type
            #     isn't included in this list, the import job is halted before modifying
            #     any entries or aspects.
            #
            #     The location of an aspect type must either match the location of the
            #     job, or the aspect type must be global.
            # @!attribute [rw] glossaries
            #   @return [::Array<::String>]
            #     Optional. The glossaries that are in scope for the import job,
            #     specified as relative resource names in the format
            #     `projects/{project_number_or_id}/locations/{location_id}/glossaries/{glossary_id}`.
            #
            #     While importing Business Glossary entries, the user must
            #     provide glossaries. While importing entries, the user does not have to
            #     provide glossaries. If the metadata import file attempts to modify
            #     Business Glossary entries whose glossary isn't included in this list,
            #     the import job will skip those entries.
            #
            #     The location of a glossary must either match the location of the
            #     job, or the glossary must be global.
            # @!attribute [rw] entry_link_types
            #   @return [::Array<::String>]
            #     Optional. The entry link types that are in scope for the import job,
            #     specified as relative resource names in the format
            #     `projects/{project_number_or_id}/locations/{location_id}/entryLinkTypes/{entry_link_type_id}`.
            #     The job modifies only the entryLinks that belong to these entry link
            #     types.
            #
            #     If the metadata import file attempts to create or delete an entry link
            #     whose entry link type isn't included in this list, the import job will
            #     skip those entry links.
            # @!attribute [rw] referenced_entry_scopes
            #   @return [::Array<::String>]
            #     Optional. Defines the scope of entries that can be referenced in the
            #     entry links.
            #
            #     Currently, projects are supported as valid scopes.
            #     Format: `projects/{project_number_or_id}`
            #
            #     If the metadata import file attempts to create an entry link
            #     which references an entry that is not in the scope, the import job will
            #     skip that entry link.
            class ImportJobScope
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end

            # Specifies how the entries and aspects in a metadata import job are
            # updated. For more information, see [Sync
            # mode](https://cloud.google.com/dataplex/docs/import-metadata#sync-mode).
            module SyncMode
              # Sync mode unspecified.
              SYNC_MODE_UNSPECIFIED = 0

              # All resources in the job's scope are modified. If a resource exists in
              # Dataplex Universal Catalog but isn't included in the metadata import
              # file, the resource is deleted when you run the metadata job. Use this
              # mode to perform a full sync of the set of entries in the job scope.
              #
              # This sync mode is supported for entries.
              FULL = 1

              # Only the resources that are explicitly included in the
              # metadata import file are modified. Use this mode to modify a subset of
              # resources while leaving unreferenced resources unchanged.
              #
              # This sync mode is supported for aspects.
              INCREMENTAL = 2

              # If entry sync mode is `NONE`, then aspects are modified according
              # to the aspect sync mode. Other metadata that belongs to entries in the
              # job's scope isn't modified.
              #
              # This sync mode is supported for entries.
              NONE = 3
            end

            # The level of logs to write to Cloud Logging for this job.
            module LogLevel
              # Log level unspecified.
              LOG_LEVEL_UNSPECIFIED = 0

              # Debug-level logging. Captures detailed logs for each import item. Use
              # debug-level logging to troubleshoot issues with specific import items.
              # For example, use debug-level logging to identify resources that are
              # missing from the job scope, entries or aspects that don't conform to
              # the associated entry type or aspect type, or other misconfigurations
              # with the metadata import file.
              #
              # Depending on the size of your metadata job and the number of logs that
              # are generated, debug-level logging might incur
              # [additional costs](https://cloud.google.com/stackdriver/pricing).
              DEBUG = 1

              # Info-level logging. Captures logs at the overall job level. Includes
              # aggregate logs about import items, but doesn't specify which import
              # item has an error.
              INFO = 2
            end
          end

          # Job specification for a metadata export job.
          # @!attribute [rw] scope
          #   @return [::Google::Cloud::Dataplex::V1::MetadataJob::ExportJobSpec::ExportJobScope]
          #     Required. The scope of the export job.
          # @!attribute [rw] output_path
          #   @return [::String]
          #     Required. The root path of the Cloud Storage bucket to export the
          #     metadata to, in the format `gs://{bucket}/`. You can optionally specify a
          #     custom prefix after the bucket name, in the format
          #     `gs://{bucket}/{prefix}/`. The maximum length of the custom prefix is 128
          #     characters. Dataplex Universal Catalog constructs the object path for the
          #     exported files by using the bucket name and prefix that you provide,
          #     followed by a system-generated path.
          #
          #     The bucket must be in the same VPC Service Controls perimeter as the job.
          class ExportJobSpec
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # The scope of the export job.
            # @!attribute [rw] organization_level
            #   @return [::Boolean]
            #     Whether the metadata export job is an organization-level export job.
            #
            #     - If `true`, the job exports the entries from the same organization and
            #     VPC Service Controls perimeter as the job. The project that the job
            #     belongs to determines the VPC Service Controls perimeter. If you set
            #     the job scope to be at the organization level, then don't provide a
            #     list of projects or entry groups.
            #     - If `false`, you must specify a list of projects or a list of entry
            #     groups whose entries you want to export.
            #
            #     The default is `false`.
            # @!attribute [rw] projects
            #   @return [::Array<::String>]
            #     The projects whose metadata you want to export, in the format
            #     `projects/{project_id_or_number}`. Only the entries from
            #     the specified projects are exported.
            #
            #     The projects must be in the same organization and VPC Service Controls
            #     perimeter as the job.
            #
            #     If you set the job scope to be a list of projects, then set the
            #     organization-level export flag to false and don't provide a list of
            #     entry groups.
            # @!attribute [rw] entry_groups
            #   @return [::Array<::String>]
            #     The entry groups whose metadata you want to export, in the format
            #     `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
            #     Only the entries in the specified entry groups are exported.
            #
            #     The entry groups must be in the same location and the same VPC Service
            #     Controls perimeter as the job.
            #
            #     If you set the job scope to be a list of entry groups, then set the
            #     organization-level export flag to false and don't provide a list of
            #     projects.
            # @!attribute [rw] entry_types
            #   @return [::Array<::String>]
            #     The entry types that are in scope for the export job, specified as
            #     relative resource names in the format
            #     `projects/{project_id_or_number}/locations/{location}/entryTypes/{entry_type_id}`.
            #     Only entries that belong to the specified entry types are affected by
            #     the job.
            # @!attribute [rw] aspect_types
            #   @return [::Array<::String>]
            #     The aspect types that are in scope for the export job, specified as
            #     relative resource names in the format
            #     `projects/{project_id_or_number}/locations/{location}/aspectTypes/{aspect_type_id}`.
            #     Only aspects that belong to the specified aspect types are affected by
            #     the job.
            class ExportJobScope
              include ::Google::Protobuf::MessageExts
              extend ::Google::Protobuf::MessageExts::ClassMethods
            end
          end

          # Metadata job status.
          # @!attribute [r] state
          #   @return [::Google::Cloud::Dataplex::V1::MetadataJob::Status::State]
          #     Output only. State of the metadata job.
          # @!attribute [r] message
          #   @return [::String]
          #     Output only. Message relating to the progression of a metadata job.
          # @!attribute [r] completion_percent
          #   @return [::Integer]
          #     Output only. Progress tracking.
          # @!attribute [r] update_time
          #   @return [::Google::Protobuf::Timestamp]
          #     Output only. The time when the status was updated.
          class Status
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # State of a metadata job.
            module State
              # State unspecified.
              STATE_UNSPECIFIED = 0

              # The job is queued.
              QUEUED = 1

              # The job is running.
              RUNNING = 2

              # The job is being canceled.
              CANCELING = 3

              # The job is canceled.
              CANCELED = 4

              # The job succeeded.
              SUCCEEDED = 5

              # The job failed.
              FAILED = 6

              # The job completed with some errors.
              SUCCEEDED_WITH_ERRORS = 7
            end
          end

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end

          # Metadata job type.
          module Type
            # Unspecified.
            TYPE_UNSPECIFIED = 0

            # Import job.
            IMPORT = 1

            # Export job.
            EXPORT = 2
          end
        end

        # EntryLink represents a link between two Entries.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Immutable. Identifier. The relative resource name of the Entry
        #     Link, of the form:
        #     `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entryLinks/{entry_link_id}`
        # @!attribute [rw] entry_link_type
        #   @return [::String]
        #     Required. Immutable. Relative resource name of the Entry Link Type used to
        #     create this Entry Link. For example:
        #
        #     - Entry link between synonym terms in a glossary:
        #     `projects/dataplex-types/locations/global/entryLinkTypes/synonym`
        #     - Entry link between related terms in a glossary:
        #     `projects/dataplex-types/locations/global/entryLinkTypes/related`
        #     - Entry link between glossary terms and data assets:
        #     `projects/dataplex-types/locations/global/entryLinkTypes/definition`
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the Entry Link was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time when the Entry Link was last updated.
        # @!attribute [rw] entry_references
        #   @return [::Array<::Google::Cloud::Dataplex::V1::EntryLink::EntryReference>]
        #     Required. Specifies the Entries referenced in the Entry Link. There should
        #     be exactly two entry references.
        class EntryLink
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # Reference to the Entry that is linked through the Entry Link.
          # @!attribute [rw] name
          #   @return [::String]
          #     Required. Immutable. The relative resource name of the referenced Entry,
          #     of the form:
          #     `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entries/{entry_id}`
          # @!attribute [rw] path
          #   @return [::String]
          #     Immutable. The path in the Entry that is referenced in the Entry Link.
          #     Empty path denotes that the Entry itself is referenced in the Entry
          #     Link.
          # @!attribute [rw] type
          #   @return [::Google::Cloud::Dataplex::V1::EntryLink::EntryReference::Type]
          #     Required. Immutable. The reference type of the Entry.
          class EntryReference
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods

            # Reference type of the Entry.
            module Type
              # Unspecified reference type. Implies that the Entry is referenced
              # in a non-directional Entry Link.
              UNSPECIFIED = 0

              # The Entry is referenced as the source of the directional Entry Link.
              SOURCE = 2

              # The Entry is referenced as the target of the directional Entry Link.
              TARGET = 3
            end
          end
        end

        # Request message for CreateEntryLink.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The resource name of the parent Entry Group:
        #     `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}`.
        # @!attribute [rw] entry_link_id
        #   @return [::String]
        #     Required. Entry Link identifier
        #     * Must contain only lowercase letters, numbers and hyphens.
        #     * Must start with a letter.
        #     * Must be between 1-63 characters.
        #     * Must end with a number or a letter.
        #     * Must be unique within the EntryGroup.
        # @!attribute [rw] entry_link
        #   @return [::Google::Cloud::Dataplex::V1::EntryLink]
        #     Required. Entry Link resource.
        class CreateEntryLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for DeleteEntryLink.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Entry Link:
        #     `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entryLinks/{entry_link_id}`.
        class DeleteEntryLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Request message for GetEntryLink.
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The resource name of the Entry Link:
        #     `projects/{project_id_or_number}/locations/{location_id}/entryGroups/{entry_group_id}/entryLinks/{entry_link_id}`.
        class GetEntryLinkRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # View for controlling which parts of an entry are to be returned.
        module EntryView
          # Unspecified EntryView. Defaults to FULL.
          ENTRY_VIEW_UNSPECIFIED = 0

          # Returns entry only, without aspects.
          BASIC = 1

          # Returns all required aspects as well as the keys of all non-required
          # aspects.
          FULL = 2

          # Returns aspects matching custom fields in GetEntryRequest. If the number of
          # aspects exceeds 100, the first 100 will be returned.
          CUSTOM = 3

          ALL = 4
        end

        # Denotes the transfer status of a resource. It is unspecified for resources
        # created from Dataplex API.
        module TransferStatus
          # The default value. It is set for resources that were not subject for
          # migration from Data Catalog service.
          TRANSFER_STATUS_UNSPECIFIED = 0

          # Indicates that a resource was migrated from Data Catalog service but it
          # hasn't been transferred yet. In particular the resource cannot be updated
          # from Dataplex API.
          TRANSFER_STATUS_MIGRATED = 1

          # Indicates that a resource was transferred from Data Catalog service. The
          # resource can only be updated from Dataplex API.
          TRANSFER_STATUS_TRANSFERRED = 2
        end
      end
    end
  end
end
