# frozen_string_literal: true

# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        # A Glossary represents a collection of GlossaryCategories and GlossaryTerms
        # defined by the user. Glossary is a top level resource and is the Google Cloud
        # parent resource of all the GlossaryCategories and GlossaryTerms within it.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of the Glossary.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System generated unique id for the Glossary. This ID will be
        #     different if the Glossary is deleted and re-created with the
        #     same name.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly display name of the Glossary. This is user-mutable.
        #     This will be same as the GlossaryId, if not specified.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The user-mutable description of the Glossary.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the Glossary was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the Glossary was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels for the Glossary.
        # @!attribute [r] term_count
        #   @return [::Integer]
        #     Output only. The number of GlossaryTerms in the Glossary.
        # @!attribute [r] category_count
        #   @return [::Integer]
        #     Output only. The number of GlossaryCategories in the Glossary.
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. Needed for resource freshness validation.
        #     This checksum is computed by the server based on the value of other
        #     fields, and may be sent on update and delete requests to ensure the
        #     client has an up-to-date value before proceeding.
        class Glossary
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # A GlossaryCategory represents a collection of GlossaryCategories and
        # GlossaryTerms within a Glossary that are related to each other.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of the GlossaryCategory.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/categories/\\{category_id}
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System generated unique id for the GlossaryCategory. This ID
        #     will be different if the GlossaryCategory is deleted and re-created with
        #     the same name.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly display name of the GlossaryCategory. This is
        #     user-mutable. This will be same as the GlossaryCategoryId, if not
        #     specified.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The user-mutable description of the GlossaryCategory.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the GlossaryCategory was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the GlossaryCategory was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels for the GlossaryCategory.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The immediate parent of the GlossaryCategory in the
        #     resource-hierarchy. It can either be a Glossary or a GlossaryCategory.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
        #     OR
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/categories/\\{category_id}
        class GlossaryCategory
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # GlossaryTerms are the core of Glossary.
        # A GlossaryTerm holds a rich text description that can be attached to Entries
        # or specific columns to enrich them.
        # @!attribute [r] name
        #   @return [::String]
        #     Output only. Identifier. The resource name of the GlossaryTerm.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/terms/\\{term_id}
        # @!attribute [r] uid
        #   @return [::String]
        #     Output only. System generated unique id for the GlossaryTerm. This ID will
        #     be different if the GlossaryTerm is deleted and re-created with the same
        #     name.
        # @!attribute [rw] display_name
        #   @return [::String]
        #     Optional. User friendly display name of the GlossaryTerm. This is
        #     user-mutable. This will be same as the GlossaryTermId, if not specified.
        # @!attribute [rw] description
        #   @return [::String]
        #     Optional. The user-mutable description of the GlossaryTerm.
        # @!attribute [r] create_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the GlossaryTerm was created.
        # @!attribute [r] update_time
        #   @return [::Google::Protobuf::Timestamp]
        #     Output only. The time at which the GlossaryTerm was last updated.
        # @!attribute [rw] labels
        #   @return [::Google::Protobuf::Map{::String => ::String}]
        #     Optional. User-defined labels for the GlossaryTerm.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The immediate parent of the GlossaryTerm in the
        #     resource-hierarchy. It can either be a Glossary or a GlossaryCategory.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
        #     OR
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/categories/\\{category_id}
        class GlossaryTerm
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods

          # @!attribute [rw] key
          #   @return [::String]
          # @!attribute [rw] value
          #   @return [::String]
          class LabelsEntry
            include ::Google::Protobuf::MessageExts
            extend ::Google::Protobuf::MessageExts::ClassMethods
          end
        end

        # Create Glossary Request
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this Glossary will be created.
        #     Format: projects/\\{project_id_or_number}/locations/\\{location_id}
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] glossary_id
        #   @return [::String]
        #     Required. Glossary ID: Glossary identifier.
        # @!attribute [rw] glossary
        #   @return [::Google::Cloud::Dataplex::V1::Glossary]
        #     Required. The Glossary to create.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Validates the request without actually creating the Glossary.
        #     Default: false.
        class CreateGlossaryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update Glossary Request
        # @!attribute [rw] glossary
        #   @return [::Google::Cloud::Dataplex::V1::Glossary]
        #     Required. The Glossary to update.
        #     The Glossary's `name` field is used to identify the Glossary to update.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        # @!attribute [rw] validate_only
        #   @return [::Boolean]
        #     Optional. Validates the request without actually updating the Glossary.
        #     Default: false.
        class UpdateGlossaryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete Glossary Request
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Glossary to delete.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
        # @!attribute [rw] etag
        #   @return [::String]
        #     Optional. The etag of the Glossary.
        #     If this is provided, it must match the server's etag.
        #     If the etag is provided and does not match the server-computed etag,
        #     the request must fail with a ABORTED error code.
        class DeleteGlossaryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get Glossary Request
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the Glossary to retrieve.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
        class GetGlossaryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List Glossaries Request
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which has this collection of Glossaries.
        #     Format: projects/\\{project_id_or_number}/locations/\\{location_id}
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of Glossaries to return. The service may
        #     return fewer than this value. If unspecified, at most 50 Glossaries will be
        #     returned. The maximum value is 1000; values above 1000 will be coerced to
        #     1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListGlossaries` call.
        #     Provide this to retrieve the subsequent page.
        #     When paginating, all other parameters provided to `ListGlossaries` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter expression that filters Glossaries listed in the response.
        #     Filters on proto fields of Glossary are supported.
        #     Examples of using a filter are:
        #       - `display_name="my-glossary"`
        #       - `categoryCount=1`
        #       - `termCount=0`
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Order by expression that orders Glossaries listed in the
        #     response. Order by fields are: `name` or `create_time` for the result. If
        #     not specified, the ordering is undefined.
        class ListGlossariesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List Glossaries Response
        # @!attribute [rw] glossaries
        #   @return [::Array<::Google::Cloud::Dataplex::V1::Glossary>]
        #     Lists the Glossaries in the specified parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable_locations
        #   @return [::Array<::String>]
        #     Locations that the service couldn't reach.
        class ListGlossariesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Creates a new GlossaryCategory under the specified Glossary.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where this GlossaryCategory will be created.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
        #     where `locationId` refers to a Google Cloud region.
        # @!attribute [rw] category_id
        #   @return [::String]
        #     Required. GlossaryCategory identifier.
        # @!attribute [rw] category
        #   @return [::Google::Cloud::Dataplex::V1::GlossaryCategory]
        #     Required. The GlossaryCategory to create.
        class CreateGlossaryCategoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update GlossaryCategory Request
        # @!attribute [rw] category
        #   @return [::Google::Cloud::Dataplex::V1::GlossaryCategory]
        #     Required. The GlossaryCategory to update.
        #     The GlossaryCategory's `name` field is used to identify the
        #     GlossaryCategory to update. Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/categories/\\{category_id}
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateGlossaryCategoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete GlossaryCategory Request
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the GlossaryCategory to delete.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/categories/\\{category_id}
        class DeleteGlossaryCategoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get GlossaryCategory Request
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the GlossaryCategory to retrieve.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/categories/\\{category_id}
        class GetGlossaryCategoryRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List GlossaryCategories Request
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which has this collection of GlossaryCategories.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
        #     Location is the Google Cloud region.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of GlossaryCategories to return. The service
        #     may return fewer than this value. If unspecified, at most 50
        #     GlossaryCategories will be returned. The maximum value is 1000; values
        #     above 1000 will be coerced to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListGlossaryCategories`
        #     call. Provide this to retrieve the subsequent page. When paginating, all
        #     other parameters provided to `ListGlossaryCategories` must match the call
        #     that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter expression that filters GlossaryCategories listed in the
        #     response. Filters are supported on the following fields:
        #       - immediate_parent
        #
        #     Examples of using a filter are:
        #       -
        #       `immediate_parent="projects/{project_id_or_number}/locations/{location_id}/glossaries/{glossary_id}"`
        #       -
        #       `immediate_parent="projects/{project_id_or_number}/locations/{location_id}/glossaries/{glossary_id}/categories/{category_id}"`
        #
        #     This will only return the GlossaryCategories that are directly nested
        #     under the specified parent.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Order by expression that orders GlossaryCategories listed in the
        #     response. Order by fields are: `name` or `create_time` for the result. If
        #     not specified, the ordering is undefined.
        class ListGlossaryCategoriesRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List GlossaryCategories Response
        # @!attribute [rw] categories
        #   @return [::Array<::Google::Cloud::Dataplex::V1::GlossaryCategory>]
        #     Lists the GlossaryCategories in the specified parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable_locations
        #   @return [::Array<::String>]
        #     Locations that the service couldn't reach.
        class ListGlossaryCategoriesResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Creates a new GlossaryTerm under the specified Glossary.
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent resource where the GlossaryTerm will be created.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] term_id
        #   @return [::String]
        #     Required. GlossaryTerm identifier.
        # @!attribute [rw] term
        #   @return [::Google::Cloud::Dataplex::V1::GlossaryTerm]
        #     Required. The GlossaryTerm to create.
        class CreateGlossaryTermRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Update GlossaryTerm Request
        # @!attribute [rw] term
        #   @return [::Google::Cloud::Dataplex::V1::GlossaryTerm]
        #     Required. The GlossaryTerm to update.
        #     The GlossaryTerm's `name` field is used to identify the GlossaryTerm to
        #     update. Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/terms/\\{term_id}
        # @!attribute [rw] update_mask
        #   @return [::Google::Protobuf::FieldMask]
        #     Required. The list of fields to update.
        class UpdateGlossaryTermRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Delete GlossaryTerm Request
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the GlossaryTerm to delete.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/terms/\\{term_id}
        class DeleteGlossaryTermRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # Get GlossaryTerm Request
        # @!attribute [rw] name
        #   @return [::String]
        #     Required. The name of the GlossaryTerm to retrieve.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}/terms/\\{term_id}
        class GetGlossaryTermRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List GlossaryTerms Request
        # @!attribute [rw] parent
        #   @return [::String]
        #     Required. The parent, which has this collection of GlossaryTerms.
        #     Format:
        #     projects/\\{project_id_or_number}/locations/\\{location_id}/glossaries/\\{glossary_id}
        #     where `location_id` refers to a Google Cloud region.
        # @!attribute [rw] page_size
        #   @return [::Integer]
        #     Optional. The maximum number of GlossaryTerms to return. The service may
        #     return fewer than this value. If unspecified, at most 50 GlossaryTerms will
        #     be returned. The maximum value is 1000; values above 1000 will be coerced
        #     to 1000.
        # @!attribute [rw] page_token
        #   @return [::String]
        #     Optional. A page token, received from a previous `ListGlossaryTerms` call.
        #     Provide this to retrieve the subsequent page.
        #     When paginating, all other parameters provided to `ListGlossaryTerms` must
        #     match the call that provided the page token.
        # @!attribute [rw] filter
        #   @return [::String]
        #     Optional. Filter expression that filters GlossaryTerms listed in the
        #     response. Filters are supported on the following fields:
        #       - immediate_parent
        #
        #     Examples of using a filter are:
        #       -
        #       `immediate_parent="projects/{project_id_or_number}/locations/{location_id}/glossaries/{glossary_id}"`
        #       -
        #       `immediate_parent="projects/{project_id_or_number}/locations/{location_id}/glossaries/{glossary_id}/categories/{category_id}"`
        #
        #     This will only return the GlossaryTerms that are directly nested under the
        #     specified parent.
        # @!attribute [rw] order_by
        #   @return [::String]
        #     Optional. Order by expression that orders GlossaryTerms listed in the
        #     response. Order by fields are: `name` or `create_time` for the result. If
        #     not specified, the ordering is undefined.
        class ListGlossaryTermsRequest
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end

        # List GlossaryTerms Response
        # @!attribute [rw] terms
        #   @return [::Array<::Google::Cloud::Dataplex::V1::GlossaryTerm>]
        #     Lists the GlossaryTerms in the specified parent.
        # @!attribute [rw] next_page_token
        #   @return [::String]
        #     A token, which can be sent as `page_token` to retrieve the next page.
        #     If this field is omitted, there are no subsequent pages.
        # @!attribute [rw] unreachable_locations
        #   @return [::Array<::String>]
        #     Locations that the service couldn't reach.
        class ListGlossaryTermsResponse
          include ::Google::Protobuf::MessageExts
          extend ::Google::Protobuf::MessageExts::ClassMethods
        end
      end
    end
  end
end
