# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!


module Google
  module Cloud
    module Dataplex
      module V1
        module MetadataService
          # Path helper methods for the MetadataService API.
          module Paths
            ##
            # Create a fully-qualified Entity resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/entities/{entity}`
            #
            # @param project [String]
            # @param location [String]
            # @param lake [String]
            # @param zone [String]
            # @param entity [String]
            #
            # @return [::String]
            def entity_path project:, location:, lake:, zone:, entity:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "lake cannot contain /" if lake.to_s.include? "/"
              raise ::ArgumentError, "zone cannot contain /" if zone.to_s.include? "/"

              "projects/#{project}/locations/#{location}/lakes/#{lake}/zones/#{zone}/entities/#{entity}"
            end

            ##
            # Create a fully-qualified Partition resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/entities/{entity}/partitions/{partition}`
            #
            # @param project [String]
            # @param location [String]
            # @param lake [String]
            # @param zone [String]
            # @param entity [String]
            # @param partition [String]
            #
            # @return [::String]
            def partition_path project:, location:, lake:, zone:, entity:, partition:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "lake cannot contain /" if lake.to_s.include? "/"
              raise ::ArgumentError, "zone cannot contain /" if zone.to_s.include? "/"
              raise ::ArgumentError, "entity cannot contain /" if entity.to_s.include? "/"

              "projects/#{project}/locations/#{location}/lakes/#{lake}/zones/#{zone}/entities/#{entity}/partitions/#{partition}"
            end

            ##
            # Create a fully-qualified Zone resource string.
            #
            # The resource will be in the following format:
            #
            # `projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}`
            #
            # @param project [String]
            # @param location [String]
            # @param lake [String]
            # @param zone [String]
            #
            # @return [::String]
            def zone_path project:, location:, lake:, zone:
              raise ::ArgumentError, "project cannot contain /" if project.to_s.include? "/"
              raise ::ArgumentError, "location cannot contain /" if location.to_s.include? "/"
              raise ::ArgumentError, "lake cannot contain /" if lake.to_s.include? "/"

              "projects/#{project}/locations/#{location}/lakes/#{lake}/zones/#{zone}"
            end

            extend self
          end
        end
      end
    end
  end
end
