# frozen_string_literal: true

# Copyright 2022 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dataplex/v1/metadata_pb"
require "google/cloud/location"
require "google/iam/v1"

module Google
  module Cloud
    module Dataplex
      module V1
        module MetadataService
          ##
          # Client for the MetadataService service.
          #
          # Metadata service manages metadata resources such as tables, filesets and
          # partitions.
          #
          class Client
            # @private
            API_VERSION = ""

            # @private
            DEFAULT_ENDPOINT_TEMPLATE = "dataplex.$UNIVERSE_DOMAIN$"

            include Paths

            # @private
            attr_reader :metadata_service_stub

            ##
            # Configure the MetadataService Client class.
            #
            # See {::Google::Cloud::Dataplex::V1::MetadataService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @example
            #
            #   # Modify the configuration for all MetadataService clients
            #   ::Google::Cloud::Dataplex::V1::MetadataService::Client.configure do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def self.configure
              @configure ||= begin
                namespace = ["Google", "Cloud", "Dataplex", "V1"]
                parent_config = while namespace.any?
                                  parent_name = namespace.join "::"
                                  parent_const = const_get parent_name
                                  break parent_const.configure if parent_const.respond_to? :configure
                                  namespace.pop
                                end
                default_config = Client::Configuration.new parent_config

                default_config.rpcs.create_entity.timeout = 60.0

                default_config.rpcs.update_entity.timeout = 60.0

                default_config.rpcs.delete_entity.timeout = 60.0

                default_config.rpcs.get_entity.timeout = 60.0
                default_config.rpcs.get_entity.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_entities.timeout = 60.0
                default_config.rpcs.list_entities.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.create_partition.timeout = 60.0

                default_config.rpcs.delete_partition.timeout = 60.0

                default_config.rpcs.get_partition.timeout = 60.0
                default_config.rpcs.get_partition.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config.rpcs.list_partitions.timeout = 60.0
                default_config.rpcs.list_partitions.retry_policy = {
                  initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                }

                default_config
              end
              yield @configure if block_given?
              @configure
            end

            ##
            # Configure the MetadataService Client instance.
            #
            # The configuration is set to the derived mode, meaning that values can be changed,
            # but structural changes (adding new fields, etc.) are not allowed. Structural changes
            # should be made on {Client.configure}.
            #
            # See {::Google::Cloud::Dataplex::V1::MetadataService::Client::Configuration}
            # for a description of the configuration fields.
            #
            # @yield [config] Configure the Client client.
            # @yieldparam config [Client::Configuration]
            #
            # @return [Client::Configuration]
            #
            def configure
              yield @config if block_given?
              @config
            end

            ##
            # The effective universe domain
            #
            # @return [String]
            #
            def universe_domain
              @metadata_service_stub.universe_domain
            end

            ##
            # Create a new MetadataService client object.
            #
            # @example
            #
            #   # Create a client using the default configuration
            #   client = ::Google::Cloud::Dataplex::V1::MetadataService::Client.new
            #
            #   # Create a client using a custom configuration
            #   client = ::Google::Cloud::Dataplex::V1::MetadataService::Client.new do |config|
            #     config.timeout = 10.0
            #   end
            #
            # @yield [config] Configure the MetadataService client.
            # @yieldparam config [Client::Configuration]
            #
            def initialize
              # These require statements are intentionally placed here to initialize
              # the gRPC module only when it's required.
              # See https://github.com/googleapis/toolkit/issues/446
              require "gapic/grpc"
              require "google/cloud/dataplex/v1/metadata_services_pb"

              # Create the configuration object
              @config = Configuration.new Client.configure

              # Yield the configuration if needed
              yield @config if block_given?

              # Create credentials
              credentials = @config.credentials
              # Use self-signed JWT if the endpoint is unchanged from default,
              # but only if the default endpoint does not have a region prefix.
              enable_self_signed_jwt = @config.endpoint.nil? ||
                                       (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                       !@config.endpoint.split(".").first.include?("-"))
              credentials ||= Credentials.default scope: @config.scope,
                                                  enable_self_signed_jwt: enable_self_signed_jwt
              if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                credentials = Credentials.new credentials, scope: @config.scope
              end
              @quota_project_id = @config.quota_project
              @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

              @metadata_service_stub = ::Gapic::ServiceStub.new(
                ::Google::Cloud::Dataplex::V1::MetadataService::Stub,
                credentials: credentials,
                endpoint: @config.endpoint,
                endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                universe_domain: @config.universe_domain,
                channel_args: @config.channel_args,
                interceptors: @config.interceptors,
                channel_pool_config: @config.channel_pool,
                logger: @config.logger
              )

              @metadata_service_stub.stub_logger&.info do |entry|
                entry.set_system_name
                entry.set_service
                entry.message = "Created client for #{entry.service}"
                entry.set_credentials_fields credentials
                entry.set "customEndpoint", @config.endpoint if @config.endpoint
                entry.set "defaultTimeout", @config.timeout if @config.timeout
                entry.set "quotaProject", @quota_project_id if @quota_project_id
              end

              @location_client = Google::Cloud::Location::Locations::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @metadata_service_stub.endpoint
                config.universe_domain = @metadata_service_stub.universe_domain
                config.logger = @metadata_service_stub.logger if config.respond_to? :logger=
              end

              @iam_policy_client = Google::Iam::V1::IAMPolicy::Client.new do |config|
                config.credentials = credentials
                config.quota_project = @quota_project_id
                config.endpoint = @metadata_service_stub.endpoint
                config.universe_domain = @metadata_service_stub.universe_domain
                config.logger = @metadata_service_stub.logger if config.respond_to? :logger=
              end
            end

            ##
            # Get the associated client for mix-in of the Locations.
            #
            # @return [Google::Cloud::Location::Locations::Client]
            #
            attr_reader :location_client

            ##
            # Get the associated client for mix-in of the IAMPolicy.
            #
            # @return [Google::Iam::V1::IAMPolicy::Client]
            #
            attr_reader :iam_policy_client

            ##
            # The logger used for request/response debug logging.
            #
            # @return [Logger]
            #
            def logger
              @metadata_service_stub.logger
            end

            # Service calls

            ##
            # Create a metadata entity.
            #
            # @overload create_entity(request, options = nil)
            #   Pass arguments to `create_entity` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::CreateEntityRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::CreateEntityRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_entity(parent: nil, entity: nil, validate_only: nil)
            #   Pass arguments to `create_entity` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the parent zone:
            #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
            #   @param entity [::Google::Cloud::Dataplex::V1::Entity, ::Hash]
            #     Required. Entity resource.
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the request, but do not perform mutations.
            #     The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::Entity]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::Entity]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::CreateEntityRequest.new
            #
            #   # Call the create_entity method.
            #   result = client.create_entity request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::Entity.
            #   p result
            #
            def create_entity request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateEntityRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_entity.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_entity.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_entity.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :create_entity, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Update a metadata entity. Only supports full resource update.
            #
            # @overload update_entity(request, options = nil)
            #   Pass arguments to `update_entity` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::UpdateEntityRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::UpdateEntityRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload update_entity(entity: nil, validate_only: nil)
            #   Pass arguments to `update_entity` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param entity [::Google::Cloud::Dataplex::V1::Entity, ::Hash]
            #     Required. Update description.
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the request, but do not perform mutations.
            #     The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::Entity]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::Entity]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::UpdateEntityRequest.new
            #
            #   # Call the update_entity method.
            #   result = client.update_entity request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::Entity.
            #   p result
            #
            def update_entity request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateEntityRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.update_entity.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.entity&.name
                header_params["entity.name"] = request.entity.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.update_entity.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.update_entity.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :update_entity, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete a metadata entity.
            #
            # @overload delete_entity(request, options = nil)
            #   Pass arguments to `delete_entity` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::DeleteEntityRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::DeleteEntityRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_entity(name: nil, etag: nil)
            #   Pass arguments to `delete_entity` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the entity:
            #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}`.
            #   @param etag [::String]
            #     Required. The etag associated with the entity, which can be retrieved with
            #     a [GetEntity][] request.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::DeleteEntityRequest.new
            #
            #   # Call the delete_entity method.
            #   result = client.delete_entity request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_entity request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteEntityRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_entity.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_entity.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_entity.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :delete_entity, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a metadata entity.
            #
            # @overload get_entity(request, options = nil)
            #   Pass arguments to `get_entity` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::GetEntityRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::GetEntityRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_entity(name: nil, view: nil)
            #   Pass arguments to `get_entity` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the entity:
            #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}.`
            #   @param view [::Google::Cloud::Dataplex::V1::GetEntityRequest::EntityView]
            #     Optional. Used to select the subset of entity information to return.
            #     Defaults to `BASIC`.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::Entity]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::Entity]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::GetEntityRequest.new
            #
            #   # Call the get_entity method.
            #   result = client.get_entity request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::Entity.
            #   p result
            #
            def get_entity request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetEntityRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_entity.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_entity.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_entity.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :get_entity, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List metadata entities in a zone.
            #
            # @overload list_entities(request, options = nil)
            #   Pass arguments to `list_entities` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::ListEntitiesRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::ListEntitiesRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_entities(parent: nil, view: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_entities` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the parent zone:
            #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
            #   @param view [::Google::Cloud::Dataplex::V1::ListEntitiesRequest::EntityView]
            #     Required. Specify the entity view to make a partial list request.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of entities to return. The service may return
            #     fewer than this value. If unspecified, 100 entities will be returned by
            #     default. The maximum value is 500; larger values will will be truncated to
            #     500.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `ListEntities` call. Provide
            #     this to retrieve the subsequent page. When paginating, all other parameters
            #     provided to `ListEntities` must match the call that provided the
            #     page token.
            #   @param filter [::String]
            #     Optional. The following filter parameters can be added to the URL to limit
            #     the entities returned by the API:
            #
            #     - Entity ID: ?filter="id=entityID"
            #     - Asset ID: ?filter="asset=assetID"
            #     - Data path ?filter="data_path=gs://my-bucket"
            #     - Is HIVE compatible: ?filter="hive_compatible=true"
            #     - Is BigQuery compatible: ?filter="bigquery_compatible=true"
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::Entity>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::Entity>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::ListEntitiesRequest.new
            #
            #   # Call the list_entities method.
            #   result = client.list_entities request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataplex::V1::Entity.
            #     p item
            #   end
            #
            def list_entities request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListEntitiesRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_entities.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_entities.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_entities.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :list_entities, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @metadata_service_stub, :list_entities, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Create a metadata partition.
            #
            # @overload create_partition(request, options = nil)
            #   Pass arguments to `create_partition` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::CreatePartitionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::CreatePartitionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload create_partition(parent: nil, partition: nil, validate_only: nil)
            #   Pass arguments to `create_partition` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the parent zone:
            #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}`.
            #   @param partition [::Google::Cloud::Dataplex::V1::Partition, ::Hash]
            #     Required. Partition resource.
            #   @param validate_only [::Boolean]
            #     Optional. Only validate the request, but do not perform mutations.
            #     The default is false.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::Partition]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::Partition]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::CreatePartitionRequest.new
            #
            #   # Call the create_partition method.
            #   result = client.create_partition request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::Partition.
            #   p result
            #
            def create_partition request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreatePartitionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.create_partition.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.create_partition.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.create_partition.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :create_partition, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Delete a metadata partition.
            #
            # @overload delete_partition(request, options = nil)
            #   Pass arguments to `delete_partition` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::DeletePartitionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::DeletePartitionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload delete_partition(name: nil, etag: nil)
            #   Pass arguments to `delete_partition` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the partition.
            #     format:
            #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}/partitions/{partition_value_path}`.
            #     The \\{partition_value_path} segment consists of an ordered sequence of
            #     partition values separated by "/". All values must be provided.
            #   @param etag [::String]
            #     Optional. The etag associated with the partition.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Protobuf::Empty]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Protobuf::Empty]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::DeletePartitionRequest.new
            #
            #   # Call the delete_partition method.
            #   result = client.delete_partition request
            #
            #   # The returned object is of type Google::Protobuf::Empty.
            #   p result
            #
            def delete_partition request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeletePartitionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.delete_partition.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.delete_partition.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.delete_partition.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :delete_partition, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Get a metadata partition of an entity.
            #
            # @overload get_partition(request, options = nil)
            #   Pass arguments to `get_partition` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::GetPartitionRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::GetPartitionRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload get_partition(name: nil)
            #   Pass arguments to `get_partition` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param name [::String]
            #     Required. The resource name of the partition:
            #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}/partitions/{partition_value_path}`.
            #     The \\{partition_value_path} segment consists of an ordered sequence of
            #     partition values separated by "/". All values must be provided.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Google::Cloud::Dataplex::V1::Partition]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Google::Cloud::Dataplex::V1::Partition]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::GetPartitionRequest.new
            #
            #   # Call the get_partition method.
            #   result = client.get_partition request
            #
            #   # The returned object is of type Google::Cloud::Dataplex::V1::Partition.
            #   p result
            #
            def get_partition request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetPartitionRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.get_partition.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.name
                header_params["name"] = request.name
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.get_partition.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.get_partition.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :get_partition, request, options: options do |response, operation|
                yield response, operation if block_given?
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # List metadata partitions of an entity.
            #
            # @overload list_partitions(request, options = nil)
            #   Pass arguments to `list_partitions` via a request object, either of type
            #   {::Google::Cloud::Dataplex::V1::ListPartitionsRequest} or an equivalent Hash.
            #
            #   @param request [::Google::Cloud::Dataplex::V1::ListPartitionsRequest, ::Hash]
            #     A request object representing the call parameters. Required. To specify no
            #     parameters, or to keep all the default parameter values, pass an empty Hash.
            #   @param options [::Gapic::CallOptions, ::Hash]
            #     Overrides the default settings for this call, e.g, timeout, retries, etc. Optional.
            #
            # @overload list_partitions(parent: nil, page_size: nil, page_token: nil, filter: nil)
            #   Pass arguments to `list_partitions` via keyword arguments. Note that at
            #   least one keyword argument is required. To specify no parameters, or to keep all
            #   the default parameter values, pass an empty Hash as a request object (see above).
            #
            #   @param parent [::String]
            #     Required. The resource name of the parent entity:
            #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/entities/{entity_id}`.
            #   @param page_size [::Integer]
            #     Optional. Maximum number of partitions to return. The service may return
            #     fewer than this value. If unspecified, 100 partitions will be returned by
            #     default. The maximum page size is 500; larger values will will be truncated
            #     to 500.
            #   @param page_token [::String]
            #     Optional. Page token received from a previous `ListPartitions` call.
            #     Provide this to retrieve the subsequent page. When paginating, all other
            #     parameters provided to `ListPartitions` must match the call that provided
            #     the page token.
            #   @param filter [::String]
            #     Optional. Filter the partitions returned to the caller using a key value
            #     pair expression. Supported operators and syntax:
            #
            #     - logic operators: AND, OR
            #     - comparison operators: <, >, >=, <= ,=, !=
            #     - LIKE operators:
            #       - The right hand of a LIKE operator supports "." and
            #         "*" for wildcard searches, for example "value1 LIKE ".*oo.*"
            #     - parenthetical grouping: ( )
            #
            #     Sample filter expression: `?filter="key1 < value1 OR key2 > value2"
            #
            #     **Notes:**
            #
            #     - Keys to the left of operators are case insensitive.
            #     - Partition results are sorted first by creation time, then by
            #       lexicographic order.
            #     - Up to 20 key value filter pairs are allowed, but due to performance
            #       considerations, only the first 10 will be used as a filter.
            #
            # @yield [response, operation] Access the result along with the RPC operation
            # @yieldparam response [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::Partition>]
            # @yieldparam operation [::GRPC::ActiveCall::Operation]
            #
            # @return [::Gapic::PagedEnumerable<::Google::Cloud::Dataplex::V1::Partition>]
            #
            # @raise [::Google::Cloud::Error] if the RPC is aborted.
            #
            # @example Basic example
            #   require "google/cloud/dataplex/v1"
            #
            #   # Create a client object. The client can be reused for multiple calls.
            #   client = Google::Cloud::Dataplex::V1::MetadataService::Client.new
            #
            #   # Create a request. To set request fields, pass in keyword arguments.
            #   request = Google::Cloud::Dataplex::V1::ListPartitionsRequest.new
            #
            #   # Call the list_partitions method.
            #   result = client.list_partitions request
            #
            #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
            #   # over elements, and API calls will be issued to fetch pages as needed.
            #   result.each do |item|
            #     # Each element is of type ::Google::Cloud::Dataplex::V1::Partition.
            #     p item
            #   end
            #
            def list_partitions request, options = nil
              raise ::ArgumentError, "request must be provided" if request.nil?

              request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListPartitionsRequest

              # Converts hash and nil to an options object
              options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

              # Customize the options with defaults
              metadata = @config.rpcs.list_partitions.metadata.to_h

              # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
              metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                lib_name: @config.lib_name, lib_version: @config.lib_version,
                gapic_version: ::Google::Cloud::Dataplex::V1::VERSION
              metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
              metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

              header_params = {}
              if request.parent
                header_params["parent"] = request.parent
              end

              request_params_header = header_params.map { |k, v| "#{k}=#{v}" }.join("&")
              metadata[:"x-goog-request-params"] ||= request_params_header

              options.apply_defaults timeout:      @config.rpcs.list_partitions.timeout,
                                     metadata:     metadata,
                                     retry_policy: @config.rpcs.list_partitions.retry_policy

              options.apply_defaults timeout:      @config.timeout,
                                     metadata:     @config.metadata,
                                     retry_policy: @config.retry_policy

              @metadata_service_stub.call_rpc :list_partitions, request, options: options do |response, operation|
                response = ::Gapic::PagedEnumerable.new @metadata_service_stub, :list_partitions, request, response, operation, options
                yield response, operation if block_given?
                throw :response, response
              end
            rescue ::GRPC::BadStatus => e
              raise ::Google::Cloud::Error.from_error(e)
            end

            ##
            # Configuration class for the MetadataService API.
            #
            # This class represents the configuration for MetadataService,
            # providing control over timeouts, retry behavior, logging, transport
            # parameters, and other low-level controls. Certain parameters can also be
            # applied individually to specific RPCs. See
            # {::Google::Cloud::Dataplex::V1::MetadataService::Client::Configuration::Rpcs}
            # for a list of RPCs that can be configured independently.
            #
            # Configuration can be applied globally to all clients, or to a single client
            # on construction.
            #
            # @example
            #
            #   # Modify the global config, setting the timeout for
            #   # create_entity to 20 seconds,
            #   # and all remaining timeouts to 10 seconds.
            #   ::Google::Cloud::Dataplex::V1::MetadataService::Client.configure do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_entity.timeout = 20.0
            #   end
            #
            #   # Apply the above configuration only to a new client.
            #   client = ::Google::Cloud::Dataplex::V1::MetadataService::Client.new do |config|
            #     config.timeout = 10.0
            #     config.rpcs.create_entity.timeout = 20.0
            #   end
            #
            # @!attribute [rw] endpoint
            #   A custom service endpoint, as a hostname or hostname:port. The default is
            #   nil, indicating to use the default endpoint in the current universe domain.
            #   @return [::String,nil]
            # @!attribute [rw] credentials
            #   Credentials to send with calls. You may provide any of the following types:
            #    *  (`Google::Auth::Credentials`) A googleauth credentials object
            #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
            #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
            #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
            #    *  (`GRPC::Core::Channel`) a gRPC channel with included credentials
            #    *  (`GRPC::Core::ChannelCredentials`) a gRPC credentails object
            #    *  (`nil`) indicating no credentials
            #
            #   @note Warning: Passing a `String` to a keyfile path or a `Hash` of credentials
            #     is deprecated. Providing an unvalidated credential configuration to
            #     Google APIs can compromise the security of your systems and data.
            #
            #   @example
            #
            #     # The recommended way to provide credentials is to use the `make_creds` method
            #     # on the appropriate credentials class for your environment.
            #
            #     require "googleauth"
            #
            #     credentials = ::Google::Auth::ServiceAccountCredentials.make_creds(
            #       json_key_io: ::File.open("/path/to/keyfile.json")
            #     )
            #
            #     client = ::Google::Cloud::Dataplex::V1::MetadataService::Client.new do |config|
            #       config.credentials = credentials
            #     end
            #
            #   @note Warning: If you accept a credential configuration (JSON file or Hash) from an
            #   external source for authentication to Google Cloud, you must validate it before
            #   providing it to a Google API client library. Providing an unvalidated credential
            #   configuration to Google APIs can compromise the security of your systems and data.
            #   For more information, refer to [Validate credential configurations from external
            #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
            #   @return [::Object]
            # @!attribute [rw] scope
            #   The OAuth scopes
            #   @return [::Array<::String>]
            # @!attribute [rw] lib_name
            #   The library name as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] lib_version
            #   The library version as recorded in instrumentation and logging
            #   @return [::String]
            # @!attribute [rw] channel_args
            #   Extra parameters passed to the gRPC channel. Note: this is ignored if a
            #   `GRPC::Core::Channel` object is provided as the credential.
            #   @return [::Hash]
            # @!attribute [rw] interceptors
            #   An array of interceptors that are run before calls are executed.
            #   @return [::Array<::GRPC::ClientInterceptor>]
            # @!attribute [rw] timeout
            #   The call timeout in seconds.
            #   @return [::Numeric]
            # @!attribute [rw] metadata
            #   Additional gRPC headers to be sent with the call.
            #   @return [::Hash{::Symbol=>::String}]
            # @!attribute [rw] retry_policy
            #   The retry policy. The value is a hash with the following keys:
            #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
            #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
            #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
            #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
            #       trigger a retry.
            #   @return [::Hash]
            # @!attribute [rw] quota_project
            #   A separate project against which to charge quota.
            #   @return [::String]
            # @!attribute [rw] universe_domain
            #   The universe domain within which to make requests. This determines the
            #   default endpoint URL. The default value of nil uses the environment
            #   universe (usually the default "googleapis.com" universe).
            #   @return [::String,nil]
            # @!attribute [rw] logger
            #   A custom logger to use for request/response debug logging, or the value
            #   `:default` (the default) to construct a default logger, or `nil` to
            #   explicitly disable logging.
            #   @return [::Logger,:default,nil]
            #
            class Configuration
              extend ::Gapic::Config

              # @private
              # The endpoint specific to the default "googleapis.com" universe. Deprecated.
              DEFAULT_ENDPOINT = "dataplex.googleapis.com"

              config_attr :endpoint,      nil, ::String, nil
              config_attr :credentials,   nil do |value|
                allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                allowed += [::GRPC::Core::Channel, ::GRPC::Core::ChannelCredentials] if defined? ::GRPC::Core::Channel
                allowed.any? { |klass| klass === value }
              end
              config_attr :scope,         nil, ::String, ::Array, nil
              config_attr :lib_name,      nil, ::String, nil
              config_attr :lib_version,   nil, ::String, nil
              config_attr(:channel_args,  { "grpc.service_config_disable_resolution" => 1 }, ::Hash, nil)
              config_attr :interceptors,  nil, ::Array, nil
              config_attr :timeout,       nil, ::Numeric, nil
              config_attr :metadata,      nil, ::Hash, nil
              config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
              config_attr :quota_project, nil, ::String, nil
              config_attr :universe_domain, nil, ::String, nil
              config_attr :logger, :default, ::Logger, nil, :default

              # @private
              def initialize parent_config = nil
                @parent_config = parent_config unless parent_config.nil?

                yield self if block_given?
              end

              ##
              # Configurations for individual RPCs
              # @return [Rpcs]
              #
              def rpcs
                @rpcs ||= begin
                  parent_rpcs = nil
                  parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                  Rpcs.new parent_rpcs
                end
              end

              ##
              # Configuration for the channel pool
              # @return [::Gapic::ServiceStub::ChannelPool::Configuration]
              #
              def channel_pool
                @channel_pool ||= ::Gapic::ServiceStub::ChannelPool::Configuration.new
              end

              ##
              # Configuration RPC class for the MetadataService API.
              #
              # Includes fields providing the configuration for each RPC in this service.
              # Each configuration object is of type `Gapic::Config::Method` and includes
              # the following configuration fields:
              #
              #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
              #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional gRPC headers
              #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
              #     include the following keys:
              #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #         trigger a retry.
              #
              class Rpcs
                ##
                # RPC-specific configuration for `create_entity`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_entity
                ##
                # RPC-specific configuration for `update_entity`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :update_entity
                ##
                # RPC-specific configuration for `delete_entity`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_entity
                ##
                # RPC-specific configuration for `get_entity`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_entity
                ##
                # RPC-specific configuration for `list_entities`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_entities
                ##
                # RPC-specific configuration for `create_partition`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :create_partition
                ##
                # RPC-specific configuration for `delete_partition`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :delete_partition
                ##
                # RPC-specific configuration for `get_partition`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :get_partition
                ##
                # RPC-specific configuration for `list_partitions`
                # @return [::Gapic::Config::Method]
                #
                attr_reader :list_partitions

                # @private
                def initialize parent_rpcs = nil
                  create_entity_config = parent_rpcs.create_entity if parent_rpcs.respond_to? :create_entity
                  @create_entity = ::Gapic::Config::Method.new create_entity_config
                  update_entity_config = parent_rpcs.update_entity if parent_rpcs.respond_to? :update_entity
                  @update_entity = ::Gapic::Config::Method.new update_entity_config
                  delete_entity_config = parent_rpcs.delete_entity if parent_rpcs.respond_to? :delete_entity
                  @delete_entity = ::Gapic::Config::Method.new delete_entity_config
                  get_entity_config = parent_rpcs.get_entity if parent_rpcs.respond_to? :get_entity
                  @get_entity = ::Gapic::Config::Method.new get_entity_config
                  list_entities_config = parent_rpcs.list_entities if parent_rpcs.respond_to? :list_entities
                  @list_entities = ::Gapic::Config::Method.new list_entities_config
                  create_partition_config = parent_rpcs.create_partition if parent_rpcs.respond_to? :create_partition
                  @create_partition = ::Gapic::Config::Method.new create_partition_config
                  delete_partition_config = parent_rpcs.delete_partition if parent_rpcs.respond_to? :delete_partition
                  @delete_partition = ::Gapic::Config::Method.new delete_partition_config
                  get_partition_config = parent_rpcs.get_partition if parent_rpcs.respond_to? :get_partition
                  @get_partition = ::Gapic::Config::Method.new get_partition_config
                  list_partitions_config = parent_rpcs.list_partitions if parent_rpcs.respond_to? :list_partitions
                  @list_partitions = ::Gapic::Config::Method.new list_partitions_config

                  yield self if block_given?
                end
              end
            end
          end
        end
      end
    end
  end
end
