# frozen_string_literal: true

# Copyright 2023 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Auto-generated by gapic-generator-ruby. DO NOT EDIT!

require "google/cloud/errors"
require "google/cloud/dataplex/v1/service_pb"
require "google/cloud/dataplex/v1/dataplex_service/rest/service_stub"
require "google/cloud/location/rest"
require "google/iam/v1/rest"

module Google
  module Cloud
    module Dataplex
      module V1
        module DataplexService
          module Rest
            ##
            # REST client for the DataplexService service.
            #
            # Dataplex service provides data lakes as a service. The primary resources
            # offered by this service are Lakes, Zones and Assets which collectively allow
            # a data administrator to organize, manage, secure and catalog data across
            # their organization located across cloud projects in a variety of storage
            # systems including Cloud Storage and BigQuery.
            #
            class Client
              # @private
              API_VERSION = ""

              # @private
              DEFAULT_ENDPOINT_TEMPLATE = "dataplex.$UNIVERSE_DOMAIN$"

              include Paths

              # @private
              attr_reader :dataplex_service_stub

              ##
              # Configure the DataplexService Client class.
              #
              # See {::Google::Cloud::Dataplex::V1::DataplexService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @example
              #
              #   # Modify the configuration for all DataplexService clients
              #   ::Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def self.configure
                @configure ||= begin
                  namespace = ["Google", "Cloud", "Dataplex", "V1"]
                  parent_config = while namespace.any?
                                    parent_name = namespace.join "::"
                                    parent_const = const_get parent_name
                                    break parent_const.configure if parent_const.respond_to? :configure
                                    namespace.pop
                                  end
                  default_config = Client::Configuration.new parent_config

                  default_config.rpcs.create_lake.timeout = 60.0

                  default_config.rpcs.update_lake.timeout = 60.0

                  default_config.rpcs.delete_lake.timeout = 60.0

                  default_config.rpcs.list_lakes.timeout = 60.0
                  default_config.rpcs.list_lakes.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_lake.timeout = 60.0
                  default_config.rpcs.get_lake.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_lake_actions.timeout = 60.0
                  default_config.rpcs.list_lake_actions.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_zone.timeout = 60.0

                  default_config.rpcs.update_zone.timeout = 60.0

                  default_config.rpcs.delete_zone.timeout = 60.0

                  default_config.rpcs.list_zones.timeout = 60.0
                  default_config.rpcs.list_zones.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_zone.timeout = 60.0
                  default_config.rpcs.get_zone.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_zone_actions.timeout = 60.0
                  default_config.rpcs.list_zone_actions.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_asset.timeout = 60.0

                  default_config.rpcs.update_asset.timeout = 60.0

                  default_config.rpcs.delete_asset.timeout = 60.0

                  default_config.rpcs.list_assets.timeout = 60.0
                  default_config.rpcs.list_assets.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_asset.timeout = 60.0
                  default_config.rpcs.get_asset.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_asset_actions.timeout = 60.0
                  default_config.rpcs.list_asset_actions.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.create_task.timeout = 60.0

                  default_config.rpcs.update_task.timeout = 60.0

                  default_config.rpcs.delete_task.timeout = 60.0

                  default_config.rpcs.list_tasks.timeout = 60.0
                  default_config.rpcs.list_tasks.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_task.timeout = 60.0
                  default_config.rpcs.get_task.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.list_jobs.timeout = 60.0
                  default_config.rpcs.list_jobs.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_job.timeout = 60.0
                  default_config.rpcs.get_job.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.cancel_job.timeout = 60.0

                  default_config.rpcs.create_environment.timeout = 60.0

                  default_config.rpcs.update_environment.timeout = 60.0

                  default_config.rpcs.delete_environment.timeout = 60.0

                  default_config.rpcs.list_environments.timeout = 60.0
                  default_config.rpcs.list_environments.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config.rpcs.get_environment.timeout = 60.0
                  default_config.rpcs.get_environment.retry_policy = {
                    initial_delay: 1.0, max_delay: 10.0, multiplier: 1.3, retry_codes: [14]
                  }

                  default_config
                end
                yield @configure if block_given?
                @configure
              end

              ##
              # Configure the DataplexService Client instance.
              #
              # The configuration is set to the derived mode, meaning that values can be changed,
              # but structural changes (adding new fields, etc.) are not allowed. Structural changes
              # should be made on {Client.configure}.
              #
              # See {::Google::Cloud::Dataplex::V1::DataplexService::Rest::Client::Configuration}
              # for a description of the configuration fields.
              #
              # @yield [config] Configure the Client client.
              # @yieldparam config [Client::Configuration]
              #
              # @return [Client::Configuration]
              #
              def configure
                yield @config if block_given?
                @config
              end

              ##
              # The effective universe domain
              #
              # @return [String]
              #
              def universe_domain
                @dataplex_service_stub.universe_domain
              end

              ##
              # Create a new DataplexService REST client object.
              #
              # @example
              #
              #   # Create a client using the default configuration
              #   client = ::Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a client using a custom configuration
              #   client = ::Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #   end
              #
              # @yield [config] Configure the DataplexService client.
              # @yieldparam config [Client::Configuration]
              #
              def initialize
                # Create the configuration object
                @config = Configuration.new Client.configure

                # Yield the configuration if needed
                yield @config if block_given?

                # Create credentials
                credentials = @config.credentials
                # Use self-signed JWT if the endpoint is unchanged from default,
                # but only if the default endpoint does not have a region prefix.
                enable_self_signed_jwt = @config.endpoint.nil? ||
                                         (@config.endpoint == Configuration::DEFAULT_ENDPOINT &&
                                         !@config.endpoint.split(".").first.include?("-"))
                credentials ||= Credentials.default scope: @config.scope,
                                                    enable_self_signed_jwt: enable_self_signed_jwt
                if credentials.is_a?(::String) || credentials.is_a?(::Hash)
                  credentials = Credentials.new credentials, scope: @config.scope
                end

                @quota_project_id = @config.quota_project
                @quota_project_id ||= credentials.quota_project_id if credentials.respond_to? :quota_project_id

                @operations_client = ::Google::Cloud::Dataplex::V1::DataplexService::Rest::Operations.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @config.endpoint
                  config.universe_domain = @config.universe_domain
                end

                @dataplex_service_stub = ::Google::Cloud::Dataplex::V1::DataplexService::Rest::ServiceStub.new(
                  endpoint: @config.endpoint,
                  endpoint_template: DEFAULT_ENDPOINT_TEMPLATE,
                  universe_domain: @config.universe_domain,
                  credentials: credentials,
                  logger: @config.logger
                )

                @dataplex_service_stub.logger(stub: true)&.info do |entry|
                  entry.set_system_name
                  entry.set_service
                  entry.message = "Created client for #{entry.service}"
                  entry.set_credentials_fields credentials
                  entry.set "customEndpoint", @config.endpoint if @config.endpoint
                  entry.set "defaultTimeout", @config.timeout if @config.timeout
                  entry.set "quotaProject", @quota_project_id if @quota_project_id
                end

                @location_client = Google::Cloud::Location::Locations::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @dataplex_service_stub.endpoint
                  config.universe_domain = @dataplex_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @dataplex_service_stub.logger if config.respond_to? :logger=
                end

                @iam_policy_client = Google::Iam::V1::IAMPolicy::Rest::Client.new do |config|
                  config.credentials = credentials
                  config.quota_project = @quota_project_id
                  config.endpoint = @dataplex_service_stub.endpoint
                  config.universe_domain = @dataplex_service_stub.universe_domain
                  config.bindings_override = @config.bindings_override
                  config.logger = @dataplex_service_stub.logger if config.respond_to? :logger=
                end
              end

              ##
              # Get the associated client for long-running operations.
              #
              # @return [::Google::Cloud::Dataplex::V1::DataplexService::Rest::Operations]
              #
              attr_reader :operations_client

              ##
              # Get the associated client for mix-in of the Locations.
              #
              # @return [Google::Cloud::Location::Locations::Rest::Client]
              #
              attr_reader :location_client

              ##
              # Get the associated client for mix-in of the IAMPolicy.
              #
              # @return [Google::Iam::V1::IAMPolicy::Rest::Client]
              #
              attr_reader :iam_policy_client

              ##
              # The logger used for request/response debug logging.
              #
              # @return [Logger]
              #
              def logger
                @dataplex_service_stub.logger
              end

              # Service calls

              ##
              # Creates a lake resource.
              #
              # @overload create_lake(request, options = nil)
              #   Pass arguments to `create_lake` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::CreateLakeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::CreateLakeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_lake(parent: nil, lake_id: nil, lake: nil, validate_only: nil)
              #   Pass arguments to `create_lake` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the lake location, of the form:
              #     projects/\\{project_number}/locations/\\{location_id}
              #     where `location_id` refers to a Google Cloud region.
              #   @param lake_id [::String]
              #     Required. Lake identifier.
              #     This ID will be used to generate names such as database and dataset names
              #     when publishing metadata to Hive Metastore and BigQuery.
              #     * Must contain only lowercase letters, numbers and hyphens.
              #     * Must start with a letter.
              #     * Must end with a number or a letter.
              #     * Must be between 1-63 characters.
              #     * Must be unique within the customer project / location.
              #   @param lake [::Google::Cloud::Dataplex::V1::Lake, ::Hash]
              #     Required. Lake resource
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the request, but do not perform mutations.
              #     The default is false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::CreateLakeRequest.new
              #
              #   # Call the create_lake method.
              #   result = client.create_lake request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_lake request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateLakeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_lake.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_lake.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_lake.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.create_lake request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a lake resource.
              #
              # @overload update_lake(request, options = nil)
              #   Pass arguments to `update_lake` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::UpdateLakeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::UpdateLakeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_lake(update_mask: nil, lake: nil, validate_only: nil)
              #   Pass arguments to `update_lake` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask of fields to update.
              #   @param lake [::Google::Cloud::Dataplex::V1::Lake, ::Hash]
              #     Required. Update description.
              #     Only fields specified in `update_mask` are updated.
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the request, but do not perform mutations.
              #     The default is false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::UpdateLakeRequest.new
              #
              #   # Call the update_lake method.
              #   result = client.update_lake request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_lake request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateLakeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_lake.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_lake.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_lake.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.update_lake request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a lake resource. All zones within the lake must be deleted before
              # the lake can be deleted.
              #
              # @overload delete_lake(request, options = nil)
              #   Pass arguments to `delete_lake` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::DeleteLakeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::DeleteLakeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_lake(name: nil)
              #   Pass arguments to `delete_lake` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the lake:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::DeleteLakeRequest.new
              #
              #   # Call the delete_lake method.
              #   result = client.delete_lake request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_lake request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteLakeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_lake.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_lake.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_lake.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.delete_lake request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists lake resources in a project and location.
              #
              # @overload list_lakes(request, options = nil)
              #   Pass arguments to `list_lakes` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListLakesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListLakesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_lakes(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_lakes` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the lake location, of the form:
              #     `projects/{project_number}/locations/{location_id}`
              #     where `location_id` refers to a Google Cloud region.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of Lakes to return. The service may return fewer
              #     than this value. If unspecified, at most 10 lakes will be returned. The
              #     maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. Page token received from a previous `ListLakes` call. Provide
              #     this to retrieve the subsequent page. When paginating, all other parameters
              #     provided to `ListLakes` must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. Filter request.
              #   @param order_by [::String]
              #     Optional. Order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Lake>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Lake>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListLakesRequest.new
              #
              #   # Call the list_lakes method.
              #   result = client.list_lakes request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::Lake.
              #     p item
              #   end
              #
              def list_lakes request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListLakesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_lakes.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_lakes.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_lakes.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.list_lakes request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataplex_service_stub, :list_lakes, "lakes", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves a lake resource.
              #
              # @overload get_lake(request, options = nil)
              #   Pass arguments to `get_lake` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::GetLakeRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::GetLakeRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_lake(name: nil)
              #   Pass arguments to `get_lake` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the lake:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::Lake]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::Lake]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::GetLakeRequest.new
              #
              #   # Call the get_lake method.
              #   result = client.get_lake request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::Lake.
              #   p result
              #
              def get_lake request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetLakeRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_lake.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_lake.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_lake.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.get_lake request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists action resources in a lake.
              #
              # @overload list_lake_actions(request, options = nil)
              #   Pass arguments to `list_lake_actions` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListLakeActionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListLakeActionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_lake_actions(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_lake_actions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent lake:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of actions to return. The service may return fewer
              #     than this value. If unspecified, at most 10 actions will be returned. The
              #     maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. Page token received from a previous `ListLakeActions` call.
              #     Provide this to retrieve the subsequent page. When paginating, all other
              #     parameters provided to `ListLakeActions` must match the call that provided
              #     the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Action>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Action>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListLakeActionsRequest.new
              #
              #   # Call the list_lake_actions method.
              #   result = client.list_lake_actions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::Action.
              #     p item
              #   end
              #
              def list_lake_actions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListLakeActionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_lake_actions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_lake_actions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_lake_actions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.list_lake_actions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataplex_service_stub, :list_lake_actions, "actions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a zone resource within a lake.
              #
              # @overload create_zone(request, options = nil)
              #   Pass arguments to `create_zone` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::CreateZoneRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::CreateZoneRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_zone(parent: nil, zone_id: nil, zone: nil, validate_only: nil)
              #   Pass arguments to `create_zone` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent lake:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
              #   @param zone_id [::String]
              #     Required. Zone identifier.
              #     This ID will be used to generate names such as database and dataset names
              #     when publishing metadata to Hive Metastore and BigQuery.
              #     * Must contain only lowercase letters, numbers and hyphens.
              #     * Must start with a letter.
              #     * Must end with a number or a letter.
              #     * Must be between 1-63 characters.
              #     * Must be unique across all lakes from all locations in a project.
              #     * Must not be one of the reserved IDs (i.e. "default", "global-temp")
              #   @param zone [::Google::Cloud::Dataplex::V1::Zone, ::Hash]
              #     Required. Zone resource.
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the request, but do not perform mutations.
              #     The default is false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::CreateZoneRequest.new
              #
              #   # Call the create_zone method.
              #   result = client.create_zone request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_zone request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateZoneRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_zone.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_zone.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_zone.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.create_zone request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates a zone resource.
              #
              # @overload update_zone(request, options = nil)
              #   Pass arguments to `update_zone` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::UpdateZoneRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::UpdateZoneRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_zone(update_mask: nil, zone: nil, validate_only: nil)
              #   Pass arguments to `update_zone` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask of fields to update.
              #   @param zone [::Google::Cloud::Dataplex::V1::Zone, ::Hash]
              #     Required. Update description.
              #     Only fields specified in `update_mask` are updated.
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the request, but do not perform mutations.
              #     The default is false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::UpdateZoneRequest.new
              #
              #   # Call the update_zone method.
              #   result = client.update_zone request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_zone request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateZoneRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_zone.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_zone.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_zone.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.update_zone request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes a zone resource. All assets within a zone must be deleted before
              # the zone can be deleted.
              #
              # @overload delete_zone(request, options = nil)
              #   Pass arguments to `delete_zone` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::DeleteZoneRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::DeleteZoneRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_zone(name: nil)
              #   Pass arguments to `delete_zone` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the zone:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::DeleteZoneRequest.new
              #
              #   # Call the delete_zone method.
              #   result = client.delete_zone request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_zone request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteZoneRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_zone.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_zone.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_zone.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.delete_zone request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists zone resources in a lake.
              #
              # @overload list_zones(request, options = nil)
              #   Pass arguments to `list_zones` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListZonesRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListZonesRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_zones(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_zones` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent lake:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of zones to return. The service may return fewer
              #     than this value. If unspecified, at most 10 zones will be returned. The
              #     maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. Page token received from a previous `ListZones` call. Provide
              #     this to retrieve the subsequent page. When paginating, all other parameters
              #     provided to `ListZones` must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. Filter request.
              #   @param order_by [::String]
              #     Optional. Order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Zone>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Zone>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListZonesRequest.new
              #
              #   # Call the list_zones method.
              #   result = client.list_zones request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::Zone.
              #     p item
              #   end
              #
              def list_zones request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListZonesRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_zones.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_zones.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_zones.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.list_zones request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataplex_service_stub, :list_zones, "zones", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves a zone resource.
              #
              # @overload get_zone(request, options = nil)
              #   Pass arguments to `get_zone` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::GetZoneRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::GetZoneRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_zone(name: nil)
              #   Pass arguments to `get_zone` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the zone:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::Zone]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::Zone]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::GetZoneRequest.new
              #
              #   # Call the get_zone method.
              #   result = client.get_zone request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::Zone.
              #   p result
              #
              def get_zone request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetZoneRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_zone.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_zone.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_zone.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.get_zone request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists action resources in a zone.
              #
              # @overload list_zone_actions(request, options = nil)
              #   Pass arguments to `list_zone_actions` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListZoneActionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListZoneActionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_zone_actions(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_zone_actions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent zone:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of actions to return. The service may return fewer
              #     than this value. If unspecified, at most 10 actions will be returned. The
              #     maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. Page token received from a previous `ListZoneActions` call.
              #     Provide this to retrieve the subsequent page. When paginating, all other
              #     parameters provided to `ListZoneActions` must match the call that provided
              #     the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Action>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Action>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListZoneActionsRequest.new
              #
              #   # Call the list_zone_actions method.
              #   result = client.list_zone_actions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::Action.
              #     p item
              #   end
              #
              def list_zone_actions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListZoneActionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_zone_actions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_zone_actions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_zone_actions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.list_zone_actions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataplex_service_stub, :list_zone_actions, "actions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates an asset resource.
              #
              # @overload create_asset(request, options = nil)
              #   Pass arguments to `create_asset` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::CreateAssetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::CreateAssetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_asset(parent: nil, asset_id: nil, asset: nil, validate_only: nil)
              #   Pass arguments to `create_asset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent zone:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
              #   @param asset_id [::String]
              #     Required. Asset identifier.
              #     This ID will be used to generate names such as table names when publishing
              #     metadata to Hive Metastore and BigQuery.
              #     * Must contain only lowercase letters, numbers and hyphens.
              #     * Must start with a letter.
              #     * Must end with a number or a letter.
              #     * Must be between 1-63 characters.
              #     * Must be unique within the zone.
              #   @param asset [::Google::Cloud::Dataplex::V1::Asset, ::Hash]
              #     Required. Asset resource.
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the request, but do not perform mutations.
              #     The default is false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::CreateAssetRequest.new
              #
              #   # Call the create_asset method.
              #   result = client.create_asset request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_asset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateAssetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_asset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_asset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_asset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.create_asset request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Updates an asset resource.
              #
              # @overload update_asset(request, options = nil)
              #   Pass arguments to `update_asset` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::UpdateAssetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::UpdateAssetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_asset(update_mask: nil, asset: nil, validate_only: nil)
              #   Pass arguments to `update_asset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask of fields to update.
              #   @param asset [::Google::Cloud::Dataplex::V1::Asset, ::Hash]
              #     Required. Update description.
              #     Only fields specified in `update_mask` are updated.
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the request, but do not perform mutations.
              #     The default is false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::UpdateAssetRequest.new
              #
              #   # Call the update_asset method.
              #   result = client.update_asset request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_asset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateAssetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_asset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_asset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_asset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.update_asset request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Deletes an asset resource. The referenced storage resource is detached
              # (default) or deleted based on the associated Lifecycle policy.
              #
              # @overload delete_asset(request, options = nil)
              #   Pass arguments to `delete_asset` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::DeleteAssetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::DeleteAssetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_asset(name: nil)
              #   Pass arguments to `delete_asset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the asset:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::DeleteAssetRequest.new
              #
              #   # Call the delete_asset method.
              #   result = client.delete_asset request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_asset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteAssetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_asset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_asset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_asset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.delete_asset request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists asset resources in a zone.
              #
              # @overload list_assets(request, options = nil)
              #   Pass arguments to `list_assets` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListAssetsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListAssetsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_assets(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_assets` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent zone:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}`.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of asset to return. The service may return fewer
              #     than this value. If unspecified, at most 10 assets will be returned. The
              #     maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. Page token received from a previous `ListAssets` call. Provide
              #     this to retrieve the subsequent page. When paginating, all other parameters
              #     provided to `ListAssets` must match the call that provided the page
              #     token.
              #   @param filter [::String]
              #     Optional. Filter request.
              #   @param order_by [::String]
              #     Optional. Order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Asset>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Asset>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListAssetsRequest.new
              #
              #   # Call the list_assets method.
              #   result = client.list_assets request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::Asset.
              #     p item
              #   end
              #
              def list_assets request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListAssetsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_assets.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_assets.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_assets.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.list_assets request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataplex_service_stub, :list_assets, "assets", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Retrieves an asset resource.
              #
              # @overload get_asset(request, options = nil)
              #   Pass arguments to `get_asset` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::GetAssetRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::GetAssetRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_asset(name: nil)
              #   Pass arguments to `get_asset` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the asset:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::Asset]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::Asset]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::GetAssetRequest.new
              #
              #   # Call the get_asset method.
              #   result = client.get_asset request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::Asset.
              #   p result
              #
              def get_asset request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetAssetRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_asset.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_asset.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_asset.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.get_asset request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists action resources in an asset.
              #
              # @overload list_asset_actions(request, options = nil)
              #   Pass arguments to `list_asset_actions` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListAssetActionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListAssetActionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_asset_actions(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_asset_actions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent asset:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zones/{zone_id}/assets/{asset_id}`.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of actions to return. The service may return fewer
              #     than this value. If unspecified, at most 10 actions will be returned. The
              #     maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. Page token received from a previous `ListAssetActions` call.
              #     Provide this to retrieve the subsequent page. When paginating, all other
              #     parameters provided to `ListAssetActions` must match the call that provided
              #     the page token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Action>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Action>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListAssetActionsRequest.new
              #
              #   # Call the list_asset_actions method.
              #   result = client.list_asset_actions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::Action.
              #     p item
              #   end
              #
              def list_asset_actions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListAssetActionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_asset_actions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_asset_actions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_asset_actions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.list_asset_actions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataplex_service_stub, :list_asset_actions, "actions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Creates a task resource within a lake.
              #
              # @overload create_task(request, options = nil)
              #   Pass arguments to `create_task` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::CreateTaskRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::CreateTaskRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_task(parent: nil, task_id: nil, task: nil, validate_only: nil)
              #   Pass arguments to `create_task` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent lake:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
              #   @param task_id [::String]
              #     Required. Task identifier.
              #   @param task [::Google::Cloud::Dataplex::V1::Task, ::Hash]
              #     Required. Task resource.
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the request, but do not perform mutations.
              #     The default is false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::CreateTaskRequest.new
              #
              #   # Call the create_task method.
              #   result = client.create_task request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_task request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateTaskRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_task.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_task.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_task.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.create_task request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update the task resource.
              #
              # @overload update_task(request, options = nil)
              #   Pass arguments to `update_task` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::UpdateTaskRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::UpdateTaskRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_task(update_mask: nil, task: nil, validate_only: nil)
              #   Pass arguments to `update_task` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask of fields to update.
              #   @param task [::Google::Cloud::Dataplex::V1::Task, ::Hash]
              #     Required. Update description.
              #     Only fields specified in `update_mask` are updated.
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the request, but do not perform mutations.
              #     The default is false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::UpdateTaskRequest.new
              #
              #   # Call the update_task method.
              #   result = client.update_task request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_task request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateTaskRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_task.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_task.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_task.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.update_task request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete the task resource.
              #
              # @overload delete_task(request, options = nil)
              #   Pass arguments to `delete_task` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::DeleteTaskRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::DeleteTaskRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_task(name: nil)
              #   Pass arguments to `delete_task` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the task:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/task/{task_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::DeleteTaskRequest.new
              #
              #   # Call the delete_task method.
              #   result = client.delete_task request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_task request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteTaskRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_task.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_task.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_task.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.delete_task request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists tasks under the given lake.
              #
              # @overload list_tasks(request, options = nil)
              #   Pass arguments to `list_tasks` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListTasksRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListTasksRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_tasks(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_tasks` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent lake:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}`.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of tasks to return. The service may return fewer
              #     than this value. If unspecified, at most 10 tasks will be returned. The
              #     maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. Page token received from a previous `ListZones` call. Provide
              #     this to retrieve the subsequent page. When paginating, all other parameters
              #     provided to `ListZones` must match the call that provided the page token.
              #   @param filter [::String]
              #     Optional. Filter request.
              #   @param order_by [::String]
              #     Optional. Order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Task>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Task>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListTasksRequest.new
              #
              #   # Call the list_tasks method.
              #   result = client.list_tasks request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::Task.
              #     p item
              #   end
              #
              def list_tasks request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListTasksRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_tasks.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_tasks.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_tasks.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.list_tasks request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataplex_service_stub, :list_tasks, "tasks", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get task resource.
              #
              # @overload get_task(request, options = nil)
              #   Pass arguments to `get_task` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::GetTaskRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::GetTaskRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_task(name: nil)
              #   Pass arguments to `get_task` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the task:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{tasks_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::Task]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::Task]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::GetTaskRequest.new
              #
              #   # Call the get_task method.
              #   result = client.get_task request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::Task.
              #   p result
              #
              def get_task request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetTaskRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_task.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_task.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_task.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.get_task request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists Jobs under the given task.
              #
              # @overload list_jobs(request, options = nil)
              #   Pass arguments to `list_jobs` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListJobsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListJobsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_jobs(parent: nil, page_size: nil, page_token: nil)
              #   Pass arguments to `list_jobs` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent environment:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}`.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of jobs to return. The service may return fewer
              #     than this value. If unspecified, at most 10 jobs will be returned. The
              #     maximum value is 1000; values above 1000 will be coerced to 1000.
              #   @param page_token [::String]
              #     Optional. Page token received from a previous `ListJobs` call. Provide this
              #     to retrieve the subsequent page. When paginating, all other parameters
              #     provided to `ListJobs` must match the call that provided the page
              #     token.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Job>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Job>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListJobsRequest.new
              #
              #   # Call the list_jobs method.
              #   result = client.list_jobs request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::Job.
              #     p item
              #   end
              #
              def list_jobs request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListJobsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_jobs.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_jobs.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_jobs.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.list_jobs request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataplex_service_stub, :list_jobs, "jobs", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Run an on demand execution of a Task.
              #
              # @overload run_task(request, options = nil)
              #   Pass arguments to `run_task` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::RunTaskRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::RunTaskRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload run_task(name: nil, labels: nil, args: nil)
              #   Pass arguments to `run_task` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the task:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}`.
              #   @param labels [::Hash{::String => ::String}]
              #     Optional. User-defined labels for the task. If the map is left empty, the
              #     task will run with existing labels from task definition. If the map
              #     contains an entry with a new key, the same will be added to existing set of
              #     labels. If the map contains an entry with an existing label key in task
              #     definition, the task will run with new label value for that entry. Clearing
              #     an existing label will require label value to be explicitly set to a hyphen
              #     "-". The label value cannot be empty.
              #   @param args [::Hash{::String => ::String}]
              #     Optional. Execution spec arguments. If the map is left empty, the task will
              #     run with existing execution spec args from task definition. If the map
              #     contains an entry with a new key, the same will be added to existing set of
              #     args. If the map contains an entry with an existing arg key in task
              #     definition, the task will run with new arg value for that entry. Clearing
              #     an existing arg will require arg value to be explicitly set to a hyphen
              #     "-". The arg value cannot be empty.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::RunTaskResponse]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::RunTaskResponse]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::RunTaskRequest.new
              #
              #   # Call the run_task method.
              #   result = client.run_task request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::RunTaskResponse.
              #   p result
              #
              def run_task request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::RunTaskRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.run_task.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.run_task.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.run_task.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.run_task request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get job resource.
              #
              # @overload get_job(request, options = nil)
              #   Pass arguments to `get_job` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::GetJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::GetJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_job(name: nil)
              #   Pass arguments to `get_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the job:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/tasks/{task_id}/jobs/{job_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::Job]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::Job]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::GetJobRequest.new
              #
              #   # Call the get_job method.
              #   result = client.get_job request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::Job.
              #   p result
              #
              def get_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.get_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Cancel jobs running for the task resource.
              #
              # @overload cancel_job(request, options = nil)
              #   Pass arguments to `cancel_job` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::CancelJobRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::CancelJobRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload cancel_job(name: nil)
              #   Pass arguments to `cancel_job` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the job:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/task/{task_id}/job/{job_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Protobuf::Empty]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Protobuf::Empty]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::CancelJobRequest.new
              #
              #   # Call the cancel_job method.
              #   result = client.cancel_job request
              #
              #   # The returned object is of type Google::Protobuf::Empty.
              #   p result
              #
              def cancel_job request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CancelJobRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.cancel_job.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.cancel_job.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.cancel_job.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.cancel_job request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Create an environment resource.
              #
              # @overload create_environment(request, options = nil)
              #   Pass arguments to `create_environment` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::CreateEnvironmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::CreateEnvironmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload create_environment(parent: nil, environment_id: nil, environment: nil, validate_only: nil)
              #   Pass arguments to `create_environment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent lake:
              #     `projects/{project_id}/locations/{location_id}/lakes/{lake_id}`.
              #   @param environment_id [::String]
              #     Required. Environment identifier.
              #     * Must contain only lowercase letters, numbers and hyphens.
              #     * Must start with a letter.
              #     * Must be between 1-63 characters.
              #     * Must end with a number or a letter.
              #     * Must be unique within the lake.
              #   @param environment [::Google::Cloud::Dataplex::V1::Environment, ::Hash]
              #     Required. Environment resource.
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the request, but do not perform mutations.
              #     The default is false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::CreateEnvironmentRequest.new
              #
              #   # Call the create_environment method.
              #   result = client.create_environment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def create_environment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::CreateEnvironmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.create_environment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.create_environment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.create_environment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.create_environment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Update the environment resource.
              #
              # @overload update_environment(request, options = nil)
              #   Pass arguments to `update_environment` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::UpdateEnvironmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::UpdateEnvironmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload update_environment(update_mask: nil, environment: nil, validate_only: nil)
              #   Pass arguments to `update_environment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param update_mask [::Google::Protobuf::FieldMask, ::Hash]
              #     Required. Mask of fields to update.
              #   @param environment [::Google::Cloud::Dataplex::V1::Environment, ::Hash]
              #     Required. Update description.
              #     Only fields specified in `update_mask` are updated.
              #   @param validate_only [::Boolean]
              #     Optional. Only validate the request, but do not perform mutations.
              #     The default is false.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::UpdateEnvironmentRequest.new
              #
              #   # Call the update_environment method.
              #   result = client.update_environment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def update_environment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::UpdateEnvironmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.update_environment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.update_environment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.update_environment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.update_environment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Delete the environment resource. All the child resources must have been
              # deleted before environment deletion can be initiated.
              #
              # @overload delete_environment(request, options = nil)
              #   Pass arguments to `delete_environment` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::DeleteEnvironmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::DeleteEnvironmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload delete_environment(name: nil)
              #   Pass arguments to `delete_environment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the environment:
              #     `projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environments/{environment_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Operation]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Operation]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::DeleteEnvironmentRequest.new
              #
              #   # Call the delete_environment method.
              #   result = client.delete_environment request
              #
              #   # The returned object is of type Gapic::Operation. You can use it to
              #   # check the status of an operation, cancel it, or wait for results.
              #   # Here is how to wait for a response.
              #   result.wait_until_done! timeout: 60
              #   if result.response?
              #     p result.response
              #   else
              #     puts "No response received."
              #   end
              #
              def delete_environment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::DeleteEnvironmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.delete_environment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.delete_environment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.delete_environment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.delete_environment request, options do |result, operation|
                  result = ::Gapic::Operation.new result, @operations_client, options: options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists environments under the given lake.
              #
              # @overload list_environments(request, options = nil)
              #   Pass arguments to `list_environments` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListEnvironmentsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListEnvironmentsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_environments(parent: nil, page_size: nil, page_token: nil, filter: nil, order_by: nil)
              #   Pass arguments to `list_environments` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent lake:
              #     `projects/{project_id}/locations/{location_id}/lakes/{lake_id}`.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of environments to return. The service may return
              #     fewer than this value. If unspecified, at most 10 environments will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Optional. Page token received from a previous `ListEnvironments` call.
              #     Provide this to retrieve the subsequent page. When paginating, all other
              #     parameters provided to `ListEnvironments` must match the call that provided
              #     the page token.
              #   @param filter [::String]
              #     Optional. Filter request.
              #   @param order_by [::String]
              #     Optional. Order by fields for the result.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Environment>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Environment>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListEnvironmentsRequest.new
              #
              #   # Call the list_environments method.
              #   result = client.list_environments request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::Environment.
              #     p item
              #   end
              #
              def list_environments request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListEnvironmentsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_environments.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_environments.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_environments.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.list_environments request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataplex_service_stub, :list_environments, "environments", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Get environment resource.
              #
              # @overload get_environment(request, options = nil)
              #   Pass arguments to `get_environment` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::GetEnvironmentRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::GetEnvironmentRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload get_environment(name: nil)
              #   Pass arguments to `get_environment` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param name [::String]
              #     Required. The resource name of the environment:
              #     `projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environments/{environment_id}`.
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Google::Cloud::Dataplex::V1::Environment]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Google::Cloud::Dataplex::V1::Environment]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::GetEnvironmentRequest.new
              #
              #   # Call the get_environment method.
              #   result = client.get_environment request
              #
              #   # The returned object is of type Google::Cloud::Dataplex::V1::Environment.
              #   p result
              #
              def get_environment request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::GetEnvironmentRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.get_environment.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.get_environment.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.get_environment.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.get_environment request, options do |result, operation|
                  yield result, operation if block_given?
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Lists session resources in an environment.
              #
              # @overload list_sessions(request, options = nil)
              #   Pass arguments to `list_sessions` via a request object, either of type
              #   {::Google::Cloud::Dataplex::V1::ListSessionsRequest} or an equivalent Hash.
              #
              #   @param request [::Google::Cloud::Dataplex::V1::ListSessionsRequest, ::Hash]
              #     A request object representing the call parameters. Required. To specify no
              #     parameters, or to keep all the default parameter values, pass an empty Hash.
              #   @param options [::Gapic::CallOptions, ::Hash]
              #     Overrides the default settings for this call, e.g, timeout, retries etc. Optional.
              #
              # @overload list_sessions(parent: nil, page_size: nil, page_token: nil, filter: nil)
              #   Pass arguments to `list_sessions` via keyword arguments. Note that at
              #   least one keyword argument is required. To specify no parameters, or to keep all
              #   the default parameter values, pass an empty Hash as a request object (see above).
              #
              #   @param parent [::String]
              #     Required. The resource name of the parent environment:
              #     `projects/{project_number}/locations/{location_id}/lakes/{lake_id}/environment/{environment_id}`.
              #   @param page_size [::Integer]
              #     Optional. Maximum number of sessions to return. The service may return
              #     fewer than this value. If unspecified, at most 10 sessions will be
              #     returned. The maximum value is 1000; values above 1000 will be coerced to
              #     1000.
              #   @param page_token [::String]
              #     Optional. Page token received from a previous `ListSessions` call. Provide
              #     this to retrieve the subsequent page. When paginating, all other parameters
              #     provided to `ListSessions` must match the call that provided the page
              #     token.
              #   @param filter [::String]
              #     Optional. Filter request. The following `mode` filter is supported to
              #     return only the sessions belonging to the requester when the mode is USER
              #     and return sessions of all the users when the mode is ADMIN. When no filter
              #     is sent default to USER mode. NOTE: When the mode is ADMIN, the requester
              #     should have `dataplex.environments.listAllSessions` permission to list all
              #     sessions, in absence of the permission, the request fails.
              #
              #     mode = ADMIN | USER
              # @yield [result, operation] Access the result along with the TransportOperation object
              # @yieldparam result [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Session>]
              # @yieldparam operation [::Gapic::Rest::TransportOperation]
              #
              # @return [::Gapic::Rest::PagedEnumerable<::Google::Cloud::Dataplex::V1::Session>]
              #
              # @raise [::Google::Cloud::Error] if the REST call is aborted.
              #
              # @example Basic example
              #   require "google/cloud/dataplex/v1"
              #
              #   # Create a client object. The client can be reused for multiple calls.
              #   client = Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new
              #
              #   # Create a request. To set request fields, pass in keyword arguments.
              #   request = Google::Cloud::Dataplex::V1::ListSessionsRequest.new
              #
              #   # Call the list_sessions method.
              #   result = client.list_sessions request
              #
              #   # The returned object is of type Gapic::PagedEnumerable. You can iterate
              #   # over elements, and API calls will be issued to fetch pages as needed.
              #   result.each do |item|
              #     # Each element is of type ::Google::Cloud::Dataplex::V1::Session.
              #     p item
              #   end
              #
              def list_sessions request, options = nil
                raise ::ArgumentError, "request must be provided" if request.nil?

                request = ::Gapic::Protobuf.coerce request, to: ::Google::Cloud::Dataplex::V1::ListSessionsRequest

                # Converts hash and nil to an options object
                options = ::Gapic::CallOptions.new(**options.to_h) if options.respond_to? :to_h

                # Customize the options with defaults
                call_metadata = @config.rpcs.list_sessions.metadata.to_h

                # Set x-goog-api-client, x-goog-user-project and x-goog-api-version headers
                call_metadata[:"x-goog-api-client"] ||= ::Gapic::Headers.x_goog_api_client \
                  lib_name: @config.lib_name, lib_version: @config.lib_version,
                  gapic_version: ::Google::Cloud::Dataplex::V1::VERSION,
                  transports_version_send: [:rest]

                call_metadata[:"x-goog-api-version"] = API_VERSION unless API_VERSION.empty?
                call_metadata[:"x-goog-user-project"] = @quota_project_id if @quota_project_id

                options.apply_defaults timeout:      @config.rpcs.list_sessions.timeout,
                                       metadata:     call_metadata,
                                       retry_policy: @config.rpcs.list_sessions.retry_policy

                options.apply_defaults timeout:      @config.timeout,
                                       metadata:     @config.metadata,
                                       retry_policy: @config.retry_policy

                @dataplex_service_stub.list_sessions request, options do |result, operation|
                  result = ::Gapic::Rest::PagedEnumerable.new @dataplex_service_stub, :list_sessions, "sessions", request, result, options
                  yield result, operation if block_given?
                  throw :response, result
                end
              rescue ::Gapic::Rest::Error => e
                raise ::Google::Cloud::Error.from_error(e)
              end

              ##
              # Configuration class for the DataplexService REST API.
              #
              # This class represents the configuration for DataplexService REST,
              # providing control over timeouts, retry behavior, logging, transport
              # parameters, and other low-level controls. Certain parameters can also be
              # applied individually to specific RPCs. See
              # {::Google::Cloud::Dataplex::V1::DataplexService::Rest::Client::Configuration::Rpcs}
              # for a list of RPCs that can be configured independently.
              #
              # Configuration can be applied globally to all clients, or to a single client
              # on construction.
              #
              # @example
              #
              #   # Modify the global config, setting the timeout for
              #   # create_lake to 20 seconds,
              #   # and all remaining timeouts to 10 seconds.
              #   ::Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.configure do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_lake.timeout = 20.0
              #   end
              #
              #   # Apply the above configuration only to a new client.
              #   client = ::Google::Cloud::Dataplex::V1::DataplexService::Rest::Client.new do |config|
              #     config.timeout = 10.0
              #     config.rpcs.create_lake.timeout = 20.0
              #   end
              #
              # @!attribute [rw] endpoint
              #   A custom service endpoint, as a hostname or hostname:port. The default is
              #   nil, indicating to use the default endpoint in the current universe domain.
              #   @return [::String,nil]
              # @!attribute [rw] credentials
              #   Credentials to send with calls. You may provide any of the following types:
              #    *  (`String`) The path to a service account key file in JSON format
              #    *  (`Hash`) A service account key as a Hash
              #    *  (`Google::Auth::Credentials`) A googleauth credentials object
              #       (see the [googleauth docs](https://rubydoc.info/gems/googleauth/Google/Auth/Credentials))
              #    *  (`Signet::OAuth2::Client`) A signet oauth2 client object
              #       (see the [signet docs](https://rubydoc.info/gems/signet/Signet/OAuth2/Client))
              #    *  (`nil`) indicating no credentials
              #
              #   Warning: If you accept a credential configuration (JSON file or Hash) from an
              #   external source for authentication to Google Cloud, you must validate it before
              #   providing it to a Google API client library. Providing an unvalidated credential
              #   configuration to Google APIs can compromise the security of your systems and data.
              #   For more information, refer to [Validate credential configurations from external
              #   sources](https://cloud.google.com/docs/authentication/external/externally-sourced-credentials).
              #   @return [::Object]
              # @!attribute [rw] scope
              #   The OAuth scopes
              #   @return [::Array<::String>]
              # @!attribute [rw] lib_name
              #   The library name as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] lib_version
              #   The library version as recorded in instrumentation and logging
              #   @return [::String]
              # @!attribute [rw] timeout
              #   The call timeout in seconds.
              #   @return [::Numeric]
              # @!attribute [rw] metadata
              #   Additional headers to be sent with the call.
              #   @return [::Hash{::Symbol=>::String}]
              # @!attribute [rw] retry_policy
              #   The retry policy. The value is a hash with the following keys:
              #    *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
              #    *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
              #    *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
              #    *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
              #       trigger a retry.
              #   @return [::Hash]
              # @!attribute [rw] quota_project
              #   A separate project against which to charge quota.
              #   @return [::String]
              # @!attribute [rw] universe_domain
              #   The universe domain within which to make requests. This determines the
              #   default endpoint URL. The default value of nil uses the environment
              #   universe (usually the default "googleapis.com" universe).
              #   @return [::String,nil]
              # @!attribute [rw] logger
              #   A custom logger to use for request/response debug logging, or the value
              #   `:default` (the default) to construct a default logger, or `nil` to
              #   explicitly disable logging.
              #   @return [::Logger,:default,nil]
              #
              class Configuration
                extend ::Gapic::Config

                # @private
                # The endpoint specific to the default "googleapis.com" universe. Deprecated.
                DEFAULT_ENDPOINT = "dataplex.googleapis.com"

                config_attr :endpoint,      nil, ::String, nil
                config_attr :credentials,   nil do |value|
                  allowed = [::String, ::Hash, ::Proc, ::Symbol, ::Google::Auth::Credentials, ::Google::Auth::BaseClient, ::Signet::OAuth2::Client, nil]
                  allowed.any? { |klass| klass === value }
                end
                config_attr :scope,         nil, ::String, ::Array, nil
                config_attr :lib_name,      nil, ::String, nil
                config_attr :lib_version,   nil, ::String, nil
                config_attr :timeout,       nil, ::Numeric, nil
                config_attr :metadata,      nil, ::Hash, nil
                config_attr :retry_policy,  nil, ::Hash, ::Proc, nil
                config_attr :quota_project, nil, ::String, nil
                config_attr :universe_domain, nil, ::String, nil

                # @private
                # Overrides for http bindings for the RPCs of this service
                # are only used when this service is used as mixin, and only
                # by the host service.
                # @return [::Hash{::Symbol=>::Array<::Gapic::Rest::GrpcTranscoder::HttpBinding>}]
                config_attr :bindings_override, {}, ::Hash, nil
                config_attr :logger, :default, ::Logger, nil, :default

                # @private
                def initialize parent_config = nil
                  @parent_config = parent_config unless parent_config.nil?

                  yield self if block_given?
                end

                ##
                # Configurations for individual RPCs
                # @return [Rpcs]
                #
                def rpcs
                  @rpcs ||= begin
                    parent_rpcs = nil
                    parent_rpcs = @parent_config.rpcs if defined?(@parent_config) && @parent_config.respond_to?(:rpcs)
                    Rpcs.new parent_rpcs
                  end
                end

                ##
                # Configuration RPC class for the DataplexService API.
                #
                # Includes fields providing the configuration for each RPC in this service.
                # Each configuration object is of type `Gapic::Config::Method` and includes
                # the following configuration fields:
                #
                #  *  `timeout` (*type:* `Numeric`) - The call timeout in seconds
                #  *  `metadata` (*type:* `Hash{Symbol=>String}`) - Additional headers
                #  *  `retry_policy (*type:* `Hash`) - The retry policy. The policy fields
                #     include the following keys:
                #      *  `:initial_delay` (*type:* `Numeric`) - The initial delay in seconds.
                #      *  `:max_delay` (*type:* `Numeric`) - The max delay in seconds.
                #      *  `:multiplier` (*type:* `Numeric`) - The incremental backoff multiplier.
                #      *  `:retry_codes` (*type:* `Array<String>`) - The error codes that should
                #         trigger a retry.
                #
                class Rpcs
                  ##
                  # RPC-specific configuration for `create_lake`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_lake
                  ##
                  # RPC-specific configuration for `update_lake`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_lake
                  ##
                  # RPC-specific configuration for `delete_lake`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_lake
                  ##
                  # RPC-specific configuration for `list_lakes`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_lakes
                  ##
                  # RPC-specific configuration for `get_lake`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_lake
                  ##
                  # RPC-specific configuration for `list_lake_actions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_lake_actions
                  ##
                  # RPC-specific configuration for `create_zone`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_zone
                  ##
                  # RPC-specific configuration for `update_zone`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_zone
                  ##
                  # RPC-specific configuration for `delete_zone`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_zone
                  ##
                  # RPC-specific configuration for `list_zones`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_zones
                  ##
                  # RPC-specific configuration for `get_zone`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_zone
                  ##
                  # RPC-specific configuration for `list_zone_actions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_zone_actions
                  ##
                  # RPC-specific configuration for `create_asset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_asset
                  ##
                  # RPC-specific configuration for `update_asset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_asset
                  ##
                  # RPC-specific configuration for `delete_asset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_asset
                  ##
                  # RPC-specific configuration for `list_assets`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_assets
                  ##
                  # RPC-specific configuration for `get_asset`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_asset
                  ##
                  # RPC-specific configuration for `list_asset_actions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_asset_actions
                  ##
                  # RPC-specific configuration for `create_task`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_task
                  ##
                  # RPC-specific configuration for `update_task`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_task
                  ##
                  # RPC-specific configuration for `delete_task`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_task
                  ##
                  # RPC-specific configuration for `list_tasks`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_tasks
                  ##
                  # RPC-specific configuration for `get_task`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_task
                  ##
                  # RPC-specific configuration for `list_jobs`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_jobs
                  ##
                  # RPC-specific configuration for `run_task`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :run_task
                  ##
                  # RPC-specific configuration for `get_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_job
                  ##
                  # RPC-specific configuration for `cancel_job`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :cancel_job
                  ##
                  # RPC-specific configuration for `create_environment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :create_environment
                  ##
                  # RPC-specific configuration for `update_environment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :update_environment
                  ##
                  # RPC-specific configuration for `delete_environment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :delete_environment
                  ##
                  # RPC-specific configuration for `list_environments`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_environments
                  ##
                  # RPC-specific configuration for `get_environment`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :get_environment
                  ##
                  # RPC-specific configuration for `list_sessions`
                  # @return [::Gapic::Config::Method]
                  #
                  attr_reader :list_sessions

                  # @private
                  def initialize parent_rpcs = nil
                    create_lake_config = parent_rpcs.create_lake if parent_rpcs.respond_to? :create_lake
                    @create_lake = ::Gapic::Config::Method.new create_lake_config
                    update_lake_config = parent_rpcs.update_lake if parent_rpcs.respond_to? :update_lake
                    @update_lake = ::Gapic::Config::Method.new update_lake_config
                    delete_lake_config = parent_rpcs.delete_lake if parent_rpcs.respond_to? :delete_lake
                    @delete_lake = ::Gapic::Config::Method.new delete_lake_config
                    list_lakes_config = parent_rpcs.list_lakes if parent_rpcs.respond_to? :list_lakes
                    @list_lakes = ::Gapic::Config::Method.new list_lakes_config
                    get_lake_config = parent_rpcs.get_lake if parent_rpcs.respond_to? :get_lake
                    @get_lake = ::Gapic::Config::Method.new get_lake_config
                    list_lake_actions_config = parent_rpcs.list_lake_actions if parent_rpcs.respond_to? :list_lake_actions
                    @list_lake_actions = ::Gapic::Config::Method.new list_lake_actions_config
                    create_zone_config = parent_rpcs.create_zone if parent_rpcs.respond_to? :create_zone
                    @create_zone = ::Gapic::Config::Method.new create_zone_config
                    update_zone_config = parent_rpcs.update_zone if parent_rpcs.respond_to? :update_zone
                    @update_zone = ::Gapic::Config::Method.new update_zone_config
                    delete_zone_config = parent_rpcs.delete_zone if parent_rpcs.respond_to? :delete_zone
                    @delete_zone = ::Gapic::Config::Method.new delete_zone_config
                    list_zones_config = parent_rpcs.list_zones if parent_rpcs.respond_to? :list_zones
                    @list_zones = ::Gapic::Config::Method.new list_zones_config
                    get_zone_config = parent_rpcs.get_zone if parent_rpcs.respond_to? :get_zone
                    @get_zone = ::Gapic::Config::Method.new get_zone_config
                    list_zone_actions_config = parent_rpcs.list_zone_actions if parent_rpcs.respond_to? :list_zone_actions
                    @list_zone_actions = ::Gapic::Config::Method.new list_zone_actions_config
                    create_asset_config = parent_rpcs.create_asset if parent_rpcs.respond_to? :create_asset
                    @create_asset = ::Gapic::Config::Method.new create_asset_config
                    update_asset_config = parent_rpcs.update_asset if parent_rpcs.respond_to? :update_asset
                    @update_asset = ::Gapic::Config::Method.new update_asset_config
                    delete_asset_config = parent_rpcs.delete_asset if parent_rpcs.respond_to? :delete_asset
                    @delete_asset = ::Gapic::Config::Method.new delete_asset_config
                    list_assets_config = parent_rpcs.list_assets if parent_rpcs.respond_to? :list_assets
                    @list_assets = ::Gapic::Config::Method.new list_assets_config
                    get_asset_config = parent_rpcs.get_asset if parent_rpcs.respond_to? :get_asset
                    @get_asset = ::Gapic::Config::Method.new get_asset_config
                    list_asset_actions_config = parent_rpcs.list_asset_actions if parent_rpcs.respond_to? :list_asset_actions
                    @list_asset_actions = ::Gapic::Config::Method.new list_asset_actions_config
                    create_task_config = parent_rpcs.create_task if parent_rpcs.respond_to? :create_task
                    @create_task = ::Gapic::Config::Method.new create_task_config
                    update_task_config = parent_rpcs.update_task if parent_rpcs.respond_to? :update_task
                    @update_task = ::Gapic::Config::Method.new update_task_config
                    delete_task_config = parent_rpcs.delete_task if parent_rpcs.respond_to? :delete_task
                    @delete_task = ::Gapic::Config::Method.new delete_task_config
                    list_tasks_config = parent_rpcs.list_tasks if parent_rpcs.respond_to? :list_tasks
                    @list_tasks = ::Gapic::Config::Method.new list_tasks_config
                    get_task_config = parent_rpcs.get_task if parent_rpcs.respond_to? :get_task
                    @get_task = ::Gapic::Config::Method.new get_task_config
                    list_jobs_config = parent_rpcs.list_jobs if parent_rpcs.respond_to? :list_jobs
                    @list_jobs = ::Gapic::Config::Method.new list_jobs_config
                    run_task_config = parent_rpcs.run_task if parent_rpcs.respond_to? :run_task
                    @run_task = ::Gapic::Config::Method.new run_task_config
                    get_job_config = parent_rpcs.get_job if parent_rpcs.respond_to? :get_job
                    @get_job = ::Gapic::Config::Method.new get_job_config
                    cancel_job_config = parent_rpcs.cancel_job if parent_rpcs.respond_to? :cancel_job
                    @cancel_job = ::Gapic::Config::Method.new cancel_job_config
                    create_environment_config = parent_rpcs.create_environment if parent_rpcs.respond_to? :create_environment
                    @create_environment = ::Gapic::Config::Method.new create_environment_config
                    update_environment_config = parent_rpcs.update_environment if parent_rpcs.respond_to? :update_environment
                    @update_environment = ::Gapic::Config::Method.new update_environment_config
                    delete_environment_config = parent_rpcs.delete_environment if parent_rpcs.respond_to? :delete_environment
                    @delete_environment = ::Gapic::Config::Method.new delete_environment_config
                    list_environments_config = parent_rpcs.list_environments if parent_rpcs.respond_to? :list_environments
                    @list_environments = ::Gapic::Config::Method.new list_environments_config
                    get_environment_config = parent_rpcs.get_environment if parent_rpcs.respond_to? :get_environment
                    @get_environment = ::Gapic::Config::Method.new get_environment_config
                    list_sessions_config = parent_rpcs.list_sessions if parent_rpcs.respond_to? :list_sessions
                    @list_sessions = ::Gapic::Config::Method.new list_sessions_config

                    yield self if block_given?
                  end
                end
              end
            end
          end
        end
      end
    end
  end
end
